-- Adminer 4.8.4 MySQL 8.2.0 dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

SET NAMES utf8mb4;

DROP TABLE IF EXISTS `batch`;
CREATE TABLE `batch` (
  `bid` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique batch ID.',
  `token` varchar(64) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'A string token generated against the current user''s session id and the batch id, used to ensure that only the user who submitted the batch can effectively access it.',
  `timestamp` int NOT NULL COMMENT 'A Unix timestamp indicating when this batch was submitted for processing. Stale batches are purged at cron time.',
  `batch` longblob COMMENT 'A serialized array containing the processing data for the batch.',
  PRIMARY KEY (`bid`),
  KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Stores details about batches (processes that run in…';


DROP TABLE IF EXISTS `block_content`;
CREATE TABLE `block_content` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `revision_id` int unsigned DEFAULT NULL,
  `type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the target entity.',
  `uuid` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `block_content_field__uuid__value` (`uuid`),
  UNIQUE KEY `block_content__revision_id` (`revision_id`),
  KEY `block_content_field__type__target_id` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='The base table for block_content entities.';


DROP TABLE IF EXISTS `block_content__body`;
CREATE TABLE `block_content__body` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext NOT NULL,
  `body_summary` longtext,
  `body_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field body.';


DROP TABLE IF EXISTS `block_content__field_ebt_accordion`;
CREATE TABLE `block_content__field_ebt_accordion` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_accordion_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_accordion_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_accordion_target_id` (`field_ebt_accordion_target_id`),
  KEY `field_ebt_accordion_target_revision_id` (`field_ebt_accordion_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_accordion.';


DROP TABLE IF EXISTS `block_content__field_ebt_basic_button_link`;
CREATE TABLE `block_content__field_ebt_basic_button_link` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_basic_button_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_ebt_basic_button_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_ebt_basic_button_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_basic_button_link_uri` (`field_ebt_basic_button_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_basic_button…';


DROP TABLE IF EXISTS `block_content__field_ebt_block_block`;
CREATE TABLE `block_content__field_ebt_block_block` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_block_block_plugin_id` varchar(255) NOT NULL COMMENT 'The block plugin id',
  `field_ebt_block_block_settings` longblob COMMENT 'Serialized array of settings for the block.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_block_block_plugin_id` (`field_ebt_block_block_plugin_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_block_block.';


DROP TABLE IF EXISTS `block_content__field_ebt_bootstrap_button_link`;
CREATE TABLE `block_content__field_ebt_bootstrap_button_link` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_bootstrap_button_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_ebt_bootstrap_button_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_ebt_bootstrap_button_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_bootstrap_button_link_uri` (`field_ebt_bootstrap_button_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_bootstrap…';


DROP TABLE IF EXISTS `block_content__field_ebt_carousel`;
CREATE TABLE `block_content__field_ebt_carousel` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_carousel_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_carousel_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_carousel_target_id` (`field_ebt_carousel_target_id`),
  KEY `field_ebt_carousel_target_revision_id` (`field_ebt_carousel_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_carousel.';


DROP TABLE IF EXISTS `block_content__field_ebt_columns_blocks`;
CREATE TABLE `block_content__field_ebt_columns_blocks` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_columns_blocks_plugin_id` varchar(255) NOT NULL COMMENT 'The block plugin id',
  `field_ebt_columns_blocks_settings` longblob COMMENT 'Serialized array of settings for the block.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_columns_blocks_plugin_id` (`field_ebt_columns_blocks_plugin_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_columns…';


DROP TABLE IF EXISTS `block_content__field_ebt_countdown_date`;
CREATE TABLE `block_content__field_ebt_countdown_date` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_countdown_date_value` varchar(20) NOT NULL COMMENT 'The date value.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_countdown_date_value` (`field_ebt_countdown_date_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_countdown…';


DROP TABLE IF EXISTS `block_content__field_ebt_counter_icon`;
CREATE TABLE `block_content__field_ebt_counter_icon` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_counter_icon_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_counter_icon_target_id` (`field_ebt_counter_icon_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_counter_icon.';


DROP TABLE IF EXISTS `block_content__field_ebt_counter_items`;
CREATE TABLE `block_content__field_ebt_counter_items` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_counter_items_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_counter_items_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_counter_items_target_id` (`field_ebt_counter_items_target_id`),
  KEY `field_ebt_counter_items_target_revision_id` (`field_ebt_counter_items_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_counter…';


DROP TABLE IF EXISTS `block_content__field_ebt_counter_number`;
CREATE TABLE `block_content__field_ebt_counter_number` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_counter_number_value` int NOT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_counter…';


DROP TABLE IF EXISTS `block_content__field_ebt_cta_column_image`;
CREATE TABLE `block_content__field_ebt_cta_column_image` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_cta_column_image_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_cta_column_image_target_id` (`field_ebt_cta_column_image_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_cta_column…';


DROP TABLE IF EXISTS `block_content__field_ebt_cta_link`;
CREATE TABLE `block_content__field_ebt_cta_link` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_cta_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_ebt_cta_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_ebt_cta_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_cta_link_uri` (`field_ebt_cta_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_cta_link.';


DROP TABLE IF EXISTS `block_content__field_ebt_cta_second_link`;
CREATE TABLE `block_content__field_ebt_cta_second_link` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_cta_second_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_ebt_cta_second_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_ebt_cta_second_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_cta_second_link_uri` (`field_ebt_cta_second_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_cta_second…';


DROP TABLE IF EXISTS `block_content__field_ebt_cta_title`;
CREATE TABLE `block_content__field_ebt_cta_title` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_cta_title_value` longtext NOT NULL,
  `field_ebt_cta_title_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_cta_title_format` (`field_ebt_cta_title_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_cta_title.';


DROP TABLE IF EXISTS `block_content__field_ebt_hero_column_image`;
CREATE TABLE `block_content__field_ebt_hero_column_image` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_hero_column_image_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_hero_column_image_target_id` (`field_ebt_hero_column_image_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_hero_column…';


DROP TABLE IF EXISTS `block_content__field_ebt_hero_link`;
CREATE TABLE `block_content__field_ebt_hero_link` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_hero_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_ebt_hero_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_ebt_hero_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_hero_link_uri` (`field_ebt_hero_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_hero_link.';


DROP TABLE IF EXISTS `block_content__field_ebt_hero_second_link`;
CREATE TABLE `block_content__field_ebt_hero_second_link` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_hero_second_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_ebt_hero_second_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_ebt_hero_second_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_hero_second_link_uri` (`field_ebt_hero_second_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_hero_second…';


DROP TABLE IF EXISTS `block_content__field_ebt_hero_title`;
CREATE TABLE `block_content__field_ebt_hero_title` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_hero_title_value` longtext NOT NULL,
  `field_ebt_hero_title_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_hero_title_format` (`field_ebt_hero_title_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_hero_title.';


DROP TABLE IF EXISTS `block_content__field_ebt_hero_title_prefix`;
CREATE TABLE `block_content__field_ebt_hero_title_prefix` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_hero_title_prefix_value` longtext NOT NULL,
  `field_ebt_hero_title_prefix_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_hero_title_prefix_format` (`field_ebt_hero_title_prefix_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_hero_title…';


DROP TABLE IF EXISTS `block_content__field_ebt_image`;
CREATE TABLE `block_content__field_ebt_image` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_image_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_image_target_id` (`field_ebt_image_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_image.';


DROP TABLE IF EXISTS `block_content__field_ebt_image_caption`;
CREATE TABLE `block_content__field_ebt_image_caption` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_image_caption_value` longtext NOT NULL,
  `field_ebt_image_caption_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_image_caption_format` (`field_ebt_image_caption_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_image…';


DROP TABLE IF EXISTS `block_content__field_ebt_image_gallery`;
CREATE TABLE `block_content__field_ebt_image_gallery` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_image_gallery_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_image_gallery_target_id` (`field_ebt_image_gallery_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_image…';


DROP TABLE IF EXISTS `block_content__field_ebt_image_link`;
CREATE TABLE `block_content__field_ebt_image_link` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_image_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_ebt_image_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_ebt_image_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_image_link_uri` (`field_ebt_image_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_image_link.';


DROP TABLE IF EXISTS `block_content__field_ebt_micromodal_title`;
CREATE TABLE `block_content__field_ebt_micromodal_title` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_micromodal_title_value` longtext NOT NULL,
  `field_ebt_micromodal_title_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_micromodal_title_format` (`field_ebt_micromodal_title_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_micromodal…';


DROP TABLE IF EXISTS `block_content__field_ebt_quote_author`;
CREATE TABLE `block_content__field_ebt_quote_author` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_quote_author_value` longtext NOT NULL,
  `field_ebt_quote_author_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_quote_author_format` (`field_ebt_quote_author_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_quote_author.';


DROP TABLE IF EXISTS `block_content__field_ebt_quote_image`;
CREATE TABLE `block_content__field_ebt_quote_image` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_quote_image_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_quote_image_target_id` (`field_ebt_quote_image_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_quote_image.';


DROP TABLE IF EXISTS `block_content__field_ebt_settings`;
CREATE TABLE `block_content__field_ebt_settings` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_settings_ebt_settings` longblob COMMENT 'Serialized block settings data',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_settings.';


DROP TABLE IF EXISTS `block_content__field_ebt_slick_slider`;
CREATE TABLE `block_content__field_ebt_slick_slider` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_slick_slider_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_slick_slider_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_slick_slider_target_id` (`field_ebt_slick_slider_target_id`),
  KEY `field_ebt_slick_slider_target_revision_id` (`field_ebt_slick_slider_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_slick_slider.';


DROP TABLE IF EXISTS `block_content__field_ebt_slideshow`;
CREATE TABLE `block_content__field_ebt_slideshow` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_slideshow_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_slideshow_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_slideshow_target_id` (`field_ebt_slideshow_target_id`),
  KEY `field_ebt_slideshow_target_revision_id` (`field_ebt_slideshow_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_slideshow.';


DROP TABLE IF EXISTS `block_content__field_ebt_stats`;
CREATE TABLE `block_content__field_ebt_stats` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_stats_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_stats_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_stats_target_id` (`field_ebt_stats_target_id`),
  KEY `field_ebt_stats_target_revision_id` (`field_ebt_stats_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_stats.';


DROP TABLE IF EXISTS `block_content__field_ebt_tabs`;
CREATE TABLE `block_content__field_ebt_tabs` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_tabs_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_tabs_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_tabs_target_id` (`field_ebt_tabs_target_id`),
  KEY `field_ebt_tabs_target_revision_id` (`field_ebt_tabs_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_tabs.';


DROP TABLE IF EXISTS `block_content__field_ebt_tiles`;
CREATE TABLE `block_content__field_ebt_tiles` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_tiles_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_tiles_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_tiles_target_id` (`field_ebt_tiles_target_id`),
  KEY `field_ebt_tiles_target_revision_id` (`field_ebt_tiles_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_tiles.';


DROP TABLE IF EXISTS `block_content__field_ebt_timeline`;
CREATE TABLE `block_content__field_ebt_timeline` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_timeline_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_timeline_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_timeline_target_id` (`field_ebt_timeline_target_id`),
  KEY `field_ebt_timeline_target_revision_id` (`field_ebt_timeline_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_timeline.';


DROP TABLE IF EXISTS `block_content__field_ebt_video`;
CREATE TABLE `block_content__field_ebt_video` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_video_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_video_target_id` (`field_ebt_video_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_video.';


DROP TABLE IF EXISTS `block_content__field_ebt_videos_and_images`;
CREATE TABLE `block_content__field_ebt_videos_and_images` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_videos_and_images_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_videos_and_images_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_videos_and_images_target_id` (`field_ebt_videos_and_images_target_id`),
  KEY `field_ebt_videos_and_images_target_revision_id` (`field_ebt_videos_and_images_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_videos_and…';


DROP TABLE IF EXISTS `block_content__field_ebt_views_views`;
CREATE TABLE `block_content__field_ebt_views_views` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_views_views_target_id` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_views_views_display_id` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL COMMENT 'The ID of the display.',
  `field_ebt_views_views_data` longtext COMMENT 'Serialized data.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_views_views_target_id` (`field_ebt_views_views_target_id`),
  KEY `field_ebt_views_views_display_id` (`field_ebt_views_views_display_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_views_views.';


DROP TABLE IF EXISTS `block_content__field_ebt_webform_form`;
CREATE TABLE `block_content__field_ebt_webform_form` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_webform_form_target_id` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the webform entity.',
  `field_ebt_webform_form_default_data` text COMMENT 'Default submission data.',
  `field_ebt_webform_form_status` varchar(20) DEFAULT NULL COMMENT 'Flag to control whether this webform should be open, closed, or scheduled for new submissions.',
  `field_ebt_webform_form_open` varchar(20) DEFAULT NULL COMMENT 'The open date/time.',
  `field_ebt_webform_form_close` varchar(20) DEFAULT NULL COMMENT 'The close date/time.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_webform_form_target_id` (`field_ebt_webform_form_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_webform_form.';


DROP TABLE IF EXISTS `block_content__field_ebt_webform_popup_form`;
CREATE TABLE `block_content__field_ebt_webform_popup_form` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_webform_popup_form_target_id` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the webform entity.',
  `field_ebt_webform_popup_form_default_data` text COMMENT 'Default submission data.',
  `field_ebt_webform_popup_form_status` varchar(20) DEFAULT NULL COMMENT 'Flag to control whether this webform should be open, closed, or scheduled for new submissions.',
  `field_ebt_webform_popup_form_open` varchar(20) DEFAULT NULL COMMENT 'The open date/time.',
  `field_ebt_webform_popup_form_close` varchar(20) DEFAULT NULL COMMENT 'The close date/time.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_webform_popup_form_target_id` (`field_ebt_webform_popup_form_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Data storage for block_content field field_ebt_webform…';


DROP TABLE IF EXISTS `block_content_field_data`;
CREATE TABLE `block_content_field_data` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL,
  `type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the target entity.',
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `status` tinyint NOT NULL,
  `info` varchar(255) DEFAULT NULL,
  `changed` int DEFAULT NULL,
  `reusable` tinyint DEFAULT NULL,
  `default_langcode` tinyint NOT NULL,
  `revision_translation_affected` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`,`langcode`),
  KEY `block_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`),
  KEY `block_content__revision_id` (`revision_id`),
  KEY `block_content_field__type__target_id` (`type`),
  KEY `block_content_field__reusable` (`reusable`),
  KEY `block_content__status_type` (`status`,`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='The data table for block_content entities.';


DROP TABLE IF EXISTS `block_content_field_revision`;
CREATE TABLE `block_content_field_revision` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `status` tinyint NOT NULL,
  `info` varchar(255) DEFAULT NULL,
  `changed` int DEFAULT NULL,
  `default_langcode` tinyint NOT NULL,
  `revision_translation_affected` tinyint DEFAULT NULL,
  PRIMARY KEY (`revision_id`,`langcode`),
  KEY `block_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='The revision data table for block_content entities.';


DROP TABLE IF EXISTS `block_content_r__1d98dd7393`;
CREATE TABLE `block_content_r__1d98dd7393` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_hero_title_prefix_value` longtext NOT NULL,
  `field_ebt_hero_title_prefix_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_hero_title_prefix_format` (`field_ebt_hero_title_prefix_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_r__2d12375ee7`;
CREATE TABLE `block_content_r__2d12375ee7` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_bootstrap_button_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_ebt_bootstrap_button_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_ebt_bootstrap_button_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_bootstrap_button_link_uri` (`field_ebt_bootstrap_button_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_r__340d64eab4`;
CREATE TABLE `block_content_r__340d64eab4` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_videos_and_images_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_videos_and_images_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_videos_and_images_target_id` (`field_ebt_videos_and_images_target_id`),
  KEY `field_ebt_videos_and_images_target_revision_id` (`field_ebt_videos_and_images_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_r__5ab1225ba6`;
CREATE TABLE `block_content_r__5ab1225ba6` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_hero_second_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_ebt_hero_second_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_ebt_hero_second_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_hero_second_link_uri` (`field_ebt_hero_second_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_r__6145a3a301`;
CREATE TABLE `block_content_r__6145a3a301` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_basic_button_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_ebt_basic_button_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_ebt_basic_button_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_basic_button_link_uri` (`field_ebt_basic_button_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_r__6a87f4fdb7`;
CREATE TABLE `block_content_r__6a87f4fdb7` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_cta_second_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_ebt_cta_second_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_ebt_cta_second_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_cta_second_link_uri` (`field_ebt_cta_second_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_r__abebd0b113`;
CREATE TABLE `block_content_r__abebd0b113` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_micromodal_title_value` longtext NOT NULL,
  `field_ebt_micromodal_title_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_micromodal_title_format` (`field_ebt_micromodal_title_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_r__b1f6f83596`;
CREATE TABLE `block_content_r__b1f6f83596` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_webform_popup_form_target_id` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the webform entity.',
  `field_ebt_webform_popup_form_default_data` text COMMENT 'Default submission data.',
  `field_ebt_webform_popup_form_status` varchar(20) DEFAULT NULL COMMENT 'Flag to control whether this webform should be open, closed, or scheduled for new submissions.',
  `field_ebt_webform_popup_form_open` varchar(20) DEFAULT NULL COMMENT 'The open date/time.',
  `field_ebt_webform_popup_form_close` varchar(20) DEFAULT NULL COMMENT 'The close date/time.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_webform_popup_form_target_id` (`field_ebt_webform_popup_form_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_r__b5f82fb056`;
CREATE TABLE `block_content_r__b5f82fb056` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_cta_column_image_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_cta_column_image_target_id` (`field_ebt_cta_column_image_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_r__c4c7d0dccb`;
CREATE TABLE `block_content_r__c4c7d0dccb` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_hero_column_image_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_hero_column_image_target_id` (`field_ebt_hero_column_image_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision`;
CREATE TABLE `block_content_revision` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL AUTO_INCREMENT,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `revision_user` int unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `revision_created` int DEFAULT NULL,
  `revision_log` longtext,
  `revision_default` tinyint DEFAULT NULL,
  PRIMARY KEY (`revision_id`),
  KEY `block_content__id` (`id`),
  KEY `block_content_field__revision_user__target_id` (`revision_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='The revision table for block_content entities.';


DROP TABLE IF EXISTS `block_content_revision__body`;
CREATE TABLE `block_content_revision__body` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext NOT NULL,
  `body_summary` longtext,
  `body_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field body.';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_accordion`;
CREATE TABLE `block_content_revision__field_ebt_accordion` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_accordion_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_accordion_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_accordion_target_id` (`field_ebt_accordion_target_id`),
  KEY `field_ebt_accordion_target_revision_id` (`field_ebt_accordion_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_block_block`;
CREATE TABLE `block_content_revision__field_ebt_block_block` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_block_block_plugin_id` varchar(255) NOT NULL COMMENT 'The block plugin id',
  `field_ebt_block_block_settings` longblob COMMENT 'Serialized array of settings for the block.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_block_block_plugin_id` (`field_ebt_block_block_plugin_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_carousel`;
CREATE TABLE `block_content_revision__field_ebt_carousel` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_carousel_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_carousel_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_carousel_target_id` (`field_ebt_carousel_target_id`),
  KEY `field_ebt_carousel_target_revision_id` (`field_ebt_carousel_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_columns_blocks`;
CREATE TABLE `block_content_revision__field_ebt_columns_blocks` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_columns_blocks_plugin_id` varchar(255) NOT NULL COMMENT 'The block plugin id',
  `field_ebt_columns_blocks_settings` longblob COMMENT 'Serialized array of settings for the block.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_columns_blocks_plugin_id` (`field_ebt_columns_blocks_plugin_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_countdown_date`;
CREATE TABLE `block_content_revision__field_ebt_countdown_date` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_countdown_date_value` varchar(20) NOT NULL COMMENT 'The date value.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_countdown_date_value` (`field_ebt_countdown_date_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_counter_icon`;
CREATE TABLE `block_content_revision__field_ebt_counter_icon` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_counter_icon_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_counter_icon_target_id` (`field_ebt_counter_icon_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_counter_items`;
CREATE TABLE `block_content_revision__field_ebt_counter_items` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_counter_items_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_counter_items_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_counter_items_target_id` (`field_ebt_counter_items_target_id`),
  KEY `field_ebt_counter_items_target_revision_id` (`field_ebt_counter_items_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_counter_number`;
CREATE TABLE `block_content_revision__field_ebt_counter_number` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_counter_number_value` int NOT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_cta_link`;
CREATE TABLE `block_content_revision__field_ebt_cta_link` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_cta_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_ebt_cta_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_ebt_cta_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_cta_link_uri` (`field_ebt_cta_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_cta_title`;
CREATE TABLE `block_content_revision__field_ebt_cta_title` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_cta_title_value` longtext NOT NULL,
  `field_ebt_cta_title_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_cta_title_format` (`field_ebt_cta_title_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_hero_link`;
CREATE TABLE `block_content_revision__field_ebt_hero_link` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_hero_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_ebt_hero_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_ebt_hero_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_hero_link_uri` (`field_ebt_hero_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_hero_title`;
CREATE TABLE `block_content_revision__field_ebt_hero_title` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_hero_title_value` longtext NOT NULL,
  `field_ebt_hero_title_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_hero_title_format` (`field_ebt_hero_title_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_image`;
CREATE TABLE `block_content_revision__field_ebt_image` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_image_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_image_target_id` (`field_ebt_image_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_image_caption`;
CREATE TABLE `block_content_revision__field_ebt_image_caption` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_image_caption_value` longtext NOT NULL,
  `field_ebt_image_caption_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_image_caption_format` (`field_ebt_image_caption_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_image_gallery`;
CREATE TABLE `block_content_revision__field_ebt_image_gallery` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_image_gallery_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_image_gallery_target_id` (`field_ebt_image_gallery_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_image_link`;
CREATE TABLE `block_content_revision__field_ebt_image_link` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_image_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_ebt_image_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_ebt_image_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_image_link_uri` (`field_ebt_image_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_quote_author`;
CREATE TABLE `block_content_revision__field_ebt_quote_author` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_quote_author_value` longtext NOT NULL,
  `field_ebt_quote_author_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_quote_author_format` (`field_ebt_quote_author_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_quote_image`;
CREATE TABLE `block_content_revision__field_ebt_quote_image` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_quote_image_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_quote_image_target_id` (`field_ebt_quote_image_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_settings`;
CREATE TABLE `block_content_revision__field_ebt_settings` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_settings_ebt_settings` longblob COMMENT 'Serialized block settings data',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_slick_slider`;
CREATE TABLE `block_content_revision__field_ebt_slick_slider` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_slick_slider_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_slick_slider_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_slick_slider_target_id` (`field_ebt_slick_slider_target_id`),
  KEY `field_ebt_slick_slider_target_revision_id` (`field_ebt_slick_slider_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_slideshow`;
CREATE TABLE `block_content_revision__field_ebt_slideshow` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_slideshow_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_slideshow_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_slideshow_target_id` (`field_ebt_slideshow_target_id`),
  KEY `field_ebt_slideshow_target_revision_id` (`field_ebt_slideshow_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_stats`;
CREATE TABLE `block_content_revision__field_ebt_stats` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_stats_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_stats_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_stats_target_id` (`field_ebt_stats_target_id`),
  KEY `field_ebt_stats_target_revision_id` (`field_ebt_stats_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_tabs`;
CREATE TABLE `block_content_revision__field_ebt_tabs` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_tabs_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_tabs_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_tabs_target_id` (`field_ebt_tabs_target_id`),
  KEY `field_ebt_tabs_target_revision_id` (`field_ebt_tabs_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_tiles`;
CREATE TABLE `block_content_revision__field_ebt_tiles` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_tiles_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_tiles_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_tiles_target_id` (`field_ebt_tiles_target_id`),
  KEY `field_ebt_tiles_target_revision_id` (`field_ebt_tiles_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_timeline`;
CREATE TABLE `block_content_revision__field_ebt_timeline` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_timeline_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_timeline_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_timeline_target_id` (`field_ebt_timeline_target_id`),
  KEY `field_ebt_timeline_target_revision_id` (`field_ebt_timeline_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_video`;
CREATE TABLE `block_content_revision__field_ebt_video` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_video_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_video_target_id` (`field_ebt_video_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_views_views`;
CREATE TABLE `block_content_revision__field_ebt_views_views` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_views_views_target_id` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the target entity.',
  `field_ebt_views_views_display_id` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL COMMENT 'The ID of the display.',
  `field_ebt_views_views_data` longtext COMMENT 'Serialized data.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_views_views_target_id` (`field_ebt_views_views_target_id`),
  KEY `field_ebt_views_views_display_id` (`field_ebt_views_views_display_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `block_content_revision__field_ebt_webform_form`;
CREATE TABLE `block_content_revision__field_ebt_webform_form` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_ebt_webform_form_target_id` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the webform entity.',
  `field_ebt_webform_form_default_data` text COMMENT 'Default submission data.',
  `field_ebt_webform_form_status` varchar(20) DEFAULT NULL COMMENT 'Flag to control whether this webform should be open, closed, or scheduled for new submissions.',
  `field_ebt_webform_form_open` varchar(20) DEFAULT NULL COMMENT 'The open date/time.',
  `field_ebt_webform_form_close` varchar(20) DEFAULT NULL COMMENT 'The close date/time.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_ebt_webform_form_target_id` (`field_ebt_webform_form_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Revision archive storage for block_content field field_ebt…';


DROP TABLE IF EXISTS `cache_access_policy`;
CREATE TABLE `cache_access_policy` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Storage for the cache API.';


DROP TABLE IF EXISTS `cache_bootstrap`;
CREATE TABLE `cache_bootstrap` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Storage for the cache API.';


DROP TABLE IF EXISTS `cache_config`;
CREATE TABLE `cache_config` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Storage for the cache API.';


DROP TABLE IF EXISTS `cache_container`;
CREATE TABLE `cache_container` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Storage for the cache API.';


DROP TABLE IF EXISTS `cache_data`;
CREATE TABLE `cache_data` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Storage for the cache API.';


DROP TABLE IF EXISTS `cache_default`;
CREATE TABLE `cache_default` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Storage for the cache API.';


DROP TABLE IF EXISTS `cache_discovery`;
CREATE TABLE `cache_discovery` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Storage for the cache API.';


DROP TABLE IF EXISTS `cache_dynamic_page_cache`;
CREATE TABLE `cache_dynamic_page_cache` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Storage for the cache API.';


DROP TABLE IF EXISTS `cache_entity`;
CREATE TABLE `cache_entity` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Storage for the cache API.';


DROP TABLE IF EXISTS `cache_menu`;
CREATE TABLE `cache_menu` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Storage for the cache API.';


DROP TABLE IF EXISTS `cache_page`;
CREATE TABLE `cache_page` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Storage for the cache API.';


DROP TABLE IF EXISTS `cache_render`;
CREATE TABLE `cache_render` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Storage for the cache API.';


DROP TABLE IF EXISTS `cache_toolbar`;
CREATE TABLE `cache_toolbar` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Storage for the cache API.';


DROP TABLE IF EXISTS `cachetags`;
CREATE TABLE `cachetags` (
  `tag` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'Namespace-prefixed tag string.',
  `invalidations` int NOT NULL DEFAULT '0' COMMENT 'Number incremented when the tag is invalidated.',
  PRIMARY KEY (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Cache table for tracking cache tag invalidations.';

INSERT INTO `cachetags` (`tag`, `invalidations`) VALUES
('4xx-response',	37),
('block_content_view',	26),
('breakpoints',	70),
('comment_view',	1),
('config:action_list',	5),
('config:block_content_type_list',	26),
('config:comment.settings',	1),
('config:comment.type.comment',	1),
('config:comment_type_list',	1),
('config:core.entity_form_display.comment.comment.default',	1),
('config:core.entity_form_display.node.article.default',	3),
('config:core.entity_form_display.node.page.default',	2),
('config:core.entity_view_display.comment.comment.default',	1),
('config:core.entity_view_display.node.article.default',	3),
('config:core.entity_view_display.node.article.rss',	3),
('config:core.entity_view_display.node.article.teaser',	3),
('config:core.entity_view_display.node.page.default',	3),
('config:core.entity_view_display.node.page.teaser',	2),
('config:core.entity_view_mode.comment.full',	1),
('config:core.entity_view_mode.comment.token',	1),
('config:core.extension',	70),
('config:editor.editor.webform_default',	1),
('config:editor_list',	1),
('config:entity_form_display_list',	34),
('config:entity_form_mode_list',	1),
('config:entity_view_display_list',	35),
('config:entity_view_mode_list',	8),
('config:field.field.comment.comment.comment_body',	1),
('config:field.field.media.image.field_media_image',	1),
('config:field.field.node.article.comment',	1),
('config:field.field.node.article.field_image',	1),
('config:field.field.node.page.field_metatags',	1),
('config:field.storage.comment.comment_body',	1),
('config:field.storage.media.field_media_image',	1),
('config:field.storage.node.comment',	1),
('config:field.storage.node.field_image',	1),
('config:field.storage.node.field_metatags',	1),
('config:file.settings',	3),
('config:filter_format_list',	1),
('config:image_style_list',	6),
('config:linkit_profile_list',	1),
('config:media_type_list',	1),
('config:metatag_defaults_list',	1),
('config:paragraphs_type_list',	10),
('config:system.action.comment_delete_action',	1),
('config:system.action.comment_publish_action',	1),
('config:system.action.comment_save_action',	1),
('config:system.action.comment_unpublish_action',	1),
('config:system.action.user_add_role_action.content_editor',	1),
('config:system.action.user_remove_role_action.content_editor',	1),
('config:system.file',	3),
('config:system.mail',	1),
('config:system.menu.account',	36),
('config:system.menu.admin',	36),
('config:system.menu.footer',	36),
('config:system.menu.main',	36),
('config:system.menu.tools',	36),
('config:user.role.administrator',	1),
('config:user.role.anonymous',	3),
('config:user.role.authenticated',	4),
('config:user.role.content_editor',	2),
('config:user_role_list',	4),
('config:views.view.comment',	1),
('config:views.view.comments_recent',	1),
('config:views.view.media',	1),
('config:views.view.media_library',	1),
('config:views.view.redirect',	1),
('config:views.view.webform_submissions',	1),
('config:view_list',	5),
('config:webform_list',	1),
('config:webform_options_list',	1),
('entity_bundles',	45),
('entity_field_info',	272),
('entity_types',	95),
('http_response',	35),
('local_task',	103),
('media_view',	6),
('node:1',	1),
('node_list',	2),
('node_list:page',	2),
('node_view',	8),
('paragraph_view',	10),
('rendered',	2),
('routes',	35),
('route_match',	35),
('search_index:help_search',	3),
('search_index:node_search',	1),
('token_info',	35),
('views_data',	36),
('webform_submission_list',	3);

DROP TABLE IF EXISTS `config`;
CREATE TABLE `config` (
  `collection` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'Primary Key: Config object collection.',
  `name` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'Primary Key: Config object name.',
  `data` longblob COMMENT 'A serialized configuration object data.',
  PRIMARY KEY (`collection`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='The base table for configuration data.';

INSERT INTO `config` (`collection`, `name`, `data`) VALUES
('',	'admin_toolbar.settings',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jvTSppzcgH5wnzBhX5xnAExcp2I1CzkQ_aky65XNfYI\";}s:10:\"menu_depth\";i:4;}'),
('',	'admin_toolbar_tools.settings',	'a:4:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"WgdZsrd_5w9jlmcHV4R9dD2tG9OZEkYo4I_O8h7Gq8Q\";}s:17:\"max_bundle_number\";i:20;s:25:\"hoverintent_functionality\";b:1;s:16:\"show_local_tasks\";b:0;}'),
('',	'announcements_feed.settings',	'a:4:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"0G5pZBcxbg8ONYzNLd1RJIsvuFFewm9htnS4I-ABKJ8\";}s:7:\"max_age\";i:86400;s:13:\"cron_interval\";i:21600;s:5:\"limit\";i:10;}'),
('',	'automated_cron.settings',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"fUksROt4FfkAU9BV4hV2XvhTBSS2nTNrZS4U7S-tKrs\";}s:8:\"interval\";i:10800;}'),
('',	'block.block.claro_breadcrumbs',	'a:13:{s:4:\"uuid\";s:36:\"d1a331f5-0df6-469b-9594-7d62381385aa\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"NjcxOBrPOiK5-38t56DwFBDVY4yer7YSlbRWXFuHe7A\";}s:2:\"id\";s:17:\"claro_breadcrumbs\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:10:\"breadcrumb\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_breadcrumb_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:23:\"system_breadcrumb_block\";s:5:\"label\";s:11:\"Breadcrumbs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.claro_content',	'a:13:{s:4:\"uuid\";s:36:\"40baaa9b-4ebb-41cb-a0f8-9438fc1633e2\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"a0Yyx1GeyKarZ4T_yXQBR_ZFKnXiFLtxAb6gWLd8nr0\";}s:2:\"id\";s:13:\"claro_content\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"system_main_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:17:\"system_main_block\";s:5:\"label\";s:17:\"Main page content\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.claro_help',	'a:13:{s:4:\"uuid\";s:36:\"e609269b-1f74-4c6d-8adc-b242386187c9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:4:\"help\";}s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jccFSSVqV0WCDb6NtML1VWAWTtDbZ-zn5YgTRMgMrIM\";}s:2:\"id\";s:10:\"claro_help\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:4:\"help\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:10:\"help_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:10:\"help_block\";s:5:\"label\";s:4:\"Help\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"help\";}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.claro_help_search',	'a:13:{s:4:\"uuid\";s:36:\"642a14ba-b7f3-4788-b6d7-7ec847635558\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"module\";a:2:{i:0;s:6:\"search\";i:1;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}s:8:\"enforced\";a:1:{s:6:\"config\";a:1:{i:0;s:23:\"search.page.help_search\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2ToeZLvlHKTeFY74gpgu1PejLoFyCECLO_gw6rAZwqw\";}s:2:\"id\";s:17:\"claro_help_search\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:4:\"help\";s:6:\"weight\";i:-4;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"search_form_block\";s:8:\"settings\";a:5:{s:2:\"id\";s:17:\"search_form_block\";s:5:\"label\";s:11:\"Search help\";s:13:\"label_display\";s:7:\"visible\";s:8:\"provider\";s:6:\"search\";s:7:\"page_id\";s:11:\"help_search\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:4:{s:2:\"id\";s:12:\"request_path\";s:6:\"negate\";b:0;s:15:\"context_mapping\";a:0:{}s:5:\"pages\";s:11:\"/admin/help\";}}}'),
('',	'block.block.claro_local_actions',	'a:13:{s:4:\"uuid\";s:36:\"b9fe9f3b-f277-4a5a-a681-c952b93cbf81\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"CdXfDmRgAvms7EQovxxWPdYi0GitxeRbVtScYK16ZH0\";}s:2:\"id\";s:19:\"claro_local_actions\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-10;s:8:\"provider\";N;s:6:\"plugin\";s:19:\"local_actions_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:19:\"local_actions_block\";s:5:\"label\";s:21:\"Primary admin actions\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.claro_messages',	'a:13:{s:4:\"uuid\";s:36:\"58d2b9f3-0bea-4a38-88ec-fdb62db9ccb4\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"-Ac3ISpIT0PQ-whzD7_dw0SdKi6dAbRFNWdSjOiVDqg\";}s:2:\"id\";s:14:\"claro_messages\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:11:\"highlighted\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_messages_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:21:\"system_messages_block\";s:5:\"label\";s:15:\"Status messages\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.claro_page_title',	'a:13:{s:4:\"uuid\";s:36:\"ecc6ef43-9d4c-491e-a458-7b4ac180124d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"fNwDdW063tk_ktzSWzZVeQS9wzvLooVO280BQ9WrsIs\";}s:2:\"id\";s:16:\"claro_page_title\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:-30;s:8:\"provider\";N;s:6:\"plugin\";s:16:\"page_title_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:16:\"page_title_block\";s:5:\"label\";s:10:\"Page title\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.claro_primary_local_tasks',	'a:13:{s:4:\"uuid\";s:36:\"d47ee844-8c65-44d3-85c0-510835e982ac\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ACjBZI5shAMiiUpsz-inLYVXDqNNXRnSzAWV3kV_8Hw\";}s:2:\"id\";s:25:\"claro_primary_local_tasks\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:12:\"Primary tabs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";s:7:\"primary\";b:1;s:9:\"secondary\";b:0;}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.claro_secondary_local_tasks',	'a:13:{s:4:\"uuid\";s:36:\"f080d7bf-33c8-49e4-a29b-4f78db0f7c2c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2L0geP-ixCbCkEpW6BVF6H7vDUZN4ea07_Y9CociQm4\";}s:2:\"id\";s:27:\"claro_secondary_local_tasks\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:11:\"pre_content\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:14:\"Secondary tabs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";s:7:\"primary\";b:0;s:9:\"secondary\";b:1;}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.olivero_account_menu',	'a:13:{s:4:\"uuid\";s:36:\"217ad55d-fd7d-4ae4-8bda-6030889a03b9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:19:\"system.menu.account\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"gmxYWWHmgbe0Pnv8y48ZLSLH5mEHejOjAP6RLxUfdzU\";}s:2:\"id\";s:20:\"olivero_account_menu\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:14:\"secondary_menu\";s:6:\"weight\";i:-4;s:8:\"provider\";N;s:6:\"plugin\";s:25:\"system_menu_block:account\";s:8:\"settings\";a:7:{s:2:\"id\";s:25:\"system_menu_block:account\";s:5:\"label\";s:17:\"User account menu\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";s:5:\"level\";i:1;s:5:\"depth\";i:1;s:16:\"expand_all_items\";b:0;}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.olivero_breadcrumbs',	'a:13:{s:4:\"uuid\";s:36:\"064ecc20-9718-4137-8404-bb79862b5dbe\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"VhBzWb7lMRtIOg9G7VSw_0uopi-7zXeHq4vXqqV1HFE\";}s:2:\"id\";s:19:\"olivero_breadcrumbs\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:10:\"breadcrumb\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_breadcrumb_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:23:\"system_breadcrumb_block\";s:5:\"label\";s:11:\"Breadcrumbs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.olivero_content',	'a:13:{s:4:\"uuid\";s:36:\"b76437ff-efaf-4c97-84ca-ae001d11fa96\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"erQSEZF2XUjNmgTl0uNRBzmg18ZGXwUcw2FhApoeuHk\";}s:2:\"id\";s:15:\"olivero_content\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"system_main_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:17:\"system_main_block\";s:5:\"label\";s:17:\"Main page content\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.olivero_help',	'a:13:{s:4:\"uuid\";s:36:\"53d20db2-085f-49cb-b889-bfcda4fdc4f1\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:4:\"help\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"VfPFqqxfkomud5CO8DUijw85QIl9GIxh_nIxLOYESxg\";}s:2:\"id\";s:12:\"olivero_help\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:13:\"content_above\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:10:\"help_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:10:\"help_block\";s:5:\"label\";s:4:\"Help\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"help\";}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.olivero_main_menu',	'a:13:{s:4:\"uuid\";s:36:\"0cd82e10-9f40-455e-9bc5-67bba0594412\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:16:\"system.menu.main\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KWAiziL39uEzmOJEql_wbUP2RtqGceL3WM2CfxhMelE\";}s:2:\"id\";s:17:\"olivero_main_menu\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:12:\"primary_menu\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:22:\"system_menu_block:main\";s:8:\"settings\";a:7:{s:2:\"id\";s:22:\"system_menu_block:main\";s:5:\"label\";s:15:\"Main navigation\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";s:5:\"level\";i:1;s:5:\"depth\";i:2;s:16:\"expand_all_items\";b:1;}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.olivero_messages',	'a:13:{s:4:\"uuid\";s:36:\"f259c98a-a416-406b-8df1-73b20ade139d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"BZ5tpW7H8X4PVGRm3MImTIHd2tN0eF7zOtp4SpRYUA0\";}s:2:\"id\";s:16:\"olivero_messages\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:11:\"highlighted\";s:6:\"weight\";i:-5;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_messages_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:21:\"system_messages_block\";s:5:\"label\";s:15:\"Status messages\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.olivero_page_title',	'a:13:{s:4:\"uuid\";s:36:\"592b2a14-a8fb-40ab-af13-fad4757b447c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6aOgWsNTXjqrDm98TXSAjP6qd2nCijD1xw45MrnbK-Y\";}s:2:\"id\";s:18:\"olivero_page_title\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:13:\"content_above\";s:6:\"weight\";i:-5;s:8:\"provider\";N;s:6:\"plugin\";s:16:\"page_title_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:16:\"page_title_block\";s:5:\"label\";s:10:\"Page title\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.olivero_powered',	'a:13:{s:4:\"uuid\";s:36:\"3aa71fac-64b6-42f2-8b3d-0feb4a6f805e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eYL19CLDyinGTWYQfBD1DswWzglEotE_kHnHx3AxTXM\";}s:2:\"id\";s:15:\"olivero_powered\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:13:\"footer_bottom\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_powered_by_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:23:\"system_powered_by_block\";s:5:\"label\";s:17:\"Powered by Drupal\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.olivero_primary_admin_actions',	'a:13:{s:4:\"uuid\";s:36:\"f3ae5ab3-e08f-4d92-8238-c0346ead125d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Q9_2whdOj1YIomfvsIfopROW4FT_X5pY0DjdOiOaQ5U\";}s:2:\"id\";s:29:\"olivero_primary_admin_actions\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:11:\"highlighted\";s:6:\"weight\";i:-5;s:8:\"provider\";N;s:6:\"plugin\";s:19:\"local_actions_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:19:\"local_actions_block\";s:5:\"label\";s:21:\"Primary admin actions\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.olivero_primary_local_tasks',	'a:13:{s:4:\"uuid\";s:36:\"869275af-a038-43a0-aec0-55d644632865\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nGE3EoPQQaQCuqTUtZgw0-KIzmrqdKDzdNQf2JyPUt4\";}s:2:\"id\";s:27:\"olivero_primary_local_tasks\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:11:\"highlighted\";s:6:\"weight\";i:-4;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:12:\"Primary tabs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";s:7:\"primary\";b:1;s:9:\"secondary\";b:0;}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.olivero_search_form_narrow',	'a:13:{s:4:\"uuid\";s:36:\"1895f221-afd5-4f39-946d-175efff616ba\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"search\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"yEBET0cqDbk8dkWzaJw-8CKft0961VBflsISoSR6Lj8\";}s:2:\"id\";s:26:\"olivero_search_form_narrow\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:12:\"primary_menu\";s:6:\"weight\";i:-4;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"search_form_block\";s:8:\"settings\";a:5:{s:2:\"id\";s:17:\"search_form_block\";s:5:\"label\";s:20:\"Search form (narrow)\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"search\";s:7:\"page_id\";s:0:\"\";}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.olivero_search_form_wide',	'a:13:{s:4:\"uuid\";s:36:\"10f91465-91e8-4b68-9b23-c26342c32145\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"search\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"imMyHD6LYci0gtXq56qr9ZKGHzbEG9uFydrN5EhKtSU\";}s:2:\"id\";s:24:\"olivero_search_form_wide\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:14:\"secondary_menu\";s:6:\"weight\";i:-5;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"search_form_block\";s:8:\"settings\";a:5:{s:2:\"id\";s:17:\"search_form_block\";s:5:\"label\";s:18:\"Search form (wide)\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"search\";s:7:\"page_id\";s:0:\"\";}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.olivero_secondary_local_tasks',	'a:13:{s:4:\"uuid\";s:36:\"a425651d-4bbc-4735-b403-60eedd891c6d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ydSxdq7R66I8UMC460rOzlfzvlUL4VRbdwc6z9DWaUI\";}s:2:\"id\";s:29:\"olivero_secondary_local_tasks\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:11:\"highlighted\";s:6:\"weight\";i:-2;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:14:\"Secondary tabs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";s:7:\"primary\";b:0;s:9:\"secondary\";b:1;}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.olivero_site_branding',	'a:13:{s:4:\"uuid\";s:36:\"9826d68e-9bcc-4b43-9656-f3d5f0c60619\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"n_nlgjggHVfQt2H__zvLOKB2YtjPDbQ5tHijF9LE1aM\";}s:2:\"id\";s:21:\"olivero_site_branding\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_branding_block\";s:8:\"settings\";a:7:{s:2:\"id\";s:21:\"system_branding_block\";s:5:\"label\";s:13:\"Site branding\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";s:13:\"use_site_logo\";b:1;s:13:\"use_site_name\";b:1;s:15:\"use_site_slogan\";b:0;}s:10:\"visibility\";a:0:{}}'),
('',	'block.block.olivero_syndicate',	'a:13:{s:4:\"uuid\";s:36:\"d4871bcb-88ea-4b21-8c89-7e1c3151ed0b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"0gq3VPg-_UM69FCCWurLFIrrnIjC2HLKhwo9iQNtcUo\";}s:2:\"id\";s:17:\"olivero_syndicate\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:6:\"social\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:20:\"node_syndicate_block\";s:8:\"settings\";a:5:{s:2:\"id\";s:20:\"node_syndicate_block\";s:5:\"label\";s:8:\"RSS feed\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"node\";s:11:\"block_count\";i:10;}s:10:\"visibility\";a:0:{}}'),
('',	'block_content.type.basic',	'a:9:{s:4:\"uuid\";s:36:\"8d0c7ff5-11fa-497e-b1cb-232bad118b10\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"pQP5iQy4SdhAMVcjDUncCfkJmTofnHVtXrsMzx4k6Yk\";}s:2:\"id\";s:5:\"basic\";s:5:\"label\";s:11:\"Basic block\";s:8:\"revision\";b:0;s:11:\"description\";s:42:\"A basic block contains a title and a body.\";}'),
('',	'block_content.type.ebt_accordion',	'a:9:{s:4:\"uuid\";s:36:\"532936a4-d4ec-4684-97d3-ea06263ffdfe\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"dB47Zxr808aSXzelLxShTOImxLGvz9ibkaPpIHw2XL8\";}s:2:\"id\";s:13:\"ebt_accordion\";s:5:\"label\";s:17:\"EBT Accordion/FAQ\";s:8:\"revision\";i:1;s:11:\"description\";s:37:\"Extra Block Type (EBT): Accordion/FAQ\";}'),
('',	'block_content.type.ebt_basic_button',	'a:9:{s:4:\"uuid\";s:36:\"5f0bd962-43f3-4e4c-9dad-bd8ad9ad83bc\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eTgR86D-XlSSjL0DOkUgyDx9iqTLZCeiiE1Wz1CNl8o\";}s:2:\"id\";s:16:\"ebt_basic_button\";s:5:\"label\";s:16:\"EBT Basic Button\";s:8:\"revision\";i:0;s:11:\"description\";s:36:\"Extra Block Type (EBT): Basic Button\";}'),
('',	'block_content.type.ebt_block',	'a:9:{s:4:\"uuid\";s:36:\"a5b41dbb-434a-4f8f-aa0f-413c4cc768db\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nKr_tXmEQ2IE6yATLpR_w5SQeEqQCm6SSKpCMIx2hKo\";}s:2:\"id\";s:9:\"ebt_block\";s:5:\"label\";s:9:\"EBT Block\";s:8:\"revision\";i:0;s:11:\"description\";s:33:\"Extra Block Type (EBT): EBT Block\";}'),
('',	'block_content.type.ebt_bootstrap_button',	'a:9:{s:4:\"uuid\";s:36:\"9575961f-7777-487f-988c-3898cad5f5b9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"EPwbWyfVd_vUMqmDcQcJd9ww6p2h7kUQTny9S5dPxXQ\";}s:2:\"id\";s:20:\"ebt_bootstrap_button\";s:5:\"label\";s:20:\"EBT Bootstrap Button\";s:8:\"revision\";i:0;s:11:\"description\";s:40:\"Extra Block Type (EBT): Bootstrap Button\";}'),
('',	'block_content.type.ebt_carousel',	'a:9:{s:4:\"uuid\";s:36:\"a8e8c97d-abf8-4a95-a638-a6a54e403d91\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"DXQisXm71ScIY9qHGkk7imRMnjI_dBDSZfzT-uFCzwQ\";}s:2:\"id\";s:12:\"ebt_carousel\";s:5:\"label\";s:12:\"EBT Carousel\";s:8:\"revision\";i:1;s:11:\"description\";s:32:\"Extra Block Type (EBT): Carousel\";}'),
('',	'block_content.type.ebt_columns',	'a:9:{s:4:\"uuid\";s:36:\"31aff369-3823-4bb0-93db-1bca2acd3aa3\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"CQSPoVI2zOeWs7Xgd9ALoKdgcYScRjwZQK17EBkHKX4\";}s:2:\"id\";s:11:\"ebt_columns\";s:5:\"label\";s:23:\"EBT Columns / Container\";s:8:\"revision\";i:0;s:11:\"description\";s:47:\"Extra Block Type (EBT): EBT Columns / Container\";}'),
('',	'block_content.type.ebt_countdown',	'a:9:{s:4:\"uuid\";s:36:\"17c62d51-6c7f-493f-85b4-fce54035fcf7\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"b04bwlmhn4qM9mk46Hq1ekInijGgB9DI7WydX2K6RJg\";}s:2:\"id\";s:13:\"ebt_countdown\";s:5:\"label\";s:13:\"EBT Countdown\";s:8:\"revision\";i:0;s:11:\"description\";s:37:\"Extra Block Type (EBT): EBT Countdown\";}'),
('',	'block_content.type.ebt_counter',	'a:9:{s:4:\"uuid\";s:36:\"f84bf2c7-0d7f-45e5-9e44-618e1cb84f84\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"BAdc_syLOJWN_IuQiwJb7kdzLXXokTLaEplzy8ajUBs\";}s:2:\"id\";s:11:\"ebt_counter\";s:5:\"label\";s:11:\"EBT Counter\";s:8:\"revision\";i:0;s:11:\"description\";s:100:\"Extra Block Type (EBT): Counter - Adds Counter with coffee cups, projects, case studies number, etc.\";}'),
('',	'block_content.type.ebt_cta',	'a:9:{s:4:\"uuid\";s:36:\"1a560148-0ddc-4fe6-a137-e201e64082d5\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"k9yRFHPv-0cHC5GXpNilObPbaFf1SBRHn-asOPpDpPA\";}s:2:\"id\";s:7:\"ebt_cta\";s:5:\"label\";s:24:\"EBT Call to Action (CTA)\";s:8:\"revision\";i:1;s:11:\"description\";s:44:\"Extra Block Type (EBT): Call to Action (CTA)\";}'),
('',	'block_content.type.ebt_hero',	'a:9:{s:4:\"uuid\";s:36:\"19fbd216-4f28-4209-a30c-bddd372736ae\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"UndgTjioHDq7754rxxFxg1qIXgj6xzvZ2292BZOTduY\";}s:2:\"id\";s:8:\"ebt_hero\";s:5:\"label\";s:8:\"EBT Hero\";s:8:\"revision\";i:1;s:11:\"description\";s:28:\"Extra Block Type (EBT): Hero\";}'),
('',	'block_content.type.ebt_image',	'a:9:{s:4:\"uuid\";s:36:\"9fd85032-8853-4ccb-8f84-451d84cc570c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"XzIeU-QRNHX9yTHUrG3pAtW39sABFIN32xzM5Roe_Zs\";}s:2:\"id\";s:9:\"ebt_image\";s:5:\"label\";s:9:\"EBT Image\";s:8:\"revision\";i:0;s:11:\"description\";s:29:\"Extra Block Type (EBT): Image\";}'),
('',	'block_content.type.ebt_image_gallery',	'a:9:{s:4:\"uuid\";s:36:\"61358808-828f-49a0-a1fc-850ba4856b25\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"hyvESyE2V701OB-pYMNV1fcs9afHHvGMwmKvID2dSys\";}s:2:\"id\";s:17:\"ebt_image_gallery\";s:5:\"label\";s:17:\"EBT Image Gallery\";s:8:\"revision\";i:0;s:11:\"description\";s:37:\"Extra Block Type (EBT): Image Gallery\";}'),
('',	'block_content.type.ebt_micromodal',	'a:9:{s:4:\"uuid\";s:36:\"49a7d1d2-299c-43f7-8353-442f7c80126a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"yHkIKUcC5OaWnPM6t0NLrROJ_Qie3lZd1nYZCnncyxQ\";}s:2:\"id\";s:14:\"ebt_micromodal\";s:5:\"label\";s:14:\"EBT Micromodal\";s:8:\"revision\";i:0;s:11:\"description\";s:34:\"Extra Block Type (EBT): Micromodal\";}'),
('',	'block_content.type.ebt_quote',	'a:9:{s:4:\"uuid\";s:36:\"6c094884-55e1-4ce3-9782-8302e193358e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"R3qZ2pP9HUZZOVzX7J5oHroNb9W2pfSWulgYrgRbm4g\";}s:2:\"id\";s:9:\"ebt_quote\";s:5:\"label\";s:9:\"EBT Quote\";s:8:\"revision\";i:0;s:11:\"description\";s:29:\"Extra Block Type (EBT): Quote\";}'),
('',	'block_content.type.ebt_slick_slider',	'a:9:{s:4:\"uuid\";s:36:\"fe1604e8-b328-4b89-bd85-fc64bd553f33\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"dHxKwXfScnz1cdiQPDzE2uUuw62lhpTtSqV5b2YZbrE\";}s:2:\"id\";s:16:\"ebt_slick_slider\";s:5:\"label\";s:16:\"EBT Slick Slider\";s:8:\"revision\";i:0;s:11:\"description\";s:36:\"Extra Block Type (EBT): Slick Slider\";}'),
('',	'block_content.type.ebt_slideshow',	'a:9:{s:4:\"uuid\";s:36:\"7d164bb3-5e33-440f-b644-b566e1827e32\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"W-lXlcGHuv4qnJqSIhwhzbs7aE2_VKhpa9-wZzfr-1A\";}s:2:\"id\";s:13:\"ebt_slideshow\";s:5:\"label\";s:13:\"EBT Slideshow\";s:8:\"revision\";i:0;s:11:\"description\";s:33:\"Extra Block Type (EBT): Slideshow\";}'),
('',	'block_content.type.ebt_stats',	'a:9:{s:4:\"uuid\";s:36:\"3e06d945-9c14-4d86-add4-87ce46604987\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"MYrjSAxOpL7yIgF7efseTPdxreHwdIytokEU8AsyKOc\";}s:2:\"id\";s:9:\"ebt_stats\";s:5:\"label\";s:9:\"EBT Stats\";s:8:\"revision\";i:0;s:11:\"description\";s:29:\"Extra Block Type (EBT): Stats\";}'),
('',	'block_content.type.ebt_tabs',	'a:9:{s:4:\"uuid\";s:36:\"a548c9cd-2123-460d-ac7a-3776cbd6628d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2Zf0IzYoN8bXlbuz0O0K2EFPtAJ-8Zgijs9KDbMjPbU\";}s:2:\"id\";s:8:\"ebt_tabs\";s:5:\"label\";s:8:\"EBT Tabs\";s:8:\"revision\";i:1;s:11:\"description\";s:28:\"Extra Block Type (EBT): Tabs\";}'),
('',	'block_content.type.ebt_text',	'a:9:{s:4:\"uuid\";s:36:\"4d70b021-1215-4212-93ff-3a65cfe166f4\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"EfDKjvl4An381lwiUletrxyYGHVSXr0ylsIz7wG4FkM\";}s:2:\"id\";s:8:\"ebt_text\";s:5:\"label\";s:8:\"EBT Text\";s:8:\"revision\";i:1;s:11:\"description\";s:40:\"Adds Text block type with WYSIWYG editor\";}'),
('',	'block_content.type.ebt_tiles',	'a:9:{s:4:\"uuid\";s:36:\"a4695763-bb05-45b7-877a-2988bc9c0c68\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7NM6NtKtRJqDl2LKF2ttqtshhXn4nV3DIIr56XEhBGw\";}s:2:\"id\";s:9:\"ebt_tiles\";s:5:\"label\";s:9:\"EBT Tiles\";s:8:\"revision\";i:0;s:11:\"description\";s:29:\"Extra Block Type (EBT): Tiles\";}'),
('',	'block_content.type.ebt_timeline',	'a:9:{s:4:\"uuid\";s:36:\"8299bf83-c3a5-401f-a1b8-bf9bb009af40\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"bjr_DHRSS1dmovJ9hu9PkQkEIHfJ9wcHbVFuexiFC7I\";}s:2:\"id\";s:12:\"ebt_timeline\";s:5:\"label\";s:12:\"EBT Timeline\";s:8:\"revision\";i:0;s:11:\"description\";s:32:\"Extra Block Type (EBT): Timeline\";}'),
('',	'block_content.type.ebt_video',	'a:9:{s:4:\"uuid\";s:36:\"f30a12fb-b405-4036-a46f-fc82d5b577e0\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Pv_CZ1UneLNgz_a4bh6MvN5tmAbmgeaL-sIZl2WyaP0\";}s:2:\"id\";s:9:\"ebt_video\";s:5:\"label\";s:9:\"EBT Video\";s:8:\"revision\";i:0;s:11:\"description\";s:29:\"Extra Block Type (EBT): Video\";}'),
('',	'block_content.type.ebt_video_and_image_gallery',	'a:9:{s:4:\"uuid\";s:36:\"c8e02878-ad67-4c1d-8022-1bcae43b1e10\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"t5QqFRQehMUNqFlizm8etvw0z1ASVYieiYTD5A-AMwM\";}s:2:\"id\";s:27:\"ebt_video_and_image_gallery\";s:5:\"label\";s:27:\"EBT Video and Image Gallery\";s:8:\"revision\";i:0;s:11:\"description\";s:47:\"Extra Block Type (EBT): Video and Image Gallery\";}'),
('',	'block_content.type.ebt_views',	'a:9:{s:4:\"uuid\";s:36:\"6eb11d1d-b72a-4d76-a761-9c91bacf5654\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"kKtLeF4r10QhfrqB_NLR_pg7hmb7wKFxIx53f6SPZPM\";}s:2:\"id\";s:9:\"ebt_views\";s:5:\"label\";s:9:\"EBT Views\";s:8:\"revision\";i:0;s:11:\"description\";s:29:\"Extra Block Type (EBT): Views\";}'),
('',	'block_content.type.ebt_webform',	'a:9:{s:4:\"uuid\";s:36:\"656280fa-6df7-4fb1-97e2-0fba6d8acda7\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"N2h4kIizWCZkC89K2_Xf6_WGzjG-9XpMDds_jEJjsGs\";}s:2:\"id\";s:11:\"ebt_webform\";s:5:\"label\";s:11:\"EBT Webform\";s:8:\"revision\";i:0;s:11:\"description\";s:35:\"Extra Paragraph Type (EPT): Webform\";}'),
('',	'block_content.type.ebt_webform_popup',	'a:9:{s:4:\"uuid\";s:36:\"3f1d7aa5-63b0-4cf5-8b1e-c69f240e9a70\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2PyweimMCiXZdcfL7o3WT6DPFw8x8O1FPQfufWOKf5A\";}s:2:\"id\";s:17:\"ebt_webform_popup\";s:5:\"label\";s:17:\"EBT Webform Popup\";s:8:\"revision\";i:0;s:11:\"description\";s:37:\"Extra Block Type (EBT): Webform Popup\";}'),
('',	'claro.settings',	'a:1:{s:20:\"third_party_settings\";a:1:{s:8:\"shortcut\";a:1:{s:11:\"module_link\";b:1;}}}'),
('',	'config_ignore.settings',	'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"IgOVnECx6lbVt6JVFnadoEEugneDf3UblPZnOzov43Q\";}s:4:\"mode\";s:6:\"simple\";s:23:\"ignored_config_entities\";a:0:{}}'),
('',	'contact.form.feedback',	'a:12:{s:4:\"uuid\";s:36:\"816a1630-e792-4f5c-a26b-35e17703bb04\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"vymHlgJy26BuI5GGj9-IXjwR3dRC5C0tij4BpWJnoqw\";}s:2:\"id\";s:8:\"feedback\";s:5:\"label\";s:16:\"Website feedback\";s:10:\"recipients\";a:1:{i:0;s:17:\"admin@example.com\";}s:5:\"reply\";s:0:\"\";s:6:\"weight\";i:0;s:7:\"message\";s:27:\"Your message has been sent.\";s:8:\"redirect\";s:0:\"\";}'),
('',	'contact.form.personal',	'a:12:{s:4:\"uuid\";s:36:\"6c8348fa-3a53-48ce-ac8f-7aa4d1c5c9cd\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jonvgt3CkUM2eMLTFwWfHileWWDC4YtXCuIlCahTk_I\";}s:2:\"id\";s:8:\"personal\";s:5:\"label\";s:21:\"Personal contact form\";s:10:\"recipients\";a:0:{}s:5:\"reply\";s:0:\"\";s:6:\"weight\";i:0;s:7:\"message\";s:27:\"Your message has been sent.\";s:8:\"redirect\";s:0:\"\";}'),
('',	'contact.settings',	'a:4:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"U69DBeuvXuNVOC15rVNaBjDPK2fWFbo9v4takdYSSO8\";}s:12:\"default_form\";s:8:\"feedback\";s:5:\"flood\";a:2:{s:5:\"limit\";i:5;s:8:\"interval\";i:3600;}s:20:\"user_default_enabled\";b:1;}'),
('',	'core.base_field_override.node.page.promote',	'a:17:{s:4:\"uuid\";s:36:\"708a5000-dcce-43d4-8735-a04f3c0ae480\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:14:\"node.type.page\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"fPUEnm4T5zfZRr3ttDUqq7yCDd2uW3clWD-pvos4tlQ\";}s:2:\"id\";s:17:\"node.page.promote\";s:10:\"field_name\";s:7:\"promote\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:5:\"label\";s:22:\"Promoted to front page\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:8:\"on_label\";s:2:\"On\";s:9:\"off_label\";s:3:\"Off\";}s:10:\"field_type\";s:7:\"boolean\";}'),
('',	'core.date_format.fallback',	'a:9:{s:4:\"uuid\";s:36:\"7066953f-600d-4fc2-84b8-58826b84da0a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7klS5IWXrwzVaPpYZFAs6wcx8U2FF1X73OfrtTsvuvE\";}s:2:\"id\";s:8:\"fallback\";s:5:\"label\";s:20:\"Fallback date format\";s:6:\"locked\";b:1;s:7:\"pattern\";s:14:\"D, m/d/Y - H:i\";}'),
('',	'core.date_format.html_date',	'a:9:{s:4:\"uuid\";s:36:\"c8f2ea5d-ee32-44b5-b2a4-73b29881a91d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"EOQltUQPmgc6UQ2rcJ4Xi_leCEJj5ui0TR-12duS-Tk\";}s:2:\"id\";s:9:\"html_date\";s:5:\"label\";s:9:\"HTML Date\";s:6:\"locked\";b:1;s:7:\"pattern\";s:5:\"Y-m-d\";}'),
('',	'core.date_format.html_datetime',	'a:9:{s:4:\"uuid\";s:36:\"1b677438-94c3-4570-af48-166d068688f0\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jxfClwZIRXIdcvMrE--WkcZxDGUVoOIE3Sm2NRZlFuE\";}s:2:\"id\";s:13:\"html_datetime\";s:5:\"label\";s:13:\"HTML Datetime\";s:6:\"locked\";b:1;s:7:\"pattern\";s:13:\"Y-m-d\\TH:i:sO\";}'),
('',	'core.date_format.html_month',	'a:9:{s:4:\"uuid\";s:36:\"b6631c90-a449-4cb7-93dc-33564909142a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Z7KuCUwM_WdTNvLcoltuX3_8d-s-8FZkTN6KgNwF0eM\";}s:2:\"id\";s:10:\"html_month\";s:5:\"label\";s:10:\"HTML Month\";s:6:\"locked\";b:1;s:7:\"pattern\";s:3:\"Y-m\";}'),
('',	'core.date_format.html_time',	'a:9:{s:4:\"uuid\";s:36:\"387b27db-0cbb-49c6-bce9-e2ae838a4eb4\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"M7yqicYkU36hRy5p9drAaGBBihhUD1OyujFrAaQ93ZE\";}s:2:\"id\";s:9:\"html_time\";s:5:\"label\";s:9:\"HTML Time\";s:6:\"locked\";b:1;s:7:\"pattern\";s:5:\"H:i:s\";}'),
('',	'core.date_format.html_week',	'a:9:{s:4:\"uuid\";s:36:\"aab47b59-a6c1-4205-a1bf-a0a7164b9f8d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"wKD4WsoV_wFgv2vgI4mcAAFSIzrye17ykzdwrnApkfY\";}s:2:\"id\";s:9:\"html_week\";s:5:\"label\";s:9:\"HTML Week\";s:6:\"locked\";b:1;s:7:\"pattern\";s:5:\"Y-\\WW\";}'),
('',	'core.date_format.html_year',	'a:9:{s:4:\"uuid\";s:36:\"58dd1255-3bf1-465a-af62-74c3770e7861\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"OjekiQuX9RbVQ2_8jOHBL94RgYLePqX7wpfNGgcQzrk\";}s:2:\"id\";s:9:\"html_year\";s:5:\"label\";s:9:\"HTML Year\";s:6:\"locked\";b:1;s:7:\"pattern\";s:1:\"Y\";}'),
('',	'core.date_format.html_yearless_date',	'a:9:{s:4:\"uuid\";s:36:\"1bea5c34-af20-4053-9459-595e10032d04\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"5VpawMrKPEPCkoO4YpPa0TDFO2dgiIHfTziJtwlmUxc\";}s:2:\"id\";s:18:\"html_yearless_date\";s:5:\"label\";s:18:\"HTML Yearless date\";s:6:\"locked\";b:1;s:7:\"pattern\";s:3:\"m-d\";}'),
('',	'core.date_format.long',	'a:9:{s:4:\"uuid\";s:36:\"3228fcaa-0dfe-4342-b299-d12cfba43674\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"og8sWXhBuHbLMw3CoiBEZjgqSyhFBFmcbUW_wLcfNbo\";}s:2:\"id\";s:4:\"long\";s:5:\"label\";s:17:\"Default long date\";s:6:\"locked\";b:0;s:7:\"pattern\";s:15:\"l, F j, Y - H:i\";}'),
('',	'core.date_format.medium',	'a:9:{s:4:\"uuid\";s:36:\"2ae289c3-6325-45f0-9ec2-99609e297832\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nzL5d024NjXIX_8TlT6uFAu973lmfkmHklJC-2i9rAE\";}s:2:\"id\";s:6:\"medium\";s:5:\"label\";s:19:\"Default medium date\";s:6:\"locked\";b:0;s:7:\"pattern\";s:14:\"D, m/d/Y - H:i\";}'),
('',	'core.date_format.olivero_medium',	'a:9:{s:4:\"uuid\";s:36:\"9f0d1e0f-c3b1-477d-8825-2a12a34e41f7\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:8:\"enforced\";a:1:{s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Mt6cmxUbDZ9XxD6p25WQ8tj3_JcX8ylfcddwZc8gcAE\";}s:2:\"id\";s:14:\"olivero_medium\";s:5:\"label\";s:14:\"Olivero Medium\";s:6:\"locked\";b:0;s:7:\"pattern\";s:8:\"j  F,  Y\";}'),
('',	'core.date_format.short',	'a:9:{s:4:\"uuid\";s:36:\"ced168ae-c45d-4704-b1d4-c36fb84b47f2\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"AlzeyytA8InBgxIG9H2UDJYs3CG98Zj6yRsDKmlbZwA\";}s:2:\"id\";s:5:\"short\";s:5:\"label\";s:18:\"Default short date\";s:6:\"locked\";b:0;s:7:\"pattern\";s:11:\"m/d/Y - H:i\";}'),
('',	'core.entity_form_display.block_content.basic.default',	'a:11:{s:4:\"uuid\";s:36:\"2fb7a522-cf93-4f57-be42-0cb4c4d31165\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:24:\"block_content.type.basic\";i:1;s:36:\"field.field.block_content.basic.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jAps3FCxvKecABS_tgExbhCZrBLQB3bNPWw18WjE3ss\";}s:2:\"id\";s:27:\"block_content.basic.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:5:\"basic\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:-4;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:-5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_accordion.default',	'a:12:{s:4:\"uuid\";s:36:\"7f7f76e5-ece6-4e93-9154-f7a914b883b8\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:32:\"block_content.type.ebt_accordion\";i:1;s:44:\"field.field.block_content.ebt_accordion.body\";i:2;s:59:\"field.field.block_content.ebt_accordion.field_ebt_accordion\";i:3;s:58:\"field.field.block_content.ebt_accordion.field_ebt_settings\";}s:6:\"module\";a:4:{i:0;s:13:\"ebt_accordion\";i:1;s:11:\"field_group\";i:2;s:10:\"paragraphs\";i:3;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:2;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:1:{i:0;s:19:\"field_ebt_accordion\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:20;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:21;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"PzCFAyJrF1CHyonIY9UYHLYTUaTzxXhcv5uiJWU41DQ\";}s:2:\"id\";s:35:\"block_content.ebt_accordion.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"ebt_accordion\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:-4;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:19:\"field_ebt_accordion\";a:5:{s:4:\"type\";s:27:\"entity_reference_paragraphs\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:6:{s:5:\"title\";s:9:\"Paragraph\";s:12:\"title_plural\";s:10:\"Paragraphs\";s:9:\"edit_mode\";s:4:\"open\";s:8:\"add_mode\";s:8:\"dropdown\";s:17:\"form_display_mode\";s:7:\"default\";s:22:\"default_paragraph_type\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:22:\"ebt_settings_accordion\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_basic_button.default',	'a:11:{s:4:\"uuid\";s:36:\"37393abe-e80e-4438-a211-2b6937d2a850\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:35:\"block_content.type.ebt_basic_button\";i:1;s:70:\"field.field.block_content.ebt_basic_button.field_ebt_basic_button_link\";i:2;s:61:\"field.field.block_content.ebt_basic_button.field_ebt_settings\";}s:6:\"module\";a:2:{i:0;s:16:\"ebt_basic_button\";i:1;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"TL36cBmV77cMjPzUpkHgNG3I6F4EZY_Iyr9A67xICRc\";}s:2:\"id\";s:38:\"block_content.ebt_basic_button.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:16:\"ebt_basic_button\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:27:\"field_ebt_basic_button_link\";a:5:{s:6:\"weight\";i:27;s:8:\"settings\";a:2:{s:15:\"placeholder_url\";s:0:\"\";s:17:\"placeholder_title\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:12:\"link_default\";s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:5:{s:6:\"weight\";i:28;s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:25:\"ebt_settings_basic_button\";s:6:\"region\";s:7:\"content\";}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:-5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_block.default',	'a:12:{s:4:\"uuid\";s:36:\"db7027b5-0083-4c23-932e-b8140582e848\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:28:\"block_content.type.ebt_block\";i:1;s:40:\"field.field.block_content.ebt_block.body\";i:2;s:57:\"field.field.block_content.ebt_block.field_ebt_block_block\";i:3;s:54:\"field.field.block_content.ebt_block.field_ebt_settings\";}s:6:\"module\";a:4:{i:0;s:11:\"block_field\";i:1;s:8:\"ebt_core\";i:2;s:11:\"field_group\";i:3;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:0;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:3:{i:0;s:4:\"info\";i:1;s:4:\"body\";i:2;s:21:\"field_ebt_block_block\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:20;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:4:\"open\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:21;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Kmx4yzKEAL5_us-5XrISqRaGX28ieDECPBvSA4I53eM\";}s:2:\"id\";s:31:\"block_content.ebt_block.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_block\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:21:\"field_ebt_block_block\";a:5:{s:4:\"type\";s:19:\"block_field_default\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:3:{s:9:\"plugin_id\";s:0:\"\";s:8:\"settings\";a:0:{}s:18:\"configuration_form\";s:4:\"full\";}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:20:\"ebt_settings_default\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_bootstrap_button.default',	'a:11:{s:4:\"uuid\";s:36:\"3fd59f0a-2725-4fa8-85fd-69b00e41a16c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:39:\"block_content.type.ebt_bootstrap_button\";i:1;s:78:\"field.field.block_content.ebt_bootstrap_button.field_ebt_bootstrap_button_link\";i:2;s:65:\"field.field.block_content.ebt_bootstrap_button.field_ebt_settings\";}s:6:\"module\";a:2:{i:0;s:20:\"ebt_bootstrap_button\";i:1;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"JwJzpFM95dLE-G20D_3HgaKN8MiWZGW-4JEwf0rWVeA\";}s:2:\"id\";s:42:\"block_content.ebt_bootstrap_button.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:20:\"ebt_bootstrap_button\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:31:\"field_ebt_bootstrap_button_link\";a:5:{s:6:\"weight\";i:27;s:8:\"settings\";a:2:{s:15:\"placeholder_url\";s:0:\"\";s:17:\"placeholder_title\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:12:\"link_default\";s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:5:{s:6:\"weight\";i:28;s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:29:\"ebt_settings_bootstrap_button\";s:6:\"region\";s:7:\"content\";}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:-5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_carousel.default',	'a:12:{s:4:\"uuid\";s:36:\"d9501a4e-79d4-4429-a572-1bc3f75caa0e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:31:\"block_content.type.ebt_carousel\";i:1;s:57:\"field.field.block_content.ebt_carousel.field_ebt_carousel\";i:2;s:57:\"field.field.block_content.ebt_carousel.field_ebt_settings\";}s:6:\"module\";a:3:{i:0;s:12:\"ebt_carousel\";i:1;s:11:\"field_group\";i:2;s:10:\"paragraphs\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:3;s:11:\"format_type\";s:4:\"tabs\";s:6:\"region\";s:7:\"content\";s:15:\"format_settings\";a:5:{s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;s:2:\"id\";s:0:\"\";s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;}s:5:\"label\";s:4:\"Tabs\";}s:13:\"group_content\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_carousel\";}s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:20;s:11:\"format_type\";s:3:\"tab\";s:6:\"region\";s:7:\"content\";s:15:\"format_settings\";a:6:{s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:7:\"classes\";s:0:\"\";s:11:\"description\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:15:\"required_fields\";b:1;}s:5:\"label\";s:7:\"Content\";}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:21;s:11:\"format_type\";s:3:\"tab\";s:6:\"region\";s:7:\"content\";s:15:\"format_settings\";a:6:{s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:7:\"classes\";s:0:\"\";s:11:\"description\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:15:\"required_fields\";b:1;}s:5:\"label\";s:8:\"Settings\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"QXlNXkmdvt1D3vvq3Xts_hS6xZcsvaZ_VMIpv7HSlJ4\";}s:2:\"id\";s:34:\"block_content.ebt_carousel.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:12:\"ebt_carousel\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:18:\"field_ebt_carousel\";a:5:{s:4:\"type\";s:27:\"entity_reference_paragraphs\";s:6:\"weight\";i:1;s:8:\"settings\";a:6:{s:5:\"title\";s:9:\"Paragraph\";s:12:\"title_plural\";s:10:\"Paragraphs\";s:9:\"edit_mode\";s:4:\"open\";s:8:\"add_mode\";s:8:\"dropdown\";s:17:\"form_display_mode\";s:7:\"default\";s:22:\"default_paragraph_type\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:5:{s:6:\"weight\";i:2;s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:21:\"ebt_settings_carousel\";s:6:\"region\";s:7:\"content\";}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_columns.default',	'a:12:{s:4:\"uuid\";s:36:\"913c0375-72d6-4813-b10b-3696ff0b8a73\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:30:\"block_content.type.ebt_columns\";i:1;s:42:\"field.field.block_content.ebt_columns.body\";i:2;s:62:\"field.field.block_content.ebt_columns.field_ebt_columns_blocks\";i:3;s:56:\"field.field.block_content.ebt_columns.field_ebt_settings\";}s:6:\"module\";a:4:{i:0;s:11:\"block_field\";i:1;s:11:\"ebt_columns\";i:2;s:11:\"field_group\";i:3;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:0;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:3:{i:0;s:4:\"info\";i:1;s:4:\"body\";i:2;s:24:\"field_ebt_columns_blocks\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:20;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:4:\"open\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:21;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"F_pGWF26Foj_C1Hq_KcX77H7LkKnWLFPV7iyltEH6CM\";}s:2:\"id\";s:33:\"block_content.ebt_columns.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_columns\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:24:\"field_ebt_columns_blocks\";a:5:{s:4:\"type\";s:19:\"block_field_default\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:3:{s:9:\"plugin_id\";s:0:\"\";s:8:\"settings\";a:0:{}s:18:\"configuration_form\";s:4:\"full\";}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:20:\"ebt_settings_columns\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_countdown.default',	'a:12:{s:4:\"uuid\";s:36:\"b9105cc0-df88-453b-a92d-90b5e523a386\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:32:\"block_content.type.ebt_countdown\";i:1;s:44:\"field.field.block_content.ebt_countdown.body\";i:2;s:64:\"field.field.block_content.ebt_countdown.field_ebt_countdown_date\";i:3;s:58:\"field.field.block_content.ebt_countdown.field_ebt_settings\";}s:6:\"module\";a:4:{i:0;s:8:\"datetime\";i:1;s:13:\"ebt_countdown\";i:2;s:11:\"field_group\";i:3;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:2;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:2:{i:0;s:4:\"body\";i:1;s:24:\"field_ebt_countdown_date\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:20;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:4:\"open\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:21;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"GsQnmOfbEL4H_QrRxe1J3YG8Iq7SEHUP16XkMeLPtac\";}s:2:\"id\";s:35:\"block_content.ebt_countdown.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"ebt_countdown\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:21;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:24:\"field_ebt_countdown_date\";a:5:{s:4:\"type\";s:16:\"datetime_default\";s:6:\"weight\";i:22;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:22:\"ebt_settings_countdown\";s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_counter.default',	'a:12:{s:4:\"uuid\";s:36:\"289e89e1-cc7d-4e50-8100-bb16ed9875c1\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:6:{i:0;s:30:\"block_content.type.ebt_counter\";i:1;s:42:\"field.field.block_content.ebt_counter.body\";i:2;s:60:\"field.field.block_content.ebt_counter.field_ebt_counter_icon\";i:3;s:61:\"field.field.block_content.ebt_counter.field_ebt_counter_items\";i:4;s:62:\"field.field.block_content.ebt_counter.field_ebt_counter_number\";i:5;s:56:\"field.field.block_content.ebt_counter.field_ebt_settings\";}s:6:\"module\";a:4:{i:0;s:11:\"ebt_counter\";i:1;s:11:\"field_group\";i:2;s:10:\"paragraphs\";i:3;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:5;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:2:{i:0;s:4:\"body\";i:1;s:23:\"field_ebt_counter_items\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:20;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:21;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"k07TlMoweT9Yz6bjpmLGKe6YvkshSJkTRnz6uGMQHkI\";}s:2:\"id\";s:33:\"block_content.ebt_counter.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_counter\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:23:\"field_ebt_counter_items\";a:5:{s:4:\"type\";s:10:\"paragraphs\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:10:{s:5:\"title\";s:9:\"Paragraph\";s:12:\"title_plural\";s:10:\"Paragraphs\";s:9:\"edit_mode\";s:4:\"open\";s:11:\"closed_mode\";s:7:\"summary\";s:12:\"autocollapse\";s:4:\"none\";s:21:\"closed_mode_threshold\";i:0;s:8:\"add_mode\";s:8:\"dropdown\";s:17:\"form_display_mode\";s:7:\"default\";s:22:\"default_paragraph_type\";s:0:\"\";s:8:\"features\";a:2:{s:17:\"collapse_edit_all\";s:17:\"collapse_edit_all\";s:9:\"duplicate\";s:9:\"duplicate\";}}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:20:\"ebt_settings_counter\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:2:{s:22:\"field_ebt_counter_icon\";b:1;s:24:\"field_ebt_counter_number\";b:1;}}'),
('',	'core.entity_form_display.block_content.ebt_cta.default',	'a:12:{s:4:\"uuid\";s:36:\"8a7d1838-30dd-4dc0-a2ae-b9e053ede2c9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:7:{i:0;s:26:\"block_content.type.ebt_cta\";i:1;s:38:\"field.field.block_content.ebt_cta.body\";i:2;s:60:\"field.field.block_content.ebt_cta.field_ebt_cta_column_image\";i:3;s:52:\"field.field.block_content.ebt_cta.field_ebt_cta_link\";i:4;s:59:\"field.field.block_content.ebt_cta.field_ebt_cta_second_link\";i:5;s:53:\"field.field.block_content.ebt_cta.field_ebt_cta_title\";i:6;s:52:\"field.field.block_content.ebt_cta.field_ebt_settings\";}s:6:\"module\";a:5:{i:0;s:7:\"ebt_cta\";i:1;s:11:\"field_group\";i:2;s:4:\"link\";i:3;s:13:\"media_library\";i:4;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:1;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:5:{i:0;s:19:\"field_ebt_cta_title\";i:1;s:4:\"body\";i:2;s:26:\"field_ebt_cta_column_image\";i:3;s:18:\"field_ebt_cta_link\";i:4;s:25:\"field_ebt_cta_second_link\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:20;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:4:\"open\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:21;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"vYgl9r_zBmBwCVILYRfEwPU5CbS9sLUc-A0mmAR2nq4\";}s:2:\"id\";s:29:\"block_content.ebt_cta.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:7:\"ebt_cta\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:7:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:7;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:26:\"field_ebt_cta_column_image\";a:5:{s:4:\"type\";s:20:\"media_library_widget\";s:6:\"weight\";i:8;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:11:\"media_types\";a:0:{}}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_cta_link\";a:5:{s:4:\"type\";s:12:\"link_default\";s:6:\"weight\";i:9;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:15:\"placeholder_url\";s:0:\"\";s:17:\"placeholder_title\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:25:\"field_ebt_cta_second_link\";a:5:{s:4:\"type\";s:12:\"link_default\";s:6:\"weight\";i:10;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:15:\"placeholder_url\";s:0:\"\";s:17:\"placeholder_title\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:19:\"field_ebt_cta_title\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:6;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:2;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:16:\"ebt_settings_cta\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_hero.default',	'a:12:{s:4:\"uuid\";s:36:\"d6f88c18-d8de-40c5-9c43-c1c4d94583bd\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:8:{i:0;s:27:\"block_content.type.ebt_hero\";i:1;s:39:\"field.field.block_content.ebt_hero.body\";i:2;s:62:\"field.field.block_content.ebt_hero.field_ebt_hero_column_image\";i:3;s:54:\"field.field.block_content.ebt_hero.field_ebt_hero_link\";i:4;s:61:\"field.field.block_content.ebt_hero.field_ebt_hero_second_link\";i:5;s:55:\"field.field.block_content.ebt_hero.field_ebt_hero_title\";i:6;s:62:\"field.field.block_content.ebt_hero.field_ebt_hero_title_prefix\";i:7;s:53:\"field.field.block_content.ebt_hero.field_ebt_settings\";}s:6:\"module\";a:5:{i:0;s:8:\"ebt_hero\";i:1;s:11:\"field_group\";i:2;s:4:\"link\";i:3;s:13:\"media_library\";i:4;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:1;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:6:{i:0;s:20:\"field_ebt_hero_title\";i:1;s:27:\"field_ebt_hero_title_prefix\";i:2;s:4:\"body\";i:3;s:27:\"field_ebt_hero_column_image\";i:4;s:19:\"field_ebt_hero_link\";i:5;s:26:\"field_ebt_hero_second_link\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:20;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:4:\"open\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:21;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"GQBJ-wowpRaxqn3ERit4j93oiUyIBZaIJDtySINgXhM\";}s:2:\"id\";s:30:\"block_content.ebt_hero.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_hero\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:8:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:8;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:27:\"field_ebt_hero_column_image\";a:5:{s:4:\"type\";s:20:\"media_library_widget\";s:6:\"weight\";i:9;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:11:\"media_types\";a:0:{}}s:20:\"third_party_settings\";a:0:{}}s:19:\"field_ebt_hero_link\";a:5:{s:4:\"type\";s:12:\"link_default\";s:6:\"weight\";i:10;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:15:\"placeholder_url\";s:0:\"\";s:17:\"placeholder_title\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:26:\"field_ebt_hero_second_link\";a:5:{s:4:\"type\";s:12:\"link_default\";s:6:\"weight\";i:11;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:15:\"placeholder_url\";s:0:\"\";s:17:\"placeholder_title\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:20:\"field_ebt_hero_title\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:6;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:2;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:27:\"field_ebt_hero_title_prefix\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:7;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:17:\"ebt_settings_hero\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_image.default',	'a:12:{s:4:\"uuid\";s:36:\"d00c707c-3248-4967-a6d8-4410bbfeb58f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:28:\"block_content.type.ebt_image\";i:1;s:51:\"field.field.block_content.ebt_image.field_ebt_image\";i:2;s:59:\"field.field.block_content.ebt_image.field_ebt_image_caption\";i:3;s:56:\"field.field.block_content.ebt_image.field_ebt_image_link\";i:4;s:54:\"field.field.block_content.ebt_image.field_ebt_settings\";}s:6:\"module\";a:5:{i:0;s:9:\"ebt_image\";i:1;s:11:\"field_group\";i:2;s:4:\"link\";i:3;s:13:\"media_library\";i:4;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:2;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:3:{i:0;s:15:\"field_ebt_image\";i:1;s:23:\"field_ebt_image_caption\";i:2;s:20:\"field_ebt_image_link\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:20;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:21;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"DD35mMXZ3KVmfiicbnARcLgWKRQLT1HYVk6OHxJ-iBk\";}s:2:\"id\";s:31:\"block_content.ebt_image.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_image\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:15:\"field_ebt_image\";a:5:{s:4:\"type\";s:20:\"media_library_widget\";s:6:\"weight\";i:26;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:11:\"media_types\";a:0:{}}s:20:\"third_party_settings\";a:0:{}}s:23:\"field_ebt_image_caption\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:27;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:20:\"field_ebt_image_link\";a:5:{s:4:\"type\";s:12:\"link_default\";s:6:\"weight\";i:28;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:15:\"placeholder_url\";s:0:\"\";s:17:\"placeholder_title\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:18:\"ebt_settings_image\";s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_image_gallery.default',	'a:12:{s:4:\"uuid\";s:36:\"90302297-9a10-4688-91b6-c1672cf0a17e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:36:\"block_content.type.ebt_image_gallery\";i:1;s:48:\"field.field.block_content.ebt_image_gallery.body\";i:2;s:67:\"field.field.block_content.ebt_image_gallery.field_ebt_image_gallery\";i:3;s:62:\"field.field.block_content.ebt_image_gallery.field_ebt_settings\";}s:6:\"module\";a:4:{i:0;s:17:\"ebt_image_gallery\";i:1;s:11:\"field_group\";i:2;s:13:\"media_library\";i:3;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:0;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:4:{i:0;s:4:\"info\";i:1;s:4:\"body\";i:2;s:23:\"field_ebt_image_gallery\";i:3;s:8:\"langcode\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:20;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:4:\"open\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:21;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"0PSdTVGfXs7VaqV30tsbYPvmzGKHhU4hZYgKxHIHVcU\";}s:2:\"id\";s:39:\"block_content.ebt_image_gallery.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:17:\"ebt_image_gallery\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:23:\"field_ebt_image_gallery\";a:5:{s:4:\"type\";s:20:\"media_library_widget\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:11:\"media_types\";a:0:{}}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:26:\"ebt_settings_image_gallery\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_micromodal.default',	'a:12:{s:4:\"uuid\";s:36:\"50e0e4ff-bae9-4a5d-a915-ec8cdc49ff77\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:33:\"block_content.type.ebt_micromodal\";i:1;s:45:\"field.field.block_content.ebt_micromodal.body\";i:2;s:67:\"field.field.block_content.ebt_micromodal.field_ebt_micromodal_title\";i:3;s:59:\"field.field.block_content.ebt_micromodal.field_ebt_settings\";}s:6:\"module\";a:3:{i:0;s:14:\"ebt_micromodal\";i:1;s:11:\"field_group\";i:2;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:13:\"group_content\";a:7:{s:8:\"children\";a:2:{i:0;s:26:\"field_ebt_micromodal_title\";i:1;s:4:\"body\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:2;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:1;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:3;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ZNJcRUtL7EWaVB-UgRyHYVB4-th0NpBsk6t-AcQiZc0\";}s:2:\"id\";s:36:\"block_content.ebt_micromodal.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:14:\"ebt_micromodal\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:6;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:26:\"field_ebt_micromodal_title\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:23:\"ebt_settings_micromodal\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_quote.default',	'a:12:{s:4:\"uuid\";s:36:\"3ac9c5a0-b4a9-4360-8947-feabad5e7f71\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:28:\"block_content.type.ebt_quote\";i:1;s:40:\"field.field.block_content.ebt_quote.body\";i:2;s:58:\"field.field.block_content.ebt_quote.field_ebt_quote_author\";i:3;s:57:\"field.field.block_content.ebt_quote.field_ebt_quote_image\";i:4;s:54:\"field.field.block_content.ebt_quote.field_ebt_settings\";}s:6:\"module\";a:4:{i:0;s:9:\"ebt_quote\";i:1;s:11:\"field_group\";i:2;s:13:\"media_library\";i:3;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:1;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:4:{i:0;s:4:\"info\";i:1;s:4:\"body\";i:2;s:22:\"field_ebt_quote_author\";i:3;s:21:\"field_ebt_quote_image\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:20;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:21;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"N-LtYp4PCPoTpwSFmV_pxSB5hcbey07dO7biDALNdbg\";}s:2:\"id\";s:31:\"block_content.ebt_quote.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_quote\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:22:\"field_ebt_quote_author\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:21:\"field_ebt_quote_image\";a:5:{s:4:\"type\";s:20:\"media_library_widget\";s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:11:\"media_types\";a:0:{}}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:18:\"ebt_settings_quote\";s:6:\"weight\";i:6;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_slick_slider.default',	'a:12:{s:4:\"uuid\";s:36:\"92792509-019c-4727-be95-79a35850d3e8\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:35:\"block_content.type.ebt_slick_slider\";i:1;s:47:\"field.field.block_content.ebt_slick_slider.body\";i:2;s:61:\"field.field.block_content.ebt_slick_slider.field_ebt_settings\";i:3;s:65:\"field.field.block_content.ebt_slick_slider.field_ebt_slick_slider\";}s:6:\"module\";a:4:{i:0;s:16:\"ebt_slick_slider\";i:1;s:11:\"field_group\";i:2;s:10:\"paragraphs\";i:3;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:1;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:2:{i:0;s:4:\"body\";i:1;s:22:\"field_ebt_slick_slider\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:5;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:4:\"open\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:8;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"bpVaLzDSRRw2IoN4B7lX2DmpEtGagQ_kHdtfu2QnBWk\";}s:2:\"id\";s:38:\"block_content.ebt_slick_slider.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:16:\"ebt_slick_slider\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:6;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:4;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:25:\"ebt_settings_slick_slider\";s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:22:\"field_ebt_slick_slider\";a:5:{s:4:\"type\";s:27:\"entity_reference_paragraphs\";s:6:\"weight\";i:7;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:6:{s:5:\"title\";s:9:\"Paragraph\";s:12:\"title_plural\";s:10:\"Paragraphs\";s:9:\"edit_mode\";s:4:\"open\";s:8:\"add_mode\";s:8:\"dropdown\";s:17:\"form_display_mode\";s:7:\"default\";s:22:\"default_paragraph_type\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_slideshow.default',	'a:12:{s:4:\"uuid\";s:36:\"1e354f38-03e4-4eb3-83d9-64e23ea8e653\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:32:\"block_content.type.ebt_slideshow\";i:1;s:58:\"field.field.block_content.ebt_slideshow.field_ebt_settings\";i:2;s:59:\"field.field.block_content.ebt_slideshow.field_ebt_slideshow\";}s:6:\"module\";a:3:{i:0;s:13:\"ebt_slideshow\";i:1;s:11:\"field_group\";i:2;s:10:\"paragraphs\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:1;s:11:\"format_type\";s:4:\"tabs\";s:6:\"region\";s:7:\"content\";s:15:\"format_settings\";a:5:{s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;s:2:\"id\";s:0:\"\";s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;}s:5:\"label\";s:4:\"Tabs\";}s:13:\"group_content\";a:7:{s:8:\"children\";a:1:{i:0;s:19:\"field_ebt_slideshow\";}s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:20;s:11:\"format_type\";s:3:\"tab\";s:6:\"region\";s:7:\"content\";s:15:\"format_settings\";a:6:{s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:7:\"classes\";s:0:\"\";s:11:\"description\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:15:\"required_fields\";b:1;}s:5:\"label\";s:7:\"Content\";}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:21;s:11:\"format_type\";s:3:\"tab\";s:6:\"region\";s:7:\"content\";s:15:\"format_settings\";a:6:{s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:7:\"classes\";s:0:\"\";s:11:\"description\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:15:\"required_fields\";b:1;}s:5:\"label\";s:8:\"Settings\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6DA12pCUzWErNlrzV5uI2gCLocIzFk1R4r6_m3BD42A\";}s:2:\"id\";s:35:\"block_content.ebt_slideshow.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"ebt_slideshow\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:18:\"field_ebt_settings\";a:5:{s:6:\"weight\";i:22;s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:22:\"ebt_settings_slideshow\";s:6:\"region\";s:7:\"content\";}s:19:\"field_ebt_slideshow\";a:5:{s:4:\"type\";s:27:\"entity_reference_paragraphs\";s:6:\"weight\";i:21;s:8:\"settings\";a:6:{s:5:\"title\";s:9:\"Paragraph\";s:12:\"title_plural\";s:10:\"Paragraphs\";s:9:\"edit_mode\";s:4:\"open\";s:8:\"add_mode\";s:8:\"dropdown\";s:17:\"form_display_mode\";s:7:\"default\";s:22:\"default_paragraph_type\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_stats.default',	'a:12:{s:4:\"uuid\";s:36:\"52b22b0d-85e9-4340-9aa7-8f4febf9050e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:28:\"block_content.type.ebt_stats\";i:1;s:40:\"field.field.block_content.ebt_stats.body\";i:2;s:54:\"field.field.block_content.ebt_stats.field_ebt_settings\";i:3;s:51:\"field.field.block_content.ebt_stats.field_ebt_stats\";}s:6:\"module\";a:4:{i:0;s:9:\"ebt_stats\";i:1;s:11:\"field_group\";i:2;s:10:\"paragraphs\";i:3;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:1;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:2:{i:0;s:4:\"body\";i:1;s:15:\"field_ebt_stats\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:20;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:21;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"_L5lmPQyOe6uFAwlop2yf-ekQRX87-T_CXqJ-IIRg7Y\";}s:2:\"id\";s:31:\"block_content.ebt_stats.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_stats\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:27;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:18:\"ebt_settings_stats\";s:6:\"weight\";i:22;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:15:\"field_ebt_stats\";a:5:{s:4:\"type\";s:10:\"paragraphs\";s:6:\"weight\";i:28;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:10:{s:5:\"title\";s:9:\"Paragraph\";s:12:\"title_plural\";s:10:\"Paragraphs\";s:9:\"edit_mode\";s:4:\"open\";s:11:\"closed_mode\";s:7:\"summary\";s:12:\"autocollapse\";s:4:\"none\";s:21:\"closed_mode_threshold\";i:0;s:8:\"add_mode\";s:8:\"dropdown\";s:17:\"form_display_mode\";s:7:\"default\";s:22:\"default_paragraph_type\";s:0:\"\";s:8:\"features\";a:2:{s:17:\"collapse_edit_all\";s:17:\"collapse_edit_all\";s:9:\"duplicate\";s:9:\"duplicate\";}}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_tabs.default',	'a:12:{s:4:\"uuid\";s:36:\"a7d39dc1-5b23-4427-87b3-0bbc28e7b99b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:27:\"block_content.type.ebt_tabs\";i:1;s:53:\"field.field.block_content.ebt_tabs.field_ebt_settings\";i:2;s:49:\"field.field.block_content.ebt_tabs.field_ebt_tabs\";}s:6:\"module\";a:3:{i:0;s:8:\"ebt_tabs\";i:1;s:11:\"field_group\";i:2;s:10:\"paragraphs\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:3;s:11:\"format_type\";s:4:\"tabs\";s:6:\"region\";s:7:\"content\";s:15:\"format_settings\";a:5:{s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:7:\"classes\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}s:5:\"label\";s:4:\"Tabs\";}s:13:\"group_content\";a:7:{s:8:\"children\";a:1:{i:0;s:14:\"field_ebt_tabs\";}s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:4;s:11:\"format_type\";s:3:\"tab\";s:6:\"region\";s:7:\"content\";s:15:\"format_settings\";a:6:{s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:7:\"classes\";s:0:\"\";s:11:\"description\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:15:\"required_fields\";b:1;}s:5:\"label\";s:7:\"Content\";}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:5;s:11:\"format_type\";s:3:\"tab\";s:6:\"region\";s:7:\"content\";s:15:\"format_settings\";a:6:{s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:7:\"classes\";s:0:\"\";s:11:\"description\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:15:\"required_fields\";b:1;}s:5:\"label\";s:8:\"Settings\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"FiD2k00iSxydyLNXRexQsZwtt3kdC7yWjKnIE2TPsds\";}s:2:\"id\";s:30:\"block_content.ebt_tabs.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_tabs\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:18:\"field_ebt_settings\";a:5:{s:6:\"weight\";i:2;s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:17:\"ebt_settings_tabs\";s:6:\"region\";s:7:\"content\";}s:14:\"field_ebt_tabs\";a:5:{s:4:\"type\";s:27:\"entity_reference_paragraphs\";s:6:\"weight\";i:1;s:8:\"settings\";a:6:{s:5:\"title\";s:9:\"Paragraph\";s:12:\"title_plural\";s:10:\"Paragraphs\";s:9:\"edit_mode\";s:4:\"open\";s:8:\"add_mode\";s:8:\"dropdown\";s:17:\"form_display_mode\";s:7:\"default\";s:22:\"default_paragraph_type\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_text.default',	'a:12:{s:4:\"uuid\";s:36:\"a186725f-445b-4043-83f2-c3bc2d5b1b87\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:27:\"block_content.type.ebt_text\";i:1;s:39:\"field.field.block_content.ebt_text.body\";i:2;s:53:\"field.field.block_content.ebt_text.field_ebt_settings\";}s:6:\"module\";a:3:{i:0;s:8:\"ebt_core\";i:1;s:11:\"field_group\";i:2;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:3;s:11:\"format_type\";s:4:\"tabs\";s:6:\"region\";s:7:\"content\";s:15:\"format_settings\";a:5:{s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:7:\"classes\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}s:5:\"label\";s:4:\"Tabs\";}s:13:\"group_content\";a:7:{s:8:\"children\";a:2:{i:0;s:4:\"info\";i:1;s:4:\"body\";}s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:4;s:11:\"format_type\";s:3:\"tab\";s:6:\"region\";s:7:\"content\";s:15:\"format_settings\";a:6:{s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:7:\"classes\";s:0:\"\";s:11:\"description\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:15:\"required_fields\";b:1;}s:5:\"label\";s:7:\"Content\";}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:5;s:11:\"format_type\";s:3:\"tab\";s:6:\"region\";s:7:\"content\";s:15:\"format_settings\";a:6:{s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:7:\"classes\";s:0:\"\";s:11:\"description\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:15:\"required_fields\";b:1;}s:5:\"label\";s:8:\"Settings\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Qr5FWoE0Z8wFG-omC1KS3oG2wlcQ86J_zl7wsCOUCto\";}s:2:\"id\";s:30:\"block_content.ebt_text.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_text\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:1;s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:5:{s:6:\"weight\";i:2;s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:20:\"ebt_settings_default\";s:6:\"region\";s:7:\"content\";}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_tiles.default',	'a:12:{s:4:\"uuid\";s:36:\"8876d1b6-9d39-4029-abb6-793bf6be88df\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:28:\"block_content.type.ebt_tiles\";i:1;s:40:\"field.field.block_content.ebt_tiles.body\";i:2;s:54:\"field.field.block_content.ebt_tiles.field_ebt_settings\";i:3;s:51:\"field.field.block_content.ebt_tiles.field_ebt_tiles\";}s:6:\"module\";a:4:{i:0;s:9:\"ebt_tiles\";i:1;s:11:\"field_group\";i:2;s:10:\"paragraphs\";i:3;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:0;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:240;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:3:{i:0;s:4:\"info\";i:1;s:4:\"body\";i:2;s:15:\"field_ebt_tiles\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:4;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:4:\"open\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:5;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"B8B292gqxvNzedSxDhs7Ss9nrmX75yMSBzLtMUBusxw\";}s:2:\"id\";s:31:\"block_content.ebt_tiles.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_tiles\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:18:\"ebt_settings_tiles\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:15:\"field_ebt_tiles\";a:5:{s:4:\"type\";s:10:\"paragraphs\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:10:{s:5:\"title\";s:9:\"Paragraph\";s:12:\"title_plural\";s:10:\"Paragraphs\";s:9:\"edit_mode\";s:4:\"open\";s:11:\"closed_mode\";s:7:\"summary\";s:12:\"autocollapse\";s:4:\"none\";s:21:\"closed_mode_threshold\";i:0;s:8:\"add_mode\";s:8:\"dropdown\";s:17:\"form_display_mode\";s:7:\"default\";s:22:\"default_paragraph_type\";s:0:\"\";s:8:\"features\";a:2:{s:17:\"collapse_edit_all\";s:17:\"collapse_edit_all\";s:9:\"duplicate\";s:9:\"duplicate\";}}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_timeline.default',	'a:12:{s:4:\"uuid\";s:36:\"2d00d268-fcaf-44e1-a5d2-99bf5b954cee\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:31:\"block_content.type.ebt_timeline\";i:1;s:57:\"field.field.block_content.ebt_timeline.field_ebt_settings\";i:2;s:57:\"field.field.block_content.ebt_timeline.field_ebt_timeline\";}s:6:\"module\";a:3:{i:0;s:12:\"ebt_timeline\";i:1;s:11:\"field_group\";i:2;s:10:\"paragraphs\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:3;s:11:\"format_type\";s:4:\"tabs\";s:6:\"region\";s:7:\"content\";s:15:\"format_settings\";a:5:{s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;s:2:\"id\";s:0:\"\";s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;}s:5:\"label\";s:4:\"Tabs\";}s:13:\"group_content\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_timeline\";}s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:4;s:11:\"format_type\";s:3:\"tab\";s:6:\"region\";s:7:\"content\";s:15:\"format_settings\";a:6:{s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:7:\"classes\";s:0:\"\";s:11:\"description\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:15:\"required_fields\";b:1;}s:5:\"label\";s:7:\"Content\";}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:5;s:11:\"format_type\";s:3:\"tab\";s:6:\"region\";s:7:\"content\";s:15:\"format_settings\";a:6:{s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:7:\"classes\";s:0:\"\";s:11:\"description\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:15:\"required_fields\";b:1;}s:5:\"label\";s:8:\"Settings\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"lnh43KY0voHRBULlVHJ5n0V8Twh6dwTa482WpJEf7nU\";}s:2:\"id\";s:34:\"block_content.ebt_timeline.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:12:\"ebt_timeline\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:18:\"field_ebt_settings\";a:5:{s:6:\"weight\";i:2;s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:21:\"ebt_settings_timeline\";s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_timeline\";a:5:{s:4:\"type\";s:27:\"entity_reference_paragraphs\";s:6:\"weight\";i:1;s:8:\"settings\";a:6:{s:5:\"title\";s:9:\"Paragraph\";s:12:\"title_plural\";s:10:\"Paragraphs\";s:9:\"edit_mode\";s:4:\"open\";s:8:\"add_mode\";s:8:\"dropdown\";s:17:\"form_display_mode\";s:7:\"default\";s:22:\"default_paragraph_type\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_video.default',	'a:12:{s:4:\"uuid\";s:36:\"adebe1bd-2c8a-4e24-8830-be649450bd8e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:28:\"block_content.type.ebt_video\";i:1;s:40:\"field.field.block_content.ebt_video.body\";i:2;s:54:\"field.field.block_content.ebt_video.field_ebt_settings\";i:3;s:51:\"field.field.block_content.ebt_video.field_ebt_video\";}s:6:\"module\";a:4:{i:0;s:9:\"ebt_video\";i:1;s:11:\"field_group\";i:2;s:13:\"media_library\";i:3;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:0;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:640;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:3:{i:0;s:4:\"info\";i:1;s:4:\"body\";i:2;s:15:\"field_ebt_video\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:5;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:4:\"open\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:6;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"tS6jBKcl-OCTitIjmc0ugKz08ENt8SoAs6NCnjOy-ek\";}s:2:\"id\";s:31:\"block_content.ebt_video.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_video\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:18:\"ebt_settings_video\";s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:15:\"field_ebt_video\";a:5:{s:4:\"type\";s:20:\"media_library_widget\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:11:\"media_types\";a:0:{}}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_video_and_image_gallery.default',	'a:12:{s:4:\"uuid\";s:36:\"4de506fd-736b-43b4-b4e9-87a88229b117\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:46:\"block_content.type.ebt_video_and_image_gallery\";i:1;s:58:\"field.field.block_content.ebt_video_and_image_gallery.body\";i:2;s:72:\"field.field.block_content.ebt_video_and_image_gallery.field_ebt_settings\";i:3;s:81:\"field.field.block_content.ebt_video_and_image_gallery.field_ebt_videos_and_images\";}s:6:\"module\";a:4:{i:0;s:27:\"ebt_video_and_image_gallery\";i:1;s:11:\"field_group\";i:2;s:10:\"paragraphs\";i:3;s:4:\"text\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:2;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:2:{i:0;s:4:\"body\";i:1;s:27:\"field_ebt_videos_and_images\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:20;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:21;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"QGg-MV2IynMGDSKSb1vqdwAQyQ8p83BjC_W3v8O_1lg\";}s:2:\"id\";s:49:\"block_content.ebt_video_and_image_gallery.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:27:\"ebt_video_and_image_gallery\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:36:\"ebt_settings_video_and_image_gallery\";s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:27:\"field_ebt_videos_and_images\";a:5:{s:4:\"type\";s:10:\"paragraphs\";s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:10:{s:5:\"title\";s:9:\"Paragraph\";s:12:\"title_plural\";s:10:\"Paragraphs\";s:9:\"edit_mode\";s:4:\"open\";s:11:\"closed_mode\";s:7:\"summary\";s:12:\"autocollapse\";s:4:\"none\";s:21:\"closed_mode_threshold\";i:0;s:8:\"add_mode\";s:8:\"dropdown\";s:17:\"form_display_mode\";s:7:\"default\";s:22:\"default_paragraph_type\";s:0:\"\";s:8:\"features\";a:2:{s:17:\"collapse_edit_all\";s:17:\"collapse_edit_all\";s:9:\"duplicate\";s:9:\"duplicate\";}}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_views.default',	'a:12:{s:4:\"uuid\";s:36:\"9166e36b-940f-481e-9cf3-5aacb1ef1208\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:28:\"block_content.type.ebt_views\";i:1;s:40:\"field.field.block_content.ebt_views.body\";i:2;s:54:\"field.field.block_content.ebt_views.field_ebt_settings\";i:3;s:57:\"field.field.block_content.ebt_views.field_ebt_views_views\";}s:6:\"module\";a:4:{i:0;s:8:\"ebt_core\";i:1;s:11:\"field_group\";i:2;s:4:\"text\";i:3;s:14:\"viewsreference\";}}s:20:\"third_party_settings\";a:1:{s:11:\"field_group\";a:3:{s:10:\"group_tabs\";a:7:{s:8:\"children\";a:2:{i:0;s:13:\"group_content\";i:1;s:14:\"group_settings\";}s:5:\"label\";s:4:\"Tabs\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:0:\"\";s:6:\"weight\";i:0;s:11:\"format_type\";s:4:\"tabs\";s:15:\"format_settings\";a:5:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"direction\";s:10:\"horizontal\";s:16:\"width_breakpoint\";i:120;}}s:13:\"group_content\";a:7:{s:8:\"children\";a:3:{i:0;s:4:\"info\";i:1;s:4:\"body\";i:2;s:21:\"field_ebt_views_views\";}s:5:\"label\";s:7:\"Content\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:20;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:4:\"open\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}s:14:\"group_settings\";a:7:{s:8:\"children\";a:1:{i:0;s:18:\"field_ebt_settings\";}s:5:\"label\";s:8:\"Settings\";s:6:\"region\";s:7:\"content\";s:11:\"parent_name\";s:10:\"group_tabs\";s:6:\"weight\";i:21;s:11:\"format_type\";s:3:\"tab\";s:15:\"format_settings\";a:6:{s:7:\"classes\";s:0:\"\";s:17:\"show_empty_fields\";b:0;s:2:\"id\";s:0:\"\";s:9:\"formatter\";s:6:\"closed\";s:11:\"description\";s:0:\"\";s:15:\"required_fields\";b:1;}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"E47G4jhOaCiwauUu7Cp8eOG0n1xF0TbNyp6_qUkGMcI\";}s:2:\"id\";s:31:\"block_content.ebt_views.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_views\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:18:\"field_ebt_settings\";a:5:{s:4:\"type\";s:20:\"ebt_settings_default\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:21:\"field_ebt_views_views\";a:5:{s:4:\"type\";s:27:\"viewsreference_autocomplete\";s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:14:\"match_operator\";s:8:\"CONTAINS\";s:11:\"match_limit\";i:10;s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_webform.default',	'a:11:{s:4:\"uuid\";s:36:\"e6638a9a-dd30-4dab-b46a-9c913eb531bb\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:30:\"block_content.type.ebt_webform\";i:1;s:42:\"field.field.block_content.ebt_webform.body\";i:2;s:56:\"field.field.block_content.ebt_webform.field_ebt_settings\";i:3;s:60:\"field.field.block_content.ebt_webform.field_ebt_webform_form\";}s:6:\"module\";a:3:{i:0;s:8:\"ebt_core\";i:1;s:4:\"text\";i:2;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"rtuRBm-Z8ZrdOhT7mc0JrMlWONwesUqNR-IwTM6axEY\";}s:2:\"id\";s:33:\"block_content.ebt_webform.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_webform\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:26;s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:5:{s:6:\"weight\";i:29;s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:20:\"ebt_settings_default\";s:6:\"region\";s:7:\"content\";}s:22:\"field_ebt_webform_form\";a:5:{s:6:\"weight\";i:28;s:8:\"settings\";a:2:{s:12:\"default_data\";b:1;s:8:\"webforms\";a:0:{}}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:31:\"webform_entity_reference_select\";s:6:\"region\";s:7:\"content\";}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:-5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.block_content.ebt_webform_popup.default',	'a:11:{s:4:\"uuid\";s:36:\"76422ca6-6b1c-4ebd-b6e5-d362e8bc423d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:36:\"block_content.type.ebt_webform_popup\";i:1;s:62:\"field.field.block_content.ebt_webform_popup.field_ebt_settings\";i:2;s:72:\"field.field.block_content.ebt_webform_popup.field_ebt_webform_popup_form\";}s:6:\"module\";a:2:{i:0;s:17:\"ebt_webform_popup\";i:1;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"-EvEMaGTSq7rxJjzGuhqBIybUTNrM39BXJjRKhFkDos\";}s:2:\"id\";s:39:\"block_content.ebt_webform_popup.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:17:\"ebt_webform_popup\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:18:\"field_ebt_settings\";a:5:{s:6:\"weight\";i:28;s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:26:\"ebt_settings_webform_popup\";s:6:\"region\";s:7:\"content\";}s:28:\"field_ebt_webform_popup_form\";a:5:{s:6:\"weight\";i:27;s:8:\"settings\";a:2:{s:12:\"default_data\";b:1;s:8:\"webforms\";a:0:{}}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:31:\"webform_entity_reference_select\";s:6:\"region\";s:7:\"content\";}s:4:\"info\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:-5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_display.media.audio.default',	'a:11:{s:4:\"uuid\";s:36:\"9efccee6-8cc4-4ff4-92bb-0553278490ef\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:46:\"field.field.media.audio.field_media_audio_file\";i:1;s:16:\"media.type.audio\";}s:6:\"module\";a:2:{i:0;s:4:\"file\";i:1;s:4:\"path\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"G2_SKH3jmI9FQeXSUxo3KgQqiyF1hPDEkc7-3-rCSbc\";}s:2:\"id\";s:19:\"media.audio.default\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:5:\"audio\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:7:\"created\";a:5:{s:4:\"type\";s:18:\"datetime_timestamp\";s:6:\"weight\";i:10;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:22:\"field_media_audio_file\";a:5:{s:4:\"type\";s:12:\"file_generic\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:18:\"progress_indicator\";s:8:\"throbber\";}s:20:\"third_party_settings\";a:0:{}}s:4:\"path\";a:5:{s:4:\"type\";s:4:\"path\";s:6:\"weight\";i:30;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:6:\"status\";a:5:{s:4:\"type\";s:16:\"boolean_checkbox\";s:6:\"weight\";i:100;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:13:\"display_label\";b:1;}s:20:\"third_party_settings\";a:0:{}}s:3:\"uid\";a:5:{s:4:\"type\";s:29:\"entity_reference_autocomplete\";s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:14:\"match_operator\";s:8:\"CONTAINS\";s:11:\"match_limit\";i:10;s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:1:{s:4:\"name\";b:1;}}'),
('',	'core.entity_form_display.media.audio.media_library',	'a:11:{s:4:\"uuid\";s:36:\"70924fc9-698f-43ce-8125-c9f66ca37236\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:41:\"core.entity_form_mode.media.media_library\";i:1;s:46:\"field.field.media.audio.field_media_audio_file\";i:2;s:16:\"media.type.audio\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"28vwMIYtvyjPcD4RyciZXIztxtZgmuWRCNgYemr_SZE\";}s:2:\"id\";s:25:\"media.audio.media_library\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:5:\"audio\";s:4:\"mode\";s:13:\"media_library\";s:7:\"content\";a:0:{}s:6:\"hidden\";a:6:{s:7:\"created\";b:1;s:22:\"field_media_audio_file\";b:1;s:4:\"name\";b:1;s:4:\"path\";b:1;s:6:\"status\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_form_display.media.document.default',	'a:11:{s:4:\"uuid\";s:36:\"c99f3040-4f5d-4326-9040-193db1713a88\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:47:\"field.field.media.document.field_media_document\";i:1;s:19:\"media.type.document\";}s:6:\"module\";a:2:{i:0;s:4:\"file\";i:1;s:4:\"path\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"aewrRkePgJzdD5kPOq8JeMcKHs6yat49nE7ZeCQzQZg\";}s:2:\"id\";s:22:\"media.document.default\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:8:\"document\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:7:\"created\";a:5:{s:4:\"type\";s:18:\"datetime_timestamp\";s:6:\"weight\";i:10;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:20:\"field_media_document\";a:5:{s:4:\"type\";s:12:\"file_generic\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:18:\"progress_indicator\";s:8:\"throbber\";}s:20:\"third_party_settings\";a:0:{}}s:4:\"path\";a:5:{s:4:\"type\";s:4:\"path\";s:6:\"weight\";i:30;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:6:\"status\";a:5:{s:4:\"type\";s:16:\"boolean_checkbox\";s:6:\"weight\";i:100;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:13:\"display_label\";b:1;}s:20:\"third_party_settings\";a:0:{}}s:3:\"uid\";a:5:{s:4:\"type\";s:29:\"entity_reference_autocomplete\";s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:14:\"match_operator\";s:8:\"CONTAINS\";s:11:\"match_limit\";i:10;s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:1:{s:4:\"name\";b:1;}}'),
('',	'core.entity_form_display.media.document.media_library',	'a:11:{s:4:\"uuid\";s:36:\"8df854a8-6d93-49a7-803e-4334857e73fc\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:41:\"core.entity_form_mode.media.media_library\";i:1;s:47:\"field.field.media.document.field_media_document\";i:2;s:19:\"media.type.document\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"dcpfpqyLXOSGpulacMAJW3H-G34_LeNsjdfxd1_oCfY\";}s:2:\"id\";s:28:\"media.document.media_library\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:8:\"document\";s:4:\"mode\";s:13:\"media_library\";s:7:\"content\";a:0:{}s:6:\"hidden\";a:6:{s:7:\"created\";b:1;s:20:\"field_media_document\";b:1;s:4:\"name\";b:1;s:4:\"path\";b:1;s:6:\"status\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_form_display.media.image.default',	'a:11:{s:4:\"uuid\";s:36:\"7b876128-538a-4826-a5a4-52747a729203\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:41:\"field.field.media.image.field_media_image\";i:1;s:21:\"image.style.thumbnail\";i:2;s:16:\"media.type.image\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"path\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"JSY4-JPyNZBiYYo6imdRYF6_SdtWQexPndrLvn3-vw4\";}s:2:\"id\";s:19:\"media.image.default\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:5:\"image\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:7:\"created\";a:5:{s:4:\"type\";s:18:\"datetime_timestamp\";s:6:\"weight\";i:10;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:17:\"field_media_image\";a:5:{s:4:\"type\";s:11:\"image_image\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}s:20:\"third_party_settings\";a:0:{}}s:4:\"path\";a:5:{s:4:\"type\";s:4:\"path\";s:6:\"weight\";i:30;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:6:\"status\";a:5:{s:4:\"type\";s:16:\"boolean_checkbox\";s:6:\"weight\";i:100;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:13:\"display_label\";b:1;}s:20:\"third_party_settings\";a:0:{}}s:3:\"uid\";a:5:{s:4:\"type\";s:29:\"entity_reference_autocomplete\";s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:14:\"match_operator\";s:8:\"CONTAINS\";s:11:\"match_limit\";i:10;s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:1:{s:4:\"name\";b:1;}}'),
('',	'core.entity_form_display.media.image.media_library',	'a:11:{s:4:\"uuid\";s:36:\"3d16f00d-32eb-4ac9-a711-00689691832b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:41:\"core.entity_form_mode.media.media_library\";i:1;s:41:\"field.field.media.image.field_media_image\";i:2;s:21:\"image.style.thumbnail\";i:3;s:16:\"media.type.image\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"BMLrK4zKp8-FFnMseBdT_6h6YipUsKRfbDf_3WUB5HA\";}s:2:\"id\";s:25:\"media.image.media_library\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:5:\"image\";s:4:\"mode\";s:13:\"media_library\";s:7:\"content\";a:1:{s:17:\"field_media_image\";a:5:{s:4:\"type\";s:11:\"image_image\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:5:{s:7:\"created\";b:1;s:4:\"name\";b:1;s:4:\"path\";b:1;s:6:\"status\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_form_display.media.remote_video.default',	'a:11:{s:4:\"uuid\";s:36:\"d145d9a4-1eb4-4ece-a5e9-4e77dd7a4b2a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:55:\"field.field.media.remote_video.field_media_oembed_video\";i:1;s:23:\"media.type.remote_video\";}s:6:\"module\";a:2:{i:0;s:5:\"media\";i:1;s:4:\"path\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"pM8mGlwfpvfG_y5tZn0lGAXFLXz2_yKkL7MvWZsRqdA\";}s:2:\"id\";s:26:\"media.remote_video.default\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:12:\"remote_video\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:7:\"created\";a:5:{s:4:\"type\";s:18:\"datetime_timestamp\";s:6:\"weight\";i:10;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:24:\"field_media_oembed_video\";a:5:{s:4:\"type\";s:16:\"oembed_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:4:\"path\";a:5:{s:4:\"type\";s:4:\"path\";s:6:\"weight\";i:30;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:6:\"status\";a:5:{s:4:\"type\";s:16:\"boolean_checkbox\";s:6:\"weight\";i:100;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:13:\"display_label\";b:1;}s:20:\"third_party_settings\";a:0:{}}s:3:\"uid\";a:5:{s:4:\"type\";s:29:\"entity_reference_autocomplete\";s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:14:\"match_operator\";s:8:\"CONTAINS\";s:11:\"match_limit\";i:10;s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:1:{s:4:\"name\";b:1;}}'),
('',	'core.entity_form_display.media.remote_video.media_library',	'a:11:{s:4:\"uuid\";s:36:\"996b87ca-42a9-4803-afcc-24ebfbdf7849\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:41:\"core.entity_form_mode.media.media_library\";i:1;s:55:\"field.field.media.remote_video.field_media_oembed_video\";i:2;s:23:\"media.type.remote_video\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"TBgPW-uaXRaICBwLaVc16rXpRiLSknDIdF9q0XL7qso\";}s:2:\"id\";s:32:\"media.remote_video.media_library\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:12:\"remote_video\";s:4:\"mode\";s:13:\"media_library\";s:7:\"content\";a:0:{}s:6:\"hidden\";a:6:{s:7:\"created\";b:1;s:24:\"field_media_oembed_video\";b:1;s:4:\"name\";b:1;s:4:\"path\";b:1;s:6:\"status\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_form_display.media.video.default',	'a:11:{s:4:\"uuid\";s:36:\"432d0cdf-b7f6-4927-af19-9a26a2f71c65\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:46:\"field.field.media.video.field_media_video_file\";i:1;s:16:\"media.type.video\";}s:6:\"module\";a:2:{i:0;s:4:\"file\";i:1;s:4:\"path\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"0kIIaDTt6dixXy8TZkat2MNGZJ6vkRG8TaBWTy3E1bM\";}s:2:\"id\";s:19:\"media.video.default\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:5:\"video\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:7:\"created\";a:5:{s:4:\"type\";s:18:\"datetime_timestamp\";s:6:\"weight\";i:10;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:22:\"field_media_video_file\";a:5:{s:4:\"type\";s:12:\"file_generic\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:18:\"progress_indicator\";s:8:\"throbber\";}s:20:\"third_party_settings\";a:0:{}}s:4:\"path\";a:5:{s:4:\"type\";s:4:\"path\";s:6:\"weight\";i:30;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:6:\"status\";a:5:{s:4:\"type\";s:16:\"boolean_checkbox\";s:6:\"weight\";i:100;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:13:\"display_label\";b:1;}s:20:\"third_party_settings\";a:0:{}}s:3:\"uid\";a:5:{s:4:\"type\";s:29:\"entity_reference_autocomplete\";s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:14:\"match_operator\";s:8:\"CONTAINS\";s:11:\"match_limit\";i:10;s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:1:{s:4:\"name\";b:1;}}'),
('',	'core.entity_form_display.media.video.media_library',	'a:11:{s:4:\"uuid\";s:36:\"eed6f1c2-957f-4ca5-9d11-57d9fb6c9564\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:41:\"core.entity_form_mode.media.media_library\";i:1;s:46:\"field.field.media.video.field_media_video_file\";i:2;s:16:\"media.type.video\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"kGv8YsopqHvzTzb7QTINWcv0fnNa5ZDQyZxpOQR2vro\";}s:2:\"id\";s:25:\"media.video.media_library\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:5:\"video\";s:4:\"mode\";s:13:\"media_library\";s:7:\"content\";a:0:{}s:6:\"hidden\";a:6:{s:7:\"created\";b:1;s:22:\"field_media_video_file\";b:1;s:4:\"name\";b:1;s:4:\"path\";b:1;s:6:\"status\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_form_display.node.article.default',	'a:11:{s:4:\"uuid\";s:36:\"c224932f-6de0-4883-88df-0c2ae5186624\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:7:{i:0;s:29:\"field.field.node.article.body\";i:1;s:36:\"field.field.node.article.field_image\";i:2;s:39:\"field.field.node.article.field_metatags\";i:3;s:35:\"field.field.node.article.field_tags\";i:4;s:47:\"field.field.node.article.layout_builder__layout\";i:5;s:21:\"image.style.thumbnail\";i:6;s:17:\"node.type.article\";}s:6:\"module\";a:4:{i:0;s:7:\"metatag\";i:1;s:4:\"path\";i:2;s:9:\"svg_image\";i:3;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ewbd6G2uX456-bgwseM2Q-KQG3RkASoyHmTh-XR3oLU\";}s:2:\"id\";s:20:\"node.article.default\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:12:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:7:\"created\";a:5:{s:4:\"type\";s:18:\"datetime_timestamp\";s:6:\"weight\";i:10;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:11:\"field_image\";a:5:{s:4:\"type\";s:11:\"image_image\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}s:20:\"third_party_settings\";a:0:{}}s:14:\"field_metatags\";a:5:{s:4:\"type\";s:16:\"metatag_firehose\";s:6:\"weight\";i:121;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:7:\"sidebar\";b:1;s:11:\"use_details\";b:1;}s:20:\"third_party_settings\";a:0:{}}s:10:\"field_tags\";a:5:{s:4:\"type\";s:34:\"entity_reference_autocomplete_tags\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:14:\"match_operator\";s:8:\"CONTAINS\";s:11:\"match_limit\";i:10;s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:4:\"path\";a:5:{s:4:\"type\";s:4:\"path\";s:6:\"weight\";i:30;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:7:\"promote\";a:5:{s:4:\"type\";s:16:\"boolean_checkbox\";s:6:\"weight\";i:15;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:13:\"display_label\";b:1;}s:20:\"third_party_settings\";a:0:{}}s:6:\"status\";a:5:{s:4:\"type\";s:16:\"boolean_checkbox\";s:6:\"weight\";i:120;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:13:\"display_label\";b:1;}s:20:\"third_party_settings\";a:0:{}}s:6:\"sticky\";a:5:{s:4:\"type\";s:16:\"boolean_checkbox\";s:6:\"weight\";i:16;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:13:\"display_label\";b:1;}s:20:\"third_party_settings\";a:0:{}}s:5:\"title\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:3:\"uid\";a:5:{s:4:\"type\";s:29:\"entity_reference_autocomplete\";s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:14:\"match_operator\";s:8:\"CONTAINS\";s:11:\"match_limit\";i:10;s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:13:\"url_redirects\";a:4:{s:6:\"weight\";i:50;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:1:{s:22:\"layout_builder__layout\";b:1;}}'),
('',	'core.entity_form_display.node.page.default',	'a:11:{s:4:\"uuid\";s:36:\"095e0e3b-5060-4869-9c69-f8044cadf927\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:26:\"field.field.node.page.body\";i:1;s:36:\"field.field.node.page.field_metatags\";i:2;s:44:\"field.field.node.page.layout_builder__layout\";i:3;s:14:\"node.type.page\";}s:6:\"module\";a:3:{i:0;s:7:\"metatag\";i:1;s:4:\"path\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SfpLhPExzvR0MgFp0Wp7CrmgEnhcqQ-fXIWFhbf4ue0\";}s:2:\"id\";s:17:\"node.page.default\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:10:{s:4:\"body\";a:5:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:6:\"weight\";i:31;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:4:\"rows\";i:9;s:12:\"summary_rows\";i:3;s:11:\"placeholder\";s:0:\"\";s:12:\"show_summary\";b:0;}s:20:\"third_party_settings\";a:0:{}}s:7:\"created\";a:5:{s:4:\"type\";s:18:\"datetime_timestamp\";s:6:\"weight\";i:10;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:14:\"field_metatags\";a:5:{s:4:\"type\";s:16:\"metatag_firehose\";s:6:\"weight\";i:121;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:7:\"sidebar\";b:1;s:11:\"use_details\";b:1;}s:20:\"third_party_settings\";a:0:{}}s:4:\"path\";a:5:{s:4:\"type\";s:4:\"path\";s:6:\"weight\";i:30;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}s:7:\"promote\";a:5:{s:4:\"type\";s:16:\"boolean_checkbox\";s:6:\"weight\";i:15;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:13:\"display_label\";b:1;}s:20:\"third_party_settings\";a:0:{}}s:6:\"status\";a:5:{s:4:\"type\";s:16:\"boolean_checkbox\";s:6:\"weight\";i:120;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:13:\"display_label\";b:1;}s:20:\"third_party_settings\";a:0:{}}s:6:\"sticky\";a:5:{s:4:\"type\";s:16:\"boolean_checkbox\";s:6:\"weight\";i:16;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:13:\"display_label\";b:1;}s:20:\"third_party_settings\";a:0:{}}s:5:\"title\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:-5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:3:\"uid\";a:5:{s:4:\"type\";s:29:\"entity_reference_autocomplete\";s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:4:{s:14:\"match_operator\";s:8:\"CONTAINS\";s:11:\"match_limit\";i:10;s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:13:\"url_redirects\";a:4:{s:6:\"weight\";i:50;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:1:{s:22:\"layout_builder__layout\";b:1;}}'),
('',	'core.entity_form_display.paragraph.ebt_accordion.default',	'a:11:{s:4:\"uuid\";s:36:\"ee2f8f98-b9f7-4254-9737-68dc2197b2fd\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:60:\"field.field.paragraph.ebt_accordion.field_ebt_accordion_text\";i:1;s:61:\"field.field.paragraph.ebt_accordion.field_ebt_accordion_title\";i:2;s:40:\"paragraphs.paragraphs_type.ebt_accordion\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"VV4WvHQlFMN4Xl5jLocxzCyuI7nCn1nGWGmJZbXlG2Q\";}s:2:\"id\";s:31:\"paragraph.ebt_accordion.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:13:\"ebt_accordion\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:24:\"field_ebt_accordion_text\";a:5:{s:6:\"weight\";i:1;s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:13:\"text_textarea\";s:6:\"region\";s:7:\"content\";}s:25:\"field_ebt_accordion_title\";a:5:{s:6:\"weight\";i:0;s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:13:\"text_textarea\";s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:2:{s:7:\"created\";b:1;s:6:\"status\";b:1;}}'),
('',	'core.entity_form_display.paragraph.ebt_carousel.default',	'a:11:{s:4:\"uuid\";s:36:\"d1b4eb72-c64f-476b-bb62-88226cb19793\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:61:\"field.field.paragraph.ebt_carousel.field_ebt_carousel_caption\";i:1;s:59:\"field.field.paragraph.ebt_carousel.field_ebt_carousel_image\";i:2;s:39:\"paragraphs.paragraphs_type.ebt_carousel\";}s:6:\"module\";a:2:{i:0;s:13:\"media_library\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"yERJpwaJ1QC8Q1Gr8Tezl9O_q0ufoiR8gwonaEjSspw\";}s:2:\"id\";s:30:\"paragraph.ebt_carousel.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:12:\"ebt_carousel\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:26:\"field_ebt_carousel_caption\";a:5:{s:6:\"weight\";i:1;s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:13:\"text_textarea\";s:6:\"region\";s:7:\"content\";}s:24:\"field_ebt_carousel_image\";a:5:{s:4:\"type\";s:20:\"media_library_widget\";s:6:\"weight\";i:0;s:8:\"settings\";a:1:{s:11:\"media_types\";a:0:{}}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:2:{s:7:\"created\";b:1;s:6:\"status\";b:1;}}'),
('',	'core.entity_form_display.paragraph.ebt_counter_item.default',	'a:11:{s:4:\"uuid\";s:36:\"4579f4f8-31b0-4cd5-b9fe-f87cd45f5fb6\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:68:\"field.field.paragraph.ebt_counter_item.field_ebt_counter_description\";i:1;s:61:\"field.field.paragraph.ebt_counter_item.field_ebt_counter_icon\";i:2;s:63:\"field.field.paragraph.ebt_counter_item.field_ebt_counter_number\";i:3;s:62:\"field.field.paragraph.ebt_counter_item.field_ebt_counter_title\";i:4;s:43:\"paragraphs.paragraphs_type.ebt_counter_item\";}s:6:\"module\";a:2:{i:0;s:13:\"media_library\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"snzZLNDA9DFF0msO0Up9bLDhB8kgJR3OFtnbryzGVms\";}s:2:\"id\";s:34:\"paragraph.ebt_counter_item.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:16:\"ebt_counter_item\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:29:\"field_ebt_counter_description\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:22:\"field_ebt_counter_icon\";a:5:{s:4:\"type\";s:20:\"media_library_widget\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:11:\"media_types\";a:0:{}}s:20:\"third_party_settings\";a:0:{}}s:24:\"field_ebt_counter_number\";a:5:{s:4:\"type\";s:6:\"number\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:23:\"field_ebt_counter_title\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:2:{s:7:\"created\";b:1;s:6:\"status\";b:1;}}'),
('',	'core.entity_form_display.paragraph.ebt_slick_slider.default',	'a:11:{s:4:\"uuid\";s:36:\"49d083c6-462d-45e8-b2da-c158f1f21e4d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:67:\"field.field.paragraph.ebt_slick_slider.field_ebt_slick_slider_image\";i:1;s:66:\"field.field.paragraph.ebt_slick_slider.field_ebt_slick_slider_link\";i:2;s:66:\"field.field.paragraph.ebt_slick_slider.field_ebt_slick_slider_text\";i:3;s:43:\"paragraphs.paragraphs_type.ebt_slick_slider\";}s:6:\"module\";a:3:{i:0;s:4:\"link\";i:1;s:13:\"media_library\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SrB8f_Znsaiqtv7a46b7z53joZ5A1SCIFKCJUjFizQk\";}s:2:\"id\";s:34:\"paragraph.ebt_slick_slider.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:16:\"ebt_slick_slider\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:28:\"field_ebt_slick_slider_image\";a:5:{s:4:\"type\";s:20:\"media_library_widget\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:11:\"media_types\";a:0:{}}s:20:\"third_party_settings\";a:0:{}}s:27:\"field_ebt_slick_slider_link\";a:5:{s:4:\"type\";s:12:\"link_default\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:15:\"placeholder_url\";s:0:\"\";s:17:\"placeholder_title\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:27:\"field_ebt_slick_slider_text\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:2:{s:7:\"created\";b:1;s:6:\"status\";b:1;}}'),
('',	'core.entity_form_display.paragraph.ebt_slideshow.default',	'a:11:{s:4:\"uuid\";s:36:\"4d6b8979-02dc-432e-a1ee-1e39bf6d0736\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:60:\"field.field.paragraph.ebt_slideshow.field_ebt_slideshow_link\";i:1;s:61:\"field.field.paragraph.ebt_slideshow.field_ebt_slideshow_slide\";i:2;s:60:\"field.field.paragraph.ebt_slideshow.field_ebt_slideshow_text\";i:3;s:61:\"field.field.paragraph.ebt_slideshow.field_ebt_slideshow_title\";i:4;s:40:\"paragraphs.paragraphs_type.ebt_slideshow\";}s:6:\"module\";a:3:{i:0;s:4:\"link\";i:1;s:13:\"media_library\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Q1kjXAT0qkIlX0WEGDAcnGaQHa1XeILgCDnWcPfDVJ0\";}s:2:\"id\";s:31:\"paragraph.ebt_slideshow.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:13:\"ebt_slideshow\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:24:\"field_ebt_slideshow_link\";a:5:{s:4:\"type\";s:12:\"link_default\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:15:\"placeholder_url\";s:0:\"\";s:17:\"placeholder_title\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:25:\"field_ebt_slideshow_slide\";a:5:{s:4:\"type\";s:20:\"media_library_widget\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:11:\"media_types\";a:0:{}}s:20:\"third_party_settings\";a:0:{}}s:24:\"field_ebt_slideshow_text\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:25:\"field_ebt_slideshow_title\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:2:{s:7:\"created\";b:1;s:6:\"status\";b:1;}}'),
('',	'core.entity_form_display.paragraph.ebt_stats_item.default',	'a:11:{s:4:\"uuid\";s:36:\"a7152796-e586-430a-a770-6b093d09cb7c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:59:\"field.field.paragraph.ebt_stats_item.field_stats_item_image\";i:1;s:58:\"field.field.paragraph.ebt_stats_item.field_stats_item_link\";i:2;s:60:\"field.field.paragraph.ebt_stats_item.field_stats_item_number\";i:3;s:58:\"field.field.paragraph.ebt_stats_item.field_stats_item_text\";i:4;s:41:\"paragraphs.paragraphs_type.ebt_stats_item\";}s:6:\"module\";a:3:{i:0;s:4:\"link\";i:1;s:13:\"media_library\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"_LZlRyxzZkfNDaWmAIuAHQXMASYeRLzj_Tu9HB2QGnw\";}s:2:\"id\";s:32:\"paragraph.ebt_stats_item.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"ebt_stats_item\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:22:\"field_stats_item_image\";a:5:{s:4:\"type\";s:20:\"media_library_widget\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:11:\"media_types\";a:0:{}}s:20:\"third_party_settings\";a:0:{}}s:21:\"field_stats_item_link\";a:5:{s:4:\"type\";s:12:\"link_default\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:15:\"placeholder_url\";s:0:\"\";s:17:\"placeholder_title\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:23:\"field_stats_item_number\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:21:\"field_stats_item_text\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:2:{s:7:\"created\";b:1;s:6:\"status\";b:1;}}'),
('',	'core.entity_form_display.paragraph.ebt_tab.default',	'a:11:{s:4:\"uuid\";s:36:\"99244a65-d42c-43a2-baae-958073fef48f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:7:{i:0;s:49:\"field.field.paragraph.ebt_tab.field_ebt_tab_block\";i:1;s:51:\"field.field.paragraph.ebt_tab.field_ebt_tab_content\";i:2;s:48:\"field.field.paragraph.ebt_tab.field_ebt_tab_page\";i:3;s:48:\"field.field.paragraph.ebt_tab.field_ebt_tab_text\";i:4;s:49:\"field.field.paragraph.ebt_tab.field_ebt_tab_title\";i:5;s:49:\"field.field.paragraph.ebt_tab.field_ebt_tab_views\";i:6;s:34:\"paragraphs.paragraphs_type.ebt_tab\";}s:6:\"module\";a:3:{i:0;s:11:\"block_field\";i:1;s:4:\"text\";i:2;s:14:\"viewsreference\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"3tkvVlJEyrGPBNqg-NmBgDBe7aW-ckCLKwsrbQPd28E\";}s:2:\"id\";s:25:\"paragraph.ebt_tab.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:7:\"ebt_tab\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:6:{s:19:\"field_ebt_tab_block\";a:5:{s:6:\"weight\";i:7;s:8:\"settings\";a:3:{s:9:\"plugin_id\";s:0:\"\";s:8:\"settings\";a:0:{}s:18:\"configuration_form\";s:4:\"full\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:19:\"block_field_default\";s:6:\"region\";s:7:\"content\";}s:21:\"field_ebt_tab_content\";a:5:{s:6:\"weight\";i:1;s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:14:\"options_select\";s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_tab_page\";a:5:{s:6:\"weight\";i:2;s:8:\"settings\";a:4:{s:14:\"match_operator\";s:8:\"CONTAINS\";s:11:\"match_limit\";i:10;s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:29:\"entity_reference_autocomplete\";s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_tab_text\";a:5:{s:6:\"weight\";i:3;s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:13:\"text_textarea\";s:6:\"region\";s:7:\"content\";}s:19:\"field_ebt_tab_title\";a:5:{s:6:\"weight\";i:0;s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:14:\"text_textfield\";s:6:\"region\";s:7:\"content\";}s:19:\"field_ebt_tab_views\";a:5:{s:6:\"weight\";i:6;s:8:\"settings\";a:4:{s:14:\"match_operator\";s:8:\"CONTAINS\";s:11:\"match_limit\";i:10;s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:27:\"viewsreference_autocomplete\";s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:2:{s:7:\"created\";b:1;s:6:\"status\";b:1;}}'),
('',	'core.entity_form_display.paragraph.ebt_tiles_item.default',	'a:11:{s:4:\"uuid\";s:36:\"fbaff897-1222-45d2-bdee-f1c92ecc517d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:6:{i:0;s:61:\"field.field.paragraph.ebt_tiles_item.field_ebt_clickable_tile\";i:1;s:58:\"field.field.paragraph.ebt_tiles_item.field_ebt_tiles_image\";i:2;s:57:\"field.field.paragraph.ebt_tiles_item.field_ebt_tiles_link\";i:3;s:57:\"field.field.paragraph.ebt_tiles_item.field_ebt_tiles_text\";i:4;s:58:\"field.field.paragraph.ebt_tiles_item.field_ebt_tiles_title\";i:5;s:41:\"paragraphs.paragraphs_type.ebt_tiles_item\";}s:6:\"module\";a:3:{i:0;s:4:\"link\";i:1;s:13:\"media_library\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"aO9CEu-AEXoDrOUyi0zQ-BFKnOQQ4j-7EZboHKs25Ao\";}s:2:\"id\";s:32:\"paragraph.ebt_tiles_item.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"ebt_tiles_item\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:24:\"field_ebt_clickable_tile\";a:5:{s:4:\"type\";s:16:\"boolean_checkbox\";s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:13:\"display_label\";b:1;}s:20:\"third_party_settings\";a:0:{}}s:21:\"field_ebt_tiles_image\";a:5:{s:4:\"type\";s:20:\"media_library_widget\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:11:\"media_types\";a:0:{}}s:20:\"third_party_settings\";a:0:{}}s:20:\"field_ebt_tiles_link\";a:5:{s:4:\"type\";s:12:\"link_default\";s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:15:\"placeholder_url\";s:0:\"\";s:17:\"placeholder_title\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:20:\"field_ebt_tiles_text\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:21:\"field_ebt_tiles_title\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:2;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:2:{s:7:\"created\";b:1;s:6:\"status\";b:1;}}'),
('',	'core.entity_form_display.paragraph.ebt_timeline.default',	'a:11:{s:4:\"uuid\";s:36:\"9ade0a26-a08a-49b3-8f21-5cc52e0a9d4a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:6:{i:0;s:61:\"field.field.paragraph.ebt_timeline.field_ebt_timeline_current\";i:1;s:58:\"field.field.paragraph.ebt_timeline.field_ebt_timeline_date\";i:2;s:65:\"field.field.paragraph.ebt_timeline.field_ebt_timeline_media_image\";i:3;s:58:\"field.field.paragraph.ebt_timeline.field_ebt_timeline_text\";i:4;s:59:\"field.field.paragraph.ebt_timeline.field_ebt_timeline_title\";i:5;s:39:\"paragraphs.paragraphs_type.ebt_timeline\";}s:6:\"module\";a:2:{i:0;s:13:\"media_library\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"roudiPcEWEQePvvKVTvyQOha3roMsIYNfxuZ8yhsA7o\";}s:2:\"id\";s:30:\"paragraph.ebt_timeline.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:12:\"ebt_timeline\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:26:\"field_ebt_timeline_current\";a:5:{s:4:\"type\";s:16:\"boolean_checkbox\";s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:13:\"display_label\";b:1;}s:20:\"third_party_settings\";a:0:{}}s:23:\"field_ebt_timeline_date\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:30:\"field_ebt_timeline_media_image\";a:5:{s:4:\"type\";s:20:\"media_library_widget\";s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:11:\"media_types\";a:0:{}}s:20:\"third_party_settings\";a:0:{}}s:23:\"field_ebt_timeline_text\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:24:\"field_ebt_timeline_title\";a:5:{s:4:\"type\";s:16:\"string_textfield\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:2:{s:7:\"created\";b:1;s:6:\"status\";b:1;}}'),
('',	'core.entity_form_display.paragraph.ebt_video_and_image_gallery_item.default',	'a:11:{s:4:\"uuid\";s:36:\"af68c1f1-a952-4c8a-ad1c-06f3eaa33777\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:85:\"field.field.paragraph.ebt_video_and_image_gallery_item.field_gallery_item_description\";i:1;s:79:\"field.field.paragraph.ebt_video_and_image_gallery_item.field_video_gallery_item\";i:2;s:59:\"paragraphs.paragraphs_type.ebt_video_and_image_gallery_item\";}s:6:\"module\";a:2:{i:0;s:13:\"media_library\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Ajt8RnSI29uPiHiC5kZcmSORcHZviDbPeC4fnIM2VWo\";}s:2:\"id\";s:50:\"paragraph.ebt_video_and_image_gallery_item.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:32:\"ebt_video_and_image_gallery_item\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:30:\"field_gallery_item_description\";a:5:{s:4:\"type\";s:13:\"text_textarea\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:4:\"rows\";i:5;s:11:\"placeholder\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}}s:24:\"field_video_gallery_item\";a:5:{s:4:\"type\";s:20:\"media_library_widget\";s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:1:{s:11:\"media_types\";a:0:{}}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:2:{s:7:\"created\";b:1;s:6:\"status\";b:1;}}'),
('',	'core.entity_form_display.user.user.default',	'a:11:{s:4:\"uuid\";s:36:\"2e78043c-ec7e-40d3-9893-74a39341e80d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:34:\"field.field.user.user.user_picture\";i:1;s:21:\"image.style.thumbnail\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"FaQ9Ptcpxpg30AtiqRDtl_8zbJArHP1LPfug_s59TOA\";}s:2:\"id\";s:17:\"user.user.default\";s:16:\"targetEntityType\";s:4:\"user\";s:6:\"bundle\";s:4:\"user\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:7:\"account\";a:2:{s:6:\"weight\";i:-10;s:6:\"region\";s:7:\"content\";}s:7:\"contact\";a:2:{s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";}s:8:\"language\";a:2:{s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:8:\"timezone\";a:2:{s:6:\"weight\";i:6;s:6:\"region\";s:7:\"content\";}s:12:\"user_picture\";a:5:{s:4:\"type\";s:11:\"image_image\";s:6:\"weight\";i:-1;s:6:\"region\";s:7:\"content\";s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_form_mode.media.media_library',	'a:10:{s:4:\"uuid\";s:36:\"4f486238-f30d-4022-ac1d-42675ab0f17a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:13:\"media_library\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"04_dAqpWYP1WmsXZ7IXJ7-yarCvNddD10EUkBDtIFy4\";}s:2:\"id\";s:19:\"media.media_library\";s:5:\"label\";s:13:\"Media library\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:5:\"media\";s:5:\"cache\";b:1;}'),
('',	'core.entity_form_mode.user.register',	'a:10:{s:4:\"uuid\";s:36:\"2a875655-65fd-42f4-bd80-8b41714fa393\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"5pE_4hurqtIlZN3XDi7eTo5RG13BMG0Rh9HYlRI3h8U\";}s:2:\"id\";s:13:\"user.register\";s:5:\"label\";s:8:\"Register\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:4:\"user\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_display.block_content.basic.default',	'a:11:{s:4:\"uuid\";s:36:\"d5902a81-52d9-49dd-b8db-4665dbc4368c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:24:\"block_content.type.basic\";i:1;s:36:\"field.field.block_content.basic.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"hBNNDTFwakREOTa6GGMqN899Iyrii0hInwSJtQ7Kj30\";}s:2:\"id\";s:27:\"block_content.basic.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:5:\"basic\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:1:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_accordion.default',	'a:11:{s:4:\"uuid\";s:36:\"4043bfd5-1d8c-40be-b5b7-7566608c0a10\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:32:\"block_content.type.ebt_accordion\";i:1;s:44:\"field.field.block_content.ebt_accordion.body\";i:2;s:59:\"field.field.block_content.ebt_accordion.field_ebt_accordion\";i:3;s:58:\"field.field.block_content.ebt_accordion.field_ebt_settings\";}s:6:\"module\";a:3:{i:0;s:8:\"ebt_core\";i:1;s:26:\"entity_reference_revisions\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"WJqWWf2uiJH8b576_UiYa5phDxIJKwgJiQjqG9e3TNI\";}s:2:\"id\";s:35:\"block_content.ebt_accordion.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"ebt_accordion\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:19:\"field_ebt_accordion\";a:6:{s:4:\"type\";s:38:\"entity_reference_revisions_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_basic_button.default',	'a:11:{s:4:\"uuid\";s:36:\"e002007d-e402-414c-a43e-0e11a4ff059c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:35:\"block_content.type.ebt_basic_button\";i:1;s:70:\"field.field.block_content.ebt_basic_button.field_ebt_basic_button_link\";i:2;s:61:\"field.field.block_content.ebt_basic_button.field_ebt_settings\";}s:6:\"module\";a:2:{i:0;s:8:\"ebt_core\";i:1;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"D0bWnt-1a4nvpSyJNmrOwKtHeZ4joh72qib-yadGXdo\";}s:2:\"id\";s:38:\"block_content.ebt_basic_button.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:16:\"ebt_basic_button\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:27:\"field_ebt_basic_button_link\";a:6:{s:6:\"weight\";i:1;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:800;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:1:\"0\";s:6:\"target\";s:1:\"0\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:4:\"link\";s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:6:\"weight\";i:2;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:20:\"ebt_settings_default\";s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_block.default',	'a:11:{s:4:\"uuid\";s:36:\"7dac4777-4a33-402e-a4fb-d2ec54e7bdbf\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:28:\"block_content.type.ebt_block\";i:1;s:40:\"field.field.block_content.ebt_block.body\";i:2;s:57:\"field.field.block_content.ebt_block.field_ebt_block_block\";i:3;s:54:\"field.field.block_content.ebt_block.field_ebt_settings\";}s:6:\"module\";a:3:{i:0;s:11:\"block_field\";i:1;s:8:\"ebt_core\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"fbnp4SbjbUUixWLq5rrWDtCZ10d3rhYWoqZRmYFJPfo\";}s:2:\"id\";s:31:\"block_content.ebt_block.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_block\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:21:\"field_ebt_block_block\";a:6:{s:4:\"type\";s:11:\"block_field\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_bootstrap_button.default',	'a:11:{s:4:\"uuid\";s:36:\"8a03d29e-a687-49e7-9a56-0dfe88836e7a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:39:\"block_content.type.ebt_bootstrap_button\";i:1;s:78:\"field.field.block_content.ebt_bootstrap_button.field_ebt_bootstrap_button_link\";i:2;s:65:\"field.field.block_content.ebt_bootstrap_button.field_ebt_settings\";}s:6:\"module\";a:2:{i:0;s:8:\"ebt_core\";i:1;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"B0SuU0apEENhv8h4tMjfQJZqaMhqfIqzm2aj6K7pj8g\";}s:2:\"id\";s:42:\"block_content.ebt_bootstrap_button.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:20:\"ebt_bootstrap_button\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:31:\"field_ebt_bootstrap_button_link\";a:6:{s:6:\"weight\";i:1;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:800;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:1:\"0\";s:6:\"target\";s:1:\"0\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:4:\"link\";s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:6:\"weight\";i:2;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:20:\"ebt_settings_default\";s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_carousel.default',	'a:11:{s:4:\"uuid\";s:36:\"5595a634-71e4-4b9c-840c-c1fcb074609f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:31:\"block_content.type.ebt_carousel\";i:1;s:57:\"field.field.block_content.ebt_carousel.field_ebt_carousel\";i:2;s:57:\"field.field.block_content.ebt_carousel.field_ebt_settings\";}s:6:\"module\";a:2:{i:0;s:8:\"ebt_core\";i:1;s:26:\"entity_reference_revisions\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"XxudurKwt1BsJ27WvP-j9wjYhEJwJoXWpngR6KCPXG8\";}s:2:\"id\";s:34:\"block_content.ebt_carousel.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:12:\"ebt_carousel\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:18:\"field_ebt_carousel\";a:6:{s:4:\"type\";s:38:\"entity_reference_revisions_entity_view\";s:6:\"weight\";i:0;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_columns.default',	'a:11:{s:4:\"uuid\";s:36:\"86bcc126-14bc-40cd-a04a-95794d3f1e10\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:30:\"block_content.type.ebt_columns\";i:1;s:42:\"field.field.block_content.ebt_columns.body\";i:2;s:62:\"field.field.block_content.ebt_columns.field_ebt_columns_blocks\";i:3;s:56:\"field.field.block_content.ebt_columns.field_ebt_settings\";}s:6:\"module\";a:3:{i:0;s:11:\"block_field\";i:1;s:8:\"ebt_core\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"a-6glPDfvKWglLxQBv5i50OSaExRNK8Y9fdSycITPPg\";}s:2:\"id\";s:33:\"block_content.ebt_columns.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_columns\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:24:\"field_ebt_columns_blocks\";a:6:{s:4:\"type\";s:11:\"block_field\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_countdown.default',	'a:11:{s:4:\"uuid\";s:36:\"814b296d-272d-49bd-b543-8a896015c80d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:32:\"block_content.type.ebt_countdown\";i:1;s:44:\"field.field.block_content.ebt_countdown.body\";i:2;s:64:\"field.field.block_content.ebt_countdown.field_ebt_countdown_date\";i:3;s:58:\"field.field.block_content.ebt_countdown.field_ebt_settings\";}s:6:\"module\";a:3:{i:0;s:8:\"datetime\";i:1;s:8:\"ebt_core\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SD9uKkLwTaGxA9CLhoLDWa7OVamzALkQ381JeZFM12Q\";}s:2:\"id\";s:35:\"block_content.ebt_countdown.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"ebt_countdown\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:24:\"field_ebt_countdown_date\";a:6:{s:4:\"type\";s:16:\"datetime_default\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:2:{s:17:\"timezone_override\";s:0:\"\";s:11:\"format_type\";s:6:\"medium\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_counter.default',	'a:11:{s:4:\"uuid\";s:36:\"4117f5ae-b100-40a0-82be-376d1b9cdd5c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:6:{i:0;s:30:\"block_content.type.ebt_counter\";i:1;s:42:\"field.field.block_content.ebt_counter.body\";i:2;s:60:\"field.field.block_content.ebt_counter.field_ebt_counter_icon\";i:3;s:61:\"field.field.block_content.ebt_counter.field_ebt_counter_items\";i:4;s:62:\"field.field.block_content.ebt_counter.field_ebt_counter_number\";i:5;s:56:\"field.field.block_content.ebt_counter.field_ebt_settings\";}s:6:\"module\";a:3:{i:0;s:8:\"ebt_core\";i:1;s:26:\"entity_reference_revisions\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"U0J7ekcnrzJlts3b7XRAuCz6M0oc4laODI1JQpfnSWU\";}s:2:\"id\";s:33:\"block_content.ebt_counter.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_counter\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:23:\"field_ebt_counter_items\";a:6:{s:4:\"type\";s:38:\"entity_reference_revisions_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:2:{s:22:\"field_ebt_counter_icon\";b:1;s:24:\"field_ebt_counter_number\";b:1;}}'),
('',	'core.entity_view_display.block_content.ebt_cta.default',	'a:11:{s:4:\"uuid\";s:36:\"0ad5cd1c-3a95-492c-a42a-3a33aad2fc81\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:7:{i:0;s:26:\"block_content.type.ebt_cta\";i:1;s:38:\"field.field.block_content.ebt_cta.body\";i:2;s:60:\"field.field.block_content.ebt_cta.field_ebt_cta_column_image\";i:3;s:52:\"field.field.block_content.ebt_cta.field_ebt_cta_link\";i:4;s:59:\"field.field.block_content.ebt_cta.field_ebt_cta_second_link\";i:5;s:53:\"field.field.block_content.ebt_cta.field_ebt_cta_title\";i:6;s:52:\"field.field.block_content.ebt_cta.field_ebt_settings\";}s:6:\"module\";a:4:{i:0;s:8:\"ebt_core\";i:1;s:4:\"link\";i:2;s:5:\"media\";i:3;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"rJRx3IkJfHu6PnEX98fydtBu7xtB6TBPxbD0H22l5MY\";}s:2:\"id\";s:29:\"block_content.ebt_cta.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:7:\"ebt_cta\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:6:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:26:\"field_ebt_cta_column_image\";a:6:{s:4:\"type\";s:15:\"media_thumbnail\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_cta_link\";a:6:{s:4:\"type\";s:4:\"link\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:800;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:1:\"0\";s:6:\"target\";s:1:\"0\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";}s:25:\"field_ebt_cta_second_link\";a:6:{s:4:\"type\";s:4:\"link\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:800;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:1:\"0\";s:6:\"target\";s:1:\"0\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";}s:19:\"field_ebt_cta_title\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_hero.default',	'a:11:{s:4:\"uuid\";s:36:\"ef3f9c37-ba74-4569-9402-eb895497b1ee\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:8:{i:0;s:27:\"block_content.type.ebt_hero\";i:1;s:39:\"field.field.block_content.ebt_hero.body\";i:2;s:62:\"field.field.block_content.ebt_hero.field_ebt_hero_column_image\";i:3;s:54:\"field.field.block_content.ebt_hero.field_ebt_hero_link\";i:4;s:61:\"field.field.block_content.ebt_hero.field_ebt_hero_second_link\";i:5;s:55:\"field.field.block_content.ebt_hero.field_ebt_hero_title\";i:6;s:62:\"field.field.block_content.ebt_hero.field_ebt_hero_title_prefix\";i:7;s:53:\"field.field.block_content.ebt_hero.field_ebt_settings\";}s:6:\"module\";a:4:{i:0;s:8:\"ebt_core\";i:1;s:4:\"link\";i:2;s:5:\"media\";i:3;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"XtJum4t5ZIxuZCmM5WqHm32Q5cPXTBC1K_4FK0DKBak\";}s:2:\"id\";s:30:\"block_content.ebt_hero.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_hero\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:7:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:27:\"field_ebt_hero_column_image\";a:6:{s:4:\"type\";s:15:\"media_thumbnail\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:19:\"field_ebt_hero_link\";a:6:{s:4:\"type\";s:4:\"link\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:800;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:1:\"0\";s:6:\"target\";s:1:\"0\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";}s:26:\"field_ebt_hero_second_link\";a:6:{s:4:\"type\";s:4:\"link\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:800;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:1:\"0\";s:6:\"target\";s:1:\"0\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";}s:20:\"field_ebt_hero_title\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:27:\"field_ebt_hero_title_prefix\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:6;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_image.default',	'a:11:{s:4:\"uuid\";s:36:\"2b267e2d-1fdb-48ce-9cb4-9e8ab433ed76\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:28:\"block_content.type.ebt_image\";i:1;s:51:\"field.field.block_content.ebt_image.field_ebt_image\";i:2;s:59:\"field.field.block_content.ebt_image.field_ebt_image_caption\";i:3;s:56:\"field.field.block_content.ebt_image.field_ebt_image_link\";i:4;s:54:\"field.field.block_content.ebt_image.field_ebt_settings\";}s:6:\"module\";a:4:{i:0;s:8:\"ebt_core\";i:1;s:4:\"link\";i:2;s:5:\"media\";i:3;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"D3uYbuXeXgRMCscOC7MzthncsxVzm02BUnKoPT6DgNI\";}s:2:\"id\";s:31:\"block_content.ebt_image.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_image\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:15:\"field_ebt_image\";a:6:{s:4:\"type\";s:15:\"media_thumbnail\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:23:\"field_ebt_image_caption\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";}s:20:\"field_ebt_image_link\";a:6:{s:4:\"type\";s:4:\"link\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:1024;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:1:\"0\";s:6:\"target\";s:1:\"0\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_image_gallery.default',	'a:11:{s:4:\"uuid\";s:36:\"4b5d6bc4-4cc6-4319-a6bf-ffb11737fa1d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:36:\"block_content.type.ebt_image_gallery\";i:1;s:48:\"field.field.block_content.ebt_image_gallery.body\";i:2;s:67:\"field.field.block_content.ebt_image_gallery.field_ebt_image_gallery\";i:3;s:62:\"field.field.block_content.ebt_image_gallery.field_ebt_settings\";}s:6:\"module\";a:2:{i:0;s:8:\"ebt_core\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"vR-7_1M__12ELdq1IjHW5dYHXbjNbXTl83IbuAVADFo\";}s:2:\"id\";s:39:\"block_content.ebt_image_gallery.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:17:\"ebt_image_gallery\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:23:\"field_ebt_image_gallery\";a:6:{s:4:\"type\";s:28:\"entity_reference_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_micromodal.default',	'a:11:{s:4:\"uuid\";s:36:\"f5514d94-f0a7-4adb-af94-b565702bcb87\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:33:\"block_content.type.ebt_micromodal\";i:1;s:45:\"field.field.block_content.ebt_micromodal.body\";i:2;s:67:\"field.field.block_content.ebt_micromodal.field_ebt_micromodal_title\";i:3;s:59:\"field.field.block_content.ebt_micromodal.field_ebt_settings\";}s:6:\"module\";a:2:{i:0;s:8:\"ebt_core\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"UuFtw5Q8hlkws7oxPOMwDUQdLg1VvFThNrchcXpdFdc\";}s:2:\"id\";s:36:\"block_content.ebt_micromodal.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:14:\"ebt_micromodal\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:26:\"field_ebt_micromodal_title\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_quote.default',	'a:11:{s:4:\"uuid\";s:36:\"7606605a-9eff-4f52-aff9-3a7d785bb2a3\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:6:{i:0;s:28:\"block_content.type.ebt_quote\";i:1;s:40:\"field.field.block_content.ebt_quote.body\";i:2;s:58:\"field.field.block_content.ebt_quote.field_ebt_quote_author\";i:3;s:57:\"field.field.block_content.ebt_quote.field_ebt_quote_image\";i:4;s:54:\"field.field.block_content.ebt_quote.field_ebt_settings\";i:5;s:23:\"image.style.quote_image\";}s:6:\"module\";a:3:{i:0;s:8:\"ebt_core\";i:1;s:5:\"media\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"xpCHQRrtCqVeeuVSJ231HGw2oStHov2UFyb3zRr3Oik\";}s:2:\"id\";s:31:\"block_content.ebt_quote.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_quote\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:22:\"field_ebt_quote_author\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:21:\"field_ebt_quote_image\";a:6:{s:4:\"type\";s:15:\"media_thumbnail\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:11:\"quote_image\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_slick_slider.default',	'a:11:{s:4:\"uuid\";s:36:\"8feddd3f-45a8-46bf-a16f-2be6634a45ea\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:35:\"block_content.type.ebt_slick_slider\";i:1;s:47:\"field.field.block_content.ebt_slick_slider.body\";i:2;s:61:\"field.field.block_content.ebt_slick_slider.field_ebt_settings\";i:3;s:65:\"field.field.block_content.ebt_slick_slider.field_ebt_slick_slider\";}s:6:\"module\";a:3:{i:0;s:8:\"ebt_core\";i:1;s:26:\"entity_reference_revisions\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"hPQzjkILUgWxfntdmuZ6HzJR7VFbSsJzCXcSrlrzRdY\";}s:2:\"id\";s:38:\"block_content.ebt_slick_slider.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:16:\"ebt_slick_slider\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:22:\"field_ebt_slick_slider\";a:6:{s:4:\"type\";s:38:\"entity_reference_revisions_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_slideshow.default',	'a:11:{s:4:\"uuid\";s:36:\"764e5ba9-f7cd-4885-88bb-ab706b279f69\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:32:\"block_content.type.ebt_slideshow\";i:1;s:58:\"field.field.block_content.ebt_slideshow.field_ebt_settings\";i:2;s:59:\"field.field.block_content.ebt_slideshow.field_ebt_slideshow\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"mtWCnFfgKEeW85VC8B0w6c1438S-bOGUJEppAIJAakE\";}s:2:\"id\";s:35:\"block_content.ebt_slideshow.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"ebt_slideshow\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:1:{s:19:\"field_ebt_slideshow\";a:6:{s:4:\"type\";s:38:\"entity_reference_revisions_entity_view\";s:6:\"weight\";i:0;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:1:{s:18:\"field_ebt_settings\";b:1;}}'),
('',	'core.entity_view_display.block_content.ebt_stats.default',	'a:11:{s:4:\"uuid\";s:36:\"8c54cc11-1b16-48f3-a610-44727c203a3d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:28:\"block_content.type.ebt_stats\";i:1;s:40:\"field.field.block_content.ebt_stats.body\";i:2;s:54:\"field.field.block_content.ebt_stats.field_ebt_settings\";i:3;s:51:\"field.field.block_content.ebt_stats.field_ebt_stats\";}s:6:\"module\";a:3:{i:0;s:8:\"ebt_core\";i:1;s:26:\"entity_reference_revisions\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"M6fW5L7z_DmzcpI5BCl95NixIxJEv1cpCEL2n4x9zpo\";}s:2:\"id\";s:31:\"block_content.ebt_stats.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_stats\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:15:\"field_ebt_stats\";a:6:{s:4:\"type\";s:38:\"entity_reference_revisions_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_tabs.default',	'a:11:{s:4:\"uuid\";s:36:\"62183f0d-0b60-47ba-bb16-40798a4776ef\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:27:\"block_content.type.ebt_tabs\";i:1;s:53:\"field.field.block_content.ebt_tabs.field_ebt_settings\";i:2;s:49:\"field.field.block_content.ebt_tabs.field_ebt_tabs\";}s:6:\"module\";a:2:{i:0;s:8:\"ebt_core\";i:1;s:26:\"entity_reference_revisions\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"I2VT_ayFTNxciojtahrIwigBhAXkhZMO4_sAejsopW0\";}s:2:\"id\";s:30:\"block_content.ebt_tabs.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_tabs\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:14:\"field_ebt_tabs\";a:6:{s:4:\"type\";s:38:\"entity_reference_revisions_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_text.default',	'a:11:{s:4:\"uuid\";s:36:\"b33df2ac-91d5-4257-bfa4-bb4911c6a960\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:27:\"block_content.type.ebt_text\";i:1;s:39:\"field.field.block_content.ebt_text.body\";i:2;s:53:\"field.field.block_content.ebt_text.field_ebt_settings\";}s:6:\"module\";a:2:{i:0;s:8:\"ebt_core\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"l_0JH2bJx47kWrf-7eYOBgwIV1dRWjVeLv68ugJKxso\";}s:2:\"id\";s:30:\"block_content.ebt_text.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_text\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:4:\"body\";a:6:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:6:\"weight\";i:1;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:20:\"ebt_settings_default\";s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_tiles.default',	'a:11:{s:4:\"uuid\";s:36:\"fb6bfaa3-7636-41c1-a411-dff1def2fef0\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:28:\"block_content.type.ebt_tiles\";i:1;s:40:\"field.field.block_content.ebt_tiles.body\";i:2;s:54:\"field.field.block_content.ebt_tiles.field_ebt_settings\";i:3;s:51:\"field.field.block_content.ebt_tiles.field_ebt_tiles\";}s:6:\"module\";a:3:{i:0;s:8:\"ebt_core\";i:1;s:26:\"entity_reference_revisions\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"rX3FVFGQ9cD5O0wbYbIxbj872CHdsK9aIut1PNuAeVI\";}s:2:\"id\";s:31:\"block_content.ebt_tiles.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_tiles\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:15:\"field_ebt_tiles\";a:6:{s:4:\"type\";s:38:\"entity_reference_revisions_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_timeline.default',	'a:11:{s:4:\"uuid\";s:36:\"1395e5da-67f6-420f-a32d-094a7d218bd0\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:31:\"block_content.type.ebt_timeline\";i:1;s:57:\"field.field.block_content.ebt_timeline.field_ebt_settings\";i:2;s:57:\"field.field.block_content.ebt_timeline.field_ebt_timeline\";}s:6:\"module\";a:2:{i:0;s:8:\"ebt_core\";i:1;s:26:\"entity_reference_revisions\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"bfJtQm_JGhXjpffKuejK_QMbyA4fxEqMrVt-N98sqZo\";}s:2:\"id\";s:34:\"block_content.ebt_timeline.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:12:\"ebt_timeline\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:18:\"field_ebt_settings\";a:6:{s:6:\"weight\";i:1;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:20:\"ebt_settings_default\";s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_timeline\";a:6:{s:4:\"type\";s:38:\"entity_reference_revisions_entity_view\";s:6:\"weight\";i:2;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_video.default',	'a:11:{s:4:\"uuid\";s:36:\"96a65454-d2c6-4d47-8247-42a53fffe403\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:28:\"block_content.type.ebt_video\";i:1;s:40:\"field.field.block_content.ebt_video.body\";i:2;s:54:\"field.field.block_content.ebt_video.field_ebt_settings\";i:3;s:51:\"field.field.block_content.ebt_video.field_ebt_video\";}s:6:\"module\";a:2:{i:0;s:8:\"ebt_core\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2csH7beKeLrgGpTLBYSVXXoJzKb7u0PjD1AUlW6AzbU\";}s:2:\"id\";s:31:\"block_content.ebt_video.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_video\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:15:\"field_ebt_video\";a:6:{s:4:\"type\";s:28:\"entity_reference_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:9:\"ebt_video\";s:4:\"link\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_video_and_image_gallery.default',	'a:11:{s:4:\"uuid\";s:36:\"b7590d64-18fe-489a-8317-2999e71355e3\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:46:\"block_content.type.ebt_video_and_image_gallery\";i:1;s:58:\"field.field.block_content.ebt_video_and_image_gallery.body\";i:2;s:72:\"field.field.block_content.ebt_video_and_image_gallery.field_ebt_settings\";i:3;s:81:\"field.field.block_content.ebt_video_and_image_gallery.field_ebt_videos_and_images\";}s:6:\"module\";a:3:{i:0;s:8:\"ebt_core\";i:1;s:26:\"entity_reference_revisions\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"GRVAFs0nqUHdsiSZnjDv7msUFBQh_m8jr87a-UZhMEs\";}s:2:\"id\";s:49:\"block_content.ebt_video_and_image_gallery.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:27:\"ebt_video_and_image_gallery\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:27:\"field_ebt_videos_and_images\";a:6:{s:4:\"type\";s:38:\"entity_reference_revisions_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_views.default',	'a:11:{s:4:\"uuid\";s:36:\"65ebcab1-d240-4884-855d-df0c65f731df\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:28:\"block_content.type.ebt_views\";i:1;s:40:\"field.field.block_content.ebt_views.body\";i:2;s:54:\"field.field.block_content.ebt_views.field_ebt_settings\";i:3;s:57:\"field.field.block_content.ebt_views.field_ebt_views_views\";}s:6:\"module\";a:3:{i:0;s:8:\"ebt_core\";i:1;s:4:\"text\";i:2;s:14:\"viewsreference\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"P_rfCoJ0TGHiNoFYHjaR-ngK4cjbqANziLUpxF5UBZM\";}s:2:\"id\";s:31:\"block_content.ebt_views.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_views\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:4:\"type\";s:20:\"ebt_settings_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:21:\"field_ebt_views_views\";a:6:{s:4:\"type\";s:24:\"viewsreference_formatter\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:12:\"plugin_types\";a:5:{s:4:\"page\";s:4:\"page\";s:5:\"block\";s:5:\"block\";s:7:\"default\";s:1:\"0\";s:4:\"feed\";s:1:\"0\";s:5:\"embed\";s:1:\"0\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_webform.default',	'a:11:{s:4:\"uuid\";s:36:\"dc06c30d-3cfa-4f39-809f-8390cd056466\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:30:\"block_content.type.ebt_webform\";i:1;s:42:\"field.field.block_content.ebt_webform.body\";i:2;s:56:\"field.field.block_content.ebt_webform.field_ebt_settings\";i:3;s:60:\"field.field.block_content.ebt_webform.field_ebt_webform_form\";}s:6:\"module\";a:3:{i:0;s:8:\"ebt_core\";i:1;s:4:\"text\";i:2;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"gpru4Rd0T0JY8wkKLrvgy_u9NIovpL4X5IKCjcykrUE\";}s:2:\"id\";s:33:\"block_content.ebt_webform.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_webform\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_settings\";a:6:{s:6:\"weight\";i:3;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:20:\"ebt_settings_default\";s:6:\"region\";s:7:\"content\";}s:22:\"field_ebt_webform_form\";a:6:{s:6:\"weight\";i:2;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:13:\"source_entity\";b:1;}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:36:\"webform_entity_reference_entity_view\";s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.block_content.ebt_webform_popup.default',	'a:11:{s:4:\"uuid\";s:36:\"8d599765-5bbf-4aff-b2cb-bd108e6c5046\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:36:\"block_content.type.ebt_webform_popup\";i:1;s:62:\"field.field.block_content.ebt_webform_popup.field_ebt_settings\";i:2;s:72:\"field.field.block_content.ebt_webform_popup.field_ebt_webform_popup_form\";}s:6:\"module\";a:2:{i:0;s:8:\"ebt_core\";i:1;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"AkhheynCt4FPPMFnHY7nwaoh-xmCWBAFHkUSVVu-DN8\";}s:2:\"id\";s:39:\"block_content.ebt_webform_popup.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:17:\"ebt_webform_popup\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:18:\"field_ebt_settings\";a:6:{s:6:\"weight\";i:2;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:20:\"ebt_settings_default\";s:6:\"region\";s:7:\"content\";}s:28:\"field_ebt_webform_popup_form\";a:6:{s:6:\"weight\";i:1;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:13:\"source_entity\";b:1;}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:36:\"webform_entity_reference_entity_view\";s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.media.audio.default',	'a:11:{s:4:\"uuid\";s:36:\"38a6ca87-814c-4d4a-b346-9326e4c72021\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:46:\"field.field.media.audio.field_media_audio_file\";i:1;s:16:\"media.type.audio\";}s:6:\"module\";a:1:{i:0;s:4:\"file\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"AS765MdDfNpK6K5eE7WVnBvpynClz_havy1R3bO3gVo\";}s:2:\"id\";s:19:\"media.audio.default\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:5:\"audio\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:1:{s:22:\"field_media_audio_file\";a:6:{s:4:\"type\";s:10:\"file_audio\";s:5:\"label\";s:15:\"visually_hidden\";s:8:\"settings\";a:4:{s:8:\"controls\";b:1;s:8:\"autoplay\";b:0;s:4:\"loop\";b:0;s:26:\"multiple_file_display_type\";s:4:\"tags\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:7:\"created\";b:1;s:4:\"name\";b:1;s:9:\"thumbnail\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_view_display.media.audio.media_library',	'a:11:{s:4:\"uuid\";s:36:\"ede5e29a-aefb-40b5-9859-1ac8ed22e499\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:41:\"core.entity_view_mode.media.media_library\";i:1;s:46:\"field.field.media.audio.field_media_audio_file\";i:2;s:21:\"image.style.thumbnail\";i:3;s:16:\"media.type.audio\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"tcAUW1Xzq5Tjw5jomR6XKGSgfiXO7QiRAHJBF-n0akg\";}s:2:\"id\";s:25:\"media.audio.media_library\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:5:\"audio\";s:4:\"mode\";s:13:\"media_library\";s:7:\"content\";a:1:{s:9:\"thumbnail\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:11:\"image_style\";s:9:\"thumbnail\";s:10:\"image_link\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:7:\"created\";b:1;s:22:\"field_media_audio_file\";b:1;s:4:\"name\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_view_display.media.document.default',	'a:11:{s:4:\"uuid\";s:36:\"beb45182-e505-48ae-a153-5d34274d8013\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:47:\"field.field.media.document.field_media_document\";i:1;s:19:\"media.type.document\";}s:6:\"module\";a:1:{i:0;s:4:\"file\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"XxUyhaTuM0OUUZpr8G6jdrFBEh5eag7auWxBKhm6cvY\";}s:2:\"id\";s:22:\"media.document.default\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:8:\"document\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:1:{s:20:\"field_media_document\";a:6:{s:4:\"type\";s:12:\"file_default\";s:5:\"label\";s:15:\"visually_hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:7:\"created\";b:1;s:4:\"name\";b:1;s:9:\"thumbnail\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_view_display.media.document.media_library',	'a:11:{s:4:\"uuid\";s:36:\"b0e61493-d3f5-4a7d-8ead-492300acdf21\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:41:\"core.entity_view_mode.media.media_library\";i:1;s:47:\"field.field.media.document.field_media_document\";i:2;s:21:\"image.style.thumbnail\";i:3;s:19:\"media.type.document\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"YcWqjhIlo-2RZUM5ogvRsrKB7M3voF2XB3lVLwgOlLU\";}s:2:\"id\";s:28:\"media.document.media_library\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:8:\"document\";s:4:\"mode\";s:13:\"media_library\";s:7:\"content\";a:1:{s:9:\"thumbnail\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:11:\"image_style\";s:9:\"thumbnail\";s:10:\"image_link\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:7:\"created\";b:1;s:20:\"field_media_document\";b:1;s:4:\"name\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_view_display.media.image.default',	'a:11:{s:4:\"uuid\";s:36:\"c80bfe30-db84-4270-a319-1c27729f2edf\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:41:\"field.field.media.image.field_media_image\";i:1;s:17:\"image.style.large\";i:2;s:16:\"media.type.image\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"73xaTNkI5J6sfFcBmNYeuk070X3mQS_iwwWaPYyfG2M\";}s:2:\"id\";s:19:\"media.image.default\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:5:\"image\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:1:{s:17:\"field_media_image\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:15:\"visually_hidden\";s:8:\"settings\";a:3:{s:11:\"image_style\";s:5:\"large\";s:10:\"image_link\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:7:\"created\";b:1;s:4:\"name\";b:1;s:9:\"thumbnail\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_view_display.media.image.ebt_image_gallery',	'a:11:{s:4:\"uuid\";s:36:\"a35ebe6b-2715-41f7-a570-96ae3af68c78\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:45:\"core.entity_view_mode.media.ebt_image_gallery\";i:1;s:41:\"field.field.media.image.field_media_image\";i:2;s:29:\"image.style.ebt_gallery_image\";i:3;s:16:\"media.type.image\";}s:6:\"module\";a:1:{i:0;s:9:\"glightbox\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"9KEafftKnenx_jl3tACupmwb0WA-eaq31pCE89gmGaY\";}s:2:\"id\";s:29:\"media.image.ebt_image_gallery\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:5:\"image\";s:4:\"mode\";s:17:\"ebt_image_gallery\";s:7:\"content\";a:1:{s:17:\"field_media_image\";a:6:{s:4:\"type\";s:9:\"glightbox\";s:5:\"label\";s:15:\"visually_hidden\";s:8:\"settings\";a:7:{s:20:\"glightbox_node_style\";s:17:\"ebt_gallery_image\";s:26:\"glightbox_node_style_first\";s:17:\"ebt_gallery_image\";s:21:\"glightbox_image_style\";s:0:\"\";s:17:\"glightbox_gallery\";s:6:\"parent\";s:24:\"glightbox_gallery_custom\";s:0:\"\";s:17:\"glightbox_caption\";s:4:\"auto\";s:24:\"glightbox_caption_custom\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:7:\"created\";b:1;s:4:\"name\";b:1;s:9:\"thumbnail\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_view_display.media.image.media_library',	'a:11:{s:4:\"uuid\";s:36:\"f69a9286-8f3b-42cf-a15a-5f569ca96e99\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:41:\"core.entity_view_mode.media.media_library\";i:1;s:41:\"field.field.media.image.field_media_image\";i:2;s:18:\"image.style.medium\";i:3;s:16:\"media.type.image\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ILLWu5KFvbsX6J7sh2Itd4w8-lBBRhR_H8ZrmQiN2yo\";}s:2:\"id\";s:25:\"media.image.media_library\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:5:\"image\";s:4:\"mode\";s:13:\"media_library\";s:7:\"content\";a:1:{s:9:\"thumbnail\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:7:\"created\";b:1;s:17:\"field_media_image\";b:1;s:4:\"name\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_view_display.media.image.video_and_image_gallery_item',	'a:11:{s:4:\"uuid\";s:36:\"513a5e40-b967-4358-8200-0c9cd79302cb\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:56:\"core.entity_view_mode.media.video_and_image_gallery_item\";i:1;s:41:\"field.field.media.image.field_media_image\";i:2;s:39:\"image.style.ebt_video_and_image_gallery\";i:3;s:16:\"media.type.image\";}s:6:\"module\";a:1:{i:0;s:9:\"glightbox\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"71w4ybrqWdKueRDFJwcgki2l30Gpyrl7WRkhoMS7C6M\";}s:2:\"id\";s:40:\"media.image.video_and_image_gallery_item\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:5:\"image\";s:4:\"mode\";s:28:\"video_and_image_gallery_item\";s:7:\"content\";a:1:{s:17:\"field_media_image\";a:6:{s:4:\"type\";s:9:\"glightbox\";s:5:\"label\";s:15:\"visually_hidden\";s:8:\"settings\";a:7:{s:20:\"glightbox_node_style\";s:27:\"ebt_video_and_image_gallery\";s:26:\"glightbox_node_style_first\";s:0:\"\";s:21:\"glightbox_image_style\";s:0:\"\";s:17:\"glightbox_gallery\";s:9:\"paragraph\";s:24:\"glightbox_gallery_custom\";s:0:\"\";s:17:\"glightbox_caption\";s:4:\"auto\";s:24:\"glightbox_caption_custom\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:7:\"created\";b:1;s:4:\"name\";b:1;s:9:\"thumbnail\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_view_display.media.remote_video.default',	'a:11:{s:4:\"uuid\";s:36:\"7b9a2dff-1714-4265-92f5-b08cb9237f6b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:55:\"field.field.media.remote_video.field_media_oembed_video\";i:1;s:23:\"media.type.remote_video\";}s:6:\"module\";a:1:{i:0;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ZdPcl2hPxl5pgv3pI-07R7h51OjeUeKJTy-ab1NfM34\";}s:2:\"id\";s:26:\"media.remote_video.default\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:12:\"remote_video\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:1:{s:24:\"field_media_oembed_video\";a:6:{s:4:\"type\";s:6:\"oembed\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:9:\"max_width\";i:0;s:10:\"max_height\";i:0;s:7:\"loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:7:\"created\";b:1;s:4:\"name\";b:1;s:9:\"thumbnail\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_view_display.media.remote_video.ebt_video',	'a:11:{s:4:\"uuid\";s:36:\"1e1b792b-f71b-470f-9810-bc2e2d11f17f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:37:\"core.entity_view_mode.media.ebt_video\";i:1;s:55:\"field.field.media.remote_video.field_media_oembed_video\";i:2;s:23:\"media.type.remote_video\";}s:6:\"module\";a:1:{i:0;s:21:\"glightbox_media_video\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"NHnPc8vxx5bXjFmHokLtYvI3ebeo_FybRqjMNEhIVOg\";}s:2:\"id\";s:28:\"media.remote_video.ebt_video\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:12:\"remote_video\";s:4:\"mode\";s:9:\"ebt_video\";s:7:\"content\";a:1:{s:24:\"field_media_oembed_video\";a:6:{s:4:\"type\";s:28:\"glightbox_media_remote_video\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:10:{s:9:\"max_width\";s:1:\"0\";s:10:\"max_height\";s:1:\"0\";s:7:\"loading\";a:1:{s:9:\"attribute\";s:5:\"eager\";}s:7:\"display\";s:9:\"thumbnail\";s:9:\"link_text\";s:10:\"View Video\";s:11:\"image_style\";s:0:\"\";s:17:\"glightbox_gallery\";s:4:\"post\";s:24:\"glightbox_gallery_custom\";s:0:\"\";s:17:\"glightbox_caption\";s:4:\"auto\";s:24:\"glightbox_caption_custom\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:7:\"created\";b:1;s:4:\"name\";b:1;s:9:\"thumbnail\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_view_display.media.remote_video.media_library',	'a:11:{s:4:\"uuid\";s:36:\"e91b1f8e-5ba5-485e-9c6e-04afe2948e85\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:41:\"core.entity_view_mode.media.media_library\";i:1;s:55:\"field.field.media.remote_video.field_media_oembed_video\";i:2;s:18:\"image.style.medium\";i:3;s:23:\"media.type.remote_video\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"PGGoP-hVkXe_S-GiJRAub4PHDu0KhMExylclrqjdJb4\";}s:2:\"id\";s:32:\"media.remote_video.media_library\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:12:\"remote_video\";s:4:\"mode\";s:13:\"media_library\";s:7:\"content\";a:1:{s:9:\"thumbnail\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:7:\"created\";b:1;s:24:\"field_media_oembed_video\";b:1;s:4:\"name\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_view_display.media.remote_video.video_and_image_gallery_item',	'a:11:{s:4:\"uuid\";s:36:\"9672ae47-7a64-49d5-904a-cba847d9377d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:56:\"core.entity_view_mode.media.video_and_image_gallery_item\";i:1;s:55:\"field.field.media.remote_video.field_media_oembed_video\";i:2;s:23:\"media.type.remote_video\";}s:6:\"module\";a:1:{i:0;s:21:\"glightbox_media_video\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"0gtodl3N0wRFdXaP60sG0h05qbgCOF8wy6ggVWOa8UY\";}s:2:\"id\";s:47:\"media.remote_video.video_and_image_gallery_item\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:12:\"remote_video\";s:4:\"mode\";s:28:\"video_and_image_gallery_item\";s:7:\"content\";a:1:{s:24:\"field_media_oembed_video\";a:6:{s:4:\"type\";s:28:\"glightbox_media_remote_video\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:10:{s:9:\"max_width\";s:1:\"0\";s:10:\"max_height\";s:1:\"0\";s:7:\"loading\";a:1:{s:9:\"attribute\";s:5:\"eager\";}s:7:\"display\";s:9:\"thumbnail\";s:9:\"link_text\";s:10:\"View Video\";s:11:\"image_style\";s:27:\"ebt_video_and_image_gallery\";s:17:\"glightbox_gallery\";s:9:\"paragraph\";s:24:\"glightbox_gallery_custom\";s:0:\"\";s:17:\"glightbox_caption\";s:4:\"auto\";s:24:\"glightbox_caption_custom\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:7:\"created\";b:1;s:4:\"name\";b:1;s:9:\"thumbnail\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_view_display.media.video.default',	'a:11:{s:4:\"uuid\";s:36:\"863188fb-17da-49e4-8e79-ddeb23903eef\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:46:\"field.field.media.video.field_media_video_file\";i:1;s:16:\"media.type.video\";}s:6:\"module\";a:1:{i:0;s:4:\"file\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SxvbuGh-6cQMxl9bBV27-hGI46u7ZvwlMm5ObaJMNnw\";}s:2:\"id\";s:19:\"media.video.default\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:5:\"video\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:1:{s:22:\"field_media_video_file\";a:6:{s:4:\"type\";s:10:\"file_video\";s:5:\"label\";s:15:\"visually_hidden\";s:8:\"settings\";a:7:{s:8:\"controls\";b:1;s:8:\"autoplay\";b:0;s:4:\"loop\";b:0;s:26:\"multiple_file_display_type\";s:4:\"tags\";s:5:\"muted\";b:0;s:5:\"width\";i:640;s:6:\"height\";i:480;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:7:\"created\";b:1;s:4:\"name\";b:1;s:9:\"thumbnail\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_view_display.media.video.ebt_video',	'a:11:{s:4:\"uuid\";s:36:\"7bab1942-d337-4497-a621-f6cc29536967\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:37:\"core.entity_view_mode.media.ebt_video\";i:1;s:46:\"field.field.media.video.field_media_video_file\";i:2;s:16:\"media.type.video\";}s:6:\"module\";a:1:{i:0;s:4:\"file\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"PhLS2RcsgmXaRpOr6Z569J0KXiE9KNW5OMTC9dvUTkg\";}s:2:\"id\";s:21:\"media.video.ebt_video\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:5:\"video\";s:4:\"mode\";s:9:\"ebt_video\";s:7:\"content\";a:1:{s:22:\"field_media_video_file\";a:6:{s:4:\"type\";s:10:\"file_video\";s:5:\"label\";s:15:\"visually_hidden\";s:8:\"settings\";a:7:{s:8:\"controls\";b:1;s:8:\"autoplay\";b:0;s:4:\"loop\";b:0;s:26:\"multiple_file_display_type\";s:4:\"tags\";s:5:\"muted\";b:0;s:5:\"width\";i:640;s:6:\"height\";i:480;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:7:\"created\";b:1;s:4:\"name\";b:1;s:9:\"thumbnail\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_view_display.media.video.media_library',	'a:11:{s:4:\"uuid\";s:36:\"d00b3c78-35a0-460e-a063-a98a387591cc\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:41:\"core.entity_view_mode.media.media_library\";i:1;s:46:\"field.field.media.video.field_media_video_file\";i:2;s:21:\"image.style.thumbnail\";i:3;s:16:\"media.type.video\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"_fnkUKwQYHkXO1Ngmq9nE6FqWUNAmkddOxAH1h5aiKg\";}s:2:\"id\";s:25:\"media.video.media_library\";s:16:\"targetEntityType\";s:5:\"media\";s:6:\"bundle\";s:5:\"video\";s:4:\"mode\";s:13:\"media_library\";s:7:\"content\";a:1:{s:9:\"thumbnail\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:11:\"image_style\";s:9:\"thumbnail\";s:10:\"image_link\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:7:\"created\";b:1;s:22:\"field_media_video_file\";b:1;s:4:\"name\";b:1;s:3:\"uid\";b:1;}}'),
('',	'core.entity_view_display.node.article.default',	'a:12:{s:4:\"uuid\";s:36:\"97d9050c-f2b4-4b7e-9f3f-10de564e06a0\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:6:{i:0;s:29:\"field.field.node.article.body\";i:1;s:36:\"field.field.node.article.field_image\";i:2;s:39:\"field.field.node.article.field_metatags\";i:3;s:35:\"field.field.node.article.field_tags\";i:4;s:16:\"image.style.wide\";i:5;s:17:\"node.type.article\";}s:6:\"module\";a:5:{i:0;s:14:\"layout_builder\";i:1;s:7:\"metatag\";i:2;s:9:\"svg_image\";i:3;s:4:\"text\";i:4;s:4:\"user\";}}s:20:\"third_party_settings\";a:1:{s:14:\"layout_builder\";a:3:{s:7:\"enabled\";b:1;s:12:\"allow_custom\";b:1;s:8:\"sections\";a:1:{i:0;a:4:{s:9:\"layout_id\";s:13:\"layout_onecol\";s:15:\"layout_settings\";a:1:{s:5:\"label\";s:0:\"\";}s:10:\"components\";a:5:{s:36:\"3120cf62-1cc1-4e2b-96e0-0996d5d6928a\";a:5:{s:4:\"uuid\";s:36:\"3120cf62-1cc1-4e2b-96e0-0996d5d6928a\";s:6:\"region\";s:7:\"content\";s:13:\"configuration\";a:4:{s:2:\"id\";s:36:\"field_block:node:article:field_image\";s:13:\"label_display\";s:1:\"0\";s:15:\"context_mapping\";a:1:{s:6:\"entity\";s:21:\"layout_builder.entity\";}s:9:\"formatter\";a:4:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:4:\"wide\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:5:\"eager\";}s:14:\"svg_attributes\";a:2:{s:5:\"width\";N;s:6:\"height\";N;}s:19:\"svg_render_as_image\";b:1;}s:20:\"third_party_settings\";a:0:{}}}s:6:\"weight\";i:0;s:10:\"additional\";a:0:{}}s:36:\"7f5f46b4-472b-4e74-9a01-8a03e0321444\";a:5:{s:4:\"uuid\";s:36:\"7f5f46b4-472b-4e74-9a01-8a03e0321444\";s:6:\"region\";s:7:\"content\";s:13:\"configuration\";a:4:{s:2:\"id\";s:29:\"field_block:node:article:body\";s:13:\"label_display\";s:1:\"0\";s:15:\"context_mapping\";a:1:{s:6:\"entity\";s:21:\"layout_builder.entity\";}s:9:\"formatter\";a:4:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}}s:6:\"weight\";i:1;s:10:\"additional\";a:0:{}}s:36:\"b902a34b-a3ce-4efc-a85b-86bb824651b9\";a:5:{s:4:\"uuid\";s:36:\"b902a34b-a3ce-4efc-a85b-86bb824651b9\";s:6:\"region\";s:7:\"content\";s:13:\"configuration\";a:4:{s:2:\"id\";s:35:\"field_block:node:article:field_tags\";s:13:\"label_display\";s:1:\"0\";s:15:\"context_mapping\";a:1:{s:6:\"entity\";s:21:\"layout_builder.entity\";}s:9:\"formatter\";a:4:{s:4:\"type\";s:22:\"entity_reference_label\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:1:{s:4:\"link\";b:1;}s:20:\"third_party_settings\";a:0:{}}}s:6:\"weight\";i:2;s:10:\"additional\";a:0:{}}s:36:\"25d5958c-bea2-4027-8bae-b924b89dce41\";a:5:{s:4:\"uuid\";s:36:\"25d5958c-bea2-4027-8bae-b924b89dce41\";s:6:\"region\";s:7:\"content\";s:13:\"configuration\";a:3:{s:2:\"id\";s:36:\"extra_field_block:node:article:links\";s:13:\"label_display\";s:1:\"0\";s:15:\"context_mapping\";a:1:{s:6:\"entity\";s:21:\"layout_builder.entity\";}}s:6:\"weight\";i:3;s:10:\"additional\";a:0:{}}s:36:\"667348d3-3500-418a-b027-8b25f62317df\";a:5:{s:4:\"uuid\";s:36:\"667348d3-3500-418a-b027-8b25f62317df\";s:6:\"region\";s:7:\"content\";s:13:\"configuration\";a:4:{s:2:\"id\";s:39:\"field_block:node:article:field_metatags\";s:13:\"label_display\";s:1:\"0\";s:15:\"context_mapping\";a:1:{s:6:\"entity\";s:21:\"layout_builder.entity\";}s:9:\"formatter\";a:4:{s:4:\"type\";s:23:\"metatag_empty_formatter\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}}s:6:\"weight\";i:4;s:10:\"additional\";a:0:{}}}s:20:\"third_party_settings\";a:0:{}}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"br6izr-iGEu--JvNbCJNtOBpRnxpFLXfoV5y61U9Nqc\";}s:2:\"id\";s:20:\"node.article.default\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:11:\"field_image\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:4:\"wide\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:5:\"eager\";}s:14:\"svg_attributes\";a:2:{s:5:\"width\";N;s:6:\"height\";N;}s:19:\"svg_render_as_image\";b:1;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:-1;s:6:\"region\";s:7:\"content\";}s:14:\"field_metatags\";a:6:{s:4:\"type\";s:23:\"metatag_empty_formatter\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:101;s:6:\"region\";s:7:\"content\";}s:10:\"field_tags\";a:6:{s:4:\"type\";s:22:\"entity_reference_label\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:1:{s:4:\"link\";b:1;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:10;s:6:\"region\";s:7:\"content\";}s:5:\"links\";a:4:{s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:100;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.node.article.rss',	'a:11:{s:4:\"uuid\";s:36:\"2e2f92c3-c50a-4139-9c95-4e46ce1f757d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:7:{i:0;s:30:\"core.entity_view_mode.node.rss\";i:1;s:29:\"field.field.node.article.body\";i:2;s:36:\"field.field.node.article.field_image\";i:3;s:39:\"field.field.node.article.field_metatags\";i:4;s:35:\"field.field.node.article.field_tags\";i:5;s:47:\"field.field.node.article.layout_builder__layout\";i:6;s:17:\"node.type.article\";}s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2rIr6K5Q0UQ9khg0zE_CK-PtJH76UL-BDDZcZnZzwCc\";}s:2:\"id\";s:16:\"node.article.rss\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:4:\"mode\";s:3:\"rss\";s:7:\"content\";a:1:{s:5:\"links\";a:2:{s:6:\"weight\";i:100;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:5:{s:4:\"body\";b:1;s:11:\"field_image\";b:1;s:14:\"field_metatags\";b:1;s:10:\"field_tags\";b:1;s:22:\"layout_builder__layout\";b:1;}}'),
('',	'core.entity_view_display.node.article.teaser',	'a:11:{s:4:\"uuid\";s:36:\"08318816-b086-4cdd-b48c-c020f5a6f328\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:8:{i:0;s:33:\"core.entity_view_mode.node.teaser\";i:1;s:29:\"field.field.node.article.body\";i:2;s:36:\"field.field.node.article.field_image\";i:3;s:39:\"field.field.node.article.field_metatags\";i:4;s:35:\"field.field.node.article.field_tags\";i:5;s:47:\"field.field.node.article.layout_builder__layout\";i:6;s:18:\"image.style.medium\";i:7;s:17:\"node.type.article\";}s:6:\"module\";a:3:{i:0;s:9:\"svg_image\";i:1;s:4:\"text\";i:2;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"O8PxzfG8DOHHRu6M23kwR6TDPq_MNfYQ10Mp367ICUQ\";}s:2:\"id\";s:19:\"node.article.teaser\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:4:\"mode\";s:6:\"teaser\";s:7:\"content\";a:4:{s:4:\"body\";a:6:{s:4:\"type\";s:23:\"text_summary_or_trimmed\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:11:\"trim_length\";i:600;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:11:\"field_image\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:7:\"content\";s:11:\"image_style\";s:6:\"medium\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:-1;s:6:\"region\";s:7:\"content\";}s:10:\"field_tags\";a:6:{s:4:\"type\";s:22:\"entity_reference_label\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:1:{s:4:\"link\";b:1;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:10;s:6:\"region\";s:7:\"content\";}s:5:\"links\";a:2:{s:6:\"weight\";i:100;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:2:{s:14:\"field_metatags\";b:1;s:22:\"layout_builder__layout\";b:1;}}'),
('',	'core.entity_view_display.node.page.default',	'a:12:{s:4:\"uuid\";s:36:\"5aaa71f3-3511-4b50-8003-331c936478f3\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:26:\"field.field.node.page.body\";i:1;s:36:\"field.field.node.page.field_metatags\";i:2;s:14:\"node.type.page\";}s:6:\"module\";a:4:{i:0;s:14:\"layout_builder\";i:1;s:7:\"metatag\";i:2;s:4:\"text\";i:3;s:4:\"user\";}}s:20:\"third_party_settings\";a:1:{s:14:\"layout_builder\";a:3:{s:7:\"enabled\";b:1;s:12:\"allow_custom\";b:1;s:8:\"sections\";a:1:{i:0;a:4:{s:9:\"layout_id\";s:13:\"layout_onecol\";s:15:\"layout_settings\";a:1:{s:5:\"label\";s:0:\"\";}s:10:\"components\";a:3:{s:36:\"38a9abee-f957-4c37-bf25-26572a864786\";a:5:{s:4:\"uuid\";s:36:\"38a9abee-f957-4c37-bf25-26572a864786\";s:6:\"region\";s:7:\"content\";s:13:\"configuration\";a:4:{s:2:\"id\";s:26:\"field_block:node:page:body\";s:13:\"label_display\";s:1:\"0\";s:15:\"context_mapping\";a:1:{s:6:\"entity\";s:21:\"layout_builder.entity\";}s:9:\"formatter\";a:4:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}}s:6:\"weight\";i:0;s:10:\"additional\";a:0:{}}s:36:\"49025aed-c7ef-4f99-bdb3-01a066d936cf\";a:5:{s:4:\"uuid\";s:36:\"49025aed-c7ef-4f99-bdb3-01a066d936cf\";s:6:\"region\";s:7:\"content\";s:13:\"configuration\";a:3:{s:2:\"id\";s:33:\"extra_field_block:node:page:links\";s:13:\"label_display\";s:1:\"0\";s:15:\"context_mapping\";a:1:{s:6:\"entity\";s:21:\"layout_builder.entity\";}}s:6:\"weight\";i:1;s:10:\"additional\";a:0:{}}s:36:\"022c3459-1bc8-481c-aea0-dc1a493c5abb\";a:5:{s:4:\"uuid\";s:36:\"022c3459-1bc8-481c-aea0-dc1a493c5abb\";s:6:\"region\";s:7:\"content\";s:13:\"configuration\";a:4:{s:2:\"id\";s:36:\"field_block:node:page:field_metatags\";s:13:\"label_display\";s:1:\"0\";s:15:\"context_mapping\";a:1:{s:6:\"entity\";s:21:\"layout_builder.entity\";}s:9:\"formatter\";a:4:{s:4:\"type\";s:23:\"metatag_empty_formatter\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}}}s:6:\"weight\";i:2;s:10:\"additional\";a:0:{}}}s:20:\"third_party_settings\";a:0:{}}}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"M_Y8L5tfmhx7DR143E05YyZSpvgil6VFvqcfBWykalg\";}s:2:\"id\";s:17:\"node.page.default\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:100;s:6:\"region\";s:7:\"content\";}s:14:\"field_metatags\";a:6:{s:4:\"type\";s:23:\"metatag_empty_formatter\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:102;s:6:\"region\";s:7:\"content\";}s:5:\"links\";a:4:{s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:101;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.node.page.teaser',	'a:11:{s:4:\"uuid\";s:36:\"0cdde055-9011-4c16-b82c-494a58ce39ed\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:33:\"core.entity_view_mode.node.teaser\";i:1;s:26:\"field.field.node.page.body\";i:2;s:36:\"field.field.node.page.field_metatags\";i:3;s:44:\"field.field.node.page.layout_builder__layout\";i:4;s:14:\"node.type.page\";}s:6:\"module\";a:2:{i:0;s:4:\"text\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"8BgdRtLbtQ0F__o0FHSH0Mx5fvXOra9tfT1GmNKbRYw\";}s:2:\"id\";s:16:\"node.page.teaser\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:4:\"mode\";s:6:\"teaser\";s:7:\"content\";a:2:{s:4:\"body\";a:6:{s:4:\"type\";s:23:\"text_summary_or_trimmed\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:11:\"trim_length\";i:600;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:100;s:6:\"region\";s:7:\"content\";}s:5:\"links\";a:2:{s:6:\"weight\";i:101;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:2:{s:14:\"field_metatags\";b:1;s:22:\"layout_builder__layout\";b:1;}}'),
('',	'core.entity_view_display.paragraph.ebt_accordion.default',	'a:11:{s:4:\"uuid\";s:36:\"d7bca4fc-d99f-4966-929d-15f5247c8564\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:60:\"field.field.paragraph.ebt_accordion.field_ebt_accordion_text\";i:1;s:61:\"field.field.paragraph.ebt_accordion.field_ebt_accordion_title\";i:2;s:40:\"paragraphs.paragraphs_type.ebt_accordion\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"yn5RBnnmFE_Y5sCchtXzAOZg0joBlJrWIBEaYAnP9Ps\";}s:2:\"id\";s:31:\"paragraph.ebt_accordion.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:13:\"ebt_accordion\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:24:\"field_ebt_accordion_text\";a:6:{s:6:\"weight\";i:1;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:12:\"text_default\";s:6:\"region\";s:7:\"content\";}s:25:\"field_ebt_accordion_title\";a:6:{s:6:\"weight\";i:0;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:12:\"text_default\";s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.paragraph.ebt_carousel.default',	'a:11:{s:4:\"uuid\";s:36:\"2e2b2311-9c14-4e94-aecd-97a3f060f45a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:61:\"field.field.paragraph.ebt_carousel.field_ebt_carousel_caption\";i:1;s:59:\"field.field.paragraph.ebt_carousel.field_ebt_carousel_image\";i:2;s:39:\"paragraphs.paragraphs_type.ebt_carousel\";}s:6:\"module\";a:2:{i:0;s:5:\"media\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"o21VkkuJdszAqDOznTVc61VIxPQJc6ocyXSW3qSQFHc\";}s:2:\"id\";s:30:\"paragraph.ebt_carousel.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:12:\"ebt_carousel\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:26:\"field_ebt_carousel_caption\";a:6:{s:6:\"weight\";i:1;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:12:\"text_default\";s:6:\"region\";s:7:\"content\";}s:24:\"field_ebt_carousel_image\";a:6:{s:4:\"type\";s:15:\"media_thumbnail\";s:6:\"weight\";i:0;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:0:\"\";s:10:\"image_link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.paragraph.ebt_counter_item.default',	'a:11:{s:4:\"uuid\";s:36:\"9cd9785e-414b-4ccf-a6f4-9b5039218fd0\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:68:\"field.field.paragraph.ebt_counter_item.field_ebt_counter_description\";i:1;s:61:\"field.field.paragraph.ebt_counter_item.field_ebt_counter_icon\";i:2;s:63:\"field.field.paragraph.ebt_counter_item.field_ebt_counter_number\";i:3;s:62:\"field.field.paragraph.ebt_counter_item.field_ebt_counter_title\";i:4;s:43:\"paragraphs.paragraphs_type.ebt_counter_item\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"EjbsMNoEaP6Z3U6dn1mNEir0yNE1gFyyIzkKiYVPO_4\";}s:2:\"id\";s:34:\"paragraph.ebt_counter_item.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:16:\"ebt_counter_item\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:29:\"field_ebt_counter_description\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";}s:22:\"field_ebt_counter_icon\";a:6:{s:4:\"type\";s:28:\"entity_reference_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:24:\"field_ebt_counter_number\";a:6:{s:4:\"type\";s:14:\"number_integer\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:18:\"thousand_separator\";s:0:\"\";s:13:\"prefix_suffix\";b:1;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:23:\"field_ebt_counter_title\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.paragraph.ebt_slick_slider.default',	'a:11:{s:4:\"uuid\";s:36:\"152c6a3e-8703-40b0-ad21-283b4ae6cc5b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:67:\"field.field.paragraph.ebt_slick_slider.field_ebt_slick_slider_image\";i:1;s:66:\"field.field.paragraph.ebt_slick_slider.field_ebt_slick_slider_link\";i:2;s:66:\"field.field.paragraph.ebt_slick_slider.field_ebt_slick_slider_text\";i:3;s:29:\"image.style.slick_slider_card\";i:4;s:43:\"paragraphs.paragraphs_type.ebt_slick_slider\";}s:6:\"module\";a:3:{i:0;s:4:\"link\";i:1;s:5:\"media\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"VVV9wfo5l1gK1weU695gzyXqp5on_oNav7jAwjjWowQ\";}s:2:\"id\";s:34:\"paragraph.ebt_slick_slider.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:16:\"ebt_slick_slider\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:28:\"field_ebt_slick_slider_image\";a:6:{s:4:\"type\";s:15:\"media_thumbnail\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:17:\"slick_slider_card\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:27:\"field_ebt_slick_slider_link\";a:6:{s:4:\"type\";s:4:\"link\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:1024;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:1:\"0\";s:6:\"target\";s:1:\"0\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";}s:27:\"field_ebt_slick_slider_text\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.paragraph.ebt_slideshow.default',	'a:11:{s:4:\"uuid\";s:36:\"5003e24e-550b-4a07-a87f-66e0dbab0e83\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:60:\"field.field.paragraph.ebt_slideshow.field_ebt_slideshow_link\";i:1;s:61:\"field.field.paragraph.ebt_slideshow.field_ebt_slideshow_slide\";i:2;s:60:\"field.field.paragraph.ebt_slideshow.field_ebt_slideshow_text\";i:3;s:61:\"field.field.paragraph.ebt_slideshow.field_ebt_slideshow_title\";i:4;s:40:\"paragraphs.paragraphs_type.ebt_slideshow\";}s:6:\"module\";a:3:{i:0;s:4:\"link\";i:1;s:5:\"media\";i:2;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"-TV7U97Wd40UA7J_3-aQjPyYv360Wi3Te0PPvYviuxU\";}s:2:\"id\";s:31:\"paragraph.ebt_slideshow.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:13:\"ebt_slideshow\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:24:\"field_ebt_slideshow_link\";a:6:{s:4:\"type\";s:4:\"link\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:1023;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:1:\"0\";s:6:\"target\";s:1:\"0\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";}s:25:\"field_ebt_slideshow_slide\";a:6:{s:4:\"type\";s:15:\"media_thumbnail\";s:5:\"label\";s:15:\"visually_hidden\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:24:\"field_ebt_slideshow_text\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:25:\"field_ebt_slideshow_title\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.paragraph.ebt_stats_item.default',	'a:11:{s:4:\"uuid\";s:36:\"77949beb-f2e0-46a7-bbe3-3ede2ef7f061\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:59:\"field.field.paragraph.ebt_stats_item.field_stats_item_image\";i:1;s:58:\"field.field.paragraph.ebt_stats_item.field_stats_item_link\";i:2;s:60:\"field.field.paragraph.ebt_stats_item.field_stats_item_number\";i:3;s:58:\"field.field.paragraph.ebt_stats_item.field_stats_item_text\";i:4;s:41:\"paragraphs.paragraphs_type.ebt_stats_item\";}s:6:\"module\";a:2:{i:0;s:4:\"link\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"5RDw3deJvwfKptyvRWt0uMj5O3zRyWKrJCZ_MFWk7Po\";}s:2:\"id\";s:32:\"paragraph.ebt_stats_item.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"ebt_stats_item\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:22:\"field_stats_item_image\";a:6:{s:4:\"type\";s:28:\"entity_reference_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:21:\"field_stats_item_link\";a:6:{s:4:\"type\";s:4:\"link\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:1024;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:1:\"0\";s:6:\"target\";s:1:\"0\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";}s:23:\"field_stats_item_number\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:21:\"field_stats_item_text\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.paragraph.ebt_tab.default',	'a:11:{s:4:\"uuid\";s:36:\"4b41c82a-77c1-47f0-a052-9b87649b8136\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:7:{i:0;s:49:\"field.field.paragraph.ebt_tab.field_ebt_tab_block\";i:1;s:51:\"field.field.paragraph.ebt_tab.field_ebt_tab_content\";i:2;s:48:\"field.field.paragraph.ebt_tab.field_ebt_tab_page\";i:3;s:48:\"field.field.paragraph.ebt_tab.field_ebt_tab_text\";i:4;s:49:\"field.field.paragraph.ebt_tab.field_ebt_tab_title\";i:5;s:49:\"field.field.paragraph.ebt_tab.field_ebt_tab_views\";i:6;s:34:\"paragraphs.paragraphs_type.ebt_tab\";}s:6:\"module\";a:3:{i:0;s:11:\"block_field\";i:1;s:4:\"text\";i:2;s:14:\"viewsreference\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"slUTwjnod77jaefmi2b5OQYl4vYxpAodJPHvoHGvQUA\";}s:2:\"id\";s:25:\"paragraph.ebt_tab.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:7:\"ebt_tab\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:19:\"field_ebt_tab_block\";a:6:{s:6:\"weight\";i:6;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:11:\"block_field\";s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_tab_page\";a:6:{s:6:\"weight\";i:1;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:4:\"link\";b:1;s:9:\"view_mode\";s:7:\"default\";}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:28:\"entity_reference_entity_view\";s:6:\"region\";s:7:\"content\";}s:18:\"field_ebt_tab_text\";a:6:{s:6:\"weight\";i:2;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:12:\"text_default\";s:6:\"region\";s:7:\"content\";}s:19:\"field_ebt_tab_title\";a:6:{s:6:\"weight\";i:0;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:12:\"text_default\";s:6:\"region\";s:7:\"content\";}s:19:\"field_ebt_tab_views\";a:6:{s:6:\"weight\";i:5;s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:12:\"plugin_types\";a:1:{i:0;s:5:\"block\";}}s:20:\"third_party_settings\";a:0:{}s:4:\"type\";s:24:\"viewsreference_formatter\";s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:1:{s:21:\"field_ebt_tab_content\";b:1;}}'),
('',	'core.entity_view_display.paragraph.ebt_tiles_item.default',	'a:11:{s:4:\"uuid\";s:36:\"4ccbb938-c11d-49a7-ba57-753328efb08b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:6:{i:0;s:61:\"field.field.paragraph.ebt_tiles_item.field_ebt_clickable_tile\";i:1;s:58:\"field.field.paragraph.ebt_tiles_item.field_ebt_tiles_image\";i:2;s:57:\"field.field.paragraph.ebt_tiles_item.field_ebt_tiles_link\";i:3;s:57:\"field.field.paragraph.ebt_tiles_item.field_ebt_tiles_text\";i:4;s:58:\"field.field.paragraph.ebt_tiles_item.field_ebt_tiles_title\";i:5;s:41:\"paragraphs.paragraphs_type.ebt_tiles_item\";}s:6:\"module\";a:2:{i:0;s:4:\"link\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ZHOP2C6K3eAHsBjc_FJwNsbIKZ-XL88CGUz5EexQ8nE\";}s:2:\"id\";s:32:\"paragraph.ebt_tiles_item.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"ebt_tiles_item\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:24:\"field_ebt_clickable_tile\";a:6:{s:4:\"type\";s:7:\"boolean\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:3:{s:6:\"format\";s:7:\"default\";s:19:\"format_custom_false\";s:0:\"\";s:18:\"format_custom_true\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";}s:21:\"field_ebt_tiles_image\";a:6:{s:4:\"type\";s:28:\"entity_reference_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:20:\"field_ebt_tiles_link\";a:6:{s:4:\"type\";s:4:\"link\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:800;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:1:\"0\";s:6:\"target\";s:1:\"0\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";}s:20:\"field_ebt_tiles_text\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:21:\"field_ebt_tiles_title\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.paragraph.ebt_timeline.default',	'a:11:{s:4:\"uuid\";s:36:\"553c2833-822a-4508-a2f9-99f9ffc89f33\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:6:{i:0;s:61:\"field.field.paragraph.ebt_timeline.field_ebt_timeline_current\";i:1;s:58:\"field.field.paragraph.ebt_timeline.field_ebt_timeline_date\";i:2;s:65:\"field.field.paragraph.ebt_timeline.field_ebt_timeline_media_image\";i:3;s:58:\"field.field.paragraph.ebt_timeline.field_ebt_timeline_text\";i:4;s:59:\"field.field.paragraph.ebt_timeline.field_ebt_timeline_title\";i:5;s:39:\"paragraphs.paragraphs_type.ebt_timeline\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"kScbPfdPZDsoEdHqJtQ9QjqdBXgkz2VT-TEA4uO4yQU\";}s:2:\"id\";s:30:\"paragraph.ebt_timeline.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:12:\"ebt_timeline\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:26:\"field_ebt_timeline_current\";a:6:{s:4:\"type\";s:7:\"boolean\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:6:\"format\";s:7:\"default\";s:19:\"format_custom_false\";s:0:\"\";s:18:\"format_custom_true\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";}s:23:\"field_ebt_timeline_date\";a:6:{s:4:\"type\";s:6:\"string\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:30:\"field_ebt_timeline_media_image\";a:6:{s:4:\"type\";s:28:\"entity_reference_entity_view\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";}s:23:\"field_ebt_timeline_text\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:24:\"field_ebt_timeline_title\";a:6:{s:4:\"type\";s:6:\"string\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.paragraph.ebt_video_and_image_gallery_item.default',	'a:11:{s:4:\"uuid\";s:36:\"0a70dbed-c211-4ec2-a7e5-7d9b701046db\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:85:\"field.field.paragraph.ebt_video_and_image_gallery_item.field_gallery_item_description\";i:1;s:79:\"field.field.paragraph.ebt_video_and_image_gallery_item.field_video_gallery_item\";i:2;s:59:\"paragraphs.paragraphs_type.ebt_video_and_image_gallery_item\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ATQKQ04wbZpenyUY_sMfDM08puKPXNvoGB5tSxGxwG0\";}s:2:\"id\";s:50:\"paragraph.ebt_video_and_image_gallery_item.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:32:\"ebt_video_and_image_gallery_item\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:30:\"field_gallery_item_description\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:24:\"field_video_gallery_item\";a:6:{s:4:\"type\";s:28:\"entity_reference_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:28:\"video_and_image_gallery_item\";s:4:\"link\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_display.user.user.compact',	'a:11:{s:4:\"uuid\";s:36:\"73223d5a-b425-4fba-9090-7b112d030f92\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:34:\"core.entity_view_mode.user.compact\";i:1;s:34:\"field.field.user.user.user_picture\";i:2;s:21:\"image.style.thumbnail\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"00zr_RBdTjPjBGITD3h4c1ESQZimjdVCcHGt1trLqIY\";}s:2:\"id\";s:17:\"user.user.compact\";s:16:\"targetEntityType\";s:4:\"user\";s:6:\"bundle\";s:4:\"user\";s:4:\"mode\";s:7:\"compact\";s:7:\"content\";a:1:{s:12:\"user_picture\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:11:\"image_style\";s:9:\"thumbnail\";s:10:\"image_link\";s:7:\"content\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:1:{s:10:\"member_for\";b:1;}}'),
('',	'core.entity_view_display.user.user.default',	'a:11:{s:4:\"uuid\";s:36:\"1c220693-f471-4184-9453-cd90fc0030d2\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:34:\"field.field.user.user.user_picture\";i:1;s:21:\"image.style.thumbnail\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"mZLyuWM9CQx2ZJVqFGSbzgFnHzudVbHBYmdU256A5Wk\";}s:2:\"id\";s:17:\"user.user.default\";s:16:\"targetEntityType\";s:4:\"user\";s:6:\"bundle\";s:4:\"user\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:10:\"member_for\";a:2:{s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";}s:12:\"user_picture\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:11:\"image_style\";s:9:\"thumbnail\";s:10:\"image_link\";s:7:\"content\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}'),
('',	'core.entity_view_mode.block.token',	'a:9:{s:4:\"uuid\";s:36:\"c298243a-fc61-46e8-8878-5de88a9bcb0b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"block\";}}s:2:\"id\";s:11:\"block.token\";s:5:\"label\";s:5:\"Token\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:5:\"block\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.block_content.full',	'a:10:{s:4:\"uuid\";s:36:\"9268fa23-36f9-4a94-a9ef-799f2d1c5eb5\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:13:\"block_content\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Q7yUUYeRLByl-MCGveKKF_KhAtNICLCMJuKWfugCvso\";}s:2:\"id\";s:18:\"block_content.full\";s:5:\"label\";s:4:\"Full\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:13:\"block_content\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.block_content.token',	'a:9:{s:4:\"uuid\";s:36:\"004ad1d4-03ad-4317-af82-4bb9f039c686\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:13:\"block_content\";}}s:2:\"id\";s:19:\"block_content.token\";s:5:\"label\";s:5:\"Token\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:13:\"block_content\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.contact_message.token',	'a:9:{s:4:\"uuid\";s:36:\"b51e5b3c-1a2e-49cf-acff-bfc2dea5ad40\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"contact\";}}s:2:\"id\";s:21:\"contact_message.token\";s:5:\"label\";s:5:\"Token\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:15:\"contact_message\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.file.token',	'a:9:{s:4:\"uuid\";s:36:\"99749d8d-98ee-49e8-b272-054f53d7c97f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"file\";}}s:2:\"id\";s:10:\"file.token\";s:5:\"label\";s:5:\"Token\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:4:\"file\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.media.ebt_image_gallery',	'a:10:{s:4:\"uuid\";s:36:\"d8772b40-e75a-46fe-a0eb-48e3c2f13441\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"gx3dAzTlzUoOPV6nrqIxtsHu6AWtMEd6M4HRihgOIdc\";}s:2:\"id\";s:23:\"media.ebt_image_gallery\";s:5:\"label\";s:17:\"EBT Image Gallery\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:5:\"media\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.media.ebt_video',	'a:10:{s:4:\"uuid\";s:36:\"9ff59caf-8ee9-4fca-bffa-89132c94c813\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"IXsnV3TXq49eaMlltbjpSWIiseAysJRe042Revn8t1s\";}s:2:\"id\";s:15:\"media.ebt_video\";s:5:\"label\";s:9:\"EBT Video\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:5:\"media\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.media.full',	'a:10:{s:4:\"uuid\";s:36:\"fb758fd6-28cd-4155-8eda-49912e1da3f8\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"dTfAUHooYV0uOVPO3saGpgv-c5PppJXDwxvwRTJOycM\";}s:2:\"id\";s:10:\"media.full\";s:5:\"label\";s:12:\"Full content\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:5:\"media\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.media.media_library',	'a:10:{s:4:\"uuid\";s:36:\"1a098749-bd7d-429f-9d91-d4e7913c8c3c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:13:\"media_library\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"04_dAqpWYP1WmsXZ7IXJ7-yarCvNddD10EUkBDtIFy4\";}s:2:\"id\";s:19:\"media.media_library\";s:5:\"label\";s:13:\"Media library\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:5:\"media\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.media.token',	'a:9:{s:4:\"uuid\";s:36:\"aa6556df-5384-471d-96b4-a6d264801693\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}}s:2:\"id\";s:11:\"media.token\";s:5:\"label\";s:5:\"Token\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:5:\"media\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.media.video_and_image_gallery_item',	'a:10:{s:4:\"uuid\";s:36:\"6f5a787d-85f5-4bea-aab2-4094c6f7772f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"u0M3Ybb0-9QE3E30c77uKo8PW64Vexg-TwC2IHerOgs\";}s:2:\"id\";s:34:\"media.video_and_image_gallery_item\";s:5:\"label\";s:28:\"Video and Image gallery item\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:5:\"media\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.menu_link_content.token',	'a:9:{s:4:\"uuid\";s:36:\"33a56e28-1d42-4a4f-b42a-88eb552104a7\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:17:\"menu_link_content\";}}s:2:\"id\";s:23:\"menu_link_content.token\";s:5:\"label\";s:5:\"Token\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:17:\"menu_link_content\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.node.full',	'a:10:{s:4:\"uuid\";s:36:\"5aefb664-7e3c-4ebe-86a2-07194cada9f4\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"QJ2aZ1xfVf59aq6Pz5X7fyUOa2HxuCoTwQ_RQjoulAU\";}s:2:\"id\";s:9:\"node.full\";s:5:\"label\";s:12:\"Full content\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.node.rss',	'a:10:{s:4:\"uuid\";s:36:\"6b3209c3-0ae1-46f6-8e2c-44d4391f2434\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"l8fiAFE3Kng_6bhLlUDnVTkTDzXWxzYFrCWTrngVXEA\";}s:2:\"id\";s:8:\"node.rss\";s:5:\"label\";s:3:\"RSS\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.node.search_index',	'a:10:{s:4:\"uuid\";s:36:\"416e3f7c-ab1b-4bb4-b428-aabf9906eecf\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"r_A0T3aTqGDwLyvoH7wLps-0PM--RHlS8UsiJe_Ac64\";}s:2:\"id\";s:17:\"node.search_index\";s:5:\"label\";s:12:\"Search index\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.node.search_result',	'a:10:{s:4:\"uuid\";s:36:\"c196759a-15b6-47d3-b672-f853645cc638\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"d8wBEm7XvJ6H3S0IneDD9PfTBklPIH7GMpxElVemPf8\";}s:2:\"id\";s:18:\"node.search_result\";s:5:\"label\";s:32:\"Search result highlighting input\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.node.teaser',	'a:10:{s:4:\"uuid\";s:36:\"aa910ffb-3a87-4512-af06-273b721bc12f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KgGJDZFpMaz_8bTv6fN1bXS3Qi5LWmRJI9R53kEGsNQ\";}s:2:\"id\";s:11:\"node.teaser\";s:5:\"label\";s:6:\"Teaser\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.node.token',	'a:9:{s:4:\"uuid\";s:36:\"3ec23f24-50ef-434e-a7b6-3d8cb9a2a4f4\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:2:\"id\";s:10:\"node.token\";s:5:\"label\";s:5:\"Token\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.paragraph.preview',	'a:10:{s:4:\"uuid\";s:36:\"f30f214f-6163-41a8-a996-f703e5fd92cb\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"h3BeHVei4Lnyqbkao3YiF4KqoY-DhRvUNfEgKG8Rgjg\";}s:2:\"id\";s:17:\"paragraph.preview\";s:5:\"label\";s:7:\"Preview\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.path_alias.token',	'a:9:{s:4:\"uuid\";s:36:\"b47111c9-dcb8-4762-af5c-3f7acca095d2\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"path_alias\";}}s:2:\"id\";s:16:\"path_alias.token\";s:5:\"label\";s:5:\"Token\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:10:\"path_alias\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.shortcut.token',	'a:9:{s:4:\"uuid\";s:36:\"550ba8ad-246f-433e-8c0d-f2c76255df0e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"shortcut\";}}s:2:\"id\";s:14:\"shortcut.token\";s:5:\"label\";s:5:\"Token\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:8:\"shortcut\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.taxonomy_term.full',	'a:10:{s:4:\"uuid\";s:36:\"e72ba8d8-dba4-4920-91d6-5e916b81a6fc\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"taxonomy\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"iukUENpf8CFvjZbGGacKX_Ges0-lU9z6zvsd32P6kbo\";}s:2:\"id\";s:18:\"taxonomy_term.full\";s:5:\"label\";s:18:\"Taxonomy term page\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:13:\"taxonomy_term\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.taxonomy_term.token',	'a:9:{s:4:\"uuid\";s:36:\"ea887f34-9e29-4000-aef4-21112004577d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"taxonomy\";}}s:2:\"id\";s:19:\"taxonomy_term.token\";s:5:\"label\";s:5:\"Token\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:13:\"taxonomy_term\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.user.compact',	'a:10:{s:4:\"uuid\";s:36:\"06ded9f9-3e1a-44f0-a5e0-224efcca6431\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"TtD7OuGskOsQfoGyxXkrdtllBpR37J19d5BMQDZWJgA\";}s:2:\"id\";s:12:\"user.compact\";s:5:\"label\";s:7:\"Compact\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:4:\"user\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.user.full',	'a:10:{s:4:\"uuid\";s:36:\"ad69e028-e0a2-4eab-9d8b-d18e904da6bf\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ZbXunWS_xAvMZXFfinyvClDAb_RCVLt7gAzE3v16E-Q\";}s:2:\"id\";s:9:\"user.full\";s:5:\"label\";s:12:\"User account\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:4:\"user\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.user.token',	'a:9:{s:4:\"uuid\";s:36:\"676a8206-d9d0-4094-bf54-66a60c6bad53\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:2:\"id\";s:10:\"user.token\";s:5:\"label\";s:5:\"Token\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:4:\"user\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.webform.token',	'a:9:{s:4:\"uuid\";s:36:\"5f8faafa-6ec3-4704-a06c-08d5391b12d7\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:2:\"id\";s:13:\"webform.token\";s:5:\"label\";s:5:\"Token\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:7:\"webform\";s:5:\"cache\";b:1;}'),
('',	'core.entity_view_mode.webform_submission.token',	'a:9:{s:4:\"uuid\";s:36:\"92d0137a-b4c4-4c19-b07b-84c8b8844019\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:2:\"id\";s:24:\"webform_submission.token\";s:5:\"label\";s:5:\"Token\";s:11:\"description\";s:0:\"\";s:16:\"targetEntityType\";s:18:\"webform_submission\";s:5:\"cache\";b:1;}'),
('',	'core.extension',	'a:4:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"4GIX5Esnc_umpXUBj4IIocRX7Mt5fPhm4AgXfE3E56E\";}s:6:\"module\";a:107:{s:13:\"admin_toolbar\";i:0;s:19:\"admin_toolbar_tools\";i:0;s:18:\"announcements_feed\";i:0;s:14:\"automated_cron\";i:0;s:8:\"big_pipe\";i:0;s:5:\"block\";i:0;s:13:\"block_content\";i:0;s:11:\"block_field\";i:0;s:10:\"breakpoint\";i:0;s:9:\"ckeditor5\";i:0;s:21:\"ckeditor5_plugin_pack\";i:0;s:32:\"ckeditor5_plugin_pack_auto_image\";i:0;s:38:\"ckeditor5_plugin_pack_find_and_replace\";i:0;s:26:\"ckeditor5_plugin_pack_font\";i:0;s:31:\"ckeditor5_plugin_pack_highlight\";i:0;s:34:\"ckeditor5_plugin_pack_indent_block\";i:0;s:32:\"ckeditor5_plugin_pack_page_break\";i:0;s:32:\"ckeditor5_plugin_pack_select_all\";i:0;s:31:\"ckeditor5_plugin_pack_templates\";i:0;s:41:\"ckeditor5_plugin_pack_text_transformation\";i:0;s:40:\"ckeditor5_plugin_pack_todo_document_list\";i:0;s:32:\"ckeditor5_plugin_pack_word_count\";i:0;s:37:\"ckeditor5_premium_features_fullscreen\";i:0;s:6:\"config\";i:0;s:13:\"config_ignore\";i:0;s:7:\"contact\";i:0;s:10:\"contextual\";i:0;s:8:\"datetime\";i:0;s:5:\"dblog\";i:0;s:18:\"dynamic_page_cache\";i:0;s:13:\"ebt_accordion\";i:0;s:16:\"ebt_basic_button\";i:0;s:9:\"ebt_block\";i:0;s:20:\"ebt_bootstrap_button\";i:0;s:12:\"ebt_carousel\";i:0;s:11:\"ebt_columns\";i:0;s:8:\"ebt_core\";i:0;s:13:\"ebt_countdown\";i:0;s:11:\"ebt_counter\";i:0;s:7:\"ebt_cta\";i:0;s:8:\"ebt_hero\";i:0;s:9:\"ebt_image\";i:0;s:17:\"ebt_image_gallery\";i:0;s:14:\"ebt_micromodal\";i:0;s:9:\"ebt_quote\";i:0;s:16:\"ebt_slick_slider\";i:0;s:13:\"ebt_slideshow\";i:0;s:9:\"ebt_stats\";i:0;s:8:\"ebt_tabs\";i:0;s:8:\"ebt_text\";i:0;s:9:\"ebt_tiles\";i:0;s:12:\"ebt_timeline\";i:0;s:9:\"ebt_video\";i:0;s:27:\"ebt_video_and_image_gallery\";i:0;s:9:\"ebt_views\";i:0;s:11:\"ebt_webform\";i:0;s:17:\"ebt_webform_popup\";i:0;s:6:\"editor\";i:0;s:26:\"entity_reference_revisions\";i:0;s:5:\"field\";i:0;s:11:\"field_group\";i:0;s:8:\"field_ui\";i:0;s:4:\"file\";i:0;s:6:\"filter\";i:0;s:9:\"glightbox\";i:0;s:21:\"glightbox_media_video\";i:0;s:16:\"google_analytics\";i:0;s:4:\"help\";i:0;s:7:\"history\";i:0;s:5:\"image\";i:0;s:9:\"jquery_ui\";i:0;s:19:\"jquery_ui_accordion\";i:0;s:14:\"jquery_ui_tabs\";i:0;s:14:\"layout_builder\";i:0;s:16:\"layout_discovery\";i:0;s:4:\"link\";i:0;s:6:\"linkit\";i:0;s:5:\"media\";i:0;s:13:\"media_library\";i:0;s:26:\"media_library_form_element\";i:0;s:17:\"menu_link_content\";i:0;s:7:\"menu_ui\";i:0;s:7:\"metatag\";i:0;s:4:\"node\";i:0;s:7:\"options\";i:0;s:10:\"page_cache\";i:0;s:4:\"path\";i:0;s:10:\"path_alias\";i:0;s:16:\"profile_switcher\";i:0;s:8:\"redirect\";i:0;s:6:\"search\";i:0;s:8:\"shortcut\";i:0;s:9:\"svg_image\";i:0;s:6:\"system\";i:0;s:8:\"taxonomy\";i:0;s:4:\"text\";i:0;s:5:\"token\";i:0;s:7:\"toolbar\";i:0;s:6:\"update\";i:0;s:4:\"user\";i:0;s:8:\"views_ui\";i:0;s:14:\"viewsreference\";i:0;s:7:\"webform\";i:0;s:8:\"pathauto\";i:1;s:5:\"views\";i:10;s:10:\"paragraphs\";i:11;s:4:\"fast\";i:1000;}s:5:\"theme\";a:2:{s:7:\"olivero\";i:0;s:5:\"claro\";i:0;}s:7:\"profile\";s:4:\"fast\";}'),
('',	'core.menu.static_menu_link_overrides',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"CXhei_vpaZk-3f_Mj2cH0YmpK-ZpKHoSzVA3yZrDq0g\";}s:11:\"definitions\";a:1:{s:18:\"contact__site_page\";a:5:{s:9:\"menu_name\";s:6:\"footer\";s:6:\"parent\";s:0:\"\";s:6:\"weight\";i:0;s:8:\"expanded\";b:0;s:7:\"enabled\";b:1;}}}'),
('',	'dblog.settings',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"e883aGsrt1wFrsydlYU584PZONCSfRy0DtkZ9KzHb58\";}s:9:\"row_limit\";i:1000;}'),
('',	'ebt_core.settings',	'a:12:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"VBIZ2klsa-wrUk3pFOgIi3avMLFro6A0nFNYc35MvNQ\";}s:26:\"ebt_core_mobile_breakpoint\";s:3:\"640\";s:26:\"ebt_core_tablet_breakpoint\";s:4:\"1020\";s:27:\"ebt_core_desktop_breakpoint\";s:4:\"1320\";s:22:\"ebt_core_xxsmall_width\";s:3:\"480\";s:21:\"ebt_core_xsmall_width\";s:3:\"640\";s:20:\"ebt_core_small_width\";s:3:\"768\";s:22:\"ebt_core_default_width\";s:3:\"960\";s:20:\"ebt_core_large_width\";s:4:\"1100\";s:21:\"ebt_core_xlarge_width\";s:4:\"1320\";s:22:\"ebt_core_xxlarge_width\";s:4:\"1600\";s:25:\"ebt_core_background_color\";s:7:\"#0d77b5\";}'),
('',	'editor.editor.basic_html',	'a:9:{s:4:\"uuid\";s:36:\"65aded18-2f8d-4ec3-8d69-0a602798f4dd\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:24:\"filter.format.basic_html\";}s:6:\"module\";a:1:{i:0;s:9:\"ckeditor5\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Qi2tIe-L97EutlMmhEvhsNxZOpOoA-RH82c4BQb5n4A\";}s:6:\"format\";s:10:\"basic_html\";s:6:\"editor\";s:9:\"ckeditor5\";s:8:\"settings\";a:2:{s:7:\"toolbar\";a:1:{s:5:\"items\";a:15:{i:0;s:4:\"bold\";i:1;s:6:\"italic\";i:2;s:1:\"|\";i:3;s:4:\"link\";i:4;s:1:\"|\";i:5;s:12:\"bulletedList\";i:6;s:12:\"numberedList\";i:7;s:1:\"|\";i:8;s:10:\"blockQuote\";i:9;s:17:\"drupalInsertImage\";i:10;s:1:\"|\";i:11;s:7:\"heading\";i:12;s:4:\"code\";i:13;s:1:\"|\";i:14;s:13:\"sourceEditing\";}}s:7:\"plugins\";a:4:{s:17:\"ckeditor5_heading\";a:1:{s:16:\"enabled_headings\";a:5:{i:0;s:8:\"heading2\";i:1;s:8:\"heading3\";i:2;s:8:\"heading4\";i:3;s:8:\"heading5\";i:4;s:8:\"heading6\";}}s:21:\"ckeditor5_imageResize\";a:1:{s:12:\"allow_resize\";b:1;}s:14:\"ckeditor5_list\";a:2:{s:10:\"properties\";a:2:{s:8:\"reversed\";b:0;s:10:\"startIndex\";b:1;}s:10:\"multiBlock\";b:1;}s:23:\"ckeditor5_sourceEditing\";a:1:{s:12:\"allowed_tags\";a:13:{i:0;s:6:\"<cite>\";i:1;s:4:\"<dl>\";i:2;s:4:\"<dt>\";i:3;s:4:\"<dd>\";i:4;s:12:\"<a hreflang>\";i:5;s:17:\"<blockquote cite>\";i:6;s:9:\"<ul type>\";i:7;s:9:\"<ol type>\";i:8;s:7:\"<h2 id>\";i:9;s:7:\"<h3 id>\";i:10;s:7:\"<h4 id>\";i:11;s:7:\"<h5 id>\";i:12;s:7:\"<h6 id>\";}}}}s:12:\"image_upload\";a:5:{s:6:\"status\";b:1;s:6:\"scheme\";s:6:\"public\";s:9:\"directory\";s:13:\"inline-images\";s:8:\"max_size\";N;s:14:\"max_dimensions\";a:2:{s:5:\"width\";N;s:6:\"height\";N;}}}'),
('',	'editor.editor.full_html',	'a:9:{s:4:\"uuid\";s:36:\"1926258e-dc0e-4aaa-95d1-5abf3be483cd\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:23:\"filter.format.full_html\";}s:6:\"module\";a:1:{i:0;s:9:\"ckeditor5\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"lurcn8yf33g3Dkzdc55cTfJa9salGp9ytSYyG1s7QMI\";}s:6:\"format\";s:9:\"full_html\";s:6:\"editor\";s:9:\"ckeditor5\";s:8:\"settings\";a:2:{s:7:\"toolbar\";a:1:{s:5:\"items\";a:21:{i:0;s:4:\"bold\";i:1;s:6:\"italic\";i:2;s:13:\"strikethrough\";i:3;s:11:\"superscript\";i:4;s:9:\"subscript\";i:5;s:12:\"removeFormat\";i:6;s:1:\"|\";i:7;s:4:\"link\";i:8;s:1:\"|\";i:9;s:12:\"bulletedList\";i:10;s:12:\"numberedList\";i:11;s:1:\"|\";i:12;s:10:\"blockQuote\";i:13;s:17:\"drupalInsertImage\";i:14;s:11:\"insertTable\";i:15;s:14:\"horizontalLine\";i:16;s:1:\"|\";i:17;s:7:\"heading\";i:18;s:9:\"codeBlock\";i:19;s:1:\"|\";i:20;s:13:\"sourceEditing\";}}s:7:\"plugins\";a:5:{s:19:\"ckeditor5_codeBlock\";a:1:{s:9:\"languages\";a:14:{i:0;a:2:{s:5:\"label\";s:10:\"Plain text\";s:8:\"language\";s:9:\"plaintext\";}i:1;a:2:{s:5:\"label\";s:1:\"C\";s:8:\"language\";s:1:\"c\";}i:2;a:2:{s:5:\"label\";s:2:\"C#\";s:8:\"language\";s:2:\"cs\";}i:3;a:2:{s:5:\"label\";s:3:\"C++\";s:8:\"language\";s:3:\"cpp\";}i:4;a:2:{s:5:\"label\";s:3:\"CSS\";s:8:\"language\";s:3:\"css\";}i:5;a:2:{s:5:\"label\";s:4:\"Diff\";s:8:\"language\";s:4:\"diff\";}i:6;a:2:{s:5:\"label\";s:4:\"HTML\";s:8:\"language\";s:4:\"html\";}i:7;a:2:{s:5:\"label\";s:4:\"Java\";s:8:\"language\";s:4:\"java\";}i:8;a:2:{s:5:\"label\";s:10:\"JavaScript\";s:8:\"language\";s:10:\"javascript\";}i:9;a:2:{s:5:\"label\";s:3:\"PHP\";s:8:\"language\";s:3:\"php\";}i:10;a:2:{s:5:\"label\";s:6:\"Python\";s:8:\"language\";s:6:\"python\";}i:11;a:2:{s:5:\"label\";s:4:\"Ruby\";s:8:\"language\";s:4:\"ruby\";}i:12;a:2:{s:5:\"label\";s:10:\"TypeScript\";s:8:\"language\";s:10:\"typescript\";}i:13;a:2:{s:5:\"label\";s:3:\"XML\";s:8:\"language\";s:3:\"xml\";}}}s:17:\"ckeditor5_heading\";a:1:{s:16:\"enabled_headings\";a:5:{i:0;s:8:\"heading2\";i:1;s:8:\"heading3\";i:2;s:8:\"heading4\";i:3;s:8:\"heading5\";i:4;s:8:\"heading6\";}}s:21:\"ckeditor5_imageResize\";a:1:{s:12:\"allow_resize\";b:1;}s:14:\"ckeditor5_list\";a:2:{s:10:\"properties\";a:2:{s:8:\"reversed\";b:1;s:10:\"startIndex\";b:1;}s:10:\"multiBlock\";b:1;}s:23:\"ckeditor5_sourceEditing\";a:1:{s:12:\"allowed_tags\";a:0:{}}}}s:12:\"image_upload\";a:5:{s:6:\"status\";b:1;s:6:\"scheme\";s:6:\"public\";s:9:\"directory\";s:13:\"inline-images\";s:8:\"max_size\";N;s:14:\"max_dimensions\";a:2:{s:5:\"width\";N;s:6:\"height\";N;}}}'),
('',	'editor.editor.webform_default',	'a:8:{s:4:\"uuid\";s:36:\"4c6d924f-2c8d-4499-9713-799828c76079\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:29:\"filter.format.webform_default\";}s:6:\"module\";a:1:{i:0;s:9:\"ckeditor5\";}}s:6:\"format\";s:15:\"webform_default\";s:6:\"editor\";s:9:\"ckeditor5\";s:8:\"settings\";a:2:{s:7:\"toolbar\";a:1:{s:5:\"items\";a:20:{i:0;s:7:\"heading\";i:1;s:1:\"|\";i:2;s:4:\"bold\";i:3;s:6:\"italic\";i:4;s:9:\"subscript\";i:5;s:11:\"superscript\";i:6;s:1:\"|\";i:7;s:17:\"specialCharacters\";i:8;s:1:\"|\";i:9;s:12:\"numberedList\";i:10;s:12:\"bulletedList\";i:11;s:1:\"|\";i:12;s:4:\"link\";i:13;s:1:\"|\";i:14;s:6:\"indent\";i:15;s:7:\"outdent\";i:16;s:1:\"|\";i:17;s:10:\"blockQuote\";i:18;s:1:\"|\";i:19;s:13:\"sourceEditing\";}}s:7:\"plugins\";a:3:{s:17:\"ckeditor5_heading\";a:1:{s:16:\"enabled_headings\";a:5:{i:0;s:8:\"heading2\";i:1;s:8:\"heading3\";i:2;s:8:\"heading4\";i:3;s:8:\"heading5\";i:4;s:8:\"heading6\";}}s:14:\"ckeditor5_list\";a:2:{s:10:\"properties\";a:2:{s:8:\"reversed\";b:1;s:10:\"startIndex\";b:1;}s:10:\"multiBlock\";b:1;}s:23:\"ckeditor5_sourceEditing\";a:1:{s:12:\"allowed_tags\";a:0:{}}}}s:12:\"image_upload\";a:1:{s:6:\"status\";b:0;}}'),
('',	'field.field.block_content.basic.body',	'a:17:{s:4:\"uuid\";s:36:\"22004f3b-acef-4ec7-a26a-84514e3b0755\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:24:\"block_content.type.basic\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"j00Gfs9AFqwK4x9RIsISLbPO7vA12psPR4s60wOIwQo\";}s:2:\"id\";s:24:\"block_content.basic.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:5:\"basic\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_accordion.body',	'a:17:{s:4:\"uuid\";s:36:\"28cf0280-0877-4dba-9961-a719b378e9f3\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:32:\"block_content.type.ebt_accordion\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"EcoPer3Ti0HE0G0vbR_XTjvl4J4xhtcfJlZiIpT2-ic\";}s:2:\"id\";s:32:\"block_content.ebt_accordion.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"ebt_accordion\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_accordion.field_ebt_accordion',	'a:17:{s:4:\"uuid\";s:36:\"da20cc91-36e0-4116-8c1e-1b5e33ccbd6e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:32:\"block_content.type.ebt_accordion\";i:1;s:47:\"field.storage.block_content.field_ebt_accordion\";i:2;s:40:\"paragraphs.paragraphs_type.ebt_accordion\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KleL2jMUTWlOv_XwXvSfbaLHvZFC4TO3ZGrHClNa8Jk\";}s:2:\"id\";s:47:\"block_content.ebt_accordion.field_ebt_accordion\";s:10:\"field_name\";s:19:\"field_ebt_accordion\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"ebt_accordion\";s:5:\"label\";s:9:\"Accordion\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:17:\"default:paragraph\";s:16:\"handler_settings\";a:3:{s:6:\"negate\";i:0;s:14:\"target_bundles\";a:1:{s:13:\"ebt_accordion\";s:13:\"ebt_accordion\";}s:24:\"target_bundles_drag_drop\";a:1:{s:13:\"ebt_accordion\";a:2:{s:7:\"enabled\";b:1;s:6:\"weight\";i:3;}}}}s:10:\"field_type\";s:26:\"entity_reference_revisions\";}'),
('',	'field.field.block_content.ebt_accordion.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"082df8d4-f424-4ec5-9be7-fa79dca0bc70\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:32:\"block_content.type.ebt_accordion\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"4JvhH84_ab4oNGRe99S5bOvjSJdmPzs1XF2s5a0tlPc\";}s:2:\"id\";s:46:\"block_content.ebt_accordion.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"ebt_accordion\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_basic_button.field_ebt_basic_button_link',	'a:17:{s:4:\"uuid\";s:36:\"c0f9b024-755c-40ce-9a70-2d7135b9b02d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:35:\"block_content.type.ebt_basic_button\";i:1;s:55:\"field.storage.block_content.field_ebt_basic_button_link\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sHxTdakkm0n2AWPN2_ygOqsVXsuySIH10GpOOAEbzYE\";}s:2:\"id\";s:58:\"block_content.ebt_basic_button.field_ebt_basic_button_link\";s:10:\"field_name\";s:27:\"field_ebt_basic_button_link\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:16:\"ebt_basic_button\";s:5:\"label\";s:11:\"Button LInk\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:9:\"link_type\";i:17;s:5:\"title\";i:2;}s:10:\"field_type\";s:4:\"link\";}'),
('',	'field.field.block_content.ebt_basic_button.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"28dce901-3d51-4486-b431-ddbf214523f7\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:35:\"block_content.type.ebt_basic_button\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"TljYP0E4TAaKsPdVXhWVNLXzzFG9oPBu7BUROGtWlPY\";}s:2:\"id\";s:49:\"block_content.ebt_basic_button.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:16:\"ebt_basic_button\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_block.body',	'a:17:{s:4:\"uuid\";s:36:\"c82da539-0efe-4f63-b7ed-cfb0c65f3022\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_block\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ze4f8wKV-sjDw10PzW5_0VDQpHaV7fUywYLVyynLOXQ\";}s:2:\"id\";s:28:\"block_content.ebt_block.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_block\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_block.field_ebt_block_block',	'a:17:{s:4:\"uuid\";s:36:\"02b3090f-c1e2-41ef-961f-8f9dbe3677b7\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_block\";i:1;s:49:\"field.storage.block_content.field_ebt_block_block\";}s:6:\"module\";a:1:{i:0;s:11:\"block_field\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ODt400wjC0-0TFAwPcqdOKmEH1RCrno2RlHZAO9jMDY\";}s:2:\"id\";s:45:\"block_content.ebt_block.field_ebt_block_block\";s:10:\"field_name\";s:21:\"field_ebt_block_block\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_block\";s:5:\"label\";s:5:\"Block\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:9:\"selection\";s:10:\"categories\";s:18:\"selection_settings\";a:1:{s:10:\"categories\";a:24:{s:5:\"Block\";s:5:\"Block\";s:14:\"Comment fields\";s:14:\"Comment fields\";s:22:\"Contact message fields\";s:22:\"Contact message fields\";s:13:\"Content block\";s:13:\"Content block\";s:20:\"Content block fields\";s:20:\"Content block fields\";s:14:\"Content fields\";s:14:\"Content fields\";s:4:\"core\";s:4:\"core\";s:23:\"Custom menu link fields\";s:23:\"Custom menu link fields\";s:11:\"File fields\";s:11:\"File fields\";s:5:\"Forms\";s:5:\"Forms\";s:4:\"Help\";s:4:\"Help\";s:13:\"Inline blocks\";s:13:\"Inline blocks\";s:13:\"Lists (Views)\";s:13:\"Lists (Views)\";s:12:\"Media fields\";s:12:\"Media fields\";s:5:\"Menus\";s:5:\"Menus\";s:16:\"Paragraph fields\";s:16:\"Paragraph fields\";s:20:\"Shortcut link fields\";s:20:\"Shortcut link fields\";s:6:\"System\";s:6:\"System\";s:20:\"Taxonomy term fields\";s:20:\"Taxonomy term fields\";s:16:\"URL alias fields\";s:16:\"URL alias fields\";s:4:\"User\";s:4:\"User\";s:11:\"User fields\";s:11:\"User fields\";s:7:\"Webform\";s:7:\"Webform\";s:25:\"Webform submission fields\";s:25:\"Webform submission fields\";}}}s:10:\"field_type\";s:11:\"block_field\";}'),
('',	'field.field.block_content.ebt_block.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"4cf8e43c-52cf-40e7-8fab-03ba24e5671d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_block\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"HsmfX01jgclZMXztEvPXS8YoUBvYO2AzDJY7Olj0G5A\";}s:2:\"id\";s:42:\"block_content.ebt_block.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_block\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_bootstrap_button.field_ebt_bootstrap_button_link',	'a:17:{s:4:\"uuid\";s:36:\"308dba68-d030-422d-b8e9-72568d1fd20a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:39:\"block_content.type.ebt_bootstrap_button\";i:1;s:59:\"field.storage.block_content.field_ebt_bootstrap_button_link\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"LHj34VkFYZYI5N_541KsHaqlWyuH7Cw_KxfjHm23woU\";}s:2:\"id\";s:66:\"block_content.ebt_bootstrap_button.field_ebt_bootstrap_button_link\";s:10:\"field_name\";s:31:\"field_ebt_bootstrap_button_link\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:20:\"ebt_bootstrap_button\";s:5:\"label\";s:4:\"Link\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:9:\"link_type\";i:17;s:5:\"title\";i:2;}s:10:\"field_type\";s:4:\"link\";}'),
('',	'field.field.block_content.ebt_bootstrap_button.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"b6ea63fb-dfef-42aa-bda8-892c68583ffc\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:39:\"block_content.type.ebt_bootstrap_button\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"-6S_O_kYEPD4uAw2AnjYuYGHz_CMhBBvkkO5sJA1DYg\";}s:2:\"id\";s:53:\"block_content.ebt_bootstrap_button.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:20:\"ebt_bootstrap_button\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_carousel.field_ebt_carousel',	'a:17:{s:4:\"uuid\";s:36:\"2bc22340-9888-4636-9768-5a9bc9ffd66c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:31:\"block_content.type.ebt_carousel\";i:1;s:46:\"field.storage.block_content.field_ebt_carousel\";i:2;s:39:\"paragraphs.paragraphs_type.ebt_carousel\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"NZhceEWb8sFj-vaeEbM_eFgHPVULnofUVtBb6FO526E\";}s:2:\"id\";s:45:\"block_content.ebt_carousel.field_ebt_carousel\";s:10:\"field_name\";s:18:\"field_ebt_carousel\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:12:\"ebt_carousel\";s:5:\"label\";s:8:\"Carousel\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:17:\"default:paragraph\";s:16:\"handler_settings\";a:3:{s:6:\"negate\";i:0;s:14:\"target_bundles\";a:1:{s:12:\"ebt_carousel\";s:12:\"ebt_carousel\";}s:24:\"target_bundles_drag_drop\";a:1:{s:12:\"ebt_carousel\";a:2:{s:7:\"enabled\";b:1;s:6:\"weight\";i:6;}}}}s:10:\"field_type\";s:26:\"entity_reference_revisions\";}'),
('',	'field.field.block_content.ebt_carousel.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"82540ccc-a725-412b-b6ba-bc89d09e03fb\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:31:\"block_content.type.ebt_carousel\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"U2Ky-DS_Wo_f9KN2f-PSJN975w1XnGxWcaly7VF6-tU\";}s:2:\"id\";s:45:\"block_content.ebt_carousel.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:12:\"ebt_carousel\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_columns.body',	'a:17:{s:4:\"uuid\";s:36:\"b6c8e80f-807f-4acf-b36e-55ea98dc4fb3\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"block_content.type.ebt_columns\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"WqbyqczhS3unr9KEuC6FRXfpi9rVW3mCtF8P2TGxkQI\";}s:2:\"id\";s:30:\"block_content.ebt_columns.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_columns\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_columns.field_ebt_columns_blocks',	'a:17:{s:4:\"uuid\";s:36:\"eca7b2b8-8806-49f1-ae15-756018a6c67f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"block_content.type.ebt_columns\";i:1;s:52:\"field.storage.block_content.field_ebt_columns_blocks\";}s:6:\"module\";a:1:{i:0;s:11:\"block_field\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"DlzRJb8gJARkGrf3IjWcpsIQfTvSJt9DmGRT1aBailQ\";}s:2:\"id\";s:50:\"block_content.ebt_columns.field_ebt_columns_blocks\";s:10:\"field_name\";s:24:\"field_ebt_columns_blocks\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_columns\";s:5:\"label\";s:6:\"Blocks\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:9:\"selection\";s:10:\"categories\";s:18:\"selection_settings\";a:1:{s:10:\"categories\";a:24:{s:5:\"Block\";s:5:\"Block\";s:14:\"Comment fields\";s:14:\"Comment fields\";s:22:\"Contact message fields\";s:22:\"Contact message fields\";s:13:\"Content block\";s:13:\"Content block\";s:20:\"Content block fields\";s:20:\"Content block fields\";s:14:\"Content fields\";s:14:\"Content fields\";s:4:\"core\";s:4:\"core\";s:23:\"Custom menu link fields\";s:23:\"Custom menu link fields\";s:11:\"File fields\";s:11:\"File fields\";s:5:\"Forms\";s:5:\"Forms\";s:4:\"Help\";s:4:\"Help\";s:13:\"Inline blocks\";s:13:\"Inline blocks\";s:13:\"Lists (Views)\";s:13:\"Lists (Views)\";s:12:\"Media fields\";s:12:\"Media fields\";s:5:\"Menus\";s:5:\"Menus\";s:16:\"Paragraph fields\";s:16:\"Paragraph fields\";s:20:\"Shortcut link fields\";s:20:\"Shortcut link fields\";s:6:\"System\";s:6:\"System\";s:20:\"Taxonomy term fields\";s:20:\"Taxonomy term fields\";s:16:\"URL alias fields\";s:16:\"URL alias fields\";s:4:\"User\";s:4:\"User\";s:11:\"User fields\";s:11:\"User fields\";s:7:\"Webform\";s:7:\"Webform\";s:25:\"Webform submission fields\";s:25:\"Webform submission fields\";}}}s:10:\"field_type\";s:11:\"block_field\";}'),
('',	'field.field.block_content.ebt_columns.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"9cc6560f-9a4a-4969-9e4b-0d667ef4817c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"block_content.type.ebt_columns\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"97Zeg-Y42bu_WIG-So7eo7DK0hKpS1XqwrJ1kGdYY8E\";}s:2:\"id\";s:44:\"block_content.ebt_columns.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_columns\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_countdown.body',	'a:17:{s:4:\"uuid\";s:36:\"7266abd1-c799-4ff0-96ef-b464471e6583\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:32:\"block_content.type.ebt_countdown\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7Eup8vFqqabcEdya_X4KmbnCSstllEkrmXRpfxOCdmU\";}s:2:\"id\";s:32:\"block_content.ebt_countdown.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"ebt_countdown\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_countdown.field_ebt_countdown_date',	'a:17:{s:4:\"uuid\";s:36:\"daee2d15-8abc-4764-8789-2fcf13604386\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:32:\"block_content.type.ebt_countdown\";i:1;s:52:\"field.storage.block_content.field_ebt_countdown_date\";}s:6:\"module\";a:1:{i:0;s:8:\"datetime\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"rS3ZCjiH3ZhM6LLmDYfxfr1x4lVA0pMJeUjgvHYJwJU\";}s:2:\"id\";s:52:\"block_content.ebt_countdown.field_ebt_countdown_date\";s:10:\"field_name\";s:24:\"field_ebt_countdown_date\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"ebt_countdown\";s:5:\"label\";s:14:\"Countdown date\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:8:\"datetime\";}'),
('',	'field.field.block_content.ebt_countdown.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"56e05cdb-f253-4954-9c39-5253face9482\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:32:\"block_content.type.ebt_countdown\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2Z_UQh0ye99krkSwmrnf32Lbdr_bJwll60WqPfcn3WQ\";}s:2:\"id\";s:46:\"block_content.ebt_countdown.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"ebt_countdown\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:12:\"ebt_settings\";a:2:{s:26:\"pass_options_to_javascript\";b:0;s:14:\"design_options\";a:2:{s:4:\"box1\";a:5:{s:10:\"margin_top\";s:0:\"\";s:12:\"margin_right\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:4:\"box2\";a:5:{s:10:\"border_top\";s:0:\"\";s:12:\"border_right\";s:0:\"\";s:13:\"border_bottom\";s:0:\"\";s:11:\"border_left\";s:0:\"\";s:4:\"box3\";a:4:{s:11:\"padding_top\";s:0:\"\";s:13:\"padding_right\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";}}}s:14:\"other_settings\";a:8:{s:12:\"border_color\";s:0:\"\";s:12:\"border_style\";s:5:\"solid\";s:13:\"border_radius\";s:4:\"none\";s:16:\"background_color\";s:0:\"\";s:16:\"background_media\";N;s:22:\"background_image_style\";s:7:\"default\";s:12:\"edge_to_edge\";i:0;s:15:\"container_width\";s:4:\"auto\";}}}}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_counter.body',	'a:17:{s:4:\"uuid\";s:36:\"c23a3476-69db-400e-a938-54992d1cfa18\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"block_content.type.ebt_counter\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"aNXxUnwWYqtaYNggYYhPjJH0IhNPU6aWjGZmWwC2Ock\";}s:2:\"id\";s:30:\"block_content.ebt_counter.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_counter\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_counter.field_ebt_counter_icon',	'a:17:{s:4:\"uuid\";s:36:\"9ba660a3-d550-47fe-aaa5-4325e7ffe30d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:30:\"block_content.type.ebt_counter\";i:1;s:50:\"field.storage.block_content.field_ebt_counter_icon\";i:2;s:16:\"media.type.image\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"AqwI810Vi6u8gzBeecbZAAUxasqqVBWGSG3usxdzT8Y\";}s:2:\"id\";s:48:\"block_content.ebt_counter.field_ebt_counter_icon\";s:10:\"field_name\";s:22:\"field_ebt_counter_icon\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_counter\";s:5:\"label\";s:4:\"Icon\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:13:\"default:media\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:5:\"image\";s:5:\"image\";}s:4:\"sort\";a:2:{s:5:\"field\";s:5:\"_none\";s:9:\"direction\";s:3:\"ASC\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.block_content.ebt_counter.field_ebt_counter_items',	'a:17:{s:4:\"uuid\";s:36:\"0776e496-c917-49a5-a502-a77f73b79b69\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:30:\"block_content.type.ebt_counter\";i:1;s:51:\"field.storage.block_content.field_ebt_counter_items\";i:2;s:43:\"paragraphs.paragraphs_type.ebt_counter_item\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"l82_oxjYqdf0vGlc2vOu3y3PdJhm9-QYk3j9aKOI-eg\";}s:2:\"id\";s:49:\"block_content.ebt_counter.field_ebt_counter_items\";s:10:\"field_name\";s:23:\"field_ebt_counter_items\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_counter\";s:5:\"label\";s:17:\"EBT Counter Items\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:17:\"default:paragraph\";s:16:\"handler_settings\";a:3:{s:14:\"target_bundles\";a:1:{s:16:\"ebt_counter_item\";s:16:\"ebt_counter_item\";}s:6:\"negate\";i:0;s:24:\"target_bundles_drag_drop\";a:1:{s:16:\"ebt_counter_item\";a:2:{s:6:\"weight\";i:12;s:7:\"enabled\";b:1;}}}}s:10:\"field_type\";s:26:\"entity_reference_revisions\";}'),
('',	'field.field.block_content.ebt_counter.field_ebt_counter_number',	'a:17:{s:4:\"uuid\";s:36:\"b4ecb5ee-b852-4360-ab89-92327a624bdf\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:30:\"block_content.type.ebt_counter\";i:1;s:52:\"field.storage.block_content.field_ebt_counter_number\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"xYrvXZvhuSrLAZDblfVrQO8BT0HeZGJKPail-de9LYQ\";}s:2:\"id\";s:50:\"block_content.ebt_counter.field_ebt_counter_number\";s:10:\"field_name\";s:24:\"field_ebt_counter_number\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_counter\";s:5:\"label\";s:6:\"Number\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:4:{s:3:\"min\";N;s:3:\"max\";N;s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";}s:10:\"field_type\";s:7:\"integer\";}'),
('',	'field.field.block_content.ebt_counter.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"1df891a3-3bde-4def-8c4e-79dd5182017a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"block_content.type.ebt_counter\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"-jefiww756YZOfPypjb0uMhOWdCkTYnChNabi-X7VTM\";}s:2:\"id\";s:44:\"block_content.ebt_counter.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_counter\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:12:\"ebt_settings\";a:2:{s:26:\"pass_options_to_javascript\";b:0;s:14:\"design_options\";a:2:{s:4:\"box1\";a:5:{s:10:\"margin_top\";s:0:\"\";s:12:\"margin_right\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:4:\"box2\";a:5:{s:10:\"border_top\";s:0:\"\";s:12:\"border_right\";s:0:\"\";s:13:\"border_bottom\";s:0:\"\";s:11:\"border_left\";s:0:\"\";s:4:\"box3\";a:4:{s:11:\"padding_top\";s:0:\"\";s:13:\"padding_right\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";}}}s:14:\"other_settings\";a:8:{s:12:\"border_color\";s:0:\"\";s:12:\"border_style\";s:5:\"solid\";s:13:\"border_radius\";s:4:\"none\";s:16:\"background_color\";s:0:\"\";s:16:\"background_media\";N;s:22:\"background_image_style\";s:7:\"default\";s:12:\"edge_to_edge\";i:0;s:15:\"container_width\";s:4:\"auto\";}}}}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_cta.body',	'a:17:{s:4:\"uuid\";s:36:\"55f4a1e8-6366-4c0b-aba3-0f05bdc8dccc\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:26:\"block_content.type.ebt_cta\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Xswlt75VBfRWb1lhRxDCEdmO2MWrGjyFMGZtNtNvvhs\";}s:2:\"id\";s:26:\"block_content.ebt_cta.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:7:\"ebt_cta\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_cta.field_ebt_cta_column_image',	'a:17:{s:4:\"uuid\";s:36:\"13cbf6a5-260c-40e0-b225-a8dd66d72da5\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:26:\"block_content.type.ebt_cta\";i:1;s:54:\"field.storage.block_content.field_ebt_cta_column_image\";i:2;s:16:\"media.type.image\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"BhJzD_e2sAj1RN0VJgS6aMUtzNeUEopdiFutXxsCBAk\";}s:2:\"id\";s:48:\"block_content.ebt_cta.field_ebt_cta_column_image\";s:10:\"field_name\";s:26:\"field_ebt_cta_column_image\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:7:\"ebt_cta\";s:5:\"label\";s:12:\"Column Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:13:\"default:media\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:5:\"image\";s:5:\"image\";}s:4:\"sort\";a:2:{s:5:\"field\";s:5:\"_none\";s:9:\"direction\";s:3:\"ASC\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.block_content.ebt_cta.field_ebt_cta_link',	'a:17:{s:4:\"uuid\";s:36:\"b2ba6467-2022-4aa3-9527-2821ef8b3866\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:26:\"block_content.type.ebt_cta\";i:1;s:46:\"field.storage.block_content.field_ebt_cta_link\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"kXVJG1nw4xsap-XsAKzJbpyAv6NK8jpGZ9eWXpGpewI\";}s:2:\"id\";s:40:\"block_content.ebt_cta.field_ebt_cta_link\";s:10:\"field_name\";s:18:\"field_ebt_cta_link\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:7:\"ebt_cta\";s:5:\"label\";s:4:\"Link\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:5:\"title\";i:1;s:9:\"link_type\";i:17;}s:10:\"field_type\";s:4:\"link\";}'),
('',	'field.field.block_content.ebt_cta.field_ebt_cta_second_link',	'a:17:{s:4:\"uuid\";s:36:\"21e7fce1-906b-4e52-94b2-deaee971de2d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:26:\"block_content.type.ebt_cta\";i:1;s:53:\"field.storage.block_content.field_ebt_cta_second_link\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"HYewglTA2MKbS8dL349fn4qm9mA-S_FxSL-Suhi0H2k\";}s:2:\"id\";s:47:\"block_content.ebt_cta.field_ebt_cta_second_link\";s:10:\"field_name\";s:25:\"field_ebt_cta_second_link\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:7:\"ebt_cta\";s:5:\"label\";s:11:\"Second Link\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:5:\"title\";i:2;s:9:\"link_type\";i:17;}s:10:\"field_type\";s:4:\"link\";}'),
('',	'field.field.block_content.ebt_cta.field_ebt_cta_title',	'a:17:{s:4:\"uuid\";s:36:\"67606c2f-9b8c-41b7-80d6-aa24493fa0d3\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:26:\"block_content.type.ebt_cta\";i:1;s:47:\"field.storage.block_content.field_ebt_cta_title\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"AKUtn2Ht2dlGYr9Y8at4yVXu5P1ozFKBdcgzWq44560\";}s:2:\"id\";s:41:\"block_content.ebt_cta.field_ebt_cta_title\";s:10:\"field_name\";s:19:\"field_ebt_cta_title\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:7:\"ebt_cta\";s:5:\"label\";s:5:\"Title\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.block_content.ebt_cta.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"b3a9c8ab-38aa-42a9-9c7a-8d9b4c4e0192\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:26:\"block_content.type.ebt_cta\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"o4qhawOFKN4zS8tfJKa0LamrN4V8y8cW4d55CAAP8EY\";}s:2:\"id\";s:40:\"block_content.ebt_cta.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:7:\"ebt_cta\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_hero.body',	'a:17:{s:4:\"uuid\";s:36:\"b99d81f7-46a3-4dd4-8588-c20bf7f86b06\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:27:\"block_content.type.ebt_hero\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Qut8svTV-WRC6mB8zNNFw0jqqJp5gzYemzlgnt3AElM\";}s:2:\"id\";s:27:\"block_content.ebt_hero.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_hero\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_hero.field_ebt_hero_column_image',	'a:17:{s:4:\"uuid\";s:36:\"47eab2ed-be4c-44cf-8125-61c4726d2170\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:27:\"block_content.type.ebt_hero\";i:1;s:55:\"field.storage.block_content.field_ebt_hero_column_image\";i:2;s:16:\"media.type.image\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"VbR985Mwa7blDm4IzjllHaKyIKieWmVaPhFiNTxALUg\";}s:2:\"id\";s:50:\"block_content.ebt_hero.field_ebt_hero_column_image\";s:10:\"field_name\";s:27:\"field_ebt_hero_column_image\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_hero\";s:5:\"label\";s:12:\"Column Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:13:\"default:media\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:5:\"image\";s:5:\"image\";}s:4:\"sort\";a:2:{s:5:\"field\";s:5:\"_none\";s:9:\"direction\";s:3:\"ASC\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.block_content.ebt_hero.field_ebt_hero_link',	'a:17:{s:4:\"uuid\";s:36:\"8c50936f-d412-4429-a9af-fe0720478b0f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:27:\"block_content.type.ebt_hero\";i:1;s:47:\"field.storage.block_content.field_ebt_hero_link\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"rDbic2tmAxT3Nwj4frhpQJGnF8nX1JE_Q3hu02XZ10o\";}s:2:\"id\";s:42:\"block_content.ebt_hero.field_ebt_hero_link\";s:10:\"field_name\";s:19:\"field_ebt_hero_link\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_hero\";s:5:\"label\";s:4:\"Link\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:5:\"title\";i:2;s:9:\"link_type\";i:17;}s:10:\"field_type\";s:4:\"link\";}'),
('',	'field.field.block_content.ebt_hero.field_ebt_hero_second_link',	'a:17:{s:4:\"uuid\";s:36:\"04371c34-46be-4086-ae87-cc361d2d3ced\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:27:\"block_content.type.ebt_hero\";i:1;s:54:\"field.storage.block_content.field_ebt_hero_second_link\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"1RX5_6HKYaNcisy7DgpQuSjGICKop8azTX3B6B_p8xc\";}s:2:\"id\";s:49:\"block_content.ebt_hero.field_ebt_hero_second_link\";s:10:\"field_name\";s:26:\"field_ebt_hero_second_link\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_hero\";s:5:\"label\";s:11:\"Second Link\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:5:\"title\";i:2;s:9:\"link_type\";i:17;}s:10:\"field_type\";s:4:\"link\";}'),
('',	'field.field.block_content.ebt_hero.field_ebt_hero_title',	'a:17:{s:4:\"uuid\";s:36:\"11b83dfa-e605-4b74-8cab-d665ab3d12a3\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:27:\"block_content.type.ebt_hero\";i:1;s:48:\"field.storage.block_content.field_ebt_hero_title\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"86hFjrfGlcIjrIIrmgUrVPJ3_QyoV2KsiqXTYhCAeR8\";}s:2:\"id\";s:43:\"block_content.ebt_hero.field_ebt_hero_title\";s:10:\"field_name\";s:20:\"field_ebt_hero_title\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_hero\";s:5:\"label\";s:5:\"Title\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.block_content.ebt_hero.field_ebt_hero_title_prefix',	'a:17:{s:4:\"uuid\";s:36:\"f115e5b7-c8ee-4130-9311-4bc5ac45d6d1\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:27:\"block_content.type.ebt_hero\";i:1;s:55:\"field.storage.block_content.field_ebt_hero_title_prefix\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"135nCPN0Zyg7GtNdwrEY1joFOZdHSUqBoP1cfFmTlws\";}s:2:\"id\";s:50:\"block_content.ebt_hero.field_ebt_hero_title_prefix\";s:10:\"field_name\";s:27:\"field_ebt_hero_title_prefix\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_hero\";s:5:\"label\";s:12:\"Title Prefix\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.block_content.ebt_hero.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"9ab7be9d-f391-4845-abb9-9620046d2cea\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:27:\"block_content.type.ebt_hero\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"T5k5YZCMxiQ-YbufcTAzxPfL6x68fxMB1znaMkjM1Ug\";}s:2:\"id\";s:41:\"block_content.ebt_hero.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_hero\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_image.field_ebt_image',	'a:17:{s:4:\"uuid\";s:36:\"f07c72d3-6387-4d4d-a4eb-5a81420e247b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:28:\"block_content.type.ebt_image\";i:1;s:43:\"field.storage.block_content.field_ebt_image\";i:2;s:16:\"media.type.image\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"W7kXKygcBjPcCe8gOrc11eBNXBHQWunB-xUjHS5ccZM\";}s:2:\"id\";s:39:\"block_content.ebt_image.field_ebt_image\";s:10:\"field_name\";s:15:\"field_ebt_image\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_image\";s:5:\"label\";s:5:\"Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:13:\"default:media\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:5:\"image\";s:5:\"image\";}s:4:\"sort\";a:2:{s:5:\"field\";s:5:\"_none\";s:9:\"direction\";s:3:\"ASC\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.block_content.ebt_image.field_ebt_image_caption',	'a:17:{s:4:\"uuid\";s:36:\"d7eb3cf3-fabf-4526-9e59-2559843a4b10\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_image\";i:1;s:51:\"field.storage.block_content.field_ebt_image_caption\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"WZl4X3tBs3QDBckRJjPbxFlnn9RiKDJXSb32UI78b0Y\";}s:2:\"id\";s:47:\"block_content.ebt_image.field_ebt_image_caption\";s:10:\"field_name\";s:23:\"field_ebt_image_caption\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_image\";s:5:\"label\";s:13:\"Image caption\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.block_content.ebt_image.field_ebt_image_link',	'a:17:{s:4:\"uuid\";s:36:\"d64d6cf7-d342-4551-933f-875ccf757101\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_image\";i:1;s:48:\"field.storage.block_content.field_ebt_image_link\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"WDCm4s-2KzOBP2lD1x_6iuJ28RmYQLSfvdSJ4KTS8hc\";}s:2:\"id\";s:44:\"block_content.ebt_image.field_ebt_image_link\";s:10:\"field_name\";s:20:\"field_ebt_image_link\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_image\";s:5:\"label\";s:10:\"Image Link\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:5:\"title\";i:0;s:9:\"link_type\";i:17;}s:10:\"field_type\";s:4:\"link\";}'),
('',	'field.field.block_content.ebt_image.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"4f2baecc-10aa-4164-b62a-d414a7a219b8\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_image\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Lo63F4kx4le3BFUXIP1j-nTj0TQ1wlVCW8T4eXa_Xu8\";}s:2:\"id\";s:42:\"block_content.ebt_image.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_image\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:12:\"ebt_settings\";a:2:{s:26:\"pass_options_to_javascript\";b:0;s:14:\"design_options\";a:2:{s:4:\"box1\";a:5:{s:10:\"margin_top\";s:0:\"\";s:12:\"margin_right\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:4:\"box2\";a:5:{s:10:\"border_top\";s:0:\"\";s:12:\"border_right\";s:0:\"\";s:13:\"border_bottom\";s:0:\"\";s:11:\"border_left\";s:0:\"\";s:4:\"box3\";a:4:{s:11:\"padding_top\";s:0:\"\";s:13:\"padding_right\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";}}}s:14:\"other_settings\";a:8:{s:12:\"border_color\";s:0:\"\";s:12:\"border_style\";s:5:\"solid\";s:13:\"border_radius\";s:4:\"none\";s:16:\"background_color\";s:0:\"\";s:16:\"background_media\";N;s:22:\"background_image_style\";s:7:\"default\";s:12:\"edge_to_edge\";i:0;s:15:\"container_width\";s:4:\"auto\";}}}}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_image_gallery.body',	'a:17:{s:4:\"uuid\";s:36:\"20361483-5f67-45d3-a3cb-a44f2e7bbae3\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:36:\"block_content.type.ebt_image_gallery\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"RI-w_mHu5j0k1rnEr3l73w0KQBcCH3Q6ZImikN8AdBw\";}s:2:\"id\";s:36:\"block_content.ebt_image_gallery.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:17:\"ebt_image_gallery\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_image_gallery.field_ebt_image_gallery',	'a:17:{s:4:\"uuid\";s:36:\"f76e7399-746c-4735-a354-63cad22949ff\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:36:\"block_content.type.ebt_image_gallery\";i:1;s:51:\"field.storage.block_content.field_ebt_image_gallery\";i:2;s:16:\"media.type.image\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"FAizD6Kvuyrbl5yxVgCp1vn4NLB9d-nI3wWWaqOR-kQ\";}s:2:\"id\";s:55:\"block_content.ebt_image_gallery.field_ebt_image_gallery\";s:10:\"field_name\";s:23:\"field_ebt_image_gallery\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:17:\"ebt_image_gallery\";s:5:\"label\";s:13:\"Image Gallery\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:13:\"default:media\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:5:\"image\";s:5:\"image\";}s:4:\"sort\";a:2:{s:5:\"field\";s:5:\"_none\";s:9:\"direction\";s:3:\"ASC\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.block_content.ebt_image_gallery.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"4c8c9d22-d8fd-4927-b62c-41815a17d1c4\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:36:\"block_content.type.ebt_image_gallery\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jJLv7Zyb3L4ZWqdYGWpZz_z81eZXwjYwQexwHk7WX2s\";}s:2:\"id\";s:50:\"block_content.ebt_image_gallery.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:17:\"ebt_image_gallery\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:12:\"ebt_settings\";a:2:{s:26:\"pass_options_to_javascript\";b:0;s:14:\"design_options\";a:2:{s:4:\"box1\";a:5:{s:10:\"margin_top\";s:0:\"\";s:12:\"margin_right\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:4:\"box2\";a:5:{s:10:\"border_top\";s:0:\"\";s:12:\"border_right\";s:0:\"\";s:13:\"border_bottom\";s:0:\"\";s:11:\"border_left\";s:0:\"\";s:4:\"box3\";a:4:{s:11:\"padding_top\";s:0:\"\";s:13:\"padding_right\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";}}}s:14:\"other_settings\";a:8:{s:12:\"border_color\";s:0:\"\";s:12:\"border_style\";s:5:\"solid\";s:13:\"border_radius\";s:4:\"none\";s:16:\"background_color\";s:0:\"\";s:16:\"background_media\";N;s:22:\"background_image_style\";s:7:\"default\";s:12:\"edge_to_edge\";i:0;s:15:\"container_width\";s:4:\"auto\";}}}}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_micromodal.body',	'a:17:{s:4:\"uuid\";s:36:\"1dd47019-ce01-47d2-8520-e5625b17bd32\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:33:\"block_content.type.ebt_micromodal\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"VfYtQCVLNmvze1_Qc3zTCMg2QFHln36_wjCm6y2MMWQ\";}s:2:\"id\";s:33:\"block_content.ebt_micromodal.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:14:\"ebt_micromodal\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_micromodal.field_ebt_micromodal_title',	'a:17:{s:4:\"uuid\";s:36:\"59e52aef-8c74-4576-ae43-df723099b73d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:33:\"block_content.type.ebt_micromodal\";i:1;s:54:\"field.storage.block_content.field_ebt_micromodal_title\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"lm4MPSDui0NEYaqvulzZIgmZumlIaUiE638_N0umXDI\";}s:2:\"id\";s:55:\"block_content.ebt_micromodal.field_ebt_micromodal_title\";s:10:\"field_name\";s:26:\"field_ebt_micromodal_title\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:14:\"ebt_micromodal\";s:5:\"label\";s:16:\"Micromodal Title\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.block_content.ebt_micromodal.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"157b9dd5-a769-42f1-9986-195e571255c4\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:33:\"block_content.type.ebt_micromodal\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ed-JI-p3sJDcQ3-4guJZ89L_Smftc8LwJ3Z_7XCW5rE\";}s:2:\"id\";s:47:\"block_content.ebt_micromodal.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:14:\"ebt_micromodal\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:12:\"ebt_settings\";a:2:{s:26:\"pass_options_to_javascript\";b:0;s:14:\"design_options\";a:2:{s:4:\"box1\";a:5:{s:10:\"margin_top\";s:0:\"\";s:12:\"margin_right\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:4:\"box2\";a:5:{s:10:\"border_top\";s:0:\"\";s:12:\"border_right\";s:0:\"\";s:13:\"border_bottom\";s:0:\"\";s:11:\"border_left\";s:0:\"\";s:4:\"box3\";a:4:{s:11:\"padding_top\";s:0:\"\";s:13:\"padding_right\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";}}}s:14:\"other_settings\";a:8:{s:12:\"border_color\";s:0:\"\";s:12:\"border_style\";s:5:\"solid\";s:13:\"border_radius\";s:4:\"none\";s:16:\"background_color\";s:0:\"\";s:16:\"background_media\";N;s:22:\"background_image_style\";s:7:\"default\";s:12:\"edge_to_edge\";i:0;s:15:\"container_width\";s:4:\"auto\";}}}}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_quote.body',	'a:17:{s:4:\"uuid\";s:36:\"bcd054c1-c1e6-47a1-9c84-af43855b0dc7\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_quote\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"RHJ2BeL7FRpMNmRALB5w7o8erlsGuBnb8MOaVvceiDo\";}s:2:\"id\";s:28:\"block_content.ebt_quote.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_quote\";s:5:\"label\";s:5:\"Quote\";s:11:\"description\";s:20:\"Quote or Testimonial\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_quote.field_ebt_quote_author',	'a:17:{s:4:\"uuid\";s:36:\"5c41064f-97a8-4a0e-aea7-eab453f27eb0\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_quote\";i:1;s:50:\"field.storage.block_content.field_ebt_quote_author\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"bcr-ywW2dLY1kQTCKA6fqxCSgq_nrKEgCB1wj_G8rOs\";}s:2:\"id\";s:46:\"block_content.ebt_quote.field_ebt_quote_author\";s:10:\"field_name\";s:22:\"field_ebt_quote_author\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_quote\";s:5:\"label\";s:12:\"Quote Author\";s:11:\"description\";s:44:\"Company name, Persona name and job position.\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.block_content.ebt_quote.field_ebt_quote_image',	'a:17:{s:4:\"uuid\";s:36:\"aa44dee9-e2fb-4a02-8f85-0ed2534a54e9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:28:\"block_content.type.ebt_quote\";i:1;s:49:\"field.storage.block_content.field_ebt_quote_image\";i:2;s:16:\"media.type.image\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"_AaWTlSa1X6CaC-_c0qarZPGAD9IaSjpuJF_CUK9vk0\";}s:2:\"id\";s:45:\"block_content.ebt_quote.field_ebt_quote_image\";s:10:\"field_name\";s:21:\"field_ebt_quote_image\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_quote\";s:5:\"label\";s:11:\"Quote Image\";s:11:\"description\";s:29:\"Persona photo or Company logo\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:13:\"default:media\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:5:\"image\";s:5:\"image\";}s:4:\"sort\";a:2:{s:5:\"field\";s:5:\"_none\";s:9:\"direction\";s:3:\"ASC\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.block_content.ebt_quote.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"c5fb6c52-df83-49a6-982d-13cd459b5086\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_quote\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"gKtk0T_7VnCmUPgUgJX1z7v13az3bkGF3bazJXEwZ_o\";}s:2:\"id\";s:42:\"block_content.ebt_quote.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_quote\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:12:\"ebt_settings\";a:2:{s:26:\"pass_options_to_javascript\";b:0;s:14:\"design_options\";a:2:{s:4:\"box1\";a:5:{s:10:\"margin_top\";s:0:\"\";s:12:\"margin_right\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:4:\"box2\";a:5:{s:10:\"border_top\";s:0:\"\";s:12:\"border_right\";s:0:\"\";s:13:\"border_bottom\";s:0:\"\";s:11:\"border_left\";s:0:\"\";s:4:\"box3\";a:4:{s:11:\"padding_top\";s:0:\"\";s:13:\"padding_right\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";}}}s:14:\"other_settings\";a:8:{s:12:\"border_color\";s:0:\"\";s:12:\"border_style\";s:5:\"solid\";s:13:\"border_radius\";s:4:\"none\";s:16:\"background_color\";s:0:\"\";s:16:\"background_media\";N;s:22:\"background_image_style\";s:7:\"default\";s:12:\"edge_to_edge\";i:0;s:15:\"container_width\";s:4:\"auto\";}}}}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_slick_slider.body',	'a:17:{s:4:\"uuid\";s:36:\"ac203ba4-4731-48c0-a489-49772d98bbcc\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:35:\"block_content.type.ebt_slick_slider\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"1VYVNgk5Hp9ZSjh89NrWVzpkv3BfOpNJz3E_qlTqNkY\";}s:2:\"id\";s:35:\"block_content.ebt_slick_slider.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:16:\"ebt_slick_slider\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_slick_slider.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"35e70eb2-5981-4ca9-9540-a6263e5f01ee\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:35:\"block_content.type.ebt_slick_slider\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"YIrMWNLT6TiXF-tmAzVOGQaDbDkIa_qy9_KBL0B4TxA\";}s:2:\"id\";s:49:\"block_content.ebt_slick_slider.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:16:\"ebt_slick_slider\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_slick_slider.field_ebt_slick_slider',	'a:17:{s:4:\"uuid\";s:36:\"237e10e6-95ca-4f5e-9d1b-2f1d8f7eef67\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:35:\"block_content.type.ebt_slick_slider\";i:1;s:50:\"field.storage.block_content.field_ebt_slick_slider\";i:2;s:43:\"paragraphs.paragraphs_type.ebt_slick_slider\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eH6HMdmAatyKEevKR8YXk2VH3AF_ntUZim5F7X5D3Cc\";}s:2:\"id\";s:53:\"block_content.ebt_slick_slider.field_ebt_slick_slider\";s:10:\"field_name\";s:22:\"field_ebt_slick_slider\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:16:\"ebt_slick_slider\";s:5:\"label\";s:12:\"Slick Slider\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:17:\"default:paragraph\";s:16:\"handler_settings\";a:3:{s:14:\"target_bundles\";a:1:{s:16:\"ebt_slick_slider\";s:16:\"ebt_slick_slider\";}s:6:\"negate\";i:0;s:24:\"target_bundles_drag_drop\";a:1:{s:16:\"ebt_slick_slider\";a:2:{s:6:\"weight\";i:9;s:7:\"enabled\";b:1;}}}}s:10:\"field_type\";s:26:\"entity_reference_revisions\";}'),
('',	'field.field.block_content.ebt_slideshow.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"f6196b18-31e7-4003-842a-206131de10c0\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:32:\"block_content.type.ebt_slideshow\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"oveTq0gmp5_KAESCvT3DtytAnJElJGWzrHzr1lEb-x0\";}s:2:\"id\";s:46:\"block_content.ebt_slideshow.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"ebt_slideshow\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_slideshow.field_ebt_slideshow',	'a:17:{s:4:\"uuid\";s:36:\"dfe1a625-168b-485c-9c9e-2e8296f0dec8\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:32:\"block_content.type.ebt_slideshow\";i:1;s:47:\"field.storage.block_content.field_ebt_slideshow\";i:2;s:40:\"paragraphs.paragraphs_type.ebt_slideshow\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"0sk3ViXko3tl_QC0x0GggU_08m7tEtKEoNDg9vwOE-Q\";}s:2:\"id\";s:47:\"block_content.ebt_slideshow.field_ebt_slideshow\";s:10:\"field_name\";s:19:\"field_ebt_slideshow\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"ebt_slideshow\";s:5:\"label\";s:9:\"Slideshow\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:17:\"default:paragraph\";s:16:\"handler_settings\";a:3:{s:6:\"negate\";i:0;s:14:\"target_bundles\";a:1:{s:13:\"ebt_slideshow\";s:13:\"ebt_slideshow\";}s:24:\"target_bundles_drag_drop\";a:1:{s:13:\"ebt_slideshow\";a:2:{s:7:\"enabled\";b:1;s:6:\"weight\";i:5;}}}}s:10:\"field_type\";s:26:\"entity_reference_revisions\";}'),
('',	'field.field.block_content.ebt_stats.body',	'a:17:{s:4:\"uuid\";s:36:\"33c69170-b2b4-49a9-9557-a9542eb08865\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_stats\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"qjLV8uviFQzoYVcltie2--7y-ZZpauda_owKbFf-IPA\";}s:2:\"id\";s:28:\"block_content.ebt_stats.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_stats\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_stats.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"1e3aa7ba-222f-4f33-8628-7c5bf22f00fe\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_stats\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Yhkjb0s5PYlfHuk2JdMtwch30e3IZCjz8R1KMJqE4JA\";}s:2:\"id\";s:42:\"block_content.ebt_stats.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_stats\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:12:\"ebt_settings\";a:2:{s:26:\"pass_options_to_javascript\";b:0;s:14:\"design_options\";a:2:{s:4:\"box1\";a:5:{s:10:\"margin_top\";s:0:\"\";s:12:\"margin_right\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:4:\"box2\";a:5:{s:10:\"border_top\";s:0:\"\";s:12:\"border_right\";s:0:\"\";s:13:\"border_bottom\";s:0:\"\";s:11:\"border_left\";s:0:\"\";s:4:\"box3\";a:4:{s:11:\"padding_top\";s:0:\"\";s:13:\"padding_right\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";}}}s:14:\"other_settings\";a:8:{s:12:\"border_color\";s:0:\"\";s:12:\"border_style\";s:5:\"solid\";s:13:\"border_radius\";s:4:\"none\";s:16:\"background_color\";s:0:\"\";s:16:\"background_media\";N;s:22:\"background_image_style\";s:7:\"default\";s:12:\"edge_to_edge\";i:0;s:15:\"container_width\";s:4:\"auto\";}}}}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_stats.field_ebt_stats',	'a:17:{s:4:\"uuid\";s:36:\"280d2344-5e0c-42f5-bd77-7b358f9b2c08\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:28:\"block_content.type.ebt_stats\";i:1;s:43:\"field.storage.block_content.field_ebt_stats\";i:2;s:41:\"paragraphs.paragraphs_type.ebt_stats_item\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"j6MsUG9RUUe4pToCAeVx7TIOtSMQyibl7ikftOLpXqA\";}s:2:\"id\";s:39:\"block_content.ebt_stats.field_ebt_stats\";s:10:\"field_name\";s:15:\"field_ebt_stats\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_stats\";s:5:\"label\";s:9:\"EBT Stats\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:17:\"default:paragraph\";s:16:\"handler_settings\";a:3:{s:14:\"target_bundles\";a:1:{s:14:\"ebt_stats_item\";s:14:\"ebt_stats_item\";}s:6:\"negate\";i:0;s:24:\"target_bundles_drag_drop\";a:1:{s:14:\"ebt_stats_item\";a:2:{s:6:\"weight\";i:12;s:7:\"enabled\";b:1;}}}}s:10:\"field_type\";s:26:\"entity_reference_revisions\";}'),
('',	'field.field.block_content.ebt_tabs.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"1396353c-ec74-4693-9d16-7ffb5a6090cc\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:27:\"block_content.type.ebt_tabs\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"_Gn1i1ea7T8MzoBSjiDcnQMYgfSAq2jN9g-ZJfv27PA\";}s:2:\"id\";s:41:\"block_content.ebt_tabs.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_tabs\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_tabs.field_ebt_tabs',	'a:17:{s:4:\"uuid\";s:36:\"b89072e5-91ec-40a1-aa9c-2a20808308cb\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:27:\"block_content.type.ebt_tabs\";i:1;s:42:\"field.storage.block_content.field_ebt_tabs\";i:2;s:34:\"paragraphs.paragraphs_type.ebt_tab\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"4qzYKe-tuRQPHfXtyOyfFfwSfj-Onz88kqc6nsXX4ns\";}s:2:\"id\";s:37:\"block_content.ebt_tabs.field_ebt_tabs\";s:10:\"field_name\";s:14:\"field_ebt_tabs\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_tabs\";s:5:\"label\";s:4:\"Tabs\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:17:\"default:paragraph\";s:16:\"handler_settings\";a:3:{s:6:\"negate\";i:0;s:14:\"target_bundles\";a:1:{s:7:\"ebt_tab\";s:7:\"ebt_tab\";}s:24:\"target_bundles_drag_drop\";a:1:{s:7:\"ebt_tab\";a:2:{s:7:\"enabled\";b:1;s:6:\"weight\";i:2;}}}}s:10:\"field_type\";s:26:\"entity_reference_revisions\";}'),
('',	'field.field.block_content.ebt_text.body',	'a:17:{s:4:\"uuid\";s:36:\"c72f430e-7366-4a91-bce3-aa5dc0cf8726\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:27:\"block_content.type.ebt_text\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"htRzt66f_OSqHawgprrWKiHiaLoBZUKzc0aMsoIVRlI\";}s:2:\"id\";s:27:\"block_content.ebt_text.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_text\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_text.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"2a94aaad-3c54-4074-9d7a-fc204b0cc509\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:27:\"block_content.type.ebt_text\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"G1bcFZfGqQcn1FyernQez0LoRoXBRPKXAjI6-yZKMGw\";}s:2:\"id\";s:41:\"block_content.ebt_text.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:8:\"ebt_text\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_tiles.body',	'a:17:{s:4:\"uuid\";s:36:\"b13d5126-3f86-4bb5-8cdc-a9b72478ab6b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_tiles\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"hru15RrwqNoJ9o_uoGV1KT2wAkHwJsGaTj7KF0sIZxU\";}s:2:\"id\";s:28:\"block_content.ebt_tiles.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_tiles\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_tiles.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"34788ebc-a5ee-43a6-be6c-58bf07f8a47a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_tiles\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"J3ICag16O5nBkU9zwYLt76LvxEF78Qt-pDCJWA5n1Q4\";}s:2:\"id\";s:42:\"block_content.ebt_tiles.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_tiles\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_tiles.field_ebt_tiles',	'a:17:{s:4:\"uuid\";s:36:\"2e2ec692-0d82-4b56-9cfc-4e871f3a1882\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:28:\"block_content.type.ebt_tiles\";i:1;s:43:\"field.storage.block_content.field_ebt_tiles\";i:2;s:41:\"paragraphs.paragraphs_type.ebt_tiles_item\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"L9cDmlbMT83s3nbfD0cDfsf0BnRv1fpAyA4KTplqxJs\";}s:2:\"id\";s:39:\"block_content.ebt_tiles.field_ebt_tiles\";s:10:\"field_name\";s:15:\"field_ebt_tiles\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_tiles\";s:5:\"label\";s:5:\"Tiles\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:17:\"default:paragraph\";s:16:\"handler_settings\";a:3:{s:14:\"target_bundles\";a:1:{s:14:\"ebt_tiles_item\";s:14:\"ebt_tiles_item\";}s:6:\"negate\";i:0;s:24:\"target_bundles_drag_drop\";a:1:{s:14:\"ebt_tiles_item\";a:2:{s:6:\"weight\";i:45;s:7:\"enabled\";b:1;}}}}s:10:\"field_type\";s:26:\"entity_reference_revisions\";}'),
('',	'field.field.block_content.ebt_timeline.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"72a4ef65-870a-4488-8009-80269e968b1b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:31:\"block_content.type.ebt_timeline\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"HN5G2K_JDpCXJ8t1Hf1GlS9QdBeEP63Bly-VhnBB6sc\";}s:2:\"id\";s:45:\"block_content.ebt_timeline.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:12:\"ebt_timeline\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_timeline.field_ebt_timeline',	'a:17:{s:4:\"uuid\";s:36:\"87a15adf-8be6-4080-925b-ebc76f101b32\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:31:\"block_content.type.ebt_timeline\";i:1;s:46:\"field.storage.block_content.field_ebt_timeline\";i:2;s:39:\"paragraphs.paragraphs_type.ebt_timeline\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"OpOMqlp0m970YTcVsX9wdXHaI-hN6RW9eawnPmz3KtQ\";}s:2:\"id\";s:45:\"block_content.ebt_timeline.field_ebt_timeline\";s:10:\"field_name\";s:18:\"field_ebt_timeline\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:12:\"ebt_timeline\";s:5:\"label\";s:8:\"Timeline\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:17:\"default:paragraph\";s:16:\"handler_settings\";a:3:{s:6:\"negate\";i:0;s:14:\"target_bundles\";a:1:{s:12:\"ebt_timeline\";s:12:\"ebt_timeline\";}s:24:\"target_bundles_drag_drop\";a:1:{s:12:\"ebt_timeline\";a:2:{s:7:\"enabled\";b:1;s:6:\"weight\";i:10;}}}}s:10:\"field_type\";s:26:\"entity_reference_revisions\";}'),
('',	'field.field.block_content.ebt_video.body',	'a:17:{s:4:\"uuid\";s:36:\"9b4acfb1-3d8e-4e3d-8901-6120a3b342b2\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_video\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nJmLT9YexVdfd-JSg5eErRWt3FrtaozSqR_v29xtRwU\";}s:2:\"id\";s:28:\"block_content.ebt_video.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_video\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_video.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"55445905-ca67-4040-b176-00e1fc2ebb3e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_video\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ZSSE8vNHSVgLXEAdnpSbPDmk02qrlhm3jj3AJhOLGDs\";}s:2:\"id\";s:42:\"block_content.ebt_video.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_video\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_video.field_ebt_video',	'a:17:{s:4:\"uuid\";s:36:\"2e653244-7a00-41c7-a943-06eade5f15ef\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:4:{i:0;s:28:\"block_content.type.ebt_video\";i:1;s:43:\"field.storage.block_content.field_ebt_video\";i:2;s:23:\"media.type.remote_video\";i:3;s:16:\"media.type.video\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"HK8CWqddmUhsshgNl5XJCSCl0ZgJWByyd-uQp8gR9to\";}s:2:\"id\";s:39:\"block_content.ebt_video.field_ebt_video\";s:10:\"field_name\";s:15:\"field_ebt_video\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_video\";s:5:\"label\";s:5:\"Video\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:13:\"default:media\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:2:{s:12:\"remote_video\";s:12:\"remote_video\";s:5:\"video\";s:5:\"video\";}s:4:\"sort\";a:2:{s:5:\"field\";s:5:\"_none\";s:9:\"direction\";s:3:\"ASC\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:12:\"remote_video\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.block_content.ebt_video_and_image_gallery.body',	'a:17:{s:4:\"uuid\";s:36:\"161669c7-6a7e-4616-86d5-a2e3de9c8fe5\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:46:\"block_content.type.ebt_video_and_image_gallery\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"1OrJhHg5mGo5emzkaM2Z6ClqRPHEtI72w5kwSnSWOaI\";}s:2:\"id\";s:46:\"block_content.ebt_video_and_image_gallery.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:27:\"ebt_video_and_image_gallery\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_video_and_image_gallery.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"278f7615-4ab0-4e87-963f-33f2ae8f78ed\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:46:\"block_content.type.ebt_video_and_image_gallery\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"5WWOgyldW7uBFXBGN623Yc_zkiry6HnXAn0L5CywrsI\";}s:2:\"id\";s:60:\"block_content.ebt_video_and_image_gallery.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:27:\"ebt_video_and_image_gallery\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:12:\"ebt_settings\";a:2:{s:26:\"pass_options_to_javascript\";b:0;s:14:\"design_options\";a:2:{s:4:\"box1\";a:5:{s:10:\"margin_top\";s:0:\"\";s:12:\"margin_right\";s:0:\"\";s:13:\"margin_bottom\";s:0:\"\";s:11:\"margin_left\";s:0:\"\";s:4:\"box2\";a:5:{s:10:\"border_top\";s:0:\"\";s:12:\"border_right\";s:0:\"\";s:13:\"border_bottom\";s:0:\"\";s:11:\"border_left\";s:0:\"\";s:4:\"box3\";a:4:{s:11:\"padding_top\";s:0:\"\";s:13:\"padding_right\";s:0:\"\";s:14:\"padding_bottom\";s:0:\"\";s:12:\"padding_left\";s:0:\"\";}}}s:14:\"other_settings\";a:8:{s:12:\"border_color\";s:0:\"\";s:12:\"border_style\";s:5:\"solid\";s:13:\"border_radius\";s:4:\"none\";s:16:\"background_color\";s:0:\"\";s:16:\"background_media\";N;s:22:\"background_image_style\";s:7:\"default\";s:12:\"edge_to_edge\";i:0;s:15:\"container_width\";s:4:\"auto\";}}}}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_video_and_image_gallery.field_ebt_videos_and_images',	'a:17:{s:4:\"uuid\";s:36:\"efc991a5-26b8-4df3-977e-953a90c2f86c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:46:\"block_content.type.ebt_video_and_image_gallery\";i:1;s:55:\"field.storage.block_content.field_ebt_videos_and_images\";i:2;s:59:\"paragraphs.paragraphs_type.ebt_video_and_image_gallery_item\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"kZTsNALzCfl1z3gE4CQ1OVfS633RZUMyI5ZBPiMVnm0\";}s:2:\"id\";s:69:\"block_content.ebt_video_and_image_gallery.field_ebt_videos_and_images\";s:10:\"field_name\";s:27:\"field_ebt_videos_and_images\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:27:\"ebt_video_and_image_gallery\";s:5:\"label\";s:17:\"Videos and Images\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:17:\"default:paragraph\";s:16:\"handler_settings\";a:3:{s:14:\"target_bundles\";a:1:{s:32:\"ebt_video_and_image_gallery_item\";s:32:\"ebt_video_and_image_gallery_item\";}s:6:\"negate\";i:0;s:24:\"target_bundles_drag_drop\";a:1:{s:32:\"ebt_video_and_image_gallery_item\";a:2:{s:6:\"weight\";i:16;s:7:\"enabled\";b:1;}}}}s:10:\"field_type\";s:26:\"entity_reference_revisions\";}'),
('',	'field.field.block_content.ebt_views.body',	'a:17:{s:4:\"uuid\";s:36:\"f746c64f-5c49-4079-bb53-0a1a1dd1a7c4\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_views\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"gYULmkk3OY2DQugmZyL9Fv_2Car9QCaQzCeihnGhfPI\";}s:2:\"id\";s:28:\"block_content.ebt_views.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_views\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_views.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"3a0e2513-d1ec-4966-9162-427a855b0977\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_views\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ZrXPDXifY_gudYEr4cT9o_GDEspGqI6gFQgTyN_6RdM\";}s:2:\"id\";s:42:\"block_content.ebt_views.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_views\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_views.field_ebt_views_views',	'a:17:{s:4:\"uuid\";s:36:\"5f1f69e3-3f90-4442-95f1-5c1579c679ab\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:28:\"block_content.type.ebt_views\";i:1;s:49:\"field.storage.block_content.field_ebt_views_views\";}s:6:\"module\";a:1:{i:0;s:14:\"viewsreference\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"MAlu-k2uullIwcqbzIvVPeeMm6-JiW5Ev0USbMEGejk\";}s:2:\"id\";s:45:\"block_content.ebt_views.field_ebt_views_views\";s:10:\"field_name\";s:21:\"field_ebt_views_views\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:9:\"ebt_views\";s:5:\"label\";s:5:\"Views\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:5:{s:7:\"handler\";s:12:\"default:view\";s:16:\"handler_settings\";a:2:{s:14:\"target_bundles\";N;s:11:\"auto_create\";b:0;}s:12:\"plugin_types\";a:2:{s:4:\"page\";s:4:\"page\";s:5:\"block\";s:5:\"block\";}s:15:\"preselect_views\";a:0:{}s:16:\"enabled_settings\";a:0:{}}s:10:\"field_type\";s:14:\"viewsreference\";}'),
('',	'field.field.block_content.ebt_webform.body',	'a:17:{s:4:\"uuid\";s:36:\"8733818b-9c02-4e2c-91a6-045583f1e01d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"block_content.type.ebt_webform\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Baa8yf9wUinT0D2-5V7tRKydSUOfQvZsUuTvSBeC-bQ\";}s:2:\"id\";s:30:\"block_content.ebt_webform.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_webform\";s:5:\"label\";s:4:\"Text\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.block_content.ebt_webform.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"a50fcf2c-9887-448e-a18c-78ac4e87b38c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"block_content.type.ebt_webform\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"VOgJYtNjHNsjml3J6mwuL3oMqXc4JPjPD8gGVHyGftg\";}s:2:\"id\";s:44:\"block_content.ebt_webform.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_webform\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_webform.field_ebt_webform_form',	'a:17:{s:4:\"uuid\";s:36:\"9c984eac-a275-47d3-a7ac-029f8216fcb8\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"block_content.type.ebt_webform\";i:1;s:50:\"field.storage.block_content.field_ebt_webform_form\";}s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"S36GzWuHJCt3YstEnQsUPzQ1dwXpO2MKmqaAgoQ2eb4\";}s:2:\"id\";s:48:\"block_content.ebt_webform.field_ebt_webform_form\";s:10:\"field_name\";s:22:\"field_ebt_webform_form\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:11:\"ebt_webform\";s:5:\"label\";s:4:\"Form\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:15:\"default:webform\";s:16:\"handler_settings\";a:2:{s:14:\"target_bundles\";N;s:11:\"auto_create\";b:0;}}s:10:\"field_type\";s:7:\"webform\";}'),
('',	'field.field.block_content.ebt_webform_popup.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"7bd9f73f-8c64-46d8-9848-e86bcb5b491e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:36:\"block_content.type.ebt_webform_popup\";i:1;s:46:\"field.storage.block_content.field_ebt_settings\";}s:6:\"module\";a:1:{i:0;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nY4Z9bxYtEWKQwTfEQV5y1aJi2T_PME930j0zdUd6e4\";}s:2:\"id\";s:50:\"block_content.ebt_webform_popup.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:17:\"ebt_webform_popup\";s:5:\"label\";s:14:\"Block settings\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:12:\"ebt_settings\";}'),
('',	'field.field.block_content.ebt_webform_popup.field_ebt_webform_popup_form',	'a:17:{s:4:\"uuid\";s:36:\"ebbc4709-9eb2-4a48-bc09-0d83eaad805d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:36:\"block_content.type.ebt_webform_popup\";i:1;s:56:\"field.storage.block_content.field_ebt_webform_popup_form\";}s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"XKxb-rFq0rOSgKq7mU1s79aoU0-O0IeICu_ZMzj9vG8\";}s:2:\"id\";s:60:\"block_content.ebt_webform_popup.field_ebt_webform_popup_form\";s:10:\"field_name\";s:28:\"field_ebt_webform_popup_form\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:17:\"ebt_webform_popup\";s:5:\"label\";s:7:\"Webform\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:15:\"default:webform\";s:16:\"handler_settings\";a:2:{s:14:\"target_bundles\";N;s:11:\"auto_create\";b:0;}}s:10:\"field_type\";s:7:\"webform\";}'),
('',	'field.field.media.audio.field_media_audio_file',	'a:17:{s:4:\"uuid\";s:36:\"4fa57014-dbe5-4dc4-b5c9-e6cb3404ad5c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:42:\"field.storage.media.field_media_audio_file\";i:1;s:16:\"media.type.audio\";}s:6:\"module\";a:1:{i:0;s:4:\"file\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"UlZPIbHcLyNqGY5bvydCTijGcKDmwn4Fo8oYZT85wlk\";}s:2:\"id\";s:34:\"media.audio.field_media_audio_file\";s:10:\"field_name\";s:22:\"field_media_audio_file\";s:11:\"entity_type\";s:5:\"media\";s:6:\"bundle\";s:5:\"audio\";s:5:\"label\";s:10:\"Audio file\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:6:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:11:\"mp3 wav aac\";s:12:\"max_filesize\";s:0:\"\";s:17:\"description_field\";b:0;}s:10:\"field_type\";s:4:\"file\";}'),
('',	'field.field.media.document.field_media_document',	'a:17:{s:4:\"uuid\";s:36:\"1ebfa792-cf03-471d-9e5c-2dccd1fedd38\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:2:{i:0;s:40:\"field.storage.media.field_media_document\";i:1;s:19:\"media.type.document\";}s:6:\"module\";a:1:{i:0;s:4:\"file\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"DY5HtJTxUjFRGU_PaY6ifo2nhR-nAZ0y0s6kLmUbv5g\";}s:2:\"id\";s:35:\"media.document.field_media_document\";s:10:\"field_name\";s:20:\"field_media_document\";s:11:\"entity_type\";s:5:\"media\";s:6:\"bundle\";s:8:\"document\";s:5:\"label\";s:8:\"Document\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:6:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:96:\"txt rtf doc docx ppt pptx xls xlsx pdf odf odg odp ods odt fodt fods fodp fodg key numbers pages\";s:12:\"max_filesize\";s:0:\"\";s:17:\"description_field\";b:0;}s:10:\"field_type\";s:4:\"file\";}'),
('',	'field.field.media.image.field_media_image',	'a:17:{s:4:\"uuid\";s:36:\"e2b79a9d-deda-4076-bcbe-2c9ae00b616e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:2:{i:0;s:37:\"field.storage.media.field_media_image\";i:1;s:16:\"media.type.image\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"P7CkVOgjDXiN26Fm2hniNei-XPK3iuZTlcBGqreTbJ0\";}s:2:\"id\";s:29:\"media.image.field_media_image\";s:10:\"field_name\";s:17:\"field_media_image\";s:11:\"entity_type\";s:5:\"media\";s:6:\"bundle\";s:5:\"image\";s:5:\"label\";s:5:\"Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:25:\"png gif jpg jpeg webp svg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:1;s:18:\"alt_field_required\";b:1;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:10:\"field_type\";s:5:\"image\";}'),
('',	'field.field.media.remote_video.field_media_oembed_video',	'a:17:{s:4:\"uuid\";s:36:\"96b9388f-0779-4e2b-8429-6932b1a68ead\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:44:\"field.storage.media.field_media_oembed_video\";i:1;s:23:\"media.type.remote_video\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Eo4HHenV5iZat_kEWgr_wydD3TgwURMCzwt-7qIEyoM\";}s:2:\"id\";s:43:\"media.remote_video.field_media_oembed_video\";s:10:\"field_name\";s:24:\"field_media_oembed_video\";s:11:\"entity_type\";s:5:\"media\";s:6:\"bundle\";s:12:\"remote_video\";s:5:\"label\";s:9:\"Video URL\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}'),
('',	'field.field.media.video.field_media_video_file',	'a:17:{s:4:\"uuid\";s:36:\"af846c60-eb6c-4029-84b4-aa0ccf412591\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:42:\"field.storage.media.field_media_video_file\";i:1;s:16:\"media.type.video\";}s:6:\"module\";a:1:{i:0;s:4:\"file\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6kMMjmk2r_csGQ52qI9BUaO8r_oAzNLbxlclaj-JlDQ\";}s:2:\"id\";s:34:\"media.video.field_media_video_file\";s:10:\"field_name\";s:22:\"field_media_video_file\";s:11:\"entity_type\";s:5:\"media\";s:6:\"bundle\";s:5:\"video\";s:5:\"label\";s:10:\"Video file\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:6:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:3:\"mp4\";s:12:\"max_filesize\";s:0:\"\";s:17:\"description_field\";b:0;}s:10:\"field_type\";s:4:\"file\";}'),
('',	'field.field.node.article.body',	'a:17:{s:4:\"uuid\";s:36:\"7f75b85e-a8a9-4e63-8ba8-42cd18f1d713\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:23:\"field.storage.node.body\";i:1;s:17:\"node.type.article\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"4Wxs1LseZ8JsNwD9uJVIbzZqG35yQXN8Eo1Hub6NMuI\";}s:2:\"id\";s:17:\"node.article.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:1;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.node.article.field_image',	'a:17:{s:4:\"uuid\";s:36:\"ba97827c-59cc-4fb5-be06-7c44f9e98113\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"field.storage.node.field_image\";i:1;s:17:\"node.type.article\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"j0riO_-77ZFWNLtj0iJ31HnohiNjdn8HUL86RueCF-M\";}s:2:\"id\";s:24:\"node.article.field_image\";s:10:\"field_name\";s:11:\"field_image\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:5:\"label\";s:12:\"Teaser Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:21:\"png gif jpg jpeg webp\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:1;s:18:\"alt_field_required\";b:1;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:10:\"field_type\";s:5:\"image\";}'),
('',	'field.field.node.article.field_metatags',	'a:16:{s:4:\"uuid\";s:36:\"06f91975-9ecb-430d-b7f8-3de8ae8601c8\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:33:\"field.storage.node.field_metatags\";i:1;s:17:\"node.type.article\";}s:6:\"module\";a:1:{i:0;s:7:\"metatag\";}}s:2:\"id\";s:27:\"node.article.field_metatags\";s:10:\"field_name\";s:14:\"field_metatags\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:5:\"label\";s:8:\"Metatags\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:7:\"metatag\";}'),
('',	'field.field.node.article.field_tags',	'a:17:{s:4:\"uuid\";s:36:\"61a810a4-e29c-4fbf-b132-9fe51b115626\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:29:\"field.storage.node.field_tags\";i:1;s:17:\"node.type.article\";i:2;s:24:\"taxonomy.vocabulary.tags\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"QdUgf_beeoaPiyKorFv0q1fcJpWH_uZTqe_xoVJacrw\";}s:2:\"id\";s:23:\"node.article.field_tags\";s:10:\"field_name\";s:10:\"field_tags\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:5:\"label\";s:4:\"Tags\";s:11:\"description\";s:84:\"Enter a comma-separated list. For example: Amsterdam, Mexico City, \"Cleveland, Ohio\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:21:\"default:taxonomy_term\";s:16:\"handler_settings\";a:3:{s:14:\"target_bundles\";a:1:{s:4:\"tags\";s:4:\"tags\";}s:4:\"sort\";a:1:{s:5:\"field\";s:5:\"_none\";}s:11:\"auto_create\";b:1;}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.node.article.layout_builder__layout',	'a:16:{s:4:\"uuid\";s:36:\"97640446-27d5-4146-8b2a-a776d7a62ec7\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:41:\"field.storage.node.layout_builder__layout\";i:1;s:17:\"node.type.article\";}s:6:\"module\";a:1:{i:0;s:14:\"layout_builder\";}}s:2:\"id\";s:35:\"node.article.layout_builder__layout\";s:10:\"field_name\";s:22:\"layout_builder__layout\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:5:\"label\";s:6:\"Layout\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:14:\"layout_section\";}'),
('',	'field.field.node.page.body',	'a:17:{s:4:\"uuid\";s:36:\"f2e704ba-2d4f-4bf0-976b-19d893472d4f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:23:\"field.storage.node.body\";i:1;s:14:\"node.type.page\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KHu9I-pR4FnP79crRJ5gVD_1mKGSZcJsdIm9bn64iFg\";}s:2:\"id\";s:14:\"node.page.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:3:{s:15:\"display_summary\";b:1;s:16:\"required_summary\";b:0;s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:17:\"text_with_summary\";}'),
('',	'field.field.node.page.field_metatags',	'a:16:{s:4:\"uuid\";s:36:\"e785ab1b-0edf-46aa-bbaf-56e645079434\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:33:\"field.storage.node.field_metatags\";i:1;s:14:\"node.type.page\";}s:6:\"module\";a:1:{i:0;s:7:\"metatag\";}}s:2:\"id\";s:24:\"node.page.field_metatags\";s:10:\"field_name\";s:14:\"field_metatags\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:5:\"label\";s:8:\"Metatags\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:7:\"metatag\";}'),
('',	'field.field.node.page.layout_builder__layout',	'a:16:{s:4:\"uuid\";s:36:\"79c176b7-33a8-419d-b175-1853525a7e50\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:41:\"field.storage.node.layout_builder__layout\";i:1;s:14:\"node.type.page\";}s:6:\"module\";a:1:{i:0;s:14:\"layout_builder\";}}s:2:\"id\";s:32:\"node.page.layout_builder__layout\";s:10:\"field_name\";s:22:\"layout_builder__layout\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:5:\"label\";s:6:\"Layout\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:14:\"layout_section\";}'),
('',	'field.field.paragraph.ebt_accordion.field_ebt_accordion_text',	'a:17:{s:4:\"uuid\";s:36:\"f0b63cf1-7f17-4dea-a7e0-b54d5d7d823f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:48:\"field.storage.paragraph.field_ebt_accordion_text\";i:1;s:40:\"paragraphs.paragraphs_type.ebt_accordion\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"K83AQZ4cOGBmrJfAKHjN1BC5fNJE2slkMvsq-eOngms\";}s:2:\"id\";s:48:\"paragraph.ebt_accordion.field_ebt_accordion_text\";s:10:\"field_name\";s:24:\"field_ebt_accordion_text\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:13:\"ebt_accordion\";s:5:\"label\";s:13:\"Text / Answer\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.paragraph.ebt_accordion.field_ebt_accordion_title',	'a:17:{s:4:\"uuid\";s:36:\"c7bb20d0-7c3a-4e1d-80bd-fc8145337db5\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:49:\"field.storage.paragraph.field_ebt_accordion_title\";i:1;s:40:\"paragraphs.paragraphs_type.ebt_accordion\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"4iRsnnRe66bYKBWRFqXd8sFfW3tTM7kGDHb5ZI6bRoI\";}s:2:\"id\";s:49:\"paragraph.ebt_accordion.field_ebt_accordion_title\";s:10:\"field_name\";s:25:\"field_ebt_accordion_title\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:13:\"ebt_accordion\";s:5:\"label\";s:16:\"Title / Question\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.paragraph.ebt_carousel.field_ebt_carousel_caption',	'a:17:{s:4:\"uuid\";s:36:\"cdf69cb6-7607-44f2-8e15-66eff3ea978e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:50:\"field.storage.paragraph.field_ebt_carousel_caption\";i:1;s:39:\"paragraphs.paragraphs_type.ebt_carousel\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"zJkgaoa5XS7hvJb5prthRdBt34u3Y3QPJJ_obTMfkfQ\";}s:2:\"id\";s:49:\"paragraph.ebt_carousel.field_ebt_carousel_caption\";s:10:\"field_name\";s:26:\"field_ebt_carousel_caption\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:12:\"ebt_carousel\";s:5:\"label\";s:13:\"Slide caption\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.paragraph.ebt_carousel.field_ebt_carousel_image',	'a:17:{s:4:\"uuid\";s:36:\"cf3345b8-8872-40ef-818f-2e94b33e8961\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:48:\"field.storage.paragraph.field_ebt_carousel_image\";i:1;s:16:\"media.type.image\";i:2;s:39:\"paragraphs.paragraphs_type.ebt_carousel\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"igPOF7Xbo0_CaEPXbAyrAz0x22az-ryGnj9S4zfXsZY\";}s:2:\"id\";s:47:\"paragraph.ebt_carousel.field_ebt_carousel_image\";s:10:\"field_name\";s:24:\"field_ebt_carousel_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:12:\"ebt_carousel\";s:5:\"label\";s:11:\"Slide image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:13:\"default:media\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:5:\"image\";s:5:\"image\";}s:4:\"sort\";a:1:{s:5:\"field\";s:5:\"_none\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.paragraph.ebt_counter_item.field_ebt_counter_description',	'a:17:{s:4:\"uuid\";s:36:\"89d82ff4-da95-426e-b0c1-c9f18b4c7e6a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:53:\"field.storage.paragraph.field_ebt_counter_description\";i:1;s:43:\"paragraphs.paragraphs_type.ebt_counter_item\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SGPys8iAffvOl_W66tfDAlPixkXxxxidEUCONW9q7dI\";}s:2:\"id\";s:56:\"paragraph.ebt_counter_item.field_ebt_counter_description\";s:10:\"field_name\";s:29:\"field_ebt_counter_description\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:16:\"ebt_counter_item\";s:5:\"label\";s:11:\"Description\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.paragraph.ebt_counter_item.field_ebt_counter_icon',	'a:17:{s:4:\"uuid\";s:36:\"22d74b30-be52-4cee-91ea-a0aa04de5dff\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:46:\"field.storage.paragraph.field_ebt_counter_icon\";i:1;s:16:\"media.type.image\";i:2;s:43:\"paragraphs.paragraphs_type.ebt_counter_item\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Vzl7VAXpLPJd2KXAxVHrOfGNPWB1y1s1Jr5foDGSdIg\";}s:2:\"id\";s:49:\"paragraph.ebt_counter_item.field_ebt_counter_icon\";s:10:\"field_name\";s:22:\"field_ebt_counter_icon\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:16:\"ebt_counter_item\";s:5:\"label\";s:4:\"Icon\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:13:\"default:media\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:5:\"image\";s:5:\"image\";}s:4:\"sort\";a:2:{s:5:\"field\";s:5:\"_none\";s:9:\"direction\";s:3:\"ASC\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.paragraph.ebt_counter_item.field_ebt_counter_number',	'a:17:{s:4:\"uuid\";s:36:\"e3b02b26-e9be-46ee-be2a-9c0cdb537a47\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:48:\"field.storage.paragraph.field_ebt_counter_number\";i:1;s:43:\"paragraphs.paragraphs_type.ebt_counter_item\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"k-5pDzCL0Ha9nbkySRCIjCME2yqGDQ9k92GT8A1xqWU\";}s:2:\"id\";s:51:\"paragraph.ebt_counter_item.field_ebt_counter_number\";s:10:\"field_name\";s:24:\"field_ebt_counter_number\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:16:\"ebt_counter_item\";s:5:\"label\";s:6:\"Number\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:4:{s:3:\"min\";N;s:3:\"max\";N;s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";}s:10:\"field_type\";s:7:\"integer\";}'),
('',	'field.field.paragraph.ebt_counter_item.field_ebt_counter_title',	'a:17:{s:4:\"uuid\";s:36:\"62ea8aa7-eadf-46fe-8360-d5a565d6e339\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:47:\"field.storage.paragraph.field_ebt_counter_title\";i:1;s:43:\"paragraphs.paragraphs_type.ebt_counter_item\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"CvlljFbOKRTlxFz1hVYtYJkEdk3S-0I9UmjjS41E7_U\";}s:2:\"id\";s:50:\"paragraph.ebt_counter_item.field_ebt_counter_title\";s:10:\"field_name\";s:23:\"field_ebt_counter_title\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:16:\"ebt_counter_item\";s:5:\"label\";s:5:\"Title\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.paragraph.ebt_slick_slider.field_ebt_slick_slider_image',	'a:17:{s:4:\"uuid\";s:36:\"0ed191f1-4795-4501-9075-ad48a0ed7ef5\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:52:\"field.storage.paragraph.field_ebt_slick_slider_image\";i:1;s:16:\"media.type.image\";i:2;s:43:\"paragraphs.paragraphs_type.ebt_slick_slider\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"pYWtlYxsR5uP9TrVPzdvPyRiMgr6Lp75dE9QtVEyu3Q\";}s:2:\"id\";s:55:\"paragraph.ebt_slick_slider.field_ebt_slick_slider_image\";s:10:\"field_name\";s:28:\"field_ebt_slick_slider_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:16:\"ebt_slick_slider\";s:5:\"label\";s:11:\"Slide Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:13:\"default:media\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:5:\"image\";s:5:\"image\";}s:4:\"sort\";a:2:{s:5:\"field\";s:5:\"_none\";s:9:\"direction\";s:3:\"ASC\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.paragraph.ebt_slick_slider.field_ebt_slick_slider_link',	'a:17:{s:4:\"uuid\";s:36:\"ae270a12-20ca-4ebe-a2f1-69ea8b4fe6e9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:51:\"field.storage.paragraph.field_ebt_slick_slider_link\";i:1;s:43:\"paragraphs.paragraphs_type.ebt_slick_slider\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jk5t1dH13MfYx1LmuLzIlSTGOi3qFvAHr8Zj5vlyM2I\";}s:2:\"id\";s:54:\"paragraph.ebt_slick_slider.field_ebt_slick_slider_link\";s:10:\"field_name\";s:27:\"field_ebt_slick_slider_link\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:16:\"ebt_slick_slider\";s:5:\"label\";s:10:\"Slide Link\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:5:\"title\";i:0;s:9:\"link_type\";i:17;}s:10:\"field_type\";s:4:\"link\";}'),
('',	'field.field.paragraph.ebt_slick_slider.field_ebt_slick_slider_text',	'a:17:{s:4:\"uuid\";s:36:\"087b3c83-4e91-4f68-b458-96330c343db8\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:51:\"field.storage.paragraph.field_ebt_slick_slider_text\";i:1;s:43:\"paragraphs.paragraphs_type.ebt_slick_slider\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ob6mfPaJJwePb80FfSWg_M2reWUeqydWDbjtcshe-Bw\";}s:2:\"id\";s:54:\"paragraph.ebt_slick_slider.field_ebt_slick_slider_text\";s:10:\"field_name\";s:27:\"field_ebt_slick_slider_text\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:16:\"ebt_slick_slider\";s:5:\"label\";s:10:\"Slide Text\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.paragraph.ebt_slideshow.field_ebt_slideshow_link',	'a:17:{s:4:\"uuid\";s:36:\"f3fdd942-959d-4943-993f-2d7c52030728\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:48:\"field.storage.paragraph.field_ebt_slideshow_link\";i:1;s:40:\"paragraphs.paragraphs_type.ebt_slideshow\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"_fFBiyKlJ3i_w71vNv_KlKPhYmEARkECK_6O5gU5skA\";}s:2:\"id\";s:48:\"paragraph.ebt_slideshow.field_ebt_slideshow_link\";s:10:\"field_name\";s:24:\"field_ebt_slideshow_link\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:13:\"ebt_slideshow\";s:5:\"label\";s:10:\"Slide Link\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:5:\"title\";i:1;s:9:\"link_type\";i:17;}s:10:\"field_type\";s:4:\"link\";}'),
('',	'field.field.paragraph.ebt_slideshow.field_ebt_slideshow_slide',	'a:17:{s:4:\"uuid\";s:36:\"b8c36a1d-4e00-47c8-8d3b-5f5c824c1c41\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:49:\"field.storage.paragraph.field_ebt_slideshow_slide\";i:1;s:16:\"media.type.image\";i:2;s:40:\"paragraphs.paragraphs_type.ebt_slideshow\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ZhjSOx4h5C-uQqS8wmCEX4R-expUAu-sQghZL7OK400\";}s:2:\"id\";s:49:\"paragraph.ebt_slideshow.field_ebt_slideshow_slide\";s:10:\"field_name\";s:25:\"field_ebt_slideshow_slide\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:13:\"ebt_slideshow\";s:5:\"label\";s:11:\"Slide Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:13:\"default:media\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:5:\"image\";s:5:\"image\";}s:4:\"sort\";a:2:{s:5:\"field\";s:5:\"_none\";s:9:\"direction\";s:3:\"ASC\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.paragraph.ebt_slideshow.field_ebt_slideshow_text',	'a:17:{s:4:\"uuid\";s:36:\"db307a56-3f8e-4027-b5d1-28fe5edaa11e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:48:\"field.storage.paragraph.field_ebt_slideshow_text\";i:1;s:40:\"paragraphs.paragraphs_type.ebt_slideshow\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"bZ0m2BBV-ldK-3Eh4BGp1MRAgA6rMqeGPulDsD9kdyg\";}s:2:\"id\";s:48:\"paragraph.ebt_slideshow.field_ebt_slideshow_text\";s:10:\"field_name\";s:24:\"field_ebt_slideshow_text\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:13:\"ebt_slideshow\";s:5:\"label\";s:10:\"Slide Text\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.paragraph.ebt_slideshow.field_ebt_slideshow_title',	'a:17:{s:4:\"uuid\";s:36:\"cc62f49e-1354-4058-a151-c4c1e7e5994a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:49:\"field.storage.paragraph.field_ebt_slideshow_title\";i:1;s:40:\"paragraphs.paragraphs_type.ebt_slideshow\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6qs_c-h6E-d-9pn4rWyP3VMtvPIx0dwfa_m8bl9Or4g\";}s:2:\"id\";s:49:\"paragraph.ebt_slideshow.field_ebt_slideshow_title\";s:10:\"field_name\";s:25:\"field_ebt_slideshow_title\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:13:\"ebt_slideshow\";s:5:\"label\";s:11:\"Slide Title\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.paragraph.ebt_stats_item.field_stats_item_image',	'a:17:{s:4:\"uuid\";s:36:\"e7dc4733-12c7-4748-975b-b7d57accd4ee\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:46:\"field.storage.paragraph.field_stats_item_image\";i:1;s:16:\"media.type.image\";i:2;s:41:\"paragraphs.paragraphs_type.ebt_stats_item\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"1k1v70N6h-IQn541w0qMasOm8bEEp3XimOb7xSv8suk\";}s:2:\"id\";s:47:\"paragraph.ebt_stats_item.field_stats_item_image\";s:10:\"field_name\";s:22:\"field_stats_item_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"ebt_stats_item\";s:5:\"label\";s:16:\"Stats item image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:13:\"default:media\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:5:\"image\";s:5:\"image\";}s:4:\"sort\";a:2:{s:5:\"field\";s:5:\"_none\";s:9:\"direction\";s:3:\"ASC\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.paragraph.ebt_stats_item.field_stats_item_link',	'a:17:{s:4:\"uuid\";s:36:\"67b6c95b-30fa-471d-a031-e84ec26a1a54\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:45:\"field.storage.paragraph.field_stats_item_link\";i:1;s:41:\"paragraphs.paragraphs_type.ebt_stats_item\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"uExk2SWTCDuqJRmvyPPMsGBSMj4ilG_32ADqZm_jKZY\";}s:2:\"id\";s:46:\"paragraph.ebt_stats_item.field_stats_item_link\";s:10:\"field_name\";s:21:\"field_stats_item_link\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"ebt_stats_item\";s:5:\"label\";s:15:\"Stats item link\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:5:\"title\";i:2;s:9:\"link_type\";i:17;}s:10:\"field_type\";s:4:\"link\";}'),
('',	'field.field.paragraph.ebt_stats_item.field_stats_item_number',	'a:17:{s:4:\"uuid\";s:36:\"4ae0f11b-4c4f-43c8-a58e-9413b992ad4d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:47:\"field.storage.paragraph.field_stats_item_number\";i:1;s:41:\"paragraphs.paragraphs_type.ebt_stats_item\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"5OFR72Rn-pvsZTbp7LEkgUVp0q21QilFZMegsC5ICbo\";}s:2:\"id\";s:48:\"paragraph.ebt_stats_item.field_stats_item_number\";s:10:\"field_name\";s:23:\"field_stats_item_number\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"ebt_stats_item\";s:5:\"label\";s:17:\"Stats item number\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.paragraph.ebt_stats_item.field_stats_item_text',	'a:17:{s:4:\"uuid\";s:36:\"2907b7cd-48be-4276-8c1a-ad20ca437cd4\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:45:\"field.storage.paragraph.field_stats_item_text\";i:1;s:41:\"paragraphs.paragraphs_type.ebt_stats_item\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"5YdkRFvRcJQuYp6xs1qhhjaUeyj1ysW93i6EPEh9dWU\";}s:2:\"id\";s:46:\"paragraph.ebt_stats_item.field_stats_item_text\";s:10:\"field_name\";s:21:\"field_stats_item_text\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"ebt_stats_item\";s:5:\"label\";s:15:\"Stats item text\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.paragraph.ebt_tab.field_ebt_tab_block',	'a:17:{s:4:\"uuid\";s:36:\"6821e0ef-8080-428a-ac78-f51249bb5e2d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:43:\"field.storage.paragraph.field_ebt_tab_block\";i:1;s:34:\"paragraphs.paragraphs_type.ebt_tab\";}s:6:\"module\";a:1:{i:0;s:11:\"block_field\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7dftnJ-QEc2wq727UtTNqtQGbbQis8Pwgykf0EPgU5U\";}s:2:\"id\";s:37:\"paragraph.ebt_tab.field_ebt_tab_block\";s:10:\"field_name\";s:19:\"field_ebt_tab_block\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:7:\"ebt_tab\";s:5:\"label\";s:9:\"Tab Block\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:9:\"selection\";s:6:\"blocks\";s:18:\"selection_settings\";a:1:{s:10:\"plugin_ids\";a:0:{}}}s:10:\"field_type\";s:11:\"block_field\";}'),
('',	'field.field.paragraph.ebt_tab.field_ebt_tab_content',	'a:17:{s:4:\"uuid\";s:36:\"9093a2e3-eafc-42f9-9d74-0c76cf2fa7e6\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:45:\"field.storage.paragraph.field_ebt_tab_content\";i:1;s:34:\"paragraphs.paragraphs_type.ebt_tab\";}s:6:\"module\";a:1:{i:0;s:7:\"options\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"as55Dml1Xd2yWFDU0vGxsQmoXaIr9fZ2lC4KG8TpvzA\";}s:2:\"id\";s:39:\"paragraph.ebt_tab.field_ebt_tab_content\";s:10:\"field_name\";s:21:\"field_ebt_tab_content\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:7:\"ebt_tab\";s:5:\"label\";s:11:\"Tab content\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:11:\"list_string\";}'),
('',	'field.field.paragraph.ebt_tab.field_ebt_tab_page',	'a:17:{s:4:\"uuid\";s:36:\"6b77acaf-9fab-4d2e-9843-cfe8180ce9fe\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:42:\"field.storage.paragraph.field_ebt_tab_page\";i:1;s:14:\"node.type.page\";i:2;s:34:\"paragraphs.paragraphs_type.ebt_tab\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"t9WpCMZrY0hReO2jvRG2Rte22ZW2y4Dq_5kF4YVAWqo\";}s:2:\"id\";s:36:\"paragraph.ebt_tab.field_ebt_tab_page\";s:10:\"field_name\";s:18:\"field_ebt_tab_page\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:7:\"ebt_tab\";s:5:\"label\";s:8:\"Tab page\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:12:\"default:node\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:4:\"page\";s:4:\"page\";}s:4:\"sort\";a:1:{s:5:\"field\";s:5:\"_none\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.paragraph.ebt_tab.field_ebt_tab_text',	'a:17:{s:4:\"uuid\";s:36:\"0cb50bf8-21aa-4ea6-a7d0-90d454555f86\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:42:\"field.storage.paragraph.field_ebt_tab_text\";i:1;s:34:\"paragraphs.paragraphs_type.ebt_tab\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"qDqTeXYS1CTWbjbJQUSmVXGsWThhwp_YLObjCrj-4wo\";}s:2:\"id\";s:36:\"paragraph.ebt_tab.field_ebt_tab_text\";s:10:\"field_name\";s:18:\"field_ebt_tab_text\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:7:\"ebt_tab\";s:5:\"label\";s:8:\"Tab text\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.paragraph.ebt_tab.field_ebt_tab_title',	'a:17:{s:4:\"uuid\";s:36:\"217d9d46-984c-450c-b218-1d58121ced68\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:43:\"field.storage.paragraph.field_ebt_tab_title\";i:1;s:34:\"paragraphs.paragraphs_type.ebt_tab\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"axHae-sP24gbeAgLnxqUi-W0N6tnY4ImUB_wdC1bCiM\";}s:2:\"id\";s:37:\"paragraph.ebt_tab.field_ebt_tab_title\";s:10:\"field_name\";s:19:\"field_ebt_tab_title\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:7:\"ebt_tab\";s:5:\"label\";s:9:\"Tab title\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:4:\"text\";}'),
('',	'field.field.paragraph.ebt_tab.field_ebt_tab_views',	'a:17:{s:4:\"uuid\";s:36:\"5c306dcf-d85c-424e-b5d0-a819386f6ecc\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:43:\"field.storage.paragraph.field_ebt_tab_views\";i:1;s:34:\"paragraphs.paragraphs_type.ebt_tab\";}s:6:\"module\";a:1:{i:0;s:14:\"viewsreference\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Zc3r5Wx5CVuHBS5Fvv1jYRaHo4EnB7V2rhALuCxql_o\";}s:2:\"id\";s:37:\"paragraph.ebt_tab.field_ebt_tab_views\";s:10:\"field_name\";s:19:\"field_ebt_tab_views\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:7:\"ebt_tab\";s:5:\"label\";s:9:\"Tab views\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:5:{s:7:\"handler\";s:12:\"default:view\";s:16:\"handler_settings\";a:2:{s:14:\"target_bundles\";N;s:11:\"auto_create\";i:0;}s:12:\"plugin_types\";a:5:{s:7:\"default\";s:7:\"default\";s:5:\"block\";s:5:\"block\";s:4:\"page\";i:0;s:4:\"feed\";i:0;s:5:\"embed\";i:0;}s:15:\"preselect_views\";a:14:{s:8:\"articles\";i:0;s:13:\"block_content\";i:0;s:7:\"comment\";i:0;s:15:\"comments_recent\";i:0;s:7:\"content\";i:0;s:14:\"content_recent\";i:0;s:5:\"files\";i:0;s:9:\"frontpage\";i:0;s:13:\"taxonomy_term\";i:0;s:17:\"user_admin_people\";i:0;s:8:\"watchdog\";i:0;s:19:\"webform_submissions\";i:0;s:9:\"who_s_new\";i:0;s:12:\"who_s_online\";i:0;}s:16:\"enabled_settings\";a:5:{s:5:\"pager\";i:0;s:5:\"limit\";i:0;s:6:\"offset\";i:0;s:5:\"title\";i:0;s:8:\"argument\";i:0;}}s:10:\"field_type\";s:14:\"viewsreference\";}'),
('',	'field.field.paragraph.ebt_tiles_item.field_ebt_clickable_tile',	'a:17:{s:4:\"uuid\";s:36:\"b6bcf941-67b4-43b7-9747-c95baf1b7bc4\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:48:\"field.storage.paragraph.field_ebt_clickable_tile\";i:1;s:41:\"paragraphs.paragraphs_type.ebt_tiles_item\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"I8Bhnp9Mihk3DDEulISHIOOcN-avs5jkwzt9L0n-CcI\";}s:2:\"id\";s:49:\"paragraph.ebt_tiles_item.field_ebt_clickable_tile\";s:10:\"field_name\";s:24:\"field_ebt_clickable_tile\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"ebt_tiles_item\";s:5:\"label\";s:14:\"Clickable Tile\";s:11:\"description\";s:66:\"Make entire tile clickable or display link separataly if unchecked\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:1;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:8:\"on_label\";s:2:\"On\";s:9:\"off_label\";s:3:\"Off\";}s:10:\"field_type\";s:7:\"boolean\";}'),
('',	'field.field.paragraph.ebt_tiles_item.field_ebt_tiles_image',	'a:17:{s:4:\"uuid\";s:36:\"9d903341-553f-4311-8a83-c48130d410e0\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:45:\"field.storage.paragraph.field_ebt_tiles_image\";i:1;s:16:\"media.type.image\";i:2;s:41:\"paragraphs.paragraphs_type.ebt_tiles_item\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"lPf_h3aKofBH6XHQRhBmyVb1lV4Z8_w0oD6vY9JLcjM\";}s:2:\"id\";s:46:\"paragraph.ebt_tiles_item.field_ebt_tiles_image\";s:10:\"field_name\";s:21:\"field_ebt_tiles_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"ebt_tiles_item\";s:5:\"label\";s:5:\"Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:13:\"default:media\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:5:\"image\";s:5:\"image\";}s:4:\"sort\";a:2:{s:5:\"field\";s:5:\"_none\";s:9:\"direction\";s:3:\"ASC\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.paragraph.ebt_tiles_item.field_ebt_tiles_link',	'a:17:{s:4:\"uuid\";s:36:\"3c7cd9d7-a4c3-49a9-9bbc-1ced5ab70209\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:44:\"field.storage.paragraph.field_ebt_tiles_link\";i:1;s:41:\"paragraphs.paragraphs_type.ebt_tiles_item\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"pQ8lDL7PoSiLrK83cA8hSPIPNufbpw3j1qT4f1V9VUc\";}s:2:\"id\";s:45:\"paragraph.ebt_tiles_item.field_ebt_tiles_link\";s:10:\"field_name\";s:20:\"field_ebt_tiles_link\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"ebt_tiles_item\";s:5:\"label\";s:4:\"Link\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:5:\"title\";i:1;s:9:\"link_type\";i:17;}s:10:\"field_type\";s:4:\"link\";}'),
('',	'field.field.paragraph.ebt_tiles_item.field_ebt_tiles_text',	'a:17:{s:4:\"uuid\";s:36:\"5201e488-c9af-4ec2-867e-3b3dbe8c8b16\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:44:\"field.storage.paragraph.field_ebt_tiles_text\";i:1;s:41:\"paragraphs.paragraphs_type.ebt_tiles_item\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"yZYhpVfxBQEK7LOwoolFtOZY726XpjMHK5opPVJB4j4\";}s:2:\"id\";s:45:\"paragraph.ebt_tiles_item.field_ebt_tiles_text\";s:10:\"field_name\";s:20:\"field_ebt_tiles_text\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"ebt_tiles_item\";s:5:\"label\";s:4:\"Text\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.paragraph.ebt_tiles_item.field_ebt_tiles_title',	'a:17:{s:4:\"uuid\";s:36:\"1e88de7b-7c46-4562-a223-9ccf83779820\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:45:\"field.storage.paragraph.field_ebt_tiles_title\";i:1;s:41:\"paragraphs.paragraphs_type.ebt_tiles_item\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"V7UyIKTz-lufN2i-3921iDZVIjrM1K-GA3PPgZfgYTI\";}s:2:\"id\";s:46:\"paragraph.ebt_tiles_item.field_ebt_tiles_title\";s:10:\"field_name\";s:21:\"field_ebt_tiles_title\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"ebt_tiles_item\";s:5:\"label\";s:5:\"Title\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.paragraph.ebt_timeline.field_ebt_timeline_current',	'a:17:{s:4:\"uuid\";s:36:\"24fd2c38-f992-42ae-89ce-590dd574cb31\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:50:\"field.storage.paragraph.field_ebt_timeline_current\";i:1;s:39:\"paragraphs.paragraphs_type.ebt_timeline\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Js3oBqyPFEjLEDUuAPzn29jLKcNg1wsB7M9uvAF8fwQ\";}s:2:\"id\";s:49:\"paragraph.ebt_timeline.field_ebt_timeline_current\";s:10:\"field_name\";s:26:\"field_ebt_timeline_current\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:12:\"ebt_timeline\";s:5:\"label\";s:7:\"Current\";s:11:\"description\";s:36:\"Highlight current stage in timeline.\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:8:\"on_label\";s:2:\"On\";s:9:\"off_label\";s:3:\"Off\";}s:10:\"field_type\";s:7:\"boolean\";}'),
('',	'field.field.paragraph.ebt_timeline.field_ebt_timeline_date',	'a:17:{s:4:\"uuid\";s:36:\"d1569baf-9302-4e38-9ed4-987caeafa2e4\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:47:\"field.storage.paragraph.field_ebt_timeline_date\";i:1;s:39:\"paragraphs.paragraphs_type.ebt_timeline\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ajUABeEHsfvEoCEA1JJywutAhjakBjNSR6yymicgJcQ\";}s:2:\"id\";s:46:\"paragraph.ebt_timeline.field_ebt_timeline_date\";s:10:\"field_name\";s:23:\"field_ebt_timeline_date\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:12:\"ebt_timeline\";s:5:\"label\";s:4:\"Date\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}'),
('',	'field.field.paragraph.ebt_timeline.field_ebt_timeline_media_image',	'a:17:{s:4:\"uuid\";s:36:\"a0651ff8-3cb5-478f-acbe-120dd869e921\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:54:\"field.storage.paragraph.field_ebt_timeline_media_image\";i:1;s:16:\"media.type.image\";i:2;s:39:\"paragraphs.paragraphs_type.ebt_timeline\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"0WMqQDbMLHG-hJMnj9tohP4sS2B93Gy_jhhZoUJIA9I\";}s:2:\"id\";s:53:\"paragraph.ebt_timeline.field_ebt_timeline_media_image\";s:10:\"field_name\";s:30:\"field_ebt_timeline_media_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:12:\"ebt_timeline\";s:5:\"label\";s:5:\"Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:13:\"default:media\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:5:\"image\";s:5:\"image\";}s:4:\"sort\";a:2:{s:5:\"field\";s:5:\"_none\";s:9:\"direction\";s:3:\"ASC\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.paragraph.ebt_timeline.field_ebt_timeline_text',	'a:17:{s:4:\"uuid\";s:36:\"265711bf-cab4-450f-83c7-f401aa255ff1\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:47:\"field.storage.paragraph.field_ebt_timeline_text\";i:1;s:39:\"paragraphs.paragraphs_type.ebt_timeline\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"5F87FeFRv4oMn7nyxCCJ3pjlpG-G5NBIfD-5o5No0t8\";}s:2:\"id\";s:46:\"paragraph.ebt_timeline.field_ebt_timeline_text\";s:10:\"field_name\";s:23:\"field_ebt_timeline_text\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:12:\"ebt_timeline\";s:5:\"label\";s:4:\"Text\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.paragraph.ebt_timeline.field_ebt_timeline_title',	'a:17:{s:4:\"uuid\";s:36:\"ae101647-2196-429e-ba3e-cbb55e4e92f3\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:48:\"field.storage.paragraph.field_ebt_timeline_title\";i:1;s:39:\"paragraphs.paragraphs_type.ebt_timeline\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"_pET64Z-ylj-Ic4NyQ0BmUF4zGO8dZ-uVWadrNKQvyo\";}s:2:\"id\";s:47:\"paragraph.ebt_timeline.field_ebt_timeline_title\";s:10:\"field_name\";s:24:\"field_ebt_timeline_title\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:12:\"ebt_timeline\";s:5:\"label\";s:5:\"Title\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}'),
('',	'field.field.paragraph.ebt_video_and_image_gallery_item.field_gallery_item_description',	'a:17:{s:4:\"uuid\";s:36:\"2c335583-7279-4b40-95b9-09d17b06fc4a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:54:\"field.storage.paragraph.field_gallery_item_description\";i:1;s:59:\"paragraphs.paragraphs_type.ebt_video_and_image_gallery_item\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"lW3Ks0DIMaIjFKfbgrmmUXgP-Atqo_sKwWuBuvS3Rmg\";}s:2:\"id\";s:73:\"paragraph.ebt_video_and_image_gallery_item.field_gallery_item_description\";s:10:\"field_name\";s:30:\"field_gallery_item_description\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:32:\"ebt_video_and_image_gallery_item\";s:5:\"label\";s:24:\"Gallery item description\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:1:{s:15:\"allowed_formats\";a:0:{}}s:10:\"field_type\";s:9:\"text_long\";}'),
('',	'field.field.paragraph.ebt_video_and_image_gallery_item.field_video_gallery_item',	'a:17:{s:4:\"uuid\";s:36:\"2d4456ac-0c7c-4f72-8624-a25a5d933b9b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:4:{i:0;s:48:\"field.storage.paragraph.field_video_gallery_item\";i:1;s:16:\"media.type.image\";i:2;s:23:\"media.type.remote_video\";i:3;s:59:\"paragraphs.paragraphs_type.ebt_video_and_image_gallery_item\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"JaxawDXWXvX-mf-HuaUiJYhh81uXGJm8rPPZGOoQze8\";}s:2:\"id\";s:67:\"paragraph.ebt_video_and_image_gallery_item.field_video_gallery_item\";s:10:\"field_name\";s:24:\"field_video_gallery_item\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:32:\"ebt_video_and_image_gallery_item\";s:5:\"label\";s:12:\"Gallery Item\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:13:\"default:media\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:2:{s:5:\"image\";s:5:\"image\";s:12:\"remote_video\";s:12:\"remote_video\";}s:4:\"sort\";a:2:{s:5:\"field\";s:5:\"_none\";s:9:\"direction\";s:3:\"ASC\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:5:\"image\";}}s:10:\"field_type\";s:16:\"entity_reference\";}'),
('',	'field.field.user.user.user_picture',	'a:17:{s:4:\"uuid\";s:36:\"a99bd180-01c5-4300-997c-47456c8ba004\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:31:\"field.storage.user.user_picture\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"TE3gYVzd6g0deXqUl8SEu2azHwVG-SdXm3kwbrz0kHw\";}s:2:\"id\";s:22:\"user.user.user_picture\";s:10:\"field_name\";s:12:\"user_picture\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";s:4:\"user\";s:5:\"label\";s:7:\"Picture\";s:11:\"description\";s:29:\"Your virtual face or picture.\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:40:\"pictures/[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:21:\"png gif jpg jpeg webp\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:0;s:18:\"alt_field_required\";b:0;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:10:\"field_type\";s:5:\"image\";}'),
('',	'field.settings',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nJk0TAQBzlNo52ehiHI7bIEPLGi0BYqZvPdEn7Chfu0\";}s:16:\"purge_batch_size\";i:50;}'),
('',	'field.storage.block_content.body',	'a:17:{s:4:\"uuid\";s:36:\"3db51960-3062-400f-b922-f0a7373dacb5\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eS0snV_L3dx9shtWRTzm5eblwOJ7qKWC9IE-4GMTDFc\";}s:2:\"id\";s:18:\"block_content.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:17:\"text_with_summary\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:1;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_accordion',	'a:17:{s:4:\"uuid\";s:36:\"510be1fe-456a-4a0f-8638-40b7764bd46a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:13:\"block_content\";i:1;s:26:\"entity_reference_revisions\";i:2;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"-9lmszSGOf8FvJqERXt4Y75SqfNFnjrUmffe3mvm63E\";}s:2:\"id\";s:33:\"block_content.field_ebt_accordion\";s:10:\"field_name\";s:19:\"field_ebt_accordion\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:26:\"entity_reference_revisions\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:9:\"paragraph\";}s:6:\"module\";s:26:\"entity_reference_revisions\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_basic_button_link',	'a:17:{s:4:\"uuid\";s:36:\"227cb366-5e8c-44f6-bcc0-a4197c0060f2\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"BzBSGwNX6bKi7xiNAKiETrdJPbGYMNk27dC6VzdE2Z4\";}s:2:\"id\";s:41:\"block_content.field_ebt_basic_button_link\";s:10:\"field_name\";s:27:\"field_ebt_basic_button_link\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_block_block',	'a:17:{s:4:\"uuid\";s:36:\"93988320-9748-44ab-ac19-9ac1a6feaa9d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:11:\"block_field\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"qUmxIKbmrhd1TnlvNUsQ24_IqgsilgfToL8gamHgjPk\";}s:2:\"id\";s:35:\"block_content.field_ebt_block_block\";s:10:\"field_name\";s:21:\"field_ebt_block_block\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:11:\"block_field\";s:8:\"settings\";a:0:{}s:6:\"module\";s:11:\"block_field\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_bootstrap_button_link',	'a:17:{s:4:\"uuid\";s:36:\"6848e7e6-6bb4-4d7b-bfe3-64cb965c8d83\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"4Mn_2tFUWa7Mu6w06yP9iFQ7KLLKr83YOpxoaTd3IDo\";}s:2:\"id\";s:45:\"block_content.field_ebt_bootstrap_button_link\";s:10:\"field_name\";s:31:\"field_ebt_bootstrap_button_link\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_carousel',	'a:17:{s:4:\"uuid\";s:36:\"c31eee89-5d35-4da4-a2f9-daca2ffd26b7\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:13:\"block_content\";i:1;s:26:\"entity_reference_revisions\";i:2;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"5RyRgQO2iOVZE4gIaH8pGJ4s3UZCNOm5nqfkFXWwVvE\";}s:2:\"id\";s:32:\"block_content.field_ebt_carousel\";s:10:\"field_name\";s:18:\"field_ebt_carousel\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:26:\"entity_reference_revisions\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:9:\"paragraph\";}s:6:\"module\";s:26:\"entity_reference_revisions\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_columns_blocks',	'a:17:{s:4:\"uuid\";s:36:\"007c60bc-7d54-4666-8065-f77200cca762\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:11:\"block_field\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"8ubMRbdfnR4zPhu3EFrCWZOc2hr9_Dum6gPo01gA7OE\";}s:2:\"id\";s:38:\"block_content.field_ebt_columns_blocks\";s:10:\"field_name\";s:24:\"field_ebt_columns_blocks\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:11:\"block_field\";s:8:\"settings\";a:0:{}s:6:\"module\";s:11:\"block_field\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_countdown_date',	'a:17:{s:4:\"uuid\";s:36:\"18c467c8-f5f7-4380-a5b7-5d8dd1bd6891\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:8:\"datetime\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"tfVOPr7E66mYxIOwRxWNsSw4nFQnztb5FQbxuKg7_Dg\";}s:2:\"id\";s:38:\"block_content.field_ebt_countdown_date\";s:10:\"field_name\";s:24:\"field_ebt_countdown_date\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:8:\"datetime\";s:8:\"settings\";a:1:{s:13:\"datetime_type\";s:8:\"datetime\";}s:6:\"module\";s:8:\"datetime\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_counter_icon',	'a:17:{s:4:\"uuid\";s:36:\"90f3734d-9d21-4723-8027-039393a502ef\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2bYFfyXow5e24VR-vUVn5lG3PHuSyRBkkEZ_qOShiuk\";}s:2:\"id\";s:36:\"block_content.field_ebt_counter_icon\";s:10:\"field_name\";s:22:\"field_ebt_counter_icon\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:5:\"media\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_counter_items',	'a:17:{s:4:\"uuid\";s:36:\"fcff8171-e2db-44a5-9585-8b9fb7992b79\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:13:\"block_content\";i:1;s:26:\"entity_reference_revisions\";i:2;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"n1DI17J39aMu-YkFmfdRmeqTQflyy2-_xOR8jw99LkE\";}s:2:\"id\";s:37:\"block_content.field_ebt_counter_items\";s:10:\"field_name\";s:23:\"field_ebt_counter_items\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:26:\"entity_reference_revisions\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:9:\"paragraph\";}s:6:\"module\";s:26:\"entity_reference_revisions\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_counter_number',	'a:17:{s:4:\"uuid\";s:36:\"62a1a67b-d505-4c27-8636-6a9c35a21cf3\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:13:\"block_content\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"fzJ_kU3wKSQOA7gdcWs4erHYixRul2pFzixpKaUIEcs\";}s:2:\"id\";s:38:\"block_content.field_ebt_counter_number\";s:10:\"field_name\";s:24:\"field_ebt_counter_number\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:7:\"integer\";s:8:\"settings\";a:2:{s:8:\"unsigned\";b:0;s:4:\"size\";s:6:\"normal\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_cta_column_image',	'a:17:{s:4:\"uuid\";s:36:\"1e11b0a4-9fbb-4f77-a027-2abe7c00a623\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"cWseV862aJoW9_oVsbhZOp1F-1WgQGPaPWt4miaSdoM\";}s:2:\"id\";s:40:\"block_content.field_ebt_cta_column_image\";s:10:\"field_name\";s:26:\"field_ebt_cta_column_image\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:5:\"media\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_cta_link',	'a:17:{s:4:\"uuid\";s:36:\"069a665c-1062-4320-b384-be548389f826\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"rx7cMICk6v3oU3DQBozX_KkK6bXWe9gJNBM2H0aC6n4\";}s:2:\"id\";s:32:\"block_content.field_ebt_cta_link\";s:10:\"field_name\";s:18:\"field_ebt_cta_link\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_cta_second_link',	'a:17:{s:4:\"uuid\";s:36:\"95a9a9f7-3de1-4e44-8f20-3d0f2dfe6baa\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nldTu1l1Acs-EQQUI6pM7wxOCM_8L8QdevFiQDrvqdk\";}s:2:\"id\";s:39:\"block_content.field_ebt_cta_second_link\";s:10:\"field_name\";s:25:\"field_ebt_cta_second_link\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_cta_title',	'a:17:{s:4:\"uuid\";s:36:\"28d853cc-13c3-4be6-9b85-37001544855b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"QzI1KYIZiUFHadsdJPmZk_6XW4wCrROvPpgDNWpBa8M\";}s:2:\"id\";s:33:\"block_content.field_ebt_cta_title\";s:10:\"field_name\";s:19:\"field_ebt_cta_title\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_hero_column_image',	'a:17:{s:4:\"uuid\";s:36:\"ef778f49-5062-47e4-bca2-1b340272972f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"qRkbr3wurZNCdoGUXFQbfo3Q8o-iJ-GBBGGEAY2iPYg\";}s:2:\"id\";s:41:\"block_content.field_ebt_hero_column_image\";s:10:\"field_name\";s:27:\"field_ebt_hero_column_image\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:5:\"media\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_hero_link',	'a:17:{s:4:\"uuid\";s:36:\"27029cab-99df-44cd-891e-de41f3558b7c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"u6S6Tua-DwnyB3sGdBXHub-aGYa1PeUoR9SfeJOlpYE\";}s:2:\"id\";s:33:\"block_content.field_ebt_hero_link\";s:10:\"field_name\";s:19:\"field_ebt_hero_link\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_hero_second_link',	'a:17:{s:4:\"uuid\";s:36:\"535ff977-be0f-4fa5-8d38-7803ae8b9094\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"zmAY3AWa6AyFxiDtFl2a9fy666r6LZkvLTF540UTBdE\";}s:2:\"id\";s:40:\"block_content.field_ebt_hero_second_link\";s:10:\"field_name\";s:26:\"field_ebt_hero_second_link\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_hero_title',	'a:17:{s:4:\"uuid\";s:36:\"2807bb2f-4aff-460c-9cf6-46dd6ddcf653\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"tz0LPZeke3wFWFFnRzkakjNgB9UGwLj1eCtzzQv6XSA\";}s:2:\"id\";s:34:\"block_content.field_ebt_hero_title\";s:10:\"field_name\";s:20:\"field_ebt_hero_title\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_hero_title_prefix',	'a:17:{s:4:\"uuid\";s:36:\"d972b731-9ab7-4ca0-8ee1-32320e00018b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"yPT-fy4fwafnNJhdyQ0u1kFfPiRvtGiJ8-5FOUcKyaw\";}s:2:\"id\";s:41:\"block_content.field_ebt_hero_title_prefix\";s:10:\"field_name\";s:27:\"field_ebt_hero_title_prefix\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_image',	'a:17:{s:4:\"uuid\";s:36:\"90e79693-e9f5-46f1-bb04-df225231b9a7\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"glPjB_880Y127LFOondnNWS1FPhcaT_fJa11BR0P5BA\";}s:2:\"id\";s:29:\"block_content.field_ebt_image\";s:10:\"field_name\";s:15:\"field_ebt_image\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:5:\"media\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_image_caption',	'a:17:{s:4:\"uuid\";s:36:\"d9f39667-4231-4f25-b5b5-7d6a627c0143\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"LJgW5JIAhD9XCJuoflFRdy-F8SWYW2Cix0FvZz4SYiY\";}s:2:\"id\";s:37:\"block_content.field_ebt_image_caption\";s:10:\"field_name\";s:23:\"field_ebt_image_caption\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_image_gallery',	'a:17:{s:4:\"uuid\";s:36:\"0ab015a1-cb97-4ec7-ad66-d236d2472cee\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"VTE6qLfHmQDITpk4f42HVWATR8Wgh7o2ygcj4yx3iNQ\";}s:2:\"id\";s:37:\"block_content.field_ebt_image_gallery\";s:10:\"field_name\";s:23:\"field_ebt_image_gallery\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:5:\"media\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_image_link',	'a:17:{s:4:\"uuid\";s:36:\"d53112b6-fda3-4a60-9140-a4f4d8c03704\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"link\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"wLzveDC1XvIz7oYfIvN4OjokbzzjPzDc9Ik730ZY254\";}s:2:\"id\";s:34:\"block_content.field_ebt_image_link\";s:10:\"field_name\";s:20:\"field_ebt_image_link\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_micromodal_title',	'a:17:{s:4:\"uuid\";s:36:\"8889dde4-ff00-4644-8af5-1d22a85992bc\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KxeGHZZZNOmgTH3mTuMpwjJqQoqqDIsVOiT05vaOjSQ\";}s:2:\"id\";s:40:\"block_content.field_ebt_micromodal_title\";s:10:\"field_name\";s:26:\"field_ebt_micromodal_title\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_quote_author',	'a:17:{s:4:\"uuid\";s:36:\"66105a0b-52fa-455d-9673-6bab401dd3d9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"un8UvEIKf-pPNdISDAwHz8cnHArBXUbFHb8rYis_-KU\";}s:2:\"id\";s:36:\"block_content.field_ebt_quote_author\";s:10:\"field_name\";s:22:\"field_ebt_quote_author\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_quote_image',	'a:17:{s:4:\"uuid\";s:36:\"c53a9a24-143b-4766-a552-e983659465b5\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"usPfnGqFjnh9WSQ4-5tqsU1G2FvbPHpJMyt4Omq2btU\";}s:2:\"id\";s:35:\"block_content.field_ebt_quote_image\";s:10:\"field_name\";s:21:\"field_ebt_quote_image\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:5:\"media\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_settings',	'a:17:{s:4:\"uuid\";s:36:\"37d2f916-06b4-418e-91ad-84a23f9fe7aa\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:8:\"ebt_core\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ifyYbCOsv_c2p19zBnvPk39PxYWsMjVLhswFVxeoMEk\";}s:2:\"id\";s:32:\"block_content.field_ebt_settings\";s:10:\"field_name\";s:18:\"field_ebt_settings\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:12:\"ebt_settings\";s:8:\"settings\";a:0:{}s:6:\"module\";s:8:\"ebt_core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_slick_slider',	'a:17:{s:4:\"uuid\";s:36:\"4f31d892-e4c2-45d6-a14e-723ccc4c06f0\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:13:\"block_content\";i:1;s:26:\"entity_reference_revisions\";i:2;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jvQGqiPKTXqRaJpknm7I-jiTH0_2U95OADILQZQt5zA\";}s:2:\"id\";s:36:\"block_content.field_ebt_slick_slider\";s:10:\"field_name\";s:22:\"field_ebt_slick_slider\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:26:\"entity_reference_revisions\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:9:\"paragraph\";}s:6:\"module\";s:26:\"entity_reference_revisions\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_slideshow',	'a:17:{s:4:\"uuid\";s:36:\"aec7f7b6-b7a3-414f-8026-620c99e80fee\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:13:\"block_content\";i:1;s:26:\"entity_reference_revisions\";i:2;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"pGo99IMeEAHZnIdMVP18pkNzYTjRT7opYqgiP2t4CzI\";}s:2:\"id\";s:33:\"block_content.field_ebt_slideshow\";s:10:\"field_name\";s:19:\"field_ebt_slideshow\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:26:\"entity_reference_revisions\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:9:\"paragraph\";}s:6:\"module\";s:26:\"entity_reference_revisions\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_stats',	'a:17:{s:4:\"uuid\";s:36:\"65f88f19-ba20-4a37-8258-22b4bbd0bed3\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:13:\"block_content\";i:1;s:26:\"entity_reference_revisions\";i:2;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"TCxq8NOVtHeT-j0H_fF1rrmP8AxlDhBMsOm8KSQlkrs\";}s:2:\"id\";s:29:\"block_content.field_ebt_stats\";s:10:\"field_name\";s:15:\"field_ebt_stats\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:26:\"entity_reference_revisions\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:9:\"paragraph\";}s:6:\"module\";s:26:\"entity_reference_revisions\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_tabs',	'a:17:{s:4:\"uuid\";s:36:\"8b001212-3460-4d07-af2d-efb8bed64599\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:13:\"block_content\";i:1;s:26:\"entity_reference_revisions\";i:2;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"-l2aVtFab9PohqPfDUp_RU4Ji6kBJLDWSfB6L_rUZmo\";}s:2:\"id\";s:28:\"block_content.field_ebt_tabs\";s:10:\"field_name\";s:14:\"field_ebt_tabs\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:26:\"entity_reference_revisions\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:9:\"paragraph\";}s:6:\"module\";s:26:\"entity_reference_revisions\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_tiles',	'a:17:{s:4:\"uuid\";s:36:\"2fa60bf2-361b-4902-b836-53c11ea98d00\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:13:\"block_content\";i:1;s:26:\"entity_reference_revisions\";i:2;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"xpk_uqKrbVXj3nCNx7pki4z-Cql8XOb4a0GLo-PxaDE\";}s:2:\"id\";s:29:\"block_content.field_ebt_tiles\";s:10:\"field_name\";s:15:\"field_ebt_tiles\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:26:\"entity_reference_revisions\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:9:\"paragraph\";}s:6:\"module\";s:26:\"entity_reference_revisions\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_timeline',	'a:17:{s:4:\"uuid\";s:36:\"34f357a7-4ec0-459d-9349-7c3b933ed9ca\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:13:\"block_content\";i:1;s:26:\"entity_reference_revisions\";i:2;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"w5cvHJQa6dOxx4ke6vQ8dBNORP8_2BYC8XoDyNSh_ag\";}s:2:\"id\";s:32:\"block_content.field_ebt_timeline\";s:10:\"field_name\";s:18:\"field_ebt_timeline\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:26:\"entity_reference_revisions\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:9:\"paragraph\";}s:6:\"module\";s:26:\"entity_reference_revisions\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_video',	'a:17:{s:4:\"uuid\";s:36:\"cd7bca62-bdaa-494e-8d09-d0af7c881721\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"yqpxggVM9qa9BsCQ0dK4C8x0wU_GrVyhYXeHKQe-IMI\";}s:2:\"id\";s:29:\"block_content.field_ebt_video\";s:10:\"field_name\";s:15:\"field_ebt_video\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:5:\"media\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_videos_and_images',	'a:17:{s:4:\"uuid\";s:36:\"51b55e7c-d254-49db-b70a-396cd9835bd2\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:13:\"block_content\";i:1;s:26:\"entity_reference_revisions\";i:2;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"gzA7OAqszgyne63vWHEzNQQzhp58wo4JD5jrt82tjk8\";}s:2:\"id\";s:41:\"block_content.field_ebt_videos_and_images\";s:10:\"field_name\";s:27:\"field_ebt_videos_and_images\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:26:\"entity_reference_revisions\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:9:\"paragraph\";}s:6:\"module\";s:26:\"entity_reference_revisions\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_views_views',	'a:17:{s:4:\"uuid\";s:36:\"f11fd5af-293c-41e7-91eb-52f5c2b14f5a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:13:\"block_content\";i:1;s:5:\"views\";i:2;s:14:\"viewsreference\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"crklekBdziPXiKGCBhoUfqwhWUXAuyDEQHEw0J7NdQI\";}s:2:\"id\";s:35:\"block_content.field_ebt_views_views\";s:10:\"field_name\";s:21:\"field_ebt_views_views\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:14:\"viewsreference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:4:\"view\";}s:6:\"module\";s:14:\"viewsreference\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_webform_form',	'a:17:{s:4:\"uuid\";s:36:\"08365941-eddc-446f-8fc9-72a7728df65c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"K4nKI1yvxZ4s40vKrpuBiz09L15lK0ygK9etUTwYVRw\";}s:2:\"id\";s:36:\"block_content.field_ebt_webform_form\";s:10:\"field_name\";s:22:\"field_ebt_webform_form\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:7:\"webform\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:7:\"webform\";}s:6:\"module\";s:7:\"webform\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.block_content.field_ebt_webform_popup_form',	'a:17:{s:4:\"uuid\";s:36:\"fb27b8eb-ae9d-44ec-8d20-6aa1287b8b5f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"GlZwbpK_4w1bHHs_IAnr12BJmD-fvq2QCviVBXnfiRA\";}s:2:\"id\";s:42:\"block_content.field_ebt_webform_popup_form\";s:10:\"field_name\";s:28:\"field_ebt_webform_popup_form\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:7:\"webform\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:7:\"webform\";}s:6:\"module\";s:7:\"webform\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.media.field_media_audio_file',	'a:17:{s:4:\"uuid\";s:36:\"75a1e1d5-184d-4541-96b7-8957dddb2453\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"file\";i:1;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"JCHoh95CpUeBx9ch24Tmi6ru0nwmNz8xWVH4Qs7RnTg\";}s:2:\"id\";s:28:\"media.field_media_audio_file\";s:10:\"field_name\";s:22:\"field_media_audio_file\";s:11:\"entity_type\";s:5:\"media\";s:4:\"type\";s:4:\"file\";s:8:\"settings\";a:4:{s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;s:10:\"uri_scheme\";s:6:\"public\";}s:6:\"module\";s:4:\"file\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.media.field_media_document',	'a:17:{s:4:\"uuid\";s:36:\"2c293a08-a63a-47a3-8b49-8e7650f47903\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:2:{i:0;s:4:\"file\";i:1;s:5:\"media\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"BdkTx7IL59MCw5a_fOZprPTOGM_wcjz-Fm8g7HV3vFk\";}s:2:\"id\";s:26:\"media.field_media_document\";s:10:\"field_name\";s:20:\"field_media_document\";s:11:\"entity_type\";s:5:\"media\";s:4:\"type\";s:4:\"file\";s:8:\"settings\";a:4:{s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;s:10:\"uri_scheme\";s:6:\"public\";}s:6:\"module\";s:4:\"file\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.media.field_media_image',	'a:17:{s:4:\"uuid\";s:36:\"379994ed-ae76-4656-ab52-4f8661d6efc4\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:3:{i:0;s:4:\"file\";i:1;s:5:\"image\";i:2;s:5:\"media\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"0N0KSFk57p6qsq3qM4lYVGSuROvzXK-tSsdwByqUh3g\";}s:2:\"id\";s:23:\"media.field_media_image\";s:10:\"field_name\";s:17:\"field_media_image\";s:11:\"entity_type\";s:5:\"media\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:5:{s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:6:\"module\";s:5:\"image\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.media.field_media_oembed_video',	'a:17:{s:4:\"uuid\";s:36:\"eca9af3a-0023-4307-a38b-526dac079818\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"cNf_852Dq-fNnSaMI4LxL-J6N7bLkHuDbD9EUqOn4_U\";}s:2:\"id\";s:30:\"media.field_media_oembed_video\";s:10:\"field_name\";s:24:\"field_media_oembed_video\";s:11:\"entity_type\";s:5:\"media\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:255;s:14:\"case_sensitive\";b:0;s:8:\"is_ascii\";b:0;}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.media.field_media_video_file',	'a:17:{s:4:\"uuid\";s:36:\"4f8a6296-0295-4cc5-8e6a-c61c708a78ba\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"file\";i:1;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"z5mgbn1PIVZ5TNMByBmivqo_u3Rdk58UIzpyN4ypTeM\";}s:2:\"id\";s:28:\"media.field_media_video_file\";s:10:\"field_name\";s:22:\"field_media_video_file\";s:11:\"entity_type\";s:5:\"media\";s:4:\"type\";s:4:\"file\";s:8:\"settings\";a:4:{s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;s:10:\"uri_scheme\";s:6:\"public\";}s:6:\"module\";s:4:\"file\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.node.body',	'a:17:{s:4:\"uuid\";s:36:\"27acecd6-ddfe-41ab-ad13-d09a77410226\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY\";}s:2:\"id\";s:9:\"node.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:17:\"text_with_summary\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:1;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.node.field_image',	'a:17:{s:4:\"uuid\";s:36:\"0ce9563d-0108-4dd8-9768-e3f3f692efb8\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:4:\"file\";i:1;s:5:\"image\";i:2;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"EymokncRIZ7SgQT2IdOQhQJicX4nNc0K89ik-LxmOHE\";}s:2:\"id\";s:16:\"node.field_image\";s:10:\"field_name\";s:11:\"field_image\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:5:{s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:6:\"module\";s:5:\"image\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:1:{s:9:\"target_id\";a:1:{i:0;s:9:\"target_id\";}}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.node.field_metatags',	'a:16:{s:4:\"uuid\";s:36:\"3a56d56d-4fea-4e6d-abfd-6e9fd5799d1f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:7:\"metatag\";i:1;s:4:\"node\";}}s:2:\"id\";s:19:\"node.field_metatags\";s:10:\"field_name\";s:14:\"field_metatags\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:7:\"metatag\";s:8:\"settings\";a:0:{}s:6:\"module\";s:7:\"metatag\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.node.field_tags',	'a:17:{s:4:\"uuid\";s:36:\"11256bc1-c4ef-404b-ae80-826c196dfc3c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:8:\"taxonomy\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"WpOE_bs8Bs_HY2ns7n2r__de-xno0-Bxkqep5-MsHAs\";}s:2:\"id\";s:15:\"node.field_tags\";s:10:\"field_name\";s:10:\"field_tags\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:13:\"taxonomy_term\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.node.layout_builder__layout',	'a:16:{s:4:\"uuid\";s:36:\"01dcf303-887c-48ba-8de3-a183f2dc164d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:14:\"layout_builder\";i:1;s:4:\"node\";}}s:2:\"id\";s:27:\"node.layout_builder__layout\";s:10:\"field_name\";s:22:\"layout_builder__layout\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:14:\"layout_section\";s:8:\"settings\";a:0:{}s:6:\"module\";s:14:\"layout_builder\";s:6:\"locked\";b:1;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:0;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_accordion_text',	'a:17:{s:4:\"uuid\";s:36:\"c88354ca-8244-4d5a-8c63-2709d938c811\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"dl3BMOx4hnrrl4qqLYkCtUssYQ_RkV9iIcbThUL8opE\";}s:2:\"id\";s:34:\"paragraph.field_ebt_accordion_text\";s:10:\"field_name\";s:24:\"field_ebt_accordion_text\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_accordion_title',	'a:17:{s:4:\"uuid\";s:36:\"7205b1e6-f387-4cb5-80f3-ea6e935096ea\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"xtdycMRMTk1-RbuIsXUkC8uoiTiAeIi8PtDCDuev5pM\";}s:2:\"id\";s:35:\"paragraph.field_ebt_accordion_title\";s:10:\"field_name\";s:25:\"field_ebt_accordion_title\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_carousel_caption',	'a:17:{s:4:\"uuid\";s:36:\"9950466c-7cf2-451c-a90c-6d94bc4223d2\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eH045cIw7DgTbyESpPO40c1yE4GkZSKAsRjv6wCv1cc\";}s:2:\"id\";s:36:\"paragraph.field_ebt_carousel_caption\";s:10:\"field_name\";s:26:\"field_ebt_carousel_caption\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_carousel_image',	'a:17:{s:4:\"uuid\";s:36:\"c9955fe0-9e81-4347-b5c8-b3a2813ea422\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:5:\"media\";i:1;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sBBtSihKznwfoZE4RCUfKLyFx5JPJOKThpsezNspQUg\";}s:2:\"id\";s:34:\"paragraph.field_ebt_carousel_image\";s:10:\"field_name\";s:24:\"field_ebt_carousel_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:5:\"media\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_clickable_tile',	'a:17:{s:4:\"uuid\";s:36:\"4a6ac85b-3418-4331-8d82-82c365e01b2a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sqyvMHG_MfFRoRtp9QsU69-Hqibbf7-n0L6nXXuy-RY\";}s:2:\"id\";s:34:\"paragraph.field_ebt_clickable_tile\";s:10:\"field_name\";s:24:\"field_ebt_clickable_tile\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_counter_description',	'a:17:{s:4:\"uuid\";s:36:\"474cb9c9-f18d-40c9-8bdc-2b263c5bf1bb\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"T2aI_SC10fUAVAHAQ6YSjRx-RgZI16Y4DhBlcYV8xTY\";}s:2:\"id\";s:39:\"paragraph.field_ebt_counter_description\";s:10:\"field_name\";s:29:\"field_ebt_counter_description\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_counter_icon',	'a:17:{s:4:\"uuid\";s:36:\"17ec174c-0286-4b9d-8d57-f5618c7d73b5\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:5:\"media\";i:1;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"A3xIcHA3Yh7nEExvOCO8fCJ2RKTLwO7PHRzSW91-6ag\";}s:2:\"id\";s:32:\"paragraph.field_ebt_counter_icon\";s:10:\"field_name\";s:22:\"field_ebt_counter_icon\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:5:\"media\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_counter_number',	'a:17:{s:4:\"uuid\";s:36:\"fe9a8722-bb07-4268-815a-a4b9b20eb504\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"12yti1pJd8_55sJ_ipVJkKkOSBrqJNbIN1ScDohe8Ug\";}s:2:\"id\";s:34:\"paragraph.field_ebt_counter_number\";s:10:\"field_name\";s:24:\"field_ebt_counter_number\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:7:\"integer\";s:8:\"settings\";a:2:{s:8:\"unsigned\";b:0;s:4:\"size\";s:6:\"normal\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_counter_title',	'a:17:{s:4:\"uuid\";s:36:\"646af88e-2cb1-4e61-9b5a-1720fbe00d94\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"8SSZniajg5zo9MscuowyDAxLHlUJhnpGgVXmpef2Qfc\";}s:2:\"id\";s:33:\"paragraph.field_ebt_counter_title\";s:10:\"field_name\";s:23:\"field_ebt_counter_title\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_slick_slider_image',	'a:17:{s:4:\"uuid\";s:36:\"7b1e8d87-89a6-4d9c-b0ae-16292b52f88b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:5:\"media\";i:1;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"HwpmmxKvO4846yzGMxYlF27KAqxGN93LugyydI_mAQk\";}s:2:\"id\";s:38:\"paragraph.field_ebt_slick_slider_image\";s:10:\"field_name\";s:28:\"field_ebt_slick_slider_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:5:\"media\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_slick_slider_link',	'a:17:{s:4:\"uuid\";s:36:\"ce8c8911-2694-45d2-b941-6c8f08c9a8fd\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"link\";i:1;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2sX2ALM8UbHO085MTpnVsKr65w2_hTSuR1OGRh9yhnc\";}s:2:\"id\";s:37:\"paragraph.field_ebt_slick_slider_link\";s:10:\"field_name\";s:27:\"field_ebt_slick_slider_link\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_slick_slider_text',	'a:17:{s:4:\"uuid\";s:36:\"fd3e2c50-dcff-4f84-bd3f-a28c9352ea81\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"bw5ktsaCO3NIoI8s4_-sX-8nheZucWVVtes3gNa3nAM\";}s:2:\"id\";s:37:\"paragraph.field_ebt_slick_slider_text\";s:10:\"field_name\";s:27:\"field_ebt_slick_slider_text\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_slideshow_link',	'a:17:{s:4:\"uuid\";s:36:\"99143ce8-61ee-4652-a122-2b74cf0353a8\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"link\";i:1;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ZYqrMKPAVBTFXGukNiO0LmsHSZLTwSIqlH0B12cWoSc\";}s:2:\"id\";s:34:\"paragraph.field_ebt_slideshow_link\";s:10:\"field_name\";s:24:\"field_ebt_slideshow_link\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_slideshow_slide',	'a:17:{s:4:\"uuid\";s:36:\"20a2702c-d0d9-491e-bc0d-48bd8f4e5479\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:5:\"media\";i:1;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"yvMPSQ3opDpO2Y7W2gLC_lfyYsUerg7quMuaUIXTG6Y\";}s:2:\"id\";s:35:\"paragraph.field_ebt_slideshow_slide\";s:10:\"field_name\";s:25:\"field_ebt_slideshow_slide\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:5:\"media\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_slideshow_text',	'a:17:{s:4:\"uuid\";s:36:\"5476f31f-53b6-41ea-919f-8ea57cf902fc\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"l1sRS9qn9Xk0p6T25AqVsGWWAhp74-8ejyMC2cSICnA\";}s:2:\"id\";s:34:\"paragraph.field_ebt_slideshow_text\";s:10:\"field_name\";s:24:\"field_ebt_slideshow_text\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_slideshow_title',	'a:17:{s:4:\"uuid\";s:36:\"b514672e-03d7-4efa-81b8-0f04c6b94cd1\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"56OfbIVnrkDV6Ei_ldSAYihwJbVyAJds03m4lf7fsqc\";}s:2:\"id\";s:35:\"paragraph.field_ebt_slideshow_title\";s:10:\"field_name\";s:25:\"field_ebt_slideshow_title\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_tab_block',	'a:17:{s:4:\"uuid\";s:36:\"0fc30373-baea-48fd-8769-4b6c582ae3d8\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:11:\"block_field\";i:1;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"AwzF4qJWahe58UULrqET0cwFen2kxLMygeAFj96-4Kk\";}s:2:\"id\";s:29:\"paragraph.field_ebt_tab_block\";s:10:\"field_name\";s:19:\"field_ebt_tab_block\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:11:\"block_field\";s:8:\"settings\";a:0:{}s:6:\"module\";s:11:\"block_field\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_tab_content',	'a:17:{s:4:\"uuid\";s:36:\"d00f9fc0-b613-4eed-90b2-740af89205eb\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:7:\"options\";i:1;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7FvDDnDFUS9rxHT4MbM9RwHPArBckbhp09KzHNMtD10\";}s:2:\"id\";s:31:\"paragraph.field_ebt_tab_content\";s:10:\"field_name\";s:21:\"field_ebt_tab_content\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:11:\"list_string\";s:8:\"settings\";a:2:{s:14:\"allowed_values\";a:4:{i:0;a:2:{s:5:\"value\";s:4:\"text\";s:5:\"label\";s:4:\"Text\";}i:1;a:2:{s:5:\"value\";s:4:\"page\";s:5:\"label\";s:4:\"Page\";}i:2;a:2:{s:5:\"value\";s:5:\"block\";s:5:\"label\";s:5:\"Block\";}i:3;a:2:{s:5:\"value\";s:5:\"views\";s:5:\"label\";s:5:\"Views\";}}s:23:\"allowed_values_function\";s:0:\"\";}s:6:\"module\";s:7:\"options\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_tab_page',	'a:17:{s:4:\"uuid\";s:36:\"527f69af-c7cb-450d-a95f-a0199f66a3fc\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Lx2SQWOPiXsxTotbjz7VPPAu-QERRb10_IFn-ApZRDo\";}s:2:\"id\";s:28:\"paragraph.field_ebt_tab_page\";s:10:\"field_name\";s:18:\"field_ebt_tab_page\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:4:\"node\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_tab_text',	'a:17:{s:4:\"uuid\";s:36:\"7492acc6-65ae-4f1f-b3c7-3e41a385e8cb\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jvq8PSEOBXAVYlGbuM_TA0t_zulyHA_Bkjc6MrrkLWY\";}s:2:\"id\";s:28:\"paragraph.field_ebt_tab_text\";s:10:\"field_name\";s:18:\"field_ebt_tab_text\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_tab_title',	'a:17:{s:4:\"uuid\";s:36:\"0c03a11f-8242-48d7-ae98-2da2e80f3f2e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"chlF7z3GEcHoQnXo-49bdW3H_FSDPxAqWy0miEMc3AM\";}s:2:\"id\";s:29:\"paragraph.field_ebt_tab_title\";s:10:\"field_name\";s:19:\"field_ebt_tab_title\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:4:\"text\";s:8:\"settings\";a:1:{s:10:\"max_length\";i:1023;}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_tab_views',	'a:17:{s:4:\"uuid\";s:36:\"3dc81a0a-ea91-4e72-af8b-18c1abffc08d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:10:\"paragraphs\";i:1;s:5:\"views\";i:2;s:14:\"viewsreference\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"QmZGd58IuoXxDcUvh8hfNHnRLR71GZA3qzfZpuVSjH4\";}s:2:\"id\";s:29:\"paragraph.field_ebt_tab_views\";s:10:\"field_name\";s:19:\"field_ebt_tab_views\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:14:\"viewsreference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:4:\"view\";}s:6:\"module\";s:14:\"viewsreference\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_tiles_image',	'a:17:{s:4:\"uuid\";s:36:\"3988ff22-66ff-4325-be58-387a6451784f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:5:\"media\";i:1;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"3aeaxW3pHrK5yFagP66-FT7HXAGYacr2YhOcg-h70n0\";}s:2:\"id\";s:31:\"paragraph.field_ebt_tiles_image\";s:10:\"field_name\";s:21:\"field_ebt_tiles_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:5:\"media\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_tiles_link',	'a:17:{s:4:\"uuid\";s:36:\"f1992284-2903-4d4f-b4c2-4336abc56b45\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"link\";i:1;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"mUN0Fv2hYJXOjWBr3fDMeZnblvk6m_qvnRncjAS5Jz0\";}s:2:\"id\";s:30:\"paragraph.field_ebt_tiles_link\";s:10:\"field_name\";s:20:\"field_ebt_tiles_link\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_tiles_text',	'a:17:{s:4:\"uuid\";s:36:\"6e677df8-5ee4-417d-be3a-d5036e605903\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SYBCp04_zUg3tqwrydEEBCSg6JWf7CR4f2Jym-jtu7Y\";}s:2:\"id\";s:30:\"paragraph.field_ebt_tiles_text\";s:10:\"field_name\";s:20:\"field_ebt_tiles_text\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_tiles_title',	'a:17:{s:4:\"uuid\";s:36:\"adfc8f4b-838d-40b5-956a-1f813f9dc592\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"__j2dIJmEb5SExuxv7f5bTbyHtFYlG0BqQD9owZgiFA\";}s:2:\"id\";s:31:\"paragraph.field_ebt_tiles_title\";s:10:\"field_name\";s:21:\"field_ebt_tiles_title\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_timeline_current',	'a:17:{s:4:\"uuid\";s:36:\"1043de86-9fe2-4436-8425-6f47521f1f00\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"io0Gxmv8qUwbnmMiTtgXlnMKWybAbO4f6d7W3yHn9vE\";}s:2:\"id\";s:36:\"paragraph.field_ebt_timeline_current\";s:10:\"field_name\";s:26:\"field_ebt_timeline_current\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_timeline_date',	'a:17:{s:4:\"uuid\";s:36:\"80c677f9-529e-499e-959c-dc9187ab7a49\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nmy2TG7m2qANlPD4kTWJk7016mawyxdzgYZ3omLSCVc\";}s:2:\"id\";s:33:\"paragraph.field_ebt_timeline_date\";s:10:\"field_name\";s:23:\"field_ebt_timeline_date\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:255;s:8:\"is_ascii\";b:0;s:14:\"case_sensitive\";b:0;}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_timeline_media_image',	'a:17:{s:4:\"uuid\";s:36:\"7089f45d-1e3c-4225-bba6-736084040e5b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:5:\"media\";i:1;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"yB2KT5oQDNzQfggkUQGHhoqlikRSVCE8a5MSV_5NvEo\";}s:2:\"id\";s:40:\"paragraph.field_ebt_timeline_media_image\";s:10:\"field_name\";s:30:\"field_ebt_timeline_media_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:5:\"media\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_timeline_text',	'a:17:{s:4:\"uuid\";s:36:\"fe035edd-b535-4ceb-bd54-a3c604fbae92\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"CFCHP9vAPguIB2d677v2iLm245zKg4MRxpfICMcUHo8\";}s:2:\"id\";s:33:\"paragraph.field_ebt_timeline_text\";s:10:\"field_name\";s:23:\"field_ebt_timeline_text\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_ebt_timeline_title',	'a:17:{s:4:\"uuid\";s:36:\"7b0677d8-0312-4994-b0a6-cd1c0852a050\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"cM8ncQUeGNJamKPS5THMY_gIhCe_qsCwn4s-_6YPaq4\";}s:2:\"id\";s:34:\"paragraph.field_ebt_timeline_title\";s:10:\"field_name\";s:24:\"field_ebt_timeline_title\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:512;s:8:\"is_ascii\";b:0;s:14:\"case_sensitive\";b:0;}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_gallery_item_description',	'a:17:{s:4:\"uuid\";s:36:\"31c1cb14-3677-44d6-951e-3560a93c8f65\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jf90xTmsti89Pjc4bIjB0aBV5QshhjB0mhGkqONmGjU\";}s:2:\"id\";s:40:\"paragraph.field_gallery_item_description\";s:10:\"field_name\";s:30:\"field_gallery_item_description\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_stats_item_image',	'a:17:{s:4:\"uuid\";s:36:\"233843a3-22c1-4376-a920-f894f695b87c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:5:\"media\";i:1;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ml8f47_-t_lza9fvHT7YnpccMFPtmO5CC_TKle1QMr8\";}s:2:\"id\";s:32:\"paragraph.field_stats_item_image\";s:10:\"field_name\";s:22:\"field_stats_item_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:5:\"media\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_stats_item_link',	'a:17:{s:4:\"uuid\";s:36:\"7003f50c-c76e-4efe-bfcc-67453daeb93c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"link\";i:1;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6Xx4YNeE_zQDdDg8HySkyOGsBrl8RHNnsFsWYoC1GI4\";}s:2:\"id\";s:31:\"paragraph.field_stats_item_link\";s:10:\"field_name\";s:21:\"field_stats_item_link\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_stats_item_number',	'a:17:{s:4:\"uuid\";s:36:\"f6763f4c-c4a6-4d80-ab1d-f0e2aca44f60\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"YWL60ZrNzy_L7BYYe7ipJCC3__awGcG9ewUwecK82J4\";}s:2:\"id\";s:33:\"paragraph.field_stats_item_number\";s:10:\"field_name\";s:23:\"field_stats_item_number\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_stats_item_text',	'a:17:{s:4:\"uuid\";s:36:\"0d6fd00f-5382-443f-ae8a-996e1552af22\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7R83PXXuAu39Em7tMg3vXyaerbWjilK3AuSi3IXVRYc\";}s:2:\"id\";s:31:\"paragraph.field_stats_item_text\";s:10:\"field_name\";s:21:\"field_stats_item_text\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.paragraph.field_video_gallery_item',	'a:17:{s:4:\"uuid\";s:36:\"5c6f70cc-17fc-4f18-bcfb-4c0d8a66500e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:5:\"media\";i:1;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"qNGEoWbTX-CnhncjUmfOTlH2eL2GnzBZckwY_yzsHfM\";}s:2:\"id\";s:34:\"paragraph.field_video_gallery_item\";s:10:\"field_name\";s:24:\"field_video_gallery_item\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:5:\"media\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field.storage.user.user_picture',	'a:17:{s:4:\"uuid\";s:36:\"13a3c6c5-6417-4477-8a58-0b066b2141c3\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:4:\"file\";i:1;s:5:\"image\";i:2;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"0q8-mw8y-Ls5I578sIPQFLp4ljpH7WvVYpzY-I9O-8E\";}s:2:\"id\";s:17:\"user.user_picture\";s:10:\"field_name\";s:12:\"user_picture\";s:11:\"entity_type\";s:4:\"user\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:5:{s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";a:5:{s:4:\"uuid\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:6:\"module\";s:5:\"image\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:1:{s:9:\"target_id\";a:1:{i:0;s:9:\"target_id\";}}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}'),
('',	'field_ui.settings',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Q1nMi90W6YQxKzZAgJQw7Ag9U4JrsEUwkomF0lhvbIM\";}s:12:\"field_prefix\";s:6:\"field_\";}'),
('',	'file.settings',	'a:5:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2bwjZB1IjEYbppgZT3g7YW_5h_LDZYNa3DaDEfWX82U\";}s:11:\"description\";a:2:{s:4:\"type\";s:9:\"textfield\";s:6:\"length\";i:128;}s:4:\"icon\";a:1:{s:9:\"directory\";s:23:\"core/modules/file/icons\";}s:35:\"make_unused_managed_files_temporary\";b:0;s:21:\"filename_sanitization\";a:6:{s:13:\"transliterate\";b:1;s:18:\"replace_whitespace\";b:1;s:24:\"replace_non_alphanumeric\";b:1;s:22:\"deduplicate_separators\";b:1;s:9:\"lowercase\";b:1;s:21:\"replacement_character\";s:1:\"-\";}}'),
('',	'filter.format.basic_html',	'a:9:{s:4:\"uuid\";s:36:\"5d0c18fb-1e15-4eac-9e4b-1484b52ff943\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:6:\"editor\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"mclCbTlJwWJORez4Y1eX2MqA0aGjSMAoJb3TaBABcK8\";}s:4:\"name\";s:10:\"Basic HTML\";s:6:\"format\";s:10:\"basic_html\";s:6:\"weight\";i:0;s:7:\"filters\";a:6:{s:21:\"editor_file_reference\";a:5:{s:2:\"id\";s:21:\"editor_file_reference\";s:8:\"provider\";s:6:\"editor\";s:6:\"status\";b:1;s:6:\"weight\";i:11;s:8:\"settings\";a:0:{}}s:12:\"filter_align\";a:5:{s:2:\"id\";s:12:\"filter_align\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:7;s:8:\"settings\";a:0:{}}s:14:\"filter_caption\";a:5:{s:2:\"id\";s:14:\"filter_caption\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:8;s:8:\"settings\";a:0:{}}s:11:\"filter_html\";a:5:{s:2:\"id\";s:11:\"filter_html\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:-10;s:8:\"settings\";a:3:{s:12:\"allowed_html\";s:243:\"<br> <p> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id> <cite> <dl> <dt> <dd> <a hreflang href> <blockquote cite> <ul type> <ol start type> <strong> <em> <code> <li> <img src alt data-entity-uuid data-entity-type height width data-caption data-align>\";s:16:\"filter_html_help\";b:0;s:20:\"filter_html_nofollow\";b:0;}}s:24:\"filter_html_image_secure\";a:5:{s:2:\"id\";s:24:\"filter_html_image_secure\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:9;s:8:\"settings\";a:0:{}}s:22:\"filter_image_lazy_load\";a:5:{s:2:\"id\";s:22:\"filter_image_lazy_load\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:15;s:8:\"settings\";a:0:{}}}}'),
('',	'filter.format.full_html',	'a:9:{s:4:\"uuid\";s:36:\"e00030fb-b30d-42df-a35b-b9dca992742e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:6:\"editor\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"vpZysv3RHJjhYzq7O_q5q8mVlHdrSzKELmXyiX6RtV0\";}s:4:\"name\";s:9:\"Full HTML\";s:6:\"format\";s:9:\"full_html\";s:6:\"weight\";i:2;s:7:\"filters\";a:5:{s:21:\"editor_file_reference\";a:5:{s:2:\"id\";s:21:\"editor_file_reference\";s:8:\"provider\";s:6:\"editor\";s:6:\"status\";b:1;s:6:\"weight\";i:11;s:8:\"settings\";a:0:{}}s:12:\"filter_align\";a:5:{s:2:\"id\";s:12:\"filter_align\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:8;s:8:\"settings\";a:0:{}}s:14:\"filter_caption\";a:5:{s:2:\"id\";s:14:\"filter_caption\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:9;s:8:\"settings\";a:0:{}}s:20:\"filter_htmlcorrector\";a:5:{s:2:\"id\";s:20:\"filter_htmlcorrector\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:10;s:8:\"settings\";a:0:{}}s:22:\"filter_image_lazy_load\";a:5:{s:2:\"id\";s:22:\"filter_image_lazy_load\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:15;s:8:\"settings\";a:0:{}}}}'),
('',	'filter.format.plain_text',	'a:9:{s:4:\"uuid\";s:36:\"98975409-6030-4f9b-8f64-18610166736a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"JLMwODO0epnA_H-jFlH9ezVfa5YBJniRv3MmLqYNl_Q\";}s:4:\"name\";s:10:\"Plain text\";s:6:\"format\";s:10:\"plain_text\";s:6:\"weight\";i:10;s:7:\"filters\";a:3:{s:12:\"filter_autop\";a:5:{s:2:\"id\";s:12:\"filter_autop\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}}s:18:\"filter_html_escape\";a:5:{s:2:\"id\";s:18:\"filter_html_escape\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:-10;s:8:\"settings\";a:0:{}}s:10:\"filter_url\";a:5:{s:2:\"id\";s:10:\"filter_url\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:0;s:8:\"settings\";a:1:{s:17:\"filter_url_length\";i:72;}}}}'),
('',	'filter.format.restricted_html',	'a:9:{s:4:\"uuid\";s:36:\"8ca43f73-d620-4c03-bbd7-8221d546124f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"QiKqQS_YGAT3Qr4vaAgZICJknm-MGCzt_xBAMqg-tRM\";}s:4:\"name\";s:15:\"Restricted HTML\";s:6:\"format\";s:15:\"restricted_html\";s:6:\"weight\";i:1;s:7:\"filters\";a:3:{s:12:\"filter_autop\";a:5:{s:2:\"id\";s:12:\"filter_autop\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}}s:11:\"filter_html\";a:5:{s:2:\"id\";s:11:\"filter_html\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:-10;s:8:\"settings\";a:3:{s:12:\"allowed_html\";s:149:\"<a href hreflang> <em> <strong> <cite> <blockquote cite> <code> <ul type> <ol start type> <li> <dl> <dt> <dd> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id>\";s:16:\"filter_html_help\";b:1;s:20:\"filter_html_nofollow\";b:0;}}s:10:\"filter_url\";a:5:{s:2:\"id\";s:10:\"filter_url\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:0;s:8:\"settings\";a:1:{s:17:\"filter_url_length\";i:72;}}}}'),
('',	'filter.format.webform_default',	'a:9:{s:4:\"uuid\";s:36:\"cf32d962-2f58-41c9-989d-a8f82367e8e1\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"EeKp_M4Oid3erARiAam9rsgBKR91uEnFkEP3aZS2ol8\";}s:4:\"name\";s:31:\"Webform (Default) - DO NOT EDIT\";s:6:\"format\";s:15:\"webform_default\";s:6:\"weight\";i:100;s:7:\"filters\";a:0:{}}'),
('',	'filter.settings',	'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"FiPjM3WdB__ruFA7B6TLwni_UcZbmek5G4b2dxQItxA\";}s:15:\"fallback_format\";s:10:\"plain_text\";s:27:\"always_show_fallback_choice\";b:0;}'),
('',	'glightbox.settings',	'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"5G059LQS_7DV7oGUpxVTPM0aWtunW7bvDpRkgeb0KtE\";}s:6:\"custom\";a:17:{s:8:\"activate\";i:0;s:11:\"open_effect\";s:4:\"zoom\";s:12:\"close_effect\";s:4:\"zoom\";s:12:\"slide_effect\";s:5:\"slide\";s:5:\"width\";s:3:\"98%\";s:6:\"height\";s:3:\"98%\";s:11:\"videosWidth\";s:5:\"960px\";s:22:\"close_on_outside_click\";b:1;s:9:\"more_text\";s:8:\"See more\";s:11:\"more_length\";i:60;s:13:\"desc_position\";s:6:\"bottom\";s:4:\"loop\";b:0;s:8:\"zoomable\";b:1;s:9:\"draggable\";b:1;s:7:\"preload\";b:1;s:15:\"autoplay_videos\";b:1;s:16:\"autofocus_videos\";b:0;}s:8:\"advanced\";a:2:{s:12:\"unique_token\";i:0;s:16:\"compression_type\";s:8:\"minified\";}}'),
('',	'google_analytics.settings',	'a:12:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"dwMYPgAnj9KBO77SLEv9Z42NDJAbuxe0uU9eGC8qw3M\";}s:7:\"account\";s:0:\"\";s:11:\"domain_mode\";i:0;s:13:\"cross_domains\";s:0:\"\";s:10:\"visibility\";a:5:{s:17:\"request_path_mode\";i:0;s:18:\"request_path_pages\";s:53:\"/admin\n/admin/*\n/batch\n/node/add*\n/node/*/*\n/user/*/*\";s:14:\"user_role_mode\";i:0;s:15:\"user_role_roles\";a:0:{}s:17:\"user_account_mode\";i:1;}s:5:\"track\";a:13:{s:8:\"outbound\";b:1;s:6:\"mailto\";b:1;s:3:\"tel\";b:1;s:5:\"files\";b:1;s:16:\"files_extensions\";s:279:\"7z|aac|arc|arj|asf|asx|avi|bin|csv|doc(x|m)?|dot(x|m)?|exe|flv|gif|gz|gzip|hqx|jar|jpe?g|js|mp(2|3|4|e?g)|mov(ie)?|msi|msp|pdf|phps|png|ppt(x|m)?|pot(x|m)?|pps(x|m)?|ppam|sld(x|m)?|thmx|qtm?|ra(m|r)?|sea|sit|tar|tgz|torrent|txt|wav|wma|wmv|wpd|xls(x|m|b)?|xlt(x|m)|xlam|xml|z|zip\";s:8:\"colorbox\";b:1;s:6:\"linkid\";b:0;s:12:\"urlfragments\";b:0;s:6:\"userid\";b:0;s:8:\"messages\";a:0:{}s:11:\"site_search\";b:0;s:7:\"adsense\";b:0;s:15:\"displayfeatures\";b:1;}s:7:\"privacy\";a:1:{s:11:\"anonymizeip\";b:1;}s:6:\"custom\";a:1:{s:10:\"parameters\";a:0:{}}s:11:\"codesnippet\";a:3:{s:6:\"create\";a:0:{}s:6:\"before\";s:0:\"\";s:5:\"after\";s:0:\"\";}s:15:\"translation_set\";b:0;s:5:\"cache\";b:0;s:5:\"debug\";b:0;}'),
('',	'image.settings',	'a:4:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"k-yDFHbqNfpe-Srg4sdCSqaosCl2D8uwyEY5esF8gEw\";}s:13:\"preview_image\";s:29:\"core/modules/image/sample.png\";s:26:\"allow_insecure_derivatives\";b:0;s:20:\"suppress_itok_output\";b:0;}'),
('',	'image.style.ebt_gallery_image',	'a:8:{s:4:\"uuid\";s:36:\"3387ae71-e231-4ddd-9e5f-664ca37b095b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Et29BhgBeTqvhgY2GYsCViL4QGjZRI0vsbEe5O1VON4\";}s:4:\"name\";s:17:\"ebt_gallery_image\";s:5:\"label\";s:17:\"EBT Gallery Image\";s:7:\"effects\";a:1:{s:36:\"6ab4544c-7611-414c-aaa8-4eed96b10c84\";a:4:{s:4:\"uuid\";s:36:\"6ab4544c-7611-414c-aaa8-4eed96b10c84\";s:2:\"id\";s:20:\"image_scale_and_crop\";s:6:\"weight\";i:1;s:4:\"data\";a:3:{s:5:\"width\";i:365;s:6:\"height\";i:265;s:6:\"anchor\";s:13:\"center-center\";}}}}'),
('',	'image.style.ebt_video_and_image_gallery',	'a:8:{s:4:\"uuid\";s:36:\"c4e70146-66c8-4f81-9049-d4e41b4c5305\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"9px7Sz4srt9t5bnyp1lHoLhxTyuSbHKBR0pbE7rMPJ4\";}s:4:\"name\";s:27:\"ebt_video_and_image_gallery\";s:5:\"label\";s:27:\"EBT Video and Image gallery\";s:7:\"effects\";a:1:{s:36:\"de12b6ed-b5ac-4ec8-9cf1-0df6cb6c8d32\";a:4:{s:4:\"uuid\";s:36:\"de12b6ed-b5ac-4ec8-9cf1-0df6cb6c8d32\";s:2:\"id\";s:20:\"image_scale_and_crop\";s:6:\"weight\";i:1;s:4:\"data\";a:3:{s:5:\"width\";i:480;s:6:\"height\";i:360;s:6:\"anchor\";s:13:\"center-center\";}}}}'),
('',	'image.style.large',	'a:8:{s:4:\"uuid\";s:36:\"527e81f9-fafb-4f3e-aad6-f169b5885095\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"rDR2BOewa2UFH9yG4tVvrGxEVv8U7LQo-RLkJhFpERs\";}s:4:\"name\";s:5:\"large\";s:5:\"label\";s:16:\"Large (480×480)\";s:7:\"effects\";a:2:{s:36:\"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d\";a:4:{s:4:\"uuid\";s:36:\"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:0;s:4:\"data\";a:3:{s:5:\"width\";i:480;s:6:\"height\";i:480;s:7:\"upscale\";b:0;}}s:36:\"6e8fe467-84c1-4ef0-a73b-7eccf1cc20e8\";a:4:{s:4:\"uuid\";s:36:\"6e8fe467-84c1-4ef0-a73b-7eccf1cc20e8\";s:2:\"id\";s:13:\"image_convert\";s:6:\"weight\";i:2;s:4:\"data\";a:1:{s:9:\"extension\";s:4:\"webp\";}}}}'),
('',	'image.style.linkit_result_thumbnail',	'a:8:{s:4:\"uuid\";s:36:\"7751cf12-1253-4c81-bcd8-bc001066b67b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"PY0kMp7KIxvU4kBi5mcnD_DHTKUc1OkYCfaPliXjpa8\";}s:4:\"name\";s:23:\"linkit_result_thumbnail\";s:5:\"label\";s:23:\"Linkit result thumbnail\";s:7:\"effects\";a:1:{s:36:\"2943df29-38ea-459c-ba1d-290489bb1807\";a:4:{s:4:\"uuid\";s:36:\"2943df29-38ea-459c-ba1d-290489bb1807\";s:2:\"id\";s:20:\"image_scale_and_crop\";s:6:\"weight\";i:1;s:4:\"data\";a:3:{s:5:\"width\";i:50;s:6:\"height\";i:50;s:6:\"anchor\";s:13:\"center-center\";}}}}'),
('',	'image.style.media_library',	'a:8:{s:4:\"uuid\";s:36:\"9fcd2b87-5cd2-4214-90f8-d2a1c4229d26\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:13:\"media_library\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"FxMdscEA4aDH0KPM73HIZtVn3zIAgC1kQ3CkBw26HYs\";}s:4:\"name\";s:13:\"media_library\";s:5:\"label\";s:34:\"Media Library thumbnail (220×220)\";s:7:\"effects\";a:2:{s:36:\"75b076a8-1234-4b42-85db-bf377c4d8d5f\";a:4:{s:4:\"uuid\";s:36:\"75b076a8-1234-4b42-85db-bf377c4d8d5f\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:0;s:4:\"data\";a:3:{s:5:\"width\";i:220;s:6:\"height\";i:220;s:7:\"upscale\";b:0;}}s:36:\"1021da71-fc2a-43d0-be5d-efaf1c79e2ea\";a:4:{s:4:\"uuid\";s:36:\"1021da71-fc2a-43d0-be5d-efaf1c79e2ea\";s:2:\"id\";s:13:\"image_convert\";s:6:\"weight\";i:2;s:4:\"data\";a:1:{s:9:\"extension\";s:4:\"webp\";}}}}'),
('',	'image.style.medium',	'a:8:{s:4:\"uuid\";s:36:\"c8b8fa24-4235-4e63-abae-72f30beb637e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"dlar76VBuGj5iMGTruB_uMZX8VbivXt9_QLemaG2q4E\";}s:4:\"name\";s:6:\"medium\";s:5:\"label\";s:17:\"Medium (220×220)\";s:7:\"effects\";a:2:{s:36:\"bddf0d06-42f9-4c75-a700-a33cafa25ea0\";a:4:{s:4:\"uuid\";s:36:\"bddf0d06-42f9-4c75-a700-a33cafa25ea0\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:0;s:4:\"data\";a:3:{s:5:\"width\";i:220;s:6:\"height\";i:220;s:7:\"upscale\";b:0;}}s:36:\"c410ed2f-aa30-4d9c-a224-d2865d9188cd\";a:4:{s:4:\"uuid\";s:36:\"c410ed2f-aa30-4d9c-a224-d2865d9188cd\";s:2:\"id\";s:13:\"image_convert\";s:6:\"weight\";i:2;s:4:\"data\";a:1:{s:9:\"extension\";s:4:\"webp\";}}}}'),
('',	'image.style.quote_image',	'a:8:{s:4:\"uuid\";s:36:\"60fb949e-3206-43f8-8a85-d75fa8ec9bf5\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"xlTbw2rsxfnXJ7Hv3VCpxLp5Ekaa0jutCubC0YpGcbw\";}s:4:\"name\";s:11:\"quote_image\";s:5:\"label\";s:11:\"Quote Image\";s:7:\"effects\";a:1:{s:36:\"d8117768-053a-4efa-87bf-a1e49600d865\";a:4:{s:4:\"uuid\";s:36:\"d8117768-053a-4efa-87bf-a1e49600d865\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:2;s:4:\"data\";a:3:{s:5:\"width\";i:530;s:6:\"height\";N;s:7:\"upscale\";b:0;}}}}'),
('',	'image.style.slick_slider_card',	'a:8:{s:4:\"uuid\";s:36:\"a7519911-04cf-4e32-8dd4-55d8d342ddfc\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2zkdfRMnFwX0N2JCd1N-mTn2NTGgTRwRkfqW4Uiit8c\";}s:4:\"name\";s:17:\"slick_slider_card\";s:5:\"label\";s:17:\"Slick Slider card\";s:7:\"effects\";a:1:{s:36:\"c770ae08-739c-4196-a069-6d5becc97113\";a:4:{s:4:\"uuid\";s:36:\"c770ae08-739c-4196-a069-6d5becc97113\";s:2:\"id\";s:20:\"image_scale_and_crop\";s:6:\"weight\";i:2;s:4:\"data\";a:3:{s:5:\"width\";i:400;s:6:\"height\";i:300;s:6:\"anchor\";s:13:\"center-center\";}}}}'),
('',	'image.style.thumbnail',	'a:8:{s:4:\"uuid\";s:36:\"7e8ff02c-5435-43f6-8dc3-916788ea8d9f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"BgeBV-xOFINMsz-y2thm45EGesj6bRM6DTLZ6ce3V9I\";}s:4:\"name\";s:9:\"thumbnail\";s:5:\"label\";s:20:\"Thumbnail (100×100)\";s:7:\"effects\";a:2:{s:36:\"1cfec298-8620-4749-b100-ccb6c4500779\";a:4:{s:4:\"uuid\";s:36:\"1cfec298-8620-4749-b100-ccb6c4500779\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:0;s:4:\"data\";a:3:{s:5:\"width\";i:100;s:6:\"height\";i:100;s:7:\"upscale\";b:0;}}s:36:\"c4eb9942-2c9e-4a81-949f-6161a44b6559\";a:4:{s:4:\"uuid\";s:36:\"c4eb9942-2c9e-4a81-949f-6161a44b6559\";s:2:\"id\";s:13:\"image_convert\";s:6:\"weight\";i:2;s:4:\"data\";a:1:{s:9:\"extension\";s:4:\"webp\";}}}}'),
('',	'image.style.wide',	'a:8:{s:4:\"uuid\";s:36:\"cf4a237b-4886-4db6-90a2-e2f1348070b5\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"XHh3ATMH7z4ljwmzdndM47qNMkgLnoYsP98rGxVgCOw\";}s:4:\"name\";s:4:\"wide\";s:5:\"label\";s:11:\"Wide (1090)\";s:7:\"effects\";a:2:{s:36:\"09959c15-59ce-4f6d-90df-e2d7cf32bce5\";a:4:{s:4:\"uuid\";s:36:\"09959c15-59ce-4f6d-90df-e2d7cf32bce5\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:1;s:4:\"data\";a:3:{s:5:\"width\";i:1090;s:6:\"height\";N;s:7:\"upscale\";b:0;}}s:36:\"294c5f76-42a4-43ce-82c2-81c2f4723da0\";a:4:{s:4:\"uuid\";s:36:\"294c5f76-42a4-43ce-82c2-81c2f4723da0\";s:2:\"id\";s:13:\"image_convert\";s:6:\"weight\";i:2;s:4:\"data\";a:1:{s:9:\"extension\";s:4:\"webp\";}}}}'),
('',	'linkit.linkit_profile.default',	'a:9:{s:4:\"uuid\";s:36:\"655a70f6-77d9-4568-ad74-866e455f296a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"0Jw_BFJCCtWk187tIYvME58VFpYwPaAdrc4eRtAyHH0\";}s:5:\"label\";s:7:\"Default\";s:2:\"id\";s:7:\"default\";s:11:\"description\";s:24:\"A default Linkit profile\";s:8:\"matchers\";a:1:{s:36:\"556010a3-e317-48b3-b4ed-854c10f4b950\";a:4:{s:2:\"id\";s:11:\"entity:node\";s:4:\"uuid\";s:36:\"556010a3-e317-48b3-b4ed-854c10f4b950\";s:8:\"settings\";a:6:{s:8:\"metadata\";s:77:\"[node:content-type:name] #[node:nid] | [node:created:medium] by [node:author]\";s:7:\"bundles\";a:0:{}s:15:\"group_by_bundle\";b:0;s:19:\"include_unpublished\";b:0;s:17:\"substitution_type\";s:9:\"canonical\";s:5:\"limit\";i:100;}s:6:\"weight\";i:0;}}}'),
('',	'media.settings',	'a:5:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"WCFqLQAxMw1weToDJEhfnW1Z-iOF7cqMdL8X7YTFxBA\";}s:13:\"icon_base_uri\";s:28:\"public://media-icons/generic\";s:13:\"iframe_domain\";N;s:20:\"oembed_providers_url\";s:33:\"https://oembed.com/providers.json\";s:14:\"standalone_url\";b:0;}'),
('',	'media.type.audio',	'a:13:{s:4:\"uuid\";s:36:\"5b9f8640-5def-4f1f-8cbb-9a34ee0d322b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eJw8n6Tk2tO3ZysuEeGR1gZa1yRffaZzR4t0Q7iNurs\";}s:2:\"id\";s:5:\"audio\";s:5:\"label\";s:5:\"Audio\";s:11:\"description\";s:28:\"A locally hosted audio file.\";s:6:\"source\";s:10:\"audio_file\";s:25:\"queue_thumbnail_downloads\";b:0;s:12:\"new_revision\";b:1;s:20:\"source_configuration\";a:1:{s:12:\"source_field\";s:22:\"field_media_audio_file\";}s:9:\"field_map\";a:1:{s:4:\"name\";s:4:\"name\";}}'),
('',	'media.type.document',	'a:13:{s:4:\"uuid\";s:36:\"474a8161-6e84-4c54-8d09-7cd6cf51ca6f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"_D9q3XSnP6ik9we9UuoTvZsQKPuYNp_G9PfwVtWzgnQ\";}s:2:\"id\";s:8:\"document\";s:5:\"label\";s:8:\"Document\";s:11:\"description\";s:44:\"An uploaded file or document, such as a PDF.\";s:6:\"source\";s:4:\"file\";s:25:\"queue_thumbnail_downloads\";b:0;s:12:\"new_revision\";b:1;s:20:\"source_configuration\";a:1:{s:12:\"source_field\";s:20:\"field_media_document\";}s:9:\"field_map\";a:1:{s:4:\"name\";s:4:\"name\";}}'),
('',	'media.type.image',	'a:13:{s:4:\"uuid\";s:36:\"d02792ed-7ab7-466f-94e2-1bc1eb7fc178\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6Qope5wG7HUpV0tPOBMtDI_GZkHFcF1Xj4hgD9Cu_hM\";}s:2:\"id\";s:5:\"image\";s:5:\"label\";s:5:\"Image\";s:11:\"description\";s:36:\"Use local images for reusable media.\";s:6:\"source\";s:5:\"image\";s:25:\"queue_thumbnail_downloads\";b:0;s:12:\"new_revision\";b:1;s:20:\"source_configuration\";a:1:{s:12:\"source_field\";s:17:\"field_media_image\";}s:9:\"field_map\";a:1:{s:4:\"name\";s:4:\"name\";}}'),
('',	'media.type.remote_video',	'a:13:{s:4:\"uuid\";s:36:\"59bb7b69-536f-47d7-b202-4c65a9b02036\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"hIBTnDGgDKnCiP6HUZm1m7600DHUEpC6FN3LQ4sUgZ4\";}s:2:\"id\";s:12:\"remote_video\";s:5:\"label\";s:12:\"Remote video\";s:11:\"description\";s:46:\"A remotely hosted video from YouTube or Vimeo.\";s:6:\"source\";s:12:\"oembed:video\";s:25:\"queue_thumbnail_downloads\";b:0;s:12:\"new_revision\";b:1;s:20:\"source_configuration\";a:3:{s:12:\"source_field\";s:24:\"field_media_oembed_video\";s:20:\"thumbnails_directory\";s:44:\"public://oembed_thumbnails/[date:custom:Y-m]\";s:9:\"providers\";a:2:{i:0;s:7:\"YouTube\";i:1;s:5:\"Vimeo\";}}s:9:\"field_map\";a:1:{s:5:\"title\";s:4:\"name\";}}'),
('',	'media.type.video',	'a:13:{s:4:\"uuid\";s:36:\"47a446d2-2250-4e11-98eb-8a4c51117635\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"hzgvcRgZHltqWf8hBmttoWh95tCJoPL25lPq9YSIRsY\";}s:2:\"id\";s:5:\"video\";s:5:\"label\";s:5:\"Video\";s:11:\"description\";s:28:\"A locally hosted video file.\";s:6:\"source\";s:10:\"video_file\";s:25:\"queue_thumbnail_downloads\";b:0;s:12:\"new_revision\";b:1;s:20:\"source_configuration\";a:1:{s:12:\"source_field\";s:22:\"field_media_video_file\";}s:9:\"field_map\";a:1:{s:4:\"name\";s:4:\"name\";}}'),
('',	'media_library.settings',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"_3gQsCnZELUjUUqHk8SSh8bXnx7TZwN95vctAeVJG60\";}s:11:\"advanced_ui\";b:0;}'),
('',	'menu_ui.settings',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SqMarzIjxC3F8dZo9FEOxfqDKD_sdW1tbcFTV1BA2zU\";}s:24:\"override_parent_selector\";b:0;}'),
('',	'metatag.metatag_defaults.403',	'a:8:{s:4:\"uuid\";s:36:\"32de19c3-215d-4985-a7d7-d588a90d7f0d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"RDCkFL0NDt75Gwioooxo1iuA1S50xTVsBOgX__c6wTw\";}s:2:\"id\";s:3:\"403\";s:5:\"label\";s:17:\"403 access denied\";s:4:\"tags\";a:3:{s:6:\"robots\";s:7:\"noindex\";s:13:\"canonical_url\";s:10:\"[site:url]\";s:9:\"shortlink\";s:10:\"[site:url]\";}}'),
('',	'metatag.metatag_defaults.404',	'a:8:{s:4:\"uuid\";s:36:\"1131c9da-259d-4688-af2b-8cd70c4d304f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"puBstSLDz8mbaWU357zaqQDBGMGsJzG0j-TQNQkjg20\";}s:2:\"id\";s:3:\"404\";s:5:\"label\";s:18:\"404 page not found\";s:4:\"tags\";a:2:{s:13:\"canonical_url\";s:10:\"[site:url]\";s:9:\"shortlink\";s:10:\"[site:url]\";}}'),
('',	'metatag.metatag_defaults.front',	'a:8:{s:4:\"uuid\";s:36:\"14e6bd6a-5fd4-4abb-b304-231e944ee914\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"1noCXlegCr5HFehQRF1ViXy1jhU1jZ_sNN99a8Sj5jo\";}s:2:\"id\";s:5:\"front\";s:5:\"label\";s:10:\"Front page\";s:4:\"tags\";a:2:{s:13:\"canonical_url\";s:10:\"[site:url]\";s:9:\"shortlink\";s:10:\"[site:url]\";}}'),
('',	'metatag.metatag_defaults.global',	'a:8:{s:4:\"uuid\";s:36:\"c377ec68-aa9d-4ed0-8e17-b44da3051c14\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sL588ui1E_8-2c_UupwyYxcqX2OVyMFp3HTLbbFqvPc\";}s:2:\"id\";s:6:\"global\";s:5:\"label\";s:6:\"Global\";s:4:\"tags\";a:2:{s:13:\"canonical_url\";s:18:\"[current-page:url]\";s:5:\"title\";s:34:\"[current-page:title] | [site:name]\";}}'),
('',	'metatag.metatag_defaults.node',	'a:8:{s:4:\"uuid\";s:36:\"3950fa9e-d155-4064-8913-f7928e563aa1\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"rpwvgyEURXLz_JjgMCrkS1rUv-0k3L79BpO-ReN7fDI\";}s:2:\"id\";s:4:\"node\";s:5:\"label\";s:7:\"Content\";s:4:\"tags\";a:3:{s:5:\"title\";s:26:\"[node:title] | [site:name]\";s:11:\"description\";s:14:\"[node:summary]\";s:13:\"canonical_url\";s:10:\"[node:url]\";}}'),
('',	'metatag.metatag_defaults.taxonomy_term',	'a:8:{s:4:\"uuid\";s:36:\"7175fa40-e959-4cb9-a9af-08b0acf53b23\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"92bXZdyYJ5xqukdfmGRr_CYcwm1vfuS8b8aJ7X_G7E0\";}s:2:\"id\";s:13:\"taxonomy_term\";s:5:\"label\";s:13:\"Taxonomy term\";s:4:\"tags\";a:3:{s:13:\"canonical_url\";s:10:\"[term:url]\";s:11:\"description\";s:18:\"[term:description]\";s:5:\"title\";s:25:\"[term:name] | [site:name]\";}}'),
('',	'metatag.metatag_defaults.user',	'a:8:{s:4:\"uuid\";s:36:\"2ce7b5a6-e273-4808-988d-bd51796041d7\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"MvQPTbQx0Vxwy0ordSHyixdZmLCMpvMdLD69dlwkrKc\";}s:2:\"id\";s:4:\"user\";s:5:\"label\";s:4:\"User\";s:4:\"tags\";a:3:{s:13:\"canonical_url\";s:10:\"[user:url]\";s:11:\"description\";s:11:\"[site:name]\";s:5:\"title\";s:33:\"[user:display-name] | [site:name]\";}}'),
('',	'metatag.settings',	'a:7:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"tKLBW2GXZVLFXqS9QgLyfTuxCLc1u_quKPQLtCia-Bw\";}s:18:\"entity_type_groups\";a:0:{}s:9:\"separator\";s:0:\"\";s:15:\"tag_trim_method\";s:11:\"beforeValue\";s:18:\"tag_trim_maxlength\";a:0:{}s:21:\"tag_scroll_max_height\";s:0:\"\";s:13:\"use_maxlength\";b:1;}'),
('',	'node.settings',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"W0cgFPhPJ3gAdqm06-az48BLf5MVcoZVS0HdByoofi0\";}s:15:\"use_admin_theme\";b:1;}'),
('',	'node.type.article',	'a:12:{s:4:\"uuid\";s:36:\"23740c9e-4bc8-422a-a456-7efd997502e9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Fe3N1uqaAyyKJbVkqT-btXy3t98puW8GCRD822xjl10\";}s:4:\"name\";s:7:\"Article\";s:4:\"type\";s:7:\"article\";s:11:\"description\";s:89:\"Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.\";s:4:\"help\";N;s:12:\"new_revision\";b:1;s:12:\"preview_mode\";i:1;s:17:\"display_submitted\";b:1;}'),
('',	'node.type.page',	'a:12:{s:4:\"uuid\";s:36:\"1edca201-7650-4af0-af2a-47c5a971bfde\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"i0snV8Wj--OkRW12UdachUiYiz3FbeMwHu_pZYfzKLc\";}s:4:\"name\";s:10:\"Basic page\";s:4:\"type\";s:4:\"page\";s:11:\"description\";s:77:\"Use <em>basic pages</em> for your static content, such as an \'About us\' page.\";s:4:\"help\";N;s:12:\"new_revision\";b:1;s:12:\"preview_mode\";i:1;s:17:\"display_submitted\";b:0;}'),
('',	'olivero.settings',	'a:8:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"1TswGK46jyu77aIM7Z-0JVQs5bxHmo-gtgrvrQGMXxc\";}s:7:\"favicon\";a:1:{s:11:\"use_default\";b:1;}s:8:\"features\";a:4:{s:20:\"comment_user_picture\";b:1;s:25:\"comment_user_verification\";b:1;s:7:\"favicon\";b:1;s:17:\"node_user_picture\";b:0;}s:4:\"logo\";a:1:{s:11:\"use_default\";b:0;}s:20:\"third_party_settings\";a:1:{s:8:\"shortcut\";a:1:{s:11:\"module_link\";b:1;}}s:22:\"mobile_menu_all_widths\";i:0;s:22:\"site_branding_bg_color\";s:7:\"default\";s:18:\"base_primary_color\";s:7:\"#1b9ae4\";}'),
('',	'paragraphs.paragraphs_type.ebt_accordion',	'a:11:{s:4:\"uuid\";s:36:\"5071ad52-b6e8-4a13-88ad-a0e644e823f9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"a7oBJmAAPescdOPyZ2zkmnxQR_-MkKei1Cs600-7sxM\";}s:2:\"id\";s:13:\"ebt_accordion\";s:5:\"label\";s:35:\"EBT Accordion section / FAQ section\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:46:\"Accordion or FAQ section for EBT Accordion/FAQ\";s:16:\"behavior_plugins\";a:0:{}}'),
('',	'paragraphs.paragraphs_type.ebt_carousel',	'a:11:{s:4:\"uuid\";s:36:\"eae57e5f-f332-4203-be4f-1ead1a6c1ebf\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"F5G5bjObjmi_ofKoiKAxY1BXGoLKFMVsBTNd7Z39OuI\";}s:2:\"id\";s:12:\"ebt_carousel\";s:5:\"label\";s:17:\"EBT Carousel item\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:33:\"Carousel section for EBT Carousel\";s:16:\"behavior_plugins\";a:0:{}}'),
('',	'paragraphs.paragraphs_type.ebt_counter_item',	'a:11:{s:4:\"uuid\";s:36:\"8a0e0b99-a544-4c46-8cb3-534e418ac0e9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ycgzZPt9EhNziX0konZumLTJ6y69olJaVnLJ2dtyKnI\";}s:2:\"id\";s:16:\"ebt_counter_item\";s:5:\"label\";s:16:\"EBT Counter Item\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:60:\"Counter Items to be used inside of Block Type: \"EBT Counter\"\";s:16:\"behavior_plugins\";a:0:{}}'),
('',	'paragraphs.paragraphs_type.ebt_slick_slider',	'a:11:{s:4:\"uuid\";s:36:\"70607742-51bf-4b77-8d46-c07397b718e6\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7IpvZPMN9T939ox72-gNDYNrZIVrXQ7nlF-Pxkzq_7M\";}s:2:\"id\";s:16:\"ebt_slick_slider\";s:5:\"label\";s:15:\"EBT Slick Slide\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:26:\"Slide for EBT Slick Slider\";s:16:\"behavior_plugins\";a:0:{}}'),
('',	'paragraphs.paragraphs_type.ebt_slideshow',	'a:11:{s:4:\"uuid\";s:36:\"68f7444a-b28e-4ac9-abc5-57a62d63fe7f\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"HQnVagG9vsLrOtO1nF5ggZaNQ0tRGZZhiOW1-8nLOMM\";}s:2:\"id\";s:13:\"ebt_slideshow\";s:5:\"label\";s:9:\"EBT Slide\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:35:\"Slideshow section for EBT Slideshow\";s:16:\"behavior_plugins\";a:0:{}}'),
('',	'paragraphs.paragraphs_type.ebt_stats_item',	'a:11:{s:4:\"uuid\";s:36:\"210023af-0ce2-4183-bbba-6adbe094a405\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"mXP3gCAYTFLXux_oLacqKfa_b0MprpWFhqxO39VWGl8\";}s:2:\"id\";s:14:\"ebt_stats_item\";s:5:\"label\";s:14:\"EBT Stats Item\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:30:\"Stats Item for EBT Stats block\";s:16:\"behavior_plugins\";a:0:{}}'),
('',	'paragraphs.paragraphs_type.ebt_tab',	'a:11:{s:4:\"uuid\";s:36:\"d24c7342-50a5-4bba-a2ca-23838ec42c25\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nzTVRmvjb6HJiVMoRzf0HR02L3_n5N9VxatQ_IQQCmc\";}s:2:\"id\";s:7:\"ebt_tab\";s:5:\"label\";s:7:\"EBT Tab\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:32:\"Tab paragraph for EBT Tabs block\";s:16:\"behavior_plugins\";a:0:{}}'),
('',	'paragraphs.paragraphs_type.ebt_tiles_item',	'a:11:{s:4:\"uuid\";s:36:\"332e9a66-40d4-4d0f-a252-bacb76456f61\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"OXCYSO_8vGgFySd4voU9Be7Av6Oqe56G4XnMO_fX4EE\";}s:2:\"id\";s:14:\"ebt_tiles_item\";s:5:\"label\";s:14:\"EBT Tiles Item\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:21:\"Section for EBT Tiles\";s:16:\"behavior_plugins\";a:0:{}}'),
('',	'paragraphs.paragraphs_type.ebt_timeline',	'a:11:{s:4:\"uuid\";s:36:\"0700c7f4-0990-4033-a96a-7eac220fe625\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"giGGVKGIGi_PVlgEPMjzx78I9q-gtwP8qRWwp4goOaE\";}s:2:\"id\";s:12:\"ebt_timeline\";s:5:\"label\";s:18:\"EBT Timeline Event\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:33:\"Timeline section for EBT Timeline\";s:16:\"behavior_plugins\";a:0:{}}'),
('',	'paragraphs.paragraphs_type.ebt_video_and_image_gallery_item',	'a:11:{s:4:\"uuid\";s:36:\"69becd39-ca29-4229-a5e0-b50dda5e664e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ASm3yV1er7y-WJqAsPm4lUKhLJEK2A1QYjC-_eJJFIA\";}s:2:\"id\";s:32:\"ebt_video_and_image_gallery_item\";s:5:\"label\";s:32:\"EBT Video and Image gallery item\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:58:\"Video and Image item for EBT Video and Image Gallery block\";s:16:\"behavior_plugins\";a:0:{}}'),
('',	'paragraphs.settings',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7eR0sk71Eol86r_A7BMqn5_46wzenh5J1O5vZRCGKv8\";}s:16:\"show_unpublished\";b:1;}'),
('',	'pathauto.settings',	'a:13:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SwvLp8snyPEExF41CaJJYdPUVomofLqtXvwciHc4cPg\";}s:20:\"enabled_entity_types\";a:1:{i:0;s:4:\"user\";}s:11:\"punctuation\";a:1:{s:6:\"hyphen\";i:1;}s:7:\"verbose\";b:0;s:9:\"separator\";s:1:\"-\";s:10:\"max_length\";i:100;s:20:\"max_component_length\";i:100;s:13:\"transliterate\";b:1;s:12:\"reduce_ascii\";b:0;s:4:\"case\";b:1;s:12:\"ignore_words\";s:134:\"a, an, as, at, before, but, by, for, from, is, in, into, like, of, off, on, onto, per, since, than, the, this, that, to, up, via, with\";s:13:\"update_action\";i:2;s:11:\"safe_tokens\";a:6:{i:0;s:5:\"alias\";i:1;s:4:\"path\";i:2;s:9:\"join-path\";i:3;s:9:\"login-url\";i:4;s:3:\"url\";i:5;s:9:\"url-brief\";}}'),
('',	'redirect.settings',	'a:8:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"FEwQLW1wXW7fiJdG1B2bxW1c_-k6w-r-3V3bSsW6PqM\";}s:13:\"auto_redirect\";b:1;s:19:\"default_status_code\";i:301;s:23:\"passthrough_querystring\";b:1;s:7:\"warning\";b:0;s:17:\"ignore_admin_path\";b:0;s:12:\"access_check\";b:0;s:24:\"route_normalizer_enabled\";b:1;}'),
('',	'search.page.help_search',	'a:11:{s:4:\"uuid\";s:36:\"fec10881-499f-4858-a42b-9b60cee45abe\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"help\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"RZ-bcSekNSsAbIPLW7Gmyd3uUjIOSrPvnb8RCCZYJm8\";}s:2:\"id\";s:11:\"help_search\";s:5:\"label\";s:4:\"Help\";s:4:\"path\";s:4:\"help\";s:6:\"weight\";i:0;s:6:\"plugin\";s:11:\"help_search\";s:13:\"configuration\";a:0:{}}'),
('',	'search.page.node_search',	'a:11:{s:4:\"uuid\";s:36:\"72642a28-df7e-4618-aa8c-3f52bf7d9f97\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"97tvtzGOa8_flb22CzSjgtm_YkiGMHvEBO-6q2K9V_U\";}s:2:\"id\";s:11:\"node_search\";s:5:\"label\";s:7:\"Content\";s:4:\"path\";s:4:\"node\";s:6:\"weight\";i:-10;s:6:\"plugin\";s:11:\"node_search\";s:13:\"configuration\";a:1:{s:8:\"rankings\";a:0:{}}}'),
('',	'search.page.user_search',	'a:11:{s:4:\"uuid\";s:36:\"294f8603-9cb9-4c47-91cb-def8653638f4\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"k3aUaZXGDuhkek2TZIee0PApOPTvYZLadziekdyHA5A\";}s:2:\"id\";s:11:\"user_search\";s:5:\"label\";s:5:\"Users\";s:4:\"path\";s:4:\"user\";s:6:\"weight\";i:0;s:6:\"plugin\";s:11:\"user_search\";s:13:\"configuration\";a:0:{}}'),
('',	'search.settings',	'a:5:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"hvVxL1G-ZCxaq32IZws0YsfuhvaDiQE_np-0g35KjUk\";}s:12:\"and_or_limit\";i:7;s:12:\"default_page\";s:11:\"node_search\";s:5:\"index\";a:4:{s:10:\"cron_limit\";i:100;s:11:\"overlap_cjk\";b:1;s:17:\"minimum_word_size\";i:3;s:11:\"tag_weights\";a:12:{s:2:\"h1\";i:25;s:2:\"h2\";i:18;s:2:\"h3\";i:15;s:2:\"h4\";i:14;s:2:\"h5\";i:9;s:2:\"h6\";i:6;s:1:\"u\";i:3;s:1:\"b\";i:3;s:1:\"i\";i:3;s:6:\"strong\";i:3;s:2:\"em\";i:3;s:1:\"a\";i:10;}}s:7:\"logging\";b:0;}'),
('',	'shortcut.set.default',	'a:7:{s:4:\"uuid\";s:36:\"bc9830ea-c02f-4ef4-a17e-f3539c02304b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"U5VlGjd_SfV0Qm_EfnaynOfc549cNscFAx48JfYoMRI\";}s:2:\"id\";s:7:\"default\";s:5:\"label\";s:7:\"Default\";}'),
('',	'system.action.media_delete_action',	'a:10:{s:4:\"uuid\";s:36:\"62205804-910a-4719-bbcb-1c8ef9179e61\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"FrZy1tmuXJcOxhXlBoI1Hsnen5TT-9OCC1iolWH84go\";}s:2:\"id\";s:19:\"media_delete_action\";s:5:\"label\";s:12:\"Delete media\";s:4:\"type\";s:5:\"media\";s:6:\"plugin\";s:26:\"entity:delete_action:media\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.media_publish_action',	'a:10:{s:4:\"uuid\";s:36:\"74ae1caf-547b-4f5b-b2c5-344fbdfc9454\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nh83qNNrmWE-CDdHz2MdFOAk60T9mzv3R-MaKfZR2jw\";}s:2:\"id\";s:20:\"media_publish_action\";s:5:\"label\";s:13:\"Publish media\";s:4:\"type\";s:5:\"media\";s:6:\"plugin\";s:27:\"entity:publish_action:media\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.media_save_action',	'a:10:{s:4:\"uuid\";s:36:\"15843e3d-3327-4414-a048-e956e137183d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"VVyUA6PIaVeGtcIbgEWqJ6SYDiJdReBeojFswURFpKs\";}s:2:\"id\";s:17:\"media_save_action\";s:5:\"label\";s:10:\"Save media\";s:4:\"type\";s:5:\"media\";s:6:\"plugin\";s:24:\"entity:save_action:media\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.media_unpublish_action',	'a:10:{s:4:\"uuid\";s:36:\"9d24595c-700e-4798-9d98-3f086528cbd9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"media\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"CsK6TseQ2DatEbZgbd30swOlZ28_HHwAESU2LvEnWq0\";}s:2:\"id\";s:22:\"media_unpublish_action\";s:5:\"label\";s:15:\"Unpublish media\";s:4:\"type\";s:5:\"media\";s:6:\"plugin\";s:29:\"entity:unpublish_action:media\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.node_delete_action',	'a:10:{s:4:\"uuid\";s:36:\"8ff0ec2c-b155-4314-9b5d-65aef57e6ed9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"t43OqwzP3CTbcAagSsWKNy6KwMm_zShXo3c4-So6rQg\";}s:2:\"id\";s:18:\"node_delete_action\";s:5:\"label\";s:14:\"Delete content\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:25:\"entity:delete_action:node\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.node_make_sticky_action',	'a:10:{s:4:\"uuid\";s:36:\"d5b780e9-4002-48fb-9961-4890d2e18a4e\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sOb26JSy3fGpWkvR0WYN6_hMqj_6d1rvbvrkzp1yya0\";}s:2:\"id\";s:23:\"node_make_sticky_action\";s:5:\"label\";s:19:\"Make content sticky\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:23:\"node_make_sticky_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.node_make_unsticky_action',	'a:10:{s:4:\"uuid\";s:36:\"79cd458d-4e0f-42fc-8713-cf8324d4116c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"lDM9mvIGAu8Sw8rt-uCO4Sr7yX5VPrDPxYcawkbKd6k\";}s:2:\"id\";s:25:\"node_make_unsticky_action\";s:5:\"label\";s:21:\"Make content unsticky\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:25:\"node_make_unsticky_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.node_promote_action',	'a:10:{s:4:\"uuid\";s:36:\"80e483ef-5cef-449b-b6eb-338611cedfbf\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"N0RDBTqiK4dKoN4p4oW2j0SGWycdHyALUe9M-Ofp89U\";}s:2:\"id\";s:19:\"node_promote_action\";s:5:\"label\";s:29:\"Promote content to front page\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:19:\"node_promote_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.node_publish_action',	'a:10:{s:4:\"uuid\";s:36:\"638ab18d-e126-4bf0-934b-ca0f8e76d21a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2B9uF8NL5gutNKSdPRAhhAsDWFZZG1PJOBmx0aBGd_0\";}s:2:\"id\";s:19:\"node_publish_action\";s:5:\"label\";s:15:\"Publish content\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:26:\"entity:publish_action:node\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.node_save_action',	'a:10:{s:4:\"uuid\";s:36:\"e656d6be-7229-49e2-a65a-513fbe566776\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"LhdsoZPL_pFas2fjaAWue4zvrQ_tEVofLYtcNec-JGM\";}s:2:\"id\";s:16:\"node_save_action\";s:5:\"label\";s:12:\"Save content\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:23:\"entity:save_action:node\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.node_unpromote_action',	'a:10:{s:4:\"uuid\";s:36:\"1dc10e26-9e52-406f-aa64-78f6f7ff20b9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"JBptjnfuOMtsdKygklXxoOgeOCTMtQxlkymjnnj-cC0\";}s:2:\"id\";s:21:\"node_unpromote_action\";s:5:\"label\";s:30:\"Remove content from front page\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:21:\"node_unpromote_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.node_unpublish_action',	'a:10:{s:4:\"uuid\";s:36:\"12dedc3c-a189-49b8-bfa3-3925d1475a53\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"C7X8h9FWlwkQ9y5mnU2JzgaZICAdc6HFbPVbhvjlAYE\";}s:2:\"id\";s:21:\"node_unpublish_action\";s:5:\"label\";s:17:\"Unpublish content\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:28:\"entity:unpublish_action:node\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.pathauto_update_alias_node',	'a:10:{s:4:\"uuid\";s:36:\"49be4fb0-6832-463d-8bbe-69dd46552e18\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:8:\"pathauto\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"lno8QThS348UX-kaUsagJtCnuPHKLXYnTQiF_9HSDWA\";}s:2:\"id\";s:26:\"pathauto_update_alias_node\";s:5:\"label\";s:16:\"Update URL alias\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:21:\"pathauto_update_alias\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.pathauto_update_alias_user',	'a:10:{s:4:\"uuid\";s:36:\"acf6f444-fa28-4103-ae56-96da6d7abcc5\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:8:\"pathauto\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"x_ok_ZsfA4Xk4B_hVW3O4-3PcNoK57nXLz_Dlletidg\";}s:2:\"id\";s:26:\"pathauto_update_alias_user\";s:5:\"label\";s:16:\"Update URL alias\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:21:\"pathauto_update_alias\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.redirect_delete_action',	'a:10:{s:4:\"uuid\";s:36:\"8c900910-1bd8-48a7-abea-4493a2f89f45\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:8:\"redirect\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"redirect\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"vcnRZRvBqTbK3nZ2M4_lKPlEGc8GjPzgaqapYUfyX8M\";}s:2:\"id\";s:22:\"redirect_delete_action\";s:5:\"label\";s:15:\"Delete redirect\";s:4:\"type\";s:8:\"redirect\";s:6:\"plugin\";s:22:\"redirect_delete_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.taxonomy_term_publish_action',	'a:10:{s:4:\"uuid\";s:36:\"98441d8b-cb2a-44eb-863f-f500933dc072\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"taxonomy\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"DoVt_VGgVLcDD4XmVbSFzr0K17SJy9imFiYusKkJBgY\";}s:2:\"id\";s:28:\"taxonomy_term_publish_action\";s:5:\"label\";s:21:\"Publish taxonomy term\";s:4:\"type\";s:13:\"taxonomy_term\";s:6:\"plugin\";s:35:\"entity:publish_action:taxonomy_term\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.taxonomy_term_unpublish_action',	'a:10:{s:4:\"uuid\";s:36:\"c50e2e3d-3fd4-474f-b4c3-6e9deb3aa4ec\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"taxonomy\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"z2sNRM3ECa7FPCGnSNje_9SmZJQgwhD_6fG_L4Mr8zI\";}s:2:\"id\";s:30:\"taxonomy_term_unpublish_action\";s:5:\"label\";s:23:\"Unpublish taxonomy term\";s:4:\"type\";s:13:\"taxonomy_term\";s:6:\"plugin\";s:37:\"entity:unpublish_action:taxonomy_term\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.user_add_role_action.administrator',	'a:9:{s:4:\"uuid\";s:36:\"e9cdc7cd-560d-4c6e-b18d-4086edd12442\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:23:\"user.role.administrator\";}s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:2:\"id\";s:34:\"user_add_role_action.administrator\";s:5:\"label\";s:50:\"Add the Administrator role to the selected user(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:20:\"user_add_role_action\";s:13:\"configuration\";a:1:{s:3:\"rid\";s:13:\"administrator\";}}'),
('',	'system.action.user_block_user_action',	'a:10:{s:4:\"uuid\";s:36:\"e33d4c27-1cb5-4a82-a343-178013992c5b\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"DyypzTfThX10FFQw-399qPfEbLLyrhXgQrKPVsmAoJ4\";}s:2:\"id\";s:22:\"user_block_user_action\";s:5:\"label\";s:26:\"Block the selected user(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:22:\"user_block_user_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.user_cancel_user_action',	'a:10:{s:4:\"uuid\";s:36:\"47b35c2c-ef80-4dbb-9bc2-87e5467e802a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nvrL9bFilzBvm2bjO9rQnFDpBA7dBBUjShSSt6NS-DU\";}s:2:\"id\";s:23:\"user_cancel_user_action\";s:5:\"label\";s:35:\"Cancel the selected user account(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:23:\"user_cancel_user_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.user_remove_role_action.administrator',	'a:9:{s:4:\"uuid\";s:36:\"3a610953-8310-41e6-916e-67a38ded8605\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:23:\"user.role.administrator\";}s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:2:\"id\";s:37:\"user_remove_role_action.administrator\";s:5:\"label\";s:55:\"Remove the Administrator role from the selected user(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:23:\"user_remove_role_action\";s:13:\"configuration\";a:1:{s:3:\"rid\";s:13:\"administrator\";}}'),
('',	'system.action.user_unblock_user_action',	'a:10:{s:4:\"uuid\";s:36:\"f372b8db-b95d-43f7-8c2b-b99a92076084\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SPsUXsR3Rc8d1y3gewzaAKWa1ncea_ywXX3f7LTn7k0\";}s:2:\"id\";s:24:\"user_unblock_user_action\";s:5:\"label\";s:28:\"Unblock the selected user(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:24:\"user_unblock_user_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.webform_archive_action',	'a:10:{s:4:\"uuid\";s:36:\"6125548a-6827-4acb-a08b-eda4e1b25de1\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"OmnschvBLb9ZJn0iVyBd2odf8U8Nt0INjRbRMixZw9U\";}s:2:\"id\";s:22:\"webform_archive_action\";s:5:\"label\";s:15:\"Archive webform\";s:4:\"type\";s:7:\"webform\";s:6:\"plugin\";s:22:\"webform_archive_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.webform_close_action',	'a:10:{s:4:\"uuid\";s:36:\"9a449986-702c-4f26-a07f-3cbbae693dde\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Dl-1T9PDkraB7MyMUjTJAioPEx6UNvIB9gqmnB1CRkk\";}s:2:\"id\";s:20:\"webform_close_action\";s:5:\"label\";s:13:\"Close webform\";s:4:\"type\";s:7:\"webform\";s:6:\"plugin\";s:20:\"webform_close_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.webform_delete_action',	'a:10:{s:4:\"uuid\";s:36:\"d93c6987-507f-40ab-8f7a-1166f768bc12\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"e1bCTp0ryXZZtnS9nlVAbtoWz3-8fmbNlqKY3GHzbsM\";}s:2:\"id\";s:21:\"webform_delete_action\";s:5:\"label\";s:14:\"Delete webform\";s:4:\"type\";s:7:\"webform\";s:6:\"plugin\";s:21:\"webform_delete_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.webform_open_action',	'a:10:{s:4:\"uuid\";s:36:\"b9252337-7eb0-41ce-b704-8142809ba069\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"AK83C-dOZEPruvi6GbkuhihWLnO4VtrbesqSC6izf4o\";}s:2:\"id\";s:19:\"webform_open_action\";s:5:\"label\";s:12:\"Open webform\";s:4:\"type\";s:7:\"webform\";s:6:\"plugin\";s:19:\"webform_open_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.webform_submission_delete_action',	'a:10:{s:4:\"uuid\";s:36:\"9caf9021-aacc-4038-827b-c7fe7712e0ed\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"TBnl4vapW7sy5bRi7TcF-ueJnvz7aZNLif95ifvhfTQ\";}s:2:\"id\";s:32:\"webform_submission_delete_action\";s:5:\"label\";s:17:\"Delete submission\";s:4:\"type\";s:18:\"webform_submission\";s:6:\"plugin\";s:32:\"webform_submission_delete_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.webform_submission_make_lock_action',	'a:10:{s:4:\"uuid\";s:36:\"5e4d1084-e98f-408d-9529-89567e88b624\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"MKmZlPRk3OJKNcYdYxSeZGQUh7LMah6MRShfkzch4bk\";}s:2:\"id\";s:35:\"webform_submission_make_lock_action\";s:5:\"label\";s:15:\"Lock submission\";s:4:\"type\";s:18:\"webform_submission\";s:6:\"plugin\";s:35:\"webform_submission_make_lock_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.webform_submission_make_sticky_action',	'a:10:{s:4:\"uuid\";s:36:\"71eff68f-3ada-438a-93f8-5554a79cb737\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"mPWBT52fKHyINRl9S3cCWFxY3rKbwkIRxaK6sIA26oo\";}s:2:\"id\";s:37:\"webform_submission_make_sticky_action\";s:5:\"label\";s:20:\"Star/flag submission\";s:4:\"type\";s:18:\"webform_submission\";s:6:\"plugin\";s:37:\"webform_submission_make_sticky_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.webform_submission_make_unlock_action',	'a:10:{s:4:\"uuid\";s:36:\"f6b34ab3-4ded-41c8-8a32-ba4e032881fb\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"begZ0-RmTzO_zDAwEKA2lKvtGYw1vbFOzbQOJzUbZX0\";}s:2:\"id\";s:37:\"webform_submission_make_unlock_action\";s:5:\"label\";s:17:\"Unlock submission\";s:4:\"type\";s:18:\"webform_submission\";s:6:\"plugin\";s:37:\"webform_submission_make_unlock_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.webform_submission_make_unsticky_action',	'a:10:{s:4:\"uuid\";s:36:\"326c9843-f7a5-4f11-a105-e093bfdaae75\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"n4gTFiUsdp7gw6yWUlDbKFEasZLCgXWWCmm7eJejay0\";}s:2:\"id\";s:39:\"webform_submission_make_unsticky_action\";s:5:\"label\";s:24:\"Unstar/unflag submission\";s:4:\"type\";s:18:\"webform_submission\";s:6:\"plugin\";s:39:\"webform_submission_make_unsticky_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.action.webform_unarchive_action',	'a:10:{s:4:\"uuid\";s:36:\"30b42137-73bc-48ad-bd3d-7b1492d2645a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"aqi5Ftlnhe9KyOowpK7CanEvJMBBo8xAR1dA99bKOuc\";}s:2:\"id\";s:24:\"webform_unarchive_action\";s:5:\"label\";s:15:\"Restore webform\";s:4:\"type\";s:7:\"webform\";s:6:\"plugin\";s:24:\"webform_unarchive_action\";s:13:\"configuration\";a:0:{}}'),
('',	'system.advisories',	'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"x0FuQ_7Cg81mSDQwG028_Z0CjH3R9ib5IDlHeV2BbAo\";}s:7:\"enabled\";b:1;s:14:\"interval_hours\";i:6;}'),
('',	'system.cron',	'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"f3yToH8v8EaBZU0NFFw2qR8ogSCuWVmQaN0hpYR1BD8\";}s:9:\"threshold\";a:2:{s:20:\"requirements_warning\";i:172800;s:18:\"requirements_error\";i:1209600;}s:7:\"logging\";b:1;}'),
('',	'system.date',	'a:4:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"IVsFTD1mvR2NGBP_1myt9kFIFmGepH4PyaN5aQBYpno\";}s:9:\"first_day\";i:0;s:7:\"country\";a:1:{s:7:\"default\";N;}s:8:\"timezone\";a:2:{s:7:\"default\";s:15:\"Europe/Belgrade\";s:4:\"user\";a:3:{s:12:\"configurable\";b:1;s:7:\"default\";i:0;s:4:\"warn\";b:0;}}}'),
('',	'system.diff',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"1WanmaEhxW_vM8_5Ktsdntj8MaO9UBHXg0lN603PsWM\";}s:7:\"context\";a:2:{s:13:\"lines_leading\";i:2;s:14:\"lines_trailing\";i:2;}}'),
('',	'system.feature_flags',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ZYyVj1FtPGV40Cf65YDVTUIc7YgLH6trXlotuevfs2I\";}s:16:\"linkset_endpoint\";b:0;}'),
('',	'system.file',	'a:4:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"mguGHCYb9Dw5EcpfjwoShGV1Vjkbz3QuPRCLfxiye-g\";}s:22:\"allow_insecure_uploads\";b:0;s:14:\"default_scheme\";s:6:\"public\";s:21:\"temporary_maximum_age\";i:21600;}'),
('',	'system.image',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"durWHaKeBaq4d9Wpi4RqwADj1OufDepcnJuhVLmKN24\";}s:7:\"toolkit\";s:2:\"gd\";}'),
('',	'system.image.gd',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eNXaHfkJJUThHeF0nvkoXyPLRrKYGxgHRjORvT4F5rQ\";}s:12:\"jpeg_quality\";i:75;}'),
('',	'system.logging',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"u3-njszl92FaxjrCMiq0yDcjAfcdx72w1zT1O9dx6aA\";}s:11:\"error_level\";s:4:\"hide\";}'),
('',	'system.mail',	'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"5PvD9swkqWUeHkabdvbJ2SQqdhrzjkCT21wtD4BLfk4\";}s:9:\"interface\";a:2:{s:7:\"default\";s:8:\"php_mail\";s:7:\"webform\";s:16:\"webform_php_mail\";}s:10:\"mailer_dsn\";a:6:{s:6:\"scheme\";s:8:\"sendmail\";s:4:\"host\";s:7:\"default\";s:4:\"user\";N;s:8:\"password\";N;s:4:\"port\";N;s:7:\"options\";a:0:{}}}'),
('',	'system.maintenance',	'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"1SNdA25INsV5YjlgAJtfC-6AM8VcWe_00xneMLb2yFg\";}s:8:\"langcode\";s:2:\"en\";s:7:\"message\";s:93:\"@site is currently under maintenance. We should be back shortly. Thank you for your patience.\";}'),
('',	'system.menu.account',	'a:9:{s:4:\"uuid\";s:36:\"c0346b12-c5cd-40d6-886c-cf0888f426ac\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"M_Bh81osDyUQ4wV0GgU_NdBNqkzM87sLxjaCdFj9mnw\";}s:2:\"id\";s:7:\"account\";s:5:\"label\";s:17:\"User account menu\";s:11:\"description\";s:40:\"Links related to the active user account\";s:6:\"locked\";b:1;}'),
('',	'system.menu.admin',	'a:9:{s:4:\"uuid\";s:36:\"90616064-32be-41e1-baa8-be78784e75f1\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sapEi2YDGoI9yQIT_WgIV2vUdQ6DScH0V3fAyTadAL0\";}s:2:\"id\";s:5:\"admin\";s:5:\"label\";s:14:\"Administration\";s:11:\"description\";s:25:\"Administrative task links\";s:6:\"locked\";b:1;}'),
('',	'system.menu.footer',	'a:9:{s:4:\"uuid\";s:36:\"ba5622c9-4800-414f-8f65-c096cf34841d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7yrlW5z9zdg2eBucB2GPqXKSMQfH9lSRSO4DbWF7AFc\";}s:2:\"id\";s:6:\"footer\";s:5:\"label\";s:6:\"Footer\";s:11:\"description\";s:22:\"Site information links\";s:6:\"locked\";b:1;}'),
('',	'system.menu.main',	'a:9:{s:4:\"uuid\";s:36:\"7f6e64bf-0677-4eaf-82ae-a29df89f11b9\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Q2Ra3jfoIVk0f3SjxJX61byRQFVBAbpzYDQOiY-kno8\";}s:2:\"id\";s:4:\"main\";s:5:\"label\";s:15:\"Main navigation\";s:11:\"description\";s:18:\"Site section links\";s:6:\"locked\";b:1;}'),
('',	'system.menu.tools',	'a:9:{s:4:\"uuid\";s:36:\"a2a145f9-0c16-431e-975e-9af61b72ef36\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"BCM-vV1zzRaLHN18dqAR_CuGOj8AFJvTx7BKl_8Gcxc\";}s:2:\"id\";s:5:\"tools\";s:5:\"label\";s:5:\"Tools\";s:11:\"description\";s:39:\"User tool links, often added by modules\";s:6:\"locked\";b:1;}'),
('',	'system.performance',	'a:5:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jtno5biznHZbrIgKwzq-ze-7XaQxLCGe6PeUOR7bRiQ\";}s:5:\"cache\";a:1:{s:4:\"page\";a:1:{s:7:\"max_age\";i:0;}}s:3:\"css\";a:2:{s:10:\"preprocess\";b:1;s:4:\"gzip\";b:1;}s:8:\"fast_404\";a:4:{s:7:\"enabled\";b:1;s:5:\"paths\";s:69:\"/\\.(?:txt|png|gif|jpe?g|css|js|ico|swf|flv|cgi|bat|pl|dll|exe|asp)$/i\";s:13:\"exclude_paths\";s:27:\"/\\/(?:styles|imagecache)\\//\";s:4:\"html\";s:162:\"<!DOCTYPE html><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL \"@path\" was not found on this server.</p></body></html>\";}s:2:\"js\";a:2:{s:10:\"preprocess\";b:1;s:4:\"gzip\";b:1;}}'),
('',	'system.rss',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"MIpNzlG4gPunfS7vTCwUPum6QH3GUsEBMj-qS631Jw0\";}s:5:\"items\";a:1:{s:9:\"view_mode\";s:3:\"rss\";}}'),
('',	'system.site',	'a:11:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ijfbzDTN4CbE7Sr-6ubWzy_t1vH4OtU1doNCLssVz-4\";}s:8:\"langcode\";s:2:\"en\";s:4:\"uuid\";s:36:\"81f69bca-c1ec-48e0-bfde-2d9c7e27ddda\";s:4:\"name\";s:18:\"EBT Builder Source\";s:4:\"mail\";s:17:\"admin@example.com\";s:6:\"slogan\";s:0:\"\";s:4:\"page\";a:3:{i:403;s:0:\"\";i:404;s:0:\"\";s:5:\"front\";s:5:\"/node\";}s:18:\"admin_compact_mode\";b:0;s:17:\"weight_select_max\";i:100;s:16:\"default_langcode\";s:2:\"en\";s:17:\"mail_notification\";N;}'),
('',	'system.theme',	'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eJ529VM1gSIA_vgTy2PdiDvJuG0xhSxfQjCyl5WKlv4\";}s:5:\"admin\";s:5:\"claro\";s:7:\"default\";s:7:\"olivero\";}'),
('',	'system.theme.global',	'a:4:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KZiV2LB312xgJBphfq5BTjmp16xiR5KM8InBJ-pff7Y\";}s:7:\"favicon\";a:4:{s:8:\"mimetype\";s:24:\"image/vnd.microsoft.icon\";s:4:\"path\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"use_default\";b:1;}s:8:\"features\";a:4:{s:20:\"comment_user_picture\";b:1;s:25:\"comment_user_verification\";b:1;s:7:\"favicon\";b:1;s:17:\"node_user_picture\";b:1;}s:4:\"logo\";a:3:{s:4:\"path\";s:0:\"\";s:3:\"url\";N;s:11:\"use_default\";b:1;}}'),
('',	'taxonomy.settings',	'a:4:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"zKpaWT6cJc1tVQQaTqatGELaCqU_oyRym6zTl27Yias\";}s:20:\"maintain_index_table\";b:1;s:17:\"override_selector\";b:0;s:20:\"terms_per_page_admin\";i:100;}'),
('',	'taxonomy.vocabulary.tags',	'a:10:{s:4:\"uuid\";s:36:\"bae62ed0-d39a-4ca0-a737-86bf6ae374a6\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"iTEzwrEQ_4JIb-OYGiqzyF2TmMgWyWayresXcWgwGWM\";}s:4:\"name\";s:4:\"Tags\";s:3:\"vid\";s:4:\"tags\";s:11:\"description\";s:61:\"Use tags to group articles on similar topics into categories.\";s:6:\"weight\";i:0;s:12:\"new_revision\";b:0;}'),
('',	'text.settings',	'a:2:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Bkewb77RBOK3_aXMPsp8p87gbc03NvmC5gBLzPl7hVA\";}s:22:\"default_summary_length\";i:600;}'),
('',	'update.settings',	'a:4:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"xbYr66-g0FjNgVBkGypCuN46vBI2XHntXN1URawq1s4\";}s:5:\"check\";a:2:{s:19:\"disabled_extensions\";b:0;s:13:\"interval_days\";i:1;}s:5:\"fetch\";a:3:{s:3:\"url\";N;s:12:\"max_attempts\";i:2;s:7:\"timeout\";i:30;}s:12:\"notification\";a:2:{s:6:\"emails\";a:1:{i:0;s:17:\"admin@example.com\";}s:9:\"threshold\";s:3:\"all\";}}'),
('',	'user.flood',	'a:6:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"UYfMzeP1S8jKm9PSvxf7nQNe8DsNS-3bc2WSNNXBQWs\";}s:8:\"uid_only\";b:0;s:8:\"ip_limit\";i:50;s:9:\"ip_window\";i:3600;s:10:\"user_limit\";i:5;s:11:\"user_window\";i:21600;}'),
('',	'user.mail',	'a:11:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6CZIzFifRq3qbdq3n3nDpEOO4hWIQtKOAQNPvGNGKeM\";}s:8:\"langcode\";s:2:\"en\";s:14:\"cancel_confirm\";a:2:{s:7:\"subject\";s:67:\"Account cancellation request for [user:display-name] at [site:name]\";s:4:\"body\";s:376:\"[user:display-name]\n\nA request to cancel your account has been made at [site:name].\n\nYou may now cancel your account on [site:url-brief] by clicking this link or copying and pasting it into your browser:\n\n[user:cancel-url]\n\nNOTE: The cancellation of your account is not reversible.\n\nThis link expires in one day and nothing will happen if it is not used.\n\n--  [site:name] team\";}s:14:\"password_reset\";a:2:{s:7:\"subject\";s:68:\"Replacement login information for [user:display-name] at [site:name]\";s:4:\"body\";s:407:\"[user:display-name],\n\nA request to reset the password for your account has been made at [site:name].\n\nYou may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password. It expires after one day and nothing will happen if it\'s not used.\n\n--  [site:name] team\";}s:22:\"register_admin_created\";a:2:{s:7:\"subject\";s:58:\"An administrator created an account for you at [site:name]\";s:4:\"body\";s:473:\"[user:display-name],\n\nA site administrator at [site:name] has created an account for you. You may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:name]\npassword: Your password\n\n--  [site:name] team\";}s:29:\"register_no_approval_required\";a:2:{s:7:\"subject\";s:54:\"Account details for [user:display-name] at [site:name]\";s:4:\"body\";s:447:\"[user:display-name],\n\nThank you for registering at [site:name]. You may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:name]\npassword: Your password\n\n--  [site:name] team\";}s:25:\"register_pending_approval\";a:2:{s:7:\"subject\";s:79:\"Account details for [user:display-name] at [site:name] (pending admin approval)\";s:4:\"body\";s:288:\"[user:display-name],\n\nThank you for registering at [site:name]. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\n\n--  [site:name] team\";}s:31:\"register_pending_approval_admin\";a:2:{s:7:\"subject\";s:79:\"Account details for [user:display-name] at [site:name] (pending admin approval)\";s:4:\"body\";s:64:\"[user:display-name] has applied for an account.\n\n[user:edit-url]\";}s:16:\"status_activated\";a:2:{s:7:\"subject\";s:65:\"Account details for [user:display-name] at [site:name] (approved)\";s:4:\"body\";s:462:\"[user:display-name],\n\nYour account at [site:name] has been activated.\n\nYou may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:account-name]\npassword: Your password\n\n--  [site:name] team\";}s:14:\"status_blocked\";a:2:{s:7:\"subject\";s:64:\"Account details for [user:display-name] at [site:name] (blocked)\";s:4:\"body\";s:89:\"[user:display-name],\n\nYour account on [site:name] has been blocked.\n\n--  [site:name] team\";}s:15:\"status_canceled\";a:2:{s:7:\"subject\";s:65:\"Account details for [user:display-name] at [site:name] (canceled)\";s:4:\"body\";s:90:\"[user:display-name],\n\nYour account on [site:name] has been canceled.\n\n--  [site:name] team\";}}'),
('',	'user.role.administrator',	'a:10:{s:4:\"uuid\";s:36:\"55c650b9-b5a7-4ff4-bc0f-f89243b36175\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"OeKGIkmZA_c-t6QLH81WNQx8gDCc1MRmxaTuQgxBByU\";}s:2:\"id\";s:13:\"administrator\";s:5:\"label\";s:13:\"Administrator\";s:6:\"weight\";i:3;s:8:\"is_admin\";b:1;s:11:\"permissions\";a:0:{}}'),
('',	'user.role.anonymous',	'a:10:{s:4:\"uuid\";s:36:\"8ae6303e-51a9-461e-9cd1-3548f02fd2f7\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:29:\"filter.format.restricted_html\";}s:6:\"module\";a:5:{i:0;s:7:\"contact\";i:1;s:6:\"filter\";i:2;s:5:\"media\";i:3;s:6:\"search\";i:4;s:6:\"system\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6WavjUYXIegP9AAg2zXGx54MWIVoomC3SZhNiqe-Dyk\";}s:2:\"id\";s:9:\"anonymous\";s:5:\"label\";s:14:\"Anonymous user\";s:6:\"weight\";i:0;s:8:\"is_admin\";b:0;s:11:\"permissions\";a:5:{i:0;s:14:\"access content\";i:1;s:29:\"access site-wide contact form\";i:2;s:14:\"search content\";i:3;s:31:\"use text format restricted_html\";i:4;s:10:\"view media\";}}'),
('',	'user.role.authenticated',	'a:10:{s:4:\"uuid\";s:36:\"a817234d-3eaa-4c9f-a2ec-0f6cada70063\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:24:\"filter.format.basic_html\";i:1;s:29:\"filter.format.webform_default\";}s:6:\"module\";a:8:{i:0;s:7:\"contact\";i:1;s:4:\"file\";i:2;s:6:\"filter\";i:3;s:16:\"google_analytics\";i:4;s:5:\"media\";i:5;s:6:\"search\";i:6;s:8:\"shortcut\";i:7;s:6:\"system\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"cFrlqjtkTfvY3RGccjJkPf1SGIfJ942IrxTLWAO4mgA\";}s:2:\"id\";s:13:\"authenticated\";s:5:\"label\";s:18:\"Authenticated user\";s:6:\"weight\";i:1;s:8:\"is_admin\";b:0;s:11:\"permissions\";a:9:{i:0;s:14:\"access content\";i:1;s:16:\"access shortcuts\";i:2;s:29:\"access site-wide contact form\";i:3;s:16:\"delete own files\";i:4;s:42:\"opt-in or out of google analytics tracking\";i:5;s:14:\"search content\";i:6;s:26:\"use text format basic_html\";i:7;s:31:\"use text format webform_default\";i:8;s:10:\"view media\";}}'),
('',	'user.role.content_editor',	'a:10:{s:4:\"uuid\";s:36:\"d6e980dc-d5d4-42cf-8308-888d9c255fa0\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:17:\"node.type.article\";i:1;s:14:\"node.type.page\";i:2;s:24:\"taxonomy.vocabulary.tags\";}s:6:\"module\";a:7:{i:0;s:10:\"contextual\";i:1;s:4:\"file\";i:2;s:4:\"node\";i:3;s:4:\"path\";i:4;s:6:\"system\";i:5;s:8:\"taxonomy\";i:6;s:7:\"toolbar\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"e_wG1u7SrGaJbY2-Szgbgl-c8T3kdirU3uTNq2c_QJQ\";}s:2:\"id\";s:14:\"content_editor\";s:5:\"label\";s:14:\"Content editor\";s:6:\"weight\";i:2;s:8:\"is_admin\";b:0;s:11:\"permissions\";a:22:{i:0;s:27:\"access administration pages\";i:1;s:23:\"access content overview\";i:2;s:23:\"access contextual links\";i:3;s:21:\"access files overview\";i:4;s:14:\"access toolbar\";i:5;s:22:\"administer url aliases\";i:6;s:22:\"create article content\";i:7;s:19:\"create page content\";i:8;s:20:\"create terms in tags\";i:9;s:18:\"create url aliases\";i:10;s:24:\"delete article revisions\";i:11;s:26:\"delete own article content\";i:12;s:16:\"delete own files\";i:13;s:23:\"delete own page content\";i:14;s:21:\"delete page revisions\";i:15;s:24:\"edit own article content\";i:16;s:21:\"edit own page content\";i:17;s:18:\"edit terms in tags\";i:18;s:20:\"revert all revisions\";i:19;s:18:\"view all revisions\";i:20;s:28:\"view own unpublished content\";i:21;s:29:\"view the administration theme\";}}'),
('',	'user.settings',	'a:9:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"-htDFWUv1S4OlJMzta2nhFl4QbhJvu0D9xsJ-clxo-M\";}s:8:\"langcode\";s:2:\"en\";s:9:\"anonymous\";s:9:\"Anonymous\";s:11:\"verify_mail\";b:1;s:6:\"notify\";a:8:{s:14:\"cancel_confirm\";b:1;s:14:\"password_reset\";b:1;s:16:\"status_activated\";b:1;s:14:\"status_blocked\";b:0;s:15:\"status_canceled\";b:0;s:22:\"register_admin_created\";b:1;s:29:\"register_no_approval_required\";b:1;s:25:\"register_pending_approval\";b:1;}s:8:\"register\";s:23:\"visitors_admin_approval\";s:13:\"cancel_method\";s:17:\"user_cancel_block\";s:22:\"password_reset_timeout\";i:86400;s:17:\"password_strength\";b:1;}'),
('',	'views.settings',	'a:5:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"8oDr9oPVb_ostrNnVV6V7VdphwoH_u-NqTS0u7SE7qc\";}s:17:\"display_extenders\";a:0:{}s:13:\"sql_signature\";b:0;s:2:\"ui\";a:3:{s:4:\"show\";a:7:{s:18:\"additional_queries\";b:0;s:15:\"advanced_column\";b:0;s:15:\"default_display\";b:0;s:22:\"performance_statistics\";b:0;s:19:\"preview_information\";b:1;s:9:\"sql_query\";a:2:{s:7:\"enabled\";b:0;s:5:\"where\";s:5:\"above\";}s:13:\"display_embed\";b:0;}s:19:\"always_live_preview\";b:1;s:24:\"exposed_filter_any_label\";s:7:\"old_any\";}s:22:\"field_rewrite_elements\";a:29:{s:3:\"div\";s:3:\"DIV\";s:4:\"span\";s:4:\"SPAN\";s:2:\"h1\";s:2:\"H1\";s:2:\"h2\";s:2:\"H2\";s:2:\"h3\";s:2:\"H3\";s:2:\"h4\";s:2:\"H4\";s:2:\"h5\";s:2:\"H5\";s:2:\"h6\";s:2:\"H6\";s:1:\"p\";s:1:\"P\";s:6:\"header\";s:6:\"HEADER\";s:6:\"footer\";s:6:\"FOOTER\";s:7:\"article\";s:7:\"ARTICLE\";s:7:\"section\";s:7:\"SECTION\";s:5:\"aside\";s:5:\"ASIDE\";s:7:\"details\";s:7:\"DETAILS\";s:10:\"blockquote\";s:10:\"BLOCKQUOTE\";s:6:\"figure\";s:6:\"FIGURE\";s:7:\"address\";s:7:\"ADDRESS\";s:4:\"code\";s:4:\"CODE\";s:3:\"pre\";s:3:\"PRE\";s:3:\"var\";s:3:\"VAR\";s:4:\"samp\";s:4:\"SAMP\";s:3:\"kbd\";s:3:\"KBD\";s:6:\"strong\";s:6:\"STRONG\";s:2:\"em\";s:2:\"EM\";s:3:\"del\";s:3:\"DEL\";s:3:\"ins\";s:3:\"INS\";s:1:\"q\";s:1:\"Q\";s:1:\"s\";s:1:\"S\";}}'),
('',	'views.view.archive',	'a:13:{s:4:\"uuid\";s:36:\"869573d7-3210-47a6-a85b-2b4f70595558\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:0;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:33:\"core.entity_view_mode.node.teaser\";}s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"exIF08PTvYSK6tJCsAzBqMEKUBKIptPorMn74SVhevc\";}s:2:\"id\";s:7:\"archive\";s:5:\"label\";s:7:\"Archive\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:22:\"All content, by month.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:15:\"Monthly archive\";s:6:\"fields\";a:0:{}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:7:{s:6:\"offset\";i:0;s:24:\"pagination_heading_level\";s:2:\"h4\";s:14:\"items_per_page\";i:10;s:11:\"total_pages\";i:0;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:6:\"››\";s:8:\"previous\";s:6:\"‹‹\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:1:{s:18:\"created_year_month\";a:13:{s:2:\"id\";s:18:\"created_year_month\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:18:\"created_year_month\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:15:\"date_year_month\";s:14:\"default_action\";s:7:\"summary\";s:9:\"exception\";a:1:{s:12:\"title_enable\";b:1;}s:12:\"title_enable\";b:1;s:5:\"title\";s:34:\"{{ arguments.created_year_month }}\";s:21:\"default_argument_type\";s:5:\"fixed\";s:15:\"summary_options\";a:2:{s:8:\"override\";b:1;s:14:\"items_per_page\";i:30;}s:7:\"summary\";a:2:{s:10:\"sort_order\";s:4:\"desc\";s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:1;}}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:0;s:6:\"expose\";a:3:{s:8:\"operator\";s:1:\"0\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:31:\"***LANGUAGE_language_content***\";s:31:\"***LANGUAGE_language_content***\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:4:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:1:{s:9:\"view_mode\";s:6:\"teaser\";}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:5:\"Block\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:9:\"arguments\";a:1:{s:18:\"created_year_month\";a:13:{s:2:\"id\";s:18:\"created_year_month\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:18:\"created_year_month\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:15:\"date_year_month\";s:14:\"default_action\";s:7:\"summary\";s:9:\"exception\";a:1:{s:12:\"title_enable\";b:1;}s:12:\"title_enable\";b:1;s:5:\"title\";s:34:\"{{ arguments.created_year_month }}\";s:21:\"default_argument_type\";s:5:\"fixed\";s:15:\"summary_options\";a:1:{s:14:\"items_per_page\";i:30;}s:7:\"summary\";a:1:{s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:1;}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:8:\"defaults\";a:1:{s:9:\"arguments\";b:0;}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:2;s:15:\"display_options\";a:3:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:7:\"archive\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}'),
('',	'views.view.block_content',	'a:13:{s:4:\"uuid\";s:36:\"2b2425c7-ad13-4164-afc2-8d66592f2a30\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"HfvTcWhiVuvxchoh4DjIkXhKkj9ow2TGgHkLHSvRLq8\";}s:2:\"id\";s:13:\"block_content\";s:5:\"label\";s:14:\"Content blocks\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:31:\"Find and manage content blocks.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:24:\"block_content_field_data\";s:10:\"base_field\";s:2:\"id\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:14:\"Content blocks\";s:6:\"fields\";a:4:{s:4:\"info\";a:37:{s:2:\"id\";s:4:\"info\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:4:\"info\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";N;s:12:\"entity_field\";s:4:\"info\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:17:\"Block description\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"type\";a:37:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:13:\"block_content\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:10:\"Block type\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:0;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:7:\"changed\";a:26:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:13:\"block_content\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:7:\"Updated\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:5:{s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";s:7:\"tooltip\";a:2:{s:11:\"date_format\";s:4:\"long\";s:18:\"custom_date_format\";s:0:\"\";}s:9:\"time_diff\";a:5:{s:7:\"enabled\";b:0;s:13:\"future_format\";s:15:\"@interval hence\";s:11:\"past_format\";s:13:\"@interval ago\";s:11:\"granularity\";i:2;s:7:\"refresh\";i:60;}}}s:10:\"operations\";a:24:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:13:\"block_content\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:13:\"block_content\";s:9:\"plugin_id\";s:17:\"entity_operations\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:7:{s:6:\"offset\";i:0;s:24:\"pagination_heading_level\";s:2:\"h4\";s:14:\"items_per_page\";i:50;s:11:\"total_pages\";N;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:8:\"Next ›\";s:8:\"previous\";s:12:\"‹ Previous\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:1;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:20:\"access block library\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:2:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:38:\"There are no content blocks available.\";s:8:\"tokenize\";b:0;}s:27:\"block_content_listing_empty\";a:10:{s:2:\"id\";s:27:\"block_content_listing_empty\";s:5:\"table\";s:13:\"block_content\";s:5:\"field\";s:27:\"block_content_listing_empty\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:13:\"block_content\";s:9:\"plugin_id\";s:27:\"block_content_listing_empty\";s:5:\"label\";s:0:\"\";s:5:\"empty\";b:1;}}s:5:\"sorts\";a:0:{}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:3:{s:4:\"info\";a:16:{s:2:\"id\";s:4:\"info\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:4:\"info\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:13:\"block_content\";s:12:\"entity_field\";s:4:\"info\";s:9:\"plugin_id\";s:6:\"string\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:7:\"info_op\";s:5:\"label\";s:17:\"Block description\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"info_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"info\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:4:\"type\";a:16:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:13:\"block_content\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:7:\"type_op\";s:5:\"label\";s:10:\"Block type\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"type_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"type\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:8:\"reusable\";a:16:{s:2:\"id\";s:8:\"reusable\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:8:\"reusable\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:13:\"block_content\";s:12:\"entity_field\";s:8:\"reusable\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:4:{s:4:\"info\";s:4:\"info\";s:4:\"type\";s:4:\"type\";s:7:\"changed\";s:7:\"changed\";s:10:\"operations\";s:10:\"operations\";}s:7:\"default\";s:7:\"changed\";s:4:\"info\";a:4:{s:4:\"info\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"type\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"changed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:10:\"operations\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:1;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:3:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:19:\"admin/content/block\";s:4:\"menu\";a:7:{s:4:\"type\";s:3:\"tab\";s:5:\"title\";s:6:\"Blocks\";s:11:\"description\";s:31:\"Create and edit content blocks.\";s:6:\"weight\";i:0;s:9:\"menu_name\";s:5:\"admin\";s:6:\"parent\";s:20:\"system.admin_content\";s:7:\"context\";s:1:\"0\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}'),
('',	'views.view.content',	'a:13:{s:4:\"uuid\";s:36:\"53b483f4-38d1-4359-99b2-b24e9f23a505\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"whBYBAcXQuQblGEdvQ9QfGuuW3zC49F2-5vXSm1slFM\";}s:2:\"id\";s:7:\"content\";s:5:\"label\";s:7:\"Content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:24:\"Find and manage content.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:7:\"Content\";s:6:\"fields\";a:8:{s:14:\"node_bulk_form\";a:14:{s:2:\"id\";s:14:\"node_bulk_form\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:14:\"node_bulk_form\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:14:\"node_bulk_form\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:1:{s:10:\"alter_text\";b:0;}s:13:\"element_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:5:\"title\";a:17:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:5:\"Title\";s:7:\"exclude\";b:0;s:5:\"alter\";a:1:{s:10:\"alter_text\";b:0;}s:13:\"element_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}}s:4:\"type\";a:37:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:12:\"Content type\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:0;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"name\";a:17:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:3:\"uid\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Author\";s:7:\"exclude\";b:0;s:5:\"alter\";a:1:{s:10:\"alter_text\";b:0;}s:13:\"element_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}s:6:\"status\";a:17:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Status\";s:7:\"exclude\";b:0;s:5:\"alter\";a:1:{s:10:\"alter_text\";b:0;}s:13:\"element_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"custom\";s:19:\"format_custom_false\";s:11:\"Unpublished\";s:18:\"format_custom_true\";s:9:\"Published\";}}s:7:\"changed\";a:17:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"changed\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:7:\"Updated\";s:7:\"exclude\";b:0;s:5:\"alter\";a:1:{s:10:\"alter_text\";b:0;}s:13:\"element_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:5:{s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";s:7:\"tooltip\";a:2:{s:11:\"date_format\";s:4:\"long\";s:18:\"custom_date_format\";s:0:\"\";}s:9:\"time_diff\";a:5:{s:7:\"enabled\";b:0;s:13:\"future_format\";s:15:\"@interval hence\";s:11:\"past_format\";s:13:\"@interval ago\";s:11:\"granularity\";i:2;s:7:\"refresh\";i:60;}}}s:8:\"langcode\";a:37:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:8:\"Language\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:8:\"language\";s:8:\"settings\";a:2:{s:14:\"link_to_entity\";b:0;s:15:\"native_language\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:10:\"operations\";a:23:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:17:\"entity_operations\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:3:{s:24:\"pagination_heading_level\";s:2:\"h4\";s:14:\"items_per_page\";i:50;s:4:\"tags\";a:4:{s:4:\"next\";s:8:\"Next ›\";s:8:\"previous\";s:12:\"‹ Previous\";s:5:\"first\";s:8:\"« First\";s:4:\"last\";s:7:\"Last »\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:6:\"Filter\";s:12:\"reset_button\";b:1;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:23:\"access content overview\";}}s:5:\"cache\";a:1:{s:4:\"type\";s:3:\"tag\";}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:6:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:21:\"No content available.\";}}s:5:\"sorts\";a:0:{}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:5:{s:5:\"title\";a:16:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:6:\"string\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:8:\"title_op\";s:5:\"label\";s:5:\"Title\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:8:\"title_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:5:\"title\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:4:\"type\";a:16:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:7:\"type_op\";s:5:\"label\";s:12:\"Content type\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"type_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"type\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:6:\"Status\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"status_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"status\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:1;s:10:\"group_info\";a:10:{s:5:\"label\";s:16:\"Published status\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:6:\"status\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:2:{i:1;a:3:{s:5:\"title\";s:9:\"Published\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";}i:2;a:3:{s:5:\"title\";s:11:\"Unpublished\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}}}}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:11:\"langcode_op\";s:5:\"label\";s:8:\"Language\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"langcode_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:8:\"langcode\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:12:\"status_extra\";a:9:{s:2:\"id\";s:12:\"status_extra\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:12:\"status_extra\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:11:\"node_status\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";b:0;s:5:\"group\";i:1;s:6:\"expose\";a:2:{s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:10:{s:14:\"node_bulk_form\";s:14:\"node_bulk_form\";s:5:\"title\";s:5:\"title\";s:4:\"type\";s:4:\"type\";s:4:\"name\";s:4:\"name\";s:6:\"status\";s:6:\"status\";s:7:\"changed\";s:7:\"changed\";s:9:\"edit_node\";s:9:\"edit_node\";s:11:\"delete_node\";s:11:\"delete_node\";s:10:\"dropbutton\";s:10:\"dropbutton\";s:9:\"timestamp\";s:5:\"title\";}s:7:\"default\";s:7:\"changed\";s:4:\"info\";a:10:{s:14:\"node_bulk_form\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:5:\"title\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"type\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"name\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:6:\"status\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"changed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:9:\"edit_node\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:11:\"delete_node\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:10:\"dropbutton\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:9:\"timestamp\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:1;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:1;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:1:{s:4:\"type\";s:11:\"views_query\";}s:13:\"relationships\";a:1:{s:3:\"uid\";a:6:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:3:\"uid\";s:11:\"admin_label\";s:6:\"author\";s:9:\"plugin_id\";s:8:\"standard\";s:8:\"required\";b:1;}}s:16:\"show_admin_links\";b:0;s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:7:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";i:5;s:21:\"user.node_grants:view\";i:6;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:18:\"admin/content/node\";s:4:\"menu\";a:6:{s:4:\"type\";s:11:\"default tab\";s:5:\"title\";s:7:\"Content\";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:-10;s:9:\"menu_name\";s:5:\"admin\";s:7:\"context\";s:0:\"\";}s:11:\"tab_options\";a:5:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:7:\"Content\";s:11:\"description\";s:23:\"Find and manage content\";s:6:\"weight\";i:-10;s:9:\"menu_name\";s:5:\"admin\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:7:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";i:5;s:21:\"user.node_grants:view\";i:6;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}'),
('',	'views.view.content_recent',	'a:13:{s:4:\"uuid\";s:36:\"0aadfe89-23e4-4ec3-a50a-3c76c79be76a\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"YqZN5rc7XDQcFcInc8wkzuaHJmC5YvirhTmDcrarT6M\";}s:2:\"id\";s:14:\"content_recent\";s:5:\"label\";s:14:\"Recent content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:15:\"Recent content.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:22:{s:5:\"title\";s:14:\"Recent content\";s:6:\"fields\";a:2:{s:5:\"title\";a:26:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}}s:7:\"changed\";a:37:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:13:\"timestamp_ago\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:21:\"No content available.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:1:{s:7:\"changed\";a:13:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"changed\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:12:\"status_extra\";a:15:{s:2:\"id\";s:12:\"status_extra\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:12:\"status_extra\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:11:\"node_status\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";b:0;s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:31:\"***LANGUAGE_language_content***\";s:31:\"***LANGUAGE_language_content***\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:9:\"html_list\";s:7:\"options\";a:6:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:4:\"type\";s:2:\"ul\";s:13:\"wrapper_class\";s:9:\"item-list\";s:5:\"class\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:1:{s:3:\"uid\";a:10:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:6:\"author\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:3:\"uid\";s:9:\"plugin_id\";s:8:\"standard\";s:8:\"required\";b:1;}}s:8:\"use_more\";b:0;s:15:\"use_more_always\";b:0;s:13:\"use_more_text\";s:4:\"More\";s:12:\"link_display\";s:1:\"0\";s:8:\"link_url\";s:0:\"\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:4:\"user\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:5:\"Block\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:1:{s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:4:\"user\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}'),
('',	'views.view.files',	'a:13:{s:4:\"uuid\";s:36:\"534a8e69-2ee4-4c66-98d4-040cedf2dcd1\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"file\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"blP1XdpU4RqVoA_8po7qnIokIbHB6DJt0lpilgY5ovM\";}s:2:\"id\";s:5:\"files\";s:5:\"label\";s:5:\"Files\";s:6:\"module\";s:4:\"file\";s:11:\"description\";s:22:\"Find and manage files.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:12:\"file_managed\";s:10:\"base_field\";s:3:\"fid\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:19:{s:5:\"title\";s:5:\"Files\";s:6:\"fields\";a:9:{s:3:\"fid\";a:24:{s:2:\"id\";s:3:\"fid\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:3:\"fid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:3:\"fid\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:3:\"Fid\";s:7:\"exclude\";b:1;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:8:\"filename\";a:36:{s:2:\"id\";s:8:\"filename\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:8:\"filename\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:8:\"filename\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:4:\"Name\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"file_link\";s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:8:\"filemime\";a:25:{s:2:\"id\";s:8:\"filemime\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:8:\"filemime\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:8:\"filemime\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:9:\"MIME type\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:13:\"file_filemime\";}s:8:\"filesize\";a:25:{s:2:\"id\";s:8:\"filesize\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:8:\"filesize\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:8:\"filesize\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:4:\"Size\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"file_size\";}s:6:\"status\";a:26:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Status\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"custom\";s:19:\"format_custom_false\";s:9:\"Temporary\";s:18:\"format_custom_true\";s:9:\"Permanent\";}}s:7:\"created\";a:26:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:11:\"Upload date\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:5:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";s:7:\"tooltip\";a:2:{s:11:\"date_format\";s:4:\"long\";s:18:\"custom_date_format\";s:0:\"\";}s:9:\"time_diff\";a:5:{s:7:\"enabled\";b:0;s:13:\"future_format\";s:15:\"@interval hence\";s:11:\"past_format\";s:13:\"@interval ago\";s:11:\"granularity\";i:2;s:7:\"refresh\";i:60;}}}s:7:\"changed\";a:26:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:12:\"Changed date\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:5:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";s:7:\"tooltip\";a:2:{s:11:\"date_format\";s:4:\"long\";s:18:\"custom_date_format\";s:0:\"\";}s:9:\"time_diff\";a:5:{s:7:\"enabled\";b:0;s:13:\"future_format\";s:15:\"@interval hence\";s:11:\"past_format\";s:13:\"@interval ago\";s:11:\"granularity\";i:2;s:7:\"refresh\";i:60;}}}s:5:\"count\";a:30:{s:2:\"id\";s:5:\"count\";s:5:\"table\";s:10:\"file_usage\";s:5:\"field\";s:5:\"count\";s:12:\"relationship\";s:3:\"fid\";s:10:\"group_type\";s:3:\"sum\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:7:\"numeric\";s:5:\"label\";s:7:\"Used in\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:1;s:4:\"path\";s:35:\"admin/content/files/usage/{{ fid }}\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:13:\"set_precision\";b:0;s:9:\"precision\";i:0;s:7:\"decimal\";s:1:\".\";s:9:\"separator\";s:1:\",\";s:13:\"format_plural\";b:1;s:20:\"format_plural_string\";s:21:\"1 place@count places\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";}s:10:\"operations\";a:24:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:9:\"plugin_id\";s:17:\"entity_operations\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:7:{s:6:\"offset\";i:0;s:24:\"pagination_heading_level\";s:2:\"h4\";s:14:\"items_per_page\";i:50;s:11:\"total_pages\";i:0;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:8:\"Next ›\";s:8:\"previous\";s:12:\"‹ Previous\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:6:\"Filter\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:21:\"access files overview\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:6:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:19:\"No files available.\";}}s:5:\"sorts\";a:0:{}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:3:{s:8:\"filename\";a:16:{s:2:\"id\";s:8:\"filename\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:8:\"filename\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:8:\"filename\";s:9:\"plugin_id\";s:6:\"string\";s:8:\"operator\";s:4:\"word\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:11:\"filemime_op\";s:5:\"label\";s:8:\"Filename\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"filename_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:8:\"filename\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:8:\"filemime\";a:16:{s:2:\"id\";s:8:\"filemime\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:8:\"filemime\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:8:\"filemime\";s:9:\"plugin_id\";s:6:\"string\";s:8:\"operator\";s:4:\"word\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:11:\"filemime_op\";s:5:\"label\";s:9:\"MIME type\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"filemime_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:8:\"filemime\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:11:\"file_status\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:9:\"status_op\";s:5:\"label\";s:6:\"Status\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"status_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"status\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:8:{s:3:\"fid\";s:3:\"fid\";s:8:\"filename\";s:8:\"filename\";s:8:\"filemime\";s:8:\"filemime\";s:8:\"filesize\";s:8:\"filesize\";s:6:\"status\";s:6:\"status\";s:7:\"created\";s:7:\"created\";s:7:\"changed\";s:7:\"changed\";s:5:\"count\";s:5:\"count\";}s:7:\"default\";s:7:\"changed\";s:4:\"info\";a:8:{s:3:\"fid\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:8:\"filename\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:8:\"filemime\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}s:8:\"filesize\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:6:\"status\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"changed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:5:\"count\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:1;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:1:{s:3:\"fid\";a:7:{s:2:\"id\";s:3:\"fid\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:3:\"fid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:10:\"File usage\";s:8:\"required\";b:1;}}s:8:\"group_by\";b:1;s:16:\"show_admin_links\";b:1;s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:14:\"Files overview\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:6:{s:8:\"defaults\";a:2:{s:5:\"pager\";b:1;s:13:\"relationships\";b:0;}s:13:\"relationships\";a:1:{s:3:\"fid\";a:7:{s:2:\"id\";s:3:\"fid\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:3:\"fid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:10:\"File usage\";s:8:\"required\";b:0;}}s:19:\"display_description\";s:0:\"\";s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:19:\"admin/content/files\";s:4:\"menu\";a:6:{s:4:\"type\";s:3:\"tab\";s:5:\"title\";s:5:\"Files\";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:0;s:9:\"menu_name\";s:5:\"admin\";s:7:\"context\";s:0:\"\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_2\";a:6:{s:2:\"id\";s:6:\"page_2\";s:13:\"display_title\";s:10:\"File usage\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:2;s:15:\"display_options\";a:15:{s:5:\"title\";s:10:\"File usage\";s:6:\"fields\";a:4:{s:12:\"entity_label\";a:23:{s:2:\"id\";s:12:\"entity_label\";s:5:\"table\";s:10:\"file_usage\";s:5:\"field\";s:12:\"entity_label\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:12:\"entity_label\";s:5:\"label\";s:6:\"Entity\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:14:\"link_to_entity\";b:1;}s:4:\"type\";a:22:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:10:\"file_usage\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:8:\"standard\";s:5:\"label\";s:11:\"Entity type\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:6:\"module\";a:22:{s:2:\"id\";s:6:\"module\";s:5:\"table\";s:10:\"file_usage\";s:5:\"field\";s:6:\"module\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:8:\"standard\";s:5:\"label\";s:18:\"Registering module\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:5:\"count\";a:30:{s:2:\"id\";s:5:\"count\";s:5:\"table\";s:10:\"file_usage\";s:5:\"field\";s:5:\"count\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:7:\"numeric\";s:5:\"label\";s:9:\"Use count\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:13:\"set_precision\";b:0;s:9:\"precision\";i:0;s:7:\"decimal\";s:1:\".\";s:9:\"separator\";s:1:\",\";s:13:\"format_plural\";b:0;s:20:\"format_plural_string\";s:8:\"1@count\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:7:{s:6:\"offset\";i:0;s:24:\"pagination_heading_level\";s:2:\"h4\";s:14:\"items_per_page\";i:10;s:11:\"total_pages\";i:0;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:8:\"Next ›\";s:8:\"previous\";s:12:\"‹ Previous\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:5:\"empty\";a:0:{}s:9:\"arguments\";a:1:{s:3:\"fid\";a:22:{s:2:\"id\";s:3:\"fid\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:3:\"fid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:3:\"fid\";s:9:\"plugin_id\";s:8:\"file_fid\";s:14:\"default_action\";s:9:\"not found\";s:9:\"exception\";a:3:{s:5:\"value\";s:3:\"all\";s:12:\"title_enable\";b:0;s:5:\"title\";s:3:\"All\";}s:12:\"title_enable\";b:1;s:5:\"title\";s:46:\"File usage information for {{ arguments.fid }}\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:0:\"\";}s:15:\"summary_options\";a:4:{s:9:\"base_path\";s:0:\"\";s:5:\"count\";b:1;s:8:\"override\";b:0;s:14:\"items_per_page\";i:25;}s:7:\"summary\";a:3:{s:10:\"sort_order\";s:3:\"asc\";s:17:\"number_of_records\";i:0;s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:0;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:12:\"break_phrase\";b:0;s:3:\"not\";b:0;}}s:7:\"filters\";a:0:{}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:0:{}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:4:{s:12:\"entity_label\";s:12:\"entity_label\";s:4:\"type\";s:4:\"type\";s:6:\"module\";s:6:\"module\";s:5:\"count\";s:5:\"count\";}s:7:\"default\";s:12:\"entity_label\";s:4:\"info\";a:4:{s:12:\"entity_label\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"type\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}s:6:\"module\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:5:\"count\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:1;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:0:{}}s:8:\"defaults\";a:11:{s:5:\"empty\";b:0;s:5:\"title\";b:0;s:5:\"pager\";b:0;s:8:\"group_by\";b:0;s:5:\"style\";b:0;s:3:\"row\";b:0;s:13:\"relationships\";b:0;s:6:\"fields\";b:0;s:9:\"arguments\";b:0;s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;}s:13:\"relationships\";a:1:{s:3:\"fid\";a:7:{s:2:\"id\";s:3:\"fid\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:3:\"fid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:10:\"File usage\";s:8:\"required\";b:1;}}s:8:\"group_by\";b:0;s:19:\"display_description\";s:0:\"\";s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:27:\"admin/content/files/usage/%\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}'),
('',	'views.view.frontpage',	'a:13:{s:4:\"uuid\";s:36:\"697fbe61-72f2-4f36-9ef0-93f40a5476d1\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"core.entity_view_mode.node.rss\";i:1;s:33:\"core.entity_view_mode.node.teaser\";}s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"OEEnRQIjfIaCFRsz8U3VqDrE82ltQKlo8wNbQJRZXu0\";}s:2:\"id\";s:9:\"frontpage\";s:5:\"label\";s:9:\"Frontpage\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:39:\"All content promoted to the front page.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:0:\"\";s:6:\"fields\";a:0:{}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:8:{s:6:\"offset\";i:0;s:24:\"pagination_heading_level\";s:2:\"h4\";s:14:\"items_per_page\";i:10;s:11:\"total_pages\";i:0;s:2:\"id\";i:0;s:4:\"tags\";a:4:{s:4:\"next\";s:8:\"Next ›\";s:8:\"previous\";s:12:\"‹ Previous\";s:5:\"first\";s:8:\"« First\";s:4:\"last\";s:7:\"Last »\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:8:\"quantity\";i:9;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:3:{s:16:\"area_text_custom\";a:11:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"label\";s:0:\"\";s:5:\"empty\";b:1;s:7:\"content\";s:181:\"No front page content has been created yet.<br/>Follow the <a target=\"_blank\" href=\"https://www.drupal.org/docs/user_guide/en/index.html\">User Guide</a> to start building your site.\";s:8:\"tokenize\";b:0;}s:18:\"node_listing_empty\";a:10:{s:2:\"id\";s:18:\"node_listing_empty\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:18:\"node_listing_empty\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:18:\"node_listing_empty\";s:5:\"label\";s:0:\"\";s:5:\"empty\";b:1;}s:5:\"title\";a:10:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"title\";s:5:\"label\";s:0:\"\";s:5:\"empty\";b:1;s:5:\"title\";s:8:\"Welcome!\";}}s:5:\"sorts\";a:2:{s:6:\"sticky\";a:12:{s:2:\"id\";s:6:\"sticky\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"sticky\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"sticky\";s:9:\"plugin_id\";s:8:\"standard\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:6:\"sticky\";}s:7:\"exposed\";b:0;}s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:3:{s:7:\"promote\";a:16:{s:2:\"id\";s:7:\"promote\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"promote\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"promote\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:31:\"***LANGUAGE_language_content***\";s:31:\"***LANGUAGE_language_content***\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:4:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:1:{s:9:\"view_mode\";s:6:\"teaser\";}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:28:\"languages:language_interface\";i:1;s:14:\"url.query_args\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"feed_1\";a:6:{s:2:\"id\";s:6:\"feed_1\";s:13:\"display_title\";s:4:\"Feed\";s:14:\"display_plugin\";s:4:\"feed\";s:8:\"position\";i:2;s:15:\"display_options\";a:7:{s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;}}s:5:\"style\";a:2:{s:4:\"type\";s:3:\"rss\";s:7:\"options\";a:3:{s:8:\"grouping\";a:0:{}s:11:\"uses_fields\";b:0;s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:2:{s:4:\"type\";s:8:\"node_rss\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:3:\"rss\";}}s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:7:\"rss.xml\";s:14:\"sitename_title\";b:1;s:8:\"displays\";a:2:{s:6:\"page_1\";s:6:\"page_1\";s:7:\"default\";s:0:\"\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:28:\"languages:language_interface\";i:1;s:21:\"user.node_grants:view\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:2:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:4:\"node\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:28:\"languages:language_interface\";i:1;s:14:\"url.query_args\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}'),
('',	'views.view.glossary',	'a:13:{s:4:\"uuid\";s:36:\"4b34ee05-e652-40b7-8ec4-c522b22c6013\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:0;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:16:\"system.menu.main\";}s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"r-klgGeO4haVHqAwxW1HXZLzdzLSMUVC08OuTBrRh58\";}s:2:\"id\";s:8:\"glossary\";s:5:\"label\";s:8:\"Glossary\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:23:\"All content, by letter.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:6:\"fields\";a:3:{s:5:\"title\";a:24:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:5:\"Title\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:3:\"uid\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Author\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}s:7:\"changed\";a:26:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:11:\"Last update\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:5:{s:11:\"date_format\";s:4:\"long\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";s:7:\"tooltip\";a:2:{s:11:\"date_format\";s:4:\"long\";s:18:\"custom_date_format\";s:0:\"\";}s:9:\"time_diff\";a:5:{s:7:\"enabled\";b:0;s:13:\"future_format\";s:15:\"@interval hence\";s:11:\"past_format\";s:13:\"@interval ago\";s:11:\"granularity\";i:2;s:7:\"refresh\";i:60;}}}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:7:{s:6:\"offset\";i:0;s:24:\"pagination_heading_level\";s:2:\"h4\";s:14:\"items_per_page\";i:36;s:11:\"total_pages\";i:0;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:6:\"››\";s:8:\"previous\";s:6:\"‹‹\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:0:{}s:9:\"arguments\";a:1:{s:5:\"title\";a:26:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:6:\"string\";s:14:\"default_action\";s:7:\"default\";s:9:\"exception\";a:1:{s:12:\"title_enable\";b:1;}s:12:\"title_enable\";b:0;s:5:\"title\";s:0:\"\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:1:\"a\";}s:15:\"summary_options\";a:0:{}s:7:\"summary\";a:1:{s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:1;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:8:\"glossary\";b:1;s:5:\"limit\";i:1;s:4:\"case\";s:5:\"upper\";s:9:\"path_case\";s:5:\"lower\";s:14:\"transform_dash\";b:0;s:12:\"break_phrase\";b:0;}}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:31:\"***LANGUAGE_language_content***\";s:31:\"***LANGUAGE_language_content***\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;s:7:\"columns\";a:3:{s:5:\"title\";s:5:\"title\";s:4:\"name\";s:4:\"name\";s:7:\"changed\";s:7:\"changed\";}s:7:\"default\";s:5:\"title\";s:4:\"info\";a:3:{s:5:\"title\";a:2:{s:8:\"sortable\";b:1;s:9:\"separator\";s:0:\"\";}s:4:\"name\";a:2:{s:8:\"sortable\";b:1;s:9:\"separator\";s:0:\"\";}s:7:\"changed\";a:2:{s:8:\"sortable\";b:1;s:9:\"separator\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:5:\"order\";s:3:\"asc\";s:11:\"empty_table\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:22:\"default_field_elements\";b:1;s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:1:{s:3:\"uid\";a:8:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:6:\"author\";s:9:\"plugin_id\";s:8:\"standard\";s:8:\"required\";b:0;}}s:8:\"use_ajax\";b:1;s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:21:\"user.node_grants:view\";i:5;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:12:\"attachment_1\";a:6:{s:2:\"id\";s:12:\"attachment_1\";s:13:\"display_title\";s:10:\"Attachment\";s:14:\"display_plugin\";s:10:\"attachment\";s:8:\"position\";i:2;s:15:\"display_options\";a:7:{s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:0;}}s:9:\"arguments\";a:1:{s:5:\"title\";a:26:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:6:\"string\";s:14:\"default_action\";s:7:\"summary\";s:9:\"exception\";a:1:{s:12:\"title_enable\";b:1;}s:12:\"title_enable\";b:0;s:5:\"title\";s:0:\"\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:1:\"a\";}s:15:\"summary_options\";a:3:{s:14:\"items_per_page\";i:25;s:6:\"inline\";b:1;s:9:\"separator\";s:3:\" | \";}s:7:\"summary\";a:1:{s:6:\"format\";s:19:\"unformatted_summary\";}s:18:\"specify_validation\";b:1;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:8:\"glossary\";b:1;s:5:\"limit\";i:1;s:4:\"case\";s:5:\"upper\";s:9:\"path_case\";s:5:\"lower\";s:14:\"transform_dash\";b:0;s:12:\"break_phrase\";b:0;}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:8:\"defaults\";a:1:{s:9:\"arguments\";b:0;}s:17:\"display_extenders\";a:0:{}s:8:\"displays\";a:2:{s:7:\"default\";s:7:\"default\";s:6:\"page_1\";s:6:\"page_1\";}s:17:\"inherit_arguments\";b:0;}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:21:\"user.node_grants:view\";i:5;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:8:\"glossary\";s:4:\"menu\";a:5:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:8:\"Glossary\";s:6:\"weight\";i:0;s:9:\"menu_name\";s:4:\"main\";s:6:\"parent\";s:0:\"\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:21:\"user.node_grants:view\";i:5;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}'),
('',	'views.view.media',	'a:13:{s:4:\"uuid\";s:36:\"36a349da-87e8-43e4-89c5-350096634510\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:21:\"image.style.thumbnail\";}s:6:\"module\";a:3:{i:0;s:5:\"image\";i:1;s:5:\"media\";i:2;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"kOTUk5XWeupgBOJuRRarCiDcFKVZcvaW-FT5MTzrML8\";}s:2:\"id\";s:5:\"media\";s:5:\"label\";s:5:\"Media\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:22:\"Find and manage media.\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:16:\"media_field_data\";s:10:\"base_field\";s:3:\"mid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:5:\"Media\";s:6:\"fields\";a:8:{s:15:\"media_bulk_form\";a:26:{s:2:\"id\";s:15:\"media_bulk_form\";s:5:\"table\";s:5:\"media\";s:5:\"field\";s:15:\"media_bulk_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:9:\"plugin_id\";s:9:\"bulk_form\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"action_title\";s:6:\"Action\";s:15:\"include_exclude\";s:7:\"exclude\";s:16:\"selected_actions\";a:0:{}}s:20:\"thumbnail__target_id\";a:37:{s:2:\"id\";s:20:\"thumbnail__target_id\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:20:\"thumbnail__target_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:9:\"thumbnail\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:9:\"Thumbnail\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:9:\"thumbnail\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:12:\"group_column\";s:0:\"\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"name\";a:37:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:5:\"media\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:10:\"Media name\";s:7:\"exclude\";b:0;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:6:\"bundle\";a:37:{s:2:\"id\";s:6:\"bundle\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:6:\"bundle\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:6:\"bundle\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:4:\"Type\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:0;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:3:\"uid\";a:37:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:3:\"uid\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Author\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:1;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:6:\"status\";a:37:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Status\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"custom\";s:19:\"format_custom_false\";s:11:\"Unpublished\";s:18:\"format_custom_true\";s:9:\"Published\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:7:\"changed\";a:37:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:7:\"Updated\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:5:{s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";s:7:\"tooltip\";a:2:{s:11:\"date_format\";s:4:\"long\";s:18:\"custom_date_format\";s:0:\"\";}s:9:\"time_diff\";a:5:{s:7:\"enabled\";b:0;s:13:\"future_format\";s:15:\"@interval hence\";s:11:\"past_format\";s:13:\"@interval ago\";s:11:\"granularity\";i:2;s:7:\"refresh\";i:60;}}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:10:\"operations\";a:24:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:5:\"media\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:9:\"plugin_id\";s:17:\"entity_operations\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:8:{s:6:\"offset\";i:0;s:24:\"pagination_heading_level\";s:2:\"h4\";s:14:\"items_per_page\";i:50;s:11:\"total_pages\";N;s:2:\"id\";i:0;s:4:\"tags\";a:4:{s:4:\"next\";s:8:\"Next ›\";s:8:\"previous\";s:12:\"‹ Previous\";s:5:\"first\";s:8:\"« First\";s:4:\"last\";s:7:\"Last »\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:8:\"quantity\";i:9;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:6:\"Filter\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:21:\"access media overview\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:19:\"No media available.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:5:{s:4:\"name\";a:16:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:6:\"string\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:7:\"name_op\";s:5:\"label\";s:10:\"Media name\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"name_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"name\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"bundle\";a:16:{s:2:\"id\";s:6:\"bundle\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:6:\"bundle\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:6:\"bundle\";s:9:\"plugin_id\";s:6:\"bundle\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:9:\"bundle_op\";s:5:\"label\";s:4:\"Type\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"bundle_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"type\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:4:\"True\";s:11:\"description\";N;s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"status_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"status\";s:8:\"required\";b:1;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:1;s:10:\"group_info\";a:10:{s:5:\"label\";s:16:\"Published status\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:6:\"status\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:2:{i:1;a:3:{s:5:\"title\";s:9:\"Published\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";}i:2;a:3:{s:5:\"title\";s:11:\"Unpublished\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}}}}s:12:\"status_extra\";a:15:{s:2:\"id\";s:12:\"status_extra\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:12:\"status_extra\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:9:\"plugin_id\";s:12:\"media_status\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:11:\"langcode_op\";s:5:\"label\";s:8:\"Language\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"langcode_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:8:\"langcode\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:6:{s:4:\"name\";s:4:\"name\";s:6:\"bundle\";s:6:\"bundle\";s:7:\"changed\";s:7:\"changed\";s:3:\"uid\";s:3:\"uid\";s:6:\"status\";s:6:\"status\";s:20:\"thumbnail__target_id\";s:20:\"thumbnail__target_id\";}s:7:\"default\";s:7:\"changed\";s:4:\"info\";a:6:{s:4:\"name\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"bundle\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"changed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:3:\"uid\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"status\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:20:\"thumbnail__target_id\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:1;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";i:5;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:15:\"media_page_list\";a:6:{s:2:\"id\";s:15:\"media_page_list\";s:13:\"display_title\";s:5:\"Media\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:19:\"display_description\";s:0:\"\";s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:19:\"admin/content/media\";s:4:\"menu\";a:8:{s:4:\"type\";s:3:\"tab\";s:5:\"title\";s:5:\"Media\";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:0;s:8:\"expanded\";b:0;s:9:\"menu_name\";s:4:\"main\";s:6:\"parent\";s:0:\"\";s:7:\"context\";s:1:\"0\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";i:5;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}'),
('',	'views.view.media_library',	'a:13:{s:4:\"uuid\";s:36:\"bc9a8070-9681-4b94-8d52-549af33d0dbe\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:2:{i:0;s:41:\"core.entity_view_mode.media.media_library\";i:1;s:25:\"image.style.media_library\";}s:6:\"module\";a:4:{i:0;s:5:\"image\";i:1;s:5:\"media\";i:2;s:13:\"media_library\";i:3;s:4:\"user\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:13:\"media_library\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"9u9hwW-Q0-uQJz1vgenJTQhZGYN0FBZoOogwPD6kgkQ\";}s:2:\"id\";s:13:\"media_library\";s:5:\"label\";s:13:\"Media library\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:22:\"Find and manage media.\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:16:\"media_field_data\";s:10:\"base_field\";s:3:\"mid\";s:7:\"display\";a:4:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:18:{s:5:\"title\";s:5:\"Media\";s:6:\"fields\";a:2:{s:15:\"media_bulk_form\";a:26:{s:2:\"id\";s:15:\"media_bulk_form\";s:5:\"table\";s:5:\"media\";s:5:\"field\";s:15:\"media_bulk_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:9:\"plugin_id\";s:9:\"bulk_form\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"action_title\";s:6:\"Action\";s:15:\"include_exclude\";s:7:\"exclude\";s:16:\"selected_actions\";a:0:{}}s:15:\"rendered_entity\";a:24:{s:2:\"id\";s:15:\"rendered_entity\";s:5:\"table\";s:5:\"media\";s:5:\"field\";s:15:\"rendered_entity\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:9:\"plugin_id\";s:15:\"rendered_entity\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:9:\"view_mode\";s:13:\"media_library\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:7:{s:6:\"offset\";i:0;s:24:\"pagination_heading_level\";s:2:\"h4\";s:14:\"items_per_page\";i:24;s:11:\"total_pages\";N;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:6:\"››\";s:8:\"previous\";s:6:\"‹‹\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"6, 12, 24, 48\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:13:\"Apply filters\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:0;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:21:\"access media overview\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:19:\"No media available.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:3:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:12:\"Newest first\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:1;s:11:\"granularity\";s:6:\"second\";}s:4:\"name\";a:12:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:8:\"standard\";s:5:\"order\";s:3:\"ASC\";s:6:\"expose\";a:2:{s:5:\"label\";s:10:\"Name (A-Z)\";s:16:\"field_identifier\";s:4:\"name\";}s:7:\"exposed\";b:1;}s:6:\"name_1\";a:12:{s:2:\"id\";s:6:\"name_1\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:8:\"standard\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:10:\"Name (Z-A)\";s:16:\"field_identifier\";s:6:\"name_1\";}s:7:\"exposed\";b:1;}}s:7:\"filters\";a:5:{s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:17:\"Publishing status\";s:11:\"description\";N;s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"status_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"status\";s:8:\"required\";b:1;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:1;s:10:\"group_info\";a:10:{s:5:\"label\";s:9:\"Published\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:6:\"status\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:2:{i:1;a:3:{s:5:\"title\";s:9:\"Published\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";}i:2;a:3:{s:5:\"title\";s:11:\"Unpublished\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}}}}s:4:\"name\";a:16:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:6:\"string\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:7:\"name_op\";s:5:\"label\";s:4:\"Name\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"name_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"name\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"bundle\";a:16:{s:2:\"id\";s:6:\"bundle\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:6:\"bundle\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:6:\"bundle\";s:9:\"plugin_id\";s:6:\"bundle\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:9:\"bundle_op\";s:5:\"label\";s:10:\"Media type\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"bundle_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"type\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:10:\"Media type\";s:11:\"description\";N;s:10:\"identifier\";s:6:\"bundle\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:3:{i:1;a:0:{}i:2;a:0:{}i:3;a:0:{}}}}s:12:\"status_extra\";a:15:{s:2:\"id\";s:12:\"status_extra\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:12:\"status_extra\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:9:\"plugin_id\";s:12:\"media_status\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:11:\"langcode_op\";s:5:\"label\";s:8:\"Language\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"langcode_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:8:\"langcode\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:3:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:22:\"default_field_elements\";b:1;s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:9:\"css_class\";s:0:\"\";s:8:\"use_ajax\";b:1;s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:6:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:22:\"url.query_args:sort_by\";i:4;s:4:\"user\";i:5;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:4:\"page\";a:6:{s:2:\"id\";s:4:\"page\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:6:\"fields\";a:5:{s:15:\"media_bulk_form\";a:26:{s:2:\"id\";s:15:\"media_bulk_form\";s:5:\"table\";s:5:\"media\";s:5:\"field\";s:15:\"media_bulk_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:9:\"plugin_id\";s:9:\"bulk_form\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"action_title\";s:6:\"Action\";s:15:\"include_exclude\";s:7:\"exclude\";s:16:\"selected_actions\";a:0:{}}s:4:\"name\";a:37:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:10:\"edit_media\";a:26:{s:2:\"id\";s:10:\"edit_media\";s:5:\"table\";s:5:\"media\";s:5:\"field\";s:10:\"edit_media\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:9:\"plugin_id\";s:16:\"entity_link_edit\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:15:\"Edit {{ name }}\";s:9:\"make_link\";b:1;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:15:\"Edit {{ name }}\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:1:\"0\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:0;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:4:\"Edit\";s:18:\"output_url_as_text\";b:0;s:8:\"absolute\";b:0;}s:12:\"delete_media\";a:26:{s:2:\"id\";s:12:\"delete_media\";s:5:\"table\";s:5:\"media\";s:5:\"field\";s:12:\"delete_media\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:9:\"plugin_id\";s:18:\"entity_link_delete\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:17:\"Delete {{ name }}\";s:9:\"make_link\";b:1;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:17:\"Delete {{ name }}\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:1:\"0\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:0;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:6:\"Delete\";s:18:\"output_url_as_text\";b:0;s:8:\"absolute\";b:0;}s:15:\"rendered_entity\";a:24:{s:2:\"id\";s:15:\"rendered_entity\";s:5:\"table\";s:5:\"media\";s:5:\"field\";s:15:\"rendered_entity\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:9:\"plugin_id\";s:15:\"rendered_entity\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:9:\"view_mode\";s:13:\"media_library\";}}s:8:\"defaults\";a:1:{s:6:\"fields\";b:0;}s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:24:\"admin/content/media-grid\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:7:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:22:\"url.query_args:sort_by\";i:5;s:4:\"user\";i:6;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"widget\";a:6:{s:2:\"id\";s:6:\"widget\";s:13:\"display_title\";s:6:\"Widget\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:2;s:15:\"display_options\";a:12:{s:6:\"fields\";a:2:{s:25:\"media_library_select_form\";a:23:{s:2:\"id\";s:25:\"media_library_select_form\";s:5:\"table\";s:5:\"media\";s:5:\"field\";s:25:\"media_library_select_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:9:\"plugin_id\";s:25:\"media_library_select_form\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:15:\"rendered_entity\";a:24:{s:2:\"id\";s:15:\"rendered_entity\";s:5:\"table\";s:5:\"media\";s:5:\"field\";s:15:\"rendered_entity\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:9:\"plugin_id\";s:15:\"rendered_entity\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:9:\"view_mode\";s:13:\"media_library\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:10:\"view media\";}}s:9:\"arguments\";a:1:{s:6:\"bundle\";a:26:{s:2:\"id\";s:6:\"bundle\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:6:\"bundle\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:6:\"bundle\";s:9:\"plugin_id\";s:6:\"string\";s:14:\"default_action\";s:6:\"ignore\";s:9:\"exception\";a:3:{s:5:\"value\";s:3:\"all\";s:12:\"title_enable\";b:0;s:5:\"title\";s:3:\"All\";}s:12:\"title_enable\";b:0;s:5:\"title\";s:0:\"\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:0:\"\";}s:15:\"summary_options\";a:4:{s:9:\"base_path\";s:0:\"\";s:5:\"count\";b:1;s:8:\"override\";b:0;s:14:\"items_per_page\";i:24;}s:7:\"summary\";a:3:{s:10:\"sort_order\";s:3:\"asc\";s:17:\"number_of_records\";i:0;s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:0;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:8:\"glossary\";b:0;s:5:\"limit\";i:0;s:4:\"case\";s:4:\"none\";s:9:\"path_case\";s:4:\"none\";s:14:\"transform_dash\";b:0;s:12:\"break_phrase\";b:0;}}s:7:\"filters\";a:3:{s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:4:\"name\";a:16:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:6:\"string\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:7:\"name_op\";s:5:\"label\";s:4:\"Name\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"name_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"name\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:16:\"default_langcode\";a:16:{s:2:\"id\";s:16:\"default_langcode\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:16:\"default_langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:16:\"default_langcode\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:8:\"defaults\";a:7:{s:6:\"access\";b:0;s:9:\"css_class\";b:0;s:6:\"fields\";b:0;s:9:\"arguments\";b:0;s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;s:6:\"header\";b:0;}s:9:\"css_class\";s:0:\"\";s:19:\"display_description\";s:0:\"\";s:6:\"header\";a:2:{s:17:\"display_link_grid\";a:7:{s:2:\"id\";s:17:\"display_link_grid\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:12:\"display_link\";s:9:\"plugin_id\";s:12:\"display_link\";s:5:\"label\";s:4:\"Grid\";s:5:\"empty\";b:1;s:10:\"display_id\";s:6:\"widget\";}s:18:\"display_link_table\";a:7:{s:2:\"id\";s:18:\"display_link_table\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:12:\"display_link\";s:9:\"plugin_id\";s:12:\"display_link\";s:5:\"label\";s:5:\"Table\";s:5:\"empty\";b:1;s:10:\"display_id\";s:12:\"widget_table\";}}s:18:\"rendering_language\";s:33:\"***LANGUAGE_language_interface***\";s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:26:\"admin/content/media-widget\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:22:\"url.query_args:sort_by\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:12:\"widget_table\";a:6:{s:2:\"id\";s:12:\"widget_table\";s:13:\"display_title\";s:14:\"Widget (table)\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:3;s:15:\"display_options\";a:13:{s:6:\"fields\";a:5:{s:25:\"media_library_select_form\";a:9:{s:2:\"id\";s:25:\"media_library_select_form\";s:5:\"table\";s:5:\"media\";s:5:\"field\";s:25:\"media_library_select_form\";s:12:\"relationship\";s:4:\"none\";s:11:\"entity_type\";s:5:\"media\";s:9:\"plugin_id\";s:25:\"media_library_select_form\";s:5:\"label\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";}s:20:\"thumbnail__target_id\";a:10:{s:2:\"id\";s:20:\"thumbnail__target_id\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:20:\"thumbnail__target_id\";s:12:\"relationship\";s:4:\"none\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:9:\"thumbnail\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:9:\"Thumbnail\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:13:\"media_library\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:5:\"eager\";}}}s:4:\"name\";a:10:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:4:\"Name\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}}s:3:\"uid\";a:10:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:20:\"media_field_revision\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:3:\"uid\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Author\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:1;}}s:7:\"changed\";a:10:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:7:\"Updated\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:5:{s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";s:7:\"tooltip\";a:2:{s:11:\"date_format\";s:4:\"long\";s:18:\"custom_date_format\";s:0:\"\";}s:9:\"time_diff\";a:5:{s:7:\"enabled\";b:0;s:13:\"future_format\";s:15:\"@interval hence\";s:11:\"past_format\";s:13:\"@interval ago\";s:11:\"granularity\";i:2;s:7:\"refresh\";i:60;}}}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:10:\"view media\";}}s:9:\"arguments\";a:1:{s:6:\"bundle\";a:26:{s:2:\"id\";s:6:\"bundle\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:6:\"bundle\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:6:\"bundle\";s:9:\"plugin_id\";s:6:\"string\";s:14:\"default_action\";s:6:\"ignore\";s:9:\"exception\";a:3:{s:5:\"value\";s:3:\"all\";s:12:\"title_enable\";b:0;s:5:\"title\";s:3:\"All\";}s:12:\"title_enable\";b:0;s:5:\"title\";s:0:\"\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:0:\"\";}s:15:\"summary_options\";a:4:{s:9:\"base_path\";s:0:\"\";s:5:\"count\";b:1;s:8:\"override\";b:0;s:14:\"items_per_page\";i:24;}s:7:\"summary\";a:3:{s:10:\"sort_order\";s:3:\"asc\";s:17:\"number_of_records\";i:0;s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:0;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:8:\"glossary\";b:0;s:5:\"limit\";i:0;s:4:\"case\";s:4:\"none\";s:9:\"path_case\";s:4:\"none\";s:14:\"transform_dash\";b:0;s:12:\"break_phrase\";b:0;}}s:7:\"filters\";a:3:{s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:4:\"name\";a:16:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:6:\"string\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:7:\"name_op\";s:5:\"label\";s:4:\"Name\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"name_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"name\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:16:\"default_langcode\";a:16:{s:2:\"id\";s:16:\"default_langcode\";s:5:\"table\";s:16:\"media_field_data\";s:5:\"field\";s:16:\"default_langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:5:\"media\";s:12:\"entity_field\";s:16:\"default_langcode\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:2:{s:9:\"row_class\";s:85:\"media-library-item media-library-item--table js-media-library-item js-click-to-select\";s:17:\"default_row_class\";b:1;}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:8:\"defaults\";a:9:{s:6:\"access\";b:0;s:9:\"css_class\";b:0;s:5:\"style\";b:0;s:3:\"row\";b:0;s:6:\"fields\";b:0;s:9:\"arguments\";b:0;s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;s:6:\"header\";b:0;}s:9:\"css_class\";s:0:\"\";s:6:\"header\";a:2:{s:17:\"display_link_grid\";a:7:{s:2:\"id\";s:17:\"display_link_grid\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:12:\"display_link\";s:9:\"plugin_id\";s:12:\"display_link\";s:5:\"label\";s:4:\"Grid\";s:5:\"empty\";b:1;s:10:\"display_id\";s:6:\"widget\";}s:18:\"display_link_table\";a:7:{s:2:\"id\";s:18:\"display_link_table\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:12:\"display_link\";s:9:\"plugin_id\";s:12:\"display_link\";s:5:\"label\";s:5:\"Table\";s:5:\"empty\";b:1;s:10:\"display_id\";s:12:\"widget_table\";}}s:18:\"rendering_language\";s:33:\"***LANGUAGE_language_interface***\";s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:32:\"admin/content/media-widget-table\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:22:\"url.query_args:sort_by\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}'),
('',	'views.view.redirect',	'a:13:{s:4:\"uuid\";s:36:\"cb66f7a4-4661-4051-8a2d-40c096d4f55d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:4:\"link\";i:1;s:8:\"redirect\";i:2;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"I9VqfbwK5ZyKzL7810d0fswaadU6riFT3kPL0yxcpLs\";}s:2:\"id\";s:8:\"redirect\";s:5:\"label\";s:8:\"Redirect\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:17:\"List of redirects\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:8:\"redirect\";s:10:\"base_field\";s:3:\"rid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:18:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:20:\"administer redirects\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:6:\"Filter\";s:12:\"reset_button\";b:1;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:8:{s:14:\"items_per_page\";i:50;s:6:\"offset\";i:0;s:2:\"id\";i:0;s:11:\"total_pages\";N;s:4:\"tags\";a:4:{s:8:\"previous\";s:12:\"‹ previous\";s:4:\"next\";s:8:\"next ›\";s:5:\"first\";s:8:\"« first\";s:4:\"last\";s:7:\"last »\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:8:\"quantity\";i:9;s:24:\"pagination_heading_level\";s:2:\"h4\";}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"caption\";s:0:\"\";s:7:\"summary\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"columns\";a:6:{s:21:\"redirect_source__path\";s:21:\"redirect_source__path\";s:22:\"redirect_redirect__uri\";s:22:\"redirect_redirect__uri\";s:11:\"status_code\";s:11:\"status_code\";s:8:\"language\";s:8:\"language\";s:7:\"created\";s:7:\"created\";s:10:\"operations\";s:10:\"operations\";}s:4:\"info\";a:6:{s:21:\"redirect_source__path\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:22:\"redirect_redirect__uri\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:11:\"status_code\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:8:\"language\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:10:\"operations\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:7:\"default\";s:7:\"created\";s:11:\"empty_table\";b:0;}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:6:\"fields\";a:7:{s:18:\"redirect_bulk_form\";a:26:{s:2:\"id\";s:18:\"redirect_bulk_form\";s:5:\"table\";s:8:\"redirect\";s:5:\"field\";s:18:\"redirect_bulk_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"action_title\";s:14:\"With selection\";s:15:\"include_exclude\";s:7:\"exclude\";s:16:\"selected_actions\";a:0:{}s:11:\"entity_type\";s:8:\"redirect\";s:9:\"plugin_id\";s:18:\"redirect_bulk_form\";}s:21:\"redirect_source__path\";a:37:{s:2:\"id\";s:21:\"redirect_source__path\";s:5:\"table\";s:8:\"redirect\";s:5:\"field\";s:21:\"redirect_source__path\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:4:\"From\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:4:\"path\";s:4:\"type\";s:15:\"redirect_source\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:0:\"\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:8:\"redirect\";s:12:\"entity_field\";s:15:\"redirect_source\";s:9:\"plugin_id\";s:5:\"field\";}s:22:\"redirect_redirect__uri\";a:6:{s:2:\"id\";s:22:\"redirect_redirect__uri\";s:5:\"table\";s:8:\"redirect\";s:5:\"field\";s:22:\"redirect_redirect__uri\";s:11:\"entity_type\";s:8:\"redirect\";s:12:\"entity_field\";s:17:\"redirect_redirect\";s:9:\"plugin_id\";s:5:\"field\";}s:11:\"status_code\";a:6:{s:2:\"id\";s:11:\"status_code\";s:5:\"table\";s:8:\"redirect\";s:5:\"field\";s:11:\"status_code\";s:11:\"entity_type\";s:8:\"redirect\";s:12:\"entity_field\";s:11:\"status_code\";s:9:\"plugin_id\";s:5:\"field\";}s:8:\"language\";a:6:{s:2:\"id\";s:8:\"language\";s:5:\"table\";s:8:\"redirect\";s:5:\"field\";s:8:\"language\";s:11:\"entity_type\";s:8:\"redirect\";s:12:\"entity_field\";s:8:\"language\";s:9:\"plugin_id\";s:5:\"field\";}s:7:\"created\";a:27:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:8:\"redirect\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:7:\"Created\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"date_format\";s:8:\"fallback\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";s:11:\"entity_type\";s:8:\"redirect\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";}s:10:\"operations\";a:5:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:8:\"redirect\";s:5:\"field\";s:10:\"operations\";s:11:\"entity_type\";s:8:\"redirect\";s:9:\"plugin_id\";s:17:\"entity_operations\";}}s:7:\"filters\";a:4:{s:21:\"redirect_source__path\";a:16:{s:2:\"id\";s:21:\"redirect_source__path\";s:5:\"table\";s:8:\"redirect\";s:5:\"field\";s:21:\"redirect_source__path\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:24:\"redirect_source__path_op\";s:5:\"label\";s:4:\"From\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:24:\"redirect_source__path_op\";s:10:\"identifier\";s:21:\"redirect_source__path\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:8:\"redirect\";s:12:\"entity_field\";s:15:\"redirect_source\";s:9:\"plugin_id\";s:6:\"string\";}s:22:\"redirect_redirect__uri\";a:16:{s:2:\"id\";s:22:\"redirect_redirect__uri\";s:5:\"table\";s:8:\"redirect\";s:5:\"field\";s:22:\"redirect_redirect__uri\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:25:\"redirect_redirect__uri_op\";s:5:\"label\";s:2:\"To\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:25:\"redirect_redirect__uri_op\";s:10:\"identifier\";s:22:\"redirect_redirect__uri\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:8:\"redirect\";s:12:\"entity_field\";s:17:\"redirect_redirect\";s:9:\"plugin_id\";s:6:\"string\";}s:11:\"status_code\";a:16:{s:2:\"id\";s:11:\"status_code\";s:5:\"table\";s:8:\"redirect\";s:5:\"field\";s:11:\"status_code\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";a:3:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:0:\"\";}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:14:\"status_code_op\";s:5:\"label\";s:11:\"Status code\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:14:\"status_code_op\";s:10:\"identifier\";s:11:\"status_code\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}s:10:\"is_grouped\";b:1;s:10:\"group_info\";a:10:{s:5:\"label\";s:11:\"Status code\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:11:\"status_code\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:7:{i:1;a:3:{s:5:\"title\";s:20:\"300 Multiple Choices\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";a:3:{s:5:\"value\";s:3:\"300\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";}}i:2;a:3:{s:5:\"title\";s:21:\"301 Moved Permanently\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";a:3:{s:5:\"value\";s:3:\"301\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";}}i:3;a:3:{s:5:\"title\";s:9:\"302 Found\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";a:3:{s:5:\"value\";s:3:\"302\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";}}i:4;a:3:{s:5:\"title\";s:13:\"303 See Other\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";a:3:{s:5:\"value\";s:3:\"303\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";}}i:5;a:3:{s:5:\"title\";s:16:\"304 Not Modified\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";a:3:{s:5:\"value\";s:3:\"304\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";}}i:6;a:3:{s:5:\"title\";s:13:\"305 Use Proxy\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";a:3:{s:5:\"value\";s:3:\"305\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";}}i:7;a:3:{s:5:\"title\";s:22:\"307 Temporary Redirect\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";a:3:{s:5:\"value\";s:3:\"307\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";}}}}s:11:\"entity_type\";s:8:\"redirect\";s:12:\"entity_field\";s:11:\"status_code\";s:9:\"plugin_id\";s:7:\"numeric\";}s:8:\"language\";a:16:{s:2:\"id\";s:8:\"language\";s:5:\"table\";s:8:\"redirect\";s:5:\"field\";s:8:\"language\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:11:\"language_op\";s:5:\"label\";s:17:\"Original language\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"language_op\";s:10:\"identifier\";s:8:\"language\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:8:\"redirect\";s:12:\"entity_field\";s:8:\"language\";s:9:\"plugin_id\";s:8:\"language\";}}s:5:\"sorts\";a:0:{}s:5:\"title\";s:8:\"Redirect\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"empty\";b:1;s:8:\"tokenize\";b:0;s:7:\"content\";s:25:\"There is no redirect yet.\";s:9:\"plugin_id\";s:11:\"text_custom\";}}s:13:\"relationships\";a:0:{}s:9:\"arguments\";a:0:{}s:17:\"display_extenders\";a:0:{}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}}s:14:\"cache_metadata\";a:4:{s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:9:\"cacheable\";b:0;s:7:\"max-age\";i:0;s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:14:\"display_plugin\";s:4:\"page\";s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:8:\"position\";i:1;s:15:\"display_options\";a:2:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:28:\"admin/config/search/redirect\";}s:14:\"cache_metadata\";a:4:{s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:9:\"cacheable\";b:0;s:7:\"max-age\";i:0;s:4:\"tags\";a:0:{}}}}}'),
('',	'views.view.taxonomy_term',	'a:13:{s:4:\"uuid\";s:36:\"d74333b1-feb4-4d77-9bb9-7230d2bc1f92\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:33:\"core.entity_view_mode.node.teaser\";}s:6:\"module\";a:3:{i:0;s:4:\"node\";i:1;s:8:\"taxonomy\";i:2;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KejdxDJQmx8SaO-t83OVekLw6ar4ldjmsJMGcotGxnQ\";}s:2:\"id\";s:13:\"taxonomy_term\";s:5:\"label\";s:13:\"Taxonomy term\";s:6:\"module\";s:8:\"taxonomy\";s:11:\"description\";s:45:\"Content belonging to a certain taxonomy term.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:18:{s:6:\"fields\";a:0:{}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:7:{s:6:\"offset\";i:0;s:24:\"pagination_heading_level\";s:2:\"h4\";s:14:\"items_per_page\";i:10;s:11:\"total_pages\";i:0;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:6:\"››\";s:8:\"previous\";s:6:\"‹‹\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:2:{s:6:\"sticky\";a:10:{s:2:\"id\";s:6:\"sticky\";s:5:\"table\";s:14:\"taxonomy_index\";s:5:\"field\";s:6:\"sticky\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:8:\"standard\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:6:\"sticky\";}s:7:\"exposed\";b:0;}s:7:\"created\";a:11:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:14:\"taxonomy_index\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:1:{s:3:\"tid\";a:22:{s:2:\"id\";s:3:\"tid\";s:5:\"table\";s:14:\"taxonomy_index\";s:5:\"field\";s:3:\"tid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:18:\"taxonomy_index_tid\";s:14:\"default_action\";s:9:\"not found\";s:9:\"exception\";a:3:{s:5:\"value\";s:0:\"\";s:12:\"title_enable\";b:0;s:5:\"title\";s:3:\"All\";}s:12:\"title_enable\";b:1;s:5:\"title\";s:19:\"{{ arguments.tid }}\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:0:\"\";}s:15:\"summary_options\";a:4:{s:9:\"base_path\";s:0:\"\";s:5:\"count\";b:1;s:8:\"override\";b:0;s:14:\"items_per_page\";i:25;}s:7:\"summary\";a:3:{s:10:\"sort_order\";s:3:\"asc\";s:17:\"number_of_records\";i:0;s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:1;s:8:\"validate\";a:2:{s:4:\"type\";s:20:\"entity:taxonomy_term\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:4:{s:7:\"bundles\";a:0:{}s:6:\"access\";b:1;s:9:\"operation\";s:4:\"view\";s:8:\"multiple\";i:0;}s:12:\"break_phrase\";b:0;s:9:\"add_table\";b:0;s:13:\"require_value\";b:0;s:17:\"reduce_duplicates\";b:0;}}s:7:\"filters\";a:2:{s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:31:\"***LANGUAGE_language_content***\";s:31:\"***LANGUAGE_language_content***\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"status\";a:14:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:14:\"taxonomy_index\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:4:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:1:{s:9:\"view_mode\";s:6:\"teaser\";}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:12:\"link_display\";s:6:\"page_1\";s:8:\"link_url\";s:0:\"\";s:6:\"header\";a:1:{s:20:\"entity_taxonomy_term\";a:12:{s:2:\"id\";s:20:\"entity_taxonomy_term\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:20:\"entity_taxonomy_term\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"entity\";s:5:\"empty\";b:1;s:6:\"target\";s:23:\"{{ raw_arguments.tid }}\";s:9:\"view_mode\";s:4:\"full\";s:8:\"tokenize\";b:1;s:13:\"bypass_access\";b:0;}}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"feed_1\";a:6:{s:2:\"id\";s:6:\"feed_1\";s:13:\"display_title\";s:4:\"Feed\";s:14:\"display_plugin\";s:4:\"feed\";s:8:\"position\";i:2;s:15:\"display_options\";a:7:{s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;}}s:5:\"style\";a:2:{s:4:\"type\";s:3:\"rss\";s:7:\"options\";a:3:{s:8:\"grouping\";a:0:{}s:11:\"uses_fields\";b:0;s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:2:{s:4:\"type\";s:8:\"node_rss\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:7:\"default\";}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:20:\"taxonomy/term/%/feed\";s:8:\"displays\";a:2:{s:6:\"page_1\";s:6:\"page_1\";s:7:\"default\";s:1:\"0\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:3:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:15:\"taxonomy/term/%\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}'),
('',	'views.view.user_admin_people',	'a:13:{s:4:\"uuid\";s:36:\"dd75f214-13a9-43b5-af70-9953d491803c\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"FFLg74mnzRE10lgg5fspPCZWLnIEcvCnJMlNzj8OEtw\";}s:2:\"id\";s:17:\"user_admin_people\";s:5:\"label\";s:6:\"People\";s:6:\"module\";s:4:\"user\";s:11:\"description\";s:50:\"Find and manage people interacting with your site.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:16:\"users_field_data\";s:10:\"base_field\";s:3:\"uid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:25:{s:5:\"title\";s:6:\"People\";s:6:\"fields\";a:8:{s:14:\"user_bulk_form\";a:23:{s:2:\"id\";s:14:\"user_bulk_form\";s:5:\"table\";s:5:\"users\";s:5:\"field\";s:14:\"user_bulk_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:9:\"plugin_id\";s:14:\"user_bulk_form\";s:5:\"label\";s:11:\"Bulk update\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:8:\"Username\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}s:6:\"status\";a:26:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Status\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"custom\";s:19:\"format_custom_false\";s:7:\"Blocked\";s:18:\"format_custom_true\";s:6:\"Active\";}}s:15:\"roles_target_id\";a:24:{s:2:\"id\";s:15:\"roles_target_id\";s:5:\"table\";s:11:\"user__roles\";s:5:\"field\";s:15:\"roles_target_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:10:\"user_roles\";s:5:\"label\";s:5:\"Roles\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:2:\"ul\";s:9:\"separator\";s:2:\", \";}s:7:\"created\";a:26:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:10:\"Member for\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:13:\"timestamp_ago\";s:8:\"settings\";a:3:{s:13:\"future_format\";s:9:\"@interval\";s:11:\"past_format\";s:9:\"@interval\";s:11:\"granularity\";i:2;}}s:6:\"access\";a:26:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:11:\"Last access\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:13:\"timestamp_ago\";s:8:\"settings\";a:3:{s:13:\"future_format\";s:15:\"@interval hence\";s:11:\"past_format\";s:13:\"@interval ago\";s:11:\"granularity\";i:2;}}s:10:\"operations\";a:24:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:5:\"users\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:9:\"plugin_id\";s:17:\"entity_operations\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;}s:4:\"mail\";a:37:{s:2:\"id\";s:4:\"mail\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"mail\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"mail\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:12:\"basic_string\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:8:{s:6:\"offset\";i:0;s:24:\"pagination_heading_level\";s:2:\"h4\";s:14:\"items_per_page\";i:50;s:11:\"total_pages\";i:0;s:2:\"id\";i:0;s:4:\"tags\";a:4:{s:4:\"next\";s:8:\"Next ›\";s:8:\"previous\";s:12:\"‹ Previous\";s:5:\"first\";s:8:\"« First\";s:4:\"last\";s:7:\"Last »\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:8:\"quantity\";i:9;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:6:\"Filter\";s:12:\"reset_button\";b:1;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:16:\"administer users\";}}s:5:\"cache\";a:1:{s:4:\"type\";s:3:\"tag\";}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:20:\"No people available.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:7:\"filters\";a:6:{s:7:\"combine\";a:15:{s:2:\"id\";s:7:\"combine\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"combine\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:7:\"combine\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:10:\"combine_op\";s:5:\"label\";s:22:\"Name or email contains\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:10:\"combine_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"user\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:6:\"fields\";a:2:{s:4:\"name\";s:4:\"name\";s:4:\"mail\";s:4:\"mail\";}}s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"status_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"status\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:1;s:10:\"group_info\";a:10:{s:5:\"label\";s:6:\"Status\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:6:\"status\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:2:{i:1;a:3:{s:5:\"title\";s:6:\"Active\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";}i:2;a:3:{s:5:\"title\";s:7:\"Blocked\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}}}}s:15:\"roles_target_id\";a:15:{s:2:\"id\";s:15:\"roles_target_id\";s:5:\"table\";s:11:\"user__roles\";s:5:\"field\";s:15:\"roles_target_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:10:\"user_roles\";s:8:\"operator\";s:2:\"or\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:18:\"roles_target_id_op\";s:5:\"label\";s:4:\"Role\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:18:\"roles_target_id_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"role\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:17:\"reduce_duplicates\";b:0;}s:10:\"permission\";a:15:{s:2:\"id\";s:10:\"permission\";s:5:\"table\";s:11:\"user__roles\";s:5:\"field\";s:10:\"permission\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:16:\"user_permissions\";s:8:\"operator\";s:2:\"or\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:13:\"permission_op\";s:5:\"label\";s:10:\"Permission\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:13:\"permission_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:10:\"permission\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:17:\"reduce_duplicates\";b:0;}s:16:\"default_langcode\";a:16:{s:2:\"id\";s:16:\"default_langcode\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:16:\"default_langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:16:\"default_langcode\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:7:\"uid_raw\";a:15:{s:2:\"id\";s:7:\"uid_raw\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:7:\"uid_raw\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:9:\"plugin_id\";s:7:\"numeric\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";a:3:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:1:\"0\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:1:\"0\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:10:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:8:{s:14:\"user_bulk_form\";s:14:\"user_bulk_form\";s:4:\"name\";s:4:\"name\";s:6:\"status\";s:6:\"status\";s:3:\"rid\";s:3:\"rid\";s:7:\"created\";s:7:\"created\";s:6:\"access\";s:6:\"access\";s:9:\"edit_node\";s:9:\"edit_node\";s:10:\"dropbutton\";s:10:\"dropbutton\";}s:7:\"default\";s:7:\"created\";s:4:\"info\";a:8:{s:14:\"user_bulk_form\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"name\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"status\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:3:\"rid\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:6:\"access\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:9:\"edit_node\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:10:\"dropbutton\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:1;}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:9:\"css_class\";s:0:\"\";s:8:\"use_ajax\";b:0;s:8:\"group_by\";b:0;s:16:\"show_admin_links\";b:1;s:8:\"use_more\";b:0;s:15:\"use_more_always\";b:0;s:13:\"use_more_text\";s:4:\"more\";s:12:\"link_display\";s:6:\"page_1\";s:8:\"link_url\";s:0:\"\";s:15:\"display_comment\";s:0:\"\";s:23:\"hide_attachment_summary\";b:0;s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:6:{s:8:\"defaults\";a:1:{s:16:\"show_admin_links\";b:0;}s:16:\"show_admin_links\";b:0;s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:17:\"admin/people/list\";s:4:\"menu\";a:6:{s:4:\"type\";s:11:\"default tab\";s:5:\"title\";s:4:\"List\";s:11:\"description\";s:50:\"Find and manage people interacting with your site.\";s:6:\"weight\";i:-10;s:9:\"menu_name\";s:5:\"admin\";s:7:\"context\";s:0:\"\";}s:11:\"tab_options\";a:5:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:6:\"People\";s:11:\"description\";s:45:\"Manage user accounts, roles, and permissions.\";s:6:\"weight\";i:0;s:9:\"menu_name\";s:5:\"admin\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}'),
('',	'views.view.watchdog',	'a:13:{s:4:\"uuid\";s:36:\"1d71a232-99d5-4253-868e-76836877a513\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:5:\"dblog\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SR5P89f0vUTPC7WY2YpLAffkDx8-Ar8LKFfowVXeqNU\";}s:2:\"id\";s:8:\"watchdog\";s:5:\"label\";s:8:\"Watchdog\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:19:\"Recent log messages\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:8:\"watchdog\";s:10:\"base_field\";s:3:\"wid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:19:{s:5:\"title\";s:19:\"Recent log messages\";s:6:\"fields\";a:8:{s:7:\"nothing\";a:22:{s:2:\"id\";s:7:\"nothing\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"nothing\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:4:\"Icon\";s:9:\"plugin_id\";s:6:\"custom\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:4:\"icon\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:0;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:0;}s:3:\"wid\";a:22:{s:2:\"id\";s:3:\"wid\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:3:\"wid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:8:\"standard\";s:5:\"label\";s:3:\"WID\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:8:\"severity\";a:23:{s:2:\"id\";s:8:\"severity\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:8:\"severity\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:12:\"machine_name\";s:5:\"label\";s:8:\"Severity\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"machine_name\";b:0;}s:4:\"type\";a:22:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:8:\"standard\";s:5:\"label\";s:4:\"Type\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:9:\"timestamp\";a:25:{s:2:\"id\";s:9:\"timestamp\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:9:\"timestamp\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"label\";s:4:\"Date\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:7:\"message\";a:23:{s:2:\"id\";s:7:\"message\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:7:\"message\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:13:\"dblog_message\";s:5:\"label\";s:7:\"Message\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:1;s:4:\"path\";s:35:\"admin/reports/dblog/event/{{ wid }}\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:13:\"{{ message }}\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:56;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:1;s:4:\"trim\";b:1;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:1;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"replace_variables\";b:1;}s:4:\"name\";a:37:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:3:\"uid\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:4:\"User\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"user_name\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"link\";a:22:{s:2:\"id\";s:4:\"link\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:4:\"link\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:16:\"dblog_operations\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:7:{s:6:\"offset\";i:0;s:24:\"pagination_heading_level\";s:2:\"h4\";s:14:\"items_per_page\";i:50;s:11:\"total_pages\";N;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:6:\"››\";s:8:\"previous\";s:6:\"‹‹\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:6:\"Filter\";s:12:\"reset_button\";b:1;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:0;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:19:\"access site reports\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:1:{s:4:\"area\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:26:\"No log messages available.\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:26:\"No log messages available.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:1:{s:3:\"wid\";a:10:{s:2:\"id\";s:3:\"wid\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:3:\"wid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:8:\"standard\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:3:\"wid\";}s:7:\"exposed\";b:0;}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:4:\"type\";a:14:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"dblog_types\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:7:\"type_op\";s:5:\"label\";s:4:\"Type\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"type_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"type\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:1;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:8:\"severity\";a:14:{s:2:\"id\";s:8:\"severity\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:8:\"severity\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"in_operator\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:11:\"severity_op\";s:5:\"label\";s:8:\"Severity\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"severity_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:8:\"severity\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:1;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:25:\"{{ type }} {{ severity }}\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:8:{s:7:\"nothing\";s:7:\"nothing\";s:3:\"wid\";s:3:\"wid\";s:8:\"severity\";s:8:\"severity\";s:4:\"type\";s:4:\"type\";s:9:\"timestamp\";s:9:\"timestamp\";s:7:\"message\";s:7:\"message\";s:4:\"name\";s:4:\"name\";s:4:\"link\";s:4:\"link\";}s:7:\"default\";s:3:\"wid\";s:4:\"info\";a:8:{s:7:\"nothing\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}s:3:\"wid\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:8:\"severity\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:4:\"type\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}s:9:\"timestamp\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:7:\"message\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"name\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}s:4:\"link\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:0;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:1:{s:3:\"uid\";a:8:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:4:\"User\";s:9:\"plugin_id\";s:8:\"standard\";s:8:\"required\";b:0;}}s:9:\"css_class\";s:11:\"admin-dblog\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:4:\"page\";a:6:{s:2:\"id\";s:4:\"page\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:2:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:19:\"admin/reports/dblog\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}'),
('',	'views.view.webform_submissions',	'a:13:{s:4:\"uuid\";s:36:\"5c298710-8d19-4662-a5cc-dcd249b03b1d\";s:8:\"langcode\";s:2:\"en\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:2:{i:0;s:4:\"user\";i:1;s:7:\"webform\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ndr5pjyhumlySBPBZtyaztiGbMUclmN32B3nTQ-FRqE\";}s:2:\"id\";s:19:\"webform_submissions\";s:5:\"label\";s:19:\"Webform submissions\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:34:\"Default webform submissions views.\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:18:\"webform_submission\";s:10:\"base_field\";s:3:\"sid\";s:7:\"display\";a:5:{s:7:\"default\";a:6:{s:14:\"display_plugin\";s:7:\"default\";s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:8:\"position\";i:0;s:15:\"display_options\";a:18:{s:6:\"access\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:0:{}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:13:\"query_comment\";s:0:\"\";s:10:\"query_tags\";a:0:{}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:8:{s:14:\"items_per_page\";i:25;s:6:\"offset\";i:0;s:2:\"id\";i:0;s:11:\"total_pages\";N;s:4:\"tags\";a:4:{s:8:\"previous\";s:6:\"‹‹\";s:4:\"next\";s:6:\"››\";s:5:\"first\";s:8:\"« First\";s:4:\"last\";s:7:\"Last »\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:23:\"5, 10, 25, 50, 100, 200\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:8:\"quantity\";i:9;s:24:\"pagination_heading_level\";s:2:\"h4\";}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"caption\";s:0:\"\";s:7:\"summary\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"columns\";a:10:{s:28:\"webform_submission_bulk_form\";s:28:\"webform_submission_bulk_form\";s:3:\"sid\";s:3:\"sid\";s:8:\"in_draft\";s:8:\"in_draft\";s:6:\"sticky\";s:6:\"sticky\";s:6:\"locked\";s:6:\"locked\";s:7:\"created\";s:7:\"created\";s:9:\"completed\";s:9:\"completed\";s:11:\"remote_addr\";s:11:\"remote_addr\";s:23:\"view_webform_submission\";s:23:\"view_webform_submission\";s:23:\"edit_webform_submission\";s:23:\"view_webform_submission\";}s:4:\"info\";a:10:{s:28:\"webform_submission_bulk_form\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:3:\"sid\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:8:\"in_draft\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"sticky\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"locked\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:9:\"completed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:11:\"remote_addr\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:23:\"view_webform_submission\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:1:\" \";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:23:\"edit_webform_submission\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:7:\"default\";s:7:\"created\";s:11:\"empty_table\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;s:22:\"default_field_elements\";b:1;}}s:6:\"fields\";a:5:{s:3:\"sid\";a:37:{s:2:\"id\";s:3:\"sid\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:3:\"sid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:1:\"#\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:14:\"number_integer\";s:8:\"settings\";a:2:{s:18:\"thousand_separator\";s:0:\"\";s:13:\"prefix_suffix\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:3:\"sid\";s:9:\"plugin_id\";s:5:\"field\";}s:8:\"in_draft\";a:37:{s:2:\"id\";s:8:\"in_draft\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:8:\"in_draft\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:5:\"Draft\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:18:\"format_custom_true\";s:0:\"\";s:19:\"format_custom_false\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:8:\"in_draft\";s:9:\"plugin_id\";s:5:\"field\";}s:7:\"created\";a:37:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:7:\"Created\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:5:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";s:7:\"tooltip\";a:2:{s:11:\"date_format\";s:0:\"\";s:18:\"custom_date_format\";s:0:\"\";}s:9:\"time_diff\";a:5:{s:7:\"enabled\";b:0;s:13:\"future_format\";s:15:\"@interval hence\";s:11:\"past_format\";s:13:\"@interval ago\";s:11:\"granularity\";i:2;s:7:\"refresh\";i:60;}}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:5:\"field\";}s:11:\"remote_addr\";a:37:{s:2:\"id\";s:11:\"remote_addr\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:11:\"remote_addr\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:10:\"IP address\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:11:\"remote_addr\";s:9:\"plugin_id\";s:5:\"field\";}s:23:\"view_webform_submission\";a:26:{s:2:\"id\";s:23:\"view_webform_submission\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:23:\"view_webform_submission\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:4:\"view\";s:18:\"output_url_as_text\";b:0;s:8:\"absolute\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:9:\"plugin_id\";s:11:\"entity_link\";}}s:7:\"filters\";a:0:{}s:5:\"sorts\";a:0:{}s:6:\"header\";a:1:{s:6:\"result\";a:9:{s:2:\"id\";s:6:\"result\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:6:\"result\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"empty\";b:0;s:7:\"content\";s:34:\"Displaying @start - @end of @total\";s:9:\"plugin_id\";s:6:\"result\";}}s:6:\"footer\";a:0:{}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"empty\";b:1;s:8:\"tokenize\";b:0;s:7:\"content\";s:25:\"No submissions available.\";s:9:\"plugin_id\";s:11:\"text_custom\";}}s:13:\"relationships\";a:0:{}s:9:\"arguments\";a:5:{s:10:\"webform_id\";a:6:{s:2:\"id\";s:10:\"webform_id\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:10:\"webform_id\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:10:\"webform_id\";s:9:\"plugin_id\";s:6:\"string\";}s:11:\"entity_type\";a:6:{s:2:\"id\";s:11:\"entity_type\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:11:\"entity_type\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:11:\"entity_type\";s:9:\"plugin_id\";s:6:\"string\";}s:9:\"entity_id\";a:6:{s:2:\"id\";s:9:\"entity_id\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:9:\"entity_id\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:9:\"entity_id\";s:9:\"plugin_id\";s:6:\"string\";}s:3:\"uid\";a:6:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:3:\"uid\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:3:\"uid\";s:9:\"plugin_id\";s:7:\"numeric\";}s:8:\"in_draft\";a:22:{s:2:\"id\";s:8:\"in_draft\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:8:\"in_draft\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:14:\"default_action\";s:6:\"ignore\";s:9:\"exception\";a:3:{s:5:\"value\";s:3:\"all\";s:12:\"title_enable\";b:0;s:5:\"title\";s:3:\"All\";}s:12:\"title_enable\";b:0;s:5:\"title\";s:0:\"\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:0:\"\";}s:15:\"summary_options\";a:4:{s:9:\"base_path\";s:0:\"\";s:5:\"count\";b:1;s:14:\"items_per_page\";i:25;s:8:\"override\";b:0;}s:7:\"summary\";a:3:{s:10:\"sort_order\";s:3:\"asc\";s:17:\"number_of_records\";i:0;s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:0;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:12:\"break_phrase\";b:0;s:3:\"not\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:8:\"in_draft\";s:9:\"plugin_id\";s:7:\"numeric\";}}s:17:\"display_extenders\";a:0:{}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:0:{}}s:5:\"title\";s:19:\"Webform submissions\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";}s:4:\"tags\";a:0:{}}}s:16:\"embed_administer\";a:6:{s:14:\"display_plugin\";s:5:\"embed\";s:2:\"id\";s:16:\"embed_administer\";s:13:\"display_title\";s:17:\"Embed: Administer\";s:8:\"position\";i:2;s:15:\"display_options\";a:9:{s:17:\"display_extenders\";a:0:{}s:19:\"display_description\";s:23:\"Administer submissions.\";s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"caption\";s:0:\"\";s:7:\"summary\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"columns\";a:10:{s:28:\"webform_submission_bulk_form\";s:28:\"webform_submission_bulk_form\";s:3:\"sid\";s:3:\"sid\";s:8:\"in_draft\";s:8:\"in_draft\";s:6:\"sticky\";s:6:\"sticky\";s:6:\"locked\";s:6:\"locked\";s:7:\"created\";s:7:\"created\";s:9:\"completed\";s:9:\"completed\";s:11:\"remote_addr\";s:11:\"remote_addr\";s:23:\"view_webform_submission\";s:23:\"view_webform_submission\";s:23:\"edit_webform_submission\";s:23:\"view_webform_submission\";}s:4:\"info\";a:10:{s:28:\"webform_submission_bulk_form\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:3:\"sid\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:8:\"in_draft\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"sticky\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"locked\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:9:\"completed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:11:\"remote_addr\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:23:\"view_webform_submission\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:1:\" \";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:23:\"edit_webform_submission\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:7:\"default\";s:7:\"created\";s:11:\"empty_table\";b:0;}}s:8:\"defaults\";a:6:{s:5:\"style\";b:0;s:3:\"row\";b:0;s:6:\"access\";b:0;s:6:\"fields\";b:0;s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;s:22:\"default_field_elements\";b:1;}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:29:\"administer webform submission\";}}s:6:\"fields\";a:9:{s:28:\"webform_submission_bulk_form\";a:26:{s:2:\"id\";s:28:\"webform_submission_bulk_form\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:28:\"webform_submission_bulk_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:39:\"Webform submission operations bulk form\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"action_title\";s:6:\"Action\";s:15:\"include_exclude\";s:7:\"exclude\";s:16:\"selected_actions\";a:0:{}s:11:\"entity_type\";s:18:\"webform_submission\";s:9:\"plugin_id\";s:28:\"webform_submission_bulk_form\";}s:3:\"sid\";a:37:{s:2:\"id\";s:3:\"sid\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:3:\"sid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:1:\"#\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:14:\"number_integer\";s:8:\"settings\";a:2:{s:18:\"thousand_separator\";s:0:\"\";s:13:\"prefix_suffix\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:3:\"sid\";s:9:\"plugin_id\";s:5:\"field\";}s:8:\"in_draft\";a:37:{s:2:\"id\";s:8:\"in_draft\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:8:\"in_draft\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:5:\"Draft\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:18:\"format_custom_true\";s:0:\"\";s:19:\"format_custom_false\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:8:\"in_draft\";s:9:\"plugin_id\";s:5:\"field\";}s:6:\"sticky\";a:37:{s:2:\"id\";s:6:\"sticky\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"sticky\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:6:\"Sticky\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:18:\"format_custom_true\";s:0:\"\";s:19:\"format_custom_false\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"sticky\";s:9:\"plugin_id\";s:5:\"field\";}s:6:\"locked\";a:37:{s:2:\"id\";s:6:\"locked\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"locked\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:6:\"Locked\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:18:\"format_custom_true\";s:0:\"\";s:19:\"format_custom_false\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"locked\";s:9:\"plugin_id\";s:5:\"field\";}s:7:\"created\";a:37:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:7:\"Created\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:5:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";s:7:\"tooltip\";a:2:{s:11:\"date_format\";s:0:\"\";s:18:\"custom_date_format\";s:0:\"\";}s:9:\"time_diff\";a:5:{s:7:\"enabled\";b:0;s:13:\"future_format\";s:15:\"@interval hence\";s:11:\"past_format\";s:13:\"@interval ago\";s:11:\"granularity\";i:2;s:7:\"refresh\";i:60;}}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:5:\"field\";}s:9:\"completed\";a:37:{s:2:\"id\";s:9:\"completed\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:9:\"completed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:9:\"Completed\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:5:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";s:7:\"tooltip\";a:2:{s:11:\"date_format\";s:0:\"\";s:18:\"custom_date_format\";s:0:\"\";}s:9:\"time_diff\";a:5:{s:7:\"enabled\";b:0;s:13:\"future_format\";s:15:\"@interval hence\";s:11:\"past_format\";s:13:\"@interval ago\";s:11:\"granularity\";i:2;s:7:\"refresh\";i:60;}}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:9:\"completed\";s:9:\"plugin_id\";s:5:\"field\";}s:11:\"remote_addr\";a:37:{s:2:\"id\";s:11:\"remote_addr\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:11:\"remote_addr\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:10:\"IP address\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:11:\"remote_addr\";s:9:\"plugin_id\";s:5:\"field\";}s:10:\"operations\";a:25:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;s:11:\"entity_type\";N;s:12:\"entity_field\";N;s:9:\"plugin_id\";s:17:\"entity_operations\";}}s:7:\"filters\";a:3:{s:8:\"in_draft\";a:16:{s:2:\"id\";s:8:\"in_draft\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:8:\"in_draft\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:3:\"All\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:8:\"Is draft\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"in_draft_op\";s:10:\"identifier\";s:8:\"in_draft\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:8:\"in_draft\";s:9:\"plugin_id\";s:7:\"boolean\";}s:6:\"sticky\";a:16:{s:2:\"id\";s:6:\"sticky\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"sticky\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:3:\"All\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:6:\"Sticky\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"sticky_op\";s:10:\"identifier\";s:6:\"sticky\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"sticky\";s:9:\"plugin_id\";s:7:\"boolean\";}s:6:\"locked\";a:16:{s:2:\"id\";s:6:\"locked\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"locked\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:3:\"All\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:6:\"Locked\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"locked_op\";s:10:\"identifier\";s:6:\"locked\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:4:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";s:11:\"demo_region\";s:1:\"0\";}s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"locked\";s:9:\"plugin_id\";s:7:\"boolean\";}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";i:5;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:13:\"embed_default\";a:6:{s:14:\"display_plugin\";s:5:\"embed\";s:2:\"id\";s:13:\"embed_default\";s:13:\"display_title\";s:14:\"Embed: Default\";s:8:\"position\";i:1;s:15:\"display_options\";a:5:{s:17:\"display_extenders\";a:0:{}s:19:\"display_description\";s:20:\"Display submissions.\";s:8:\"defaults\";a:5:{s:6:\"fields\";b:1;s:5:\"style\";b:0;s:3:\"row\";b:0;s:7:\"filters\";b:1;s:13:\"filter_groups\";b:1;}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"caption\";s:0:\"\";s:7:\"summary\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"columns\";a:5:{s:3:\"sid\";s:3:\"sid\";s:8:\"in_draft\";s:8:\"in_draft\";s:7:\"created\";s:7:\"created\";s:11:\"remote_addr\";s:11:\"remote_addr\";s:23:\"view_webform_submission\";s:23:\"view_webform_submission\";}s:4:\"info\";a:5:{s:3:\"sid\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:8:\"in_draft\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:11:\"remote_addr\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:23:\"view_webform_submission\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:1:\" \";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:7:\"default\";s:7:\"created\";s:11:\"empty_table\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;s:22:\"default_field_elements\";b:1;}}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";}s:4:\"tags\";a:0:{}}}s:12:\"embed_manage\";a:6:{s:14:\"display_plugin\";s:5:\"embed\";s:2:\"id\";s:12:\"embed_manage\";s:13:\"display_title\";s:13:\"Embed: Manage\";s:8:\"position\";i:3;s:15:\"display_options\";a:9:{s:17:\"display_extenders\";a:0:{}s:19:\"display_description\";s:19:\"Manage submissions.\";s:6:\"fields\";a:10:{s:28:\"webform_submission_bulk_form\";a:26:{s:2:\"id\";s:28:\"webform_submission_bulk_form\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:28:\"webform_submission_bulk_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:39:\"Webform submission operations bulk form\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"action_title\";s:6:\"Action\";s:15:\"include_exclude\";s:7:\"include\";s:16:\"selected_actions\";a:4:{i:0;s:35:\"webform_submission_make_lock_action\";i:1;s:37:\"webform_submission_make_sticky_action\";i:2;s:37:\"webform_submission_make_unlock_action\";i:3;s:39:\"webform_submission_make_unsticky_action\";}s:11:\"entity_type\";s:18:\"webform_submission\";s:9:\"plugin_id\";s:28:\"webform_submission_bulk_form\";}s:3:\"sid\";a:37:{s:2:\"id\";s:3:\"sid\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:3:\"sid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:1:\"#\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:14:\"number_integer\";s:8:\"settings\";a:2:{s:18:\"thousand_separator\";s:0:\"\";s:13:\"prefix_suffix\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:3:\"sid\";s:9:\"plugin_id\";s:5:\"field\";}s:8:\"in_draft\";a:37:{s:2:\"id\";s:8:\"in_draft\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:8:\"in_draft\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:5:\"Draft\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:18:\"format_custom_true\";s:0:\"\";s:19:\"format_custom_false\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:8:\"in_draft\";s:9:\"plugin_id\";s:5:\"field\";}s:6:\"sticky\";a:37:{s:2:\"id\";s:6:\"sticky\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"sticky\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:6:\"Sticky\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:18:\"format_custom_true\";s:0:\"\";s:19:\"format_custom_false\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"sticky\";s:9:\"plugin_id\";s:5:\"field\";}s:6:\"locked\";a:37:{s:2:\"id\";s:6:\"locked\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"locked\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:5:\"label\";s:6:\"Locked\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"str