<?php

namespace Drupal\social_font;

use Drupal\Core\Link;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Url;

/**
 * Defines a class to build a listing of Font entities.
 *
 * @ingroup social_font
 */
class FontListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header = [];
    $header['id'] = $this->t('Font ID');
    $header['name'] = $this->t('Name');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row = [];
    /** @var \Drupal\social_font\Entity\Font $entity */
    $row['id'] = $entity->id();
    $label = $entity->label();
    if (!empty($row['id']) && !empty($label)) {
      $row['name'] = Link::fromTextAndUrl($label, new Url(
        'entity.font.edit_form', [
          'font' => $entity->id(),
        ]
      ));
    }
    return $row + parent::buildRow($entity);

  }

}
