<?php

namespace Drupal\social_search;

use Drupal\Core\Breadcrumb\BreadcrumbBuilderInterface;
use Drupal\Core\Breadcrumb\Breadcrumb;
use Drupal\Core\Link;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Class to define the search breadcrumb builder.
 */
class SocialSearchBreadcrumbBuilder implements BreadcrumbBuilderInterface {
  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function applies(RouteMatchInterface $route_match) {
    $search_routes = [
      'view.search_all.page',
      'view.search_all.page_no_value',
      'view.search_content.page',
      'view.search_content.page_no_value',
      'view.search_users.page',
      'view.search_users.page_no_value',
      'view.search_groups.page',
      'view.search_groups.page_no_value',
    ];
    return in_array($route_match->getRouteName(), $search_routes);
  }

  /**
   * {@inheritdoc}
   */
  public function build(RouteMatchInterface $route_match) {
    $breadcrumb = new Breadcrumb();

    switch ($route_match->getRouteName()) {
      case 'view.search_content.page':
      case 'view.search_content.page_no_value':
      case 'view.search_users.page':
      case 'view.search_users.page_no_value':
      case 'view.search_groups.page':
      case 'view.search_groups.page_no_value':
      case 'view.search_all.page':
      case 'view.search_all.page_no_value':
        // No value because of duplicate words.
        break;

      default:
        $page_title = $this->t('Search');
        $breadcrumb->addLink(Link::createFromRoute($page_title, '<none>'));
    }

    $breadcrumb->addLink(Link::createFromRoute($this->t('Home'), '<front>'));

    // This breadcrumb builder is based on a route parameter, and hence it
    // depends on the 'route' cache context.
    $breadcrumb->addCacheContexts(['route']);

    return $breadcrumb;
  }

}
