<?php

namespace Drupal\social_user\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class SocialUserFloodForm.
 *
 * @package Drupal\social_user\Form
 */
class SocialUserFloodForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'user.flood',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'social_user_flood_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    // Get config for this form.
    $config = $this->config('user.flood');

    $form['ip_limit'] = [
      '#type' => 'number',
      '#title' => $this->t('IP limit'),
      '#description' => $this->t('The amount of login attempts that can be made from a certain IP address.'),
      '#default_value' => $config->get('ip_limit'),
      '#min' => 0,
      '#step' => 10,
    ];

    $form['ip_window'] = [
      '#type' => 'number',
      '#title' => $this->t('IP window'),
      '#description' => $this->t('The time in seconds that needs to pass before a login block expires (IP).'),
      '#default_value' => $config->get('ip_window'),
      '#min' => 0,
      '#step' => 60,
    ];

    $form['user_limit'] = [
      '#type' => 'number',
      '#title' => $this->t('User limit'),
      '#description' => $this->t('The amount of login attempts that can be made by a username.'),
      '#default_value' => $config->get('user_limit'),
      '#min' => 0,
      '#step' => 1,
    ];

    $form['user_window'] = [
      '#type' => 'number',
      '#title' => $this->t('User window'),
      '#description' => $this->t('The time in seconds that needs to pass before a login block expires (User).'),
      '#default_value' => $config->get('user_window'),
      '#min' => 0,
      '#step' => 60,
    ];

    // @todo Change the autogenerated stub.
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('user.flood')
      ->set('ip_limit', $form_state->getValue('ip_limit'))
      ->set('ip_window', $form_state->getValue('ip_window'))
      ->set('user_limit', $form_state->getValue('user_limit'))
      ->set('user_window', $form_state->getValue('user_window'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
