---
home: true
heroImage: /thunder.svg
heroText: null
title: Homepage
footer: © 2021 <a href="https://thunder.org">Thunder</a>
footerHtml: true
actions:
  - text: User Guide
    link: /user-guide/feature-overview.html
    type: primary
  - text: Developer Guide
    link: /developer-guide/setup.html
    type: secondary
features:
  - title: Easy to use
    details: Drive team success with easy content authoring tools that put your goals within reach - faster.
  - title: Drupal-Powered
    details: Enjoy the dev experience of Drupal, use Drupal modules, and develop custom themes with Drupal.
  - title: Performant
    details: Increase your search rank and reduce your bounce rate with page content that loads blazing fast using
        Drupal Big Pipe.
---

## What is Thunder

Thunder is a Drupal distribution for professional publishers. It consists of the current Drupal functionality, lots of
handpicked publisher-centric modules with custom enhancements, and an environment which makes it easy to install, deploy
and add new functionality.

In 2016, the German publisher Hubert Burda Media established the Thunder Coalition, which aims at joining forces amongst
publishers by sharing code and innovation power.

As members of the Thunder Coalition, publishers, industry partners, and developers develop useful modules and
extensions, use them for their own purposes and share them with the Coalition by publishing them under the GNU General
Public License to further enhance Thunder.

## What do I get with Thunder

* **Create articles dynamically with paragraphs**: Using paragraphs, you can add text with a WYSIWYG-editor, pictures,
  videos, Instagram or Twitter cards to your article – and change the order by dragging and dropping the content
  wherever you like it. Thanks to a preview mode, you get a good idea of how your article will look like in the end.
* **Schedule your content**: You can plan when texts should be published, and you can also set a date to remove the
  article from your website. Also, you can set an expire date for images. After this, the picture will be replaced with
  a placeholder.
* **Improved media handling**: With the help of the media browser, it’s very easy to add pictures, galleries, or videos
  to your article. You can upload new pictures to the media browser by just dragging and dropping. The pictures are
  cropped automatically and with the focal point, you can define the important part of the picture, which should be
  visible in every layout.
* **Mobile Friendly**: With the Thunder installation, you get a responsive theme for frontend and backend. When writing
  an article, you can check how your text will look on different smartphones and tablets with the help of the device
  preview.
* **Demo Content and Guided Tour**: We added demo content and a guided tour to make it easier for newcomers to
  understand how Thunder works. Step by step, we explain how to add an article, how to edit an article, or how to add
  and sort channels.
* **Flexible System**: With Thunder, you get a system with a very high scalability. It's extendable with more than 2500
  modules to fit every need. Plus, it's themeable.
* **Big Drupal community**: Benefit from an active community with more than 100.000 user actively contributing and more
  than 2000 commits per week. In the Drupal and the Thunder community you'll find support if needed.

## Who is doing this

The distribution is maintained by the Thunder Core Team. The Thunder Core Team are a small number of publishing experts
and computer scientists. They maintain the distribution, handle industry relations, publishers’ requests and offers as
well as specialists training. They also run the Coalition’s infrastructure (like [thunder.org](http://thunder.org/)) and
organize events. Plus, the Core Team decides which modules are added to or removed from the distribution. The Core Team
also ensures that all basic functionality is available free of charge.

And if you like to chat, join our Slack team at [thunder.org/slack](http://www.thunder.org/slack).

## How to reach the Thunder Core Team

We would love to hear about your plans for using Thunder, your feature requests, your potential needs, and your
contributions to Thunder and the Community. Follow the @ThunderCoreTeam
on [Twitter](https://twitter.com/ThunderCoreTeam) and get the latest news about Thunder-related topics. Apart from that,
we are available for you at [info@thunder.org](mailto:info@thunder.org)
and [technology@thunder.org](mailto:technology@thunder.org).
