<?php
use CRM_CivicrmAdminUi_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Administer_Navigation_Menu',
    'entity' => 'SavedSearch',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Administer_Navigation_Menu',
        'label' => E::ts('Administer Navigation Menu'),
        'api_entity' => 'Navigation',
        'api_params' => [
          'version' => 4,
          'select' => [
            'id',
            'label',
          ],
          'orderBy' => [],
          'where' => [
            ['domain_id:name', '=', 'current_domain'],
            ['name', '!=', 'Home'],
          ],
          'groupBy' => [],
          'join' => [],
          'having' => [],
        ],
      ],
      'match' => ['name'],
    ],
  ],
  [
    'name' => 'SavedSearch_Administer_Navigation_Menu_SearchDisplay_Administer_Navigation_Menu',
    'entity' => 'SearchDisplay',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Administer_Navigation_Menu',
        'label' => E::ts('Administer Navigation Menu'),
        'saved_search_id.name' => 'Administer_Navigation_Menu',
        'type' => 'tree',
        'settings' => [
          'description' => '',
          'sort' => [],
          'parent_field' => 'parent_id',
          'placeholder' => 8,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'label',
              'dataType' => 'String',
              'icons' => [
                [
                  'icon' => 'fa-ban',
                  'side' => 'left',
                  'if' => [
                    'is_active',
                    '=',
                    FALSE,
                  ],
                ],
                [
                  'field' => 'icon',
                  'side' => 'left',
                ],
              ],
              'rewrite' => '',
              'break' => FALSE,
              'editable' => TRUE,
              'cssRules' => [
                [
                  'disabled',
                  'is_active',
                  '=',
                  FALSE,
                ],
              ],
            ],
            [
              'text' => '',
              'style' => 'default-outline',
              'size' => 'btn-xs',
              'icon' => 'fa-gear',
              'links' => [
                [
                  'path' => '',
                  'icon' => 'fa-pencil',
                  'text' => E::ts('Edit'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => 'Navigation',
                  'action' => 'update',
                  'join' => '',
                  'target' => 'crm-popup',
                ],
                [
                  'path' => 'civicrm/admin/menu/item?action=add&parent_id=[id]&reset=1',
                  'icon' => 'fa-folder-tree',
                  'text' => E::ts('Add subitem'),
                  'style' => 'default',
                  'condition' => [],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => 'crm-popup',
                ],
                [
                  'task' => 'disable',
                  'entity' => 'Navigation',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-off',
                  'text' => E::ts('Disable'),
                  'style' => 'warning',
                  'path' => '',
                  'action' => '',
                ],
                [
                  'task' => 'enable',
                  'entity' => 'Navigation',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-on',
                  'text' => E::ts('Enable'),
                  'style' => 'success',
                  'path' => '',
                  'action' => '',
                ],
                [
                  'task' => '',
                  'entity' => 'Navigation',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-trash',
                  'text' => E::ts('Delete'),
                  'style' => 'danger',
                  'path' => '',
                  'action' => 'delete',
                  'condition' => [],
                ],
              ],
              'type' => 'menu',
            ],
          ],
          'actions' => FALSE,
          'collapsible' => 'closed',
          'draggable' => 'weight',
          'cssRules' => [
            [
              'crm-separator-above',
              'has_separator:name',
              '=',
              '2',
            ],
            [
              'crm-separator-below',
              'has_separator:name',
              '=',
              '1',
            ],
          ],
          'toolbar' => [
            [
              'entity' => 'Navigation',
              'text' => E::ts('Add Menu Item'),
              'icon' => 'fa-plus',
              'target' => 'crm-popup',
              'action' => 'add',
              'style' => 'primary',
              'join' => '',
              'path' => '',
              'task' => '',
              'condition' => [],
            ],
          ],
        ],
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
];
