# CiviCRM 5.15.0

Released July 3, 2019

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     | **yes** |
| Alter the API?                                                  | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     | **yes** |
| Introduce features?                                             | **yes** |
| Fix bugs?                                                       | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Rearrange quick search options
  ([dev/core#628](https://lab.civicrm.org/dev/core/issues/628):
  [14441](https://github.com/civicrm/civicrm-core/pull/14441))**

  This change makes it so that the quicksearch field options can be rearranged.

- **Improve formatting for settings checkboxes
  ([14461](https://github.com/civicrm/civicrm-core/pull/14461) and
  [14419](https://github.com/civicrm/civicrm-core/pull/14419))**

  Restyles the checkboxes on the "Display Preferences" screen so they all use
  the same styling for visual consistency and restyles the "Components" settings
  field as a checkbox list instead of it being an AdvMultiSelect element.

- **Differentiate smart group from regular group using icon in select2 field
  (preliminary work for [dev/core#785](https://lab.civicrm.org/dev/core/issues/785):
  [14416](https://github.com/civicrm/civicrm-core/pull/14416))**

  Extends the addField() function to support fields of the type `select2` and
  `select`.

- **Cleanup & api-ise the dedupe code (preliminary work for
  [dev/core#982](https://lab.civicrm.org/dev/core/issues/982):
  [14298](https://github.com/civicrm/civicrm-core/pull/14298))**

  Adds a `dedupe.getstatistics` API action.

- **Add Contact.get_merge_conflicts API
  ([14394](https://github.com/civicrm/civicrm-core/pull/14394))**

  Adds a `contact.get_merge_conflicts` API action.

- **Add API for Dedupe.getduplicates
  ([14411](https://github.com/civicrm/civicrm-core/pull/14411))**

  Adds a `dedupe.getduplicates` API action.

- **Support latest PHPUnit versions
  ([dev/core#980](https://lab.civicrm.org/dev/core/issues/980):
  [14333](https://github.com/civicrm/civicrm-core/pull/14333),
  [14387](https://github.com/civicrm/civicrm-core/pull/14387),
  [14279](https://github.com/civicrm/civicrm-core/pull/14279),
  [14319](https://github.com/civicrm/civicrm-core/pull/14319),
  [14315](https://github.com/civicrm/civicrm-core/pull/14315),
  [14421](https://github.com/civicrm/civicrm-core/pull/14421),
  [14404](https://github.com/civicrm/civicrm-core/pull/14404),
  [254](https://github.com/civicrm/civicrm-packages/pull/254),
  [14283](https://github.com/civicrm/civicrm-core/pull/14283) and
  [14321](https://github.com/civicrm/civicrm-core/pull/14321))**

  Updates phpunit version support so that the CiviCRM test suite works with
  phpunit versions 5 thru 8. Removes dependency on discontinued dbunit. Moves
  towards using API functions instead of dbunit.

- **Permit sort_name as a url parameter on advanced search
  ([14475](https://github.com/civicrm/civicrm-core/pull/14475))**

  Lays the ground work for a metadata based approach to search forms,
  Specifically for the contact form. Converts one field (sort_name) to be
  added by metadata and also to be supported via url (sort_name=x).

- **Allow updating ENGINE_CONFIG for System.updatelogtables
  ([14348](https://github.com/civicrm/civicrm-core/pull/14348))**

  Makes it so users can modify the SQL engine config for log tables thru the
  api.

- **Reduce cache bypasses - Do not bypass custom metadata cache in setGroupTree
  ([14292](https://github.com/civicrm/civicrm-core/pull/14292))**

  Improves performance when editing a form with custom data by using
  the cached metadata instead of doing a database query to rebuild the metadata.

- **Try enabling api4 extension in test suite
  ([14241](https://github.com/civicrm/civicrm-core/pull/14241))**

  Makes the api4 extension available when running unit tests.

- **Use data provider to test both API versions
  ([14153](https://github.com/civicrm/civicrm-core/pull/14153))**

  Makes it so 311 API v3 tests are converted to also test API v4.

- **Advanced search: activity tags should use select2 ([
  dev/core#924](https://lab.civicrm.org/dev/core/issues/924):
  [14247](https://github.com/civicrm/civicrm-core/pull/14247))**

  Changes the "Activity Tags" field on the "Advanced Search" form to be a
  select2 instead of a checkbox list to improve user experience.

## CiviContribute  

- **Better support in core for token payment processing (continues work for
  [dev/core#905](https://lab.civicrm.org/dev/core/issues/905):
  [14395](https://github.com/civicrm/civicrm-core/pull/14395) and
  [14343](https://github.com/civicrm/civicrm-core/pull/14343))**

  Separates the `contribution_recur` status_id option group from the `contribution`
  status_id  option group and adds the contribution recur statuses 'Processing'
  and 'Failing'.

- **Add cancel_reason field to civicrm_contribution_recur table
  ([dev/core#830](https://lab.civicrm.org/dev/core/issues/830):
  [13997](https://github.com/civicrm/civicrm-core/pull/13997))**

  Adds a `Cancellation Reason` field to the form to cancel recurring
  contributions.

- **Add time start date and end date values on page contribution widget ajax
  response ([dev/core#964](https://lab.civicrm.org/dev/core/issues/964):
  [14262](https://github.com/civicrm/civicrm-core/pull/14262))**

  Makes campaign start and end dates available to the campaign widget on
  Contribution Pages so that one can customize the campaign widget with options
  such as  "Starts in X days".

- **Expose contribution page in Contribution Summary report
  ([dev/core#959](https://lab.civicrm.org/dev/core/issues/959):
  [14249](https://github.com/civicrm/civicrm-core/pull/14249))**

  Exposes the contribution page field in the "Contribution Summary" report.

- **Add developer tab for summary report
  ([14254](https://github.com/civicrm/civicrm-core/pull/14254))**

  Adds a developer tab to the "Contribution Summary" report.

- **Wrap titles in metadata in ts on payment.create API
  ([14450](https://github.com/civicrm/civicrm-core/pull/14450))**

  Improves the API v3 explorer for multilingual sites by translating the
  titles in the payment create API action.

- **Translation in billingblock.tpl - dropping 'Information'
  ([14358](https://github.com/civicrm/civicrm-core/pull/14358))**

  Improves translation of the billing block on front facing contribution and
  event forms by removing the word Information from the title.

## CiviEvent

- **WYSIWYG support for i18n event fields
  ([14384](https://github.com/civicrm/civicrm-core/pull/14384) and
  [14396](https://github.com/civicrm/civicrm-core/pull/14396))**

  Adds support for wysiwyg editor in i18n popup for event fields.

## Drupal Integration  

- **Pass the RFC 3164 severity level thru to drupal watchdog.
  ([14185](https://github.com/civicrm/civicrm-core/pull/14185))**

  Improves error logging for Drupal users by passing the severity level to
  drupal watchdog. Before this change all errors passed from CiviCRM to
  drupal watchdog were logged at the debug level now errors, warnings, notices,
  info, etc. can be logged as such.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Fix Notice errors caused by l10n rewriting of query so query outputed create
  view rather than the create table
  ([dev/translation#26](https://lab.civicrm.org/dev/translation/issues/26):
  [14152](https://github.com/civicrm/civicrm-core/pull/14152))**

  Fixes a notice `Undefined property: CRM_Core_DAO::$Create_Table in
  CRM_Core_DAO::checkConstraintExists()..` when enabling a language in
  multilingual mode.

- **File custom fields cause a fatal error when trying to merge
  ([dev/core#723](https://lab.civicrm.org/dev/core/issues/723):
  [14325](https://github.com/civicrm/civicrm-core/pull/14325))**

  Fixes a fatal error when trying to merge two contacts with the custom fields
  of type "file".

- **Autogenerated .htaccess is for apache 2.2
  ([dev/core#913](https://lab.civicrm.org/dev/core/issues/913):
  [14158](https://github.com/civicrm/civicrm-core/pull/14158))**

  Updates the auto-generated .htaccess so it no longer gives an internal error
  for sites on apache 2.4.

- **Dedupe screen: single "flip" and multi-selected-flip have no effect
  ([dev/core#932](https://lab.civicrm.org/dev/core/issues/932):
  [14195](https://github.com/civicrm/civicrm-core/pull/14195))**

  Fixes the dedupe screen "flip selected duplicates" button so that it
  works as expected.

- **$this can not be used in static methods
  ([dev/core#945](https://lab.civicrm.org/dev/core/issues/945):
  [14217](https://github.com/civicrm/civicrm-core/pull/14217))**

  Fixes "$this can not be used in static methods" error thrown by
  getIncompleteImportTables() in CRM/Contact/Import/ImportJob.php

- **CiviCRM 5.13.4 - Specified key was too long; max key length is 767 bytes
  ([dev/core#978](https://lab.civicrm.org/dev/core/issues/978):
  [14363](https://github.com/civicrm/civicrm-core/pull/14363))**

  Fixes DB Error: `unknown error` if the system status check query fails.

- **userFrameworkResourceURL gets wrong trailing slash on windows
  ([dev/core#985](https://lab.civicrm.org/dev/core/issues/985):
  [14405](https://github.com/civicrm/civicrm-core/pull/14405))**

  Fixes an issue where `addTrailingSlash` would generate a \ instead of a '/' on
  Windows.

- **Can't set a non-breaking space as Thousands Separator in Administer >
  Localization settings
  ([dev/core#994](https://lab.civicrm.org/dev/core/issues/994):
  [14376](https://github.com/civicrm/civicrm-core/pull/14376))**

  Removes a form rule preventing location separators from having more than one
  character so that one can use a non-breaking space (or other string longer
  than one character).

- **Add CRM_Utils_System::sendResponse(). Fix AssetBuilder's status-code on WP.
  ([14468](https://github.com/civicrm/civicrm-core/pull/14468))**

  Ensures that a consistent response is returned across CMS's in regards to
  Asset Builder URLs. Before this change Wordpress would return a different
  response then Drupal/Backdrop and E2E Unit tests would fail on Wordpress.

- **Fix Exception API to save lower id number as contact 1
  ([14448](https://github.com/civicrm/civicrm-core/pull/14448))**

  Improves consistency when deduping contacts.

- **Fix Exception to remove result from duplicates
  ([14447](https://github.com/civicrm/civicrm-core/pull/14447))**

  Ensures that marking a non-duplicate contact removes them from the cached
  duplicates table.

- **Fix upgrade on participant_register date
  ([14427](https://github.com/civicrm/civicrm-core/pull/14427))**

  Fixes conversion routing on participant register date when upgrading to 5.15.

- **Misc translation 'ts' fixes
  ([14467](https://github.com/civicrm/civicrm-core/pull/14467))**

  Fixes a few places where `ts()` was used incorrectly so that is used correctly.

- **Don't run search when editing smartgroup criteria
  ([14464](https://github.com/civicrm/civicrm-core/pull/14464))**

  Ensures that editing smart group criteria does not trigger a search on that
  smartgroup before the criteria can be viewed.

- **Add angular-xeditable to angular
  ([14414](https://github.com/civicrm/civicrm-core/pull/14414))**

  Add angular xeditable component to our bower_components.

- **crmRouteBinder - Remove params from url if they equal their defaults
  ([14211](https://github.com/civicrm/civicrm-core/pull/14211))**

  Ensures when a parameter is removed in the api4 explorer, it is also removed
  from the url.

- **Remove wasteful double-caching of settings metadata
  ([14259](https://github.com/civicrm/civicrm-core/pull/14259))**

  Ensures that Settings metadata is cached once per domain and that
  `hook_civicrm_alterSettingsMetaData()` is invoked only once per domain.

- **Remove CIVICRM_TEMP_FORCE_UTF8; deprecate TempTable::setUtf8()
  ([14004](https://github.com/civicrm/civicrm-core/pull/14004))**

  Continues work to phase out CIVICRM_TEMP_FORCE_UTF8.

- **Stop overriding is_active default when saving new relationship
  ([14199](https://github.com/civicrm/civicrm-core/pull/14199))**

  Ensures that new relationships are saved as active by default.

- **Enotice fix on creating a smart group
  ([14180](https://github.com/civicrm/civicrm-core/pull/14180))**

  Fixes an E-notice `Notice: Undefined index: component_mode in
  CRM_Contact_Form_Task_SaveSearch->PreProcess()` when creating a smart group.

- **Ensure that the oldest creation date is preserved when deduping
  ([dev/core#996](https://lab.civicrm.org/dev/core/issues/996):
  [14368](https://github.com/civicrm/civicrm-core/pull/14368))**

- **Recurring activities don't carry over custom data and tags
  ([CRM-21832](https://issues.civicrm.org/jira/browse/CRM-21832), 
  [14183](https://github.com/civicrm/civicrm-core/pull/14183))**

- **Disabling Alphabetical Pager is not respected for events and contribution
  pages. ([dev/core#705](https://lab.civicrm.org/dev/core/issues/705):
  [14203](https://github.com/civicrm/civicrm-core/pull/14203))**

- **When creating relationship types don't munge names
  ([14216](https://github.com/civicrm/civicrm-core/pull/14216))**

- **CRM_Extension_System - Only allow `test.*` extensions during headless
  testing. Hide from regular users.
  ([14392](https://github.com/civicrm/civicrm-core/pull/14392))**

- **Fix name of cache key column to be all lower case rather than camel case in
  civicrm_prevnext_cache
  ([14359](https://github.com/civicrm/civicrm-core/pull/14359))**

- **Don't apply api3 pre/post processing to api4 actions
  ([14357](https://github.com/civicrm/civicrm-core/pull/14357))**

- **Fix fatal error when full group by mysql mode enabled & selecting contacts
  ([14331](https://github.com/civicrm/civicrm-core/pull/14331))**

- **Caches - Normalize dependency on php-cache integration-tests
  ([14423](https://github.com/civicrm/civicrm-core/pull/14423))**

- **Cache/IntegrationTests - Remove. This can be replaced by composer dependency
  ([255](https://github.com/civicrm/civicrm-packages/pull/255))**

## CiviCase

- **Case report showing 1 result
  ([dev/core#743](https://lab.civicrm.org/dev/core/issues/743):
  [14082](https://github.com/civicrm/civicrm-core/pull/14082))**

  Fixes the Case Summary report so that it properly filters on case
  relationships.

- **Set title properly on Move/Copy/File on Case popup
  ([14347](https://github.com/civicrm/civicrm-core/pull/14347))**

  Ensures when clicking "Move to Case"/"Copy to Case" from the Manage cases
  activity list the title is set correctly and stays set correctly instead of
  reverting to "File on Case".

- **Manage Case search filter "Deleted Activities" no longer working
  ([dev/core#1022](https://lab.civicrm.org/dev/core/issues/1022):
  [14445](https://github.com/civicrm/civicrm-core/pull/14445))**

  Fixes the search filter "Deleted Activities" on the Manage Cases form.

- **Closing a case gives a warning notice
  ([dev/core#896](https://lab.civicrm.org/dev/core/issues/896):
  [14160](https://github.com/civicrm/civicrm-core/pull/14160))**


## CiviContribute

- **Bug in storing settings for CiviContribute component
  ([dev/financial#54](https://lab.civicrm.org/dev/financial/issues/54):
  [14267](https://github.com/civicrm/civicrm-core/pull/14267))**

  Ensures deferred revenue settings are respected.

- **Changing financial type on a contribution records incorrect financial items
  ([dev/financial#56](https://lab.civicrm.org/dev/financial/issues/56):
  [14309](https://github.com/civicrm/civicrm-core/pull/14309))**

  Fixes a bug where changing the financial type on a contribution record would
  result in a sales tax row being added regardless of whether sales tax was
  turned on.

- **Fix financial ACL permissions to respect check_permissions
  ([14118](https://github.com/civicrm/civicrm-core/pull/14118))**

  Fixes bug where `check_permissions=0` is ignored when doing contribution.get
  in conjunction with financial ACLs.

- **Elavon payment processor seems to no longer accept url encoded emails
  ([dev/core#966](https://lab.civicrm.org/dev/core/issues/966):
  [14263](https://github.com/civicrm/civicrm-core/pull/14263))**

  Fixes payment processing for sites using an Elavon processor.

- **Set new inactive statuses as 'Chargeback' does not exist on new installs and
  that breaks Contributionrecur.create API
  ([14398](https://github.com/civicrm/civicrm-core/pull/14398))**

- **Fix inconsistent handling when searching contribution text fields
  ([14354](https://github.com/civicrm/civicrm-core/pull/14354))**

- **Fix bug where contribution status is mishandled if label is changed
  ([14352](https://github.com/civicrm/civicrm-core/pull/14352))**

## CiviEvent

- **Sorting participants ignored search values.
  ([dev/core#981](https://lab.civicrm.org/dev/core/issues/981):
  [14313](https://github.com/civicrm/civicrm-core/pull/14313))**

  Ensures when searching for participants for a specific event and then sorting
  the results the search parameters are respected, before this change all
  participants for all events would be displayed.

- **Fix deprecation notice on manage events page
  ([14289](https://github.com/civicrm/civicrm-core/pull/14289))**

  Removes a `User deprecated function: Deprecated function
  CRM_Event_BAO_Event::CheckPermission` notice from the manage events page.

- **Backoffice participant transfer form does not populate contact reference
  field ([dev/core#888](https://lab.civicrm.org/dev/core/issues/888):
  [14102](https://github.com/civicrm/civicrm-core/pull/14102))**

## CiviMail  

- **Deletion of SMS provider caused all scheduled reminders to fail to be sent
  (begins work for [dev/core#369](https://lab.civicrm.org/dev/core/issues/369):
  [14266](https://github.com/civicrm/civicrm-core/pull/14266))**

  Before this change if the Scheduled reminder job was triggered and there were
  active SMS scheduled reminders for which the SMS Provider has been deleted the
  job would fail with the message "Provider not known or not provided" and no
  scheduled reminders would go out this change makes it so that scheduled
  reminders for which a SMS Provider exists will go out even if there are some
  scheduled SMS reminders for which there is not an SMS Provider.

- **E_NOTICE when creating bulk SMS
  ([dev/core#1023](https://lab.civicrm.org/dev/core/issues/1023):
  [14449](https://github.com/civicrm/civicrm-core/pull/14449))**

  Fixes E_NOTICE `Notice: Undefined index: Subject in
  civicrm_api3_mailing_preview()` when creating bulk SMS.

- **"Confirm this subscription" URL generated by MailingEventSubscribe API
  should always be a front-end
  URL([dev/core#1005](https://lab.civicrm.org/dev/core/issues/1005):
  [14389](https://github.com/civicrm/civicrm-core/pull/14389))**

  Ensures that the "Confirm this subscription" URL included in bulk emails is
  always a front end URL.

- **SMTP help text is misleading - references the wrong admin screen
  ([dev/core#879](https://lab.civicrm.org/dev/core/issues/879):
  [14329](https://github.com/civicrm/civicrm-core/pull/14329))**

- **[Outbound mail admin form] fix some more notices resulting from recent
  change ([14433](https://github.com/civicrm/civicrm-core/pull/14433))**

## CiviPledge

- **incorrect capitalization in default Pledges - Acknowledgement message
  template ([dev/core#1010](https://lab.civicrm.org/dev/core/issues/1010):
  [14465](https://github.com/civicrm/civicrm-core/pull/14465) and
  [14469](https://github.com/civicrm/civicrm-core/pull/14469))**

  Ensures that Pledge acknowledgments use correct capitalization and the
  `email_greeting`.

- **correct syntax "IS NOT NULL" to get pledge payment count
  ([13374](https://github.com/civicrm/civicrm-core/pull/13374))**

  Ensures when editing a payment for a pledge the screen does not freeze because
  the API count returns 0.

## Drupal Integration

- **incorrect Drupal 8 login URL
  ([dev/core#898]https://lab.civicrm.org/dev/core/issues/898():
  [14138](https://github.com/civicrm/civicrm-core/pull/14138))**

  If you create a public contribution page on a Drupal 8 site, it will include a
  login link for unauthenticated users, with parameters ?destination=... to
  direct back to the contribution page after login. Fixes this link for
  recent Drupal versionsso it points to the right login url.

- **Drupal8: Implement set UF locale/language (affects mailing tokens)
  ([dev/drupal#19](https://lab.civicrm.org/dev/drupal/issues/19):
  [14302](https://github.com/civicrm/civicrm-core/pull/14302) and
  [12152](https://github.com/civicrm/civicrm-core/pull/12152))**

  Fixes a 500 error when calling the REST API endpoint in Drupal 8 and fixes a
  bug when using Drupal 8 with a multilingual site where mailing token links
  were not taking the user to the page in the expected language.

- **Drupal8/jquery
  ([dev/drupal#68](https://lab.civicrm.org/dev/drupal/issues/68):
  [14442](https://github.com/civicrm/civicrm-core/pull/14442))**

  Fixes a Javascript error if Drupal's jQuery is not loaded (when its not
  needed).

- **Fix legacy IPN endpoint for Drupal
  ([dev/core#973](https://lab.civicrm.org/dev/core/issues/973):
  [14272](https://github.com/civicrm/civicrm-core/pull/14272))**

  Fixes a `PHP Fatal error:  Uncaught Error: Call to undefined function
  variable_get()` error when bootstraping Drupal for Drupal sites collecting
  recurring PayPal donations.

- **Don't call session_start() before CMS bootstrap (PHP 7.2 compat)
  ([14074](https://github.com/civicrm/civicrm-core/pull/14074))**

  Fixes a `Warning: ini_set(): A session is active` error for Drupal sites
  running PHP > 7.1.

## Joomla Integration

- **Fix php warning when viewing profiles
  ([dev/joomla#11](https://lab.civicrm.org/dev/joomla/issues/11):
  [14312](https://github.com/civicrm/civicrm-core/pull/14312))**

## <a name="misc"></a>Miscellany

- **Declare API Key as a protected field for future use
  ([14274](https://github.com/civicrm/civicrm-core/pull/14274))**

- **Make apiRequst nextId accessible for api4 constructor
  ([14311](https://github.com/civicrm/civicrm-core/pull/14311))**

- **Remove confusing pass params by ref
  ([14360](https://github.com/civicrm/civicrm-core/pull/14360))**

- **Add EntityPageTrait
  ([14399](https://github.com/civicrm/civicrm-core/pull/14399))**

- **[code-quality] [jcalendar] remove jcalendar usage from
  participant_register_date on event search
  ([14330](https://github.com/civicrm/civicrm-core/pull/14330))**

- **Deprecate creating recipients from MailingJob.create.
  ([14097](https://github.com/civicrm/civicrm-core/pull/14097))**

- **Fix running of CRM_Utils_MoneyTest on PHPUnit6+
  ([14424](https://github.com/civicrm/civicrm-core/pull/14424))**

- **Remove broken delete from customGroupCreate
  ([14239](https://github.com/civicrm/civicrm-core/pull/14239))**

- **Remove duplicate line in case BAO
  ([14345](https://github.com/civicrm/civicrm-core/pull/14345))**

- **Switch to calling Payment.create api when processing a refund from
  AdditionalPayment form
  ([14317](https://github.com/civicrm/civicrm-core/pull/14317))**

- **Updating contact (with no email) via import adding email doesn't set email
  as primary (adds test for
  [dev/core#953](https://lab.civicrm.org/dev/core/issues/953):
  [14225](https://github.com/civicrm/civicrm-core/pull/14225))**

- **Cancel first contribution associated to membership, cancels the membership
  (preliminary work for
  [dev/core#927](https://lab.civicrm.org/dev/core/issues/927):
  [14197](https://github.com/civicrm/civicrm-core/pull/14197))**

- **Searching for removed contacts in a smart group doesn't work (preliminary
  work for [dev/core#926](https://lab.civicrm.org/dev/core/issues/926):
  [14181](https://github.com/civicrm/civicrm-core/pull/14181))**

- **When using custom fields for smart group criteria with relative dates the
  group does not respect the relative date over time (preliminary work for
  [dev/core#389](https://lab.civicrm.org/dev/core/issues/389)[14401]:
  (https://github.com/civicrm/civicrm-core/pull/14401) and
  [14386](https://github.com/civicrm/civicrm-core/pull/14386))**

- **Remove instances of $dao->free
  ([dev/core#562](https://lab.civicrm.org/dev/core/issues/562):
  [14179](https://github.com/civicrm/civicrm-core/pull/14179))**

- **Correct syntax for Get pledge payment count (extend test coverage for
  [dev/core#627](https://lab.civicrm.org/dev/core/issues/627):
  [14350](https://github.com/civicrm/civicrm-core/pull/14350))**

- **Remove never-called function
  _civicrm_api3_deprecated_contact_check_custom_params
  ([14341](https://github.com/civicrm/civicrm-core/pull/14341))**

- **IDE re-format of tools directory
  ([14177](https://github.com/civicrm/civicrm-core/pull/14177))**

- **Unit test for FGB error in #14331
  ([14340](https://github.com/civicrm/civicrm-core/pull/14340))**

- **Test tweaks that *might* help with intermittant test weirdness
  ([14458](https://github.com/civicrm/civicrm-core/pull/14458))**

- **[TEST SUITE] Remove some use of dbunit from tests
  ([14271](https://github.com/civicrm/civicrm-core/pull/14271))**

- **Test cleanup to remove references to discontinued package dbunit
  ([14276](https://github.com/civicrm/civicrm-core/pull/14276))**

- **[dbunit test] remove dbunit dependency
  ([14328](https://github.com/civicrm/civicrm-core/pull/14328))**

- **Add unit test for merge handling on custom data.
  ([14310](https://github.com/civicrm/civicrm-core/pull/14310))**

- **Fix test / possible live error on submitting credit card renewals
  ([14316](https://github.com/civicrm/civicrm-core/pull/14316))**

- **Update testGetActivityAccessCiviCRMEnough test for clarity
  ([14226](https://github.com/civicrm/civicrm-core/pull/14226))**

- **[REF] Move retrieval of basicSearchFields to 'get' fn
  ([14476](https://github.com/civicrm/civicrm-core/pull/14476))**

- **[REF] Remove input format function from deprecated utils to the only place
  that calls it ([14342](https://github.com/civicrm/civicrm-core/pull/14342))**

- **[REF] extract isLiveMode
  ([14336](https://github.com/civicrm/civicrm-core/pull/14336))**

- **[REF] use generic loadStandardSearchOptionsFromUrl
  ([14338](https://github.com/civicrm/civicrm-core/pull/14338))**

- **[REF] Extract function to get cached duplicate matches
  ([14324](https://github.com/civicrm/civicrm-core/pull/14324))**

- **[REF] minor code re-org
  ([14318](https://github.com/civicrm/civicrm-core/pull/14318))**

- **[REF] Remove extraneous variable
  ([14261](https://github.com/civicrm/civicrm-core/pull/14261))**

- **[REF] Centralize logic for resolving settings pseudoconstants
  ([14264](https://github.com/civicrm/civicrm-core/pull/14264))**

- **[REF] Super Minor code readability fix
  ([14258](https://github.com/civicrm/civicrm-core/pull/14258))**

- **[REF] Move copyCustomFields function from Event to Core_DAO for
  re-usablibilty ([14171](https://github.com/civicrm/civicrm-core/pull/14171))**

- **[REF] Remove reference symbol from 2 variables
  ([14270](https://github.com/civicrm/civicrm-core/pull/14270))**

- **[cleanup] Remove deprecated pattern &CRM_Core_Config::singleton()
  ([14178](https://github.com/civicrm/civicrm-core/pull/14178))**

- **[REF] Refactor to reduce duplication on payment forms
  ([14206](https://github.com/civicrm/civicrm-core/pull/14206))**

- **[REF+ test] start process of cleaning up payment activity handling
  ([14198](https://github.com/civicrm/civicrm-core/pull/14198))**

- **[REF][Test] Remove call to
  CRM_Contribute_BAO_Contribution::recordAdditionalPayment in favour of payment
  create ([14137](https://github.com/civicrm/civicrm-core/pull/14137))**

- **[REF+test] clean up code for getting labels for merge screen, stdise
  ([14260](https://github.com/civicrm/civicrm-core/pull/14260))**

- **[REF] Simplify ACL page template
  ([14288](https://github.com/civicrm/civicrm-core/pull/14288))**

- **[REF] Fix pointless use of CRM_Utils_Array::value in Campaign BAO
  ([14300](https://github.com/civicrm/civicrm-core/pull/14300))**

- **[code-cleanup] remove orderBy param from getDuplicatePairs, it is not used
  ([14297](https://github.com/civicrm/civicrm-core/pull/14297))**

- **[REF] extract buildGroupTree function
  ([14303](https://github.com/civicrm/civicrm-core/pull/14303))**

- **[REF] Test class cleanup - Extract function to create nuanced custom fields
  to a trait ([14301](https://github.com/civicrm/civicrm-core/pull/14301))**

- **[REF] Cleanup input & output on paymentActivityCreate & improve test
  ([14269](https://github.com/civicrm/civicrm-core/pull/14269))**

- **[REF] move calculation of migrationInfo into the function that uses it
  ([14365](https://github.com/civicrm/civicrm-core/pull/14365))**

- **[REF] extract buildClause from CRM_Report_Form_Event_Income
  ([14098](https://github.com/civicrm/civicrm-core/pull/14098))**

- **[REF] Activity Summary report - move temp table generation etc from
  postProcess to buildQuery, remove postProcess, don't skip in unit tests
  ([14375](https://github.com/civicrm/civicrm-core/pull/14375))**

- **[REF] Activity form - very minor tidy up
  ([14434](https://github.com/civicrm/civicrm-core/pull/14434))**

- **[REF] Stop passing cacheKey to refillCache
  ([14337](https://github.com/civicrm/civicrm-core/pull/14337))**

- **[REF] dev/core#998 make processDupes testable & add test
  ([14370](https://github.com/civicrm/civicrm-core/pull/14370))**

- **[REF] Remove reference to 'changePaymentInstrument' from
  updateFinancialAccounts as never passed in
  ([14353](https://github.com/civicrm/civicrm-core/pull/14353))**

- **[NFC][test-fix] centralise use of assertLike for comparing sql
  ([14470](https://github.com/civicrm/civicrm-core/pull/14470))**

- **[nfc] [test] Skip testGetFromTo on date transition
  ([14472](https://github.com/civicrm/civicrm-core/pull/14472))**

- **[NFC] Fix issue with Job Manager Test giving out a warning
  ([14327](https://github.com/civicrm/civicrm-core/pull/14327))**

- **[NFC] Fix comment block for variable declarations
  ([14314](https://github.com/civicrm/civicrm-core/pull/14314))**

- **(NFC) Update node package versions to latest ones
  ([14087](https://github.com/civicrm/civicrm-core/pull/14087))**

- **[NFC] Update civicrm_generated data file following addition of contri…
  ([14371](https://github.com/civicrm/civicrm-core/pull/14371))**

- **(NFC) Remove without param tests
  ([14454](https://github.com/civicrm/civicrm-core/pull/14454))**

- **[NFC] PHPCS fixes.
  ([14402](https://github.com/civicrm/civicrm-core/pull/14402))**

- **[NFC] Update package-lock and civicrm_generated to fix langague issues
  ([14385](https://github.com/civicrm/civicrm-core/pull/14385))**

- **[NFC] phpdoc cleanup
  ([14335](https://github.com/civicrm/civicrm-core/pull/14335))**

- **[NFC] Fix variable types in DAO doc blocks
  ([14294](https://github.com/civicrm/civicrm-core/pull/14294))**

- **[NFC] fix docblock types from boolean to bool
  ([14296](https://github.com/civicrm/civicrm-core/pull/14296))**

- **[NFC] array formatting in CRM_Dedupe_MergerTest
  ([14273](https://github.com/civicrm/civicrm-core/pull/14273))**

- **[NFC] Update Language to be more user friendly when checking logs
  ([14278](https://github.com/civicrm/civicrm-core/pull/14278))**

- **[NFC] array formatting, some comments
  ([14291](https://github.com/civicrm/civicrm-core/pull/14291))**

- **[NFC] fix comment blocks capitalising null
  ([14306](https://github.com/civicrm/civicrm-core/pull/14306))**

- **[NFC] fix more places where var is declared as boolean rather than bool
  ([14305](https://github.com/civicrm/civicrm-core/pull/14305))**

- **[NFC] formatting & comment fixes - Regenerate DAO files
  ([14304](https://github.com/civicrm/civicrm-core/pull/14304))**

- **[NFC] ProfileTest class - formatting & general cleanup
  ([14282](https://github.com/civicrm/civicrm-core/pull/14282))**

- **[NFC] Add trailing comma to pseudoconstant array in DAOs
  ([14295](https://github.com/civicrm/civicrm-core/pull/14295))**

- **[NFC] array formatting in api_v3_paymentTest class
  ([14451](https://github.com/civicrm/civicrm-core/pull/14451))**

- **[NFC] Update Exception DAO class
  ([14482](https://github.com/civicrm/civicrm-core/pull/14482))**

- **[NFC] Further tests tidy up following removing of dbunit
  ([14344](https://github.com/civicrm/civicrm-core/pull/14344))**

- **[NFC] Docblock fixes
  ([14323](https://github.com/civicrm/civicrm-core/pull/14323))**

- **NFC Fix DAO Style issues
  ([14307](https://github.com/civicrm/civicrm-core/pull/14307))**

- **[NFC] reformat UFFieldTest
  ([14308](https://github.com/civicrm/civicrm-core/pull/14308))**

- **contributor-keys file - jira/lab.c.o username fix
  ([14200](https://github.com/civicrm/civicrm-core/pull/14200))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt, Eli Lisseck; Agileware - Francis
Whittle; Australian Greens - Seamus Lee; Business & Code - Alain Benbassat;
Christian Wach; Circle Interactive - Dave Jenkins; CiviCRM - Coleman Watts, Tim
Otten; CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy, Samuel
Vanhove; Dave D; Electronic Frontier Foundation - Mark Burdett; Francesc Bassas
i Bullich; Fuzion - Jitendra Purohit; iXiam - Vangelis Pantazis; JMA Consulting -
Monish Deb; Just Hope - Phil Morice Brubaker; Megaphone Technology Consulting -
Jon Goldberg; MJW Consulting - Matthew Wire; Onyemenam Ndubuisi; Pradeep
Nayak; Progressive Technology Project - Jamie McClelland; Stephen Palmstrom;
Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Artful Robot - Rich Lott; Blackfly Solutions - Alan
Dixon; CEDC - Laryn Kragt Bakker; Chris Burgess; CiviCoop - Jaap Jansma;
Centrale Organisatie van Voetbal Scheidsrechters (COVS) - Ed van Leeuwen; Fuzion -
Luke Stewart; gareth-circle; Greenpeace CEE - Patrick Figel; JMA Consulting -
Joe Murray; John Kingsnorth; John Kyle Cronan; Joinery - Allen Shaw; Lighthouse
Design and Consulting - Brian Shaughnessy; myDropWizard - David Snopek; Nicol
Wistreich; Webstanz - Adelson;

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
