# CiviCRM 5.37.0

Released May 5, 2021

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Improve quicksearch result presentation to enable browser link functions
  ([19779](https://github.com/civicrm/civicrm-core/pull/19779))**

  The results in the quick search in the menu bar now appear as actual links.
  Clicking an item acts the same as before, but you can now ctrl-click or
  right-click for advanced functions in your browser (such as to open the link
  in a new tab or window).

- **Add new super-duper-no-permissions-apply permission
  ([19797](https://github.com/civicrm/civicrm-core/pull/19797))**

  A new permission, "Administer all of CiviCRM", is established as a super-duper
  permission that implicitly has all other CiviCRM permissions.  This is much
  like how a Drupal user with the ID 1 has all permissions, even if they're not
  individually granted.

- **AngularJS - Allow loading multiple apps on a single page
  ([19922](https://github.com/civicrm/civicrm-core/pull/19922))**

  Allows multiple Angular apps to run on a single page. For example, you
  might display 2x Angular-based tabs, 3x Angular-based WP shortcodes, or 4x
  Angular-based Drupal blocks.

- **Support mobile devices on public forms
  ([dev/user-interface#35](https://lab.civicrm.org/dev/user-interface/-/issues/35):
  [19968](https://github.com/civicrm/civicrm-core/pull/19968))**

  Improves user experience for mobile users on public forms by making labels
  appear above inputs on small screens.

- **info.xml - Allow PSR-0 style class-loader declarations
  ([19870](https://github.com/civicrm/civicrm-core/pull/19870))**

  Makes it so extensions may setup classloading in info.xml.

- **We should not be auto-generating 5.xx.beta1.mysql.tpl files
  ([dev/release#16](https://lab.civicrm.org/dev/release/-/issues/16):
  [19743](https://github.com/civicrm/civicrm-core/pull/19743))**

  Makes it possible to skip upgrader increments which do not actually require DB
  updates.

- **Adjust weights on activity contact record types
  ([dev/core#2442](https://lab.civicrm.org/dev/core/-/issues/2442):
  [19992](https://github.com/civicrm/civicrm-core/pull/19992) and
  [19987](https://github.com/civicrm/civicrm-core/pull/19987))**

  Improves user experience by making the default Activity Contact Record type
  "Activity Target".

- **The mailings screen is very slow to load when there are many campaigns in
  the database ([dev/core#2451](https://lab.civicrm.org/dev/core/-/issues/2451):
  [19766](https://github.com/civicrm/civicrm-core/pull/19766))**

  Improves processing of option groups in select2 elements.

- **Reorganize contact summary template to support non-ajax tabs
  ([19875](https://github.com/civicrm/civicrm-core/pull/19875))**

  Adds hook support for non-ajax contact summary tabs.

- **Feature Request: API endpoint to trigger rebuild paths
  ([dev/core#2458](https://lab.civicrm.org/dev/core/-/issues/2458):
  [19795](https://github.com/civicrm/civicrm-core/pull/19795))**

  Adds an API to trigger rebuilding paths.

- **Add job to cleanup acl_cache table, add setting to disable opportunistic
  flushing ([dev/core#2477](https://lab.civicrm.org/dev/core/-/issues/2477):
  [19930](https://github.com/civicrm/civicrm-core/pull/19930))**

  Adds a scheduled job to cleanup acl_cache table (like for smart groups).

- **APIv4 entity parity
  ([dev/core#2486](https://lab.civicrm.org/dev/core/-/issues/2486):
  [19932](https://github.com/civicrm/civicrm-core/pull/19932),
  [19933](https://github.com/civicrm/civicrm-core/pull/19933) and
  [19931](https://github.com/civicrm/civicrm-core/pull/19931))**

  Moves towards APIv4 entity parity by adding the following entities: "Payment
  Token", "Batch" and "Entity Financial trxn".

- **APIv4 - Add CiviCase, CaseType, CaseContact entities
  ([19907](https://github.com/civicrm/civicrm-core/pull/19907), followed up by
  [dev/core#2573](https://lab.civicrm.org/dev/core/-/issues/2573):
  [20174](https://github.com/civicrm/civicrm-core/pull/20174))**

  Adds support for CiviCase entities to APIv4.

- **Add FinancialTrxn APIv4
  ([19918](https://github.com/civicrm/civicrm-core/pull/19918))**

  Adds support for FinancialTrxn to APIv4.

- **Afform - Add submit actions (Work Towards
  [dev/core#2522](https://lab.civicrm.org/dev/core/-/issues/2522):
  [20018](https://github.com/civicrm/civicrm-core/pull/20018) and
  [20147](https://github.com/civicrm/civicrm-core/pull/20147))**

  Adds in a submit handler and redirect after submit for afform.

- **Add 'readonly' attribute to fields in schema
  ([dev/core#2397](https://lab.civicrm.org/dev/core/-/issues/2397):
  [19751](https://github.com/civicrm/civicrm-core/pull/19751) and
  [19778](https://github.com/civicrm/civicrm-core/pull/19778))**

  Adds metadata to schema to tell SearchKit and Afform which fields are
  appropriate to show to the user.

- **SearchKit - Add "in-place edit" feature
  ([19765](https://github.com/civicrm/civicrm-core/pull/19765))**

  Adds a new feature "in-place edit" to search displays.

- **SearchKit - Exposed join filters
  ([dev/core#2494](https://lab.civicrm.org/dev/core/-/issues/2494):
  [19984](https://github.com/civicrm/civicrm-core/pull/19984))**

  Improves SearchKit generated SQL joins.

- **SearchKit - Support implied operators in exposed search forms
  ([19959](https://github.com/civicrm/civicrm-core/pull/19959))**

  Improves SearchKit by adding support for "Multi-Select" and "Search by range"
  exposed filters.

- **Expose mapping search task to Search Kit
  ([19561](https://github.com/civicrm/civicrm-core/pull/19561))**

  Exposes Contact Mapping task to SearchKit.

- **Add created_id & modified_id to civicrm_saved_search
  ([dev/core#2422](https://lab.civicrm.org/dev/core/-/issues/2422):
  [19892](https://github.com/civicrm/civicrm-core/pull/19892))**

   Adds created & modified info to SavedSearch listing in SearchKit.

- **SearchKit - Include custom group title with custom field label
  ([19856](https://github.com/civicrm/civicrm-core/pull/19856))**

  Adds Custom Group title when display custom fields. This makes it easier to
  tell custom fields apart in SearchKit when they have similar names to core or
  other custom fields.

- **Afform GUI - Improve drag-n-drop and add link to edit search
  ([19935](https://github.com/civicrm/civicrm-core/pull/19935))**

  This adds a few UI improvements to Afform, making drag-n-drop smoother and
  adding a configuration option to edit saved searches.

- **Afform - Add support for email tokens `{afform.myFormUrl}`
  ([19660](https://github.com/civicrm/civicrm-core/pull/19660))**

  Adds support for Afform email tokens ex: "My public form (Full Hyperlink)" and
  "My public form (URL)".

- **Embed afforms & search displays on contact summary screen as blocks and tabs
  ([19887](https://github.com/civicrm/civicrm-core/pull/19887))**

  Enables the creation of blocks and tabs on the contact summary screen,
  using Afform & SearchKit.

- **Phpunit 8 support - add void to setup
  ([19974](https://github.com/civicrm/civicrm-core/pull/19974),
  [19921](https://github.com/civicrm/civicrm-core/pull/19921),
  [19898](https://github.com/civicrm/civicrm-core/pull/19898),
  [19901](https://github.com/civicrm/civicrm-core/pull/19901),
  [19905](https://github.com/civicrm/civicrm-core/pull/19905),
  [19899](https://github.com/civicrm/civicrm-core/pull/19899),
  [19925](https://github.com/civicrm/civicrm-core/pull/19925),
  [19909](https://github.com/civicrm/civicrm-core/pull/19909) and
  [19900](https://github.com/civicrm/civicrm-core/pull/19900))**

  Work towards supporting PHPunit8.

- **Create reCAPTCHA core extension
  ([19967](https://github.com/civicrm/civicrm-core/pull/19967))**

  Moves reCAPTCHA from core to a core extension.

- **Include the timezone for date values in the Activity iCal
  ([19770](https://github.com/civicrm/civicrm-core/pull/19770))**

  Ensures the timezone is specified for the start date value in the Activity
  iCal.

### CiviContribute

- **Add entity financial account bridge entity
  ([19927](https://github.com/civicrm/civicrm-core/pull/19927))**

  Adds a new entity 'EntityFinancialAccount'.

- **Enable translation for Contribution Ordinality options on Contribution
  Detail Report ([19771](https://github.com/civicrm/civicrm-core/pull/19771))**

  Improves translation on the Contribution Detail Report.

- **Enable translation for Contribution Ordinality options on Member
  Contribution Detail Report
  ([19772](https://github.com/civicrm/civicrm-core/pull/19772))**

  Improves translation on the Member Contribution Detail Report.

### CiviEvent

- **Include the timezone for date values in the Event iCal
  ([19762](https://github.com/civicrm/civicrm-core/pull/19762))**

  Ensures the timezone is specified for the start date value in the Event
  iCal.

### CiviMail

- **MessageTemplates - Convert token processing to use `TokenProcessor`
  ([19550](https://github.com/civicrm/civicrm-core/pull/19550))**

  Improves token processing (resulting in some different token processing).

- **Align most of the tokens in the `TokenProcessor` handling with the legacy
  handling ([19806](https://github.com/civicrm/civicrm-core/pull/19806) and
  [19863](https://github.com/civicrm/civicrm-core/pull/19863))**

  Aligns new token processing with legacy token processing handling and moves
  towards deprecating the Mailing_BAO classes in favor of flexmailer.

- **Upgrader - Display note about token formatting
  ([19920](https://github.com/civicrm/civicrm-core/pull/19920))**

  Improves communications about tokens that may generate different output after
  token processing changes made in this release.

### WordPress Integration

- **Cannot create a WordPress account from the Contact record
  ([dev/wordpress#82](https://lab.civicrm.org/dev/wordpress/-/issues/82):
  [18982](https://github.com/civicrm/civicrm-core/pull/18982))**

  Adds support for creating WordPress accounts from the contact record.

- **Afform - Support embedding forms via WP shortcodes.
  ([19687](https://github.com/civicrm/civicrm-core/pull/19687))**

  Adds the ability to embed Afform forms using WordPress shortcodes.

- **Allow shortcodes to be rendered without invoking Civi page
  ([244](https://github.com/civicrm/civicrm-wordpress/pull/244))**

  Allows CiviCRM core and extensions to supply content for shortcodes without
  rendering a page; they can simply implement civicrm_shortcode_get_markup and
  return the content.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Unable to send individual email with attachment and 3+ recipients
  ([dev/core#2588](https://lab.civicrm.org/dev/core/-/issues/2588): [20222](https://github.com/civicrm/civicrm-core/pull/20222), [20227](https://github.com/civicrm/civicrm-core/pull/20227))**

- **Search Kit terminology and help
  ([dev/report#58](https://lab.civicrm.org/dev/report/-/issues/58):
  [20033](https://github.com/civicrm/civicrm-core/pull/20033))**

  Renames 'Filters' to 'Having' in the SearchKit UI  which is clearer for users
  familiar with SQL terms.

- **Address location type search errors when using a search profile
  ([dev/report#59](https://lab.civicrm.org/dev/report/-/issues/59):
  [19764](https://github.com/civicrm/civicrm-core/pull/19764))**

  Fixes a "DB Error: no such field" when using Advanced Search with a profile
  used as a search view.

- **civicrm_saved_search FK in civicrm_group should be ON DELETE CACSCADE
  ([dev/core#1845](https://lab.civicrm.org/dev/core/-/issues/1845):
  [19312](https://github.com/civicrm/civicrm-core/pull/19312))**

  Change FK on civicrm_group to delete the associated group if a saved search is
  deleted.

- **Schema - Add readonly to all fields in RelationshipCache entity
  ([19908](https://github.com/civicrm/civicrm-core/pull/19908))**

  Ensures SearchKit understands that Relationship Cache fields are not editable.

- **Skip UFField.field_name on singleValueAlter as flakey
  ([19895](https://github.com/civicrm/civicrm-core/pull/19895))**

  Fixes a recurring test fail.

- **Return from getACLRoles when contactID is not null
  ([19871](https://github.com/civicrm/civicrm-core/pull/19871))**

  Code Cleanup.

- **Add .clear class to break inline flow on social share footer
  ([19829](https://github.com/civicrm/civicrm-core/pull/19829))**

  Fixes the display of the social share footer for some sites with front end
  theme conflicts.

- **Enable & do single field metadata conversion for defaultContactCountry
  ([19697](https://github.com/civicrm/civicrm-core/pull/19697))**

  Ensures the template for defaultContactCountry uses metadata for the field.

- **Activity contact is null challenge
  ([dev/core#2438](https://lab.civicrm.org/dev/core/-/issues/2438):
  [19825](https://github.com/civicrm/civicrm-core/pull/19825))**

  Fixes the ability to do "Without" conditions in SearchKit when a bridge table
  is used (e.g. EntityTag or RelationshipCache).

- **Northern Ireland / Wales counties are out of date
  ([dev/core#2027](https://lab.civicrm.org/dev/core/-/issues/2027):
  [19802](https://github.com/civicrm/civicrm-core/pull/19802))**

  Fix state/province abbreviation for Carmarthenshire.

- **Add created_date column to the civicrm_note table
  ([dev/core#2243](https://lab.civicrm.org/dev/core/-/issues/2243):
  [19738](https://github.com/civicrm/civicrm-core/pull/19738))**

  Adds a created date to notes.

- **SearchKit request - aggregate without group by
  ([dev/core#2415](https://lab.civicrm.org/dev/core/-/issues/2415):
  [19755](https://github.com/civicrm/civicrm-core/pull/19755))**

  Adds API support for aggregate without group by.

- **Can't export link custom fields
  ([dev/core#2466](https://lab.civicrm.org/dev/core/-/issues/2466):
  [19839](https://github.com/civicrm/civicrm-core/pull/19839))**

  Ensures users can export custom fields of the type link with a length above
  around 110 chars.

- **Deprecated function Redis::delete()
  ([dev/core#2468](https://lab.civicrm.org/dev/core/-/issues/2468):
  [19830](https://github.com/civicrm/civicrm-core/pull/19830))**

  Removes deprecated function.

- **(APIv3, APIv4) OptionValue.create and OptionValue.update: Setting the default
  value (is_default=1) ignores domain ID
  ([dev/core#2488](https://lab.civicrm.org/dev/core/-/issues/2488):
  [19970](https://github.com/civicrm/civicrm-core/pull/19970))**

  Ensures when setting the default optionValue thru the API (versions 3 and 4)
  the query is limited to the specified domain.

- **Regression dedupe threshold
  ([dev/core#2498](https://lab.civicrm.org/dev/core/-/issues/2498):
  [20071](https://github.com/civicrm/civicrm-core/pull/20071))**

  Ensures dedupe rule threshold validation works correctly.

- **SearchKit - Flush Angular cache when saving
  ([20031](https://github.com/civicrm/civicrm-core/pull/20031))**

  Fixes caching issue for search displays embedded in Afforms (as pages,
  dashlets, tabs, blocks, etc).

- **APIv4 - Standardize generic entity name resolution
  ([19889](https://github.com/civicrm/civicrm-core/pull/19889))**

  APIv4 code cleanup to enable the addition of a Case API.

- **Upgrade error
  ([dev/core#2528](https://lab.civicrm.org/dev/core/-/issues/2528):
  [20066](https://github.com/civicrm/civicrm-core/pull/20066))**

  Fixes an `(errno: 121 "Duplicate key on write or update")` when upgrading from
  5.35 - 5.37.

- **Exporting in localized civicrm crashes due to long translations in columns
  T_Boolean ([dev/core#2164](https://lab.civicrm.org/dev/core/-/issues/2164):
  [19963](https://github.com/civicrm/civicrm-core/pull/19963))**

- **Scheduled Reminder fails to send if From Name includes comma
  ([dev/core#2226](https://lab.civicrm.org/dev/core/-/issues/2226):
  [19603](https://github.com/civicrm/civicrm-core/pull/19603))**

- **The civicrm_alterReportVar hook is not working for contribute detail report
  ([dev/core#2285](https://lab.civicrm.org/dev/core/-/issues/2285):
  [19317](https://github.com/civicrm/civicrm-core/pull/19317))**

- **Some API calls no longer give an error when e.g. a database error happens
  ([dev/core#2364](https://lab.civicrm.org/dev/core/-/issues/2364):
  [131](https://github.com/civicrm/civicrm-backdrop/pull/131))**

- **PHP 7.4 - get_magic_quotes_gpc() deprecated in IDS_Monitor
  ([dev/core#2366](https://lab.civicrm.org/dev/core/-/issues/2366):
  [315](https://github.com/civicrm/civicrm-packages/pull/315) and
  [19851](https://github.com/civicrm/civicrm-core/pull/19851))**

- **Contact custom data date field not working in scheduled reminder
  ([dev/core#2383](https://lab.civicrm.org/dev/core/-/issues/2383):
  [19628](https://github.com/civicrm/civicrm-core/pull/19628))**

- **Add hook support for Activity Contact ([dev/core#2390](dev/core#2390):
  [19828](https://github.com/civicrm/civicrm-core/pull/19828))**

- **Wrong event fee shown in CiviCRM
  ([dev/core#2447](https://lab.civicrm.org/dev/core/-/issues/2447):
  [19810](https://github.com/civicrm/civicrm-core/pull/19810))**

- **Changing a custom field from multiple choice to Text breaks the API
  ([dev/core#2459](https://lab.civicrm.org/dev/core/-/issues/2459):
  [19794](https://github.com/civicrm/civicrm-core/pull/19794))**

- **Boolean custom values can't be of type boolean
  ([dev/core#2461](https://lab.civicrm.org/dev/core/-/issues/2461):
  [19805](https://github.com/civicrm/civicrm-core/pull/19805))**

- **Feature to file emails on multiple case ids provided in the url not working
  ([dev/core#2463](https://lab.civicrm.org/dev/core/-/issues/2463):
  [19873](https://github.com/civicrm/civicrm-core/pull/19873) and
  [19826](https://github.com/civicrm/civicrm-core/pull/19826))**

- **SearchBuilder: contact search for tags with child-tags broken when using '='
  operator ([dev/core#2502](https://lab.civicrm.org/dev/core/-/issues/2502):
  [19961](https://github.com/civicrm/civicrm-core/pull/19961))**

- **CiviReport does not localize custom fields of type Money
  ([dev/core#2503](https://lab.civicrm.org/dev/core/-/issues/2503):
  [19962](https://github.com/civicrm/civicrm-core/pull/19962))**

- **SearchKit - remove extra irrelevant fields from bridge joins
  ([19868](https://github.com/civicrm/civicrm-core/pull/19868))**

- **SearchKit - Fix broken export action
  ([20003](https://github.com/civicrm/civicrm-core/pull/20003))**

- **SearchKit - remove unused smartGroup code
  ([19752](https://github.com/civicrm/civicrm-core/pull/19752))**

- **SearchKit - Refactor loading actions list & support custom fields for groups
  ([19783](https://github.com/civicrm/civicrm-core/pull/19783))**

- **APIv4 Explorer - Prevent long results from breaking layout
  ([19853](https://github.com/civicrm/civicrm-core/pull/19853))**

- **APIv4 - Code cleanup & improve links to @see annotations in Explorer
  ([19798](https://github.com/civicrm/civicrm-core/pull/19798))**

- **APIv4 Explorer - Fix layout in code tab
  ([19734](https://github.com/civicrm/civicrm-core/pull/19734))**

- **APIv4 - Prevent API adding default join conditions when it shouldn't
  ([19993](https://github.com/civicrm/civicrm-core/pull/19993))**

- **Fix APIv4 test sloppiness
  ([19754](https://github.com/civicrm/civicrm-core/pull/19754))**

- **APIv4 - Fix GetActions function to work with entityNames that don't match
  className ([19896](https://github.com/civicrm/civicrm-core/pull/19896))**

- **APIv4 - Add function to get API class name
  ([19867](https://github.com/civicrm/civicrm-core/pull/19867))**

- **Afform - Refresh assetBuilder when saving a form
  ([19998](https://github.com/civicrm/civicrm-core/pull/19998))**

- **Afform - Fix endless spinner on "New Search Display" dropdown
  ([19997](https://github.com/civicrm/civicrm-core/pull/19997))**

- **Fix issues with "Create User Record" process
  ([20057](https://github.com/civicrm/civicrm-core/pull/20057))**

- **Fix entity-ref search by id & update search prompt
  ([20050](https://github.com/civicrm/civicrm-core/pull/20050))**

- **Soft credit fails when membership is created using backend form
  ([20025](https://github.com/civicrm/civicrm-core/pull/20025))**

- **Rename 'Misc' menu item machine name to a safe string
  ([19996](https://github.com/civicrm/civicrm-core/pull/19996))**

- **replaceOrgTokens: Remove broken code
  ([19543](https://github.com/civicrm/civicrm-core/pull/19543))**

- **E-notice fix on serialized setting
  ([19969](https://github.com/civicrm/civicrm-core/pull/19969))**

- **Pledge - Fix re-calculation of payment dates
  ([19990](https://github.com/civicrm/civicrm-core/pull/19990))**

- **Fix scrollbars on fullscreen dashboard dashlet
  ([19981](https://github.com/civicrm/civicrm-core/pull/19981))**

- **Only call getGroupACLRoles if contactID is present
  ([19894](https://github.com/civicrm/civicrm-core/pull/19894))**

- **Stop passing html to crmMoney
  ([19941](https://github.com/civicrm/civicrm-core/pull/19941))**

- **Fix to avoid passing non-money to money::format
  ([19940](https://github.com/civicrm/civicrm-core/pull/19940))**

- **Fix ts() namespace in searchKit & afform extensions
  ([19729](https://github.com/civicrm/civicrm-core/pull/19729))**

- **Fix for dedupe error under some mysql configs
  ([19818](https://github.com/civicrm/civicrm-core/pull/19818))**

- **Fix loop ([19858](https://github.com/civicrm/civicrm-core/pull/19858))**

- **Export UI - Only present "save mapping" button to permissioned users
  ([19733](https://github.com/civicrm/civicrm-core/pull/19733))**

- **Update SocialNetwork.tpl Twitter Intent URL
  ([19724](https://github.com/civicrm/civicrm-core/pull/19724))**

- **Prevent pages and metabox from loading until CiviCRM is installed
  ([247](https://github.com/civicrm/civicrm-wordpress/pull/247))**

- **Fix access permissions for sub-pages and "Quick Add" dashlet
  ([245](https://github.com/civicrm/civicrm-wordpress/pull/245))**

- **Non translatable fields in profile schema
  ([dev/core#527](https://lab.civicrm.org/dev/core/-/issues/527):
  [19937](https://github.com/civicrm/civicrm-core/pull/19937))**

- **Merge Contacts fails when custom Contact Reference field allows Multi-Select
  ([dev/core#2561](https://lab.civicrm.org/dev/core/-/issues/2561):
  [20142](https://github.com/civicrm/civicrm-core/pull/20142))**

- **Error: Undefined class constant 'MODE_CBC' in
  `Civi\Crypto\PhpseclibCipherSuite->__construct()`
  ([dev/core#2564](https://lab.civicrm.org/dev/core/-/issues/2564):
  [20148](https://github.com/civicrm/civicrm-core/pull/20148))**

- **SearchKit - Pass-thru permission checks from SearchDisplay::run to API.get
  ([20186](https://github.com/civicrm/civicrm-core/pull/20186))**

### CiviCampaign

- **On New Campaign form, placeholder text for status is weird
  ([dev/core#2411](https://lab.civicrm.org/dev/core/-/issues/2411):
  [19768](https://github.com/civicrm/civicrm-core/pull/19768))**

- **Fix incorrect placeholder text on 'Create Campaign' form
  ([19767](https://github.com/civicrm/civicrm-core/pull/19767))**

### CiviCase

- **Civicase: Wrong Details in Change Custom Data Activity when filling an empty
  field ([dev/core#2019](https://lab.civicrm.org/dev/core/-/issues/2019):
  [19735](https://github.com/civicrm/civicrm-core/pull/19735) and
  [19741](https://github.com/civicrm/civicrm-core/pull/19741))**

  Changing a case custom field from blank to something doesn't show properly
  what changed.

- **Activity Type and Case Type not being combined correctly in Advanced Search
  ([dev/report#53](https://lab.civicrm.org/dev/report/-/issues/53):
  [20009](https://github.com/civicrm/civicrm-core/pull/20009))**

  Allows SearchKit to search by and display cases with their activities.

- **Investigate replacing civicase views with something that is not views
  ([dev/core#2385](https://lab.civicrm.org/dev/core/-/issues/2385) and
  [dev/core#2262](https://lab.civicrm.org/dev/core/-/issues/2262):
  [19642](https://github.com/civicrm/civicrm-core/pull/19642))**

### CiviContribute

- **Changing Payment Method on a Transaction causes fatal error
  ([dev/core#2577](https://lab.civicrm.org/dev/core/-/issues/2577):
  [20195](https://github.com/civicrm/civicrm-core/pull/20195))**

- **Access Control by Financial Type permissioning does not cover
  contribution_recur (Work Towards
  [dev/core#2454](https://lab.civicrm.org/dev/core/-/issues/2454):
  [19788](https://github.com/civicrm/civicrm-core/pull/19788))**

  Ensures Contribution Recur is properly permissioned.

- **Warnings when saving a contribution with recognition date filled in
  ([dev/financial#172](https://lab.civicrm.org/dev/financial/-/issues/172):
  [19948](https://github.com/civicrm/civicrm-core/pull/19948))**

  Fixes warnings when saving a contribution with a recognition date.

- **Contribution page creates a wrong amount and probably payment processor use
  this wrong amount
  ([dev/core#2449](https://lab.civicrm.org/dev/core/-/issues/2449):
  [19807](https://github.com/civicrm/civicrm-core/pull/19807))**

  Ensures amounts are saved correcly when localization settings are changed.

- **Activity contact is not updated when contribution contact is changed
  ([dev/core#2450](https://lab.civicrm.org/dev/core/-/issues/2450):
  [19820](https://github.com/civicrm/civicrm-core/pull/19820))**

  Ensures source/target activity contacts are updated whenever a contribution is
  updated.

- **Fix recurring contribution defaults
  ([dev/core#2487](https://lab.civicrm.org/dev/core/-/issues/2487):
  [19934](https://github.com/civicrm/civicrm-core/pull/19934))**

  Updates defaults for the civicrm_contribution_recur table to bring the API
  behaviour closer to the user interface behavior.

- **Simplify decision as to whether to use a PDF on emails
  ([dev/financial#162](https://lab.civicrm.org/dev/financial/-/issues/162):
  [19486](https://github.com/civicrm/civicrm-core/pull/19486))**

- **Minor buttonrama issue with Cancel button after exporting financial batch
  ([dev/financial#170](https://lab.civicrm.org/dev/financial/-/issues/170):
  [19787](https://github.com/civicrm/civicrm-core/pull/19787))**

- **False positive message about missing INTL PHP extension on membership type
  form ([dev/financial#171](https://lab.civicrm.org/dev/financial/-/issues/171):
  [19929](https://github.com/civicrm/civicrm-core/pull/19929),
  [19958](https://github.com/civicrm/civicrm-core/pull/19958),
  [19880](https://github.com/civicrm/civicrm-core/pull/19880),
  [19876](https://github.com/civicrm/civicrm-core/pull/19876) and
  [19938](https://github.com/civicrm/civicrm-core/pull/19938))**

- **PHP 7.4 - E_NOTICE every time you save a contribution
  ([dev/core#2425](https://lab.civicrm.org/dev/core/-/issues/2425):
  [19978](https://github.com/civicrm/civicrm-core/pull/19978))**

- **Payment balance should be cast to float, not int, when checking if a
  contribution form should load
  ([dev/core#2453](https://lab.civicrm.org/dev/core/-/issues/2453):
  [19777](https://github.com/civicrm/civicrm-core/pull/19777))**

- **CiviCRM 5.35.1, truncation of money values where $1,000 donation is recorded
  as $1 which appears to be truncating at the thousand separator when using the
  Australian (AU) and US Locale
  ([dev/core#2493](https://lab.civicrm.org/dev/core/-/issues/2493):
  [20040](https://github.com/civicrm/civicrm-core/pull/20040))**

- **Fix re-calculation of payment dates on pledge
  ([19976](https://github.com/civicrm/civicrm-core/pull/19976))**

- **Donot over-ride total amount incase contribution has more than one line item
  ([19951](https://github.com/civicrm/civicrm-core/pull/19951))**

- **Only include completed contributions in the aggregate custom search
  ([19936](https://github.com/civicrm/civicrm-core/pull/19936))**

- **Set the `Other Amount` input in a price set to not autocomplete
  ([19923](https://github.com/civicrm/civicrm-core/pull/19923))**

- **Replace deprecated money_format() fn to support PHP 7.4
  ([dev/translation#65](https://lab.civicrm.org/dev/translation/-/issues/65) and
  [dev/core#1494](https://lab.civicrm.org/dev/core/-/issues/1494):
  [19753](https://github.com/civicrm/civicrm-core/pull/19753))**

- **Remove text about email receipts for each recurring contribution.
  ([dev/core#2384](https://lab.civicrm.org/dev/core/-/issues/2384):
  [19624](https://github.com/civicrm/civicrm-core/pull/19624))**

### CiviEvent

- **Price option reaches max amount causes critical error.
  ([dev/event#53](https://lab.civicrm.org/dev/event/-/issues/53):
  [20073](https://github.com/civicrm/civicrm-core/pull/20073))**

  Ensures that on registration forms sold out radio price options are frozen.

- **Cannot "Transfer or Cancel" event participant as admin user
  ([dev/event#54](https://lab.civicrm.org/dev/event/-/issues/54):
  [20223](https://github.com/civicrm/civicrm-core/pull/20223))**

### CiviMail

- **Remove addressee, email_greeting_id, postal_greeting_id from exposed tokens
  ([19782](https://github.com/civicrm/civicrm-core/pull/19782))**

  Removes support for tokens that are likely to break and are redundant.

- **[regression] CiviMail crashing on send instead of throwing exception when
  using Job.execute
  ([dev/mail#72](https://lab.civicrm.org/dev/mail/-/issues/72):
  [18466](https://github.com/civicrm/civicrm-core/pull/18466))**

### CiviMember

- **Backend Membership Renewal returns a fatal error when min fee is empty
  ([dev/core#2583](https://lab.civicrm.org/dev/core/-/issues/2583):
  [20212](https://github.com/civicrm/civicrm-core/pull/20212))**

- **Selecting of price sets not working anymore
  ([dev/core#2434](https://lab.civicrm.org/dev/core/-/issues/2434):
  [20158](https://github.com/civicrm/civicrm-core/pull/20158))**

  The membership tab on the contribution page configuration form failed to
  display the dropdown for choosing a price set.  This problem was an unreleased
  regression prior to 5.36.0 but this one form got missed when fixed.

- **Update to lifetime membership does not clear the end date
  ([19716](https://github.com/civicrm/civicrm-core/pull/19716))**

  Fix membership to clear end date if type is updated to lifetime.

- **When editing a membership with no existing payments, checking the box to
  record payments results in a total amount of NaN.N
  ([dev/core#2560](https://lab.civicrm.org/dev/core/-/issues/2560):
  [20127](https://github.com/civicrm/civicrm-core/pull/20127))**

### Drupal Integration

- **Rebuild the Drupal route cache.
  ([19906](https://github.com/civicrm/civicrm-core/pull/19906))**

  Ensures enabling a CiviCRM extension that adds a route on Drupal 8 or 9 does
  not result in a 404.

- **Drupal 8 hook_uninstall not implemented
  ([dev/drupal#141](https://lab.civicrm.org/dev/drupal/-/issues/141):
  [61](https://github.com/civicrm/civicrm-drupal-8/pull/61))**

- **Fix Drupal Base 'isFrontEndPage' Returns Wrong Value After Saving A Settings
  Page ([dev/core#2464](https://lab.civicrm.org/dev/core/-/issues/2464):
  [19823](https://github.com/civicrm/civicrm-core/pull/19823))**

- **Fix batch transaction export on D8/9
  ([19761](https://github.com/civicrm/civicrm-core/pull/19761))**

### WordPress Integration

- **WordPress: avoid PHP notice if the anonymous user does not have any
  capabilities ([19732](https://github.com/civicrm/civicrm-core/pull/19732))**

## <a name="misc"></a>Miscellany

- **Remove recaptcha library as now part of core extension
  ([317](https://github.com/civicrm/civicrm-packages/pull/317))**

- **Migrate current recaptcha library into extension and fix a couple of ts
  calls ([20011](https://github.com/civicrm/civicrm-core/pull/20011))**

- **Add recaptcha to distmaker
  ([19999](https://github.com/civicrm/civicrm-core/pull/19999))**

- **Use standard function to add reCAPTCHA to PCPAccount form
  ([20019](https://github.com/civicrm/civicrm-core/pull/20019))**

- **Make testExpiredPriceSet more realistic
  ([19474](https://github.com/civicrm/civicrm-core/pull/19474))**

- **Remove safe+mode setting
  ([19833](https://github.com/civicrm/civicrm-core/pull/19833))**

- **Fold back in getGroupACLs
  ([19882](https://github.com/civicrm/civicrm-core/pull/19882))**

- **Remove getACLRoles
  ([19879](https://github.com/civicrm/civicrm-core/pull/19879))**

- **Move setting of _includesSoftCredits out of getQuery
  ([19860](https://github.com/civicrm/civicrm-core/pull/19860))**

- **Upgrade angularJs from 1.8.0 to 1.8.2
  ([19831](https://github.com/civicrm/civicrm-core/pull/19831))**

- **Bump phpseclib/phpseclib from 2.0.29 to 2.0.31
  ([19994](https://github.com/civicrm/civicrm-core/pull/19994))**

- **Bump y18n from 4.0.0 to 4.0.1
  ([19944](https://github.com/civicrm/civicrm-core/pull/19944))**

- **Code cleanup in bootstrap.php
  ([19834](https://github.com/civicrm/civicrm-core/pull/19834))**

- **Updates to ExportTest
  ([19884](https://github.com/civicrm/civicrm-core/pull/19884))**

- **Update Unit tests to work with phpunit8
  ([130](https://github.com/civicrm/civicrm-backdrop/pull/130))**

- **Update Unit tests to work with PHPUnit8
  ([643](https://github.com/civicrm/civicrm-drupal/pull/643))**

- **Add :void return type to tearDown on a bunch of unit tests
  ([19897](https://github.com/civicrm/civicrm-core/pull/19897))**

- **Tighten mysql mode in test environment
  ([19817](https://github.com/civicrm/civicrm-core/pull/19817))**

- **Add further test for token custom fields
  ([19790](https://github.com/civicrm/civicrm-core/pull/19790))**

- **Remove deprecated code
  ([19919](https://github.com/civicrm/civicrm-core/pull/19919))**

- **Remove unused private function
  ([19950](https://github.com/civicrm/civicrm-core/pull/19950))**

- **Remove empty setUp() functions
  ([19971](https://github.com/civicrm/civicrm-core/pull/19971))**

- **Remove unused variables/assigns from buildMembershipBlock function
  ([19775](https://github.com/civicrm/civicrm-core/pull/19775))**

- **Remove an unnecessary ampersand
  ([19821](https://github.com/civicrm/civicrm-core/pull/19821))**

- **Remove now-empty function
  ([19824](https://github.com/civicrm/civicrm-core/pull/19824))**

- **Remove legacy phpunit param
  ([19836](https://github.com/civicrm/civicrm-core/pull/19836))**

- **[REF] Fix APIv3 MembershipJob test failure on PHP 7.4 by only doing ch…
  ([19844](https://github.com/civicrm/civicrm-core/pull/19844))**

- **[REF] Extract getQueryParams
  ([19857](https://github.com/civicrm/civicrm-core/pull/19857))**

- **[REF] Clarify & simplify is_recur param
  ([19812](https://github.com/civicrm/civicrm-core/pull/19812))**

- **[REF] Minor function extraction
  ([19835](https://github.com/civicrm/civicrm-core/pull/19835))**

- **[REF] Simplify a couple of variables
  ([19861](https://github.com/civicrm/civicrm-core/pull/19861))**

- **[REF] Simplify BAO_ACL table references
  ([19869](https://github.com/civicrm/civicrm-core/pull/19869))**

- **[REF] Stdise campaign_id handling
  ([19877](https://github.com/civicrm/civicrm-core/pull/19877))**

- **[REF] Minor simplification around assigning taxAmount to the template
  ([19757](https://github.com/civicrm/civicrm-core/pull/19757))**

- **[REF] Remove setting of unused variables
  ([19800](https://github.com/civicrm/civicrm-core/pull/19800))**

- **[REF] Fold getACLs back into the calling function
  ([19872](https://github.com/civicrm/civicrm-core/pull/19872))**

- **[REF] Simplify code calculating the number of membership terms
  ([19801](https://github.com/civicrm/civicrm-core/pull/19801))**

- **[REF] Remove redundant toArray() function
  ([19885](https://github.com/civicrm/civicrm-core/pull/19885))**

- **[REF] Store the getSearchQueryResults so it can be re-accessed
  ([19881](https://github.com/civicrm/civicrm-core/pull/19881))**

- **[REF] Minor extraction to help cleanup permission code
  ([19803](https://github.com/civicrm/civicrm-core/pull/19803))**

- **[REF] Minor parameter cleanup
  ([19799](https://github.com/civicrm/civicrm-core/pull/19799))**

- **[REF] Extract code to get generic membership parameters
  ([19784](https://github.com/civicrm/civicrm-core/pull/19784))**

- **[REF] Cleanup on permission code
  ([19796](https://github.com/civicrm/civicrm-core/pull/19796))**

- **[REF] Extract getPaymentInstrumentID
  ([19793](https://github.com/civicrm/civicrm-core/pull/19793))**

- **[Ref] Remove copy and paste overkill
  ([19786](https://github.com/civicrm/civicrm-core/pull/19786))**

- **[REF]  getCorePermissions cleanup
  ([19789](https://github.com/civicrm/civicrm-core/pull/19789))**

- **[REF] Very minor simplification
  ([19785](https://github.com/civicrm/civicrm-core/pull/19785))**

- **[REF] Fix ContributionPage::recurringNotify to use APIv4, simplify params
  ([19639](https://github.com/civicrm/civicrm-core/pull/19639))**

- **[REF] Cleanup code to determine financial_type_id
  ([19756](https://github.com/civicrm/civicrm-core/pull/19756))**

- **[REF] [Towards membership API] Cleanup access to payment_processor_id
  ([19910](https://github.com/civicrm/civicrm-core/pull/19910))**

- **[REF] Remove now redundant code to set line item financial type
  ([19745](https://github.com/civicrm/civicrm-core/pull/19745))**

- **[REF] [Towards membership API] Duplicate emailReceipt function rather than
  silly sharing ([19912](https://github.com/civicrm/civicrm-core/pull/19912))**

- **[REF] [Towards membership API] Simplify message functions
  ([19915](https://github.com/civicrm/civicrm-core/pull/19915))**

- **[REF] Extract portion of GroupContact load that builds the temporary table
  ([19945](https://github.com/civicrm/civicrm-core/pull/19945))**

- **[REF] remove unused code in recordFinancialAccounts
  ([19769](https://github.com/civicrm/civicrm-core/pull/19769))**

- **[REF] Clean up code around is_email_receipt
  ([19746](https://github.com/civicrm/civicrm-core/pull/19746))**

- **[REF] Move function from static class to OO class
  ([19955](https://github.com/civicrm/civicrm-core/pull/19955))**

- **[REF] Extract getMembershipTypeValues
  ([19924](https://github.com/civicrm/civicrm-core/pull/19924))**

- **(REF) CRM_Upgrade_Form - Remove unused method getRevisionPart()
  ([19742](https://github.com/civicrm/civicrm-core/pull/19742))**

- **[REF] [SearchKit Actions] Cleanup around contribution PDF common
  ([19904](https://github.com/civicrm/civicrm-core/pull/19904))**

- **[REF] Minor cleanup - remove unused variables
  ([19980](https://github.com/civicrm/civicrm-core/pull/19980))**

- **REF Ensure that getAmount includes 0s in decimal places up to 2 places
  ([20074](https://github.com/civicrm/civicrm-core/pull/20074))**

- **[REF] Minor cleanup - strictness & formatting
  ([19949](https://github.com/civicrm/civicrm-core/pull/19949))**

- **[REF] [Towards membership API] more consistent handling on amount
  ([19911](https://github.com/civicrm/civicrm-core/pull/19911))**

- **[REF]  [Towards membership API] Simplify calculation of recurring membership
  parameters ([19893](https://github.com/civicrm/civicrm-core/pull/19893))**

- **[REF] Simplify setting of softcredit form options (minor)
  ([19891](https://github.com/civicrm/civicrm-core/pull/19891))**

- **[NFC] Minor coding standards cleanup
  ([19838](https://github.com/civicrm/civicrm-core/pull/19838))**

- **[NFC] Add in "void" statements on various Core Ext Tests to future support PHP…
  ([19832](https://github.com/civicrm/civicrm-core/pull/19832))**

- **[NFC] Minor test cleanup
  ([19852](https://github.com/civicrm/civicrm-core/pull/19852))**

- **[NFC] Cleanup in test class
  ([19866](https://github.com/civicrm/civicrm-core/pull/19866))**

- **[NFC] Fix logging schema test to work on MySQL8 as it no longer outpu…
  ([19850](https://github.com/civicrm/civicrm-core/pull/19850))**

- **[NFC] Fix test failures on PHP 7.4 caused by either NULL being set fo…
  ([19849](https://github.com/civicrm/civicrm-core/pull/19849))**

- **[NFC] Fix test failures on MySQL 8 caused by change in output of eith…
  ([19847](https://github.com/civicrm/civicrm-core/pull/19847))**

- **[NFC] Fix PHP 7.4 errors on ContributionPage tests
  ([19846](https://github.com/civicrm/civicrm-core/pull/19846))**

- **[NFC] Fix Membership Type Test error on PHP 7.4
  ([19845](https://github.com/civicrm/civicrm-core/pull/19845))**

- **[NFC] Minor IDE cleanup in test class
  ([19816](https://github.com/civicrm/civicrm-core/pull/19816))**

- **[NFC] IDE cleanup on test class
  ([19813](https://github.com/civicrm/civicrm-core/pull/19813))**

- **NFC cleanup in test class
  ([19953](https://github.com/civicrm/civicrm-core/pull/19953))**

- **[NFC] Update unit tests to be compatible with PHPUnit8
  ([246](https://github.com/civicrm/civicrm-wordpress/pull/246))**

- **(NFC) Add FUNDING.yml to display a SPONSOR link that directs to c.o
  ([19946](https://github.com/civicrm/civicrm-core/pull/19946))**

- **[NFC] Minor cleanup on test class
  ([19864](https://github.com/civicrm/civicrm-core/pull/19864))**

- **[REF] Fix installation of the search display table on MySQL 5.36 in tests
  ([20094](https://github.com/civicrm/civicrm-core/pull/20094))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Justin Freeman; Alexy
Mikhailichenko; Calibrate - Wouter Hechtermans; Christian Wach; Circle
Interactive - Pradeep Nayak; CiviCoop - Jaap Jansma; CiviCRM - Coleman Watts,
Tim Otten; CompuCorp - Ahed Eid; Coop SymbioTIC - Mathieu Lutfy, Samuel Vanhove;
Dave D; Francesc Bassas i Bullich; Fuzion - Jitendra Purohit; Greenpeace CEE -
mflandorfer; JMA Consulting - Monish Deb, Seamus Lee; Lighthouse Consulting and
Design - Brian Shaughnessy; Megaphone Technology Consulting - Jon Goldberg;
MJCO - Mikey O'Toole; MJW Consulting - Matthew Wire; Nicol Wistreich; Oxfam
Germany - Thomas Schüttler; Progressive Technology Project - Jamie McClelland;
Romain Thouvenin; SYSTOPIA Organisationsberatung - Björn Endres; Third Sector
Design - Michael McAndrew; Timbsoft Technologies - Tunbola Ogunwande; Web
Access - Kurund Jalmi; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Artful Robot - Rich Lott; BrightMinded Ltd - Bradley Taylor; CiviCoop - Erik
Hommel; CiviDesk - Nicolas Ganivet; Context Institute - Robert Gilman; Dave T;
Freeform Solutions - Herb van den Dool; Joinery - Allen Shaw; Megaphone
Technology Consulting - Dennis P. Osorio; Richard van Oosterhout; Semper IT -
Karin Gerritsen; Skvare - Sunil Pawar; Tadpole Collective - Kevin Cristiano

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
