# CiviCRM 5.55.0

Released November 2, 2022

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **APIv4 - Add Contact::mergeDuplicates action
  ([24542](https://github.com/civicrm/civicrm-core/pull/24542))**

  Adds a mergeDuplicates APIv4 action, for parity with APIv3.

- **SearchKit: Add ability to search and filter by active periods
  (Work Towards [dev/core#3878](https://lab.civicrm.org/dev/core/-/issues/3878):
  [24688](https://github.com/civicrm/civicrm-core/pull/24688))**

  Makes it possible to join on related contacts limited by current relationship
  in SearchKit.

- **Add display only field support for formbuilder
  ([dev/core#3779](https://lab.civicrm.org/dev/core/-/issues/3779):
  [24158](https://github.com/civicrm/civicrm-core/pull/24158))**

  Adds the ability to set a field as display only in formbuilder.

- **Afform - Store all values in submission record
  ([24264](https://github.com/civicrm/civicrm-core/pull/24264))**

  Stores all submitted values in the submission record, including saved ids.
  This allows values to be retrieved from the submission for debugging or
  display purposes.

- **AdminUi Extension - Translate strings
  ([24553](https://github.com/civicrm/civicrm-core/pull/24553))**

  Ensures strings are translated in the AdminUI extension.

- **Add icon for Country entity
  ([24686](https://github.com/civicrm/civicrm-core/pull/24686))**

  Adds an icon and description for Country.

- **.htaccess support for OpenLiteSpeed webservers.
  ([24666](https://github.com/civicrm/civicrm-core/pull/24666))**

  Makes rewrite rules compatible with OpenLiteSpeed webservers.

- **Autoload services based on interfaces/annotations. Convert APIv4 services.
  ([24276](https://github.com/civicrm/civicrm-core/pull/24276))**

  Allows developers to auto-register hook-listeners, event-subscribers, and
  container-services and converts APIv4 to do so.

### CiviContribute

- **Simplify description text for Display amounts on price fields, add help
  text for Description on price options
  ([24630](https://github.com/civicrm/civicrm-core/pull/24630))**

  Improves user experience when creating price fields by adding more help text.

### CiviEvent

- **Afform - basic support for creating event participant
  ([24420](https://github.com/civicrm/civicrm-core/pull/24420))**

  Basic support for adding an unpaid participant thru Afform.

### WordPress Integration

- **Add system check for updated clean URL settings
  ([dev/core#3839](https://lab.civicrm.org/dev/core/-/issues/3839):
  [24477](https://github.com/civicrm/civicrm-core/pull/24477))**

  Creates a system check warning for Wordpress users if civicrm.settings.php
  does not include up-to-date clean URL settings.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Importing to checkbox field updates incorrectly
  ([dev/core#3850](https://lab.civicrm.org/dev/core/-/issues/3850):
  [24848](https://github.com/civicrm/civicrm-core/pull/24848))**

- **Improve scheduled reminder UI for selection of event specific date or time
  before event ([dev/core#2535 ](dev/core#2535):
  [24655](https://github.com/civicrm/civicrm-core/pull/24655))**

  Prevents users from saving a scheduled reminder that has both an absolute and
  relative date set, resulting in the relative date being ignored.

- **Changing report rows per page doesn't change rows per page, but limits what
  is displayed.
  ([dev/core#3825](https://lab.civicrm.org/dev/core/-/issues/3825):
  [24616](https://github.com/civicrm/civicrm-core/pull/24616))**

- **More useful error message on missing custom field
  ([dev/core#3847](https://lab.civicrm.org/dev/core/-/issues/3847):
  [24522](https://github.com/civicrm/civicrm-core/pull/24522))**

- **Bootstrap classloading list incomplete (or something) when classscanner
  runs during extension install
  ([dev/core#3852](https://lab.civicrm.org/dev/core/-/issues/3852):
  [24549](https://github.com/civicrm/civicrm-core/pull/24549))**

- **Fix custom data view for case of type Money
  ([dev/core#3876](https://lab.civicrm.org/dev/core/-/issues/3876):
  [24640](https://github.com/civicrm/civicrm-core/pull/24640))**

- **APIv4 - GroupContact - Does not set actual time part in subscription history
  date ([dev/core#3877](https://lab.civicrm.org/dev/core/-/issues/3877):
  [24643](https://github.com/civicrm/civicrm-core/pull/24643))**

- **Can no longer install civirules
  ([dev/core#3853](https://lab.civicrm.org/dev/core/-/issues/3853):
  [24550](https://github.com/civicrm/civicrm-core/pull/24550))**

- **admin-ui extension: contact types doesn't work  
  ([dev/core#3854](https://lab.civicrm.org/dev/core/-/issues/3854):
  [24557](https://github.com/civicrm/civicrm-core/pull/24557))**

  Fixes the "Administer Contact Types" screen for sites using the admin ui
  extension.

- **Handle all from and to relative dates in API4
  ([24663](https://github.com/civicrm/civicrm-core/pull/24663))**

  Ensures APIv4 works with relative date ranges with out set end dates.

- **Migrate JobLog page to API4
  ([24606](https://github.com/civicrm/civicrm-core/pull/24606))**

  Migrates JobLog page to API4 to prevent undefined array keys.

- **Sync api & form layer permissions for jobLog
  ([24619](https://github.com/civicrm/civicrm-core/pull/24619))**

- **Crash when trying to retrieve a completed queue
  ([24678](https://github.com/civicrm/civicrm-core/pull/24678))**

- **Import summary field fix
  ([24711](https://github.com/civicrm/civicrm-core/pull/24711))**

- **Fix accidental revert of import batch size
  ([24772](https://github.com/civicrm/civicrm-core/pull/24772))**

- **Fix language negotiation exception to be standard
  ([24764](https://github.com/civicrm/civicrm-core/pull/24764))**

- **Ensure that class-index is up-to-date after toggling extensions (A)
  ([24743](https://github.com/civicrm/civicrm-core/pull/24743))**

- **Enotice & markup fixes to GeoCode, Postal blocks
  ([24334](https://github.com/civicrm/civicrm-core/pull/24334))**

- **prevent the get property from non-object error
  ([24667](https://github.com/civicrm/civicrm-core/pull/24667))**

- **Ensure smarty variable editSmartGroupURL is always defined on group edit
  ([24613](https://github.com/civicrm/civicrm-core/pull/24613))**

- **Use array_key_exists to avoid warning on report GroupBy.tpl
  template ([24631](https://github.com/civicrm/civicrm-core/pull/24631))**

- **Fix smarty e-notices on group settings form
  ([24594](https://github.com/civicrm/civicrm-core/pull/24594))**

- **Remove stray character in income report
  ([24558](https://github.com/civicrm/civicrm-core/pull/24558))**

- **demoqueue - fix job_type parameter
  ([24668](https://github.com/civicrm/civicrm-core/pull/24668))**

- **Fix smarty notices on localization page
  ([24596](https://github.com/civicrm/civicrm-core/pull/24596))**

- **Migrate single note view to API4, avoid PHP warnings
  ([24609](https://github.com/civicrm/civicrm-core/pull/24609))**

- **APIv4 - Fix Get operation to load options that depend on other options
  ([24600](https://github.com/civicrm/civicrm-core/pull/24600))**

- **Handle unexpected API result in JobManager (Avoid PHP warning)
  ([24605](https://github.com/civicrm/civicrm-core/pull/24605))**

- **Ensure children key is always set in tag buildTree
  ([24607](https://github.com/civicrm/civicrm-core/pull/24607))**

- **Add missing th element to note.tpl
  ([24608](https://github.com/civicrm/civicrm-core/pull/24608))**

- **Avoid PHP notices in Add Contacts to Household task
  ([24565](https://github.com/civicrm/civicrm-core/pull/24565))**

- **Add psr0 to afform extensions
  ([24713](https://github.com/civicrm/civicrm-core/pull/24713))**

- **SearchKit display results does not seem to respect the contribution currency
  ([dev/core#3428](https://lab.civicrm.org/dev/core/-/issues/3428):
  [24524](https://github.com/civicrm/civicrm-core/pull/24524))**

- **Search Kit Tokens only returns first value for multi-selects
  ([dev/core#3745](https://lab.civicrm.org/dev/core/-/issues/3745):
  [24393](https://github.com/civicrm/civicrm-core/pull/24393))**

- **SearchKit - Don't show custom fields from disabled field groups
  ([24687](https://github.com/civicrm/civicrm-core/pull/24687))**

- **Fix missing links in SearchKit results
  ([24882](https://github.com/civicrm/civicrm-core/pull/24882))**

- **Return success from cleanup job
  ([24604](https://github.com/civicrm/civicrm-core/pull/24604))**

- **No longer install the Contribution Cancel Actions, CiviCRM Core Extension
  by default on new CiviCRM sites
  ([22686](https://github.com/civicrm/civicrm-core/pull/22686) and
  [24578](https://github.com/civicrm/civicrm-core/pull/24578))**

  Work towards deprecating the Contribution Cancel Actions extension by no
  longer setting it to default to installed on new sites.

- **Code Cleanup - combines `CRM_Core_Exception`, `civicrm_api3_Exception` and
  `ApiException` into one class.
  ([24531](https://github.com/civicrm/civicrm-core/pull/24531),
  [24535](https://github.com/civicrm/civicrm-core/pull/24535),
  [24537](https://github.com/civicrm/civicrm-core/pull/24537),
  [24534](https://github.com/civicrm/civicrm-core/pull/24534) and
  [24536](https://github.com/civicrm/civicrm-core/pull/24536))**

- **Wording typo in pledge reminder message template
  ([24527](https://github.com/civicrm/civicrm-core/pull/24527))**

- **CiviCRM fatal error on enabling `civiimport`
  ([dev/core#3941](https://lab.civicrm.org/dev/core/-/issues/3941):
  [24807](https://github.com/civicrm/civicrm-core/pull/24807) and
  [24874](https://github.com/civicrm/civicrm-core/pull/24874))**

### CiviContribute

- **Stop adding 'In Progress' and 'Overdue' statuses to
  civicrm_contribution.contribution_status_id option group
  ([dev/financial#201](https://lab.civicrm.org/dev/financial/-/issues/201):
  [23074](https://github.com/civicrm/civicrm-core/pull/23074))**

  Do not add pledge statuses to Contribution statuses.

- **Import contributions: Contact matching by email no longer available
  ([dev/core#3939](https://lab.civicrm.org/dev/core/-/issues/3939):
  [24838](https://github.com/civicrm/civicrm-core/pull/24838) and
  [24871](https://github.com/civicrm/civicrm-core/pull/24871))**

- **Including Soft Credits causes Contribution Import to fail
  ([dev/core#3879](https://lab.civicrm.org/dev/core/-/issues/3879):
  [24858](https://github.com/civicrm/civicrm-core/pull/24858))**

- **Price set pre and post help display is inconsistent
  ([dev/core#3870](https://lab.civicrm.org/dev/core/-/issues/3870):
  [24624](https://github.com/civicrm/civicrm-core/pull/24624))**

- **Fix css for price fields of html type Select with long labels
  ([(dev/core#3865](https://lab.civicrm.org/dev/core/-/issues/3865):
  [24598](https://github.com/civicrm/civicrm-core/pull/24598))**

- **Show billing address on Edit contribution screen as well
  ([dev/core#3732](https://lab.civicrm.org/dev/core/-/issues/3732):
  [24009](https://github.com/civicrm/civicrm-core/pull/24009))**

- **Only public custom groups should be shown in offline contribution receipts
  ([dev/core#3857](https://lab.civicrm.org/dev/core/-/issues/3857):
  [24645](https://github.com/civicrm/civicrm-core/pull/24645))**

- **Fix paypal subscription 'things don't seem to be working at the moment'
  if frequency_interval not specified
  ([24614](https://github.com/civicrm/civicrm-core/pull/24614))**

- **Don't repeat email twice on the contribution confirm/thank-you pages
  ([24564](https://github.com/civicrm/civicrm-core/pull/24564))**

- **Remove call to deprecated `CRM_Contribute_PseudoConstant::contributionStatus`
  ([24528](https://github.com/civicrm/civicrm-core/pull/24528))**

- **Remove usage of result from deprecated contributionStatus
  ([24540](https://github.com/civicrm/civicrm-core/pull/24540))**

- **[REF] Fix importing contributions with a campaign id rather than a title
  ([24815](https://github.com/civicrm/civicrm-core/pull/24815))**

### CiviEvent

- **Event badges, json may be broken (was CiviEvent - Date tokens may be
  misformatted)
  ([dev/core#3952](https://lab.civicrm.org/dev/core/-/issues/3952):
  [24872](https://github.com/civicrm/civicrm-core/pull/24872))**

  This upgrade step resolves a problem where the `"` character in labels and
  badges was not being properly escaped for json purposes on a previous upgrade
  process.

- **Event participant import fails, Cannot call constructor
  ([dev/core#3932](https://lab.civicrm.org/dev/core/-/issues/3932):
  [24790](https://github.com/civicrm/civicrm-core/pull/24790))**

- **Barcodes in event badges missing data after updating to CiviCRM 5.45.7
  ([dev/core#3829](https://lab.civicrm.org/dev/core/-/issues/3829):
  [24701](https://github.com/civicrm/civicrm-core/pull/24701) and
  [24695](https://github.com/civicrm/civicrm-core/pull/24695))**

### CiviMail

- **Stop PHP notice on Find Mailings page
  ([24560](https://github.com/civicrm/civicrm-core/pull/24560))**

### Drupal Integration

- **Change message so it doesn't say Drupal8 on Drupal9 site
  ([dev/drupal#174](https://lab.civicrm.org/dev/drupal/-/issues/174):
  [24561](https://github.com/civicrm/civicrm-core/pull/24561))**

## <a name="misc"></a>Miscellany

- **Remove call to deprecated function
  `CRM_Contribute_PseudoConstant::contributionStatus`
  ([24544](https://github.com/civicrm/civicrm-core/pull/24544))**

- **Remove call to deprecated
  `CRM_Contribute_PseudoConstant::contributionStatus`
  ([24575](https://github.com/civicrm/civicrm-core/pull/24575))**

- **Remove unused variable
  ([24563](https://github.com/civicrm/civicrm-core/pull/24563))**

- **Remove `CRM_Core_Pseudoconstant::pcpStatus()` function after two-year noisy
  deprecation ([24591](https://github.com/civicrm/civicrm-core/pull/24591))**

- **Remove long-deprecated function
  ([24620](https://github.com/civicrm/civicrm-core/pull/24620))**

- **contribution template clean up for reports
  ([24556](https://github.com/civicrm/civicrm-core/pull/24556))**

- **case template clean up for reports
  ([24541](https://github.com/civicrm/civicrm-core/pull/24541))**

- **pledge template clean for reports
  ([24519](https://github.com/civicrm/civicrm-core/pull/24519))**

- **event report template clean up
  ([24644](https://github.com/civicrm/civicrm-core/pull/24644))**

- **clean up more report templates
  ([24642](https://github.com/civicrm/civicrm-core/pull/24642))**

- **Code cleanup - remove unused fn call, prefer strict comparision
  ([24530](https://github.com/civicrm/civicrm-core/pull/24530))**

- **Stop using private static for tests
  ([24680](https://github.com/civicrm/civicrm-core/pull/24680))**

- **Re run regen
  ([24533](https://github.com/civicrm/civicrm-core/pull/24533))**

- **Regen update
  ([24677](https://github.com/civicrm/civicrm-core/pull/24677))**

- **Avoid confusion between contributors and contributor-key
  ([24670](https://github.com/civicrm/civicrm-core/pull/24670))**

- **add as a contributor
  ([24659](https://github.com/civicrm/civicrm-core/pull/24659))**

- **add as a contributor
  ([24673](https://github.com/civicrm/civicrm-core/pull/24673))**

- **Add contributor info for release notes
  ([24669](https://github.com/civicrm/civicrm-core/pull/24669))**

- **Fix `testCreateWithPrimaryAndBilling`
  ([24691](https://github.com/civicrm/civicrm-core/pull/24691))**

- **Deprecate handling for removed silly constant
  ([24521](https://github.com/civicrm/civicrm-core/pull/24521))**

- **[REF] Minor extraction
  ([24595](https://github.com/civicrm/civicrm-core/pull/24595))**

- **[REF] DAO - Add helper function to check if component is enabled
  ([24525](https://github.com/civicrm/civicrm-core/pull/24525))**

- **[REF] Update Tplaner/when package to latest version
  ([24682](https://github.com/civicrm/civicrm-core/pull/24682))**

- **[REF] Afform - Extract string function to CRM_Utils_String
  ([24559](https://github.com/civicrm/civicrm-core/pull/24559))**

- **[REF] ExportUI - Convert Angular controller to component
  ([24581](https://github.com/civicrm/civicrm-core/pull/24581))**

- **[REF] Cleanup unused references to CRM_Core_Exception aliases
  ([24526](https://github.com/civicrm/civicrm-core/pull/24526))**

- **[REF] Update JQuery UI to 1.13.2
  ([24703](https://github.com/civicrm/civicrm-core/pull/24703))**

- **[REF][PHP8.1] Fix Notice errors on php8.1 when running IDS
  ([350](https://github.com/civicrm/civicrm-packages/pull/350))**

- **[REF][PHP8.1] Fix test failure on civiimport unit test because sequence key
  and keys are using id not _id
  ([24736](https://github.com/civicrm/civicrm-core/pull/24736))**

- **[REF][PHP8.1] Fix Extension Manager Module test failures on php8.1 due to
  passing in null to dirname
  ([24733](https://github.com/civicrm/civicrm-core/pull/24733))**

- **[REF] Fix passing null into string functions in translation BAO
  ([24732](https://github.com/civicrm/civicrm-core/pull/24732))**

- **[REF] Remove Reference to now moved CONTRIBUTORS.txt file blocking building
  ([24753](https://github.com/civicrm/civicrm-core/pull/24753))**

- **[NFC] Add comment about uiLanguages vs languageLimit to avoid confusion
  ([24625](https://github.com/civicrm/civicrm-core/pull/24625))**

- **[NFC] Assert something in unit test
  ([24626](https://github.com/civicrm/civicrm-core/pull/24626))**

- **(NFC) Add various comments (ClassScanner, Config)
  ([24568](https://github.com/civicrm/civicrm-core/pull/24568))**

- **[REF] Add in Unit test to demonstrate error when trying to import a campaign
  id int rather than name or label of the campaign
  ([24814](https://github.com/civicrm/civicrm-core/pull/24814))**  

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt, Alice Frumin, Eli Lisseck; Agileware - Justin
Freeman; BrightMinded Ltd - Bradley Taylor; Bund Deutscher PfadfinderInnen
BaWue - David Geisel; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha
Chaku; Dave D; JMA Consulting - Seamus Lee; Megaphone Technology Consulting -
Jon Goldberg; MJW Consulting - Matthew Wire; NowaTech - Kasper Nowak; Oxfam
Germany - Thomas Schüttler; Richard van Oosterhout; Squiffle Consulting -
Aidan Saunders; Third Sector Design - Kurund Jalmi; Wikimedia Foundation -
Eileen McNaughton, Wenjun Fan; Wildsight - Lars Sanders-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Rennie Harrison; Coop SymbioTIC - Mathieu Lutfy;
Francesc Bassas i Bullich; Freewindrider; Greenpeace Central and Eastern
Europe - Patrick Figel; Megaphone Technology Consulting - Brienne Kordis;
SYSTOPIA Organisationsberatung - Björn Endres; Tadpole Collective - Kevin
Cristiano; Third Sector Design - William Mortada; YesusHDS

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
