# CiviCRM 5.71.0

Released March 6, 2024

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     |         |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| Fix problems installing or upgrading to a previous version?     |         |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Make name, title, frontend_title fields on UFGroup consistent with
  ContributionPage, Group
  ([28492](https://github.com/civicrm/civicrm-core/pull/28492))**

  This makes profile names operate in the same way as group and contribution
  page names

### CiviEvent

- **Consolidate handling of line items in back office participant form
  ([28735](https://github.com/civicrm/civicrm-core/pull/28735))**

- **Clean up  code to add custom data to forms, implement on back office
  participant form
  ([28733](https://github.com/civicrm/civicrm-core/pull/28733))**

- **Add html types to Participant schema
  ([28900](https://github.com/civicrm/civicrm-core/pull/28900))**

### CiviMember

- **SearchUI - Add Find Membership using searchkit
  ([29064](https://github.com/civicrm/civicrm-core/pull/29064))**

- **ContactSummary - Replace Membership tab with Searchkit display
  ([28810](https://github.com/civicrm/civicrm-core/pull/28810))**

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Regression - Fix missing getLinks action in SKEntity
  ([29589](https://github.com/civicrm/civicrm-core/pull/29589))**

- **SearchKit - Fix enable/disable links in displays ([29547](https://github.com/civicrm/civicrm-core/pull/29547))**

- **Rename 'Provider' entity to 'SmsProvider' ([29555](https://github.com/civicrm/civicrm-core/pull/29555))**

- **Make integer field selfcancelxfer_time required ([29525](https://github.com/civicrm/civicrm-core/pull/29525))**

- **Fix regression from #27902 disabled options showing ([29504](https://github.com/civicrm/civicrm-core/pull/29504))**

- **dev/core#5018 Fix UFGroup.xml ([29461](https://github.com/civicrm/civicrm-core/pull/29461))**

- **dev/core#4889 - Don't delete my files (alternate) ([29421](https://github.com/civicrm/civicrm-core/pull/29421))**

- **News Dashlet - Fix styling of unread items ([29452](https://github.com/civicrm/civicrm-core/pull/29452))**

- **dev/core#5005 Fix validating to allow for saving with entity sub filt… ([29444](https://github.com/civicrm/civicrm-core/pull/29444))**

- **Afform - Fix incorrect html encoding when saving ([29400](https://github.com/civicrm/civicrm-core/pull/29400))**

- **AngularJS - Fix log warning on upgrade UI ([29403](https://github.com/civicrm/civicrm-core/pull/29403))**

- **5.71 upgrade is not safe to re-run ([29398](https://github.com/civicrm/civicrm-core/pull/29398))**

- **CryptoJwt - Fix detection of firebase/php-jwt APIs ([29376](https://github.com/civicrm/civicrm-core/pull/29376))**

- **APIv4 - Fetch all options when matching pseudoconstants. ([29369](https://github.com/civicrm/civicrm-core/pull/29369))**

- **CryptoJwt - Fix detection of firebase/php-jwt APIs ([29345](https://github.com/civicrm/civicrm-core/pull/29345))**

- **Unshare the SMSCommon::preProcess function between the  ([29339](https://github.com/civicrm/civicrm-core/pull/29339))**

- **dev/core#4821 - APIv4: Allow custom field to reference value in bridge joins ([29325](https://github.com/civicrm/civicrm-core/pull/29325))**

- **dev/core#3381 Fix currency display on total fees ([29299](https://github.com/civicrm/civicrm-core/pull/29299))**

- **Fix php8.x issues in payment form ([29245](https://github.com/civicrm/civicrm-core/pull/29245))**

- **SMS tasks, use shared trait, move some functions to it ([29285](https://github.com/civicrm/civicrm-core/pull/29285))**

- **Remove incorrectly placed ChangeCaseStatus class properties and convert one of them to a local var ([29284](https://github.com/civicrm/civicrm-core/pull/29284))**

- **Fix misunderstanding about return value of getKeyId ([29141](https://github.com/civicrm/civicrm-core/pull/29141))**

- **Stop burying the lead ([29306](https://github.com/civicrm/civicrm-core/pull/29306))**

- **dev/core#4974 Fix total fees over-sharing ([29309](https://github.com/civicrm/civicrm-core/pull/29309))**

- **Afform - Reduce noise in mgd.php file ([29316](https://github.com/civicrm/civicrm-core/pull/29316))**

- **Drupal.civi-setup: setAuthorized if running via drush ([29303](https://github.com/civicrm/civicrm-core/pull/29303))**

- **APIv4 - Add type hints to Result object ([29258](https://github.com/civicrm/civicrm-core/pull/29258))**

- **WP - Handle updated permissions format ([29297](https://github.com/civicrm/civicrm-core/pull/29297))**

- **Clean up on clear_assign ([29287](https://github.com/civicrm/civicrm-core/pull/29287))**

- **API - More helpful authorization failed error message ([29179](https://github.com/civicrm/civicrm-core/pull/29179))**

- **(REF) Cleanup - Replace more nested CRM_Utils_Array::value with ?? ([29283](https://github.com/civicrm/civicrm-core/pull/29283))**

- **composer.json: Use current SPDX license identifier ([29078](https://github.com/civicrm/civicrm-core/pull/29078))**

- **[php8.x] Clean up max value functionality ([29254](https://github.com/civicrm/civicrm-core/pull/29254))**

- **(REF) Cleanup - Replace illegible nested CRM_Utils_Array::value with ?? ([29268](https://github.com/civicrm/civicrm-core/pull/29268))**

- **[php8.x] Minor cleanup in priceSetOptionsCount ([29255](https://github.com/civicrm/civicrm-core/pull/29255))**

- **[php8.x] Clarify what `optionsMaxValueTotal` means ([29252](https://github.com/civicrm/civicrm-core/pull/29252))**

- **Allow cascade delete for custom entity reference fields ([28225](https://github.com/civicrm/civicrm-core/pull/28225))**

- **Do not permit a contact to be deleted if it is linked to a CMS user issue1290 ([29026](https://github.com/civicrm/civicrm-core/pull/29026))**

- **Update template deprecation text, add one more string ([29250](https://github.com/civicrm/civicrm-core/pull/29250))**

- **Unshare another function to permit code cleanup ([29248](https://github.com/civicrm/civicrm-core/pull/29248))**

- **Fold functions that only support one form back into that form (survey) ([29232](https://github.com/civicrm/civicrm-core/pull/29232))**

- **Make form-specific funciont protected, non-static ([29247](https://github.com/civicrm/civicrm-core/pull/29247))**

- **Afform - Remove guesswork from fk lookups ([29236](https://github.com/civicrm/civicrm-core/pull/29236))**

- **Remove call to silly non-php8.2 compliant function ([29230](https://github.com/civicrm/civicrm-core/pull/29230))**

- **APIv4 - Add type hints to FieldSpec functions ([29223](https://github.com/civicrm/civicrm-core/pull/29223))**

- **Declare some public variables on ChangeCaseStatus ([29227](https://github.com/civicrm/civicrm-core/pull/29227))**

- **DAO - Remove buggy caching from import/export ([29182](https://github.com/civicrm/civicrm-core/pull/29182))**

- **CorePermission - Declare more implied permissions explicitly ([29218](https://github.com/civicrm/civicrm-core/pull/29218))**

- **Use standardised function to get PriceFieldMetadata ([29219](https://github.com/civicrm/civicrm-core/pull/29219))**

- **Unshare another function with over-sharing ([29217](https://github.com/civicrm/civicrm-core/pull/29217))**

- **Make previously shared function non-static ([29216](https://github.com/civicrm/civicrm-core/pull/29216))**

- **Permissions - Make implied permissions declarative ([29174](https://github.com/civicrm/civicrm-core/pull/29174))**

- **Pass fee block into validatePriceset rather than looking up property ([29215](https://github.com/civicrm/civicrm-core/pull/29215))**

- **Unshare initFee function ([29211](https://github.com/civicrm/civicrm-core/pull/29211))**

- **Pass variables into validatePriceSet rather than getting from the form ([29210](https://github.com/civicrm/civicrm-core/pull/29210))**

- **Move static function to parent, make non-static ([29207](https://github.com/civicrm/civicrm-core/pull/29207))**

- **SearchKit - Hide invalid links and prevent error ([29201](https://github.com/civicrm/civicrm-core/pull/29201))**

- **Move function to shared parent & make non-static ([29198](https://github.com/civicrm/civicrm-core/pull/29198))**

- **Remove unused properties, make internal function private ([29161](https://github.com/civicrm/civicrm-core/pull/29161))**

- **Core/DAO - Add boilerplate import/export functions to base class  ([29181](https://github.com/civicrm/civicrm-core/pull/29181))**

- **Fix notices on Additional Payment Form ([29110](https://github.com/civicrm/civicrm-core/pull/29110))**

- **Return determination  of title to the only user ([29103](https://github.com/civicrm/civicrm-core/pull/29103))**

- **Remove function noisily deprecated in 2020 ([29177](https://github.com/civicrm/civicrm-core/pull/29177))**

- **Add some deprecation warnings, annotations ([29176](https://github.com/civicrm/civicrm-core/pull/29176))**

- **(REF) Normalize internal format of permissions ([29173](https://github.com/civicrm/civicrm-core/pull/29173))**

- **Remove some unused function variables ([29167](https://github.com/civicrm/civicrm-core/pull/29167))**

- **corePermissions - Add label and description keys to arrays ([29170](https://github.com/civicrm/civicrm-core/pull/29170))**

- **Remove unused extra param in getAllModulePermissions ([29165](https://github.com/civicrm/civicrm-core/pull/29165))**

- **Remove unused implied_permissions declaration ([29164](https://github.com/civicrm/civicrm-core/pull/29164))**

- **Remove non-sms parts from SMS class ([29153](https://github.com/civicrm/civicrm-core/pull/29153))**

- **Remove instances of bltID ([29160](https://github.com/civicrm/civicrm-core/pull/29160))**

- **Stop passing billingLocationID to functions that ignore the incoming parameter ([28762](https://github.com/civicrm/civicrm-core/pull/28762))**

- **Use names rather than variables for table names in findPendingTasks ([29150](https://github.com/civicrm/civicrm-core/pull/29150))**

- **Use table names directly in query ([29144](https://github.com/civicrm/civicrm-core/pull/29144))**

- **Contact tokens - Implement fall back from billing address to primary address ([29121](https://github.com/civicrm/civicrm-core/pull/29121))**

- **Remove un-passed parameter ([29146](https://github.com/civicrm/civicrm-core/pull/29146))**

- **SearchKit - Assign raw values to Smarty in field rewrite ([26742](https://github.com/civicrm/civicrm-core/pull/26742))**

- **(REF) ContactType - Fix 2 functions to be more reliable and efficient ([29052](https://github.com/civicrm/civicrm-core/pull/29052))**

- **Do not use a variable for table names ([29134](https://github.com/civicrm/civicrm-core/pull/29134))**

- **Do not return params from doSubmitActions, it is unchanged ([29131](https://github.com/civicrm/civicrm-core/pull/29131))**

- **Remove unused properties, variables ([29129](https://github.com/civicrm/civicrm-core/pull/29129))**

- **Remove unused variables, object fetch ([29130](https://github.com/civicrm/civicrm-core/pull/29130))**

- **Notice fix on qfKey ([29128](https://github.com/civicrm/civicrm-core/pull/29128))**

- **dev/core#4836 Fix mishandling of multiple fields with serialize ([29116](https://github.com/civicrm/civicrm-core/pull/29116))**

- **Fix php warnings on contact edit ([29111](https://github.com/civicrm/civicrm-core/pull/29111))**

- **Use cached array field for custom field validation ([29108](https://github.com/civicrm/civicrm-core/pull/29108))**

- **Degrade consistently when civi_report not enabled but logging is ([28864](https://github.com/civicrm/civicrm-core/pull/28864))**

- **Contact Changelog: use h3 for page title ([29067](https://github.com/civicrm/civicrm-core/pull/29067))**

- **SearchKit - Run filterTasksForDisplay after all other hooks ([29088](https://github.com/civicrm/civicrm-core/pull/29088))**

- **(REF) CRM_Core_Session - Streamline lookup of current user id & display name ([29048](https://github.com/civicrm/civicrm-core/pull/29048))**

- **APIv4 - RequestSpec caching ([29066](https://github.com/civicrm/civicrm-core/pull/29066))**

- **(REF) APIv4 - Remove unnecessary class namespace prefixes ([29068](https://github.com/civicrm/civicrm-core/pull/29068))**

- **Fix internal links in AdminUI templates ([29065](https://github.com/civicrm/civicrm-core/pull/29065))**

- **Move import export to UserJob ([29062](https://github.com/civicrm/civicrm-core/pull/29062))**

- **Deprecate unused function getSurveyCustomGroups ([29053](https://github.com/civicrm/civicrm-core/pull/29053))**

- **(REF) APIv4 - Use caching to speed up invoke function ([29061](https://github.com/civicrm/civicrm-core/pull/29061))**

- **Import minor adjustments - add getters, setters, flush, ability to export ([29057](https://github.com/civicrm/civicrm-core/pull/29057))**

- **Use static caching to reduce lookups in import display ([29059](https://github.com/civicrm/civicrm-core/pull/29059))**

- **jsortable.tpl: make order direction configurable ([28672](https://github.com/civicrm/civicrm-core/pull/28672))**

- **(REF) - Cleanup ajax on profile field admin form ([29042](https://github.com/civicrm/civicrm-core/pull/29042))**

- **Add missing aliases for billingCountry fields ([28926](https://github.com/civicrm/civicrm-core/pull/28926))**

- **(REF) Profile - simplify loop to check for multi-record custom group ([29037](https://github.com/civicrm/civicrm-core/pull/29037))**

- **Fix isMultiRecordField function to return group id ([29036](https://github.com/civicrm/civicrm-core/pull/29036))**

- **PHP8 - Remove unnecessary pass-by-reference ([29030](https://github.com/civicrm/civicrm-core/pull/29030))**

- **APIv4 - Deprecae unused function ([29031](https://github.com/civicrm/civicrm-core/pull/29031))**

- **SearchKit - Allow rewrite with only whitespace ([29024](https://github.com/civicrm/civicrm-core/pull/29024))**

- **Correct message template warning in MessageTemplates.php ([29015](https://github.com/civicrm/civicrm-core/pull/29015))**

- **UFGroup - Cleanup getCustomFields and standardize checkPermission param ([29004](https://github.com/civicrm/civicrm-core/pull/29004))**

- **Dedupe - Include EntityReference custom fields ([28991](https://github.com/civicrm/civicrm-core/pull/28991))**

- **Remove check for core-error, never thrown ([28980](https://github.com/civicrm/civicrm-core/pull/28980))**

- **Add params to actions when creating a WordPress User ([28992](https://github.com/civicrm/civicrm-core/pull/28992))**

- **Take a copy of importable fields back to the upgrade  class ([28982](https://github.com/civicrm/civicrm-core/pull/28982))**

- **Superficial clean up Use strict type checks ([28961](https://github.com/civicrm/civicrm-core/pull/28961))**

- **Remove duplicate financial acl check ([28963](https://github.com/civicrm/civicrm-core/pull/28963))**

- **Add comments to settings definition to clarify that this is not the preferred method ([28969](https://github.com/civicrm/civicrm-core/pull/28969))**

- **CiviCRM APIv4, Extension::get - expose more Extension properties ([28986](https://github.com/civicrm/civicrm-core/pull/28986))**

- **Remove arguable statement about refunds ([28979](https://github.com/civicrm/civicrm-core/pull/28979))**

- **Make error message more traceable ([28972](https://github.com/civicrm/civicrm-core/pull/28972))**

- **(REF)  Convert _checkAccess to event listener ([28890](https://github.com/civicrm/civicrm-core/pull/28890))**

- **PCP - Add metadata for SearchKit dynamic joins ([28549](https://github.com/civicrm/civicrm-core/pull/28549))**

- **Followup to 28936 ([28956](https://github.com/civicrm/civicrm-core/pull/28956))**

- **(REF) SearchKit - minor code cleanup/clarification ([28958](https://github.com/civicrm/civicrm-core/pull/28958))**

- **dev/core#4888 - Location field on case activity is misaligned ([28955](https://github.com/civicrm/civicrm-core/pull/28955))**

- **Copy formatFieldsForOptionFull to not share backoffice & front end ([28938](https://github.com/civicrm/civicrm-core/pull/28938))**

- **hook_links - Identify more quirks ([28950](https://github.com/civicrm/civicrm-core/pull/28950))**

- **Add system checks for civicrm.settings performance options ([28936](https://github.com/civicrm/civicrm-core/pull/28936))**

- **APIv4 - Improve getFields internal value lookups ([28940](https://github.com/civicrm/civicrm-core/pull/28940))**

- **Remove un-used noticey function ([28885](https://github.com/civicrm/civicrm-core/pull/28885))**

- **Stop setting unused key ([28923](https://github.com/civicrm/civicrm-core/pull/28923))**

- **Remove unused variable ([28939](https://github.com/civicrm/civicrm-core/pull/28939))**

- **DeletedFilesCheck - Include renamed as well as deleted files ([28930](https://github.com/civicrm/civicrm-core/pull/28930))**

- **Make function non-static, protected ([28924](https://github.com/civicrm/civicrm-core/pull/28924))**

- **Add preliminary previewability and token support to case-activity ([28800](https://github.com/civicrm/civicrm-core/pull/28800))**

- **Handle updated permissions format ([678](https://github.com/civicrm/civicrm-drupal/pull/678))**

- **Use unaliased Exception ([315](https://github.com/civicrm/civicrm-wordpress/pull/315))**

- **Handle updated permissions format ([172](https://github.com/civicrm/civicrm-backdrop/pull/172))**

- **Add clearAssign transitional shim ([384](https://github.com/civicrm/civicrm-packages/pull/384))**

- **Contemplate nothingness ([29269](https://github.com/civicrm/civicrm-core/pull/29269))**

### CiviContribute

- **Warn when undefined php properties in mail text
  ([28399](https://github.com/civicrm/civicrm-core/pull/28399))**

- **fix bug saving a new recurring contribution to the database
  ([29005](https://github.com/civicrm/civicrm-core/pull/29005))**

### CiviEvent

- **[php8.x] [online-event] [test] Use Order object rather than passed
  parameter to figure out if price field values use participant count
  ([29249](https://github.com/civicrm/civicrm-core/pull/29249))**

- **Multiple Participant Event Registration Issue
  ([dev/core#4390](https://lab.civicrm.org/dev/core/-/issues/4390):
  [29358](https://github.com/civicrm/civicrm-core/pull/29358))**

  This removes unused code that results in errors for multiple participant registration.

- **BackOffice participant form - Fix failure to reload correct default when
  custom data subtype changes
  ([29356](https://github.com/civicrm/civicrm-core/pull/29356))**

- **Event full inconsistencies
  ([dev/core#4907](https://lab.civicrm.org/dev/core/-/issues/4907),
  [dev/core#4918](https://lab.civicrm.org/dev/core/-/issues/4918), and
  [dev/core#4942](https://lab.civicrm.org/dev/core/-/issues/4942):
  [28983](https://github.com/civicrm/civicrm-core/pull/28983)
  [28984](https://github.com/civicrm/civicrm-core/pull/28984),
  [29105](https://github.com/civicrm/civicrm-core/pull/29105),
  [29106](https://github.com/civicrm/civicrm-core/pull/29106),
  [29127](https://github.com/civicrm/civicrm-core/pull/29127), and
  [29197](https://github.com/civicrm/civicrm-core/pull/29197))**

- **event title is blank in transfer participant email
  ([28993](https://github.com/civicrm/civicrm-core/pull/28993))**

- **Regression - Events - Registration Confirmation and Receipt (on-line)
  ([dev/core#5006](https://lab.civicrm.org/dev/core/-/issues/5006):
  [29408](https://github.com/civicrm/civicrm-core/pull/29408))**

- **Extra squiggly bracket appearing on event thankyou page
  ([29464](https://github.com/civicrm/civicrm-core/pull/29464))**

- **Notice fixes on AdditionalParticipant page
  ([29234](https://github.com/civicrm/civicrm-core/pull/29234))**

- **Stop calculating optionsCountDetails in non-unshared function on
  participantFeeSelection
  ([29221](https://github.com/civicrm/civicrm-core/pull/29221))**

- **Fix Participant fee selection to use standardised getPriceFieldMetadata
  ([29220](https://github.com/civicrm/civicrm-core/pull/29220))**

- **Event cart - stop using undeclared property cid
  ([29237](https://github.com/civicrm/civicrm-core/pull/29237))**

- **Fix a couple of notices on event dashboard
  ([29222](https://github.com/civicrm/civicrm-core/pull/29222))**

- **Fix Smarty Notices on Event confirm & thank you pages
  ([29310](https://github.com/civicrm/civicrm-core/pull/29310))**

- **[online-event] Fix typing on fee level
  ([29239](https://github.com/civicrm/civicrm-core/pull/29239))**

- **Fix notices on event info page
  ([29304](https://github.com/civicrm/civicrm-core/pull/29304))**

- **Copy buildAmount back to form to avoid unhelpful sharing
  ([28916](https://github.com/civicrm/civicrm-core/pull/28916))**

- **[online-event] PHP8.2 stop unnecessarily setting undefined Properties in
  event thankyou ([29244](https://github.com/civicrm/civicrm-core/pull/29244))**

- **Fix master-only regression on saving event info when no custom data applies
  ([29301](https://github.com/civicrm/civicrm-core/pull/29301))**

- **Event Registration Confirm/Thank You pages show incorrect currency
  ([dev/core#3381](https://lab.civicrm.org/dev/core/-/issues/3381):
  [29251](https://github.com/civicrm/civicrm-core/pull/29251))**

- **organizer field should ONLY be included if ics is used for group scheduling
  ([28954](https://github.com/civicrm/civicrm-core/pull/28954))**

- **Fix notices & php8.2 compatibility on Manage Event Info page
  ([29240](https://github.com/civicrm/civicrm-core/pull/29240))**

- **FIx show-hide notices on event confirm
  ([29224](https://github.com/civicrm/civicrm-core/pull/29224))**

- **Remove a chunk of legacy code from (probably unused) EventForward code)
  ([29145](https://github.com/civicrm/civicrm-core/pull/29145))**

- **Number field input validation does not respect decimal separator setting
  (event custom field)
  ([dev/core#4941](https://lab.civicrm.org/dev/core/-/issues/4941):
  [29125](https://github.com/civicrm/civicrm-core/pull/29125))**

- **Notice fix on event thank you page
  ([29126](https://github.com/civicrm/civicrm-core/pull/29126))**

- **VTIMEZONE block in ICS file publishes DSTART in wrong timezone
  ([dev/core#4860](https://lab.civicrm.org/dev/core/-/issues/4860):
  [28853](https://github.com/civicrm/civicrm-core/pull/28853))**

- **Fix handling for available registrations in event Register::formRule
  ([28987](https://github.com/civicrm/civicrm-core/pull/28987))**

- **Remove bltID from eventFees class
  ([28772](https://github.com/civicrm/civicrm-core/pull/28772))**

- **E-notice fix, online event, currency
  ([28883](https://github.com/civicrm/civicrm-core/pull/28883))**

- **Unconditionally assign priceSet on event forms to avoid notices
  ([28949](https://github.com/civicrm/civicrm-core/pull/28949))**

### CiviMail

- **[PHP 8.2] mail wrongly formatted
  ([dev/core#4913](https://lab.civicrm.org/dev/core/-/issues/4913):
  [29035](https://github.com/civicrm/civicrm-core/pull/29035))**

  This is resolved by updating the pear/mail and pear/db libraries.

- **don't create duplicate contacts when sending test emails
  ([29212](https://github.com/civicrm/civicrm-core/pull/29212))**

- **Add test & clean up deprecated apiv3 Forward action
  ([29166](https://github.com/civicrm/civicrm-core/pull/29166))**

- **Remove unused paramter (was to support email forward deprecated function -
  but that no longer calls this)
  ([29147](https://github.com/civicrm/civicrm-core/pull/29147))**

- **Fix apiv4 Mailing Api to not do scheduling
  ([29138](https://github.com/civicrm/civicrm-core/pull/29138))**

- **(REF) Flexmailer - Simplify service definitions
  ([29163](https://github.com/civicrm/civicrm-core/pull/29163))**

- **Remove guts of civicrm Mailing.preview
  ([29171](https://github.com/civicrm/civicrm-core/pull/29171))**

- **Stop over-sharing - MailingJob::findPendingTasks
  ([29162](https://github.com/civicrm/civicrm-core/pull/29162))**

- **Noisily deprecate & stop using BAO_MailingJob::create
  ([29137](https://github.com/civicrm/civicrm-core/pull/29137))**

- **Use writeRecord from mailing job DAO
  ([29135](https://github.com/civicrm/civicrm-core/pull/29135))**

- **Rationalise MailingJob::queue
  ([29148](https://github.com/civicrm/civicrm-core/pull/29148))**

- **Fix confusion over what function is called when delivering mailing
  ([29149](https://github.com/civicrm/civicrm-core/pull/29149))**

- **Extract refreshMailingGroupCache
  ([29133](https://github.com/civicrm/civicrm-core/pull/29133))**

- **(REF) CiviMail - Remove old/unused page controller
  ([28998](https://github.com/civicrm/civicrm-core/pull/28998))**

### CiviMember

- **Editing an unpaid event registration to add a partial payment crashes
  ([dev/core#5035](https://lab.civicrm.org/dev/core/-/issues/5035):
  [29507](https://github.com/civicrm/civicrm-core/pull/29507))**

- **Setting a default membership type in a contribution page has no effect
  ([dev/core#5051](https://lab.civicrm.org/dev/core/-/issues/5051):
  [29623](https://github.com/civicrm/civicrm-core/pull/29623))**

- **Align membership online receipt with contribution online receipt
  ([29498](https://github.com/civicrm/civicrm-core/pull/29498))**

- **AdminUI: Fix auto renew display on new SK membership tab
  ([29012](https://github.com/civicrm/civicrm-core/pull/29012))**

## Standalone

- **standalone: apply user's timezone during boot ([29282](https://github.com/civicrm/civicrm-core/pull/29282))**

- **standalone: fix ACLs on Roles re core #4862 ([29256](https://github.com/civicrm/civicrm-core/pull/29256))**

- **Standaloneusers API permission lockdown ([28877](https://github.com/civicrm/civicrm-core/pull/28877))**

### Special Topic: Custom Field Caches

- **dev/core#4905 - More efficient loading and caching of custom field metadata ([28975](https://github.com/civicrm/civicrm-core/pull/28975))**

- **dev/core#4905 - Deprecate redundant functions that fetch custom groups ([28990](https://github.com/civicrm/civicrm-core/pull/28990))**

- **dev/core#4905 - Add CRM_Core_BAO_CustomGroup::getAll() with optional filters ([28995](https://github.com/civicrm/civicrm-core/pull/28995))**

- **dev/core#4905 - Deprecate CustomGroup::getAllCustomGroupsByBaseEntity ([28999](https://github.com/civicrm/civicrm-core/pull/28999))**

- **dev/core#4905 - Refactor CustomField::getFields() to use more efficient getter ([29002](https://github.com/civicrm/civicrm-core/pull/29002))**

- **dev/core#4905 - DedupeMerger - Delete detangled function, use api instead ([29006](https://github.com/civicrm/civicrm-core/pull/29006))**

- **dev/core#4905 - Refactor out duplicate CustomField getter functions ([29011](https://github.com/civicrm/civicrm-core/pull/29011))**

- **dev/core#4905 - Refactor SelectValues::getQuicksearchOptions to use caching ([29020](https://github.com/civicrm/civicrm-core/pull/29020))**

- **dev/core#4905 - Refactor legacy CustomGroup getters to use cached data provider ([29027](https://github.com/civicrm/civicrm-core/pull/29027))**

- **dev/core#4905 - Refactor CustomField getters to use cached provider ([29032](https://github.com/civicrm/civicrm-core/pull/29032))**

- **dev/core#4905 - Add CustomGroup::getGroup() function ([29034](https://github.com/civicrm/civicrm-core/pull/29034))**

- **(REF) dev/core#4905 - Cleanup CustomGroup functions to use more efficient getter ([29044](https://github.com/civicrm/civicrm-core/pull/29044))**

- **dev/core#4905 - Improve Afform.get to use cached custom group getter ([29045](https://github.com/civicrm/civicrm-core/pull/29045))**

- **dev/core#4905 - DedupeMerger - Use cached function to get custom groups ([29046](https://github.com/civicrm/civicrm-core/pull/29046))**

- **dev/core#4905 - ImportParser - Use cached function to get custom groups ([29047](https://github.com/civicrm/civicrm-core/pull/29047))**

- **dev/core#4905 - Cleanup customField lookup code in CiviCase ([29050](https://github.com/civicrm/civicrm-core/pull/29050))**

- **(REF) dev/core#4905 - Cleanup customField lookup code in DedupeRule ([29051](https://github.com/civicrm/civicrm-core/pull/29051))**

- **dev/core#4905 - CiviReport - Use cached function to get custom groups & fields ([29054](https://github.com/civicrm/civicrm-core/pull/29054))**

- **(REF) dev/core#4905 - Simplify custom field lookup code in ImportParser ([29089](https://github.com/civicrm/civicrm-core/pull/29089))**

- **(REF) dev/core#4905 ContactType - Use cache to get custom fields ([29094](https://github.com/civicrm/civicrm-core/pull/29094))**

- **dev/core#4905 - Use cached getFieldObject instead of new customField ([29098](https://github.com/civicrm/civicrm-core/pull/29098))**

- **dev/core#4905 - Delete unused buildGroupTree function ([29099](https://github.com/civicrm/civicrm-core/pull/29099))**

- **dev/core#4905 - Use cache to fetch custom groups by contact type ([29100](https://github.com/civicrm/civicrm-core/pull/29100))**

- **dev/core#4905 - Make internal function private again ([29101](https://github.com/civicrm/civicrm-core/pull/29101))**

- **dev/core#4905 - Relocate survey-specific function to CiviCampaign class ([29102](https://github.com/civicrm/civicrm-core/pull/29102))**

- **dev/core#4905 - Simplify CustomValueTable::setValues to use new getter ([29124](https://github.com/civicrm/civicrm-core/pull/29124))**

- **dev/core#4905 - Use new customField getter in a few more places ([29259](https://github.com/civicrm/civicrm-core/pull/29259))**

### Special Topic: Smarty Compatibility

- **Add Smarty4 folder ([380](https://github.com/civicrm/civicrm-packages/pull/380))**

- **Add Smarty5 to packages ([382](https://github.com/civicrm/civicrm-packages/pull/382))**

- **Hack more forward compatibility into Smarty2 ([383](https://github.com/civicrm/civicrm-packages/pull/383))**

- **Bump smarty/smarty from 4.0.0 to 4.3.1 in /smarty4 ([385](https://github.com/civicrm/civicrm-packages/pull/385))**

- **Update to latest Smarty4 ([386](https://github.com/civicrm/civicrm-packages/pull/386))**

- **Run tests on Smarty4 instead of 3
  ([29288](https://github.com/civicrm/civicrm-core/pull/29288))**

- **[Smarty Gencode] Load Smarty3 in Gencode too  ([28774](https://github.com/civicrm/civicrm-core/pull/28774))**

- **[Smarty Gencode] Fixes on clearAllAssign ([29265](https://github.com/civicrm/civicrm-core/pull/29265))**

- **[Smarty Gencode] Switch createSmarty to use functions that work on v2,v3,v4 ([29279](https://github.com/civicrm/civicrm-core/pull/29279))**

- **[Smarty Gencode] Clean up resourcesTest for Smarty3
  ([29266](https://github.com/civicrm/civicrm-core/pull/29266))**

- **[Smarty Gencode] Remove clearAllVars from SessionTest
  ([29263](https://github.com/civicrm/civicrm-core/pull/29263))**

- **[Smarty Gencode] Try removing clearTemplateVars hack from test
  ([29262](https://github.com/civicrm/civicrm-core/pull/29262))**

- **Update Smarty function in snapshop template ([28832](https://github.com/civicrm/civicrm-core/pull/28832))**

- **Register native php functions that we use as Smarty plugins ([29289](https://github.com/civicrm/civicrm-core/pull/29289))**

- **Deprecate a couple of backward compatibility Smarty functions ([29302](https://github.com/civicrm/civicrm-core/pull/29302))**

- **Do not attempt to register string resources for Smarty3+ ([29104](https://github.com/civicrm/civicrm-core/pull/29104))**

- **dev/core#4928 - Smarty3 filenames generated by singleUseString are invalid on windows ([29056](https://github.com/civicrm/civicrm-core/pull/29056))**

- **dev/core#4951 Add support for Smarty debugging ([29183](https://github.com/civicrm/civicrm-core/pull/29183))**

- **Use upper not strtoupper in Smarty as that is supported going forwards ([29321](https://github.com/civicrm/civicrm-core/pull/29321))**

- **Remove calls to get_template_vars, template_exists ([29411](https://github.com/civicrm/civicrm-core/pull/29411))**

- **Add str_starts_with modifier to Smarty ([29337](https://github.com/civicrm/civicrm-core/pull/29337))**

- **Stop using intval in Smarty ([29323](https://github.com/civicrm/civicrm-core/pull/29323))**

- **Add smarty mixin (replaces smartyv2 for clarify only) ([29187](https://github.com/civicrm/civicrm-core/pull/29187))**

- **Stop calling assign_by_ref on Smarty ([29414](https://github.com/civicrm/civicrm-core/pull/29414))**

- **Fix SmartyCompatibility to use php8.3 friendly function ([29415](https://github.com/civicrm/civicrm-core/pull/29415))**

- **Update Smarty autoload constant to be version agnostic ([29185](https://github.com/civicrm/civicrm-core/pull/29185))**

- **Remove getTemplateVars() override now that it happens in Smarty2 ([29184](https://github.com/civicrm/civicrm-core/pull/29184))**

- **Move messageTemplate call out of create Smarty ([29261](https://github.com/civicrm/civicrm-core/pull/29261))**

- **dev/core#4955 Hack Smarty3+ getTemplateVars into Smarty2 ([381](https://github.com/civicrm/civicrm-packages/pull/381))**

- **(REF) Fix Smarty Notice on missing hideRelativeLabel ([29087](https://github.com/civicrm/civicrm-core/pull/29087))**

- **Fix Smarty notice when a single contact is deleted (not from search) ([29238](https://github.com/civicrm/civicrm-core/pull/29238))**

- **Smarty notice fix ([29151](https://github.com/civicrm/civicrm-core/pull/29151))**

- **Smarty notice fix ([29231](https://github.com/civicrm/civicrm-core/pull/29231))**

- **Fix a few tests to be Smarty3 friendly
  ([29257](https://github.com/civicrm/civicrm-core/pull/29257))**

## <a name="misc"></a>Miscellany

- **Bump phpseclib/phpseclib from 2.0.31 to 2.0.47
  ([29620](https://github.com/civicrm/civicrm-core/pull/29620))**

- **Bump phenx/php-svg-lib from 0.5.1 to 0.5.2
  ([29469](https://github.com/civicrm/civicrm-core/pull/29469))**

- **(NFC) test fix for leap year
  ([29515](https://github.com/civicrm/civicrm-core/pull/29515))**

- **dev/core#5006 Add test for self_cancel
  ([29509](https://github.com/civicrm/civicrm-core/pull/29509))**

- **(NFC) Remove redundant deprecated checks for assertObjectHasAttribute
  ([29336](https://github.com/civicrm/civicrm-core/pull/29336))**

- **Disable failing test in PR runs for now
  ([29242](https://github.com/civicrm/civicrm-core/pull/29242))**

- **APIv4 - Remove unused PerformanceTest
  ([29077](https://github.com/civicrm/civicrm-core/pull/29077))**

- **dev/core#4847 - Add test to verify APIv4 Activity ACL works properly
  ([29055](https://github.com/civicrm/civicrm-core/pull/29055))**

- **Update Event RegisterTest form to use the FormTrait
  ([28988](https://github.com/civicrm/civicrm-core/pull/28988))**

- **Test helper fix, link price set ID if passed in
  ([28989](https://github.com/civicrm/civicrm-core/pull/28989))**

- **Minor clean up in test class
  ([28951](https://github.com/civicrm/civicrm-core/pull/28951))**

- **Remove now-unused test-template
  ([28968](https://github.com/civicrm/civicrm-core/pull/28968))**

- **Minor clean up in test class
  ([28981](https://github.com/civicrm/civicrm-core/pull/28981))**

- **Switch confirmTest to use the form wrapper
  ([28937](https://github.com/civicrm/civicrm-core/pull/28937))**

- **Add test cover for event additional profiles
  ([28891](https://github.com/civicrm/civicrm-core/pull/28891))**

- **(REF) Move paymentProcessorAuthorizeNetCreate test function to authorizenet
  test trait ([28925](https://github.com/civicrm/civicrm-core/pull/28925))**

- **(REF) Minor cleanup in handling of additional participants when sending
  mail + improve test
  ([28889](https://github.com/civicrm/civicrm-core/pull/28889))**

- **Fix Profile set up in test configuration
  ([28899](https://github.com/civicrm/civicrm-core/pull/28899))**

- **(NFC) CoreExt - Cleanup boilerplate from extension readmes
  ([29340](https://github.com/civicrm/civicrm-core/pull/29340))**

- **(NFC) Deprecated class name for abstract classes in phpunit
  ([29335](https://github.com/civicrm/civicrm-core/pull/29335))**

- **(NFC) CustomField - Add @deprecated notice to old function
  ([29009](https://github.com/civicrm/civicrm-core/pull/29009))**

- **(NFC) composer.json - Add comments block for the `patches` section
  ([29028](https://github.com/civicrm/civicrm-core/pull/29028))**

- **(NFC) ContactType - Cleanup function docs & type hints
  ([28996](https://github.com/civicrm/civicrm-core/pull/28996))**

- **(NFC) Simplify translatePermission() switch statement
  ([28835](https://github.com/civicrm/civicrm-core/pull/28835))**

- **setting-admin@1 - Bump version
  ([29322](https://github.com/civicrm/civicrm-core/pull/29322))**

- **Restore membership types in tearDown
  ([28680](https://github.com/civicrm/civicrm-core/pull/28680))**

- **EventCart - Update readme to reflect current state
  ([29341](https://github.com/civicrm/civicrm-core/pull/29341))**

- **ContributionBase - Remove unused code
  ([29281](https://github.com/civicrm/civicrm-core/pull/29281))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Justin Freeman; Artful Robot - Rich Lott; Christian Wach; Circle Interactive - Pradeep Nayak; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy; Dave D; Fuzion - Jitendra Purohit; Humanists UK - Andrew West;; JMA Consulting - Seamus Lee; John Kingsnorth; Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire; Progressive Technology Project - Jamie McClelland; Reflexive Communications - Sandor Semsey; Stephen Palmstrom; Third Sector Design - Kurund Jalmi, William Mortada; University of Waterloo - Patrick Lam; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Chris Garaffa; Andy Burns; ASMAC (American Society of Music Arrangers and Composers) - Jeff Kellem; BrightMinded Ltd - Bradley Taylor; civiservice.de - Detlev Sieber; Coop SymbioTIC - Samuel Vanhove; Francesc Bassas i Bullich; Greenleaf Advancement - Guy Iaccarino; JMA Consulting - Joe Murray; Nicol Wistreich; Squiffle Consulting - Aidan Saunders; Systopia - Dominic Tubach; Tadpole Collective - Kevin Cristiano

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
