# CiviCRM 5.74.0

Released June 6, 2024

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### CiviCRM Core

- **Imagine a world without CodeGen (Work Towards
  [dev/core#4999](https://lab.civicrm.org/dev/core/-/issues/4999):
  [29472](https://github.com/civicrm/civicrm-core/pull/29472),
  [29988](https://github.com/civicrm/civicrm-core/pull/29988),
  [30016](https://github.com/civicrm/civicrm-core/pull/30016) and
  [30021](https://github.com/civicrm/civicrm-core/pull/30021))**

  Works towards a world without code gen by fixing delegation for queued upgrade
  tasks and converting xml schema to new entityType.php format.

- **Upgrade Smarty to 5.1.0.0
  ([396](https://github.com/civicrm/civicrm-packages/pull/396))**

  Upgrades Smarty to 5.1.0.0.

- **Switch default smarty for localhost, demo to Smarty5
  ([29909](https://github.com/civicrm/civicrm-core/pull/29909))**

  Defaults demo to Smarty5.

- **Remove text version of some more message templates
  ([30041](https://github.com/civicrm/civicrm-core/pull/30041),
  [30040](https://github.com/civicrm/civicrm-core/pull/30040),
  [30038](https://github.com/civicrm/civicrm-core/pull/30038) and
  [30039](https://github.com/civicrm/civicrm-core/pull/30039))**

  Removes text versions of some more message templates. If no text version is
  entered, text is generated based on the html version.

- **Add support for saving custom data on option values
  ([29929](https://github.com/civicrm/civicrm-core/pull/29929))**

  Adds support for custom data on option values.

- **Afform - Allow 'Current Date' as a value option for date fields
  ([29986](https://github.com/civicrm/civicrm-core/pull/29986))**

  Makes it so one can set "Current Date" as a value option for date fields in
  Afform.

- **Afform - enable autocomplete id filter on search forms
  ([29919](https://github.com/civicrm/civicrm-core/pull/29919))**

  Permits the ID field to be used as an autocomplete on search forms.

- **Angular Datepicker - Default to +-100 year range
  ([29885](https://github.com/civicrm/civicrm-core/pull/29885))**

  Makes Angular Datepickers default to +-100 year range.

- **OAuth - Add permission implications
  ([29950](https://github.com/civicrm/civicrm-core/pull/29950))**

  Adds a logical relationship between the 2 permissions declared by OAuth.

- **Update UserJob status & date fields as it progresses
  ([29981](https://github.com/civicrm/civicrm-core/pull/29981))**

  Ensures UserJob start & end date are updated appropriately, and the job
  progresses through draft->scheduled->in progress->completed.

- **Add expires_date as an editable field to "my imports" and "all imports" SK
  ([29977](https://github.com/civicrm/civicrm-core/pull/29977))**

  Makes the expiration date an editable field on SearchKit import screens.

- **Feature request - APIv4 Get action, provide ability to define aliases for
  the select fields so that external integrations with CiviCRM do not break
  when the field name changes OR a different field is selected (Work Towards
  [dev/core#3738](https://lab.civicrm.org/dev/core/-/issues/3738):
  [29714](https://github.com/civicrm/civicrm-core/pull/29714))**

  Adds APIv4 rekey function.

- **Improve support for German dates on import
  ([30067](https://github.com/civicrm/civicrm-core/pull/30067))**

  Improves supports for German dates when importing.

- **SMS Provider searchkit admin ui
  ([29567](https://github.com/civicrm/civicrm-core/pull/29567))**

  Converts the SMS Provider page to searchkit.

- **Permissions - Allow hooks/extensions to declare implied permissions  
  ([29940](https://github.com/civicrm/civicrm-core/pull/29940))**

  Enables extensions to take advantage of implied permissions.

- **CRM_Admin_Form_Setting_Url: use metadata for enableSSL, verifySSL fields
  ([30075](https://github.com/civicrm/civicrm-core/pull/30075))**

  Improves user experience when editing SSL settings.

### CiviEvent

- **Update participant import to work on updates (with participant ID)
  ([30052](https://github.com/civicrm/civicrm-core/pull/30052))**

  Makes it so one can update participant records by import using a participant
  ID.

### CiviMail

- **Call hooks when recording mailing open
  ([29887](https://github.com/civicrm/civicrm-core/pull/29887))**

  Ensures hooks are called when a mailing open event is recorded.

### Backdrop Integration

- **Support oEmbed for external facing pages
  (Work Towards [dev/core#2994](https://lab.civicrm.org/dev/core/-/issues/2994):
  [29928](https://github.com/civicrm/civicrm-core/pull/29928))**

  Adds support for IFrame Connector extension (to allow remote iframes) for
  backdrop.

### Standalone Integration

- **Standalone - Add permission implications
  ([29945](https://github.com/civicrm/civicrm-core/pull/29945))**

  Adds a logical relationship between the 2 permissions declared by standalone.

- **standalone: password change screen
  ([29788](https://github.com/civicrm/civicrm-core/pull/29788))**

  Sets up a password change screen for standalone integrations.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **`testLocalizedData()` failing after recent strings update
  ([dev/translation#84](https://lab.civicrm.org/dev/translation/-/issues/84):
  [30141](https://github.com/civicrm/civicrm-core/pull/30141))**

- **API Deprecation (Work Towards
  [dev/core#4846](https://lab.civicrm.org/dev/core/-/issues/4846):
  [30026](https://github.com/civicrm/civicrm-core/pull/30026))**

  Fixes call to deprecated function.

- **Formbuilder: Individual 1 fields are refreshed to their initial values
  (updates are lost) as soon as a Individual 2 contact is chosen in an existing
  contact field
  ([dev/core#5094](https://lab.civicrm.org/dev/core/-/issues/5094):
  [29832](https://github.com/civicrm/civicrm-core/pull/29832))**

  Afform fix prefill of one entity overwriting 'current user'.

- **Scheduled Reminders: with multi-lingual, the language filters are empty
  ([dev/core#5116](https://lab.civicrm.org/dev/core/-/issues/5116):
  [30131](https://github.com/civicrm/civicrm-core/pull/30131))**

  Fixes missing language selector for scheduled reminders.

- **Wrong Link from Administer page to Date Preferences page
  ([dev/core#5139](https://lab.civicrm.org/dev/core/-/issues/5139):
  [30147](https://github.com/civicrm/civicrm-core/pull/30147))**

- **Can't select parent menu when cloning report
  ([dev/core#5141](https://lab.civicrm.org/dev/core/-/issues/5141):
  [30143](https://github.com/civicrm/civicrm-core/pull/30143))**

- **Non-admin users unable to view Contact Reports menu item
  ([dev/core#5148](https://lab.civicrm.org/dev/core/-/issues/5148):
  [30064](https://github.com/civicrm/civicrm-core/pull/30064))**

- **Do not use wysiwyg editor for system workflow message when workflow_name is
  set ([dev/core#5154](https://lab.civicrm.org/dev/core/-/issues/5154):
  [29999](https://github.com/civicrm/civicrm-core/pull/29999))**

- **Deleting a individual contact gives: The contact might be the Membership
  Organization of a Membership Type when the contact is not an organisation
  ([dev/core#5165](https://lab.civicrm.org/dev/core/-/issues/5165):
  [30053](https://github.com/civicrm/civicrm-core/pull/30053))**

- **Required radio buttons don't display "This field is required."
  ([dev/core#5167](https://lab.civicrm.org/dev/core/-/issues/5167):
  [30060](https://github.com/civicrm/civicrm-core/pull/30060))**

- **System Workflow Message regression: html, head, body tags disappear
  ([dev/core#5176](https://lab.civicrm.org/dev/core/-/issues/5176):
  [30204](https://github.com/civicrm/civicrm-core/pull/30204))**

- **CiviCRM 5.72.1 and newer, PHP 8.x - Smart groups trigger a PHP Fatal error
  and no longer load if the saved search criteria refers to any custom fields
  which have been deleted
  ([dev/core#5185](https://lab.civicrm.org/dev/core/-/issues/5185):
  [30104](https://github.com/civicrm/civicrm-core/pull/30104))**

- **Some emails not shown when editing a contact in non-inline mode
  ([dev/core#5208](https://lab.civicrm.org/dev/core/-/issues/5208):
  [30196](https://github.com/civicrm/civicrm-core/pull/30196))**

- **Can't cancel recurring contributions if CiviMember is not enabled
  (regression) ([dev/core#5226](https://lab.civicrm.org/dev/core/-/issues/5226):
  [30226](https://github.com/civicrm/civicrm-core/pull/30226))**

- **Api4 - Set 'usage' property for custom fields
  ([30058](https://github.com/civicrm/civicrm-core/pull/30058))**

  Sets property for custom fields in APIv4 to be equivalent to core fields.

- **Reduce import controller boiler plate
  ([29978](https://github.com/civicrm/civicrm-core/pull/29978))**

- **Assign highlighted fields as json
  ([29976](https://github.com/civicrm/civicrm-core/pull/29976))**

- **SearchKit - Move search tasks to their respective component-extensions
  ([29747](https://github.com/civicrm/civicrm-core/pull/29747))**

- **SearchKit - Add conditional rule for membershipStatus links
  ([29745](https://github.com/civicrm/civicrm-core/pull/29745))**

  Adds conditional rules to enforce the status-quo in Admin UI.

- **add missing cms: prefix to permission check
  ([29946](https://github.com/civicrm/civicrm-core/pull/29946))**

- **Smarty 3/4 - Fix prepending extension template directories
  ([30148](https://github.com/civicrm/civicrm-core/pull/30148))**

- **Smarty3/4 compatibility for Address.tpl
  ([29968](https://github.com/civicrm/civicrm-core/pull/29968))**

- **Message templates admin page crashes with smarty 5
  ([30070](https://github.com/civicrm/civicrm-core/pull/30070))**

- **support 'current user' as value in Afform
  ([30089](https://github.com/civicrm/civicrm-core/pull/30089))**

- **Partially convert recur updateOnNewPayment to API4
  ([30062](https://github.com/civicrm/civicrm-core/pull/30062))**

- **Afform - Fix 'Edit' links to always go to backend
  ([29922](https://github.com/civicrm/civicrm-core/pull/29922))**

- **Regression: Custom field file type not saved on entity
  ([30191](https://github.com/civicrm/civicrm-core/pull/30191))**

- **SampleData - Add missing customGroup weights
  ([29984](https://github.com/civicrm/civicrm-core/pull/29984))**

- **SearchKit - Fix SearchSegment state/province
  ([29927](https://github.com/civicrm/civicrm-core/pull/29927))**

- **Guard against missing saved search class during smart group cache rebuild
  ([29956](https://github.com/civicrm/civicrm-core/pull/29956))**

- **Afform - Fix edit links permission for multiple users
  ([30205](https://github.com/civicrm/civicrm-core/pull/30205))**

- **Fix setTemplateDir to actually work
  ([397](https://github.com/civicrm/civicrm-packages/pull/397))**

- **Stop passing ids to function that does not use them
  ([30049](https://github.com/civicrm/civicrm-core/pull/30049))**

- **Fix rendering default value of autocomplete fields
  ([30199](https://github.com/civicrm/civicrm-core/pull/30199))**

- **Fix invalid date with STRICT SQL mode
  ([29916](https://github.com/civicrm/civicrm-core/pull/29916) and
  [29921](https://github.com/civicrm/civicrm-core/pull/29921))**

- **avoid deprecation notice if header is null
  ([29901](https://github.com/civicrm/civicrm-core/pull/29901))**

- **Fix wrong function in error message
  ([29894](https://github.com/civicrm/civicrm-core/pull/29894))**

- **Fix function to use apiv4
  ([30006](https://github.com/civicrm/civicrm-core/pull/30006))**

- **Fix double passing of same params to private function
  ([30009](https://github.com/civicrm/civicrm-core/pull/30009))**

- **Stop setting now-already-set id
  ([30003](https://github.com/civicrm/civicrm-core/pull/30003))**

- **PHP8 - Fix wordReplacement function to always return an array
  ([29934](https://github.com/civicrm/civicrm-core/pull/29934))**

- **Include schema in tarball - so that civicrm can be installed
  ([30150](https://github.com/civicrm/civicrm-core/pull/30150))**

- **Default values having ampersand (`&`) displayed as `&amp;` ([dev/core#5252](https://lab.civicrm.org/dev/core/-/issues/5252): [#30331](https://github.com/civicrm/civicrm-core/pull/30331))**
- **ContactSummary - Ensure tabs are refreshed with admin_ui enabled ([dev/core#5171](https://lab.civicrm.org/dev/core/-/issues/5171): [#30344](https://github.com/civicrm/civicrm-core/pull/30344))**
- **Tokens -  Newer style tokesn (with quotes) should work with HTML encoding ([dev/core#5199](https://lab.civicrm.org/dev/core/-/issues/5199): [#30330](https://github.com/civicrm/civicrm-core/pull/30330))**

### CiviCase

- **Similar to 30189 - customgroup::getGroupDetail is case-sensitive now
  ([30190](https://github.com/civicrm/civicrm-core/pull/30190))**

- **Case custom fields no longer appearing on print report
  ([30189](https://github.com/civicrm/civicrm-core/pull/30189))**

- **Crash in Smarty 5 on Manage Case ([#30325](https://github.com/civicrm/civicrm-core/pull/30325))**

### CiviContribute

- **Contribution pending status wrong
  ([dev/core#5070](https://lab.civicrm.org/dev/core/-/issues/5070):
  [30165](https://github.com/civicrm/civicrm-core/pull/30165))**

  Fix failure to set is_pay_later on back office.

- **Improve loading of PriceField metadata on Contribution Form to avoid notice
  ([29936](https://github.com/civicrm/civicrm-core/pull/29936))**

- **Align price field loading with other forms to address notice
  ([30078](https://github.com/civicrm/civicrm-core/pull/30078))**

- **On contribution forms, checkbox fields don't save all options selected
  ([dev/core#5212](https://lab.civicrm.org/dev/core/-/issues/5212):
  [30233](https://github.com/civicrm/civicrm-core/pull/30233))**

- **Move BAO/Contribute to api4 not api3, replacing getvalue/getsingle
  ([29992](https://github.com/civicrm/civicrm-core/pull/29992))**

- **Use pan_truncation where present on form
  ([30223](https://github.com/civicrm/civicrm-core/pull/30223))**

- **Fix calculation on amount allocation for tax line to happen in main loop
  ([29947](https://github.com/civicrm/civicrm-core/pull/29947))**

- **Resolve issue with Payment allocation for Sales Item
  ([30017](https://github.com/civicrm/civicrm-core/pull/30017))**

- **Alternate fix to remove extraneous tax display
  ([29889](https://github.com/civicrm/civicrm-core/pull/29889))**

- **Contribution page confirmation page help text says click continue but the
  button actually says "Make Contribution"
  ([dev/core#5155](https://lab.civicrm.org/dev/core/-/issues/5155):
  [30000](https://github.com/civicrm/civicrm-core/pull/30000))**

- **""Send Letter"" - Crashes while rendering help widget ([dev/core#5250](https://lab.civicrm.org/dev/core/-/issues/5250): [#30298](https://github.com/civicrm/civicrm-core/pull/30298))**

### CiviEvent

- **Update import/participant url to match new standardised name
  ([30056](https://github.com/civicrm/civicrm-core/pull/30056))**

- **CiviEvent: Online registration of multiple participants is broken (if no
  waitlist activated)
  ([dev/core#5168](https://lab.civicrm.org/dev/core/-/issues/5168):
  [30124](https://github.com/civicrm/civicrm-core/pull/30124))**

- **Custom data displayed twice ([#30341](https://github.com/civicrm/civicrm-core/pull/30341))**
- **"Total amount" on some event registrations is showing wrong amounts ([#30335](https://github.com/civicrm/civicrm-core/pull/30335))**
- **Some custom event fields don't display on "Event Info" form ([#30336](https://github.com/civicrm/civicrm-core/pull/30336))**

### CiviMail

- **“Save & Send Test Email” should call the alterMailParams hook to replicate
  live conditions
  ([dev/core#5151](https://lab.civicrm.org/dev/core/-/issues/5151):
  [29995](https://github.com/civicrm/civicrm-core/pull/29995))**

### CiviMember

- **Assign weights on membership tab
  ([30108](https://github.com/civicrm/civicrm-core/pull/30108))**

- **Fix notice on membership form by loading price field information in
  standardised way
  ([30079](https://github.com/civicrm/civicrm-core/pull/30079))**

- **Membership price fields ignored in backend
  ([dev/core#5147](https://lab.civicrm.org/dev/core/-/issues/5147):
  [29982](https://github.com/civicrm/civicrm-core/pull/29982))**

### CiviPledge

- **Clean up smarty notices on pledge view
  ([29705](https://github.com/civicrm/civicrm-core/pull/29705))**

### Backdrop Integration

- **Correct CRMDatabasePrefix() for Backdrop
 ([dev/core#5158](https://lab.civicrm.org/dev/core/-/issues/5158):
 [30015](https://github.com/civicrm/civicrm-core/pull/30015))**

### Drupal Integration

- **Fix broken user account profile tab in drupal 10
  ([29965](https://github.com/civicrm/civicrm-core/pull/29965))**

- **Drupal 10 - Fix breadcrumbs with id tokens
  ([29958](https://github.com/civicrm/civicrm-core/pull/29958))**

- **composer.json - Explicitly allow dev-master
  ([91](https://github.com/civicrm/civicrm-drupal-8/pull/91))**

### Joomla Integration

- **KC Finder Not Working Under Joomla 4
  ([dev/joomla#46](https://lab.civicrm.org/dev/joomla/-/issues/46):
  [374](https://github.com/civicrm/civicrm-packages/pull/374))**

### Standalone Integration

- **Standalone - ensure id value is an int for comparison check when changing
  password ([29895](https://github.com/civicrm/civicrm-core/pull/29895))**

- **Standalone installer - fix admin not getting admin role
  ([30136](https://github.com/civicrm/civicrm-core/pull/30136))**

- **Standalone cms permissions are civi permissions
  ([dev/core#5125](https://lab.civicrm.org/dev/core/-/issue/5125):
  [29896](https://github.com/civicrm/civicrm-core/pull/29896))**

### WordPress Integration

- **Fix Asset Builder links in Afform Shortcodes
  ([324](https://github.com/civicrm/civicrm-wordpress/pull/324))**

- **Skip Base Page test when there is no Post object
  ([317](https://github.com/civicrm/civicrm-wordpress/pull/317))**

- **Declare class property to avoid PHP warning
  ([323](https://github.com/civicrm/civicrm-wordpress/pull/323))**

- **Use base page URL function to build links in multiple Shortcodes
  ([313](https://github.com/civicrm/civicrm-wordpress/pull/313))**

## <a name="misc"></a>Miscellany

- **Update AuthSasl Net_SMTP and Net_Socket packages
  ([30066](https://github.com/civicrm/civicrm-core/pull/30066))**

- **Use addPluginsDir rather than non-public property
  ([30158](https://github.com/civicrm/civicrm-core/pull/30158))**

- **Extract our code to override addPluginsDir
  ([401](https://github.com/civicrm/civicrm-packages/pull/401))**

- **Backport addPluginsDir to Smarty2
  ([398](https://github.com/civicrm/civicrm-packages/pull/398))**

- **Upgrader - Delete old schemaStructure files
  ([30045](https://github.com/civicrm/civicrm-core/pull/30045))**

- **Use loaded balance_amount
  ([29990](https://github.com/civicrm/civicrm-core/pull/29990))**

- **Use apiv4 to getFields for participant import
  ([30048](https://github.com/civicrm/civicrm-core/pull/30048))**

- **Tidy up Import StateMachine & Controller
  ([30044](https://github.com/civicrm/civicrm-core/pull/30044))**

- **DAO - Add getter function for labelField
  ([30013](https://github.com/civicrm/civicrm-core/pull/30013))**

- **Use Apiv4 rather than funky function to get line items
  ([29964](https://github.com/civicrm/civicrm-core/pull/29964))**

- **Switch from apv3 to apiv4 within Payment.create
  ([29966](https://github.com/civicrm/civicrm-core/pull/29966))**

- **Regen - message templates out of date
  ([30069](https://github.com/civicrm/civicrm-core/pull/30069))**

- **Regenerate schema files with core-style fixes
  ([30014](https://github.com/civicrm/civicrm-core/pull/30014))**

- **regen - node 16 deprecated in github actions
  ([30011](https://github.com/civicrm/civicrm-core/pull/30011))**

- **Switch to already loaded paid_amount
  ([30005](https://github.com/civicrm/civicrm-core/pull/30005))**

- **Clean up some no-longer-used properties
  ([30008](https://github.com/civicrm/civicrm-core/pull/30008))**

- **Fold function back into the main scope, simplify, use apiv4
  ([29944](https://github.com/civicrm/civicrm-core/pull/29944))**

- **Switch function to apiv4, minor cleanup
  ([29943](https://github.com/civicrm/civicrm-core/pull/29943))**

- **AdminUI - Remove redundant conditionals
  ([29942](https://github.com/civicrm/civicrm-core/pull/29942))**

- **Further cleanup on arrays in payment create.
  ([29913](https://github.com/civicrm/civicrm-core/pull/29913))**

- **Consolidate some of the subtype wrangling code in dedupe finder
  ([29862](https://github.com/civicrm/civicrm-core/pull/29862))**

- **Fold function back into only caller
  ([29937](https://github.com/civicrm/civicrm-core/pull/29937))**

- **Fix comments ([29974](https://github.com/civicrm/civicrm-core/pull/29974))**

- **Fix some CRM_Utils_array to ... not be
  ([29952](https://github.com/civicrm/civicrm-core/pull/29952))**

- **Move the code to generate payableItems back into getPayableItems
  ([29989](https://github.com/civicrm/civicrm-core/pull/29989))**

- **Unravel variable variables  
  ([29951](https://github.com/civicrm/civicrm-core/pull/29951))**

- **Fix old merge conflict mis-resolution, superficial tidy up
  ([30082](https://github.com/civicrm/civicrm-core/pull/30082))**

- **UtilsArray - Refactor out deprecated value() in array assignments  
  ([29925](https://github.com/civicrm/civicrm-core/pull/29925))**

- **Remove a few more variable variables
  ([29953](https://github.com/civicrm/civicrm-core/pull/29953))**

- **Remove deprecated function
  ([29796](https://github.com/civicrm/civicrm-core/pull/29796))**

- **Remove function that no longer does much of anything
  ([30036](https://github.com/civicrm/civicrm-core/pull/30036))**

- **Remove function deprecated in 2022, after universe search
  ([30033](https://github.com/civicrm/civicrm-core/pull/30033))**

- **Remove some unreachable legacy code
  ([30032](https://github.com/civicrm/civicrm-core/pull/30032))**

- **Remove cancerous unreachable code
  ([30050](https://github.com/civicrm/civicrm-core/pull/30050))**

- **Remove a couple of utils_array::value
  ([30042](https://github.com/civicrm/civicrm-core/pull/30042))**

- **Remove unused properties
  ([29980](https://github.com/civicrm/civicrm-core/pull/29980))**

- **Remove always true if from previously shared code
  ([29941](https://github.com/civicrm/civicrm-core/pull/29941))**

- **Remove unused variable + some test tidy up
  ([29904](https://github.com/civicrm/civicrm-core/pull/29904))**

- **Remove deprecated functions that were on their final notice
  ([29905](https://github.com/civicrm/civicrm-core/pull/29905))**

- **Remove deprecated function
  ([30090](https://github.com/civicrm/civicrm-core/pull/30090))**

- **[REF] Start to use sane arrays in Payment create
  ([29893](https://github.com/civicrm/civicrm-core/pull/29893))**

- **[REF] Use standard DeleteMessage functionality from EntityFormTrait for
  OptionValues ([29930](https://github.com/civicrm/civicrm-core/pull/29930))**

- **[REF] Autocleanup - Remove redundant conditions
  ([29935](https://github.com/civicrm/civicrm-core/pull/29935))**

- **[REF] Refactor out deprecated CRM_Utils_Array from UFGroup class
  ([29932](https://github.com/civicrm/civicrm-core/pull/29932))**

- **[REF] Refactor out deprecated CRM_Utils_Array from some BAO classes
  ([29933](https://github.com/civicrm/civicrm-core/pull/29933))**

- **[REF] CustomGroup BAO function cleanup
  ([29985](https://github.com/civicrm/civicrm-core/pull/29985))**

- **[REF] Payment.create - Combine the 2 calls to LineItem.get
  ([30010](https://github.com/civicrm/civicrm-core/pull/30010))**

- **(REF) `ts()` - Move from class-file to `functions.php`
  ([30071](https://github.com/civicrm/civicrm-core/pull/30071))**

- **(REF) Drop references to `require_once "CRM/Core/I18n.php"`
  ([30072](https://github.com/civicrm/civicrm-core/pull/30072))**

- **[NFC] APIv4 - Add documentation comments to addJoin() function
  ([29899](https://github.com/civicrm/civicrm-core/pull/29899))**

- **[NFC] UtilsCheck - Improve docblock comments
  ([29959](https://github.com/civicrm/civicrm-core/pull/29959))**

- **[NFC] space error in a ts in the event receipt template
  ([29970](https://github.com/civicrm/civicrm-core/pull/29970))**

- **[NFC] Fix registration confirmtest
  ([30073](https://github.com/civicrm/civicrm-core/pull/30073))**

- **NFC: Rewrite "is_page_request" method for comment
  ([325](https://github.com/civicrm/civicrm-wordpress/pull/325))**

- **Notice fixes in test, use preferred helper
  ([30080](https://github.com/civicrm/civicrm-core/pull/30080))**

- **Test handling for path argument
  ([30076](https://github.com/civicrm/civicrm-core/pull/30076))**

- **Fix some tests to not rely on natural sort (implicit id)
  ([29915](https://github.com/civicrm/civicrm-core/pull/29915))**

- **Fix test to use full form flow
  ([29906](https://github.com/civicrm/civicrm-core/pull/29906))**

- **CRM_Utils_Cache_Tiered - Fix test failure on Standalone
  ([30095](https://github.com/civicrm/civicrm-core/pull/30095))**

- **Fix test to test form, not a deprecated function
  ([29907](https://github.com/civicrm/civicrm-core/pull/29907))**

- **Fix test to use full form flow
  ([29903](https://github.com/civicrm/civicrm-core/pull/29903))**

- **Update tests to orderBy amount rather than rely on id order
  ([29897](https://github.com/civicrm/civicrm-core/pull/29897))**

- **Crash in Smarty 5 if you have the fulltext block enabled ([#30326](https://github.com/civicrm/civicrm-core/pull/30326), [#30296](https://github.com/civicrm/civicrm-core/pull/30296))**
- **5.74 release notes first pass ([#30305](https://github.com/civicrm/civicrm-core/pull/30305))**
- **Port Point Release Notes to RC branch ([#30304](https://github.com/civicrm/civicrm-core/pull/30304))**
- **DaoBase - Move class to correct directory  ([#30306](https://github.com/civicrm/civicrm-core/pull/30306))**
- **Hold back recent deprecation ([#30332](https://github.com/civicrm/civicrm-core/pull/30332))**
- **Smarty - Remove duplicate template dirs ([#30290](https://github.com/civicrm/civicrm-core/pull/30290))**
- **Smarty - Allow setting version via environment variable ([#30272](https://github.com/civicrm/civicrm-core/pull/30272))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Agileware Team, Francis Whittle; angelajackson07; Artful
Robot - Rich Lott; Benjamin W; Christian Wach; Circle Interactive - Pradeep
Nayak; CiviCRM - Coleman Watts, Tim Otten; Compuco - Olayiwola Odunsi; Coop
SymbioTIC - Samuel Vanhove; CrusonWeb - Dan Cruson; CSES (Chelmsford Science and
Engineering Society) - Adam Wood; Dave D; Francesc Bassas i Bullich; Freeform
Solutions - Herb van den Dool; Fuzion - Jitendra Purohit; Jens Schuppe; JMA
Consulting - Seamus Lee; John Kingsnorth; Megaphone Technology Consulting - Jon
Goldberg; MJW Consulting - Matthew Wire; Nicol Wistreich; Progressive Technology
Project - Jamie McClelland; Reflexive Communications - Sandor Semsey; Squiffle
Consulting - Aidan Saunders; Stephen Palmstrom; Tadpole Collective - Kevin
Cristiano; Third Sector Design - Michael McAndrew, William Mortada; Wikimedia
Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Alice Frumin; Agileware - Justin Freeman; ALL IN APPLI admin;
Australian Greens - John Twyman; CiviDesk - Yashodha Chaku; civiservice.de -
Detlev Sieber; CompuCorp - Omar Abu Hussein; Coop SymbioTIC - Mathieu Lutfy,
mmyriam; Fransly; Fuzion - Luke Stewart; Guydn; Levi.k;

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
