# CiviCRM 5.79.0

Released November 6, 2024

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### CiviCRM Core

- **Add timestamp as a crmDate option
  ([31110](https://github.com/civicrm/civicrm-core/pull/31110))**

  Adds timestamp as a crmDate option.

- **afform_login_token - Re-import login-token feature as core extension  
  ([31388](https://github.com/civicrm/civicrm-core/pull/31388))**

  Re-introduces afform login-token support as a core-extension.

- **Transactional Authentication (Page-level auth tokens)
  ([dev/core#4462](https://lab.civicrm.org/dev/core/-/issues/4462):
  [31357](https://github.com/civicrm/civicrm-core/pull/31357),
  [31386](https://github.com/civicrm/civicrm-core/pull/31386),
  [31151](https://github.com/civicrm/civicrm-core/pull/31151) and
  [30585](https://github.com/civicrm/civicrm-core/pull/30585))**

  Improves the support for transactional approaches in the authentication
  framework.

- **SearchKit - Improve appearance and usability of pager
  ([31026](https://github.com/civicrm/civicrm-core/pull/31026))**

  Improves the appearance and usability of the searchkit pager.

- **SearchKit - Hierarchical entity displays
  ([31189](https://github.com/civicrm/civicrm-core/pull/31189))**

  Makes it possible to visualize nested hierarchies in search display tables.

- **SearchKit - Selectable option-value format
  ([31100](https://github.com/civicrm/civicrm-core/pull/31100))**

  Improves the user experience of SearchKit option-value select format.

- **ChartKit - add week as a date rounding option
  ([31138](https://github.com/civicrm/civicrm-core/pull/31138))**

  Adds week as an additional rounding bucket option for Datetime columns.

- **ChartKit - add new chart type: Series Chart
  ([31133](https://github.com/civicrm/civicrm-core/pull/31133))**

  Adds additional chart kit chart type Series Chart.

- **Allow disabling household contact type
  ([dev/core#4470](https://lab.civicrm.org/dev/core/-/issues/4470):
  [31165](https://github.com/civicrm/civicrm-core/pull/31165))**

  Makes it so users can disable the household contact type.

- **Schema - Add support for default_callback functions
  ([31172](https://github.com/civicrm/civicrm-core/pull/31172),
  [31204](https://github.com/civicrm/civicrm-core/pull/31204) and
  [31202](https://github.com/civicrm/civicrm-core/pull/31202))**

  Makes entity create functions more metadata-driven by allowing a callback to
  supply field default values.

### CiviCase

- **Add Regions to the Case View template
  ([31164](https://github.com/civicrm/civicrm-core/pull/31164))**

  Adds regions to the CiviCase view template.

### Joomla Integration

- **Create a Joomla 5 build
  ([30367](https://github.com/civicrm/civicrm-core/pull/30367))**

  Adds a joomla 5 dismaker dist.

### Standalone Integration

- **Standalone multifactor authentication
  ([31130](https://github.com/civicrm/civicrm-core/pull/31130))**

  Adds time-based one-time password implementation (TOTP) for standalone, and
  optionally require it.

- **Add renamed PHPGangsta TOTP authenticator for Standalone
  ([415](https://github.com/civicrm/civicrm-packages/pull/415))**

  Adds the package used by Drupal (7)'s tfa_basic module for TOTP. It's a
  generic library and compatible with popular apps like many open source OTP
  systems + Google Authenticator.

- **standalone: remove unecessary config page; use settings schema better for
  MFA ([31154](https://github.com/civicrm/civicrm-core/pull/31154))**

  Improves settings page for MultiFactor autorization options.

- **Standalone: Getting public extensions directory is not available -
  intermittently
  ([dev/core#5455](https://lab.civicrm.org/dev/core/-/issues/5455):
  [31112](https://github.com/civicrm/civicrm-core/pull/31112))**

- **SearchKit role-permissions screen unusably slow
  ([dev/core#4840](https://lab.civicrm.org/dev/core/-/issues/4840):
  [31162](https://github.com/civicrm/civicrm-core/pull/31162))**

  Improves performance of the searchkit role permissions screen on standalone.

- **Standalone - allow creating a homepage at `/civicrm/home`
  ([31093](https://github.com/civicrm/civicrm-core/pull/31093))**

  Enables creating a Standalone homepage at /civicrm/home.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Notify updates to unapproved extensions
  ([dev/core#3035](https://lab.civicrm.org/dev/core/-/issues/3035):
  [31061](https://github.com/civicrm/civicrm-core/pull/31061))**

  Ensures the System Status page shows available updates for all extensions that
  are listed on civicrm.org.

- **By default, installer should synchronize users<=>contacts
  ([dev/core#5434](https://lab.civicrm.org/dev/core/-/issues/5434):
  [31046](https://github.com/civicrm/civicrm-core/pull/31046))**

- **Admin UI extension: Can't view job log
  ([dev/core#5460](https://lab.civicrm.org/dev/core/-/issues/5460):
  [31119](https://github.com/civicrm/civicrm-core/pull/31119))**

- **SearchKit: Include displays when cloning searches
  ([dev/core#3880](https://lab.civicrm.org/dev/core/-/issues/3880):
  [31200](https://github.com/civicrm/civicrm-core/pull/31200))**

  Improves SearchKit by adding the ability to clone displays.

- **Search kit: for an event/ event location, the labels for the fields street
  and the city are not present anymore in a search but they have been probably
  moved to Location address
  ([dev/core#5467](https://lab.civicrm.org/dev/core/-/issues/5467):
  [31210](https://github.com/civicrm/civicrm-core/pull/31210))**

- **Searchkit/ totals: totals (count, ...) do not work when the field is set to
  "label" (it has to be "Raw value")
  ([dev/core#5476](https://lab.civicrm.org/dev/core/-/issues/5476):
  [31207](https://github.com/civicrm/civicrm-core/pull/31207))**

- **SearchKit - JS cleanup, use const for constants
  ([31168](https://github.com/civicrm/civicrm-core/pull/31168))**

- **SearchKit - Format footer tally values according to data type
  ([30780](https://github.com/civicrm/civicrm-core/pull/30780))**

- **SearchKit - Hide tally loading placholders when search hasn't run yet
  ([31108](https://github.com/civicrm/civicrm-core/pull/31108))**

- **SearchKit - Show 'label' for autocomplete displays
  ([31058](https://github.com/civicrm/civicrm-core/pull/31058))**

- **ChartKit - fix legend item vertical alignment on Chrome
  ([31126](https://github.com/civicrm/civicrm-core/pull/31126))**

- **FormBuilder duplicates options after deleting an option for a checkbox field
  ([dev/core#5513](https://lab.civicrm.org/dev/core/-/issues/5513):
  [31267](https://github.com/civicrm/civicrm-core/pull/31267))**

- **Afform - Restore token listing
  ([31224](https://github.com/civicrm/civicrm-core/pull/31224))**

- **Print screens result in AJAX security error
  ([dev/core#5543](https://lab.civicrm.org/dev/core/-/issues/5543):
  [31346](https://github.com/civicrm/civicrm-core/pull/31346))**

- **Remove the top-page on search results, tweak qill display
  ([31187](https://github.com/civicrm/civicrm-core/pull/31187))**

- **Api4 - Prefer @primaryKey annotation in BasicEntity
  ([31159](https://github.com/civicrm/civicrm-core/pull/31159))**

- **RolePermission - Ensure implied permissions cascade > 1 depth
  ([31191](https://github.com/civicrm/civicrm-core/pull/31191))**

- **Update warning shown when installing unreviewed extensions
  ([31144](https://github.com/civicrm/civicrm-core/pull/31144))**

- **Localization form - use arrayified var for currencyLimit
  ([31217](https://github.com/civicrm/civicrm-core/pull/31217))**

- **Pseudoconstant - Improve currency dropdowns & use non-deprecated functions
  ([31076](https://github.com/civicrm/civicrm-core/pull/31076))**

- **Use SettingsManager for boot time settings to enable reading from
  environment variables
  ([30533](https://github.com/civicrm/civicrm-core/pull/30533))**

- **Visual bundle consolidation / cleanup
  ([30796](https://github.com/civicrm/civicrm-core/pull/30796))**

- **respect Custom Group collapse on Activity and Case search forms
  ([31129](https://github.com/civicrm/civicrm-core/pull/31129))**

- **Scales login box padding down at smaller screen widths
  ([31115](https://github.com/civicrm/civicrm-core/pull/31115))**

- **extdir: remove cms=uf parameter to reduce the number of cache entries
  ([31113](https://github.com/civicrm/civicrm-core/pull/31113))**

- **WebsiteType - Delete branded website-type options that are not in use
  ([31135](https://github.com/civicrm/civicrm-core/pull/31135))**

- **Remove brand names from website types
  ([31094](https://github.com/civicrm/civicrm-core/pull/31094) and
  [31142](https://github.com/civicrm/civicrm-core/pull/31142))**

- **Stop including vine as a website type on new installs
  ([31092](https://github.com/civicrm/civicrm-core/pull/31092))**

- **API4: Abstract resolveContactID and ensure that formatCustomField receives a
  valid contact ID
  ([31048](https://github.com/civicrm/civicrm-core/pull/31048))**

- **Schema - Add 'default_fallback' for fields
  ([31096](https://github.com/civicrm/civicrm-core/pull/31096))**

- **Schema - Make 'multiple' input_attr a true boolean
  ([31132](https://github.com/civicrm/civicrm-core/pull/31132))**

- **Display Preferences screen - use settings metadata as much as possible
  ([31106](https://github.com/civicrm/civicrm-core/pull/31106))**

- **Add missing help text for mailer settings screen
  ([31120](https://github.com/civicrm/civicrm-core/pull/31120))**

- **AllCoreTables - allow multiple entities per table when filtering out
  tableless entities.
  ([31099](https://github.com/civicrm/civicrm-core/pull/31099))**

- **Avoid JS error when user does not have permission to save the template
  ([31136](https://github.com/civicrm/civicrm-core/pull/31136))**

- **Fix implicit TIMESTAMP default generating invalid DDL
  ([31006](https://github.com/civicrm/civicrm-core/pull/31006))**

- **SqlGenerator - Always specify NULL or NOT NULL in DDL
  ([31206](https://github.com/civicrm/civicrm-core/pull/31206))**

- **EntityMetadata - Implement getOptions method
  ([30986](https://github.com/civicrm/civicrm-core/pull/30986))**

- **ext/*/info.xml - Use a short expressions instead of constantly revising
  files ([31183](https://github.com/civicrm/civicrm-core/pull/31183))**

- **don't do install requirements check on every status check
  ([100](https://github.com/civicrm/civicrm-drupal-8/pull/100))**

- **properly merge NULL into custom money field
  ([31124](https://github.com/civicrm/civicrm-core/pull/31124))**

- **composer.lock hash out of date
  ([31143](https://github.com/civicrm/civicrm-core/pull/31143))**

- **SettingsField.tpl - move help swatch next to label
  ([31107](https://github.com/civicrm/civicrm-core/pull/31107))**

- **Aren't links supposed to be in quotes?
  ([31091](https://github.com/civicrm/civicrm-core/pull/31091))**

- **Fix formatting of empty array for custom fields with html_type `CheckBox`
  ([30833](https://github.com/civicrm/civicrm-core/pull/30833))**

- **fix for displaying submission data
  ([31049](https://github.com/civicrm/civicrm-core/pull/31049))**

- **Batch - Update deprecated pseudocontant getter calls
  ([31090](https://github.com/civicrm/civicrm-core/pull/31090))**

- **Batch - Fix default values of columns
  ([31177](https://github.com/civicrm/civicrm-core/pull/31177))**

- **Civi::url() - Multiple fixes and test improvements
  ([31008](https://github.com/civicrm/civicrm-core/pull/31008))**

- **fix 'invalid character in regex' error
  ([31118](https://github.com/civicrm/civicrm-core/pull/31118))**

- **sybunt report cleanup
  ([31145](https://github.com/civicrm/civicrm-core/pull/31145))**

- **AllCoreTables - Handle tableless and classless entities without crashing
  ([31079](https://github.com/civicrm/civicrm-core/pull/31079))**

- **Update pseudoconstant getters to avoid deprecated function
  ([31081](https://github.com/civicrm/civicrm-core/pull/31081))**

- **PHP8 - Fix undeclared var in batch form
  ([31173](https://github.com/civicrm/civicrm-core/pull/31173))**

- **fix using REGEXP with contact ID
  ([31040](https://github.com/civicrm/civicrm-core/pull/31040))**

- **Notice fix
  ([31194](https://github.com/civicrm/civicrm-core/pull/31194))**

- **Api4 - Fix date format metadata
  ([31338](https://github.com/civicrm/civicrm-core/pull/31338))**

- **contact quicksearch (menu bar) no longer works with multi-record custom
  fields ([dev/core#5536](https://lab.civicrm.org/dev/core/-/issues/5536):
  [31322](https://github.com/civicrm/civicrm-core/pull/31322))**

- **Upgrade 5.78-stable to 5.79-rc - No navigation UI
  ([dev/core#5563](https://lab.civicrm.org/dev/core/-/issues/5563):
  [31399](https://github.com/civicrm/civicrm-core/pull/31399))**

- **Upgrade bug: Cannot drop index 'FK_civicrm_participant_cart_id': needed in a
  foreign key constraint
  ([dev/core#5521](https://lab.civicrm.org/dev/core/-/issues/5521):
  [31282](https://github.com/civicrm/civicrm-core/pull/31282))**

- **Template compile directory missing, error running 5.78.2 updates
  ([dev/core#5534](https://lab.civicrm.org/dev/core/-/issues/5534):
  [31314](https://github.com/civicrm/civicrm-core/pull/31314))**

- **Prevent saving an empty "array" for serialised Contact Reference fields
  ([31260](https://github.com/civicrm/civicrm-core/pull/31260))**

- **UtilsArray - An empty padded string should unserialize to an empty array
  ([31261](https://github.com/civicrm/civicrm-core/pull/31261))**

- **UtilsArray - An empty string should serialize to an empty string
  ([31264](https://github.com/civicrm/civicrm-core/pull/31264))**

- **Api4 - Restore support for 'fields_callback'
  ([31292](https://github.com/civicrm/civicrm-core/pull/31292))**

- **Quicksearch icon may not be displayed
  ([dev/core#5512](https://lab.civicrm.org/dev/core/-/issues/5512):
  [31290](https://github.com/civicrm/civicrm-core/pull/31290))**

- **Contact Relationships tab does not translate
  ([dev/core#5499](https://lab.civicrm.org/dev/core/-/issues/5499):
  [31302](https://github.com/civicrm/civicrm-core/pull/31302))**

- **Form Builder: Conditional logic not working for multi-select fields
  ([dev/core#5163](https://lab.civicrm.org/dev/core/-/issues/5163):
  [31304](https://github.com/civicrm/civicrm-core/pull/31304))**

- **iconPicker - Fix initial height
  ([31199](https://github.com/civicrm/civicrm-core/pull/31199))**

- **extensionsDir setting broken
  ([dev/core#5484](https://lab.civicrm.org/dev/core/-/issues/5484):
  [31215](https://github.com/civicrm/civicrm-core/pull/31215))**

- **export batch fatal error with smarty 5
  ([dev/core#5489](https://lab.civicrm.org/dev/core/-/issues/5489):
  [31184](https://github.com/civicrm/civicrm-core/pull/31184))**

- **Inline email block on contact summary screen fails to load using smarty 2
  ([dev/core#5507](https://lab.civicrm.org/dev/core/-/issues/5507):
  [31238](https://github.com/civicrm/civicrm-core/pull/31238))**

### CiviCampaign

- **CiviCampaign - Update metadata defaults to use best-practices
  ([31203](https://github.com/civicrm/civicrm-core/pull/31203))**

### CiviCase

- **crash on file-on-case search result action if with-contact sort_name
  contains special chars
  ([dev/core#5558](https://lab.civicrm.org/dev/core/-/issues/5558) and
  [5552](https://lab.civicrm.org/dev/core/-/issues/5552):
  [31370](https://github.com/civicrm/civicrm-core/pull/31370) and
  [31369](https://github.com/civicrm/civicrm-core/pull/31369))**

- **FormBuilder: CiviCase submissions working but receiving error on front-end
  ([dev/core#5411](https://lab.civicrm.org/dev/core/-/issues/5411):
  [31117](https://github.com/civicrm/civicrm-core/pull/31117))**

### CiviContribute

- **Contribution totals broken by nofilter in Smarty 2 if statements
  ([dev/core#5506](https://lab.civicrm.org/dev/core/-/issues/5506):
  [31231](https://github.com/civicrm/civicrm-core/pull/31231))**

- **Admin-only price fields displayed to all users
  ([dev/core#5440](https://lab.civicrm.org/dev/core/-/issues/5440):
  [31278](https://github.com/civicrm/civicrm-core/pull/31278))**

- **Invoice message template additional text is squished
  ([31088](https://github.com/civicrm/civicrm-core/pull/31088))**

- **FinancialType table is missing a translatable Label field
  ([dev/core#5419](https://lab.civicrm.org/dev/core/-/issues/5419):
  [31116](https://github.com/civicrm/civicrm-core/pull/31116) and
  [31182](https://github.com/civicrm/civicrm-core/pull/31182))**

- **Financial Type label should be required in form
  ([31235](https://github.com/civicrm/civicrm-core/pull/31235))**

- **Don't clobber financial label changes if upgrade is rerun
  ([31166](https://github.com/civicrm/civicrm-core/pull/31166))**

- **[ext/financialacls] Add constraint for `contribution_id` in SQL clause for
  unavailable financial types
  ([30877](https://github.com/civicrm/civicrm-core/pull/30877))**

- **Recurring contributions: ThankYou page does not translate the membership
  contribution unit
  ([dev/translation#90](https://lab.civicrm.org/dev/translation/-/issues/90):
  [31299](https://github.com/civicrm/civicrm-core/pull/31299) and
  [31310](https://github.com/civicrm/civicrm-core/pull/31310))**

- **Fix Product image upload
  ([31255](https://github.com/civicrm/civicrm-core/pull/31255))**

### CiviEvent

- **Event Settings: rename labels for public listing, calendar links
  ([31141](https://github.com/civicrm/civicrm-core/pull/31141))**

- **Move template selection field when adding a new event to the top
  ([31174](https://github.com/civicrm/civicrm-core/pull/31174))**

- **Event Register: tweak statusBounce on some error messages
  ([31140](https://github.com/civicrm/civicrm-core/pull/31140))**

- **Event Info Block outputs contact details section even when empty
  ([dev/core#5468](https://lab.civicrm.org/dev/core/-/issues/5468):
  [31122](https://github.com/civicrm/civicrm-core/pull/31122))**

- **Event cart type error
  ([dev/core#5535](https://lab.civicrm.org/dev/core/-/issues/5535):
  [31319](https://github.com/civicrm/civicrm-core/pull/31319))**

### CiviGrant

- **CiviGrant - Translate untranslated strings in mgd.php files
  ([31070](https://github.com/civicrm/civicrm-core/pull/31070))**

### CiviMail

- **Remove alert boo from editing of bulk mailings field on email addresses  
  ([31378](https://github.com/civicrm/civicrm-core/pull/31378))**

- **Mailing Report: call mailingSize only if the queue is empty
  ([31188](https://github.com/civicrm/civicrm-core/pull/31188))**

### CiviMember

- **Adding a membership to a contact fails when CiviContribute is not activated
  ([dev/core#5504](https://lab.civicrm.org/dev/core/-/issues/5504):
  [31296](https://github.com/civicrm/civicrm-core/pull/31296) and
  [31300](https://github.com/civicrm/civicrm-core/pull/31300))**

### Drupal Integration

- **Use a static var for initialized guard for Drupal\civicrm\Civicrm  
  ([101](https://github.com/civicrm/civicrm-drupal-8/pull/101))**

- **D7 Views - Update some deprecated pseudoconstant function calls
  ([688](https://github.com/civicrm/civicrm-drupal/pull/688))**

### Standalone Integration

- **standalone: Fix Drupal7 password algorithm
  ([31075](https://github.com/civicrm/civicrm-core/pull/31075))**

- **standalone: minor fixes
  ([31078](https://github.com/civicrm/civicrm-core/pull/31078))**

- **standalone: Add status messages to public output tpl
  ([31152](https://github.com/civicrm/civicrm-core/pull/31152))**

- **Standalone login screen: tidies padding, input height, label margin, fixes
  duplicate semi-colon
  ([31102](https://github.com/civicrm/civicrm-core/pull/31102))**

## <a name="misc"></a>Miscellany

- **Update tcpdf to 6.7.7
  ([31376](https://github.com/civicrm/civicrm-core/pull/31376))**

- **Update phpoffice
  ([31243](https://github.com/civicrm/civicrm-core/pull/31243))**

- **Update ContributionPage schema/bao to use best-practices
  ([31205](https://github.com/civicrm/civicrm-core/pull/31205))**

- **Update hook_civicrm_entityTypes docblock to match updated dev docs
  ([31071](https://github.com/civicrm/civicrm-core/pull/31071))**

- **Move 'Manage Custom Searches' menu item to extension
  ([31067](https://github.com/civicrm/civicrm-core/pull/31067))**

- **Annotate CRM_Core_PseudoConstant::get as @deprecated
  ([31080](https://github.com/civicrm/civicrm-core/pull/31080))**

- **Schema - IDE-friendly formatting of callbacks
  ([31178](https://github.com/civicrm/civicrm-core/pull/31178))**

- **ManagedEntities - Remove unused function
  ([31121](https://github.com/civicrm/civicrm-core/pull/31121))**

- **Remove last core usage of hook_tokens
  ([31218](https://github.com/civicrm/civicrm-core/pull/31218))**

- **Remove some legacy copy & paste from mailing labels
  ([31156](https://github.com/civicrm/civicrm-core/pull/31156))**

- **Remove extraneous angular module dependency from chart_kit
  ([31123](https://github.com/civicrm/civicrm-core/pull/31123))**

- **Remove a couple of CRM_Core_DAO::$_nullObject
  ([31084](https://github.com/civicrm/civicrm-core/pull/31084))**

- **Activity - Remove unused variables
  ([31077](https://github.com/civicrm/civicrm-core/pull/31077))**

- **Delete a dinosaur
  ([31066](https://github.com/civicrm/civicrm-core/pull/31066))**

- **Remove code noisly deprecated March 2023
  ([31222](https://github.com/civicrm/civicrm-core/pull/31222))**

- **[REF] Fix fatal error about converting object of class CRM_Core_Config to
  string in template
  ([31219](https://github.com/civicrm/civicrm-core/pull/31219))**

- **REF: Simplify processMembership function on membership renewal form
  ([30774](https://github.com/civicrm/civicrm-core/pull/30774))**

- **[REF] use null-coalescing assignment for CRM_Extension_System parameter
  defaults ([31214](https://github.com/civicrm/civicrm-core/pull/31214))**

- **[REF] Replace create with writeRecord in Group
  ([31095](https://github.com/civicrm/civicrm-core/pull/31095))**

- **[REF] Accessiblity fix - empty form label on new individual form
  ([30675](https://github.com/civicrm/civicrm-core/pull/30675))**

- **(REF) CRM_Core_Invoke - Cleanup old experiment circa Symfony 2
  ([31060](https://github.com/civicrm/civicrm-core/pull/31060))**

- **[REF] Fix variable typo causing excessive updates of civicrm_mailing table
  when mailing jobs are running
  ([31401](https://github.com/civicrm/civicrm-core/pull/31401))**

- **[NFC] fix intermittent fail about phone export
  ([31354](https://github.com/civicrm/civicrm-core/pull/31354))**

- **[NFC] first pass release notes 5.79
   ([31381](https://github.com/civicrm/civicrm-core/pull/31381))**

- **[NFC] Api4 - Settings test code cleanup
  ([31201](https://github.com/civicrm/civicrm-core/pull/31201))**

- **[NFC] Fix some references to old exception aliases in code comments
  ([31137](https://github.com/civicrm/civicrm-core/pull/31137))**

- **SearchKit - Test fix
  ([31212](https://github.com/civicrm/civicrm-core/pull/31212))**

- **Add Unit test to demonstrate & remove code cruft
  ([31193](https://github.com/civicrm/civicrm-core/pull/31193))**

- **Add unit test for getDuplicates behaviour on Register task
  ([31148](https://github.com/civicrm/civicrm-core/pull/31148))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin; Agileware - Iris; Artful Robot - Rich Lott;
Asylum Seekers Centre; Benjamin W; BrightMinded Ltd - Bradley Taylor; CiviCRM -
Coleman Watts, Josh Gowans, Tim Otten; Coop SymbioTIC - Mathieu Lutfy, Shane
Bill; Dave D; Greenpeace Central and Eastern Europe - Patrick Figel; Jens
Schuppe; JMA Consulting - Monish Deb, Seamus Lee; Megaphone Technology
Consulting - Jon Goldberg; MJW Consulting - Matthew Wire; Nicol Wistreich;
Progressive Technology Project - Jamie McClelland; Third Sector Design - Kurund
Jalmi, William Mortada; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Chris Garaffa; Agileware - Justin Freeman; Andy Burns;
CiviDesk - Yashodha Chaku; Fuzion - Luke Stewart, Peter Davis; gibsonoliver;
Greenleaf Advancement - Guy Iaccarino; Guydn; Joinery - Allen Shaw; Lemniscus -
Noah Miller; Squiffle Consulting - Aidan Saunders; Systopia - Johannes Franz;
Tadpole Collective - Kevin Cristiano; Third Sector Design - Michael McAndrew;

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
