# CiviCRM 6.1.0

Released April 3, 2025

- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Possibility to add SearchKit to Case Summary Screen
  ([dev/core#5729](https://lab.civicrm.org/dev/core/-/issues/5729):
  [32074](https://github.com/civicrm/civicrm-core/pull/32074))**

  Moves two screens to use Form Builder specifically: a tab on the Manage Event
  screen and a block on the Case Summary.

- **Add icons to CiviCRM menu
  ([32165](https://github.com/civicrm/civicrm-core/pull/32165))**

  Adds some icons to the CiviCRM-logo menu.

- **Remove "Cleanup Caches and Update Paths" page, leave a Clear Caches button
  and deprecate update/reset paths
  ([31981](https://github.com/civicrm/civicrm-core/pull/31981))**

  Removes the "Cleanup Caches and Update Paths" page and replaces it with a menu
  button to clear caches.

- **SK: Use the custom column names from the DB Entity Display UI for creating
  the actual column names
  ([dev/core#5614](https://lab.civicrm.org/dev/core/-/issues/5614):
  [31919](https://github.com/civicrm/civicrm-core/pull/31919))**

  When creating a saved-search, one may define a "DB Entity" (eg SQL TABLE or
  VIEW derived from the query). This update allows the administrator to define
  the SQL column names.

- **search_kit -  render classes settings key for non-table search displays
  ([32262](https://github.com/civicrm/civicrm-core/pull/32262))**

  Makes it easier to target styles in a search kit packaged using *.mgd.php.

- **SearchKit - Get inline-edit working for contact primary phone/email/address
  ([32070](https://github.com/civicrm/civicrm-core/pull/32070))**

  Makes it so one can inline edit primary phone, email and address in SearcKit
  displays.

- **Core/File - Decouple file download links from the entityFile table
  ([32290](https://github.com/civicrm/civicrm-core/pull/32290) and
  [32303](https://github.com/civicrm/civicrm-core/pull/32303))**

  Simplifies the creation of links to file downloads, and modernizes the file
  hash generator.

- **Provide File system as alternative cache storage for
  CRM_Utils_Cache_Interface
  ([dev/core#5734](https://lab.civicrm.org/dev/core/-/issues/5734):
  [32069](https://github.com/civicrm/civicrm-core/pull/32069) and
  [32140](https://github.com/civicrm/civicrm-core/pull/32140))**

  Makes File system available an alternative cache storage option.

- **Make import template fields editable
  (Work Towards [dev/core#5634](https://lab.civicrm.org/dev/core/-/issues/5634):
  [31580](https://github.com/civicrm/civicrm-core/pull/31580))**

  Adds a new table `ImportTemplateField` to the schema for use by CiviImport.

- **RiverLea: fixes illegible Bootstrap bg region in dark-mode (GL:#112)
  ([32126](https://github.com/civicrm/civicrm-core/pull/32126))**

  User experience improvement in dark mode.

- **Proposal: Phase out public profile fields and profile listings
  (Work towards [dev/core#4808](https://lab.civicrm.org/dev/core/-/issues/4808):
  [32148](https://github.com/civicrm/civicrm-core/pull/32148))**

  Removes the "Return to listing" link shown when one submits a profile form.

- **Api4 - Use global cache for entityFields
  ([32210](https://github.com/civicrm/civicrm-core/pull/32210))**

  Api4 performance improvement: fewer calls to getFields, more caching.

- **Optimize dedupe query in finder flow - speed improvement
  ([32304](https://github.com/civicrm/civicrm-core/pull/32304))**

  Improves performance when deduping.

- **Improve performance of financial ACL where clause
  ([31976](https://github.com/civicrm/civicrm-core/pull/31976))**

  Improves performance for financial ACLs.

- **Possible performance improvement: When a custom field is disabled,
  automatically uncheck the searchable box and remove the db index
  ([dev/core#4923](https://lab.civicrm.org/dev/core/-/issues/4923):
  [32027](https://github.com/civicrm/civicrm-core/pull/32027))**

  Performance improvement when a custom field is disabled.

### CiviContribute

- **Tokens: Exclude/add additional recurring tokens for scheduled reminders
  ([dev/core#5578](https://lab.civicrm.org/dev/core/-/issues/5578):
  [31579](https://github.com/civicrm/civicrm-core/pull/31579))**

  Adds new tokens related to recurring contributions for scheduled reminders
  specifically: "Next Scheduled Contribution Date", "Failure Count (to check
  and display something if it's true)" and "Failure Retry Date"

- **Contribution Page Widget restructure and cleanup
  ([32120](https://github.com/civicrm/civicrm-core/pull/32120))**

  Improves user experience of the Contribution page widget settings tab.

- **"Maintenance mode"
  ([dev/core#5387](https://lab.civicrm.org/dev/core/-/issues/5387):
  [31893](https://github.com/civicrm/civicrm-core/pull/31893))**

  Adds Maintenance Mode checks to scheduled jobs and REST api.

### Drupal Integration

- **Generate URLs faster - another attempt
  ([98](https://github.com/civicrm/civicrm-drupal-8/pull/98))**

  Performance improvement for drupal 8 when generating urls.

### Standalone Integration

- **Add svg logo asset - use for Standalone login
  ([32153](https://github.com/civicrm/civicrm-core/pull/32153))**

  Adds a svg logo and uses it on the standalone login screen.

- **Standalone password reset email template
  ([31850](https://github.com/civicrm/civicrm-core/pull/31850))**

  Sets up password reset email template for standalone sites.

- **Standaloneusers - move password reset email to managed record
  ([32110](https://github.com/civicrm/civicrm-core/pull/32110))**

  Moves password reset email to a managed record instead of a bespoke approach.

- **Standalone: more user friendly error when credentials are invalid
  ([31965](https://github.com/civicrm/civicrm-core/pull/31965))**

  Improves user experience when when a user enters invalid login credentials.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Extensions - Built-in upgrader is prone to coherency bugs
  ([dev/core#5700](https://lab.civicrm.org/dev/core/-/issues/5700):
  [32285](https://github.com/civicrm/civicrm-core/pull/32285))**

- **Fix form validation error for street address
  ([32416](https://github.com/civicrm/civicrm-core/pull/32416))**

- **Upgrade to 6.0 fails during "Migrate from_email_address option group to
  SiteEmailAddress entity"
  ([dev/core#5805](https://lab.civicrm.org/dev/core/-/issues/5805):
  [32431](https://github.com/civicrm/civicrm-core/pull/32431))**

- **Custom Fields data not saved when using the "Submit Credit Card Membership"
  form ([dev/core#5708](https://lab.civicrm.org/dev/core/-/issues/5708):
  [32437](https://github.com/civicrm/civicrm-core/pull/32437))**

- **Searchkit: filter to Current User is reset
  ([dev/core#5766](https://lab.civicrm.org/dev/core/-/issues/5766):
  [32450](https://github.com/civicrm/civicrm-core/pull/32450))**

- **"Expected to find one Address record, but there were zero." error when a
  user with limited permissions views a related contact
  ([dev/core#5718](https://lab.civicrm.org/dev/core/-/issues/5718):
  [32453](https://github.com/civicrm/civicrm-core/pull/32453))**

- **Click on "Payment Processors" in "Configuration Checklist" causes fatal
  error ([dev/core#5715](https://lab.civicrm.org/dev/core/-/issues/5715):
  [32445](https://github.com/civicrm/civicrm-core/pull/32445))**

- **"Invalid session" message no longer appears, results in fatal error
  ([dev/core#5808](https://lab.civicrm.org/dev/core/-/issues/5808):
  [32449](https://github.com/civicrm/civicrm-core/pull/32449))**

- **TypeError: Unsupported operand types: string - int
  ([dev/core#5767](https://lab.civicrm.org/dev/core/-/issues/5767):
  [32462](https://github.com/civicrm/civicrm-core/pull/32462))**

- **Performance regression: FormBuilder custom field blocks increase page load
  time 4-5x ([dev/core#5804](https://lab.civicrm.org/dev/core/-/issues/5804):
  [32427](https://github.com/civicrm/civicrm-core/pull/32427))**

- **filter empty contact IDs from legacydedupefinder SQL
  ([32486](https://github.com/civicrm/civicrm-core/pull/32486))**

- **"Options per line" not respected (again)
  ([dev/core#5716](https://lab.civicrm.org/dev/core/-/issues/5716):
  [32380](https://github.com/civicrm/civicrm-core/pull/32380))**

- **Manage ACLs Page: ACLs of mode "Deny" show as "Allow"
  ([dev/core#5722](https://lab.civicrm.org/dev/core/-/issues/5722):
  [31984](https://github.com/civicrm/civicrm-core/pull/31984))**

- **Relationship tab shows relationships when relationship type is disabled
  ([dev/core#5735](https://lab.civicrm.org/dev/core/-/issues/5735):
  [32166](https://github.com/civicrm/civicrm-core/pull/32166))**

- **Searchkit: when there are 2 buttons set, it is not possible de change the
  order of the buttons in a buttons set
  ([dev/core#5754](https://lab.civicrm.org/dev/core/-/issues/5754):
  [32203](https://github.com/civicrm/civicrm-core/pull/32203))**

- **Incorrect participant records are cancelled by 'Contribution cancel actions'
  core extension
  ([dev/core#5764](https://lab.civicrm.org/dev/core/-/issues/5764):
  [32258](https://github.com/civicrm/civicrm-core/pull/32258))**

- **Crash when doing certain things if you had civigrant enabled but no longer
  do ([dev/core#5779](https://lab.civicrm.org/dev/core/-/issues/5779):
  [32323](https://github.com/civicrm/civicrm-core/pull/32323))**

- **AdminUI - Fix hiding disabled fields in custom field tabs
  ([32469](https://github.com/civicrm/civicrm-core/pull/32469))**

- **afform - block user input during prefilling
  ([32090](https://github.com/civicrm/civicrm-core/pull/32090))**

- **Form Builder - Support uploading files with "secret link" (JWT)
  ([31993](https://github.com/civicrm/civicrm-core/pull/31993))**

  Fixes a 403 error on `Afform.submitFiles`.

- **Remove the Financial Type from contribution and event receipts, update
  Billing Address label
  ([32211](https://github.com/civicrm/civicrm-core/pull/32211) and
  [32247](https://github.com/civicrm/civicrm-core/pull/32247))**

  Improves the contribution and event receipts by removing the financial type
  and renaming the label "Billing Name and Address" to just "Billing Address".

- **riverlea - fix checkbox-list in hackneybrook dark mode
   ([32389](https://github.com/civicrm/civicrm-core/pull/32389))**

- **RiverLea Thames Dark Mode / Extensions colour fix
  ([32393](https://github.com/civicrm/civicrm-core/pull/32393))**

- **CRM_Utils_String - Fix convertStringToSnakeCase to prevent double
  underscores
  ([32075](https://github.com/civicrm/civicrm-core/pull/32075))**

- **Upgrade 5.45 to 6.0 fails during `financialacls_civicrm_permission()`
  ([dev/core#5794](https://lab.civicrm.org/dev/core/-/issues/5794):
  [32377](https://github.com/civicrm/civicrm-core/pull/32377))**

- **Fix dedupe query wrangling to combine queries where 2 fields in the same
  table are always used together
  ([30591](https://github.com/civicrm/civicrm-core/pull/30591))**

- **FormBuilder - DisplayOnly fields cannot be required
  ([32034](https://github.com/civicrm/civicrm-core/pull/32034))**

- **Deprecate legacy parameters to Address::format()
  ([31982](https://github.com/civicrm/civicrm-core/pull/31982))**

- **CustomGroup - When deleting an entity, remove references from
  customGroupExtends
  ([32186](https://github.com/civicrm/civicrm-core/pull/32186))**

- **File - Fix links that do not include entityId
  ([32326](https://github.com/civicrm/civicrm-core/pull/32326))**

- **Stop wrangling sub_type in contact import
  ([32294](https://github.com/civicrm/civicrm-core/pull/32294))**

- **Fix error message for invalid step
  ([32295](https://github.com/civicrm/civicrm-core/pull/32295))**

- **Fix undefined array key error in Smarty
  ([32308](https://github.com/civicrm/civicrm-core/pull/32308))**

- **Api4 - Fix typo in code
  ([32042](https://github.com/civicrm/civicrm-core/pull/32042))**

- **Fix notice by switching to apiv4
  ([32039](https://github.com/civicrm/civicrm-core/pull/32039))**

- **Fix intermittent ExpiredToken error when Iframe patches applied
  ([341](https://github.com/civicrm/civicrm-wordpress/pull/341))**

- **Use local variable instead of protected property
  ([32000](https://github.com/civicrm/civicrm-core/pull/32000))**

- **Shimmy - Fix deprecated php implicit null
  ([32114](https://github.com/civicrm/civicrm-core/pull/32114))**

- **Php 8.x deprecation fixes
  ([32112](https://github.com/civicrm/civicrm-core/pull/32112))**

### CiviCase

- **CiviCase - Fix links and breadcrumbs when viewing case without cid in url
  ([32058](https://github.com/civicrm/civicrm-core/pull/32058))**

### CiviContribute

- **Check contribution tab exists before marking it as valid
  ([32425](https://github.com/civicrm/civicrm-core/pull/32425))**

- **When financial account is the same before and after, treat payment method
  changes the same as for financial type changes
  ([dev/financial#230](https://lab.civicrm.org/dev/financial/-/issues/230):
  [32062](https://github.com/civicrm/civicrm-core/pull/32062))**

- **Financial Entity Account selection dropdowns offer disabled accounts
  ([dev/financial#231](https://lab.civicrm.org/dev/financial/-/issues/231):
  [32085](https://github.com/civicrm/civicrm-core/pull/32085) and
  [32084](https://github.com/civicrm/civicrm-core/pull/32084))**

- **Api4 - Fix sql renderer for contribution calculated fields
  ([32184](https://github.com/civicrm/civicrm-core/pull/32184))**

- **Fix notices when rendering advanced search as contributions
  ([32072](https://github.com/civicrm/civicrm-core/pull/32072))**

- **Fix failure to permit actions on deleted contributions (move) - use apiv4
  ([32135](https://github.com/civicrm/civicrm-core/pull/32135))**

- **Ensure modelProps has contributionID
  ([32064](https://github.com/civicrm/civicrm-core/pull/32064))**

### CiviEvent

- **Tell-a-friend tab on events not working - just displays manage events page
  ([dev/core#5780](https://lab.civicrm.org/dev/core/-/issues/5780):
  [32434](https://github.com/civicrm/civicrm-core/pull/32434))**

### CiviMail

- **Tracking URL not modified after changing case & trailing whitespace
  ([dev/core#5331](https://lab.civicrm.org/dev/core/-/issues/5331):
  [32204](https://github.com/civicrm/civicrm-core/pull/32204) and
  [30626](https://github.com/civicrm/civicrm-core/pull/30626))**

- **CiviMail: Cron job for inbound-emails fails with "API... does not exist"
  ([dev/core#5788](https://lab.civicrm.org/dev/core/-/issues/5788):
  [32337](https://github.com/civicrm/civicrm-core/pull/32337))**

- **Avoid fatal error editing CiviMail when current user missing email
  ([32037](https://github.com/civicrm/civicrm-core/pull/32037))**

### CiviMember

- **Get Membership Contribution from LineItem instead of MembershipPayment
  ([32244](https://github.com/civicrm/civicrm-core/pull/32244))**

- **Fix Membership import inline with fixes on participant, contribution
  ([32379](https://github.com/civicrm/civicrm-core/pull/32379))**

- **Fix Membership import to not require start_date if id supplied
  ([32177](https://github.com/civicrm/civicrm-core/pull/32177))**

- **Fix membership import to update without requiring membership_type_id
  ([31995](https://github.com/civicrm/civicrm-core/pull/31995))**

- **Fix recent updates to import member to align with import activity
  ([32300](https://github.com/civicrm/civicrm-core/pull/32300))**

### Backdrop Integration

- **PHAR Loading - Enable PharStreamWrapper on Backdrop CMS
  ([32310](https://github.com/civicrm/civicrm-core/pull/32310))**

  Fix a problem affecting CiviCRM-Backdrop where some extensions fail to load.
  Symptoms vary, but it generally presents as a "class not found".

### Drupal Integration

- **League/csv 9.7.4 Conflicts with Drupal/csv_serialization needing 9.16
  ([dev/core#5556](https://lab.civicrm.org/dev/core/-/issues/5556):
  [32107](https://github.com/civicrm/civicrm-core/pull/32107))**

- **Drupal8::isMaintenceMode() - Don't crash on new/clean sites
  ([32327](https://github.com/civicrm/civicrm-core/pull/32327))**

### Joomla Integration

- **Joomla: Upgrade from 5.82=>6.0 fails with incomplete file removal
  ([dev/core#5787](https://lab.civicrm.org/dev/core/-/issues/5787):
  [32335](https://github.com/civicrm/civicrm-core/pull/32335))**

### Standalone Integration

- **specify light mode for civicrm.css to fix Standalone logo in Greenwich
  ([32286](https://github.com/civicrm/civicrm-core/pull/32286))**

- **standaloneusers - remove unused password attribute from afform User entity
  ([32296](https://github.com/civicrm/civicrm-core/pull/32296))**

- **standalone error handler caused error
  ([32183](https://github.com/civicrm/civicrm-core/pull/32183))**

### WordPress Integration

- **Fix intermittent ExpiredToken error when Iframe patches applied
  ([31997](https://github.com/civicrm/civicrm-core/pull/31997))**

## <a name="misc"></a>Miscellany

- **Update oauth packages for PHP8.3/8.4 official support
  ([32199](https://github.com/civicrm/civicrm-core/pull/32199))**

- **Update tplanner/when for type hints
  ([32076](https://github.com/civicrm/civicrm-core/pull/32076))**

- **Upgrading typo3/phar-stream-wrapper (v3.1.8 => v4.0.0)
  ([32132](https://github.com/civicrm/civicrm-core/pull/32132))**

- **Add polyfill for php 8.3 & 8.4
  ([32128](https://github.com/civicrm/civicrm-core/pull/32128))**

- **Update firebase/php-jwt v6.4.0 to v6.11.0
  ([32113](https://github.com/civicrm/civicrm-core/pull/32113))**

- **php8.4 support fgetcsv
  ([32133](https://github.com/civicrm/civicrm-core/pull/32133))**

- **Convert custom data import to apiv4
  ([32250](https://github.com/civicrm/civicrm-core/pull/32250))**

- **Update Membership import to use apiv4
  ([32202](https://github.com/civicrm/civicrm-core/pull/32202))**

- **Finish upgrading participant import to apvi4
  ([32123](https://github.com/civicrm/civicrm-core/pull/32123))**

- **Add function for setting max query execution time to core
  ([32231](https://github.com/civicrm/civicrm-core/pull/32231))**

- **Separate legacy `fillTable` out from 'to-keep' finder code
  ([32117](https://github.com/civicrm/civicrm-core/pull/32117))**

- **Simplify updatedAmount calculation in LineItem changeFeeSelections()
  ([32240](https://github.com/civicrm/civicrm-core/pull/32240))**

- **Simplify params to legacyProcessMembership
  ([32224](https://github.com/civicrm/civicrm-core/pull/32224))**

- **Simplify tab count calculation
  ([32242](https://github.com/civicrm/civicrm-core/pull/32242))**

- **Civi::rebuild() - Consolidate super-functions rebuildMenuAndCaches,
  flushCache, and cleanupCaches
  ([32065](https://github.com/civicrm/civicrm-core/pull/32065))**

- **Add comment to batch
  ([32223](https://github.com/civicrm/civicrm-core/pull/32223))**

- **Clarify that entity_table is always civicrm_participant
  ([32225](https://github.com/civicrm/civicrm-core/pull/32225))**

- **Move query code to the FinderOptimizer class
  ([32283](https://github.com/civicrm/civicrm-core/pull/32283))**

- **Further clean up in dedupe query builder
  ([32284](https://github.com/civicrm/civicrm-core/pull/32284))**

- **CustomGroup - Remove unnecessary workaround for contact types
  ([32180](https://github.com/civicrm/civicrm-core/pull/32180))**

- **Remove Enum from validTypes list; call deprecatedFunctionWarning
  ([32217](https://github.com/civicrm/civicrm-core/pull/32217))**

- **Remove function noisily deprecated in 2022
  ([32237](https://github.com/civicrm/civicrm-core/pull/32237))**

- **Remove deprecated code path from 2020
  ([32124](https://github.com/civicrm/civicrm-core/pull/32124))**

- **Update comments on setting property on admin forms
  ([32299](https://github.com/civicrm/civicrm-core/pull/32299))**

- **Fix comment for getCMSPermissionsUrlParams
  ([32293](https://github.com/civicrm/civicrm-core/pull/32293))**

- **Tidy up opt out handling in contact import
  ([32277](https://github.com/civicrm/civicrm-core/pull/32277))**

- **Extract part of function that is shared between old path & new
  ([32031](https://github.com/civicrm/civicrm-core/pull/32031))**

- **Unused variable/function call
  ([32232](https://github.com/civicrm/civicrm-core/pull/32232))**

- **Remove some contact_type wrangling from previously shared code
  ([32274](https://github.com/civicrm/civicrm-core/pull/32274))**

- **Remove unused functions, old comments
  ([32273](https://github.com/civicrm/civicrm-core/pull/32273))**

- **Remove redundant custom field handling in contact import
  ([32265](https://github.com/civicrm/civicrm-core/pull/32265))**

- **Remove unused function
  ([32238](https://github.com/civicrm/civicrm-core/pull/32238))**

- **Remove function deprecated in 2023, no universe usages found
  ([32192](https://github.com/civicrm/civicrm-core/pull/32192))**

- **Remove more do-nothing code
  ([32236](https://github.com/civicrm/civicrm-core/pull/32236))**

- **Remove do-nothing legacy code
  ([32235](https://github.com/civicrm/civicrm-core/pull/32235))**

- **OptionGroup - Deprecate isDomainOptionGroup function
  ([31989](https://github.com/civicrm/civicrm-core/pull/31989))**

- **Decommission thresholdQuery, only call legacy hook from backward compat
  extension ([31996](https://github.com/civicrm/civicrm-core/pull/31996))**

- **Do legacy param setting in the legacy callers
  ([32030](https://github.com/civicrm/civicrm-core/pull/32030))**

- **Import code consolidation, membership import
  ([31943](https://github.com/civicrm/civicrm-core/pull/31943))**

- **Clean up contact matching in Membership import
  ([32028](https://github.com/civicrm/civicrm-core/pull/32028))**

- **UtilsArray - Refactor out uses of deprecated CRM_Utils_Array::value
  ([31990](https://github.com/civicrm/civicrm-core/pull/31990))**

- **[REF] CRM/Utils - Use str_contains instead of strpos
  ([32156](https://github.com/civicrm/civicrm-core/pull/32156))**

- **[REF] CRM/Export - Use str_contains instead of strpos
  ([32162](https://github.com/civicrm/civicrm-core/pull/32162))**

- **[REF] CRM/Event - Use str_contains instead of strpos
  ([32161](https://github.com/civicrm/civicrm-core/pull/32161))**

- **[REF] CRM/Profile - Use str_contains instead of strpos
  ([32163](https://github.com/civicrm/civicrm-core/pull/32163))**

- **[REF] CRM/Contribute - Use str_contains instead of strpos
  ([32159](https://github.com/civicrm/civicrm-core/pull/32159))**

- **[REF] Api3 - Use str_contains instead of strpos
  ([32151](https://github.com/civicrm/civicrm-core/pull/32151))**

- **[REF] CRM/Mailing - Use str_contains instead of strpos
  ([32160](https://github.com/civicrm/civicrm-core/pull/32160))**

- **[REF] CRM/Core - Use str_contains instead of strpos
  ([32157](https://github.com/civicrm/civicrm-core/pull/32157))**

- **[REF] CRM/Misc - Use str_contains instead of strpos
  ([32164](https://github.com/civicrm/civicrm-core/pull/32164))**

- **[REF] Ext - Use str_contains instead of strpos
  ([32158](https://github.com/civicrm/civicrm-core/pull/32158))**

- **[REF] Civi - Use str_contains instead of strpos
  ([32154](https://github.com/civicrm/civicrm-core/pull/32154))**

- **[REF] Api4 - Use str_contains instead of strpos
  ([32152](https://github.com/civicrm/civicrm-core/pull/32152))**

- **[REF] Tests - Use str_contains instead of strpos
  ([32145](https://github.com/civicrm/civicrm-core/pull/32145))**

- **[REF] Misc - Use str_starts_with instead of strpos
  ([32144](https://github.com/civicrm/civicrm-core/pull/32144))**

- **[REF] Complete separation of the legacydedupefinder from the core code to
  keep ([32119](https://github.com/civicrm/civicrm-core/pull/32119))**

- **[REF] Tests - Use str_starts_with instead of strpos
  ([32097](https://github.com/civicrm/civicrm-core/pull/32097))**

- **[REF] Afform - Use str_starts_with instead of strpos
  ([32098](https://github.com/civicrm/civicrm-core/pull/32098))**

- **[REF] Misc - Use str_starts_with instead of strpos
  ([32096](https://github.com/civicrm/civicrm-core/pull/32096))**

- **[REF] Api4 - Use str_starts_with instead of strpos
  ([32094](https://github.com/civicrm/civicrm-core/pull/32094))**

- **[REF] SearchKit - Use str_starts_with instead of strpos
  ([32099](https://github.com/civicrm/civicrm-core/pull/32099))**

- **[REF] CiviImport - Use str_starts_with instead of strpos
  ([32100](https://github.com/civicrm/civicrm-core/pull/32100))**

- **[REF] CRM/Core - Use str_starts_with instead of strpos
  ([32102](https://github.com/civicrm/civicrm-core/pull/32102))**

- **[REF] CRM/Utils - Use str_starts_with instead of strpos
  ([32103](https://github.com/civicrm/civicrm-core/pull/32103))**

- **[REF] Civi/misc - Use str_starts_with instead of strpos
  ([32095](https://github.com/civicrm/civicrm-core/pull/32095))**

- **[REF] Api3 - Use str_starts_with instead of strpos
  ([32093](https://github.com/civicrm/civicrm-core/pull/32093))**

- **[REF] CRM/Financial - Use str_starts_with instead of strpos
  ([32104](https://github.com/civicrm/civicrm-core/pull/32104))**

- **(REF) CRM_Queue_TaskHandler - Use constant+comments to highlight wiring
  ([32233](https://github.com/civicrm/civicrm-core/pull/32233))**

- **[REF] Config - Clarify that directories have trailing slashes
  ([32312](https://github.com/civicrm/civicrm-core/pull/32312))**

- **(REF) Remove dead code (re: CIVICRM_UF_HEAD)
  ([32254](https://github.com/civicrm/civicrm-core/pull/32254))**

- **[REF] Ensure that Reply-To header is appropriately quoted if copying from
  the from address as well
  ([32278](https://github.com/civicrm/civicrm-core/pull/32278))**

- **[REF] Api4 - Performance tweak: less looping in selectArray()
  ([32272](https://github.com/civicrm/civicrm-core/pull/32272))**

- **[REF] Faster pseudoconstant name lookups
  ([32261](https://github.com/civicrm/civicrm-core/pull/32261))**

- **[REF] CRM/Contact - Use str_contains instead of strpos
  ([32155](https://github.com/civicrm/civicrm-core/pull/32155))**

- **[REF] Ensure that ContactId is passed through on Mailing Event Emails to
  mailParams hook
  ([32179](https://github.com/civicrm/civicrm-core/pull/32179))**

- **[REF] Reduce API calls to get subtypes
  ([32230](https://github.com/civicrm/civicrm-core/pull/32230))**

- **(REF) Queue - Extract better helper for batch operations
  ([31908](https://github.com/civicrm/civicrm-core/pull/31908))**

- **[REF] Use random_bytes instead of uniqid/rand for random hex strings
  ([32205](https://github.com/civicrm/civicrm-core/pull/32205))**

- **[REF] CRM/Core - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32010](https://github.com/civicrm/civicrm-core/pull/32010))**

- **[REF] CRM/Custom - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32011](https://github.com/civicrm/civicrm-core/pull/32011))**

- **[REF] ext/payments - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32023](https://github.com/civicrm/civicrm-core/pull/32023))**

- **[REF] Contact - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32008](https://github.com/civicrm/civicrm-core/pull/32008))**

- **[REF] CRM/Price - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32015](https://github.com/civicrm/civicrm-core/pull/32015))**

- **[REF] Relationship - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32007](https://github.com/civicrm/civicrm-core/pull/32007))**

- **[REF] Campaign - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32006](https://github.com/civicrm/civicrm-core/pull/32006))**

- **[REF] CRM/Member - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32014](https://github.com/civicrm/civicrm-core/pull/32014))**

- **[REF] CRM/Report/Form/ - Refactor out uses of deprecated
  CRM_Utils_Array::value
  ([32018](https://github.com/civicrm/civicrm-core/pull/32018))**

- **[REF] ext/eventcart - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32024](https://github.com/civicrm/civicrm-core/pull/32024))**

- **[REF] CRM/SMS - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32020](https://github.com/civicrm/civicrm-core/pull/32020))**

- **Ref clean up contact lookup handling in Participant import
  ([30583](https://github.com/civicrm/civicrm-core/pull/30583))**

- **[REF] CRM/Utils - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32016](https://github.com/civicrm/civicrm-core/pull/32016))**

- **[REF] CRM/Report - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32017](https://github.com/civicrm/civicrm-core/pull/32017))**

- **[REF] CRM/Tag - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32019](https://github.com/civicrm/civicrm-core/pull/32019))**

- **[REF] Batch - Refactor out uses of deprecated CRM_Utils_Array::value.
  ([32005](https://github.com/civicrm/civicrm-core/pull/32005))**

- **[REF] CRM/Contribute - Refactor out uses of deprecated CRM_Utils_Array
  ([32009](https://github.com/civicrm/civicrm-core/pull/32009))**

- **[REF] ext/civigrant - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32021](https://github.com/civicrm/civicrm-core/pull/32021))**

- **[REF] CRM/Misc - Refactor out uses of deprecated CRM_Utils_Array::value.
  ([32013](https://github.com/civicrm/civicrm-core/pull/32013))**

- **[REF] ext/ckeditor4 - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32022](https://github.com/civicrm/civicrm-core/pull/32022))**

- **[REF] Badge - Refactor out uses of deprecated CRM_Utils_Array::value.
  ([32004](https://github.com/civicrm/civicrm-core/pull/32004))**

- **[REF] ext/legacycustomsearches - Refactor out uses of deprecated CRM_
  Code cleanup to stop using deprecated function.
  ([32026](https://github.com/civicrm/civicrm-core/pull/32026))**

- **[REF] ext/misc - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32025](https://github.com/civicrm/civicrm-core/pull/32025))**

- **[REF] Admin - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32003](https://github.com/civicrm/civicrm-core/pull/32003))**

- **[REF] CRM/Activity - Refactor out uses of deprecated CRM_Utils_Array::value.
  ([32002](https://github.com/civicrm/civicrm-core/pull/32002))**

- **[REF] Bin - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32001](https://github.com/civicrm/civicrm-core/pull/32001))**

- **[REF] Api3 - Refactor out uses of deprecated CRM_Utils_Array::value.
  ([31999](https://github.com/civicrm/civicrm-core/pull/31999))**

- **[REF] Use tokenProcessor to render display name
  ([31983](https://github.com/civicrm/civicrm-core/pull/31983))**

- **[REF] Member/Pledge - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32052](https://github.com/civicrm/civicrm-core/pull/32052))**

- **[REF] Remove unused variables
  ([32045](https://github.com/civicrm/civicrm-core/pull/32045))**

- **[REF] CiviContribute - Refactor out uses of deprecated
  CRM_Utils_Array::value
  ([32050](https://github.com/civicrm/civicrm-core/pull/32050))**

- **[REF] CRM/Misc - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32053](https://github.com/civicrm/civicrm-core/pull/32053))**

- **[REF] CRM/Event - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32012](https://github.com/civicrm/civicrm-core/pull/32012))**

- **[REF] api/v3 - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32046](https://github.com/civicrm/civicrm-core/pull/32046))**

- **[REF] CRM/Case - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32051](https://github.com/civicrm/civicrm-core/pull/32051))**

- **[REF] CRM/Activity - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32049](https://github.com/civicrm/civicrm-core/pull/32049))**

- **[REF] Refactor redundant `isset()`s to use null coalescing operator (??)
  ([32044](https://github.com/civicrm/civicrm-core/pull/32044))**

- **[REF] CRM/Event - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32048](https://github.com/civicrm/civicrm-core/pull/32048))**

- **[REF] CRM/Report - Refactor out uses of deprecated CRM_Utils_Array::value
  ([32047](https://github.com/civicrm/civicrm-core/pull/32047))**

- **[REF] CRM/Event - Use str_starts_with instead of strpos
  ([32105](https://github.com/civicrm/civicrm-core/pull/32105))**

- **[REF] CRM/Misc - Use str_starts_with instead of strpos
  ([32106](https://github.com/civicrm/civicrm-core/pull/32106))**

- **[REF] - Simplify redundant calls to `empty()` function
  ([32043](https://github.com/civicrm/civicrm-core/pull/32043))**

- **[REF] Ext/misc - Use str_starts_with instead of strpos
  ([32101](https://github.com/civicrm/civicrm-core/pull/32101))**

- **[NFC] 6.1 release notes first pass
  ([32447](https://github.com/civicrm/civicrm-core/pull/32447))**

- **NFC: Remove MembershipPayment from comment
  ([32241](https://github.com/civicrm/civicrm-core/pull/32241))**

- **Follow on fix with a test
  ([32309](https://github.com/civicrm/civicrm-core/pull/32309))**

- **Ensure that RuntimeException is appropriately appropriately described as in
  root namespace ([32315](https://github.com/civicrm/civicrm-core/pull/32315))**

- **Pacify SqlFunctionTest. Encode limitations of APIv4 TIMESTAMPDIFF().
  ([32340](https://github.com/civicrm/civicrm-core/pull/32340))**

- **Fix a few test clean places
  ([32298](https://github.com/civicrm/civicrm-core/pull/32298))**

- **Add test for opt out handling on import, ready for cleanup
  ([32276](https://github.com/civicrm/civicrm-core/pull/32276))**

- **UnitTests - Allow mocking date/time functions in sql
  ([32188](https://github.com/civicrm/civicrm-core/pull/32188))**

- **Fix failing ParticipantTest
  ([32216](https://github.com/civicrm/civicrm-core/pull/32216))**

- **Revert "adjust test"
  ([32198](https://github.com/civicrm/civicrm-core/pull/32198))**

- **Switch sampleContact test function to private
  ([32171](https://github.com/civicrm/civicrm-core/pull/32171))**

- **Use Mock Handler in A.net test
  ([32197](https://github.com/civicrm/civicrm-core/pull/32197))**

- **Support apiv4 in test functions individualCreate, organizationCreate,
  householdCreate
  ([32174](https://github.com/civicrm/civicrm-core/pull/32174))**

- **Fix test to reflect 6.1 changes to mapping
  ([32508(https://github.com/civicrm/civicrm-core/pull/32508))**

- **Add upgrade test
  ([32509](https://github.com/civicrm/civicrm-core/pull/32509))**

- **Minor test cleanups
  ([32301](https://github.com/civicrm/civicrm-core/pull/32301))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin; Artful Robot - Rich Lott; Benjamin W;
CiviCoop - Jaap Jansma; CiviCRM - Coleman Watts, Tim Otten; Coop SymbioTIC -
Mathieu Lutfy, Shane Bill; Dave D; Freeform Solutions - Herb van den Dool;
Fuzion - Luke Stewart; Jens Schuppe; JMA Consulting - Monish Deb, Seamus Lee;
Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
Nicol Wistreich; Sjoerd Langkemper; Squiffle Consulting - Aidan Saunders; Third
Sector Design - Kurund Jalmi, William Mortada; Wikimedia Foundation - Eileen
McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

civiservice.de - Andreas Howiller; Daniel Strum; JMA Consulting - Edsel Lopez;
Joinery - Allen Shaw; Matt5K; Mosier Consulting - Justin Mosier; Tadpole
Collective - Kevin Cristiano
