# CiviCRM 6.2.0

Released May 7, 2025;

- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add aria-label to CheckBox, Radio and EntityRef in FormBuilder
  ([dev/core#5203](https://lab.civicrm.org/dev/core/-/issues/5023):
  [32088](https://github.com/civicrm/civicrm-core/pull/32088))**

  Improves accessibility of checkboxes in FormBuilder by adding aria labels.

- **Allow using "abbr" for domain.state_province_id token
  ([32347](https://github.com/civicrm/civicrm-core/pull/32347))**

  Makes it so one can use the token {domain.state_province_id:abbr}.

- **FormBuilder - Now you can make Tab Sets 🎉
  ([31944](https://github.com/civicrm/civicrm-core/pull/31944))**

  Makes it so one can build tabsets with the FormBuilder drag-n-drop editor!

- **Api4 - Improve efficiency of FormattingUtil::formatOutputValues
  ([32436](https://github.com/civicrm/civicrm-core/pull/32436))**

  Optimization of Api4 code.

- **Add new Contact api actions to discoverable list
  ([32395](https://github.com/civicrm/civicrm-core/pull/32395))**

  Adds visibility / autocomplete for APIv4 Contact.getMergedTo/getMergedFrom
  actions.

- **Api4 - Support entities in alternate databases
  ([32474](https://github.com/civicrm/civicrm-core/pull/32474))**

  Allows Api4 entities to exist in different sql databases from CiviCRM.

- **Api4 - Add attachment functionality to the File api
  ([32311](https://github.com/civicrm/civicrm-core/pull/32311))**

  Improves the APIv4 File entity vy adding attachment functionality.

- **File - consistently set created_id
  ([32333](https://github.com/civicrm/civicrm-core/pull/32333))**

  Ensure file table keeps track of the user who uploaded the file.

- **File - deprecate 'document' field from File entity.
  ([32331](https://github.com/civicrm/civicrm-core/pull/32331))**

  The 'document' field is kind of antithetical to the File table's purpose,
  marking it deprecated as a part of updates.

- **File - set default in sql for upload_date
  ([32332](https://github.com/civicrm/civicrm-core/pull/32332))**

  Makes the file -> upload_date field required and gives it a default,
  consistent with other fields of this type.

- **SearchKit - Minor updates to display type options
  ([32532](https://github.com/civicrm/civicrm-core/pull/32532))**

  Updates description to match new functionality and removes unused params.

- **RiverLea 1.4.2 ([32370](https://github.com/civicrm/civicrm-core/pull/32370),
  [32351](https://github.com/civicrm/civicrm-core/pull/32351) and
  [32500](https://github.com/civicrm/civicrm-core/pull/32500))**

  User interface improvements for sites using RiverLea.

- **EntityBatch: clarify the entityType description
  ([32412](https://github.com/civicrm/civicrm-core/pull/32412))**

  Improves the Entity Batch -> entity type description.

- **EFv2 - Implement $entity->getReferenceCounts
  ([32568](https://github.com/civicrm/civicrm-core/pull/32568))**

  Adds more functionality to Entity Framework v2.

- **Update regions in Denmark
  ([32549](https://github.com/civicrm/civicrm-core/pull/32549) and
  [32554](https://github.com/civicrm/civicrm-core/pull/32554))**

  Updates Denmark regions.

- **Modify the ACL Contact Cache table to be domain aware
  ([32371](https://github.com/civicrm/civicrm-core/pull/32371))**

  Aids support to the Multisite Extension by making the
  civicrm_acl_contact_cache table multi domain aware.

- **Ext - Add upgrade helper functions
  ([32521](https://github.com/civicrm/civicrm-core/pull/32521) and
  [32531](https://github.com/civicrm/civicrm-core/pull/32531))**

  Adds extension upgrade helper functions for adding/modifying a table.

- **Make Civiimport required
  ([32519](https://github.com/civicrm/civicrm-core/pull/32519),
  [32430](https://github.com/civicrm/civicrm-core/pull/32430) and
  [32473](https://github.com/civicrm/civicrm-core/pull/32473))**

  Makes the civiimport extension required and uses it for the membership and
  participants imports.

- **Civi-Import UI permissions
  ([32414](https://github.com/civicrm/civicrm-core/pull/32414))**

  Ensures users have permissions to view their own imports.

- **Add 'View User Job' button to All Imports and My Imports
  ([32421](https://github.com/civicrm/civicrm-core/pull/32421))**

  Makes it easier to go back and see detailed results of and import by clicking
  the "View User job" button.

### CiviEvent

- **Event dashboard slow on large site
  ([32322](https://github.com/civicrm/civicrm-core/pull/32322))**

  Improves performance of event dashboard.

- **Add region to ManageEvent/Form/Tab so we can change/replace
  ConfirmRepeatMode template
  ([32488](https://github.com/civicrm/civicrm-core/pull/32488))**

  Adds a region to ManageEvent/Form/Tab so extension developers can use a hook
  to alter it.

### CiviMail

- **Remove the Mailing Forward feature
  ([32130](https://github.com/civicrm/civicrm-core/pull/32130))**

  Improves user experience by removing the mail forward feature.

### CiviMember

- **Remove top buttons from backend Membership Renewal form
  ([32512](https://github.com/civicrm/civicrm-core/pull/32512))**

  Improves user experience by simplifying the Membership Renewal Form.

### Standalone Integration

- **standaloneusers - use only circle icons on permissions display
  ([32448](https://github.com/civicrm/civicrm-core/pull/32448))**

  Improves user experience for standalone sites by using only circle icons on
  the permission display.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Fix rejection of activity import if id not mapped  
  ([32581](https://github.com/civicrm/civicrm-core/pull/32581))**

- **RiverLea: fixes inline checkbox regression
  ([32608](https://github.com/civicrm/civicrm-core/pull/32608))**

- **Extensions - Built-in upgrader is prone to coherency bugs
  ([dev/core#5700](https://lab.civicrm.org/dev/core/-/issues/5700):
  [32591](https://github.com/civicrm/civicrm-core/pull/32591))**

- **Unhide legacydedupefinder so that it can be disabled  
  ([32606](https://github.com/civicrm/civicrm-core/pull/32606))**

- **isTableBigger in legacydedupefinder is still broken in 6.1.1
  ([dev/core#5846](https://lab.civicrm.org/dev/core/-/issues/5846):
  [32633](https://github.com/civicrm/civicrm-core/pull/32633) and
  [32629](https://github.com/civicrm/civicrm-core/pull/32629))**

  Fixes dedupe error when no data is passed in.

- **Fix fatal error when a user with limited permissions edits their own contact
  using the contact summary interface
  ([32415](https://github.com/civicrm/civicrm-core/pull/32415))**

- **iframe - Fix PHP error about print function
  ([32649](https://github.com/civicrm/civicrm-core/pull/32649))**

- **composer-patches: Update workflow to fix intermittent failures
  ([32671](https://github.com/civicrm/civicrm-core/pull/32671))**

- **When merging two contacts, when i choose to NOT merge relationships, the
  relationships are still being merged
  ([dev/core#5822](https://lab.civicrm.org/dev/core/-/issues/5822):
  [32677](https://github.com/civicrm/civicrm-core/pull/32677))**

- **Form Builder / Afform: Date elements have the wrong default value between
  midnight and UTC offset
  ([dev/core#5295](https://lab.civicrm.org/dev/core/-/issues/5295):
  [32366](https://github.com/civicrm/civicrm-core/pull/32366))**

- **SearchKit In-Place Edit requires multiple clicks/keystrokes to initiate
  ([dev/core#5770](https://lab.civicrm.org/dev/core/-/issues/5770):
  [32291](https://github.com/civicrm/civicrm-core/pull/32291))**

- **Do Not Phone (and other checkboxes) become incorrectly set upon recording
  survey responses
  ([dev/core#5773](https://lab.civicrm.org/dev/core/-/issues/5773):
  [32334](https://github.com/civicrm/civicrm-core/pull/32334))**

- **Form Builder returns error: "Please enter no more than 0 characters." for
  First Name and Last Name fields when a value is entered and no field max
  length is set
  ([dev/core#5781](https://lab.civicrm.org/dev/core/-/issues/5781):
  [32373](https://github.com/civicrm/civicrm-core/pull/32373))**

- **searchkit display run - default col type is field
  ([32534](https://github.com/civicrm/civicrm-core/pull/32534))**

  Cleans up chartkit errors.

- **Searchkit: function IS NOT NULL is missing
  ([dev/core#5790](https://lab.civicrm.org/dev/core/-/issues/5790):
  [32355](https://github.com/civicrm/civicrm-core/pull/32355))**

- **Form Builder: repeating with join gives an error
  ([dev/core#5801](https://lab.civicrm.org/dev/core/-/issues/5801):
  [32408](https://github.com/civicrm/civicrm-core/pull/32408))**

- **Search UI: Open links in same tab
  ([32560](https://github.com/civicrm/civicrm-core/pull/32560))**

- **Use class rather than hook to override template, remove no-longer accessible
  MapField.tpls ([32537](https://github.com/civicrm/civicrm-core/pull/32537))**

- **Fix display of pay later instructions on thankyou and skipping when payment
  on confirmation page
  ([32502](https://github.com/civicrm/civicrm-core/pull/32502))**

- **InstanceList: translate the component names
  ([32505](https://github.com/civicrm/civicrm-core/pull/32505))**

  Fixes the translation of component names in "Reports > All Reports".

- **Allow `hook_civicrm_pre()` delete on a contact to delete a CMS user
  ([32361](https://github.com/civicrm/civicrm-core/pull/32361))**

- **Use merged to contact if attempt is made to import to a merged contact
  ([32396](https://github.com/civicrm/civicrm-core/pull/32396))**

- **Use get permissions for getMergedTo, getMergedFrom
  ([32397](https://github.com/civicrm/civicrm-core/pull/32397))**

- **CustomGroup - Make `name`, `extends`, and `style` required.
  ([32362](https://github.com/civicrm/civicrm-core/pull/32362))**

  Sets missing defaults and NOT NULL attributes in the civicrm_custom_group
  table.

- **Search icon wrong for certain browser/OS/configurations
  ([dev/core#5789](https://lab.civicrm.org/dev/core/-/issues/5789):
  [32368](https://github.com/civicrm/civicrm-core/pull/32368))**

- **(Performance) ManagedEntities - Only update an entity if its declaration has
  changed ([32345](https://github.com/civicrm/civicrm-core/pull/32345))**

- **EntityTag - Remove redundant deletes already handled by hook
  ([32364](https://github.com/civicrm/civicrm-core/pull/32364))**

- **Queue.run API - Log an alert for unhandled exceptions
  ([32365](https://github.com/civicrm/civicrm-core/pull/32365))**

- **Advanced Search: standardize labels (singular, no question mark)
  ([32353](https://github.com/civicrm/civicrm-core/pull/32353))**

- **Upgrader - Ensure rebuildMenuAndCaches() runs with fresh container
  ([32339](https://github.com/civicrm/civicrm-core/pull/32339))**

- **afform core: remove settings mixins since the settings were removed
  ([32504](https://github.com/civicrm/civicrm-core/pull/32504))**

- **riverlea - fix is_active to allow streams from external extensions
  ([32263](https://github.com/civicrm/civicrm-core/pull/32263))**

- **Catch throwable (e.g typehint) in queue handler
  ([32367](https://github.com/civicrm/civicrm-core/pull/32367))**

- **Display error for API4 batch action
  ([32219](https://github.com/civicrm/civicrm-core/pull/32219))**

- **Rename, fix input for now-reasonable function
  ([32494](https://github.com/civicrm/civicrm-core/pull/32494))**

- **Fix use of scope
  ([32522](https://github.com/civicrm/civicrm-core/pull/32522))**

- **Remove some of the hacks to run quickform alongside civiimport
  ([32523](https://github.com/civicrm/civicrm-core/pull/32523))**

- **Stop passing self to private non-static form function
  ([32480](https://github.com/civicrm/civicrm-core/pull/32480))**

- **SearchKit: Fix ctrl.field is undefined error
  ([32550](https://github.com/civicrm/civicrm-core/pull/32550))**

- **SearchKit - Fix php warning when an entity has no fields
  ([32547](https://github.com/civicrm/civicrm-core/pull/32547))**

- **avoid errors with canary table when using READ-COMMITTED
  ([32557](https://github.com/civicrm/civicrm-core/pull/32557))**

- **Fix orphaned form label for afform radio buttons
  ([32518](https://github.com/civicrm/civicrm-core/pull/32518))**

- **Api - Fix 'required' setting of legacyArrayToField
  ([32561](https://github.com/civicrm/civicrm-core/pull/32561))**

- **Fix incorrect hook name: `hook_civicrm_permission`
  ([32467](https://github.com/civicrm/civicrm-core/pull/32467))**

- **Fix notice in help text on settings pages
  ([32406](https://github.com/civicrm/civicrm-core/pull/32406))**

- **Fix rejection of activity import if id not mapped
  ([32581](https://github.com/civicrm/civicrm-core/pull/32581))**

- **Notice fix
  ([32471](https://github.com/civicrm/civicrm-core/pull/32471))**

- **Notice fix, use local variable
  ([32452](https://github.com/civicrm/civicrm-core/pull/32452))**

- **Smarty notice fix on tell-a-friend
  ([31808](https://github.com/civicrm/civicrm-core/pull/31808))**

###  CiviContribute

- **Get ContributionID from LineItem instead of MembershipPayment in more places
  ([32424](https://github.com/civicrm/civicrm-core/pull/32424))**

- **Look up existing line items, not participant payments, to find participant
  line items ([32477](https://github.com/civicrm/civicrm-core/pull/32477))**

- **Fix participant fee_amount alter on edit
  ([32484](https://github.com/civicrm/civicrm-core/pull/32484))**

- **don't allow payment on a canceled invoice
  ([32357](https://github.com/civicrm/civicrm-core/pull/32357))**

- **Freeze price_set_id when freezing total_amount
  ([32513](https://github.com/civicrm/civicrm-core/pull/32513))**

- **Fix Financial Type wrench on select
  ([32343](https://github.com/civicrm/civicrm-core/pull/32343))**

- **Fix undefined _paymentFields PHP warning
  ([32501](https://github.com/civicrm/civicrm-core/pull/32501))**

- **Attempt to lift hex
  ([32485](https://github.com/civicrm/civicrm-core/pull/32485))**

- **Make sure legacy tax token values are in the deprecation list
  ([32483](https://github.com/civicrm/civicrm-core/pull/32483))**

- **PCP Info page doesn't load
  ([dev/core#5859](https://lab.civicrm.org/dev/core/-/issues/5859):
  [32659](https://github.com/civicrm/civicrm-core/pull/32659))**

### CiviEvent

- **Always assign 'findParticipants' to template
  ([32487](https://github.com/civicrm/civicrm-core/pull/32487))**

- **Missing Translation for Self Service Event Cancelation
  ([dev/core#5418](https://lab.civicrm.org/dev/core/-/issues/5418):
  [32341](https://github.com/civicrm/civicrm-core/pull/32341))**

- **Remove invalid table markup on event tab
  ([32386](https://github.com/civicrm/civicrm-core/pull/32386))**

- **actually suppress event templates in event autocomplete
  ([32400](https://github.com/civicrm/civicrm-core/pull/32400))**

- **Events: further simplify messaging when registration requires approval
  ([32369](https://github.com/civicrm/civicrm-core/pull/32369))**

### CiviMember

- **Membership Renewal Form: Don't pass IDs
  ([32422](https://github.com/civicrm/civicrm-core/pull/32422))**

### Drupal Integration

- **(Un)Installer - Fix testing issue on D7
  ([32661](https://github.com/civicrm/civicrm-core/pull/32661))**

  Fixes a bug with the uninstall routine on D7.

### Standalone Integration

- **Standalone: running core upgrade through web UI logs you out on completion
  ([dev/core#5594](https://lab.civicrm.org/dev/core/-/issues/5594):
  [32402](https://github.com/civicrm/civicrm-core/pull/32402))**

- **"Enable Multiple Languages" causes "Critical error"
  ([dev/core#5714](https://lab.civicrm.org/dev/core/-/issues/5714):
  [32525](https://github.com/civicrm/civicrm-core/pull/32525))**

- **Standalone: minor tweak to some strings
  ([32625](https://github.com/civicrm/civicrm-core/pull/32625))**

## <a name="misc"></a>Miscellany

- **update tcpdf 6.8.0...6.9.3
  ([32632](https://github.com/civicrm/civicrm-core/pull/32632))**

- **Ext - Move new upgrade functions to SchemaHelper
  ([32603](https://github.com/civicrm/civicrm-core/pull/32603))**

- **SchemaHelper - Tweak compatibility and docblocks
  ([32613](https://github.com/civicrm/civicrm-core/pull/32613))**

- **Add isQuickConfig function, in line with similar forms
  ([32478](https://github.com/civicrm/civicrm-core/pull/32478))**

- **Alter activity import prefixing to new agreed version
  ([32529](https://github.com/civicrm/civicrm-core/pull/32529))**

- **Simplify setting of money defaults on contribution form
  ([32475](https://github.com/civicrm/civicrm-core/pull/32475))**

- **Also Standardise Membership import field map names
  ([32530](https://github.com/civicrm/civicrm-core/pull/32530))**

- **Use getExistingLineItems to ... get existing line items
  ([32479](https://github.com/civicrm/civicrm-core/pull/32479))**

- **CustomGroup - Simplify getShortNameFromLongName
  ([32439](https://github.com/civicrm/civicrm-core/pull/32439))**

- **Standardise prefixing on Participant import
  ([32536](https://github.com/civicrm/civicrm-core/pull/32536))**

- **Clean up in fill code (Contact import) - baby step
  ([32497](https://github.com/civicrm/civicrm-core/pull/32497))**

- **Comment fix, remove pass-by-ref
  ([32481](https://github.com/civicrm/civicrm-core/pull/32481))**

- **Remove long-noisily deprecated if clause
  ([32503](https://github.com/civicrm/civicrm-core/pull/32503))**

- **Aria-label afform: Remove element label from radio option and add for to
  label ([32517](https://github.com/civicrm/civicrm-core/pull/32517))**

- **Remove create membershipPayment code - it's already created by lineitem
  ([32423](https://github.com/civicrm/civicrm-core/pull/32423))**

- **Stop using deprecated function to calculate already-calculated values
  ([32515](https://github.com/civicrm/civicrm-core/pull/32515))**

- **Regenerate civicrm_generated.mysql
  ([32465](https://github.com/civicrm/civicrm-core/pull/32465))**

- **Add peetcreative to colaborators
  ([32403](https://github.com/civicrm/civicrm-core/pull/32403))**

- **contributor-key.yml - Fix syntax error
  ([32685](https://github.com/civicrm/civicrm-core/pull/32685))**

- **Update contributor-key.yml
  ([32470](https://github.com/civicrm/civicrm-core/pull/32470))**

- **Update contributor-key.yml
  ([32555](https://github.com/civicrm/civicrm-core/pull/32555))**

- **Remove code from previously shared function
  ([32492](https://github.com/civicrm/civicrm-core/pull/32492))**

- **Remove legacy code that does nothing
  ([32495](https://github.com/civicrm/civicrm-core/pull/32495))**

- **release notes - Maintenance Mode is not Standalone specific
  ([32622](https://github.com/civicrm/civicrm-core/pull/32622))**

- **Remove boilerplate
  ([32520](https://github.com/civicrm/civicrm-core/pull/32520))**

- **Remove noisily deprecated function
  ([32482](https://github.com/civicrm/civicrm-core/pull/32482))**

- **Comment fix - remove experimental on well used code
  ([32354](https://github.com/civicrm/civicrm-core/pull/32354))**

- **CustomField - Refactor quickform addCustomDataFieldsToForm to fetch all
  fields consistently
  ([32463](https://github.com/civicrm/civicrm-core/pull/32463))**

- **[REF] Import - Add UserJobTrait
  ([32506](https://github.com/civicrm/civicrm-core/pull/32506))**

- **Refactor towards removing hex
  ([32538](https://github.com/civicrm/civicrm-core/pull/32538))**

- **[REF][PHP8.2] Declare properties CRM_Campaign_Selector_Search
  ([32459](https://github.com/civicrm/civicrm-core/pull/32459))**

- **[REF][PHP8.2] Replace undeclared property with local variable
  (CRM_Grant_Form_Grant)
  ([32458](https://github.com/civicrm/civicrm-core/pull/32458))**

- **[REF] Import function extractions
  ([32539](https://github.com/civicrm/civicrm-core/pull/32539))**

- **[REF] SearchKit - move static prop, use native function
  ([32535](https://github.com/civicrm/civicrm-core/pull/32535))**

- **[REF] Update to release version 1.14.5 for pear/log to fix implicit nullable
  deprecation in PHP8.4
  ([32249](https://github.com/civicrm/civicrm-core/pull/32249))**

- **[REF] Catch Exceptions caused by CRM_Utils_Array::single() if there is
  either no record found for potential permission reasons
  ([32338](https://github.com/civicrm/civicrm-core/pull/32338))**

- **[REF] CiviCase - Move component quasi-hook to real hook
  ([32570](https://github.com/civicrm/civicrm-core/pull/32570))**

- **[REF][PHP8.2] Declare property on CRM_PCP_Form_PCP
  ([32385](https://github.com/civicrm/civicrm-core/pull/32385))**

- **[NFC] riverlea - remove some double definitions
  ([32390](https://github.com/civicrm/civicrm-core/pull/32390))**

- **[NFC] Add Unit test of changing FT in quick config changes Line item FT as
  well ([32546](https://github.com/civicrm/civicrm-core/pull/32546))**

- **(NFC) IframeTest - Fix test-failure on wp
  ([32651](https://github.com/civicrm/civicrm-core/pull/32651))**

- **[NFC] 6.2 release notes first pass
  ([32626](https://github.com/civicrm/civicrm-core/pull/32626))**

- **(NFC) RadioWithDiv, GroupWithDiv - Fix header
  ([32375](https://github.com/civicrm/civicrm-core/pull/32375))**

- **(NFC) Fix typo in periodically
  ([32460](https://github.com/civicrm/civicrm-core/pull/32460))**

- **Extensions - Fix new error in cv's ExtensionLifecycleTest
  ([32417](https://github.com/civicrm/civicrm-core/pull/32417))**

- **Use apiv4 rather than apiv3 for some test helpers (order)
  ([32476](https://github.com/civicrm/civicrm-core/pull/32476))**

- **Add test cover for 6.1 regression, type error on invalid fields
  ([32620](https://github.com/civicrm/civicrm-core/pull/32620))**

- **additional dedupe finder test
  ([32314](https://github.com/civicrm/civicrm-core/pull/32314))**

- **Add additional test coverage for MembershipRenewal form
  ([32420](https://github.com/civicrm/civicrm-core/pull/32420))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin; Agileware - Justin Freeman; Artful Robot - Rich
Lott; Benjamin W; BrightMinded Ltd - Bradley Taylor; CiviCoop - Jaap Jansma;
CiviCRM - Coleman Watts, Tim Otten; Coop SymbioTIC - Mathieu Lutfy; Dave D;
Fuzion - Luke Stewart; Jens Schuppe; JMA Consulting - Monish Deb, Seamus Lee;
Lemniscus - Noah Miller; Megaphone Technology Consulting - Jon Goldberg; MJW
Consulting - Matthew Wire; Nicol Wistreich; OSSeed Technologies LLP - Vinay
Gawade; Progressive Technology Project - Jamie McClelland; Squiffle Consulting -
Aidan Saunders; TechSoup - Patryk Żukowicz; Wikimedia Foundation - Eileen
McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

All In Appli.com - Guillaume Sorel; anil-circle; Australian Greens - Andrew
Cormick-Dockery, John Twyman; Benjamin W; Buildkite - Angus Fretwell; Pooka &
Co - Marcus J Wilson; Sjoerd Langkemper; Third Sector Design - William Mortada
