# CiviCRM 6.3.0

Released June 4, 2025;

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **add date_sub for api v4
  ([32607](https://github.com/civicrm/civicrm-core/pull/32607))**

  Adds the ability to use "Date Subraction" and "Date Addition" in APIv4.

- **Allow JobLog date to be used as formbuilder filter
  ([32575](https://github.com/civicrm/civicrm-core/pull/32575))**

  Allows one to add a filter by "log date" in the scheduled Job Logs.

- **Enable custom data for IM & Open IDs
  ([32724](https://github.com/civicrm/civicrm-core/pull/32724) and
  [32734](https://github.com/civicrm/civicrm-core/pull/32734))**

  Enables custom data for IM & Open IDs.

- **Enable custom data for phones on contact summary
  ([32706](https://github.com/civicrm/civicrm-core/pull/32706))**

  Enables custom data for phones on contact summary.

- **SearchKit - Add batch data entry display for creating imports
  ([32541](https://github.com/civicrm/civicrm-core/pull/32541))**

  Adds a spreadsheet-like SearchDisplay for batch data entry which can then be
  imported.

- **SearchKitBatch - Switch to search_display_id column
  ([32799](https://github.com/civicrm/civicrm-core/pull/32799))**

  Improves the schema for batch search imports.

- **Afform: Confirmation message
  ([32383](https://github.com/civicrm/civicrm-core/pull/32383))**

  Adds the ability to configure a confirmation message which is displayed after
  the form is submitted.

- **Deprecate the l10n tar.gz
  ([infra/ops#1014](https://lab.civicrm.org/infra/ops/-/issues/1014):
  [32610](https://github.com/civicrm/civicrm-core/pull/32610))**

  Moves localized default settings into core.

- **Radio buttons in form builder
  ([dev/core#5818](https://lab.civicrm.org/dev/core/-/issues/5818):
  [32556](https://github.com/civicrm/civicrm-core/pull/32556))**

  Improves user experience of radio buttons in form builder.

- **ChartKit - Add description, set reserved display type
  ([32710](https://github.com/civicrm/civicrm-core/pull/32710))**

  Adds a description to the chart display.

- **Chartkit - support multiple dimension columns, add HeatMap chart type
  ([32583](https://github.com/civicrm/civicrm-core/pull/32583))**

  Updates buildDimension in the general chart renderer to support multiple
  dimension columns, and adds HeatMap chart type to use this functionality.

- **Add support to ISO8601 time formatting supported for imports
  ([32642](https://github.com/civicrm/civicrm-core/pull/32642))**

  Adds support to ISO8601 time formatting supported for imports.

- **Api4 - More efficient ACL clause handling
  ([32656](https://github.com/civicrm/civicrm-core/pull/32656))**

  Ensures deduping works for any combination of explicit and implicit joins.

- **CustomGroup - Allow `cg_extend_objects` to override hardcoded list of
  entities ([32605](https://github.com/civicrm/civicrm-core/pull/32605))**

  Improves configurability of custom field groups.

- **Installer - Tweak prose for "Sample Data" and "Users"
  ([32655](https://github.com/civicrm/civicrm-core/pull/32655))**

  Improves prose on the installer page.

### CiviContribute

- **Make PriceSetEntity entity_table work with searchkit/formbuilder
  ([32598](https://github.com/civicrm/civicrm-core/pull/32598))**

  Updates the metadata for Price Sets to match other Entities that implement the
  entity_table/entity_id dynamic foreign key.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Fatal Error trying to add a New Communication
  ([dev/core#5733](https://lab.civicrm.org/dev/core/-/issues/5733):
  [32865](https://github.com/civicrm/civicrm-core/pull/32865))**

- **Message Administration - Wrong sorting for User-Driven Messages
  ([dev/core#5796](https://lab.civicrm.org/dev/core/-/issues/5796):
  [32679](https://github.com/civicrm/civicrm-core/pull/32679))**

   Enables more sorting options on the User Driven Messages screen for sites
   using Message Administration.

- **Misleading System Status message when CIVICRM_MAIL_LOG_AND_SEND is set
  ([dev/core#5824](https://lab.civicrm.org/dev/core/-/issues/5824):
  [32566](https://github.com/civicrm/civicrm-core/pull/32566))**

- **CaseType api (v4) returns an empty definition
  ([dev/core#5830](https://lab.civicrm.org/dev/core/-/issues/5830):
  [32596](https://github.com/civicrm/civicrm-core/pull/32596) and
  [32592](https://github.com/civicrm/civicrm-core/pull/32592))**

- **EntityReference Custom field in export causes DB error : data too long
  ([dev/core#5831](https://lab.civicrm.org/dev/core/-/issues/5831):
  [32593](https://github.com/civicrm/civicrm-core/pull/32593))**

- **Import, trim spaces before putting into the import table, rather than on
  retrieval ([dev/core#5843](https://lab.civicrm.org/dev/core/-/issues/5843):
  [32722](https://github.com/civicrm/civicrm-core/pull/32722) and
  [32664](https://github.com/civicrm/civicrm-core/pull/32664))**

- **Web installer: remove the Sample Data option
  ([dev/core#5845](https://lab.civicrm.org/dev/core/-/issues/5845):
  [32627](https://github.com/civicrm/civicrm-core/pull/32627))**

- **Expired cache items only ever get handled if they're stored in the database
  ([dev/core#5853](https://lab.civicrm.org/dev/core/-/issues/5853):
  [32643](https://github.com/civicrm/civicrm-core/pull/32643))**

- **Tag Set Search Fields Disappearing from Contact Advanced Search Page
  ([dev/core#5866](https://lab.civicrm.org/dev/core/-/issues/5866):
  [32670](https://github.com/civicrm/civicrm-core/pull/32670))**

- **SK DB Entity not usable in new search
  ([dev/core#5867](https://lab.civicrm.org/dev/core/-/issues/5867):
  [32715](https://github.com/civicrm/civicrm-core/pull/32715))**

- **Dedupe rule generating error message, "DB Error: syntax error" when LENGTH
  is configured.
  ([dev/core#5876](https://lab.civicrm.org/dev/core/-/issues/5876):
  [32763](https://github.com/civicrm/civicrm-core/pull/32763))**

- **Riverlea - cant move or delete rich text elements in FormBuilder
  ([dev/core#5888](https://lab.civicrm.org/dev/core/-/issues/5888):
  [32787](https://github.com/civicrm/civicrm-core/pull/32787))**

- **Contact Communication Preferences not stored correctly after save
  ([dev/core#5902](https://lab.civicrm.org/dev/core/-/issues/5902):
  [32837](https://github.com/civicrm/civicrm-core/pull/32837))**

- **Riverlea 1.4.4: loading animation fix
  ([32673](https://github.com/civicrm/civicrm-core/pull/32673))**

- **RiverLea: fixes two code block regressions
  ([32730](https://github.com/civicrm/civicrm-core/pull/32730))**

- **RiverLea regression - Civi logo not centred when spinning
  ([32819](https://github.com/civicrm/civicrm-core/pull/32819))**

- **RiverLea: restored internal scrolling in FormBuilder for left & right
  panels, new variable
  ([32812](https://github.com/civicrm/civicrm-core/pull/32812))**

- **RiverLea: 1.4.5 – fixes FormBuilder DropDown delete colour clash + metadata
  ([32811](https://github.com/civicrm/civicrm-core/pull/32811))**

- **RiverLea: fixes two code block regressions
  ([32774](https://github.com/civicrm/civicrm-core/pull/32774))**

- **RiverLea UI Regression: Close icon on community message floats left not
  right ([32821](https://github.com/civicrm/civicrm-core/pull/32821))**

- **Riverlea theme: fix offscreen right column in contact summary
  ([32559](https://github.com/civicrm/civicrm-core/pull/32559))**

- **RiverLea 1.4.3: emphasis colours rework, changed & new variables
  ([32507](https://github.com/civicrm/civicrm-core/pull/32507))**

- **SearchKit - Fix wrong widget for aggregate fields in WHERE/HAVING
  ([32731](https://github.com/civicrm/civicrm-core/pull/32731))**

- **SearchKit - Hide non-viewable display types
  ([32713](https://github.com/civicrm/civicrm-core/pull/32713))**

- **SearchKit - Fix expanding links in toolbar
  ([32672](https://github.com/civicrm/civicrm-core/pull/32672))**

- **SK: Rewrite tokens in 'Link' metadata correctly
  ([32663](https://github.com/civicrm/civicrm-core/pull/32663))**

- **Afform Save as Draft does not save file uploads.
  ([dev/core#5762](https://lab.civicrm.org/dev/core/-/issues/5762):
  [32692](https://github.com/civicrm/civicrm-core/pull/32692))**

- **Afform - Fix viewing files
  ([32891](https://github.com/civicrm/civicrm-core/pull/32891))**

- **Afform - Fix setting default values
  ([32699](https://github.com/civicrm/civicrm-core/pull/32699))**

- **Afform - Refactor "DisplayOnly" fields to render client-side
  ([32683](https://github.com/civicrm/civicrm-core/pull/32683))**

- **ChartKit - fix priority of text color setting
  ([32586](https://github.com/civicrm/civicrm-core/pull/32586))**

- **ChartKit - Fix display in standalone mode
  ([32711](https://github.com/civicrm/civicrm-core/pull/32711))**

- **ChartKit - fix secondary grouping columns missing from legend text
  ([32635](https://github.com/civicrm/civicrm-core/pull/32635))**

- **ChartKit - names for renderlet listeners
  ([32587](https://github.com/civicrm/civicrm-core/pull/32587))**

  This a) prevents clashes between renderlets on the same hook, b) allows you to
  deregister certain renderlets by name if you want to customise the chart.

- **ChartKit - fallback if no format settings are set
  ([32588](https://github.com/civicrm/civicrm-core/pull/32588))**

  Prevents a console error if you hit Preview before selecting a chart type.

- **Deal with possibility of import_mappings not being configured
  ([32717](https://github.com/civicrm/civicrm-core/pull/32717) and
  [32775](https://github.com/civicrm/civicrm-core/pull/32775))**

- **Autocomplete - Fix broken scroll-loading
  ([32752](https://github.com/civicrm/civicrm-core/pull/32752))**

- **Schema - Fix getOptions to quote sql field names
  ([32712](https://github.com/civicrm/civicrm-core/pull/32712))**

- **Schema - Fix 2 typos: mis-capitalization of CheckBox
  ([32698](https://github.com/civicrm/civicrm-core/pull/32698))**

- **Add spaces between concatenated translated strings
  ([32695](https://github.com/civicrm/civicrm-core/pull/32695))**

- **Fix typo: Group
  ([32689](https://github.com/civicrm/civicrm-core/pull/32689))**

- **Fix typo in 'template'
  ([32697](https://github.com/civicrm/civicrm-core/pull/32697))**

- **Correctly output group label in basic criteria form
  ([32690](https://github.com/civicrm/civicrm-core/pull/32690))**

- **When merging tags the form field is added with the wrong number of params to
  add() ([32653](https://github.com/civicrm/civicrm-core/pull/32653))**

- **Merging tags update the name instead of the label
  ([32639](https://github.com/civicrm/civicrm-core/pull/32639))**

- **Files - Stop creating an EntityFile record for custom fields
  ([32319](https://github.com/civicrm/civicrm-core/pull/32319))**

- **Switch 'smtp' form to use metadata rather than legacy method
  ([32657](https://github.com/civicrm/civicrm-core/pull/32657))**

- **Allow using smarty5 syntax for join modifier in smarty4
  ([424](https://github.com/civicrm/civicrm-packages/pull/424))**

- **Handle smarty5 syntax for join/implode modifier so can support smarty2 at
  the same time without deprecations
  ([423](https://github.com/civicrm/civicrm-packages/pull/423))**

- **ensure api4 dedupe uses numeric phone
  ([32654](https://github.com/civicrm/civicrm-core/pull/32654))**

- **Tags - Fix tagging files
 ([32562](https://github.com/civicrm/civicrm-core/pull/32562))**

- **Fix failure to load defaults on import
  ([32792](https://github.com/civicrm/civicrm-core/pull/32792))**

- **CiviImport - Fix undefined indices
  ([32826](https://github.com/civicrm/civicrm-core/pull/32826))**

- **Fix typo: recipients
  ([32686](https://github.com/civicrm/civicrm-core/pull/32686))**

- **Fix typo
  ([32735](https://github.com/civicrm/civicrm-core/pull/32735))**

- **UserDashboard.tpl typo
  ([32646](https://github.com/civicrm/civicrm-core/pull/32646))**

- **Refix leak avoidance -now avoid notice too
  ([32732](https://github.com/civicrm/civicrm-core/pull/32732))**

- **Notice fix
  ([32621](https://github.com/civicrm/civicrm-core/pull/32621))**

- **Fix Custom import to use civiimport
  ([32540](https://github.com/civicrm/civicrm-core/pull/32540))**

### CiviContribute

- **Manage Contribution Page: fix search form layout, remove PCP button
  ([32647](https://github.com/civicrm/civicrm-core/pull/32647))**

- **Financial ACLs shouldn't restrict financial accounts by relationship type
  ([30643](https://github.com/civicrm/civicrm-core/pull/30643))**

- **Record fee amount financial transaction line items
  ([26804](https://github.com/civicrm/civicrm-core/pull/26804))**

  Ensures that a fee amount line item is generated when creating a payment.

### CiviMail

- **Add ORDER BY Clause to CRM_Mailing_BAO_MailingRecipients->mailingQuery()
  ([dev/core#5812](https://lab.civicrm.org/dev/core/-/issues/5812):
  [32516](https://github.com/civicrm/civicrm-core/pull/32516))**

### CiviMember

- **Offline Membership creation and renewal does not attach Invoice to emails
  ([32036](https://github.com/civicrm/civicrm-core/pull/32036))**

### Backdrop Integration

- **Fix PHP 8.2 deprecation in backdrop's mapConfigToSSL
  ([32680](https://github.com/civicrm/civicrm-core/pull/32680))**

### Drupal Integration

- **Add enctype to multipart/form-data if civicrm profile on user registration
  form have file field
  ([105](https://github.com/civicrm/civicrm-drupal-8/pull/105))**

  Form element missing enctype=multipart/form-data if drupal not using any file
  type field on user registration form.

### WordPress Integration

- **don't emit error on wordpress if using symlinked web dir
  ([32601](https://github.com/civicrm/civicrm-core/pull/32601))**

### Standalone Integration

- **Standalone - Fix broken passwords containing < or >
  ([32884](https://github.com/civicrm/civicrm-core/pull/32884))**

- **Standalone: error $(...).notify is not a function on login page
  ([dev/core#5887](https://lab.civicrm.org/dev/core/-/issues/5887):
  [32789](https://github.com/civicrm/civicrm-core/pull/32789))**

- **Standalone - avoid redirect loops in permissionDenied
  ([32614](https://github.com/civicrm/civicrm-core/pull/32614))**

- **Standalone - check logged in User's locale in multilingual mode
  ([32444](https://github.com/civicrm/civicrm-core/pull/32444))**

  Work Towards fixing multilingual mode for standalone sites.

## <a name="misc"></a>Miscellany

- **Progress towards clarifying form assignment
  ([32707](https://github.com/civicrm/civicrm-core/pull/32707))**

- **Migrate HookInterface references from class_alias
  ([32612](https://github.com/civicrm/civicrm-core/pull/32612))**

- **distmaker - Drop support for `starterkit.tgz`
  ([32640](https://github.com/civicrm/civicrm-core/pull/32640))**

- **phpstorm - Add autocomplete for permission names
  ([32666](https://github.com/civicrm/civicrm-core/pull/32666))**

- **Unhide legacydedupefinder so that it can be disabled
  ([32595](https://github.com/civicrm/civicrm-core/pull/32595))**

- **composer.lock - Update civicrm/composer-compile-plugin for php84
  ([32694](https://github.com/civicrm/civicrm-core/pull/32694))**

- **Pass info in modelProps
  ([32579](https://github.com/civicrm/civicrm-core/pull/32579))**

- **Php 8.4 support for IDS
  ([425](https://github.com/civicrm/civicrm-packages/pull/425))**

- **Make it easier to extract totals from LineItems client-side
  ([32574](https://github.com/civicrm/civicrm-core/pull/32574))**

- **Remove entity_field_prefix
  ([32558](https://github.com/civicrm/civicrm-core/pull/32558))**

- **Add type hints in Inline_Phone class
  ([32705](https://github.com/civicrm/civicrm-core/pull/32705))**

- **CiviImport - Remove non-functional code in import function
  ([32669](https://github.com/civicrm/civicrm-core/pull/32669))**

- **Remove always false variable from event cart extension
  ([32741](https://github.com/civicrm/civicrm-core/pull/32741))**

- **Consolidate a couple more places to use the traits to build location block
  forms ([32727](https://github.com/civicrm/civicrm-core/pull/32727))**

- **Standardise implementation of `civicrm/logout` route
  ([32615](https://github.com/civicrm/civicrm-core/pull/32615))**

- **Follow on code consolidations
  ([32726](https://github.com/civicrm/civicrm-core/pull/32726))**

- **Remove duplicate code
  ([32708](https://github.com/civicrm/civicrm-core/pull/32708))**

- **Remove function noisily deprecated 15 months ago
  ([32641](https://github.com/civicrm/civicrm-core/pull/32641))**

- **Remove noisily deprecated unreachable code
  ([32720](https://github.com/civicrm/civicrm-core/pull/32720))**

- **Remove more noisily deprecated unreachable code
  ([32723](https://github.com/civicrm/civicrm-core/pull/32723))**

- **Remove unreachable noisily deprecated code
  ([32719](https://github.com/civicrm/civicrm-core/pull/32719))**

- **Add some smarty variables to deprecated list
  ([32745](https://github.com/civicrm/civicrm-core/pull/32745))**

- **DAO - Remove unused debugging function
  ([32565](https://github.com/civicrm/civicrm-core/pull/32565))**

- **Remove deprecated function
  ([32725](https://github.com/civicrm/civicrm-core/pull/32725))**

- **[REF] CiviImport - Pass full values array to import function
  ([32662](https://github.com/civicrm/civicrm-core/pull/32662))**

- **[REF][PHP8.2] Move single and limit properties to parent class
  ([32307](https://github.com/civicrm/civicrm-core/pull/32307))**

- **[REF] Cleanup uses of deprecated CRM_Utils_Array::value
  ([32582](https://github.com/civicrm/civicrm-core/pull/32582))**

- **[REF] Chartkit minor code improvements
  ([32578](https://github.com/civicrm/civicrm-core/pull/32578))**

- **[REF] Fix GetMergeTo return if no delete activity causing a type error in
  Import ([32875](https://github.com/civicrm/civicrm-core/pull/32875))**

- **[NFC] testFileHash - incorrect order of dataprovider params
  ([32688](https://github.com/civicrm/civicrm-core/pull/32688))**

- **(NFC) Tweak gitignore and docs
  ([32678](https://github.com/civicrm/civicrm-core/pull/32678))**

- **[NFC] stricter linting for chart kit
  ([32576](https://github.com/civicrm/civicrm-core/pull/32576))**

- **(NFC) SchemaTrait - Flag as deprecated
  ([32597](https://github.com/civicrm/civicrm-core/pull/32597))**

- **Ensure domain address exists when testing domain tokens
  ([32716](https://github.com/civicrm/civicrm-core/pull/32716))**

- **[Test Only] Payment.create should create a trxn for the fee_amount
  ([32644](https://github.com/civicrm/civicrm-core/pull/32644))**

- **ClickTrackerTest - Switch from runkit7 to civi.mailing.track (for php84)
  ([32696](https://github.com/civicrm/civicrm-core/pull/32696))**

- **Update location form test to use wrapper
  ([32736](https://github.com/civicrm/civicrm-core/pull/32736))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin; Andy Burns; Artful Robot - Rich Lott; Benjamin W;
BrightMinded Ltd - Bradley Taylor; CiviCoop - Jaap Jansma; CiviCRM - Coleman
Watts, Tim Otten; Coop SymbioTIC - Mathieu Lutfy, Samuel Vanhove, Shane Bill;
Dave D; Erawat Chamanont; Freeform Solutions - Herb van den Dool; JMA
Consulting - Monish Deb, Seamus Lee; Megaphone Technology Consulting - Jon
Goldberg; MJW Consulting - Matthew Wire; Nicol Wistreich; Progressive Technology
Project - Jamie McClelland; Skvare - Sunil Pawar; Third Sector Design - Kurund
Jalmi; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Alice Frumin; Andy Clark; Blackfly Solutions - Alan Dixon;
Circle Interactive - Angela Jackson; CiviDesk - Nicolas Ganivet; CompuCorp -
Jamie Novick; Daniel Strum; New York State Senate - Nate Harris; Francesc
Bassas i Bullich; Jens Schuppe; Lemniscus - Noah Miller; Lighthouse
Consulting and Design - Brian Shaughnessy; Coop SymbioTIC - mmyriam;
Peter-Reck; Skvare - Mark Hanna; Squiffle Consulting - Aidan Saunders;
Systopia - Dominic Tubach; Tadpole Collective - Kevin Cristiano
