<?php

return [
  'name' => 'Product',
  'table' => 'civicrm_product',
  'class' => 'CRM_Contribute_DAO_Product',
  'getInfo' => fn() => [
    'title' => ts('Product'),
    'title_plural' => ts('Products'),
    'description' => ts('Stores "product info" for premiums and can be used for non-incentive products'),
    'log' => TRUE,
    'add' => '1.4',
    'label_field' => 'name',
  ],
  'getPaths' => fn() => [
    'add' => 'civicrm/admin/contribute/managePremiums/edit?action=add&reset=1',
    'update' => 'civicrm/admin/contribute/managePremiums/edit?action=update&id=[id]&reset=1',
    'delete' => 'civicrm/admin/contribute/managePremiums/edit?action=delete&id=[id]&reset=1',
    'preview' => 'civicrm/admin/contribute/managePremiums/edit?action=preview&reset=1&id=[id]',
    'browse' => 'civicrm/admin/contribute/managePremiums/',
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Product ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'add' => '1.4',
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'name' => [
      'title' => ts('Product Name'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'required' => TRUE,
      'localizable' => TRUE,
      'description' => ts('Required product/premium name'),
      'add' => '1.4',
      'unique_name' => 'product_name',
      'usage' => [
        'export',
      ],
    ],
    'description' => [
      'title' => ts('Description'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'localizable' => TRUE,
      'description' => ts('Optional description of the product/premium.'),
      'add' => '1.4',
    ],
    'sku' => [
      'title' => ts('SKU'),
      'sql_type' => 'varchar(50)',
      'input_type' => 'Text',
      'description' => ts('Optional product sku or code.'),
      'add' => '1.4',
      'usage' => [
        'export',
      ],
    ],
    'options' => [
      'title' => ts('Options'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'localizable' => TRUE,
      'description' => ts('Store comma-delimited list of color, size, etc. options for the product.'),
      'add' => '1.4',
      'serialize' => CRM_Core_DAO::SERIALIZE_COMMA_KEY_VALUE,
    ],
    'image' => [
      'title' => ts('Image'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Full or relative URL to uploaded image - fullsize.'),
      'add' => '1.4',
    ],
    'thumbnail' => [
      'title' => ts('Thumbnail'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Full or relative URL to image thumbnail.'),
      'add' => '1.4',
    ],
    'price' => [
      'title' => ts('Price'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => NULL,
      'description' => ts('Sell price or market value for premiums. For tax-deductible contributions, this will be stored as non_deductible_amount in the contribution record.'),
      'add' => '1.4',
    ],
    'currency' => [
      'title' => ts('Currency'),
      'sql_type' => 'varchar(3)',
      'input_type' => 'Select',
      'description' => ts('3 character string, value from config setting or input via user.'),
      'add' => '3.2',
      'default' => NULL,
      'input_attrs' => [
        'label' => ts('Currency'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_currency',
        'key_column' => 'name',
        'label_column' => 'full_name',
        'name_column' => 'name',
        'abbr_column' => 'symbol',
        'description_column' => 'IFNULL(CONCAT(name, " (", symbol, ")"), name)',
      ],
    ],
    'financial_type_id' => [
      'title' => ts('Financial Type ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('FK to Financial Type.'),
      'add' => '4.3',
      'default' => NULL,
      'input_attrs' => [
        'label' => ts('Financial Type'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_financial_type',
        'key_column' => 'id',
        'label_column' => 'label',
      ],
      'entity_reference' => [
        'entity' => 'FinancialType',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'min_contribution' => [
      'title' => ts('Minimum Contribution'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => NULL,
      'description' => ts('Minimum contribution required to be eligible to select this premium.'),
      'add' => '1.4',
    ],
    'cost' => [
      'title' => ts('Cost'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => NULL,
      'description' => ts('Actual cost of this product. Useful to determine net return from sale or using this as an incentive.'),
      'add' => '1.4',
    ],
    'is_active' => [
      'title' => ts('Is Active'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Disabling premium removes it from the premiums_premium join table below.'),
      'add' => '1.4',
      'default' => TRUE,
      'input_attrs' => [
        'label' => ts('Enabled'),
      ],
    ],
    'period_type' => [
      'title' => ts('Period Type'),
      'sql_type' => 'varchar(8)',
      'input_type' => 'Select',
      'description' => ts('Rolling means we set start/end based on current day, fixed means we set start/end for current year or month (e.g. 1 year + fixed -> we would set start/end for 1/1/06 thru 12/31/06 for any premium chosen in 2006)'),
      'add' => '1.4',
      'default' => 'rolling',
      'pseudoconstant' => [
        'callback' => ['CRM_Core_SelectValues', 'periodType'],
      ],
    ],
    'fixed_period_start_day' => [
      'title' => ts('Fixed Period Start Day'),
      'sql_type' => 'int',
      'input_type' => 'Number',
      'description' => ts('Month and day (MMDD) that fixed period type subscription or membership starts.'),
      'add' => '1.4',
      'default' => 101,
    ],
    'duration_unit' => [
      'title' => ts('Duration Unit'),
      'sql_type' => 'varchar(8)',
      'input_type' => 'Select',
      'add' => '1.4',
      'default' => 'year',
      'pseudoconstant' => [
        'callback' => ['CRM_Core_SelectValues', 'getPremiumUnits'],
      ],
    ],
    'duration_interval' => [
      'title' => ts('Duration Interval'),
      'sql_type' => 'int',
      'input_type' => 'Number',
      'description' => ts('Number of units for total duration of subscription, service, membership (e.g. 12 Months).'),
      'add' => '1.4',
    ],
    'frequency_unit' => [
      'title' => ts('Frequency Unit'),
      'sql_type' => 'varchar(8)',
      'input_type' => 'Select',
      'description' => ts('Frequency unit and interval allow option to store actual delivery frequency for a subscription or service.'),
      'add' => '1.4',
      'default' => 'month',
      'pseudoconstant' => [
        'callback' => ['CRM_Core_SelectValues', 'getPremiumUnits'],
      ],
    ],
    'frequency_interval' => [
      'title' => ts('Frequency Interval'),
      'sql_type' => 'int',
      'input_type' => 'Number',
      'description' => ts('Number of units for delivery frequency of subscription, service, membership (e.g. every 3 Months).'),
      'add' => '1.4',
    ],
  ],
];
