<?php

return [
  'name' => 'Menu',
  'table' => 'civicrm_menu',
  'class' => 'CRM_Core_DAO_Menu',
  'getInfo' => fn() => [
    'title' => ts('Menu'),
    'title_plural' => ts('Menus'),
    'description' => ts('Table to store menu items for all civicrm components.'),
    'add' => '1.1',
    'label_field' => 'title',
  ],
  'getIndices' => fn() => [
    'UI_path_domain_id' => [
      'fields' => [
        'path' => TRUE,
        'domain_id' => TRUE,
      ],
      'unique' => TRUE,
      'add' => '2.1',
    ],
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Menu ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'add' => '2.1',
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'domain_id' => [
      'title' => ts('Domain ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'required' => TRUE,
      'description' => ts('Which Domain is this menu item for'),
      'add' => '3.0',
      'input_attrs' => [
        'label' => ts('Domain'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_domain',
        'key_column' => 'id',
        'label_column' => 'name',
      ],
      'entity_reference' => [
        'entity' => 'Domain',
        'key' => 'id',
      ],
    ],
    'path' => [
      'title' => ts('Path'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Path Name'),
      'add' => '2.1',
    ],
    'path_arguments' => [
      'title' => ts('Arguments'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'description' => ts('Arguments to pass to the url'),
      'add' => '2.1',
    ],
    'title' => [
      'title' => ts('Menu Title'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'add' => '2.1',
    ],
    'access_callback' => [
      'title' => ts('Access Callback'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Function to call to check access permissions'),
      'add' => '2.1',
    ],
    'access_arguments' => [
      'title' => ts('Access Arguments'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'description' => ts('Arguments to pass to access callback'),
      'add' => '2.1',
    ],
    'page_callback' => [
      'title' => ts('Page Callback'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('function to call for this url'),
      'add' => '2.1',
    ],
    'page_arguments' => [
      'title' => ts('Page Arguments'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'description' => ts('Arguments to pass to page callback'),
      'add' => '2.1',
    ],
    'breadcrumb' => [
      'title' => ts('Breadcrumb'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'description' => ts('Breadcrumb for the path.'),
      'add' => '2.1',
    ],
    'return_url' => [
      'title' => ts('Return Url'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Url where a page should redirected to, if next url not known.'),
      'add' => '2.1',
      'input_attrs' => [
        'label' => ts('Return URL'),
      ],
    ],
    'return_url_args' => [
      'title' => ts('Return Url Args'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Arguments to pass to return_url'),
      'add' => '2.1',
      'input_attrs' => [
        'label' => ts('Return URL Arguments'),
      ],
    ],
    'component_id' => [
      'title' => ts('Component ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('Component that this menu item belongs to'),
      'add' => '2.1',
      'input_attrs' => [
        'label' => ts('Component'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_component',
        'key_column' => 'id',
        'label_column' => 'name',
      ],
      'entity_reference' => [
        'entity' => 'Component',
        'key' => 'id',
      ],
    ],
    'is_active' => [
      'title' => ts('Enabled?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this menu item active?'),
      'add' => '2.1',
      'default' => TRUE,
      'input_attrs' => [
        'label' => ts('Enabled'),
      ],
    ],
    'is_public' => [
      'title' => ts('Public?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this menu accessible to the public?'),
      'add' => '2.1',
      'default' => FALSE,
    ],
    'is_exposed' => [
      'title' => ts('Exposed?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this menu exposed to the navigation system?'),
      'add' => '2.1',
      'default' => TRUE,
    ],
    'is_ssl' => [
      'title' => ts('Use SSL?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Should this menu be exposed via SSL if enabled?'),
      'add' => '2.1',
      'default' => TRUE,
    ],
    'weight' => [
      'title' => ts('Order'),
      'sql_type' => 'int',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Ordering of the menu items in various blocks.'),
      'add' => '2.1',
      'default' => 1,
    ],
    'type' => [
      'title' => ts('Type'),
      'sql_type' => 'int',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Drupal menu type.'),
      'add' => '2.1',
      'default' => 1,
    ],
    'page_type' => [
      'title' => ts('Page Type'),
      'sql_type' => 'int',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('CiviCRM menu type.'),
      'add' => '2.1',
      'default' => 1,
    ],
    'skipBreadcrumb' => [
      'title' => ts('Hide Breadcrumb?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('skip this url being exposed to breadcrumb'),
      'add' => '2.2',
      'default' => FALSE,
    ],
    'module_data' => [
      'title' => ts('Other menu data'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'description' => ts('All other menu metadata not stored in other fields'),
      'add' => '4.7',
    ],
  ],
];
