<?php

return [
  'name' => 'MessageTemplate',
  'table' => 'civicrm_msg_template',
  'class' => 'CRM_Core_DAO_MessageTemplate',
  'getInfo' => fn() => [
    'title' => ts('Message Template'),
    'title_plural' => ts('Message Templates'),
    'description' => ts('Users will need a way to save and retrieve templates with tokens for use in recurring email communication tasks'),
    'add' => '1.6',
    'icon' => 'fa-newspaper-o',
    'label_field' => 'msg_title',
  ],
  'getPaths' => fn() => [
    'add' => 'civicrm/admin/messageTemplates/add?action=add&reset=1',
    'view' => 'civicrm/admin/messageTemplates/add?action=view&id=[id]&reset=1',
    'update' => 'civicrm/admin/messageTemplates/add?action=update&id=[id]&reset=1',
    'delete' => 'civicrm/admin/messageTemplates?action=delete&id=[id]&reset=1',
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Message Template ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Message Template ID'),
      'add' => '1.6',
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'msg_title' => [
      'title' => ts('Message Template Title'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Descriptive title of message'),
      'add' => '1.6',
    ],
    'msg_subject' => [
      'title' => ts('Message Template Subject'),
      'sql_type' => 'text',
      'input_type' => 'Text',
      'description' => ts('Subject for email message.'),
      'add' => '1.6',
    ],
    'msg_text' => [
      'title' => ts('Message Template Text'),
      'sql_type' => 'longtext',
      'input_type' => 'TextArea',
      'description' => ts('Text formatted message'),
      'add' => '1.6',
      'input_attrs' => [
        'rows' => 10,
        'cols' => 75,
      ],
    ],
    'msg_html' => [
      'title' => ts('Message Template HTML'),
      'sql_type' => 'longtext',
      'input_type' => 'RichTextEditor',
      'description' => ts('HTML formatted message'),
      'add' => '1.6',
      'input_attrs' => [
        'rows' => 10,
        'cols' => 75,
      ],
    ],
    'is_active' => [
      'title' => ts('Is Active'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'add' => '1.6',
      'default' => TRUE,
      'input_attrs' => [
        'label' => ts('Enabled'),
      ],
    ],
    'workflow_id' => [
      'title' => ts('Deprecated field for Message Template Workflow.'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('a pseudo-FK to civicrm_option_value'),
      'add' => '3.1',
    ],
    'workflow_name' => [
      'title' => ts('Message Template Workflow Name'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'add' => '5.26',
    ],
    'is_default' => [
      'title' => ts('Message Template Is Default?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('is this the default message template for the workflow referenced by workflow_id?'),
      'add' => '3.1',
      'default' => TRUE,
      'input_attrs' => [
        'label' => ts('Default'),
      ],
    ],
    'is_reserved' => [
      'title' => ts('Message Template Is Reserved?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('is this the reserved message template which we ship for the workflow referenced by workflow_id?'),
      'add' => '3.1',
      'default' => FALSE,
    ],
    'is_sms' => [
      'title' => ts('Message Template is used for SMS?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this message template used for sms?'),
      'add' => '4.5',
      'default' => FALSE,
    ],
    'pdf_format_id' => [
      'title' => ts('Message Template Format'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('a pseudo-FK to civicrm_option_value containing PDF Page Format.'),
      'add' => '3.4',
      'pseudoconstant' => [
        'option_group_name' => 'pdf_format',
        'key_column' => 'id',
      ],
    ],
  ],
];
