<?php

return [
  'name' => 'FinancialAccount',
  'table' => 'civicrm_financial_account',
  'class' => 'CRM_Financial_DAO_FinancialAccount',
  'getInfo' => fn() => [
    'title' => ts('Financial Account'),
    'title_plural' => ts('Financial Accounts'),
    'description' => ts('Financial Accounts'),
    'log' => TRUE,
    'add' => '3.2',
    'label_field' => 'label',
  ],
  'getPaths' => fn() => [
    'add' => 'civicrm/admin/financial/financialAccount/edit?action=add&reset=1',
    'update' => 'civicrm/admin/financial/financialAccount/edit?action=update&id=[id]&reset=1',
    'delete' => 'civicrm/admin/financial/financialAccount/edit?action=delete&id=[id]&reset=1',
    'browse' => 'civicrm/admin/financial/financialAccount',
  ],
  'getIndices' => fn() => [
    'UI_name' => [
      'fields' => [
        'name' => TRUE,
      ],
      'unique' => TRUE,
      'add' => '4.3',
    ],
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Financial Account ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('ID'),
      'add' => '3.2',
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'name' => [
      'title' => ts('Financial Account Name'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'required' => TRUE,
      'default_fallback' => ['label'],
      'description' => ts('Financial Account Name.'),
      'add' => '3.2',
    ],
    'label' => [
      'title' => ts('Financial Account Label'),
      'sql_type' => 'varchar(64)',
      'input_type' => 'Text',
      'description' => ts('User-facing financial account label'),
      'required' => TRUE,
      'default_fallback' => ['name'],
      'localizable' => TRUE,
      'add' => '5.79',
      'input_attrs' => [
        'label' => ts('Financial Account'),
      ],
    ],
    'contact_id' => [
      'title' => ts('Contact ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('FK to Contact ID that is responsible for the funds in this account'),
      'add' => '4.3',
      'unique_name' => 'financial_account_contact_id',
      'input_attrs' => [
        'label' => ts('Contact'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'financial_account_type_id' => [
      'title' => ts('Financial Account Type'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'required' => TRUE,
      'description' => ts('pseudo FK into civicrm_option_value.'),
      'add' => '4.3',
      'default' => 3,
      'pseudoconstant' => [
        'option_group_name' => 'financial_account_type',
      ],
    ],
    'accounting_code' => [
      'title' => ts('Accounting Code'),
      'sql_type' => 'varchar(64)',
      'input_type' => 'Text',
      'description' => ts('Optional value for mapping monies owed and received to accounting system codes.'),
      'add' => '4.3',
      'usage' => [
        'export',
      ],
    ],
    'account_type_code' => [
      'title' => ts('Account Type Code'),
      'sql_type' => 'varchar(64)',
      'input_type' => 'Text',
      'description' => ts('Optional value for mapping account types to accounting system account categories (QuickBooks Account Type Codes for example).'),
      'add' => '4.3',
      'usage' => [
        'export',
      ],
    ],
    'description' => [
      'title' => ts('Financial Account Description'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Financial Type Description.'),
      'add' => '4.3',
    ],
    'parent_id' => [
      'title' => ts('Parent ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('Parent ID in account hierarchy'),
      'add' => '4.3',
      'input_attrs' => [
        'label' => ts('Parent'),
      ],
      'entity_reference' => [
        'entity' => 'FinancialAccount',
        'key' => 'id',
      ],
    ],
    'is_header_account' => [
      'title' => ts('Header Financial Account?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this a header account which does not allow transactions to be posted against it directly, but only to its sub-accounts?'),
      'add' => '4.3',
      'default' => FALSE,
    ],
    'is_deductible' => [
      'title' => ts('Deductible Financial Account?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this account tax-deductible?'),
      'add' => '4.3',
      'default' => FALSE,
    ],
    'is_tax' => [
      'title' => ts('Tax Financial Account?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this account for taxes?'),
      'add' => '4.3',
      'default' => FALSE,
    ],
    'tax_rate' => [
      'title' => ts('Financial Account Tax Rate'),
      'sql_type' => 'decimal(10,8)',
      'input_type' => NULL,
      'description' => ts('The percentage of the total_amount that is due for this tax.'),
      'add' => '4.3',
    ],
    'is_reserved' => [
      'title' => ts('Reserved Financial Account?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this a predefined system object?'),
      'add' => '4.3',
      'default' => FALSE,
    ],
    'is_active' => [
      'title' => ts('Financial Account is Active'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this property active?'),
      'add' => '4.3',
      'default' => TRUE,
      'input_attrs' => [
        'label' => ts('Enabled'),
      ],
    ],
    'is_default' => [
      'title' => ts('Default Financial Account'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this account the default one (or default tax one) for its financial_account_type?'),
      'add' => '4.3',
      'default' => FALSE,
      'input_attrs' => [
        'label' => ts('Default'),
      ],
    ],
  ],
];
